(function(t,e,i,s,n,o){"use strict";
/**
	 * Bitrix UI
	 * Social Video Vue component
	 *
	 * @package bitrix
	 * @subpackage ui
	 * @copyright 2001-2021 Bitrix
	 */var a=Object.freeze({play:"play",pause:"pause",stop:"stop",none:"none"});n.BitrixVue.component("bx-socialvideo",{props:{id:{default:0},src:{default:""},preview:{default:""},autoplay:{default:true},containerClass:{default:null},containerStyle:{default:null},elementStyle:{default:null},showControls:{default:true}},data:function t(){return{preload:"none",previewLoaded:false,loaded:false,loading:false,playAfterLoad:false,enterFullscreen:false,playBeforeMute:2,state:a.none,progress:0,timeCurrent:0,timeTotal:0,muteFlag:true}},created:function t(){if(!this.preview){this.previewLoaded=true;this.preload="metadata"}this.$Bitrix.eventEmitter.subscribe("ui:socialvideo:unmute",this.onUnmute)},mounted:function t(){this.getObserver().observe(this.$refs.body)},beforeDestroy:function t(){this.$Bitrix.eventEmitter.unsubscribe("ui:socialvideo:unmute",this.onUnmute);this.getObserver().unobserve(this.$refs.body)},watch:{id:function t(e){this.registeredId=e}},methods:{loadFile:function t(){var e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:false;if(this.loaded){return true}if(this.loading){return true}this.preload="auto";this.loading=true;this.playAfterLoad=e;return true},clickToButton:function t(e){if(!this.src){return false}if(this.state===a.play){this.getObserver().unobserve(this.$refs.body);this.pause()}else{this.play()}e.stopPropagation()},clickToMute:function t(){if(!this.src){return false}if(!this.muteFlag){this.mute()}else{this.unmute()}event.stopPropagation()},click:function t(e){if(this.autoPlayDisabled){this.play();e.stopPropagation();return false}if(this.isMobile){if(this.source().webkitEnterFullscreen){this.unmute();this.enterFullscreen=true;this.source().webkitEnterFullscreen()}else if(this.source().requestFullscreen){this.unmute();this.enterFullscreen=true;this.source().requestFullscreen()}else{this.$emit("click",e)}}else{this.$emit("click",e)}e.stopPropagation()},play:function t(e){if(!this.loaded){this.loadFile(true);return false}if(!this.source()){return false}this.source().play()},pause:function t(){if(!this.source()){return false}this.playAfterLoad=false;this.source().pause()},stop:function t(){if(!this.source()){return false}this.state=a.stop;this.source().pause()},mute:function t(){if(!this.source()){return false}this.muteFlag=true;this.playBeforeMute=2;this.source().muted=true},unmute:function t(){if(!this.source()){return false}this.muteFlag=false;this.source().muted=false;if(this.id>0){this.$Bitrix.eventEmitter.emit("ui:socialvideo:unmute",{initiator:this.id})}},setProgress:function t(e){this.progress=e},formatTime:function t(e){e=Math.floor(e);var i=Math.floor(e/60/60);if(i>0){e-=i*60*60}var s=Math.floor(e/60);if(s>0){e-=s*60}return(i>0?i+":":"")+(i>0?s.toString().padStart(2,"0")+":":s+":")+e.toString().padStart(2,"0")},onUnmute:function t(e){e=e.getData();if(e.initiator===this.id){return false}this.mute()},source:function t(){return this.$refs.source},videoEventRouter:function t(e,i){if(e==="durationchange"||e==="loadeddata"){if(!this.source()){return false}this.timeTotal=this.source().duration}else if(e==="loadedmetadata"){if(!this.source()){return false}this.timeTotal=this.source().duration;this.loaded=true;if(this.playAfterLoad){this.play()}}else if(e==="abort"||e==="error"){console.error("BxSocialVideo: load failed",this.id,i);this.loading=false;this.state=a.none;this.timeTotal=0;this.preload="none"}else if(e==="canplaythrough"){this.loading=false;this.loaded=true;if(this.playAfterLoad){this.play()}}else if(e==="volumechange"){if(!this.source()){return false}if(this.source().muted){this.mute()}else{this.unmute()}}else if(e==="timeupdate"){if(!this.source()){return false}this.timeCurrent=this.source().currentTime;if(!this.muteFlag&&!this.enterFullscreen&&this.timeCurrent===0){if(this.playBeforeMute<=0){this.mute()}this.playBeforeMute-=1}this.setProgress(Math.round(100/this.timeTotal*this.timeCurrent))}else if(e==="pause"){if(this.state!==a.stop){this.state=a.pause}if(this.enterFullscreen){this.enterFullscreen=false;this.mute();this.play()}}else if(e==="play"){this.state=a.play;if(this.state===a.stop){this.progress=0;this.timeCurrent=0}if(this.enterFullscreen){this.enterFullscreen=false}}},getObserver:function t(){var e=this;if(this.observer){return this.observer}this.observer=new IntersectionObserver((function(t,i){if(e.autoPlayDisabled){return false}t.forEach((function(t){if(t.isIntersecting){e.play()}else{e.pause()}}))}),{threshold:[0,1]});return this.observer},lazyLoadCallback:function t(e){this.previewLoaded=e.state==="success"}},computed:{State:function t(){return a},autoPlayDisabled:function t(){return!this.autoplay&&this.state===a.none},showStartButton:function t(){return this.autoPlayDisabled&&this.previewLoaded},showInterface:function t(){return this.previewLoaded&&!this.showStartButton},labelTime:function t(){if(!this.loaded&&!this.timeTotal){return"--:--"}var e;if(this.state===a.play){e=this.timeTotal-this.timeCurrent}else{e=this.timeTotal}return this.formatTime(e)},isMobile:function t(){var e=navigator.userAgent.toLowerCase();return e.includes("android")||e.includes("iphone")||e.includes("ipad")||e.includes("bitrixmobile")}},template:'\n\t\t<div :class="[\'ui-vue-socialvideo\', containerClass, {\n\t\t\t\t\'ui-vue-socialvideo-mobile\': isMobile,\n\t\t\t}]" :style="containerStyle" @click="click">\n\t\t\t<transition name="ui-vue-socialvideo-animation-fade">\n\t\t\t\t<div v-if="showStartButton && showControls" class="ui-vue-socialvideo-button-start">\n\t\t\t\t\t<span class="ui-vue-socialvideo-button-start-icon"></span>\n\t\t\t\t</div>\n\t\t\t</transition>\n\t\t\t<transition name="ui-vue-socialvideo-animation-fade">\n\t\t\t\t<div v-if="showInterface && showControls" class="ui-vue-socialvideo-overlay-container">\n\t\t\t\t\t<div class="ui-vue-socialvideo-controls-container" @click="clickToButton">\n\t\t\t\t\t\t<button :class="[\'ui-vue-socialvideo-control\', {\n\t\t\t\t\t\t\t\'ui-vue-socialvideo-control-loader\': loading,\n\t\t\t\t\t\t\t\'ui-vue-socialvideo-control-play\': !loading && state !== State.play,\n\t\t\t\t\t\t\t\'ui-vue-socialvideo-control-pause\': !loading && state === State.play,\n\t\t\t\t\t\t}]"></button>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class="ui-vue-socialvideo-info-container" @click="clickToMute">\n\t\t\t\t\t\t<span class="ui-vue-socialvideo-time-current">{{labelTime}}</span>\n\t\t\t\t\t\t<span :class="[\'ui-vue-socialvideo-sound\', {\n\t\t\t\t\t\t\t\'ui-vue-socialvideo-sound-on\': state !== State.none && !muteFlag,\n\t\t\t\t\t\t\t\'ui-vue-socialvideo-sound-off\': state !== State.none && muteFlag\n\t\t\t\t\t\t}]"></span>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</transition>\n\t\t\t<div v-if="!preview" class="ui-vue-socialvideo-background" :style="{position: (src? \'absolute\': \'relative\')}"></div>\n\t\t\t<div class="ui-vue-socialvideo-container" ref="body">\n\t\t\t\t<img \n\t\t\t\t\tv-bx-lazyload="{callback: lazyLoadCallback}"\n\t\t\t\t\tdata-lazyload-dont-hide\n\t\t\t\t\tv-if="preview"\n\t\t\t\t\tclass="ui-vue-socialvideo-image-source"\n\t\t\t\t\t:data-lazyload-src="preview"\n\t\t\t\t\t:style="{position: (src? \'absolute\': \'relative\'), ...elementStyle}"\n\t\t\t\t/>\n\t\t\t\t<video \n\t\t\t\t\tv-if="src" :src="src" \n\t\t\t\t\tclass="ui-vue-socialvideo-source" \n\t\t\t\t\tref="source"\n\t\t\t\t\t:preload="preload" \n\t\t\t\t\tplaysinline\n\t\t\t\t\tloop \n\t\t\t\t\tmuted\n\t\t\t\t\t:style="{opacity: (loaded? 1: 0), ...elementStyle}"\n\t\t\t\t\t@abort="videoEventRouter(\'abort\', $event)"\n\t\t\t\t\t@error="videoEventRouter(\'error\', $event)"\n\t\t\t\t\t@suspend="videoEventRouter(\'suspend\', $event)"\n\t\t\t\t\t@canplay="videoEventRouter(\'canplay\', $event)"\n\t\t\t\t\t@canplaythrough="videoEventRouter(\'canplaythrough\', $event)"\n\t\t\t\t\t@durationchange="videoEventRouter(\'durationchange\', $event)"\n\t\t\t\t\t@loadeddata="videoEventRouter(\'loadeddata\', $event)"\n\t\t\t\t\t@loadedmetadata="videoEventRouter(\'loadedmetadata\', $event)"\n\t\t\t\t\t@volumechange="videoEventRouter(\'volumechange\', $event)"\n\t\t\t\t\t@timeupdate="videoEventRouter(\'timeupdate\', $event)"\n\t\t\t\t\t@play="videoEventRouter(\'play\', $event)"\n\t\t\t\t\t@playing="videoEventRouter(\'playing\', $event)"\n\t\t\t\t\t@pause="videoEventRouter(\'pause\', $event)"\n\t\t\t\t></video>\n\t\t\t</div>\n\t\t</div>\t\n\t'})})(this.window=this.window||{},BX,window,BX,BX,BX.Event);
//# sourceMappingURL=socialvideo.bundle.map.js