(function(){"use strict";BX.namespace("BX.UI.Viewer");BX.UI.Viewer.Controller=function(e){this.items=null;this.currentIndex=null;this.handlers={handleCarouselItemError:this.handleCarouselItemError.bind(this)};this.baseContainer=e.baseContainer||document.body;this.setItems(e.items||[]);this.isBodyPaddingAdded=null;this.cycleMode=e.hasOwnProperty("cycleMode")?e.cycleMode:true;this.stretch=e.hasOwnProperty("stretch")?e.stretch:false;this.cachedData={};this.optionsByGroup={};this.layout={container:null,content:null,inner:null,title:null,itemContainer:null,next:null,prev:null,close:null,downloadBtn:null,moreBtn:null,error:null,loader:null,loaderContainer:null,loaderText:null,defaultActions:null,extraActions:null,carouselItems:null,carouselContainer:null,carouselScrollable:null};this.actionPanel={getItemById:()=>{}};this.maxParallelLoads=3;this.loadingItems=new Set;this.moreMenu=null;this.eventsAlreadyBinded=false;this.init()};BX.UI.Viewer.Controller.prototype={buildItemListByNode:function(e){var t=new BX.Promise;var i=[];if(this.isSeparateItem(e)){i=[e]}else if(e.dataset.viewerGroupBy){i=[].slice.call(e.ownerDocument.querySelectorAll("[data-viewer][data-viewer-group-by='"+e.dataset.viewerGroupBy+"']"))}else{i=[e]}this.loadExtensions(this.collectExtensionsForItems(i)).then(function(){var e=i.map((function(e){return BX.UI.Viewer.buildItemByNode(e)}));t.fulfill(e)}.bind(this));return t},isSeparateItem:function(e){return e.dataset.viewerSeparateItem},shouldProcessSeparateMode:function(e){return e.length===1&&e[0].isSeparateItem()},shouldRunViewer:function(e){if(!BX.type.isDomNode(e)||!e.dataset){return false}if(!e.dataset.hasOwnProperty("viewer")){return false}return true},collectExtensionsForItems:function(e){var t=new Set;e.forEach((function(e){if(BX.type.isString(e.dataset.viewerExtension)){t.add(e.dataset.viewerExtension)}}));var i=[];t.forEach((function(e){if(shouldLoadExtensions(e)){i.push(e)}}));return i},extractTargetFromEvent:function(e){var t=BX.getEventTarget(e);var i=false;var n=8;do{if(this.shouldRunViewer(t)){i=true;break}t=t.parentNode;n--}while(n>0&&t);return i?t:null},handleDocumentClick:function(e){var t=this.extractTargetFromEvent(e);if(!t){return}if(t.tagName!=="A"&&t.closest('a[target="_blank"]')){return false}e.preventDefault();this.buildItemListByNode(t).then(function(i){if(i.length===0){return}if(this.shouldProcessSeparateMode(i)){this.setItems(i).then(function(){this.openSeparate(0)}.bind(this));return}if(BX.browser.IsMac()&&e.metaKey||e.ctrlKey){this.runActionByNode(t,"download")}else{this.setItems(i).then(function(){this.open(this.getIndexByNode(t))}.bind(this))}}.bind(this))},bindEvents:function(){if(this.eventsAlreadyBinded){return}this.eventsAlreadyBinded=true;this.handlers.keyPress=this.handleKeyPress.bind(this);this.handlers.touchStart=this.handleTouchStart.bind(this);this.handlers.touchEnd=this.handleTouchEnd.bind(this);this.handlers.resize=this.handleWindowResize.bind(this);this.handlers.showNext=this.showNext.bind(this);this.handlers.showPrev=this.showPrev.bind(this);this.handlers.close=this.close.bind(this);this.handlers.handleClickOnItemContainer=this.handleClickOnItemContainer.bind(this);this.handlers.handleSliderCloseByEsc=this.handleSliderCloseByEsc.bind(this);BX.bind(document,"keydown",this.handlers.keyPress);BX.bind(window,"resize",this.handlers.resize);BX.bind(this.getItemContainer(),"touchstart",this.handlers.touchStart);BX.bind(this.getItemContainer(),"touchend",this.handlers.touchEnd);BX.bind(this.getItemContainer(),"click",this.handlers.handleClickOnItemContainer);BX.bind(this.getNextButton(),"click",this.handlers.showNext);BX.bind(this.getPrevButton(),"click",this.handlers.showPrev);BX.bind(this.getCloseButton(),"click",this.handlers.close);BX.addCustomEvent("SidePanel.Slider:onCloseByEsc",this.handlers.handleSliderCloseByEsc)},handleVisibleControls:function(e){if(BX.browser.IsMobile()||BX.hasClass(document.documentElement,"bx-touch")){return}if(this._timerIdReadingMode){clearTimeout(this._timerIdReadingMode)}if(!this.cursorInPerimeter(e)||BX.findParent(e.target,{className:"ui-viewer-next"})||BX.findParent(e.target,{className:"ui-viewer-prev"})){this.disableReadingMode()}else{this._timerIdReadingMode=setTimeout(function(){this.enableReadingMode()}.bind(this),2800)}},handleMoreBtnClick(){if(this.moreMenu===null){const e=this.getCurrentItem();const t=[...e.getMoreMenuItems(),...this.createMoreMenuItems(e)];if(t.length===0){return}this.moreMenu=new BX.Main.Menu({angle:true,minWidth:150,bindElement:this.getMoreButton(),offsetLeft:30,offsetTop:-20,items:t,cacheable:false,events:{onDestroy:()=>{this.moreMenu=null}}})}this.moreMenu.show()},enableReadingMode:function(e){if(BX.browser.IsMobile()||!this.isOnTop()){return}if(e){this._timerIdReadingMode=setTimeout(function(){this.layout.container.classList.add("ui-viewer-reading-mode")}.bind(this),5e3);return}this.layout.container.classList.add("ui-viewer-reading-mode")},disableReadingMode:function(){if(this._timerIdReadingMode){clearTimeout(this._timerIdReadingMode)}this.layout.container.classList.remove("ui-viewer-reading-mode")},cursorInPerimeter:function(e){var t=document.body.clientHeight/100*30;var i=document.body.clientWidth/100*30;i<300?i=300:null;t<300?t=300:null;if(e.y<t||e.y>document.body.clientHeight-t||e.x<i||e.x>document.body.clientWidth-i){return false}return true},handleSliderCloseByEsc:function(e){if(this.isOpen()&&this.getZindex()>e.getSlider().getZindex()){e.denyAction()}},adjustViewport:function(){var e=document.querySelector('[name="viewport"]');if(!e){return}this._viewportContent=e.getAttribute("content");e.setAttribute("content","width=device-width, user-scalable=no")},restoreViewport:function(){var e=document.querySelector('[name="viewport"]');if(!this._viewportContent||!e){return}e.setAttribute("content",this._viewportContent)},unbindEvents:function(){this.eventsAlreadyBinded=false;BX.unbind(document,"keydown",this.handlers.keyPress);BX.unbind(window,"resize",this.handlers.resize);BX.unbind(this.getItemContainer(),"touchstart",this.handlers.touchStart);BX.unbind(this.getItemContainer(),"touchend",this.handlers.touchEnd);BX.unbind(this.getItemContainer(),"click",this.handlers.handleClickOnItemContainer);BX.unbind(this.getNextButton(),"click",this.handlers.showNext);BX.unbind(this.getPrevButton(),"click",this.handlers.showPrev);BX.unbind(this.getCloseButton(),"click",this.handlers.close)},init:function(){},openByNode:function(e){this.buildItemListByNode(e).then(function(t){if(t.length===0){return}if(this.shouldProcessSeparateMode(t)){this.setItems(t).then(function(){this.openSeparate(0)}.bind(this));return}this.setItems(t).then(function(){this.open(this.getIndexByNode(e))}.bind(this))}.bind(this))},runActionByNode:function(e,t,i){this.buildItemListByNode(e).then(function(n){if(n.length===0){return}this.setItems(n).then(function(){this.runAction(this.getIndexByNode(e),t,i)}.bind(this))}.bind(this))},runAction(e,t,i){const n=this.getItemByIndex(e);if(t==="download"){window.open(n.getDownloadUrl(),this.isExternalLink(n.getDownloadUrl())?"_blank":"_self");return}var o=n.getActions().find((function(e){return e.id===t}));console.log("actionToRun",t,o);if(!BX.type.isFunction(o.action)){console.log("action is not a function");return}o.action.call(this,n,i)},getZindex:function(){var e=this.getViewerContainer();if(!e.parentNode){return 0}var t=BX.ZIndexManager.getComponent(e);return t.getZIndex()},setItems:function(e){if(!BX.type.isArray(e)){throw new Error("BX.UI.Viewer.Controller.setItems: 'items' has to be Array.")}BX.onCustomEvent("BX.UI.Viewer.Controller:onSetItems",[this,e]);if(this.items!==null){this.items.forEach((e=>{e.destroy()}))}this.items=e;this.items.forEach((function(e){e.setController(this)}),this);return this.loadExtensions(this.collectExtensionsForAction(e))},loadExtensions:function(e){return BX.loadExt(e)},collectExtensionsForAction:function(e){var t=new Set;e.forEach((function(e){var i=e.getActions()||[];i.forEach((function(e){if(!e.extension){return}if(!BX.type.isArray(e.extension)){e.extension=[e.extension]}e.extension.forEach((function(e){t.add(e)}))}))}));var i=[];t.forEach((function(e){if(shouldLoadExtensions(e)){i.push(e)}}));return i},appendItem:function(e){if(!(e instanceof BX.UI.Viewer.Item)){throw new Error("BX.UI.Viewer.Controller.appendItem: 'item' has to be instance of BX.UI.Viewer.Item.")}e.setController(this);this.items.push(e)},reloadItem:function(e,t){t=t||{};if(!(e instanceof BX.UI.Viewer.Item)){throw new Error("BX.UI.Viewer.Controller.reloadItem: 'item' has to be instance of BX.UI.Viewer.Item.")}var i=this.items.indexOf(e);if(i===-1){throw new Error("BX.UI.Viewer.Controller.reloadItem: there is no 'item' in items to reload.")}var n=null;if(e.sourceNode){n=BX.UI.Viewer.buildItemByNode(e.sourceNode)}else{n=new e.constructor(e.options)}e.destroy();n.setController(this);n.applyReloadOptions(t);this.items[i]=n},show:function(e,t){t=t||{};if(typeof e==="undefined"){e=0}BX.onCustomEvent("BX.UI.Viewer.Controller:onBeforeShow",[this,e]);var i=this.getItemByIndex(e);if(!i){return}this.hideErrorBlock();this.hideCurrentItem();this.disableReadingMode();this.showLoading();const n=e===0&&this.currentIndex===this.items.length-1;const o=this.currentIndex===0&&e===this.items.length-1;const s=e<this.currentIndex&&!n||o?"backward":"forward";this.currentIndex=e;this.updateActions(this.getCurrentItem());this.observeItemLoading(i);const r=i.getTitle();this.setTitle(BX.Type.isStringFilled(r)?r:"");i.load().then((e=>{this.unobserveItemLoading(i);if(this.getCurrentItem()===e){console.log("show item");this.processShowItem(e,t);if(t.asFirstToShow){e.asFirstToShow()}}})).catch((e=>{this.unobserveItemLoading(i);var t=e.item;console.log("catch viewer");BX.onCustomEvent("BX.UI.Viewer.Controller:onItemError",[this,e,t]);if(this.getCurrentItem()===t){this.processError(e,t)}BX.onCustomEvent("BX.UI.Viewer.Controller:onAfterProcessItemError",[this,e,t])}));this.updateControls();this.lockScroll();this.adjustViewerHeight();const a=this.items.length>20&&(n||o);this.selectCarouselItem(this.currentIndex,t.asFirstToShow!==true&&!a);this.processPreload(this.currentIndex,s)},processPreload(e,t){if(this.maxParallelLoads<1){return}const i=this.maxParallelLoads-1;let n=t==="backward"?e-1:e+1;const o=()=>{if(t==="backward"){return n>e-1-i}return n<i+e+1};while(o()){const e=this.getItemByIndex(n);if(!e){break}console.log("Trying to preload",n);this.observeItemLoading(e);e.load().then((()=>{this.unobserveItemLoading(e)})).catch((()=>{this.unobserveItemLoading(e)}));if(t==="backward"){n--}else{n++}}},reload:function(e,t){var i=this.getCurrentItem()===e;this.reloadItem(e,t);if(i){console.log("reload");this.show(this.currentIndex)}},reloadCurrentItem:function(e){this.reload(this.getCurrentItem(),e||{})},processShowItem:function(e,t){this.hideCurrentItem();this.hideLoading();this.unlockExtraActions();var i=BX.create("div",{props:{className:"ui-viewer-inner-content-wrapper"}});const n=e.getTitle();this.setTitle(BX.Type.isStringFilled(n)?n:"");var o=document.createDocumentFragment();o.appendChild(e.render(t));i.appendChild(o);var s=this.layout.container.classList;var r=e.listContainerModifiers();if(r.length){s.add.apply(s,r)}this.layout.itemContainer.appendChild(i);e.afterRender();this.adjustControlsSize(e.getContentWidth());BX.onCustomEvent("BX.UI.Viewer.Controller:onAfterShow",[this,e])},adjustControlsSize:function(e){this.getNextButton().style.width=null;this.getPrevButton().style.width=null;this.getNextButton().style.maxWidth=null;this.getPrevButton().style.maxWidth=null;if(e&&BX.Type.isFunction(e.then)){e.then((e=>{let t=Math.floor((document.body.offsetWidth-Math.ceil(e))/2);t=Math.max(t,70);this.getNextButton().style.width=t+"px";this.getPrevButton().style.width=t+"px";this.getNextButton().style.maxWidth="none";this.getPrevButton().style.maxWidth="none"}))}},processError:function(e,t){e=e||{};var i=e.message||null;if(BX.type.isArray(e.errors)&&e.errors.length){if(e.errors[0].code===1e3&&!e.message){i=BX.message("JS_UI_VIEWER_ITEM_TRANSFORMATION_ERROR_1").replace("#DOWNLOAD_LINK#",t.getSrc())}}this.hideCurrentItem();this.hideLoading();this.cleanExtraActions();var n=BX.create("div",{props:{className:"ui-viewer-inner-content-wrapper"}});var o=t.getTitle();this.setTitle(BX.Type.isStringFilled(o)?o:"");var s={};if(i){s.title=i}if(e.description){s.description=e.description}n.appendChild(this.getErrorBlock(s,t));this.layout.itemContainer.appendChild(n)},hideErrorBlock:function(){if(this.layout.error){BX.remove(this.layout.error)}},getErrorBlock:function(e,t){this.hideErrorBlock();var i=BX.prop.getString(e,"viewType","info");var n=BX.prop.getString(e,"title",BX.message("JS_UI_VIEWER_ITEM_TRANSFORMATION_ERROR_1").replace("#DOWNLOAD_LINK#",t.getSrc()));var o=BX.prop.getString(e,"description",BX.message("JS_UI_VIEWER_ITEM_TRANSFORMATION_HINT"));this.layout.error=BX.create("div",{props:{className:"ui-viewer-error"},style:{maxWidth:o?"440px":null},children:[BX.create("div",{props:{className:"ui-viewer-"+i+"-title"},html:n}),BX.create("div",{props:{className:"ui-viewer-"+i+"-text"},html:o})]});return this.layout.error},isExternalLink:function(e){var t=new RegExp("^([a-z]+://|//)","i");if(!t.test(e)){return false}if(!BX.getClass("URL")){return e.indexOf(location.hostname)===-1}try{return new URL(e).hostname!==location.hostname}catch(e){}return true},createMoreMenuItems(e){return e.getActions().map((t=>{const i={...t};if(!i.href&&BX.type.isFunction(i.action)){const t=i.action;i.onclick=(i,n)=>{t.call(this,e,{event:i,menuItem:n});this.moreMenu?.close()}}i.disabled=i.disableBeforeLoaded===true&&e.isLoaded===false;if(BX.Type.isArrayFilled(i.items)){i.items=i.items.map((e=>{const t={...e};if(BX.type.isString(t.onclick)){const e=new Function("event","popupItem",t.onclick);t.onclick=(t,i)=>{e(t,i);this.moreMenu?.close()}}return t}))}return i}))},refineItemActions(item){const defaultActions={download:{id:"download",type:"download",text:BX.Loc.getMessage("JS_UI_VIEWER_ITEM_ACTION_DOWNLOAD"),href:item.src,buttonIconClass:"ui-btn-icon-download"},edit:{id:"edit",type:"edit",text:BX.Loc.getMessage("JS_UI_VIEWER_ITEM_ACTION_EDIT"),buttonIconClass:"ui-btn-icon-edit"},share:{id:"share",type:"share",text:BX.Loc.getMessage("JS_UI_VIEWER_ITEM_ACTION_SHARE"),buttonIconClass:"ui-btn-icon-share"},print:{id:"print",type:"print",text:BX.Loc.getMessage("JS_UI_VIEWER_ITEM_ACTION_PRINT"),buttonIconClass:"ui-btn-icon-print ui-btn-disabled",disableBeforeLoaded:true},info:{id:"info",type:"info",text:BX.Loc.getMessage("JS_UI_VIEWER_ITEM_ACTION_INFO"),buttonIconClass:"ui-btn-icon-info ui-action-panel-item-last"},delete:{id:"delete",type:"delete",text:BX.Loc.getMessage("JS_UI_VIEWER_ITEM_ACTION_DELETE"),buttonIconClass:"ui-btn-icon-remove"}};const actions=[];for(const[,nakedAction]of item.getNakedActions().entries()){const action=defaultActions[nakedAction.type]?BX.mergeEx(defaultActions[nakedAction.type],nakedAction):nakedAction;if(!action.id){action.id=action.type}if(action.id==="download"&&BX.Type.isStringFilled(action.href)){item.setDownloadUrl(action.href);continue}if(!action.action&&action.href){action.action=()=>{window.open(action.href,this.isExternalLink(action.href)?"_blank":"_self")}}if(BX.type.isString(action.action)){const params=action.params||{};const actionString=action.action;action.action=(item,additionalParams)=>{try{const fn=eval(actionString);fn.call(this,item,params,additionalParams)}catch(e){console.log(e)}}}actions.push(action)}return actions},getLoader:function(e){if(!this.layout.loader){this.layout.loader=BX.create("div",{props:{className:"ui-viewer-loader"},style:{zIndex:-1},children:[this.layout.loaderContainer=BX.create("div",{props:{className:"ui-viewer-loader-container"}}),this.layout.loaderText=BX.create("div",{props:{className:"ui-viewer-loader-text"},text:""})]});var t=new BX.Loader({size:130});t.show(this.layout.loaderContainer)}return this.layout.loader},getPrevButton:function(){if(!this.layout.prev){this.layout.prev=BX.create("div",{props:{className:"ui-viewer-prev"},events:{mousewheel:function(e){this.handleMouseWheelOnControlButton(this.layout.prev,e)}.bind(this)}})}return this.layout.prev},getNextButton:function(){if(!this.layout.next){this.layout.next=BX.create("div",{props:{className:"ui-viewer-next"},events:{mousewheel:function(e){this.handleMouseWheelOnControlButton(this.layout.next,e)}.bind(this)}})}return this.layout.next},handleMouseWheelOnControlButton:function(e,t){if(this._timeoutIdMouseWheel){clearTimeout(this._timeoutIdMouseWheel)}e.style.pointerEvents="none";this._timeoutIdMouseWheel=setTimeout((function(){e.style.pointerEvents=null}),50)},getCloseButton:function(){if(!this.layout.close){this.layout.close=BX.create("div",{props:{className:"ui-viewer-close"},html:'<div class="ui-viewer-close-icon">'+'<div class="ui-icon-set --cross-40"></div>'+"</div>"})}return this.layout.close},getDownloadButton:function(){if(!this.layout.downloadBtn){this.layout.downloadBtn=BX.Tag.render`
					<a 
						class="ui-viewer-download-btn" 
						target="_blank" 
						title="${BX.Text.encode(BX.Loc.getMessage("JS_UI_VIEWER_ITEM_ACTION_DOWNLOAD"))}"
						href="" 
						download
					>
						<div class="ui-icon-set --download ui-viewer-download-btn-icon"></div>
					</a>
				`}return this.layout.downloadBtn},getMoreButton:function(){if(!this.layout.moreBtn){this.layout.moreBtn=BX.Tag.render`
					<div class="ui-viewer-more-btn" onclick="${this.handleMoreBtnClick.bind(this)}">
						<div class="ui-icon-set --more ui-viewer-more-btn-icon"></div>
					</div>
				`}return this.layout.moreBtn},isOpen:function(){return this._isOpen},addBodyPadding:function(){var e=window.innerWidth-document.documentElement.clientWidth;if(BX.getClass("BXIM.messenger.popupMessenger")||e===0){return}document.body.style.paddingRight=e+"px";var t=document.getElementById("bx-im-bar");if(t){var i="rgb(238, 242, 244)";if(document.body.classList.contains("bitrix24-light-theme")){i="rgba(255, 255, 255, .1)"}if(document.body.classList.contains("bitrix24-dark-theme")){i="rgba(82, 92, 105, .1)"}t.style.borderRight=e+"px solid "+i}this.isBodyPaddingAdded=true},removeBodyPadding:function(){document.body.style.removeProperty("padding-right");var e=document.getElementById("bx-im-bar");if(e){e.style.removeProperty("border-right")}this.isBodyPaddingAdded=false},openSeparate:function(e){var t=this.getItemByIndex(e);if(!t){return}t.load().then(function(e){}.bind(this)).catch(function(e){var t=e.item;console.log("catch viewer");BX.onCustomEvent("BX.UI.Viewer.Controller:onItemError",[this,e,t]);if(this.getCurrentItem()===t){this.processError(e,t)}BX.onCustomEvent("BX.UI.Viewer.Controller:onAfterProcessItemError",[this,e,t])}.bind(this))},open:function(e){this.adjustViewport();this.addBodyPadding();var t=this.getViewerContainer();const i=this.baseContainer||document.body;i.appendChild(t);BX.focus(t);var n=BX.ZIndexManager.getComponent(t);if(!n){BX.ZIndexManager.register(t)}BX.ZIndexManager.bringToFront(t);this.createCarouselItems(e);this.show(e,{asFirstToShow:true});this.bindEvents();this._isOpen=true},setTitle:function(e){if(BX.Type.isStringFilled(e)){this.getTitleContainer().textContent=e}},getTitleContainer:function(){if(!this.layout.title){this.layout.title=BX.Tag.render`
					<span class="ui-viewer-title-text"></span>
				`}return this.layout.title},getExtraActions:function(){if(!this.layout.extraActions){this.layout.extraActions=BX.Tag.render`
					<div class="ui-viewer-extra-actions"></div>
				`}return this.layout.extraActions},getDefaultActions:function(){if(!this.layout.defaultActions){this.layout.defaultActions=BX.Tag.render`
					<div class="ui-viewer-default-actions">
						${this.getDownloadButton()}
						${this.getMoreButton()}
					</div>
				`}return this.layout.defaultActions},observeItemLoading(e){const t=Object.hasOwn(Object.getPrototypeOf(e),"abort");if(e.isLoaded===true||!t){return}this.loadingItems.add(e);if(this.loadingItems.size>this.maxParallelLoads){for(const t of this.loadingItems){if(t===e||t===this.getCurrentItem()){continue}const i=t.abort();if(i===true){this.loadingItems.delete(t);break}}}},unobserveItemLoading(e){this.loadingItems.delete(e)},updateActions(e){this.getDownloadButton().setAttribute("href",e.getDownloadUrl());if(e.getActions().length>0){BX.Dom.removeClass(this.getMoreButton(),"--hidden")}else{BX.Dom.addClass(this.getMoreButton(),"--hidden")}this.renderExtraActions(e);if(!e.isLoaded){this.lockExtraActions()}},getCarouselContainer:function(){if(!this.layout.carouselContainer){this.layout.carouselContainer=BX.Tag.render`
					<div class="ui-viewer-carousel">
						${this.getCarouselScrollable()}
					<div>
				`}return this.layout.carouselContainer},getCarouselScrollable:function(){if(!this.layout.carouselScrollable){this.layout.carouselScrollable=BX.Tag.render`
					<div 
						class="ui-viewer-carousel-scrollable" 
						onscroll="${BX.Runtime.debounce(this.handleCarouselScroll,200,this)}"
					>
						${this.getCarouselItems()}
					</div>
				`}return this.layout.carouselScrollable},getCarouselItems:function(){if(!this.layout.carouselItems){this.layout.carouselItems=BX.Tag.render`
					<div class="ui-viewer-carousel-items" onclick="${this.handleCarouselClick.bind(this)}"></div>
				`}return this.layout.carouselItems},getCarouselItemWidth:function(e=false){const t=4*2;return e?72+t:46+t},createCarouselItems:function(e){const t=this.getCarouselItems();BX.Dom.clean(t);BX.Dom.style(t,{paddingLeft:null,paddingRight:null});BX.Dom.style(this.getCarouselContainer(),{width:null});BX.Dom.remove(this.getCarouselContainer());if(!this.isCarouselEnabled()){return}for(const[t,i]of this.items.entries()){const n=BX.Tag.render`
					<div class="ui-viewer-carousel-item" data-index="${t}"></div>
				`;if(t===e){BX.Dom.addClass(n,"--selected")}if(i.getPreviewUrl()===null){const e=this.createItemIcon(i);e.renderTo(n)}else{const e=document.createElement("img");e.className="ui-viewer-carousel-item-preview-img";e.onerror=this.handlers.handleCarouselItemError;if(t<=10||i.getPreviewUrl().startsWith("blob:")){e.src=i.getPreviewUrl()}else{e.src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";n.dataset.lazyloadSrc=i.getPreviewUrl()}n.appendChild(e)}BX.Dom.append(n,this.getCarouselItems())}BX.Dom.append(this.getCarouselContainer(),this.getViewerContainer());const i=this.getCarouselItemWidth()*6+this.getCarouselItemWidth(true);const n=((this.getItemsCount()-1)*this.getCarouselItemWidth()+this.getCarouselItemWidth(true)/2)*2;const o=Math.max(this.getCarouselContainer().offsetWidth,Math.min(n,i));const s=o/2-this.getCarouselItemWidth(true)/2;BX.Dom.style(this.getCarouselContainer(),{width:`${o}px`});BX.Dom.style(t,{paddingLeft:`${s}px`,paddingRight:`${s}px`})},loadCarouselPreviews(){const e=this.getCarouselItemWidth();const t=this.getCarouselItems().parentNode;const i=t.parentNode.offsetWidth;const n=Math.round(i/e);const o=t.scrollLeft;const s=Math.ceil(o/e);const r=Math.max(s-n,0);const a=Math.min(s+n*1.5,this.items.length-1);for(let e=r;e<=a;e++){const t=this.getCarouselItems().children[e];if(t.dataset.lazyloadSrc){const e=t.firstElementChild;e.src=t.dataset.lazyloadSrc;BX.Dom.attr(t,"data-lazyload-src",null)}}},getFileExtension:function(e){const t=BX.Type.isStringFilled(e)?e.lastIndexOf("."):-1;return t>0?e.slice(Math.max(0,t+1)):""},handleCarouselClick:function(e){const t=e.target.closest(".ui-viewer-carousel-item");if(!t){return}const i=Number(t.dataset.index);this.show(i)},handleCarouselScroll(e){this.loadCarouselPreviews()},handleCarouselItemError(e){const t=e.target.closest(".ui-viewer-carousel-item");const i=t.dataset.index;const n=this.getItemByIndex(i);BX.Dom.clean(t);const o=this.createItemIcon(n);o.renderTo(t)},createItemIcon(e){return new BX.UI.Icons.Generator.FileIcon({name:this.getFileExtension(e.getTitle())||"...",size:18})},isCarouselEnabled:function(){if(this.items.length<2){return false}return this.items.some((e=>e.getPreviewUrl()!==null))},selectCarouselItem:function(e,t=true){if(!this.isCarouselEnabled()){return}const i=this.getCarouselItems().querySelector(".ui-viewer-carousel-item.--selected");if(i){BX.Dom.removeClass(i,"--selected")}const n=this.getCarouselItems().querySelector(`.ui-viewer-carousel-item[data-index="${e}"]`);BX.Dom.addClass(n,"--selected");this.adjustCarouselPosition(this.currentIndex,t);this.loadCarouselPreviews()},adjustCarouselPosition:function(e,t=true){if(!this.isCarouselEnabled()){return false}const i=this.getCarouselItems().parentNode;const n=this.getCarouselItems().querySelector(`.ui-viewer-carousel-item[data-index="${e}"]`);if(n===null){return false}const o=this.getCarouselItemWidth()*e;if(i.scrollLeft!==o){i.scrollTo({left:o,behavior:t?"smooth":"instant"});return true}return false},hideCurrentItem:function(){if(this.getCurrentItem()){var e=this.layout.container.classList;var t=this.getCurrentItem().listContainerModifiers();if(t.length){e.remove.apply(e,t)}this.getCurrentItem().beforeHide()}this.moreMenu?.close();BX.cleanNode(this.layout.itemContainer)},updateControls:function(){if(!this.allowToUseCycleMode()&&this.currentIndex+1>=this.items.length){BX.addClass(this.getNextButton(),"ui-viewer-navigation-hide")}else{BX.removeClass(this.getNextButton(),"ui-viewer-navigation-hide")}if(!this.allowToUseCycleMode()&&this.currentIndex===0){BX.addClass(this.getPrevButton(),"ui-viewer-navigation-hide")}else{BX.removeClass(this.getPrevButton(),"ui-viewer-navigation-hide")}},getCurrentItem:function(){return this.getItemByIndex(this.currentIndex)},getIndexByNode:function(e){var t=null;this.items.forEach((function(i,n){if(i.sourceNode===e){t=n}}));return t},getItemByIndex:function(e){e=parseInt(e,10);BX.onCustomEvent("BX.UI.Viewer.Controller:onGetItemByIndex",[this,e]);if(e<0||e-1>this.items.length){return null}return this.items[e]},getItemsCount:function(){return this.items.length},handleClickOnItemContainer:function(e){this.getCurrentItem().handleClickOnItemContainer(e)},allowToUseCycleMode:function(){var e=this.cycleMode;var t=this.getCurrentItem().getGroupBy();if(this.optionsByGroup[t]&&this.optionsByGroup[t].hasOwnProperty("cycleMode")){e=this.optionsByGroup[t].cycleMode}return this.items.length>1&&e},showNext:function(){var e=this.currentIndex+1;if(this.allowToUseCycleMode()&&e>=this.items.length){e=0}this.show(e)},showPrev:function(){var e=this.currentIndex-1;if(this.allowToUseCycleMode()&&e===-1){e=this.items.length-1}this.show(e)},close:function(){this._isOpen=false;BX.onCustomEvent("BX.UI.Viewer.Controller:onClose",[this]);BX.addClass(this.layout.container,"ui-viewer-hide");this.restoreViewport();this.hideCurrentItem();BX.bind(this.layout.container,"transitionend",function(){BX.ZIndexManager.unregister(this.layout.container);BX.remove(this.layout.container);BX.removeClass(this.layout.container,"ui-viewer-hide");BX.unbindAll(this.layout.container);this.unLockScroll();this.unbindEvents();this.disableReadingMode();if(this.isBodyPaddingAdded){this.removeBodyPadding()}}.bind(this))},showLoading:function(e){e=e||{};e.zIndex=BX.type.isNumber(e.zIndex)?e.zIndex:-1;this.layout.inner.appendChild(this.getLoader());this.setTextOnLoading(e.text||"");this.layout.loader.style.zIndex=e.zIndex},setTextOnLoading:function(e){this.layout.loaderText.textContent=e},hideLoading:function(){BX.remove(this.layout.loader)},lockScroll:function(){BX.addClass(document.body,"ui-viewer-lock-body")},unLockScroll:function(){BX.removeClass(document.body,"ui-viewer-lock-body")},renderExtraActions(e){this.cleanExtraActions();BX.Dom.append(e.renderExtraActions(),this.getExtraActions())},cleanExtraActions(){BX.Dom.clean(this.getExtraActions())},lockExtraActions:function(){BX.Dom.addClass(this.getExtraActions(),"--locked")},unlockExtraActions:function(){BX.Dom.removeClass(this.getExtraActions(),"--locked")},handleWindowResize(){this.adjustViewerHeight();const e=this.getCurrentItem();if(e){e.handleResize()}},adjustViewerHeight:function(){if(!this.layout.container||BX.browser.IsMobile())return;this.layout.container.style.height=document.documentElement.clientHeight+"px"},getViewerContainer:function(){if(!this.layout.container){this.layout.container=BX.create("div",{props:{className:"ui-viewer",tabIndex:22081990},style:{height:window.clientHeight+"px"},children:[BX.Tag.render`
							<div class="ui-viewer-header">
								<div class="ui-viewer-author"></div>
								<div class="ui-viewer-title">
									${this.getTitleContainer()}
								</div>
								<div class="ui-viewer-actions">
									${this.getExtraActions()}
									${this.getDefaultActions()}
									${this.getCloseButton()}
								</div>
							</div>
						`,this.layout.inner=BX.create("div",{props:{className:"ui-viewer-inner"},children:[this.getItemContainer()]}),this.getPrevButton(),this.getNextButton()]})}return this.layout.container},getItemContainer:function(){if(!this.layout.itemContainer){this.layout.itemContainer=BX.create("div",{props:{className:"ui-viewer-inner-content"}})}return this.layout.itemContainer},handleTouchStart:function(e){var t=e.changedTouches[0];this.swipeDirection=null;this.startX=t.pageX;this.startY=t.pageY;this.startTime=(new Date).getTime()},handleTouchEnd:function(e){var t=e.changedTouches[0];var i=300;var n=80;var o=100;var s=t.pageX-this.startX;var r=t.pageY-this.startY;var a=(new Date).getTime()-this.startTime;if(a<=i){if(Math.abs(s)>=n&&Math.abs(r)<=o){this.swipeDirection=s<0?"left":"right"}}switch(this.swipeDirection){case"left":this.showPrev();break;case"right":this.showNext();break}},isOnTop:function(){if(!this.isOpen()){return false}if(BX.getClass("BXIM.messenger")&&BXIM.messenger.popupMessenger){return true}if(!BX.getClass("BX.SidePanel.Instance")||!BX.SidePanel.Instance.getTopSlider()){return true}return this.getZindex()>BX.SidePanel.Instance.getTopSlider().getZindex()},handleKeyPress:function(e){if(!this.isOnTop()){return}if(e.metaKey){return}const t=this.getCurrentItem().handleKeyPress(e);if(t===true){return}switch(e.code){case"Space":case"ArrowRight":this.showNext();e.preventDefault();e.stopPropagation();break;case"ArrowLeft":this.showPrev();e.preventDefault();e.stopPropagation();break;case"Escape":this.close();e.preventDefault();e.stopPropagation();break}},setOptionsByGroup:function(e,t){this.optionsByGroup[e]=t;return this},getCachedData:function(e){return this.cachedData[e]},setCachedData:function(e,t){this.cachedData[e]=t},unsetCachedData:function(e){this.cachedData[e]=null},addType:function(e,t){return BX.UI.Viewer.addType(e,t)}};BX.UI.Viewer.InlineController=function(e){e=e||{};BX.UI.Viewer.Controller.apply(this,arguments)};BX.UI.Viewer.InlineController.prototype={__proto__:BX.UI.Viewer.Controller.prototype,constructor:BX.UI.Viewer.Controller,adjustViewport:function(){},addBodyPadding:function(){},adjustZindex:function(){},adjustViewerHeight:function(){},renderItemByNode:function(e){if(!e){return}this.buildItemListByNode(e).then(function(e){if(e.length===0){return}this.setItems(e).then(function(){this.open(0)}.bind(this))}.bind(this))},getViewerContainer:function(){if(!this.layout.container){this.layout.container=this.layout.inner=BX.create("div",{props:{className:"ui-viewer-inner"},children:[this.getItemContainer()]})}return this.layout.container},handleClickOnItemContainer:function(){},handleKeyPress:function(){},temp(){}};BX.UI.Viewer.buildItemByTypeAndNode=function(e,t){var i=new e;if(!(i instanceof BX.UI.Viewer.Item)){throw new Error("BX.UI.Viewer.buildItemByTypeAndNode: 'item' has to be instance of BX.UI.Viewer.Item.")}i.bindSourceNode(t);i.setPropertiesByNode(t);i.setActions(BX.UI.Viewer.Instance.refineItemActions(i));return i};BX.UI.Viewer.buildItemByNode=function(e){if(!BX.type.isDomNode(e)){throw new Error("BX.UI.Viewer.buildItemByNode: 'node' has to be DomNode.")}var t=e.dataset.viewerType;if(!t&&e.tagName.toLowerCase()==="img"){t="image"}BX.UI.Viewer.triggerEventToFindTypeClass(t);var i=types[t];if(i){return BX.UI.Viewer.buildItemByTypeAndNode(BX.getClass(i),e)}if(e.dataset.viewerTypeClass){if(!BX.getClass(e.dataset.viewerTypeClass)){throw new Error("BX.UI.Viewer.buildItemByNode: could not find class "+e.dataset.viewerTypeClass)}return BX.UI.Viewer.buildItemByTypeAndNode(BX.getClass(e.dataset.viewerTypeClass),e)}console.warn("BX.UI.Viewer.buildItemByNode: could not find class to build type {"+t+"}");return BX.UI.Viewer.buildItemByTypeAndNode(BX.getClass(types.unknown),e)};var types={image:"BX.UI.Viewer.Image",plainText:"BX.UI.Viewer.PlainText",unknown:"BX.UI.Viewer.Unknown",video:"BX.UI.Viewer.Video",audio:"BX.UI.Viewer.Audio",document:"BX.UI.Viewer.Document",code:"BX.UI.Viewer.HightlightCode"};BX.UI.Viewer.addType=function(e,t){types[e]=t};BX.UI.Viewer.triggerEventToFindTypeClass=function(e){BX.onCustomEvent("BX.UI.Viewer.Controller:onFindType",[BX.UI.Viewer.Instance,e])};BX.UI.Viewer.bind=function(e,t){if(!BX.type.isDomNode(e)){throw new Error("BX.UI.Viewer.bind: 'container' has to be DomNode.")}if(!BX.type.isPlainObject(t)&&!BX.type.isFunction(t)){t=function(e){return BX.type.isElementNode(e)&&e.dataset.hasOwnProperty("viewer")}}BX.bindDelegate(e,"click",t,(function(i){var n=BX.findChildren(e,t,true);var o=0;var s=BX.getEventTarget(i);if(s.tagName!=="A"&&s.closest('a[target="_blank"]')){return false}var r=n.map((function(e,t){if(e===s){o=t}return BX.UI.Viewer.buildItemByNode(e)}));BX.UI.Viewer.Instance.setItems(r).then((function(){BX.UI.Viewer.Instance.open(o)}));i.preventDefault()}))};var shouldLoadExtensions=function(e){if(e==="disk.viewer.actions"&&BX.getClass("BX.Disk.Viewer.Actions")){return false}if(e==="disk.viewer.document-item"&&BX.getClass("BX.Disk.Viewer.DocumentItem")){return false}return true};var instance=null;Object.defineProperty(BX.UI.Viewer,"Instance",{enumerable:false,get:function(){if(window.top!==window&&BX.getClass("window.top.BX.UI.Viewer.Instance")){return window.top.BX.UI.Viewer.Instance}if(instance===null){instance=new BX.UI.Viewer.Controller({})}return instance}});window.document.addEventListener("click",(function(e){if(e.button!==0){return}if(window.top!==window&&!BX.getClass("window.top.BX.UI.Viewer.Instance")){top.BX.loadExt("ui.viewer").then((function(){top.BX.UI.Viewer.Instance.handleDocumentClick(e)}))}else{top.BX.UI.Viewer.Instance.handleDocumentClick(e)}}),true);if(window.top!==window&&!BX.getClass("window.top.BX.UI.Viewer.Instance")){top.BX.loadExt("ui.viewer")}})();
//# sourceMappingURL=ui.viewer.map.js