(function(){"use strict";BX.namespace("BX.UI.Notification");var t={INIT:0,OPENING:1,OPEN:2,CLOSING:3,CLOSED:4,PAUSED:5,QUEUED:6};BX.UI.Notification.State=t;BX.UI.Notification.Balloon=function(i){i=BX.type.isPlainObject(i)?i:Object.create(null);if(!(i.stack instanceof BX.UI.Notification.Stack)){throw new Error("BX.UI.Notification.Balloon: 'stack' parameter is required.")}this.id=BX.type.isNotEmptyString(i.id)?i.id:BX.util.getRandomString(8).toLowerCase();this.stack=i.stack;this.state=t.INIT;this.showOnTopWindow=i.showOnTopWindow===true;this.container=null;this.content=null;this.actions=[];this.animationClassName="ui-notification-balloon-animate";this.customRender=null;this.category=null;this.autoHide=true;this.autoHideDelay=8e3;this.autoHideTimeout=null;this.data={};this.width=400;this.closeButton=null;this.closeButtonVisibility=true;if(BX.type.isPlainObject(i.events)){for(var e in i.events){this.addEvent(e,i.events[e])}}this.setOptions(i)};BX.UI.Notification.Balloon.prototype={show:function(){if(this.getState()===t.OPENING){return}if(this.getState()===t.OPEN){this.activateAutoHide();return}var i=false;if(!this.getContainer().parentNode){i=true;if(this.showOnTopWindow){window.top.document.body.appendChild(this.getContainer())}else{document.body.appendChild(this.getContainer())}BX.ZIndexManager.register(this.getContainer(),{alwaysOnTop:true});this.getStack().add(this);if(this.getState()===t.QUEUED){return}}var e=this.getState()===t.PAUSED;this.setState(t.OPENING);this.adjustPosition();BX.ZIndexManager.bringToFront(this.getContainer());this.animateIn(function(){if(this.getState()!==t.OPENING){return}this.setState(t.OPEN);if(i){this.fireEvent("onOpen")}if(!e){this.activateAutoHide()}}.bind(this))},setOptions:function(t){if(!BX.type.isPlainObject(t)){return}this.setContent(t.content);this.setWidth(t.width);this.setData(t.data);this.setCloseButtonVisibility(t.closeButton);this.setActions(t.actions);this.setCategory(t.category);this.setAutoHide(t.autoHide);this.setCustomRender(t.render);this.setAutoHideDelay(t.autoHideDelay)},update:function(t){this.setOptions(t);BX.cleanNode(this.getContainer());this.getContainer().appendChild(this.render());this.deactivateAutoHide();this.activateAutoHide()},close:function(){const i=this.getState();if(i===t.CLOSING||i===t.CLOSED){return}this.setState(t.CLOSING);this.deactivateAutoHide();const e=()=>{if(this.getState()!==t.CLOSING){return}this.setState(t.CLOSED);BX.ZIndexManager.unregister(this.getContainer());BX.remove(this.getContainer());this.container=null;this.fireEvent("onClose")};if(i===t.OPENING){e()}else{this.animateOut((()=>{e()}))}},blink:function(){var t=this;this.animateOut((function(){setTimeout((function(){t.update(null);t.animateIn((function(){}))}),200)}))},adjustPosition:function(){if(this.getStack().isNewestOnTop()){this.getStack().adjustPosition()}else{this.getStack().adjustPosition(this)}},getId:function(){return this.id},getCloseButton:function(){if(this.closeButton!==null){return this.closeButton}this.closeButton=BX.create("div",{props:{className:"ui-notification-balloon-close-btn"},events:{click:this.handleCloseBtnClick.bind(this)}});return this.closeButton},setCloseButtonVisibility:function(t){this.closeButtonVisibility=t!==false},isCloseButtonVisible:function(){return this.closeButtonVisibility},getContent:function(){return this.content},setContent:function(t){if(BX.type.isString(t)||BX.type.isDomNode(t)){this.content=t}},getWidth:function(){return this.width},setWidth:function(t){if(BX.type.isNumber(t)||t==="auto"){this.width=t}},getZIndex:function(){var t=BX.ZIndexManager.getComponent(this.getContainer());return t?t.getZIndex():0},setZIndex:function(t){},getHeight:function(){return this.getContainer().offsetHeight},getCategory:function(){return this.category},setCategory:function(t){if(BX.type.isNotEmptyString(t)||t===null){this.category=t}},setActions:function(t){if(BX.type.isArray(t)){this.actions=[];t.forEach((function(t){this.actions.push(new BX.UI.Notification.Action(this,t))}),this)}else if(t===null){this.actions=[]}},getActions:function(){return this.actions},getAction:function(t){for(var i=0;i<this.actions.length;i++){var e=this.actions[i];if(e.getId()===t){return e}}return null},getContainer:function(){if(this.container!==null){return this.container}this.container=BX.create("div",{props:{className:"ui-notification-balloon"},children:[this.render()],events:{mouseenter:this.handleMouseEnter.bind(this),mouseleave:this.handleMouseLeave.bind(this)}});return this.container},render:function(){if(this.getCustomRender()!==null){return this.getCustomRender().apply(this,[this])}var t=this.getActions().map((function(t){return t.getContainer()}));var i=this.getContent();var e=this.getWidth();return BX.create("div",{props:{className:"ui-notification-balloon-content"},style:{width:BX.type.isNumber(e)?e+"px":e},children:[BX.create("div",{props:{className:"ui-notification-balloon-message"},html:BX.type.isDomNode(i)?null:i,children:BX.type.isDomNode(i)?[i]:[]}),BX.create("div",{props:{className:"ui-notification-balloon-actions"},children:t}),this.isCloseButtonVisible()?this.getCloseButton():null]})},setCustomRender:function(t){if(BX.type.isFunction(t)){this.customRender=t}},getCustomRender:function(){return this.customRender},getStack:function(){return this.stack},setState:function(t){var i=this.getStateCode(t);if(i!==null){this.state=t}},getState:function(){return this.state},getStateCode:function(i){for(var e in t){if(t[e]===i){return e}}return null},activateAutoHide:function(){if(!this.getAutoHide()){return}this.deactivateAutoHide();this.autoHideTimeout=setTimeout(function(){this.close()}.bind(this),this.getAutoHideDelay())},deactivateAutoHide:function(){clearTimeout(this.autoHideTimeout);this.autoHideTimeout=null},setAutoHide:function(t){this.autoHide=t!==false},getAutoHide:function(){return this.autoHide},setAutoHideDelay:function(t){if(BX.type.isNumber(t)&&t>0){this.autoHideDelay=t}},getAutoHideDelay:function(){return this.autoHideDelay},animateIn:function(t){if(!this.getContainer().classList.contains(this.getAnimationClassName())){this.getContainer().addEventListener("transitionend",(function i(){this.removeEventListener("transitionend",i);t()}));this.getContainer().classList.add(this.getAnimationClassName())}else{t()}},animateOut:function(t){if(this.getContainer().classList.contains(this.getAnimationClassName())){this.getContainer().addEventListener("transitionend",(function i(){this.removeEventListener("transitionend",i);t()}));this.getContainer().classList.remove(this.getAnimationClassName())}else{t()}},getAnimationClassName:function(){return this.animationClassName},handleCloseBtnClick:function(){this.close()},handleMouseEnter:function(){this.fireEvent("onMouseEnter");this.deactivateAutoHide();this.setState(t.PAUSED);this.show()},handleMouseLeave:function(){this.fireEvent("onMouseLeave");this.activateAutoHide()},fireEvent:function(t){var i=this.getEvent(t);BX.onCustomEvent(this,i.getFullName(),[i]);return i},addEvent:function(t,i){if(BX.type.isFunction(i)){BX.addCustomEvent(this,BX.UI.Notification.Event.getFullName(t),i)}},removeEvent:function(t,i){if(BX.type.isFunction(i)){BX.removeCustomEvent(this,BX.UI.Notification.Event.getFullName(t),i)}},getEvent:function(t){var i=new BX.UI.Notification.Event;i.setBalloon(this);i.setName(t);return i},getData:function(){return this.data},setData:function(t){if(BX.type.isPlainObject(t)){this.data=t}}};BX.UI.Notification.Event=function(){this.balloon=null;this.name=null};BX.UI.Notification.Event.getFullName=function(t){return"UI.Notification.Balloon:"+t};BX.UI.Notification.Event.prototype={getBalloon:function(){return this.balloon},setBalloon:function(t){if(t instanceof BX.UI.Notification.Balloon){this.balloon=t}},getName:function(){return this.name},setName:function(t){if(BX.type.isNotEmptyString(t)){this.name=t}},getFullName:function(){return BX.UI.Notification.Event.getFullName(this.getName())}};BX.UI.Notification.Action=function(t,i){i=BX.type.isPlainObject(i)?i:Object.create(null);this.balloon=t;this.id=BX.type.isNotEmptyString(i.id)?i.id:BX.util.getRandomString(8).toLowerCase();this.container=null;this.href=BX.type.isNotEmptyString(i.href)?i.href:null;this.title=BX.type.isNotEmptyString(i.title)?i.title:null;this.window=window;this.events={};if(BX.type.isPlainObject(i.events)){for(var e in i.events){var n=i.events[e];if(!BX.type.isFunction(n)){continue}this.events[e]=function(t,i){return function(e){t.call(e.target,e,i.getBalloon(),i)}}(n,this)}}};BX.UI.Notification.Action.prototype={getBalloon:function(){return this.balloon},getId:function(){return this.id},getTitle:function(){return this.title},getHref:function(){return this.href},getContainer:function(){if(this.container===null){this.container=BX.create(this.getHref()?"a":"span",{props:{href:this.getHref(),className:"ui-notification-balloon-action"},events:this.events,text:this.getTitle()})}return this.container},getWindow:function(){return this.window}}})();
//# sourceMappingURL=ui.notification.balloon.map.js