(function(){"use strict";BX.namespace("BX.UI");BX.UI.Dropdown=function(t){this.popupWindow=null;this.items=[];this.defaultItems=[];this.itemsContainer=null;this.popupConatiner=null;this.footerItems=null;this.targetElement=t.targetElement;this.CurrentItem=null;this.id=BX.prop.getString(t,"id",BX.Text.getRandom());this.searchAction=BX.prop.getString(t,"searchAction","");this.searchOptions=BX.prop.getObject(t,"searchOptions",{});this.previousSearchQuery=null;this.isLastSearchComplete=null;this.messages=BX.prop.getObject(t,"messages",{});this.isChanged=false;this.isDisabled=BX.prop.getBoolean(t,"isDisabled",false);this.enableCreation=BX.prop.getBoolean(t,"enableCreation",false);this.enableCreationOnBlur=BX.prop.getBoolean(t,"enableCreationOnBlur",true);this.isEmbedded=BX.prop.getBoolean(BX.prop.getObject(t,"context",{}),"isEmbedded",false);this.quickForm=document.querySelectorAll(".crm-kanban-quick-form");this.ajaxRequestTimer=null;this.autocompleteDelay=BX.prop.getInteger(t,"autocompleteDelay",0);this.minSearchStringLength=BX.prop.getInteger(t,"minSearchStringLength",2);this.documentClickHandler=BX.delegate(this.onDocumentClick,this);this.emptyValueEventHandle=0;this.events=t.events||{};this.bindEvents();this.updateItemsList(t.items);this.setDefaultItems(t.items);this.setFooterItems(t.footerItems);if(this.targetElement!=="undefined"&&typeof this.targetElement!=="undefined"){this.init()}};BX.UI.Dropdown.prototype={bindEvents:function(){if(this.events){for(var t in this.events){if(BX.type.isFunction(this.events[t])){BX.addCustomEvent(this,"BX.UI.Dropdown:"+t,this.events[t])}}}},init:function(){setTimeout(function(){BX.bind(this.targetElement,"input",function(){if(this.isDisabled){return}if(this.targetElement.value.length===0){this.enableTargetElement();return}this.showPopupWindow()}.bind(this))}.bind(this),100);this.targetElement.addEventListener("click",function(t){this.destroyPopupWindow();if(this.isDisabled){return}if(this.CurrentItem&&this.CurrentItem.title.length===this.targetElement.value.length){this.disableTargetElement()}else if(this.targetElement.value.length>0){this.disableTargetElement()}if(this.popupWindow){BX.PreventDefault(t)}this.showPopupWindow()}.bind(this),true);setTimeout(function(){this.targetElement.addEventListener("focus",function(){if(this.isDisabled){return}this.showPopupWindow();if(!this.popupAlertContainer){return}}.bind(this),true)}.bind(this),100);BX.bind(this.targetElement,"keyup",BX.throttle(function(t){if(this.isDisabled){return}if(this.targetElement.value===""){return}if(t.key==="Escape"){if(this.isDisabled){return}if(this.targetElement.value!==""&&!this.popupWindow){this.showPopupWindow()}else{BX.PreventDefault(t)}}}.bind(this),1e3));this.targetElement.addEventListener("keyup",function(t){if(this.isDisabled){return}if(t.keyCode===40){this.handleDownArrow()}else if(t.keyCode===38){this.handleUpArrow()}else if(t.keyCode===13){if(this.highlightedItem){this.handleItemClick(this.highlightedItem);this.getPopupWindow().close()}if(this.highlightedItem&&this.CurrentItem===this.popupAlertContainer){this.onEmptyValueEvent();return}if(this.CurrentItem&&this.CurrentItem.title.length!==this.targetElement.value.length||!this.CurrentItem&&this.targetElement.value.length>0){this.onEmptyValueEvent();return}if(this.popupWindow&&this.enableCreation){this.destroyPopupWindow()}}else{this.handleTypeInField()}if(this.targetElement.value!==""&&!this.popupWindow){this.showPopupWindow();return}if(t.keyCode===9&&!this.popupWindow){this.showPopupWindow();return}if(t.keyCode===9&&this.targetElement.value===""&&!this.popupWindow){this.showPopupWindow()}if(!this.enableCreation){this.targetElement.addEventListener("keyup",function(t){if(t.key==="Escape"){this.resetInputValue()}}.bind(this));BX.bind(document,"click",this.documentClickHandler)}}.bind(this));this.targetElement.addEventListener("keydown",function(t){if(this.isDisabled){return}if(t.keyCode===9&&this.CurrentItem&&this.CurrentItem.title.length!==this.targetElement.value.length||t.keyCode===9&&!this.CurrentItem&&this.targetElement.value.length>0){this.onEmptyValueEvent();return}if(t.keyCode===9&&!this.popupWindow){this.showPopupWindow();return}if(t.keyCode===9&&this.targetElement.value===""&&!this.popupWindow){this.showPopupWindow();return}if(t.keyCode===9&&this.popupWindow){this.destroyPopupWindow()}}.bind(this))},onDocumentClick:function(){if(this.isTargetElementChanged()){if(!this.enableCreationOnBlur){this.resetInputValue();this.setItems(this.getDefaultItems());BX.cleanNode(this.popupAlertContainer);this.newAlertContainer=null}else{this.onEmptyValueEvent()}}},isTargetElementChanged:function(){return this.CurrentItem&&this.CurrentItem.title.length!==this.targetElement.value.length||!this.CurrentItem&&this.targetElement.value.length>0},getDefaultItems:function(){return this.defaultItems},setDefaultItems:function(t){this.defaultItems=t},getItems:function(){return this.items},updateItemsList:function(t){this.setDefaultItems(t);this.setItems(t)},setItems:function(t){this.items=t;if(this.popupWindow){this.renderItemsToInnerContainer();this.popupWindow.adjustPosition({forceBindPosition:true})}},handleTypeInField:function(){if(!this.isChanged){this.isChanged=true}var t=this.targetElement.value.trim();var e=this.autocompleteDelay===0?true:this.isLastSearchComplete!==false;var i=this.getItemsListContainer();if(!t){this.setItems(this.getDefaultItems());i.classList.remove("ui-dropdown-loader-active");BX.cleanNode(this.popupAlertContainer);this.newAlertContainer=null;this.previousSearchQuery="";BX.onCustomEvent(this,"BX.UI.Dropdown:onReset",[this])}else if(t.length>=this.minSearchStringLength&&t!==this.previousSearchQuery&&e){BX.onCustomEvent(this,"BX.UI.Dropdown:onBeforeSearchStart",[this,t]);clearTimeout(this.ajaxRequestTimer);this.ajaxRequestTimer=setTimeout(this.searchItemsByStrDelayed.bind(this),this.autocompleteDelay);i.classList.add("ui-dropdown-loader-active")}},searchItemsByStrDelayed:function(){this.isLastSearchComplete=false;var t=this.getItemsListContainer();var e=this.targetElement.value.trim();var i={searchQuery:e};BX.onCustomEvent(this,"BX.UI.Dropdown:onSearchStart",[this,i]);this.searchItemsByStr(i.searchQuery).then(function(t){BX.onCustomEvent(this,"BX.UI.Dropdown:onSearchComplete",[this,t]);return t}.bind(this)).then(function(i){if(!this.newAlertContainer&&this.enableCreation&&BX.Type.isDomNode(this.popupAlertContainer)){var n=this.getNewAlertContainer(i);if(BX.Type.isDomNode(n)){this.popupAlertContainer.appendChild(n)}BX.bind(document,"click",this.documentClickHandler)}this.setItems(i);t.classList.remove("ui-dropdown-loader-active");this.showPopupWindow();this.previousSearchQuery=e;this.isLastSearchComplete=true;this.handleTypeInField()}.bind(this))},searchItemsByStr:function(t){return BX.ajax.runAction(this.searchAction,{data:{searchQuery:t,options:this.searchOptions}}).then(this.onSearchRequestSuccess.bind(this))},onSearchRequestSuccess:function(t){return BX.prop.getArray(BX.prop.getObject(t,"data",{}),"items",[])},getFooterItems:function(){return this.footerItems},setFooterItems:function(t){if(Array.isArray(t)){this.footerItems=t}},showPopupWindow:function(){var t=this.getPopupAlertContainer();if(this.getItems().length||this.footerItems||t&&t.textContent.trim().length){this.getPopupWindow().show()}},getPopupWindow:function(){if(!this.popupWindow){this.popupWindow=new BX.PopupWindow("dropdown_"+this.id,this.targetElement,{autoHide:true,content:this.popupConatiner?this.popupContainer:this.getPopupContainer(),contentColor:"white",closeByEsc:true,className:"ui-dropdown-window",events:{onPopupClose:function(){this.popupWindow.destroy();this.popupWindow=null;this.itemListContainer=null;this.itemListInnerContainer=null;this.newAlertContainer=null;this.popupAlertContainer=null}.bind(this)}});if(this.isEmbedded&&this.quickForm){this.popupWindow.setOffset({offsetLeft:this.getQuickFormOffsetWidth()})}}this.setWidthPopup();BX.bind(window,"resize",this.setWidthPopup.bind(this));return this.popupWindow},getQuickFormOffsetWidth:function(){var t=BX.findParent(this.getPopupWindow().bindElement,{className:"crm-kanban-quick-form"});if(!t){return 0}this.popupWindow.popupContainer.style.width=t.offsetWidth+"px";var e=-(this.targetElement.getBoundingClientRect().left-t.getBoundingClientRect().left);return e},setWidthPopup:function(){if(!this.isEmbedded&&this.quickForm){if(this.popupWindow&&this.targetElement){this.popupWindow.popupContainer.style.width=this.targetElement.offsetWidth+"px"}}},onEmptyValueEvent:function(){this.emptyValueEventHandle=window.setTimeout(function(){this.emptyValueEventHandle=0;if(this.enableCreation){BX.onCustomEvent(this,"BX.UI.Dropdown:onAdd",[this,{title:this.targetElement.value}]);this.setItems(this.getDefaultItems());BX.cleanNode(this.popupAlertContainer);this.newAlertContainer=null}else{this.resetInputValue()}}.bind(this),0)},resetInputValue:function(){this.targetElement.value="";BX.onCustomEvent(this,"BX.UI.Dropdown:onReset",[this])},destroyPopupWindow:function(){BX.unbind(document,"click",this.documentClickHandler);if(!this.popupWindow){return}this.popupWindow.close()},getPopupContainer:function(){this.popupContainer=this.getItemsListContainer();this.popupContainer.appendChild(this.getItemsListInnerContainer());this.popupContainer.appendChild(this.getPopupAlertContainer());this.renderItemsToInnerContainer();if(this.footerItems){this.popupContainer.appendChild(this.getLoaderContainer());this.popupContainer.appendChild(this.getFooterContent())}return this.popupContainer},getPopupAlertContainer:function(){if(!this.popupAlertContainer){this.popupAlertContainer=BX.create("div",{attrs:{className:"ui-dropdown-alert-container"}})}return this.popupAlertContainer},getNewAlertContainer:function(t){if(!this.newAlertContainer){this.newAlertContainer=BX.create("div",{props:{className:"ui-dropdown-alert"},children:[this.alertContainerValue=BX.create("div",{attrs:{className:"ui-dropdown-alert-name"},text:this.targetElement.value}),BX.create("div",{attrs:{className:"ui-dropdown-alert-text"},text:BX.prop.getString(this.messages,this.enableCreation?"creationLegend":"notFound",""),events:{click:this.onEmptyValueEvent.bind(this)}})]});BX.onCustomEvent(this,"BX.UI.Dropdown:onGetNewAlertContainer",[this,this.newAlertContainer]);this.targetElement.addEventListener("input",function(){this.alertContainerValue.textContent=this.targetElement.value}.bind(this));if(!this.enableCreation){this.targetElement.addEventListener("input",function(){this.alertContainerValue.style.display="none"}.bind(this))}}if(t.length>0&&!this.enableCreation){this.newAlertContainer.style.display="none"}else{this.newAlertContainer.style.display=""}return this.newAlertContainer},getItemsListContainer:function(){if(!this.itemListContainer){this.itemListContainer=BX.create("div",{attrs:{className:"ui-dropdown-container"}})}return this.itemListContainer},getItemsListInnerContainer:function(){if(!this.itemListInnerContainer){this.itemListInnerContainer=BX.create("div",{attrs:{className:"ui-dropdown-inner"}})}return this.itemListInnerContainer},getItemNodeList:function(){var t=[];this.getItems().forEach((function(e){var i=BX.prop.getObject(e,"attributes",{});var n=BX.prop.getObject(i,"icon",null);var s=BX.prop.getArray(i,"phone",[]);var r=BX.prop.getArray(i,"email",[]);var o=BX.prop.getArray(i,"web",[]);var a=n!==null&&BX.type.isNotEmptyString(n.src)?n.src:"";var h=s.length>0?s[0].value:"";var l=r.length>0?r[0].value:"";var u=o.length>0?o[0].value:"";e.node=BX.create("div",{attrs:{className:"ui-dropdown-item"+(a!==""?" ui-dropdown-item-node-with-icon":"")},events:{click:this.handleItemClick.bind(this,e)},children:[a!==""?BX.create("span",{attrs:{className:"ui-dropdown-item-icon",style:"background-image: url('"+BX.util.htmlspecialchars(a)+"')"},text:""}):null,BX.create("div",{attrs:{className:"ui-dropdown-item-name"},text:e.title}),BX.create("div",{attrs:{className:"ui-dropdown-item-subname"},text:e.subTitle||""}),BX.create("div",{attrs:{className:"ui-dropdown-contact-info"},children:[h!==""?BX.create("div",{attrs:{className:"ui-dropdown-contact-info-item ui-dropdown-item-phone"},text:h}):null,l!==""?BX.create("div",{attrs:{className:"ui-dropdown-contact-info-item ui-dropdown-item-email"},text:l}):null,u!==""?BX.create("div",{attrs:{className:"ui-dropdown-contact-info-item ui-dropdown-item-web"},text:u}):null]})]});t.push(e.node)}),this);return t},renderItemsToInnerContainer:function(){var t=this.getItemsListInnerContainer();BX.cleanNode(t);var e=this.getItemNodeList();for(var i=0;i<e.length;i++){t.appendChild(e[i])}return t},getLoaderContainer:function(){return BX.create("div",{props:{className:"ui-dropdown-loader-container"},html:'<svg class="ui-dropdown-loader" viewBox="25 25 50 50"><circle class="ui-dropdown-loader-path" cx="50" cy="50" r="20" fill="none" stroke-miterlimit="10"></circle><circle class="ui-dropdown-loader-inner-path" cx="50" cy="50" r="20" fill="none" stroke-miterlimit="10"></circle></svg>'})},getFooterContent:function(){var t=BX.create("div",{});this.getFooterItems().forEach((function(e){var i=BX.create("div",{attrs:{className:"ui-dropdown-footer"},children:[BX.create("div",{attrs:{className:"ui-dropdown-caption-box"},children:[BX.create("div",{attrs:{className:"ui-dropdown-caption"},text:e.caption})]})]});e.buttons.forEach((function(t){i.appendChild(BX.create("div",{attrs:{className:"ui-dropdown-button-add"},text:t.caption,events:t.events}))}));t.appendChild(i)}));return t},handleUpArrow:function(){if(this.newAlertContainer&&this.popupAlertContainer.classList.contains("ui-dropdown-item-highlight")){if(this.items&&this.items.length>0){e=this.getItemByIndex(this.items.length-1);this.popupAlertContainer.classList.remove("ui-dropdown-item-highlight");this.cleanHighlightingItem();this.highlightItem(e)}return}if(!this.items){return}var t=this.getHighlightItemIndex();var e=null;if(t===null){e=this.getLastItem()}else{if(this.items.length>=t+1){e=this.getItemByIndex(t-1)}}if(e){this.cleanHighlightingItem();this.highlightItem(e)}},handleDownArrow:function(){var t=this.getHighlightItemIndex();if(this.newAlertContainer&&this.popupAlertContainer.classList.contains("ui-dropdown-item-highlight")){return}if(!this.items||this.items.length===0){if(this.newAlertContainer&&!this.popupAlertContainer.classList.contains("ui-dropdown-item-highlight")){this.popupAlertContainer.classList.add("ui-dropdown-item-highlight")}return}if(t===this.items.length-1){if(this.newAlertContainer&&!this.popupAlertContainer.classList.contains("ui-dropdown-item-highlight")){this.cleanHighlightingItem();this.popupAlertContainer.classList.add("ui-dropdown-item-highlight")}return}var e=null;if(t===null){e=this.getFirstItem()}else{e=this.getItemByIndex(t+1)}if(e){this.cleanHighlightingItem();this.highlightItem(e)}},scrollToItem:function(){var t=this.getItemsListInnerContainer();var e=t.getBoundingClientRect();var i=this.highlightedItem.node.getBoundingClientRect();var n=e.bottom-i.bottom;var s=e.top-i.top;if(n<0){t.scrollTop=t.scrollTop+Math.abs(n)}else if(s>0){t.scrollTop=t.scrollTop-s}},highlightItem:function(t){t.node.classList.add("ui-dropdown-item-highlight");this.highlightedItem=t;this.scrollToItem()},cleanHighlightingItem:function(){if(this.highlightedItem){this.highlightedItem.node.classList.remove("ui-dropdown-item-highlight")}this.highlightedItem=null},getHighlightItemIndex:function(){var t=null;var e=this.getItems();for(var i=0;i<e.length;i++){if(e[i].node.classList.contains("ui-dropdown-item-highlight")){return i}}return t},getItemIndex:function(t){var e=this.getItems();for(var i=0;i<e.length;i++){if(e[i]===t){return i}}return false},getFirstItem:function(){if(!this.items||this.items.length===0){return null}return this.items[0]},getLastItem:function(){var t=this.getItems();if(!t){return}return t[t.length-1]},getItemByIndex:function(t){var e=this.getItems();if(e[t]){return e[t]}return null},handleItemClick:function(t,e){if(this.emptyValueEventHandle>0){window.clearTimeout(this.emptyValueEventHandle);this.emptyValueEventHandle=0}this.CurrentItem=t;BX.onCustomEvent(this,"BX.UI.Dropdown:onSelect",[this,t])},selectTargetElementValue:function(){this.targetElement.select();this.targetElement.focus()},disableTargetElement:function(){this.targetElement.select();this.targetElement.focus();this.targetElement.addEventListener("keyup",function(t){var e=t.charCode||t.keyCode;if(this.targetElement===document.activeElement){if(e===8){return true}else if(e===37||e===39){if(this.targetElement.value.length>0&&this.targetElement===document.activeElement){this.selectTargetElementValue()}}else if(this.targetElement.value.length>0&&this.targetElement===document.activeElement){return true}else{BX.PreventDefault(t)}}}.bind(this))},enableTargetElement:function(){this.targetElement.addEventListener("keyup",function(){return true}.bind(this))}};BX.UI.DropdownUser=function(t){BX.UI.Dropdown.call(this,t)};BX.UI.DropdownUser.prototype={__proto__:BX.UI.Dropdown.prototype,renderItem:function(t){itemsContainer.appendChild(BX.create("div",{attrs:{className:"ui-dropdown-item ui-dropdown-item-user"},children:[BX.create("div",{attrs:{className:"ui-dropdown-item-icon"},text:t.user}),BX.create("div",{attrs:{className:"ui-dropdown-info-box"},children:[BX.create("div",{attrs:{className:"ui-dropdown-item-name"},text:t.title}),BX.create("div",{attrs:{className:"ui-dropdown-item-subname"},text:t.subtitle}),BX.create("div",{attrs:{className:"ui-dropdown-item-value"},text:t.value})]})]}))}}})();
//# sourceMappingURL=dropdown.map.js