(function(){"use strict";BX.namespace("BX.UI");BX.UI.IButton=function(){};BX.UI.IButton.prototype={render:function(){throw new Error("Must be implemented by subclass")}};BX.UI.BaseButton=function(t){t=BX.type.isPlainObject(t)?t:{};this.button=t.buttonContainer||null;this.text="";this.props={};this.events={};this.handleEvent=this.handleEvent.bind(this);this.tag=this.isEnumValue(t.tag,BX.UI.Button.Tag)?t.tag:BX.UI.Button.Tag.BUTTON;this.baseClass=BX.type.isNotEmptyString(t.baseClass)?t.baseClass:"ui-btn";this.setText(t.text);this.setProps(t.props);this.setDataSet(t.dataset);this.addClass(t.className);this.bindEvent("click",t.onclick);this.bindEvents(t.events)};BX.namespace("BX.UI.ButtonManager");BX.UI.ButtonManager.buttons={};BX.UI.ButtonManager.createFromNode=function(t,n){n=BX.type.isPlainObject(n)?n:{};if(!BX.type.isDomNode(t)){throw new Error("BX.UI.Button.Manager.buildByNode: {node} has to be DomNode.")}var e=t.dataset.jsonOptions?JSON.parse(t.dataset.jsonOptions):{};if(!e.jsClass||!BX.getClass(e.jsClass)){throw new Error("BX.UI.Button.Manager.buildByNode: {jsonOptions.jsClass} has to be set.")}if(t.nodeName==="A"){n.tag=BX.UI.Button.Tag.LINK}else if(t.nodeName==="BUTTON"){n.tag=BX.UI.Button.Tag.BUTTON}else if(t.nodeName==="INPUT"&&t.type==="button"){n.tag=BX.UI.Button.Tag.INPUT}else if(t.nodeName==="INPUT"&&t.type==="submit"){n.tag=BX.UI.Button.Tag.SUBMIT}n.props=BX.type.isPlainObject(n.props)?n.props:{};if(!n.props.hasOwnProperty("disabled")&&t.disabled){n.props.disabled=n.props}for(var i in BX.UI.Button.Size){if(!BX.UI.Button.Size.hasOwnProperty(i)){continue}if(t.classList.contains(BX.UI.Button.Size[i])){n.size=BX.UI.Button.Size[i]}}for(var o in BX.UI.Button.Color){if(!BX.UI.Button.Color.hasOwnProperty(o)){continue}if(t.classList.contains(BX.UI.Button.Color[o])){n.color=BX.UI.Button.Color[o]}}for(var s in BX.UI.Button.State){if(!BX.UI.Button.State.hasOwnProperty(s)){continue}if(t.classList.contains(BX.UI.Button.State[s])){n.state=BX.UI.Button.State[s]}}for(var u in BX.UI.Button.Icon){if(!BX.UI.Button.Icon.hasOwnProperty(u)){continue}if(t.classList.contains(BX.UI.Button.Icon[u])){n.icon=BX.UI.Button.Icon[u]}}n=BX.mergeEx(n,e);n.buttonContainer=t;var B=BX.getClass(e.jsClass);if(B.prototype instanceof BX.UI.SplitButton||e.jsClass==="BX.UI.SplitButton"){var r=n.querySelectors;if(r){var a=r.mainButton?document.querySelector(r.mainButton):null;var l=r.menuButton?document.querySelector(r.menuButton):null;n.mainButton?n.mainButton.buttonContainer=a:null;n.menuButton?n.menuButton.buttonContainer=l:null}}var c=function(t){if(BX.type.isFunction(t)){return t}if(!BX.type.isObject(t)){throw"Event handler must be described as object or function."}if(BX.type.isString(t.handler)){return function(){var n=BX.getClass(t.handler);if(BX.type.isFunction(n)){var e=this;if(t.context){e=BX.getClass(t.context)}return n.apply(e,arguments)}console.warn("Be aware, the handler "+t.handler+" is not a function.");return null}}return null};var p=function(t){if(BX.type.isPlainObject(t)){for(var n in t){t[n]=c(t[n])}}};var h=function(t){if(BX.type.isArray(t)){t.forEach(function(t){if(t.onclick){t.onclick=c(t.onclick)}if(BX.type.isArray(t.items)){h(t.items)}})}};if(n.click){n.click=c(n.click)}p(n.events);n.mainButton&&p(n.mainButton.events);n.menuButton&&p(n.menuButton.events);n.menu&&h(n.menu.items);var I=new B(n);BX.UI.ButtonManager.buttons[I.getDataSet()["btnUniqid"]]=I;return I};BX.UI.ButtonManager.getByUniqid=function(t){if(BX.UI.ButtonManager.buttons[t]){return BX.UI.ButtonManager.buttons[t]}return null};BX.UI.BaseButton.prototype={__proto__:BX.UI.IButton.prototype,constructor:BX.UI.BaseButton,render:function(){return this.getContainer()},renderTo:function(t){if(BX.type.isDomNode(t)){return t.appendChild(this.getContainer())}return null},getContainer:function(){if(this.button!==null){return this.button}switch(this.getTag()){case BX.UI.Button.Tag.BUTTON:default:this.button=BX.create("button",{props:{className:this.getBaseClass()}});break;case BX.UI.Button.Tag.INPUT:this.button=BX.create("input",{props:{className:this.getBaseClass()},attrs:{type:"button"}});break;case BX.UI.Button.Tag.LINK:this.button=BX.create("a",{props:{className:this.getBaseClass(),href:""}});break;case BX.UI.Button.Tag.SUBMIT:this.button=BX.create("input",{props:{className:this.getBaseClass()},attrs:{type:"submit"}});break}return this.button},getBaseClass:function(){return this.baseClass},setText:function(t){if(BX.type.isString(t)){this.text=t;if(this.isInputType()){this.getContainer().value=t}else{this.getContainer().textContent=t}}return this},getText:function(){return this.text},getTag:function(){return this.tag},setProps:function(t){if(!BX.type.isPlainObject(t)){return this}for(var n in t){var e=t[n];if(e===null){this.getContainer().removeAttribute(n);delete this.props[n]}else{this.getContainer().setAttribute(n,e);this.props[n]=e}}return this},getProps:function(){return this.props},setDataSet:function(t){if(!BX.type.isPlainObject(t)){return this}for(var n in t){var e=t[n];if(e===null){delete this.getDataSet()[n]}else{this.getDataSet()[n]=e}}return this},getDataSet:function(){return this.getContainer().dataset},addClass:function(t){if(BX.type.isNotEmptyString(t)){BX.addClass(this.getContainer(),t)}return this},removeClass:function(t){if(BX.type.isNotEmptyString(t)){BX.removeClass(this.getContainer(),t)}return this},setDisabled:function(t){if(t===false){this.setProps({disabled:null})}else{this.setProps({disabled:true})}return this},isDisabled:function(){return this.getProps().disabled===true},isInputType:function(){return this.getTag()===BX.UI.Button.Tag.SUBMIT||this.getTag()===BX.UI.Button.Tag.INPUT},bindEvents:function(t){if(BX.type.isPlainObject(t)){for(var n in t){var e=t[n];this.bindEvent(n,e)}}return this},unbindEvents:function(t){if(BX.type.isArray(t)){t.forEach(function(t){this.unbindEvent(t)},this)}return this},bindEvent:function(t,n){if(BX.type.isNotEmptyString(t)&&BX.type.isFunction(n)){this.unbindEvent(t);this.events[t]=n;this.getContainer().addEventListener(t,this.handleEvent)}return this},unbindEvent:function(t){if(this.events[t]){delete this.events[t];this.getContainer().removeEventListener(t,this.handleEvent)}return this},handleEvent:function(t){var n=t.type;if(this.events[n]){var e=this.events[n];e.call(this,this,t)}},isEnumValue:function(t,n){for(var e in n){if(n[e]===t){return true}}return false}};BX.UI.Button=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.BaseButton.call(this,t);this.size=null;this.color=null;this.icon=null;this.state=null;this.id=null;this.context=null;this.menuWindow=null;this.handleMenuClick=this.handleMenuClick.bind(this);this.handleMenuClose=this.handleMenuClose.bind(this);this.setSize(t.size);this.setColor(t.color);this.setIcon(t.icon);this.setState(t.state);this.setId(t.id);this.setMenu(t.menu);this.setContext(t.context);t.noCaps&&this.setNoCaps();t.round&&this.setRound();if(t.dropdown||this.getMenuWindow()&&t.dropdown!==false){this.setDropdown()}};BX.UI.Button.Size={LARGE:"ui-btn-lg",MEDIUM:"ui-btn-md",SMALL:"ui-btn-sm",EXTRA_SMALL:"ui-btn-xs"};BX.UI.Button.Color={DANGER:"ui-btn-danger",DANGER_DARK:"ui-btn-danger-dark",DANGER_LIGHT:"ui-btn-danger-light",SUCCESS:"ui-btn-success",SUCCESS_DARK:"ui-btn-success-dark",SUCCESS_LIGHT:"ui-btn-success-light",PRIMARY_DARK:"ui-btn-primary-dark",PRIMARY:"ui-btn-primary",SECONDARY:"ui-btn-secondary",LINK:"ui-btn-link",LIGHT:"ui-btn-light",LIGHT_BORDER:"ui-btn-light-border"};BX.UI.Button.State={HOVER:"ui-btn-hover",ACTIVE:"ui-btn-active",DISABLED:"ui-btn-disabled",CLOCKING:"ui-btn-clock",WAITING:"ui-btn-wait"};BX.UI.Button.Icon={UNFOLLOW:"ui-btn-icon-unfollow",FOLLOW:"ui-btn-icon-follow",ADD:"ui-btn-icon-add",STOP:"ui-btn-icon-stop",START:"ui-btn-icon-start",PAUSE:"ui-btn-icon-pause",ADD_FOLDER:"ui-btn-icon-add-folder",SETTING:"ui-btn-icon-setting",TASK:"ui-btn-icon-task",INFO:"ui-btn-icon-info",SEARCH:"ui-btn-icon-search",PRINT:"ui-btn-icon-print",LIST:"ui-btn-icon-list",BUSINESS:"ui-btn-icon-business",BUSINESS_CONFIRM:"ui-btn-icon-business-confirm",BUSINESS_WARNING:"ui-btn-icon-business-warning",CAMERA:"ui-btn-icon-camera",PHONE_UP:"ui-btn-icon-phone-up",PHONE_DOWN:"ui-btn-icon-phone-down",PHONE_CALL:"ui-btn-icon-phone-call",BACK:"ui-btn-icon-back",REMOVE:"ui-btn-icon-remove",DOWNLOAD:"ui-btn-icon-download",DONE:"ui-btn-icon-done",DISK:"ui-btn-icon-disk",LOCK:"ui-btn-icon-lock",MAIL:"ui-btn-icon-mail",CHAT:"ui-btn-icon-chat",PAGE:"ui-btn-icon-page",CLOUD:"ui-btn-icon-cloud",EDIT:"ui-btn-icon-edit",SHARE:"ui-btn-icon-share"};BX.UI.Button.Tag={BUTTON:0,LINK:1,SUBMIT:2,INPUT:3};BX.UI.Button.Style={NO_CAPS:"ui-btn-no-caps",ROUND:"ui-btn-round",DROPDOWN:"ui-btn-dropdown"};BX.UI.Button.prototype={__proto__:BX.UI.BaseButton.prototype,constructor:BX.UI.Button,setSize:function(t){return this.setProperty("size",t,BX.UI.Button.Size)},getSize:function(){return this.size},setColor:function(t){return this.setProperty("color",t,BX.UI.Button.Color)},getColor:function(){return this.color},setIcon:function(t){this.setProperty("icon",t,BX.UI.Button.Icon);if(this.isInputType()&&this.getIcon()!==null){throw"Input type button cannot have an icon."}return this},getIcon:function(){return this.icon},setState:function(t){return this.setProperty("state",t,BX.UI.Button.State)},getState:function(){return this.state},setNoCaps:function(t){if(t===false){BX.removeClass(this.getContainer(),BX.UI.Button.Style.NO_CAPS)}else{BX.addClass(this.getContainer(),BX.UI.Button.Style.NO_CAPS)}return this},setRound:function(t){if(t===false){BX.removeClass(this.getContainer(),BX.UI.Button.Style.ROUND)}else{BX.addClass(this.getContainer(),BX.UI.Button.Style.ROUND)}return this},setDropdown:function(t){if(t===false){BX.removeClass(this.getContainer(),BX.UI.Button.Style.DROPDOWN)}else{BX.addClass(this.getContainer(),BX.UI.Button.Style.DROPDOWN)}return this},setMenu:function(t){if(BX.type.isPlainObject(t)&&BX.type.isArray(t.items)&&t.items.length>0){this.setMenu(false);this.menuWindow=new BX.PopupMenuWindow("ui-btn-menu-"+BX.util.getRandomString().toLowerCase(),this.getMenuBindElement(),t.items,t);BX.addCustomEvent(this.menuWindow.getPopupWindow(),"onPopupClose",this.handleMenuClose);this.getMenuClickElement().addEventListener("click",this.handleMenuClick)}else if(t===false&&this.menuWindow!==null){this.menuWindow.close();BX.removeCustomEvent(this.menuWindow.getPopupWindow(),"onPopupClose",this.handleMenuClose);this.getMenuClickElement().removeEventListener("click",this.handleMenuClick);this.menuWindow.destroy();this.menuWindow=null}},getMenuBindElement:function(){return this.getContainer()},getMenuClickElement:function(){return this.getContainer()},handleMenuClick:function(t){this.getMenuWindow().show();this.setActive(this.getMenuWindow().getPopupWindow().isShown())},handleMenuClose:function(){this.setActive(false)},getMenuWindow:function(){return this.menuWindow},setId:function(t){if(BX.type.isNotEmptyString(t)||t===null){this.id=t}return this},getId:function(){return this.id},setActive:function(t){return this.setState(t===false?null:BX.UI.Button.State.ACTIVE)},isActive:function(){return this.getState()===BX.UI.Button.State.ACTIVE},setHovered:function(t){return this.setState(t===false?null:BX.UI.Button.State.HOVER)},isHover:function(){return this.getState()===BX.UI.Button.State.HOVER},setDisabled:function(t){this.setState(t===false?null:BX.UI.Button.State.DISABLED);BX.UI.BaseButton.prototype.setDisabled.call(this,t);return this},isDisabled:function(){return this.getState()===BX.UI.Button.State.DISABLED},setWaiting:function(t){if(t===false){this.setState(null);this.setProps({disabled:null})}else{this.setState(BX.UI.Button.State.WAITING);this.setProps({disabled:true})}return this},isWaiting:function(){return this.getState()===BX.UI.Button.State.WAITING},setClocking:function(t){if(t===false){this.setState(null);this.setProps({disabled:null})}else{this.setState(BX.UI.Button.State.CLOCKING);this.setProps({disabled:true})}return this},isClocking:function(){return this.getState()===BX.UI.Button.State.CLOCKING},setProperty:function(t,n,e){if(this.isEnumValue(n,e)){BX.removeClass(this.getContainer(),this[t]);BX.addClass(this.getContainer(),n);this[t]=n}else if(n===null){BX.removeClass(this.getContainer(),this[t]);this[t]=null}return this},setContext:function(t){if(t!==undefined){this.context=t}},getContext:function(){return this.context}};BX.UI.SaveButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.Button.call(this,t);this.setText(BX.message("UI_BUTTONS_SAVE_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.SUCCESS);this.setColor(t.color)};BX.UI.SaveButton.prototype={__proto__:BX.UI.Button.prototype,constructor:BX.UI.SaveButton};BX.UI.CreateButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.Button.call(this,t);this.setText(BX.message("UI_BUTTONS_CREATE_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.SUCCESS);this.setColor(t.color)};BX.UI.CreateButton.prototype={__proto__:BX.UI.Button.prototype,constructor:BX.UI.CreateButton};BX.UI.AddButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.Button.call(this,t);this.setText(BX.message("UI_BUTTONS_ADD_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.SUCCESS);this.setColor(t.color)};BX.UI.AddButton.prototype={__proto__:BX.UI.Button.prototype,constructor:BX.UI.AddButton};BX.UI.SendButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.Button.call(this,t);this.setText(BX.message("UI_BUTTONS_SEND_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.SUCCESS);this.setColor(t.color)};BX.UI.SendButton.prototype={__proto__:BX.UI.Button.prototype,constructor:BX.UI.SendButton};BX.UI.ApplyButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.Button.call(this,t);this.setText(BX.message("UI_BUTTONS_APPLY_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.LIGHT_BORDER);this.setColor(t.color)};BX.UI.ApplyButton.prototype={__proto__:BX.UI.Button.prototype,constructor:BX.UI.ApplyButton};BX.UI.CancelButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.Button.call(this,t);this.setText(BX.message("UI_BUTTONS_CANCEL_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.LINK);this.setColor(t.color)};BX.UI.CancelButton.prototype={__proto__:BX.UI.Button.prototype,constructor:BX.UI.CancelButton};BX.UI.CloseButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.Button.call(this,t);this.setText(BX.message("UI_BUTTONS_CLOSE_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.LINK);this.setColor(t.color)};BX.UI.CloseButton.prototype={__proto__:BX.UI.Button.prototype,constructor:BX.UI.CloseButton};BX.UI.SplitButton=function(t){t=BX.type.isPlainObject(t)?t:{};delete t.tag;delete t.round;var n=BX.type.isPlainObject(t.mainButton)?t.mainButton:{};var e=BX.type.isPlainObject(t.menuButton)?t.menuButton:{};n.buttonType=BX.UI.SplitSubButton.Type.MAIN;e.buttonType=BX.UI.SplitSubButton.Type.MENU;this.mainButton=new BX.UI.SplitSubButton(n);this.menuButton=new BX.UI.SplitSubButton(e);this.mainButton.setSplitButton(this);this.menuButton.setSplitButton(this);this.menuTarget=BX.UI.SplitSubButton.Type.MAIN;if(t.menuTarget===BX.UI.SplitSubButton.Type.MENU){this.menuTarget=BX.UI.SplitSubButton.Type.MENU}BX.UI.Button.call(this,t)};BX.UI.SplitButton.State={HOVER:"ui-btn-hover",MAIN_HOVER:"ui-btn-main-hover",MENU_HOVER:"ui-btn-menu-hover",ACTIVE:"ui-btn-active",MAIN_ACTIVE:"ui-btn-main-active",MENU_ACTIVE:"ui-btn-menu-active",DISABLED:"ui-btn-disabled",MAIN_DISABLED:"ui-btn-main-disabled",MENU_DISABLED:"ui-btn-menu-disabled",CLOCKING:"ui-btn-clock",WAITING:"ui-btn-wait"};BX.UI.SplitButton.prototype={__proto__:BX.UI.Button.prototype,constructor:BX.UI.SplitButton,getContainer:function(){if(this.button===null){this.button=BX.create("div",{props:{className:"ui-btn-split"},children:[this.getMainButton().getContainer(),this.getMenuButton().getContainer()]})}return this.button},getMainButton:function(){return this.mainButton},getMenuButton:function(){return this.menuButton},setText:function(t){if(BX.type.isString(t)){this.getMainButton().setText(t)}return this},setState:function(t){return this.setProperty("state",t,BX.UI.SplitButton.State)},setDisabled:function(t){this.setState(t===false?null:BX.UI.Button.State.DISABLED);this.getMainButton().setDisabled(t);this.getMenuButton().setDisabled(t);return this},getMenuBindElement:function(){if(this.getMenuTarget()===BX.UI.SplitSubButton.Type.MENU){return this.getMenuButton().getContainer()}else{return this.getContainer()}},handleMenuClick:function(t){this.getMenuWindow().show();var n=this.getMenuWindow().getPopupWindow().isShown();this.getMenuButton().setActive(n)},handleMenuClose:function(t){this.getMenuButton().setActive(false)},getMenuClickElement:function(){return this.getMenuButton().getContainer()},getMenuTarget:function(){return this.menuTarget},setRound:function(t){throw new Error("BX.UI.SplitButton can't be round.")},setDropdown:function(t){return this}};BX.UI.SplitSubButton=function(t){t=BX.type.isPlainObject(t)?t:{};this.splitButton=null;this.buttonType=t.buttonType===BX.UI.SplitSubButton.Type.MAIN?BX.UI.SplitSubButton.Type.MAIN:BX.UI.SplitSubButton.Type.MENU;t.baseClass=this.buttonType;BX.UI.BaseButton.call(this,t);if(this.isInputType()){throw"Split button cannot be an input tag."}};BX.UI.SplitSubButton.Type={MAIN:"ui-btn-main",MENU:"ui-btn-menu"};BX.UI.SplitSubButton.prototype={__proto__:BX.UI.BaseButton.prototype,constructor:BX.UI.SplitSubButton,setSplitButton:function(t){this.splitButton=t},getSplitButton:function(){return this.splitButton},isMainButton:function(){return this.buttonType===BX.UI.SplitSubButton.Type.MAIN},isMenuButton:function(){return this.buttonType===BX.UI.SplitSubButton.Type.MENU},setActive:function(t){this.toggleState(t,BX.UI.SplitButton.State.ACTIVE,BX.UI.SplitButton.State.MAIN_ACTIVE,BX.UI.SplitButton.State.MENU_ACTIVE);return this},isActive:function(){var t=this.getSplitButton().getState();if(t===BX.UI.SplitButton.State.ACTIVE){return true}if(this.isMainButton()){return t===BX.UI.SplitButton.State.MAIN_ACTIVE}else{return t===BX.UI.SplitButton.State.MENU_ACTIVE}},setDisabled:function(t){this.toggleState(t,BX.UI.SplitButton.State.DISABLED,BX.UI.SplitButton.State.MAIN_DISABLED,BX.UI.SplitButton.State.MENU_DISABLED);BX.UI.BaseButton.prototype.setDisabled.call(this,t);return this},setHovered:function(t){this.toggleState(t,BX.UI.SplitButton.State.HOVER,BX.UI.SplitButton.State.MAIN_HOVER,BX.UI.SplitButton.State.MENU_HOVER);return this},isHovered:function(){var t=this.getSplitButton().getState();if(t===BX.UI.SplitButton.State.HOVER){return true}if(this.isMainButton()){return t===BX.UI.SplitButton.State.MAIN_HOVER}else{return t===BX.UI.SplitButton.State.MENU_HOVER}},toggleState:function(t,n,e,i){var o=this.getSplitButton().getState();if(t===false){if(o===n){this.getSplitButton().setState(this.isMainButton()?i:e)}else{this.getSplitButton().setState(null)}}else{if(o===e&&this.isMenuButton()){this.getSplitButton().setState(n)}else if(o===i&&this.isMainButton()){this.getSplitButton().setState(n)}else if(o!==n){this.getSplitButton().setState(this.isMainButton()?e:i)}}}};BX.UI.SaveSplitButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.SplitButton.call(this,t);this.setText(BX.message("UI_BUTTONS_SAVE_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.SUCCESS);this.setColor(t.color)};BX.UI.SaveSplitButton.prototype={__proto__:BX.UI.SplitButton.prototype,constructor:BX.UI.SaveSplitButton};BX.UI.CreateSplitButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.SplitButton.call(this,t);this.setText(BX.message("UI_BUTTONS_CREATE_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.SUCCESS);this.setColor(t.color)};BX.UI.CreateSplitButton.prototype={__proto__:BX.UI.SplitButton.prototype,constructor:BX.UI.CreateSplitButton};BX.UI.AddSplitButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.SplitButton.call(this,t);this.setText(BX.message("UI_BUTTONS_ADD_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.SUCCESS);this.setColor(t.color)};BX.UI.AddSplitButton.prototype={__proto__:BX.UI.SplitButton.prototype,constructor:BX.UI.AddSplitButton};BX.UI.SendSplitButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.SplitButton.call(this,t);this.setText(BX.message("UI_BUTTONS_SEND_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.SUCCESS);this.setColor(t.color)};BX.UI.SendSplitButton.prototype={__proto__:BX.UI.SplitButton.prototype,constructor:BX.UI.SendSplitButton};BX.UI.ApplySplitButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.SplitButton.call(this,t);this.setText(BX.message("UI_BUTTONS_APPLY_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.LIGHT_BORDER);this.setColor(t.color)};BX.UI.ApplySplitButton.prototype={__proto__:BX.UI.SplitButton.prototype,constructor:BX.UI.ApplySplitButton};BX.UI.CancelSplitButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.SplitButton.call(this,t);this.setText(BX.message("UI_BUTTONS_CANCEL_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.LINK);this.setColor(t.color)};BX.UI.CancelSplitButton.prototype={__proto__:BX.UI.SplitButton.prototype,constructor:BX.UI.CancelSplitButton};BX.UI.CloseSplitButton=function(t){t=BX.type.isPlainObject(t)?t:{};BX.UI.SplitButton.call(this,t);this.setText(BX.message("UI_BUTTONS_CLOSE_BTN_TEXT"));this.setText(t.text);this.setColor(BX.UI.Button.Color.LINK);this.setColor(t.color)};BX.UI.CloseSplitButton.prototype={__proto__:BX.UI.SplitButton.prototype,constructor:BX.UI.CloseSplitButton}})();
//# sourceMappingURL=ui.buttons.map.js