(function(){"use strict";BX.namespace("BX.Translate");if(BX.Translate.Process){return}BX.Translate.Process=function(){this.id="";this.settings={};this.controller="";this.controllerDefault="";this.action="";this.method="POST";this.params={};this.xhr=null;this.option={};this.state=this.STATES.intermediate;this.isRequestRunning=false;this.messages={};this.dialog=null;this.queue=[];this.currentStep=-1;this.sToken="";this.cToken="";this.token="";this.handlers={}};BX.Translate.Process.prototype={STATES:{intermediate:"INTERMEDIATE",running:"RUNNING",completed:"COMPLETED",stopped:"STOPPED",error:"ERROR",canceling:"CANCELING"},STATUSES:{progress:"PROGRESS",completed:"COMPLETED"},init:function(t){this.settings=t?t:{};this.id=BX.type.isNotEmptyString(this.settings.id)?this.settings.id:"TranslateProcess_"+Math.random().toString().substring(2);this.controller=this.getSetting("controller","");if(!BX.type.isNotEmptyString(this.controller)){throw"BX.Translate.Process: Could not find ajax controller endpoint."}this.controllerDefault=this.controller;this.method=this.getSetting("method","POST");this.action=this.getSetting("action","");if(!BX.type.isNotEmptyString(this.action)){this.action=""}this.queue=this.getSetting("queue");if(!BX.type.isArray(this.queue)){this.queue=[]}this.params=this.getSetting("params");if(!this.params){this.params={}}this.messages=this.getSetting("messages");if(!this.messages){this.messages={}}var e=this.getSetting("optionsFields");if(!e){this.setSetting("optionsFields",{})}this.handlers=this.getSetting("handlers");if(!this.handlers){this.handlers={}}this.sToken=this.getSetting("sToken","");if(!BX.type.isNotEmptyString(this.sToken)){throw"BX.Translate.Process: parameter 'sToken' is not found."}this.refreshToken()},refreshToken:function(){this.cToken="c"+Date.now();this.token=this.sToken+this.cToken;this.setParam("PROCESS_TOKEN",this.token);return this},addQueueItem:function(t){this.queue.push(t);return this},getQueueLength:function(){return this.queue.length},setOptionFieldValue:function(t,e){var s=this.getSetting("optionsFields");if(s[t]){s[t].value=e}return this},saveOptionFieldValues:function(t){var e={};if("sessionStorage"in window){var s,i,r=this.getSetting("optionsFields");for(i in r){if(r.hasOwnProperty(i)){s=r[i];switch(s["type"]){case"checkbox":case"select":case"radio":if(i in t){e[i]=t[i]}break}}}}if(BX.type.isNotEmptyObject(e)){window.sessionStorage.setItem("bx.translate.options."+this.getId(),JSON.stringify(e))}},loadOptionFieldValues:function(){var t={};if("sessionStorage"in window){t=JSON.parse(window.sessionStorage.getItem("bx.translate.options."+this.getId()));if(!BX.type.isPlainObject(t)){t={}}}return t},getDialog:function(){if(!(this.dialog instanceof BX.Translate.ProcessDialog)){this.dialog=BX.Translate.ProcessDialogManager.create({id:this.id,optionsFields:this.getSetting("optionsFields",{}),optionsFieldsValue:this.loadOptionFieldValues(),messages:{title:this.getMessage("DialogTitle"),summary:this.getMessage("DialogSummary"),startButton:this.getMessage("DialogStartButton"),stopButton:this.getMessage("DialogStopButton"),closeButton:this.getMessage("DialogCloseButton"),downloadButton:this.getMessage("DialogExportDownloadButton"),clearButton:this.getMessage("DialogExportClearButton")},showButtons:this.getSetting("showButtons"),handlers:{start:BX.delegate(this.start,this),stop:BX.delegate(this.stop,this),dialogShown:typeof this.handlers.dialogShown=="function"?this.handlers.dialogShown:null,dialogClosed:typeof this.handlers.dialogClosed=="function"?this.handlers.dialogClosed:null}})}return this.dialog},showDialog:function(){this.getDialog().setSetting("optionsFieldsValue",this.loadOptionFieldValues()).show();if(!this.isRequestRunning){this.setState(this.STATES.intermediate)}return this},closeDialog:function(){if(this.isRequestRunning){this.stop()}this.getDialog().close();return this},destroy:function(){if(this.dialog instanceof BX.Translate.ProcessDialog){this.dialog.close();BX.Translate.ProcessDialogManager.delete(this.dialog.getId());this.dialog=null}if(this.xhr instanceof XMLHttpRequest){try{this.xhr.abort()}catch(t){}this.xhr=null}},getId:function(){return this.id},getSetting:function(t,e){return this.settings.hasOwnProperty(t)?this.settings[t]:e},setSetting:function(t,e){this.settings[t]=e;return this},getMessage:function(t,e){var s="";e=e||{};if(BX.type.isNotEmptyString(this.messages[t])){s=this.messages[t];if(BX.type.isPlainObject(e)){for(var i in e){if(e.hasOwnProperty(i)){s=s.replace("#"+i+"#",e[i])}}}}return s},getState:function(){return this.state},getController:function(){return this.controller},setController:function(t){this.controller=t;return this},getAction:function(){return this.action},setAction:function(t){this.action=t;return this},getParams:function(){return this.params},setParams:function(t){this.params=t;return this},getParam:function(t){return this.params[t]?this.params[t]:null},setParam:function(t,e){this.params[t]=e;return this},callHandler:function(t,e){if(typeof this.handlers[t]=="function"){this.handlers[t].apply(this,e)}},setHandler:function(t,e){if(typeof e=="function"){this.handlers[t]=e}return this},callAction:function(t){this.setAction(t);this.refreshToken();this.startRequest()},start:function(t){this.refreshToken();t=t||1;if(this.state===this.STATES.intermediate||this.state===this.STATES.stopped||this.state===this.STATES.completed){if(!this.getDialog().checkOptions()){return}this.getDialog().setError("").setWarning("");if(this.getQueueLength()>0){this.currentStep=0;if(t>1){this.currentStep=t-1}if(BX.type.isNotEmptyString(this.queue[this.currentStep].controller)){this.setController(this.queue[this.currentStep].controller)}if(!BX.type.isNotEmptyString(this.queue[this.currentStep].action)){throw"BX.Translate.Process: Could not find controller action at the queue position."}this.setAction(this.queue[this.currentStep].action);this.startRequest();this.getDialog().setSummary(this.queue[this.currentStep].title)}else{this.startRequest()}}return this},stop:function(){if(this.state===this.STATES.running){this.stopRequest();this.currentStep=-1}return this},setState:function(t,e){if(this.state===t){return this}e=e?e:{};this.state=t;if(t===this.STATES.intermediate||t===this.STATES.stopped){this.getDialog().lockButton("start",false);this.getDialog().lockButton("stop",true);this.getDialog().showButton("close",true)}else if(t===this.STATES.running){this.getDialog().lockButton("start",true);this.getDialog().lockButton("stop",false);this.getDialog().showButton("close",false)}else if(t===this.STATES.canceling){this.getDialog().lockButton("start",true);this.getDialog().lockButton("stop",true);this.getDialog().showButton("close",false);this.getDialog().hideProgressBar()}else if(t===this.STATES.error){this.getDialog().lockButton("start",true);this.getDialog().lockButton("stop",true);this.getDialog().showButton("close",true)}else if(t===this.STATES.completed){this.getDialog().lockButton("start",true);this.getDialog().lockButton("stop",true);this.getDialog().showButton("close",true);this.getDialog().hideProgressBar()}this.callHandler("StateChanged",[t,e]);BX.onCustomEvent(this,"BX.Translate.Process.StateChanged",[this,t,e]);return this},startRequest:function(){if(this.isRequestRunning||this.state===this.STATES.canceling){return}this.isRequestRunning=true;var t=new FormData;function e(e){if(BX.type.isNotEmptyObject(e)){for(var s in e){if(e.hasOwnProperty(s)){t.append(s,e[s])}}}}e(this.params);e(this.queue[this.currentStep].params);var s=this.getDialog().getOptions();if(BX.type.isNotEmptyObject(s)){e(s);this.option=s;this.saveOptionFieldValues(s)}else if(BX.type.isNotEmptyObject(this.option)){for(var i in this.option){if(this.option.hasOwnProperty(i)){if(this.option[i]instanceof File){delete this.option[i]}}}e(this.option)}this.setState(this.STATES.running);this.callHandler("RequestStart",[t]);BX.onCustomEvent(this,"BX.Translate.Process.BeforeRequestStart",[this,t]);BX.ajax.runAction(this.controller+"."+this.getAction(),{data:t,method:this.method,onrequeststart:BX.delegate(this.onRequestStart,this)}).then(BX.delegate(this.onRequestSuccess,this),BX.delegate(this.onRequestFailure,this))},stopRequest:function(){if(this.state===this.STATES.canceling){return}this.setState(this.STATES.canceling);if(this.xhr instanceof XMLHttpRequest){try{this.xhr.abort()}catch(t){}}var t=BX.clone(this.params);t.cancelingAction=this.getAction();this.getDialog().setSummary(this.getMessage("RequestCanceling"));this.setController(this.controllerDefault);this.callHandler("RequestStop",[t]);BX.onCustomEvent(this,"BX.Translate.Process.BeforeRequestStart",[this,t]);BX.ajax.runAction(this.controller+".cancel",{data:t,method:this.method,onrequeststart:BX.delegate(this.onRequestStart,this)}).then(BX.delegate(this.onRequestSuccess,this),BX.delegate(this.onRequestFailure,this))},finalizeRequest:function(){if(this.state===this.STATES.canceling){return}var t=BX.clone(this.params);this.setController(this.controllerDefault);this.callHandler("RequestFinalize",[t]);BX.onCustomEvent(this,"BX.Translate.Process.BeforeRequestStart",[this,t]);BX.ajax.runAction(this.controller+".finalize",{data:t,method:this.method,onrequeststart:BX.delegate(this.onRequestStart,this)})},onRequestStart:function(t){this.xhr=t},onRequestSuccess:function(t){this.isRequestRunning=false;this.xhr=null;if(!t){this.getDialog().setError(this.getMessage("RequestError"));this.setState(this.STATES.error);return}if(BX.type.isArray(t["errors"])&&t["errors"].length>0){var e=t["errors"].slice(-10),s=[];e.forEach(function(t){s.push(t.message)});this.getDialog().setError(s.join("<br>"),true);this.setState(this.STATES.error);return}t=t["data"];var i=BX.type.isNotEmptyString(t["STATUS"])?t["STATUS"]:"";var r=BX.type.isNotEmptyString(t["SUMMARY"])?t["SUMMARY"]:"";var n=BX.type.isNumber(t["PROCESSED_ITEMS"])?t["PROCESSED_ITEMS"]:0;var o=BX.type.isNumber(t["TOTAL_ITEMS"])?t["TOTAL_ITEMS"]:0;var a=BX.type.isNotEmptyString(t["FINALIZE"]);var h=BX.type.isNotEmptyString(t["WARNING"])?t["WARNING"]:"";this.getDialog().setWarning(h);if(i===this.STATUSES.progress||i===this.STATUSES.completed){if(o>0){if(this.queue[this.currentStep].progressBarTitle){this.getDialog().setProgressBar(o,n,this.queue[this.currentStep].progressBarTitle)}else{this.getDialog().setProgressBar(o,n)}}else{this.getDialog().hideProgressBar()}}if(i===this.STATUSES.progress){if(r!==""){this.getDialog().setSummary(r,true)}if(this.state===this.STATES.canceling){this.setState(this.STATES.stopped)}else{var l=BX.type.isNotEmptyString(t["NEXT_CONTROLLER"])?t["NEXT_CONTROLLER"]:"";if(l!==""){this.setController(l)}else if(BX.type.isNotEmptyString(this.queue[this.currentStep].controller)){this.setController(this.queue[this.currentStep].controller)}else{this.setController(this.controllerDefault)}var u=BX.type.isNotEmptyString(t["NEXT_ACTION"])?t["NEXT_ACTION"]:"";if(u!==""){this.setAction(u)}window.setTimeout(BX.delegate(this.startRequest,this),100)}return}if(this.state===this.STATES.canceling){this.getDialog().setSummary(this.getMessage("RequestCanceled"));this.setState(this.STATES.completed)}else if(i===this.STATUSES.completed){if(this.getQueueLength()>0&&this.currentStep+1<this.getQueueLength()){this.currentStep++;if(BX.type.isNotEmptyString(this.queue[this.currentStep].controller)){this.setController(this.queue[this.currentStep].controller)}else{this.setController(this.controllerDefault)}if(!BX.type.isNotEmptyString(this.queue[this.currentStep].action)){throw"BX.Translate.Process: Could not find controller action at the queue position."}if("finalize"in this.queue[this.currentStep]){a=true;this.setAction(this.queue[this.currentStep].action)}else{this.setAction(this.queue[this.currentStep].action);this.getDialog().setSummary(this.queue[this.currentStep].title);window.setTimeout(BX.delegate(this.startRequest,this),100);return}}if(r!==""){this.getDialog().setSummary(r,true)}else{this.getDialog().setSummary(this.getMessage("RequestCompleted"))}if(BX.type.isNotEmptyString(t["DOWNLOAD_LINK"])){this.getDialog().setDownloadButtons(t["DOWNLOAD_LINK"],t["FILE_NAME"],BX.delegate(function(){this.callAction("purge")},this))}this.setState(this.STATES.completed,t);if(a){window.setTimeout(BX.delegate(this.finalizeRequest,this),100)}}else{this.getDialog().setSummary("").setError(this.getMessage("RequestError"));this.setState(this.STATES.error)}},onRequestFailure:function(t){if(this.state===this.STATES.canceling){return}if(BX.type.isPlainObject(t)&&"data"in t&&BX.type.isPlainObject(t.data)&&"ajaxRejectData"in t.data&&BX.type.isPlainObject(t.data.ajaxRejectData)&&"reason"in t.data.ajaxRejectData&&t.data.ajaxRejectData.reason==="status"&&"data"in t.data.ajaxRejectData&&t.data.ajaxRejectData.data===401){this.getDialog().setError(this.getMessage("AuthError"))}else if(BX.type.isPlainObject(t)&&"errors"in t&&BX.type.isArray(t.errors)&&t.errors.length>0){if(this.state===this.STATES.canceling){var e=false;t.errors.forEach(function(t){if(t.code==="NETWORK_ERROR"){e=true}});if(e){return}}var s=t.errors.slice(-10),i=[];s.forEach(function(t){i.push(t.message)});this.getDialog().setError(i.join("<br>"),true)}else{this.getDialog().setError(this.getMessage("RequestError"))}this.isRequestRunning=false;this.xhr=null;this.currentStep=-1;this.setState(this.STATES.error)}};if(typeof BX.Translate.ProcessManager=="undefined"){BX.Translate.ProcessManager={}}if(typeof BX.Translate.ProcessManager.items=="undefined"){BX.Translate.ProcessManager.items={}}BX.Translate.ProcessManager.create=function(t){var e=new BX.Translate.Process;e.init(t);BX.Translate.ProcessManager.items[e.getId()]=e;return e};BX.Translate.ProcessManager.delete=function(t){if(BX.Translate.ProcessManager.items.hasOwnProperty(t)){BX.Translate.ProcessManager.items[t].destroy();delete BX.Translate.ProcessManager.items[t]}};BX.Translate.ProcessManager.getInstance=function(t){return BX.Translate.ProcessManager.items[t]?BX.Translate.ProcessManager.items[t]:null}})();
//# sourceMappingURL=process.map.js