
CREATE TABLE b_list_rubric (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LID char(2) NOT NULL,
  CODE varchar(100),
  NAME varchar(100),
  DESCRIPTION text,
  SORT int NOT NULL DEFAULT 100,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  AUTO char(1) NOT NULL DEFAULT 'N',
  DAYS_OF_MONTH varchar(100),
  DAYS_OF_WEEK varchar(15),
  TIMES_OF_DAY varchar(255),
  TEMPLATE varchar(100),
  LAST_EXECUTED timestamp,
  VISIBLE char(1) NOT NULL DEFAULT 'Y',
  FROM_FIELD varchar(255),
  PRIMARY KEY (ID)
);

CREATE TABLE b_subscription (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  DATE_UPDATE timestamp,
  USER_ID int,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  EMAIL varchar(255) NOT NULL,
  FORMAT varchar(4) NOT NULL DEFAULT 'text',
  CONFIRM_CODE varchar(8),
  CONFIRMED char(1) NOT NULL DEFAULT 'N',
  DATE_CONFIRM timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_subscription_email_user_id ON b_subscription (email, user_id);
CREATE INDEX ix_b_subscription_confirmed_date_confirm ON b_subscription (confirmed, date_confirm);

CREATE TABLE b_subscription_rubric (
  SUBSCRIPTION_ID int NOT NULL,
  LIST_RUBRIC_ID int NOT NULL,
  PRIMARY KEY (SUBSCRIPTION_ID, LIST_RUBRIC_ID)
);

CREATE TABLE b_posting (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp NOT NULL,
  STATUS char(1) NOT NULL DEFAULT 'D',
  VERSION char(1),
  DATE_SENT timestamp,
  SENT_BCC text,
  FROM_FIELD varchar(255) NOT NULL,
  TO_FIELD varchar(255),
  BCC_FIELD text,
  EMAIL_FILTER varchar(255),
  SUBJECT varchar(255) NOT NULL,
  BODY_TYPE varchar(4) NOT NULL DEFAULT 'text',
  BODY text NOT NULL,
  DIRECT_SEND char(1) NOT NULL DEFAULT 'N',
  CHARSET varchar(50),
  MSG_CHARSET varchar(255),
  SUBSCR_FORMAT varchar(4),
  ERROR_EMAIL text,
  AUTO_SEND_TIME timestamp,
  BCC_TO_SEND text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_posting_email (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  POSTING_ID int NOT NULL,
  STATUS char(1) NOT NULL,
  EMAIL varchar(255) NOT NULL,
  SUBSCRIPTION_ID int,
  USER_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_posting_email_posting_id_status ON b_posting_email (posting_id, status);
CREATE INDEX ix_b_posting_email_posting_id_email ON b_posting_email (posting_id, email);

CREATE TABLE b_posting_rubric (
  POSTING_ID int NOT NULL,
  LIST_RUBRIC_ID int NOT NULL
);
CREATE UNIQUE INDEX ux_b_posting_rubric_posting_id_list_rubric_id ON b_posting_rubric (posting_id, list_rubric_id);

CREATE TABLE b_posting_group (
  POSTING_ID int NOT NULL,
  GROUP_ID int NOT NULL
);
CREATE UNIQUE INDEX ux_b_posting_group_posting_id_group_id ON b_posting_group (posting_id, group_id);

CREATE TABLE b_posting_file (
  POSTING_ID int NOT NULL,
  FILE_ID int NOT NULL
);
CREATE UNIQUE INDEX ux_b_posting_file_posting_id_file_id ON b_posting_file (posting_id, file_id);
