create table if not exists b_stat_adv_searcher (
   ID int(18) not null auto_increment,
   ADV_ID int(18) not null,
   SEARCHER_ID int(18) not null,
   primary key (ID));

create table if not exists b_stat_adv (
   ID int(18) not null auto_increment,
   REFERER1 varchar(255),
   REFERER2 varchar(255),
   COST decimal(18,4) not null default '0.0000',
   REVENUE decimal(18,4) not null default '0.0000',
   EVENTS_VIEW varchar(255),
   GUESTS int(18) not null default '0',
   NEW_GUESTS int(18) not null default '0',
   FAVORITES int(18) not null default '0',
   C_HOSTS int(18) not null default '0',
   SESSIONS int(18) not null default '0',
   HITS int(18) not null default '0',
   DATE_FIRST datetime,
   DATE_LAST datetime,
   GUESTS_BACK int(18) not null default '0',
   FAVORITES_BACK int(18) not null default '0',
   HOSTS_BACK int(18) not null default '0',
   SESSIONS_BACK int(18) not null default '0',
   HITS_BACK int(18) not null default '0',
   DESCRIPTION text,
   PRIORITY int(18) not null default '100',
   primary key (ID),
   index IX_REFERER1(REFERER1));

create table if not exists b_stat_adv_event (
   ID int(18) not null auto_increment,
   ADV_ID int(18) default '0',
   EVENT_ID int(18) default '0',
   COUNTER int(18) not null default '0',
   COUNTER_BACK int(18) not null default '0',
   MONEY decimal(18,4) not null default '0.0000',
   MONEY_BACK decimal(18,4) not null default '0.0000',
   primary key (ID),
   index IX_ADV_EVENT_ID (ADV_ID, EVENT_ID));

create table if not exists b_stat_adv_guest (
   ID int(11) not null auto_increment,
   ADV_ID int(11) not null default '0',
   BACK char(1) not null default 'N',
   GUEST_ID int(11) not null default '0',
   DATE_GUEST_HIT datetime,
   DATE_HOST_HIT datetime,
   SESSION_ID int(11) not null default '0',
   IP varchar(15),
   IP_NUMBER bigint(20),
   primary key (ID),
   index IX_ADV_ID_GUEST (ADV_ID, GUEST_ID),
   index IX_ADV_ID_IP_NUMBER (ADV_ID, IP_NUMBER));

create table if not exists b_stat_adv_page (
   ID int(18) not null auto_increment,
   ADV_ID int(18) not null default '0',
   PAGE varchar(255) not null,
   C_TYPE varchar(5) not null default 'TO',
   primary key (ID),
   index IX_ADV_ID_TYPE (ADV_ID, C_TYPE));

create table if not exists b_stat_day (
   ID int(18) not null auto_increment,
   DATE_STAT date,
   HITS int(18) not null default '0',
   C_HOSTS int(18) not null default '0',
   SESSIONS int(18) not null default '0',
   C_EVENTS int(18) not null default '0',
   GUESTS int(18) not null default '0',
   NEW_GUESTS int(18) not null default '0',
   FAVORITES int(18) not null default '0',
   TOTAL_HOSTS int(18) not null default '0',
   AM_AVERAGE_TIME decimal(18,2) not null default '0.00',
   AM_1 int(18) not null default '0',
   AM_1_3 int(18) not null default '0',
   AM_3_6 int(18) not null default '0',
   AM_6_9 int(18) not null default '0',
   AM_9_12 int(18) not null default '0',
   AM_12_15 int(18) not null default '0',
   AM_15_18 int(18) not null default '0',
   AM_18_21 int(18) not null default '0',
   AM_21_24 int(18) not null default '0',
   AM_24 int(18) not null default '0',
   AH_AVERAGE_HITS decimal(18,2) not null default '0.00',
   AH_1 int(18) not null default '0',
   AH_2_5 int(18) not null default '0',
   AH_6_9 int(18) not null default '0',
   AH_10_13 int(18) not null default '0',
   AH_14_17 int(18) not null default '0',
   AH_18_21 int(18) not null default '0',
   AH_22_25 int(18) not null default '0',
   AH_26_29 int(18) not null default '0',
   AH_30_33 int(18) not null default '0',
   AH_34 int(18) not null default '0',
   HOUR_HOST_0 int(18) not null default '0',
   HOUR_HOST_1 int(18) not null default '0',
   HOUR_HOST_2 int(18) not null default '0',
   HOUR_HOST_3 int(18) not null default '0',
   HOUR_HOST_4 int(18) not null default '0',
   HOUR_HOST_5 int(18) not null default '0',
   HOUR_HOST_6 int(18) not null default '0',
   HOUR_HOST_7 int(18) not null default '0',
   HOUR_HOST_8 int(18) not null default '0',
   HOUR_HOST_9 int(18) not null default '0',
   HOUR_HOST_10 int(18) not null default '0',
   HOUR_HOST_11 int(18) not null default '0',
   HOUR_HOST_12 int(18) not null default '0',
   HOUR_HOST_13 int(18) not null default '0',
   HOUR_HOST_14 int(18) not null default '0',
   HOUR_HOST_15 int(18) not null default '0',
   HOUR_HOST_16 int(18) not null default '0',
   HOUR_HOST_17 int(18) not null default '0',
   HOUR_HOST_18 int(18) not null default '0',
   HOUR_HOST_19 int(18) not null default '0',
   HOUR_HOST_20 int(18) not null default '0',
   HOUR_HOST_21 int(18) not null default '0',
   HOUR_HOST_22 int(18) not null default '0',
   HOUR_HOST_23 int(18) not null default '0',
   HOUR_GUEST_0 int(18) not null default '0',
   HOUR_GUEST_1 int(18) not null default '0',
   HOUR_GUEST_2 int(18) not null default '0',
   HOUR_GUEST_3 int(18) not null default '0',
   HOUR_GUEST_4 int(18) not null default '0',
   HOUR_GUEST_5 int(18) not null default '0',
   HOUR_GUEST_6 int(18) not null default '0',
   HOUR_GUEST_7 int(18) not null default '0',
   HOUR_GUEST_8 int(18) not null default '0',
   HOUR_GUEST_9 int(18) not null default '0',
   HOUR_GUEST_10 int(18) not null default '0',
   HOUR_GUEST_11 int(18) not null default '0',
   HOUR_GUEST_12 int(18) not null default '0',
   HOUR_GUEST_13 int(18) not null default '0',
   HOUR_GUEST_14 int(18) not null default '0',
   HOUR_GUEST_15 int(18) not null default '0',
   HOUR_GUEST_16 int(18) not null default '0',
   HOUR_GUEST_17 int(18) not null default '0',
   HOUR_GUEST_18 int(18) not null default '0',
   HOUR_GUEST_19 int(18) not null default '0',
   HOUR_GUEST_20 int(18) not null default '0',
   HOUR_GUEST_21 int(18) not null default '0',
   HOUR_GUEST_22 int(18) not null default '0',
   HOUR_GUEST_23 int(18) not null default '0',
   HOUR_NEW_GUEST_0 int(18) not null default '0',
   HOUR_NEW_GUEST_1 int(18) not null default '0',
   HOUR_NEW_GUEST_2 int(18) not null default '0',
   HOUR_NEW_GUEST_3 int(18) not null default '0',
   HOUR_NEW_GUEST_4 int(18) not null default '0',
   HOUR_NEW_GUEST_5 int(18) not null default '0',
   HOUR_NEW_GUEST_6 int(18) not null default '0',
   HOUR_NEW_GUEST_7 int(18) not null default '0',
   HOUR_NEW_GUEST_8 int(18) not null default '0',
   HOUR_NEW_GUEST_9 int(18) not null default '0',
   HOUR_NEW_GUEST_10 int(18) not null default '0',
   HOUR_NEW_GUEST_11 int(18) not null default '0',
   HOUR_NEW_GUEST_12 int(18) not null default '0',
   HOUR_NEW_GUEST_13 int(18) not null default '0',
   HOUR_NEW_GUEST_14 int(18) not null default '0',
   HOUR_NEW_GUEST_15 int(18) not null default '0',
   HOUR_NEW_GUEST_16 int(18) not null default '0',
   HOUR_NEW_GUEST_17 int(18) not null default '0',
   HOUR_NEW_GUEST_18 int(18) not null default '0',
   HOUR_NEW_GUEST_19 int(18) not null default '0',
   HOUR_NEW_GUEST_20 int(18) not null default '0',
   HOUR_NEW_GUEST_21 int(18) not null default '0',
   HOUR_NEW_GUEST_22 int(18) not null default '0',
   HOUR_NEW_GUEST_23 int(18) not null default '0',
   HOUR_SESSION_0 int(18) not null default '0',
   HOUR_SESSION_1 int(18) not null default '0',
   HOUR_SESSION_2 int(18) not null default '0',
   HOUR_SESSION_3 int(18) not null default '0',
   HOUR_SESSION_4 int(18) not null default '0',
   HOUR_SESSION_5 int(18) not null default '0',
   HOUR_SESSION_6 int(18) not null default '0',
   HOUR_SESSION_7 int(18) not null default '0',
   HOUR_SESSION_8 int(18) not null default '0',
   HOUR_SESSION_9 int(18) not null default '0',
   HOUR_SESSION_10 int(18) not null default '0',
   HOUR_SESSION_11 int(18) not null default '0',
   HOUR_SESSION_12 int(18) not null default '0',
   HOUR_SESSION_13 int(18) not null default '0',
   HOUR_SESSION_14 int(18) not null default '0',
   HOUR_SESSION_15 int(18) not null default '0',
   HOUR_SESSION_16 int(18) not null default '0',
   HOUR_SESSION_17 int(18) not null default '0',
   HOUR_SESSION_18 int(18) not null default '0',
   HOUR_SESSION_19 int(18) not null default '0',
   HOUR_SESSION_20 int(18) not null default '0',
   HOUR_SESSION_21 int(18) not null default '0',
   HOUR_SESSION_22 int(18) not null default '0',
   HOUR_SESSION_23 int(18) not null default '0',
   HOUR_HIT_0 int(18) not null default '0',
   HOUR_HIT_1 int(18) not null default '0',
   HOUR_HIT_2 int(18) not null default '0',
   HOUR_HIT_3 int(18) not null default '0',
   HOUR_HIT_4 int(18) not null default '0',
   HOUR_HIT_5 int(18) not null default '0',
   HOUR_HIT_6 int(18) not null default '0',
   HOUR_HIT_7 int(18) not null default '0',
   HOUR_HIT_8 int(18) not null default '0',
   HOUR_HIT_9 int(18) not null default '0',
   HOUR_HIT_10 int(18) not null default '0',
   HOUR_HIT_11 int(18) not null default '0',
   HOUR_HIT_12 int(18) not null default '0',
   HOUR_HIT_13 int(18) not null default '0',
   HOUR_HIT_14 int(18) not null default '0',
   HOUR_HIT_15 int(18) not null default '0',
   HOUR_HIT_16 int(18) not null default '0',
   HOUR_HIT_17 int(18) not null default '0',
   HOUR_HIT_18 int(18) not null default '0',
   HOUR_HIT_19 int(18) not null default '0',
   HOUR_HIT_20 int(18) not null default '0',
   HOUR_HIT_21 int(18) not null default '0',
   HOUR_HIT_22 int(18) not null default '0',
   HOUR_HIT_23 int(18) not null default '0',
   HOUR_EVENT_0 int(18) not null default '0',
   HOUR_EVENT_1 int(18) not null default '0',
   HOUR_EVENT_2 int(18) not null default '0',
   HOUR_EVENT_3 int(18) not null default '0',
   HOUR_EVENT_4 int(18) not null default '0',
   HOUR_EVENT_5 int(18) not null default '0',
   HOUR_EVENT_6 int(18) not null default '0',
   HOUR_EVENT_7 int(18) not null default '0',
   HOUR_EVENT_8 int(18) not null default '0',
   HOUR_EVENT_9 int(18) not null default '0',
   HOUR_EVENT_10 int(18) not null default '0',
   HOUR_EVENT_11 int(18) not null default '0',
   HOUR_EVENT_12 int(18) not null default '0',
   HOUR_EVENT_13 int(18) not null default '0',
   HOUR_EVENT_14 int(18) not null default '0',
   HOUR_EVENT_15 int(18) not null default '0',
   HOUR_EVENT_16 int(18) not null default '0',
   HOUR_EVENT_17 int(18) not null default '0',
   HOUR_EVENT_18 int(18) not null default '0',
   HOUR_EVENT_19 int(18) not null default '0',
   HOUR_EVENT_20 int(18) not null default '0',
   HOUR_EVENT_21 int(18) not null default '0',
   HOUR_EVENT_22 int(18) not null default '0',
   HOUR_EVENT_23 int(18) not null default '0',
   HOUR_FAVORITE_0 int(18) not null default '0',
   HOUR_FAVORITE_1 int(18) not null default '0',
   HOUR_FAVORITE_2 int(18) not null default '0',
   HOUR_FAVORITE_3 int(18) not null default '0',
   HOUR_FAVORITE_4 int(18) not null default '0',
   HOUR_FAVORITE_5 int(18) not null default '0',
   HOUR_FAVORITE_6 int(18) not null default '0',
   HOUR_FAVORITE_7 int(18) not null default '0',
   HOUR_FAVORITE_8 int(18) not null default '0',
   HOUR_FAVORITE_9 int(18) not null default '0',
   HOUR_FAVORITE_10 int(18) not null default '0',
   HOUR_FAVORITE_11 int(18) not null default '0',
   HOUR_FAVORITE_12 int(18) not null default '0',
   HOUR_FAVORITE_13 int(18) not null default '0',
   HOUR_FAVORITE_14 int(18) not null default '0',
   HOUR_FAVORITE_15 int(18) not null default '0',
   HOUR_FAVORITE_16 int(18) not null default '0',
   HOUR_FAVORITE_17 int(18) not null default '0',
   HOUR_FAVORITE_18 int(18) not null default '0',
   HOUR_FAVORITE_19 int(18) not null default '0',
   HOUR_FAVORITE_20 int(18) not null default '0',
   HOUR_FAVORITE_21 int(18) not null default '0',
   HOUR_FAVORITE_22 int(18) not null default '0',
   HOUR_FAVORITE_23 int(18) not null default '0',
   WEEKDAY_HOST_0 int(18) not null default '0',
   WEEKDAY_HOST_1 int(18) not null default '0',
   WEEKDAY_HOST_2 int(18) not null default '0',
   WEEKDAY_HOST_3 int(18) not null default '0',
   WEEKDAY_HOST_4 int(18) not null default '0',
   WEEKDAY_HOST_5 int(18) not null default '0',
   WEEKDAY_HOST_6 int(18) not null default '0',
   WEEKDAY_GUEST_0 int(18) not null default '0',
   WEEKDAY_GUEST_1 int(18) not null default '0',
   WEEKDAY_GUEST_2 int(18) not null default '0',
   WEEKDAY_GUEST_3 int(18) not null default '0',
   WEEKDAY_GUEST_4 int(18) not null default '0',
   WEEKDAY_GUEST_5 int(18) not null default '0',
   WEEKDAY_GUEST_6 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_0 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_1 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_2 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_3 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_4 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_5 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_6 int(18) not null default '0',
   WEEKDAY_SESSION_0 int(18) not null default '0',
   WEEKDAY_SESSION_1 int(18) not null default '0',
   WEEKDAY_SESSION_2 int(18) not null default '0',
   WEEKDAY_SESSION_3 int(18) not null default '0',
   WEEKDAY_SESSION_4 int(18) not null default '0',
   WEEKDAY_SESSION_5 int(18) not null default '0',
   WEEKDAY_SESSION_6 int(18) not null default '0',
   WEEKDAY_HIT_0 int(18) not null default '0',
   WEEKDAY_HIT_1 int(18) not null default '0',
   WEEKDAY_HIT_2 int(18) not null default '0',
   WEEKDAY_HIT_3 int(18) not null default '0',
   WEEKDAY_HIT_4 int(18) not null default '0',
   WEEKDAY_HIT_5 int(18) not null default '0',
   WEEKDAY_HIT_6 int(18) not null default '0',
   WEEKDAY_EVENT_0 int(18) not null default '0',
   WEEKDAY_EVENT_1 int(18) not null default '0',
   WEEKDAY_EVENT_2 int(18) not null default '0',
   WEEKDAY_EVENT_3 int(18) not null default '0',
   WEEKDAY_EVENT_4 int(18) not null default '0',
   WEEKDAY_EVENT_5 int(18) not null default '0',
   WEEKDAY_EVENT_6 int(18) not null default '0',
   WEEKDAY_FAVORITE_0 int(18) not null default '0',
   WEEKDAY_FAVORITE_1 int(18) not null default '0',
   WEEKDAY_FAVORITE_2 int(18) not null default '0',
   WEEKDAY_FAVORITE_3 int(18) not null default '0',
   WEEKDAY_FAVORITE_4 int(18) not null default '0',
   WEEKDAY_FAVORITE_5 int(18) not null default '0',
   WEEKDAY_FAVORITE_6 int(18) not null default '0',
   MONTH_HOST_1 int(18) not null default '0',
   MONTH_HOST_2 int(18) not null default '0',
   MONTH_HOST_3 int(18) not null default '0',
   MONTH_HOST_4 int(18) not null default '0',
   MONTH_HOST_5 int(18) not null default '0',
   MONTH_HOST_6 int(18) not null default '0',
   MONTH_HOST_7 int(18) not null default '0',
   MONTH_HOST_8 int(18) not null default '0',
   MONTH_HOST_9 int(18) not null default '0',
   MONTH_HOST_10 int(18) not null default '0',
   MONTH_HOST_11 int(18) not null default '0',
   MONTH_HOST_12 int(18) not null default '0',
   MONTH_GUEST_1 int(18) not null default '0',
   MONTH_GUEST_2 int(18) not null default '0',
   MONTH_GUEST_3 int(18) not null default '0',
   MONTH_GUEST_4 int(18) not null default '0',
   MONTH_GUEST_5 int(18) not null default '0',
   MONTH_GUEST_6 int(18) not null default '0',
   MONTH_GUEST_7 int(18) not null default '0',
   MONTH_GUEST_8 int(18) not null default '0',
   MONTH_GUEST_9 int(18) not null default '0',
   MONTH_GUEST_10 int(18) not null default '0',
   MONTH_GUEST_11 int(18) not null default '0',
   MONTH_GUEST_12 int(18) not null default '0',
   MONTH_NEW_GUEST_1 int(18) not null default '0',
   MONTH_NEW_GUEST_2 int(18) not null default '0',
   MONTH_NEW_GUEST_3 int(18) not null default '0',
   MONTH_NEW_GUEST_4 int(18) not null default '0',
   MONTH_NEW_GUEST_5 int(18) not null default '0',
   MONTH_NEW_GUEST_6 int(18) not null default '0',
   MONTH_NEW_GUEST_7 int(18) not null default '0',
   MONTH_NEW_GUEST_8 int(18) not null default '0',
   MONTH_NEW_GUEST_9 int(18) not null default '0',
   MONTH_NEW_GUEST_10 int(18) not null default '0',
   MONTH_NEW_GUEST_11 int(18) not null default '0',
   MONTH_NEW_GUEST_12 int(18) not null default '0',
   MONTH_SESSION_1 int(18) not null default '0',
   MONTH_SESSION_2 int(18) not null default '0',
   MONTH_SESSION_3 int(18) not null default '0',
   MONTH_SESSION_4 int(18) not null default '0',
   MONTH_SESSION_5 int(18) not null default '0',
   MONTH_SESSION_6 int(18) not null default '0',
   MONTH_SESSION_7 int(18) not null default '0',
   MONTH_SESSION_8 int(18) not null default '0',
   MONTH_SESSION_9 int(18) not null default '0',
   MONTH_SESSION_10 int(18) not null default '0',
   MONTH_SESSION_11 int(18) not null default '0',
   MONTH_SESSION_12 int(18) not null default '0',
   MONTH_HIT_1 int(18) not null default '0',
   MONTH_HIT_2 int(18) not null default '0',
   MONTH_HIT_3 int(18) not null default '0',
   MONTH_HIT_4 int(18) not null default '0',
   MONTH_HIT_5 int(18) not null default '0',
   MONTH_HIT_6 int(18) not null default '0',
   MONTH_HIT_7 int(18) not null default '0',
   MONTH_HIT_8 int(18) not null default '0',
   MONTH_HIT_9 int(18) not null default '0',
   MONTH_HIT_10 int(18) not null default '0',
   MONTH_HIT_11 int(18) not null default '0',
   MONTH_HIT_12 int(18) not null default '0',
   MONTH_EVENT_1 int(18) not null default '0',
   MONTH_EVENT_2 int(18) not null default '0',
   MONTH_EVENT_3 int(18) not null default '0',
   MONTH_EVENT_4 int(18) not null default '0',
   MONTH_EVENT_5 int(18) not null default '0',
   MONTH_EVENT_6 int(18) not null default '0',
   MONTH_EVENT_7 int(18) not null default '0',
   MONTH_EVENT_8 int(18) not null default '0',
   MONTH_EVENT_9 int(18) not null default '0',
   MONTH_EVENT_10 int(18) not null default '0',
   MONTH_EVENT_11 int(18) not null default '0',
   MONTH_EVENT_12 int(18) not null default '0',
   MONTH_FAVORITE_1 int(18) not null default '0',
   MONTH_FAVORITE_2 int(18) not null default '0',
   MONTH_FAVORITE_3 int(18) not null default '0',
   MONTH_FAVORITE_4 int(18) not null default '0',
   MONTH_FAVORITE_5 int(18) not null default '0',
   MONTH_FAVORITE_6 int(18) not null default '0',
   MONTH_FAVORITE_7 int(18) not null default '0',
   MONTH_FAVORITE_8 int(18) not null default '0',
   MONTH_FAVORITE_9 int(18) not null default '0',
   MONTH_FAVORITE_10 int(18) not null default '0',
   MONTH_FAVORITE_11 int(18) not null default '0',
   MONTH_FAVORITE_12 int(18) not null default '0',
   primary key (ID),
   unique IX_DATE_STAT (DATE_STAT));

create table if not exists b_stat_day_site (
   ID int(18) not null auto_increment,
   DATE_STAT date,
   SITE_ID char(2) not null,
   HITS int(18) not null default '0',
   C_HOSTS int(18) not null default '0',
   SESSIONS int(18) not null default '0',
   C_EVENTS int(18) not null default '0',
   GUESTS int(18) not null default '0',
   NEW_GUESTS int(18) not null default '0',
   FAVORITES int(18) not null default '0',
   TOTAL_HOSTS int(18) not null default '0',
   AM_AVERAGE_TIME decimal(18,2) not null default '0.00',
   AM_1 int(18) not null default '0',
   AM_1_3 int(18) not null default '0',
   AM_3_6 int(18) not null default '0',
   AM_6_9 int(18) not null default '0',
   AM_9_12 int(18) not null default '0',
   AM_12_15 int(18) not null default '0',
   AM_15_18 int(18) not null default '0',
   AM_18_21 int(18) not null default '0',
   AM_21_24 int(18) not null default '0',
   AM_24 int(18) not null default '0',
   AH_AVERAGE_HITS decimal(18,2) not null default '0.00',
   AH_1 int(18) not null default '0',
   AH_2_5 int(18) not null default '0',
   AH_6_9 int(18) not null default '0',
   AH_10_13 int(18) not null default '0',
   AH_14_17 int(18) not null default '0',
   AH_18_21 int(18) not null default '0',
   AH_22_25 int(18) not null default '0',
   AH_26_29 int(18) not null default '0',
   AH_30_33 int(18) not null default '0',
   AH_34 int(18) not null default '0',
   HOUR_HOST_0 int(18) not null default '0',
   HOUR_HOST_1 int(18) not null default '0',
   HOUR_HOST_2 int(18) not null default '0',
   HOUR_HOST_3 int(18) not null default '0',
   HOUR_HOST_4 int(18) not null default '0',
   HOUR_HOST_5 int(18) not null default '0',
   HOUR_HOST_6 int(18) not null default '0',
   HOUR_HOST_7 int(18) not null default '0',
   HOUR_HOST_8 int(18) not null default '0',
   HOUR_HOST_9 int(18) not null default '0',
   HOUR_HOST_10 int(18) not null default '0',
   HOUR_HOST_11 int(18) not null default '0',
   HOUR_HOST_12 int(18) not null default '0',
   HOUR_HOST_13 int(18) not null default '0',
   HOUR_HOST_14 int(18) not null default '0',
   HOUR_HOST_15 int(18) not null default '0',
   HOUR_HOST_16 int(18) not null default '0',
   HOUR_HOST_17 int(18) not null default '0',
   HOUR_HOST_18 int(18) not null default '0',
   HOUR_HOST_19 int(18) not null default '0',
   HOUR_HOST_20 int(18) not null default '0',
   HOUR_HOST_21 int(18) not null default '0',
   HOUR_HOST_22 int(18) not null default '0',
   HOUR_HOST_23 int(18) not null default '0',
   HOUR_GUEST_0 int(18) not null default '0',
   HOUR_GUEST_1 int(18) not null default '0',
   HOUR_GUEST_2 int(18) not null default '0',
   HOUR_GUEST_3 int(18) not null default '0',
   HOUR_GUEST_4 int(18) not null default '0',
   HOUR_GUEST_5 int(18) not null default '0',
   HOUR_GUEST_6 int(18) not null default '0',
   HOUR_GUEST_7 int(18) not null default '0',
   HOUR_GUEST_8 int(18) not null default '0',
   HOUR_GUEST_9 int(18) not null default '0',
   HOUR_GUEST_10 int(18) not null default '0',
   HOUR_GUEST_11 int(18) not null default '0',
   HOUR_GUEST_12 int(18) not null default '0',
   HOUR_GUEST_13 int(18) not null default '0',
   HOUR_GUEST_14 int(18) not null default '0',
   HOUR_GUEST_15 int(18) not null default '0',
   HOUR_GUEST_16 int(18) not null default '0',
   HOUR_GUEST_17 int(18) not null default '0',
   HOUR_GUEST_18 int(18) not null default '0',
   HOUR_GUEST_19 int(18) not null default '0',
   HOUR_GUEST_20 int(18) not null default '0',
   HOUR_GUEST_21 int(18) not null default '0',
   HOUR_GUEST_22 int(18) not null default '0',
   HOUR_GUEST_23 int(18) not null default '0',
   HOUR_NEW_GUEST_0 int(18) not null default '0',
   HOUR_NEW_GUEST_1 int(18) not null default '0',
   HOUR_NEW_GUEST_2 int(18) not null default '0',
   HOUR_NEW_GUEST_3 int(18) not null default '0',
   HOUR_NEW_GUEST_4 int(18) not null default '0',
   HOUR_NEW_GUEST_5 int(18) not null default '0',
   HOUR_NEW_GUEST_6 int(18) not null default '0',
   HOUR_NEW_GUEST_7 int(18) not null default '0',
   HOUR_NEW_GUEST_8 int(18) not null default '0',
   HOUR_NEW_GUEST_9 int(18) not null default '0',
   HOUR_NEW_GUEST_10 int(18) not null default '0',
   HOUR_NEW_GUEST_11 int(18) not null default '0',
   HOUR_NEW_GUEST_12 int(18) not null default '0',
   HOUR_NEW_GUEST_13 int(18) not null default '0',
   HOUR_NEW_GUEST_14 int(18) not null default '0',
   HOUR_NEW_GUEST_15 int(18) not null default '0',
   HOUR_NEW_GUEST_16 int(18) not null default '0',
   HOUR_NEW_GUEST_17 int(18) not null default '0',
   HOUR_NEW_GUEST_18 int(18) not null default '0',
   HOUR_NEW_GUEST_19 int(18) not null default '0',
   HOUR_NEW_GUEST_20 int(18) not null default '0',
   HOUR_NEW_GUEST_21 int(18) not null default '0',
   HOUR_NEW_GUEST_22 int(18) not null default '0',
   HOUR_NEW_GUEST_23 int(18) not null default '0',
   HOUR_SESSION_0 int(18) not null default '0',
   HOUR_SESSION_1 int(18) not null default '0',
   HOUR_SESSION_2 int(18) not null default '0',
   HOUR_SESSION_3 int(18) not null default '0',
   HOUR_SESSION_4 int(18) not null default '0',
   HOUR_SESSION_5 int(18) not null default '0',
   HOUR_SESSION_6 int(18) not null default '0',
   HOUR_SESSION_7 int(18) not null default '0',
   HOUR_SESSION_8 int(18) not null default '0',
   HOUR_SESSION_9 int(18) not null default '0',
   HOUR_SESSION_10 int(18) not null default '0',
   HOUR_SESSION_11 int(18) not null default '0',
   HOUR_SESSION_12 int(18) not null default '0',
   HOUR_SESSION_13 int(18) not null default '0',
   HOUR_SESSION_14 int(18) not null default '0',
   HOUR_SESSION_15 int(18) not null default '0',
   HOUR_SESSION_16 int(18) not null default '0',
   HOUR_SESSION_17 int(18) not null default '0',
   HOUR_SESSION_18 int(18) not null default '0',
   HOUR_SESSION_19 int(18) not null default '0',
   HOUR_SESSION_20 int(18) not null default '0',
   HOUR_SESSION_21 int(18) not null default '0',
   HOUR_SESSION_22 int(18) not null default '0',
   HOUR_SESSION_23 int(18) not null default '0',
   HOUR_HIT_0 int(18) not null default '0',
   HOUR_HIT_1 int(18) not null default '0',
   HOUR_HIT_2 int(18) not null default '0',
   HOUR_HIT_3 int(18) not null default '0',
   HOUR_HIT_4 int(18) not null default '0',
   HOUR_HIT_5 int(18) not null default '0',
   HOUR_HIT_6 int(18) not null default '0',
   HOUR_HIT_7 int(18) not null default '0',
   HOUR_HIT_8 int(18) not null default '0',
   HOUR_HIT_9 int(18) not null default '0',
   HOUR_HIT_10 int(18) not null default '0',
   HOUR_HIT_11 int(18) not null default '0',
   HOUR_HIT_12 int(18) not null default '0',
   HOUR_HIT_13 int(18) not null default '0',
   HOUR_HIT_14 int(18) not null default '0',
   HOUR_HIT_15 int(18) not null default '0',
   HOUR_HIT_16 int(18) not null default '0',
   HOUR_HIT_17 int(18) not null default '0',
   HOUR_HIT_18 int(18) not null default '0',
   HOUR_HIT_19 int(18) not null default '0',
   HOUR_HIT_20 int(18) not null default '0',
   HOUR_HIT_21 int(18) not null default '0',
   HOUR_HIT_22 int(18) not null default '0',
   HOUR_HIT_23 int(18) not null default '0',
   HOUR_EVENT_0 int(18) not null default '0',
   HOUR_EVENT_1 int(18) not null default '0',
   HOUR_EVENT_2 int(18) not null default '0',
   HOUR_EVENT_3 int(18) not null default '0',
   HOUR_EVENT_4 int(18) not null default '0',
   HOUR_EVENT_5 int(18) not null default '0',
   HOUR_EVENT_6 int(18) not null default '0',
   HOUR_EVENT_7 int(18) not null default '0',
   HOUR_EVENT_8 int(18) not null default '0',
   HOUR_EVENT_9 int(18) not null default '0',
   HOUR_EVENT_10 int(18) not null default '0',
   HOUR_EVENT_11 int(18) not null default '0',
   HOUR_EVENT_12 int(18) not null default '0',
   HOUR_EVENT_13 int(18) not null default '0',
   HOUR_EVENT_14 int(18) not null default '0',
   HOUR_EVENT_15 int(18) not null default '0',
   HOUR_EVENT_16 int(18) not null default '0',
   HOUR_EVENT_17 int(18) not null default '0',
   HOUR_EVENT_18 int(18) not null default '0',
   HOUR_EVENT_19 int(18) not null default '0',
   HOUR_EVENT_20 int(18) not null default '0',
   HOUR_EVENT_21 int(18) not null default '0',
   HOUR_EVENT_22 int(18) not null default '0',
   HOUR_EVENT_23 int(18) not null default '0',
   HOUR_FAVORITE_0 int(18) not null default '0',
   HOUR_FAVORITE_1 int(18) not null default '0',
   HOUR_FAVORITE_2 int(18) not null default '0',
   HOUR_FAVORITE_3 int(18) not null default '0',
   HOUR_FAVORITE_4 int(18) not null default '0',
   HOUR_FAVORITE_5 int(18) not null default '0',
   HOUR_FAVORITE_6 int(18) not null default '0',
   HOUR_FAVORITE_7 int(18) not null default '0',
   HOUR_FAVORITE_8 int(18) not null default '0',
   HOUR_FAVORITE_9 int(18) not null default '0',
   HOUR_FAVORITE_10 int(18) not null default '0',
   HOUR_FAVORITE_11 int(18) not null default '0',
   HOUR_FAVORITE_12 int(18) not null default '0',
   HOUR_FAVORITE_13 int(18) not null default '0',
   HOUR_FAVORITE_14 int(18) not null default '0',
   HOUR_FAVORITE_15 int(18) not null default '0',
   HOUR_FAVORITE_16 int(18) not null default '0',
   HOUR_FAVORITE_17 int(18) not null default '0',
   HOUR_FAVORITE_18 int(18) not null default '0',
   HOUR_FAVORITE_19 int(18) not null default '0',
   HOUR_FAVORITE_20 int(18) not null default '0',
   HOUR_FAVORITE_21 int(18) not null default '0',
   HOUR_FAVORITE_22 int(18) not null default '0',
   HOUR_FAVORITE_23 int(18) not null default '0',
   WEEKDAY_HOST_0 int(18) not null default '0',
   WEEKDAY_HOST_1 int(18) not null default '0',
   WEEKDAY_HOST_2 int(18) not null default '0',
   WEEKDAY_HOST_3 int(18) not null default '0',
   WEEKDAY_HOST_4 int(18) not null default '0',
   WEEKDAY_HOST_5 int(18) not null default '0',
   WEEKDAY_HOST_6 int(18) not null default '0',
   WEEKDAY_GUEST_0 int(18) not null default '0',
   WEEKDAY_GUEST_1 int(18) not null default '0',
   WEEKDAY_GUEST_2 int(18) not null default '0',
   WEEKDAY_GUEST_3 int(18) not null default '0',
   WEEKDAY_GUEST_4 int(18) not null default '0',
   WEEKDAY_GUEST_5 int(18) not null default '0',
   WEEKDAY_GUEST_6 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_0 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_1 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_2 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_3 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_4 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_5 int(18) not null default '0',
   WEEKDAY_NEW_GUEST_6 int(18) not null default '0',
   WEEKDAY_SESSION_0 int(18) not null default '0',
   WEEKDAY_SESSION_1 int(18) not null default '0',
   WEEKDAY_SESSION_2 int(18) not null default '0',
   WEEKDAY_SESSION_3 int(18) not null default '0',
   WEEKDAY_SESSION_4 int(18) not null default '0',
   WEEKDAY_SESSION_5 int(18) not null default '0',
   WEEKDAY_SESSION_6 int(18) not null default '0',
   WEEKDAY_HIT_0 int(18) not null default '0',
   WEEKDAY_HIT_1 int(18) not null default '0',
   WEEKDAY_HIT_2 int(18) not null default '0',
   WEEKDAY_HIT_3 int(18) not null default '0',
   WEEKDAY_HIT_4 int(18) not null default '0',
   WEEKDAY_HIT_5 int(18) not null default '0',
   WEEKDAY_HIT_6 int(18) not null default '0',
   WEEKDAY_EVENT_0 int(18) not null default '0',
   WEEKDAY_EVENT_1 int(18) not null default '0',
   WEEKDAY_EVENT_2 int(18) not null default '0',
   WEEKDAY_EVENT_3 int(18) not null default '0',
   WEEKDAY_EVENT_4 int(18) not null default '0',
   WEEKDAY_EVENT_5 int(18) not null default '0',
   WEEKDAY_EVENT_6 int(18) not null default '0',
   WEEKDAY_FAVORITE_0 int(18) not null default '0',
   WEEKDAY_FAVORITE_1 int(18) not null default '0',
   WEEKDAY_FAVORITE_2 int(18) not null default '0',
   WEEKDAY_FAVORITE_3 int(18) not null default '0',
   WEEKDAY_FAVORITE_4 int(18) not null default '0',
   WEEKDAY_FAVORITE_5 int(18) not null default '0',
   WEEKDAY_FAVORITE_6 int(18) not null default '0',
   MONTH_HOST_1 int(18) not null default '0',
   MONTH_HOST_2 int(18) not null default '0',
   MONTH_HOST_3 int(18) not null default '0',
   MONTH_HOST_4 int(18) not null default '0',
   MONTH_HOST_5 int(18) not null default '0',
   MONTH_HOST_6 int(18) not null default '0',
   MONTH_HOST_7 int(18) not null default '0',
   MONTH_HOST_8 int(18) not null default '0',
   MONTH_HOST_9 int(18) not null default '0',
   MONTH_HOST_10 int(18) not null default '0',
   MONTH_HOST_11 int(18) not null default '0',
   MONTH_HOST_12 int(18) not null default '0',
   MONTH_GUEST_1 int(18) not null default '0',
   MONTH_GUEST_2 int(18) not null default '0',
   MONTH_GUEST_3 int(18) not null default '0',
   MONTH_GUEST_4 int(18) not null default '0',
   MONTH_GUEST_5 int(18) not null default '0',
   MONTH_GUEST_6 int(18) not null default '0',
   MONTH_GUEST_7 int(18) not null default '0',
   MONTH_GUEST_8 int(18) not null default '0',
   MONTH_GUEST_9 int(18) not null default '0',
   MONTH_GUEST_10 int(18) not null default '0',
   MONTH_GUEST_11 int(18) not null default '0',
   MONTH_GUEST_12 int(18) not null default '0',
   MONTH_NEW_GUEST_1 int(18) not null default '0',
   MONTH_NEW_GUEST_2 int(18) not null default '0',
   MONTH_NEW_GUEST_3 int(18) not null default '0',
   MONTH_NEW_GUEST_4 int(18) not null default '0',
   MONTH_NEW_GUEST_5 int(18) not null default '0',
   MONTH_NEW_GUEST_6 int(18) not null default '0',
   MONTH_NEW_GUEST_7 int(18) not null default '0',
   MONTH_NEW_GUEST_8 int(18) not null default '0',
   MONTH_NEW_GUEST_9 int(18) not null default '0',
   MONTH_NEW_GUEST_10 int(18) not null default '0',
   MONTH_NEW_GUEST_11 int(18) not null default '0',
   MONTH_NEW_GUEST_12 int(18) not null default '0',
   MONTH_SESSION_1 int(18) not null default '0',
   MONTH_SESSION_2 int(18) not null default '0',
   MONTH_SESSION_3 int(18) not null default '0',
   MONTH_SESSION_4 int(18) not null default '0',
   MONTH_SESSION_5 int(18) not null default '0',
   MONTH_SESSION_6 int(18) not null default '0',
   MONTH_SESSION_7 int(18) not null default '0',
   MONTH_SESSION_8 int(18) not null default '0',
   MONTH_SESSION_9 int(18) not null default '0',
   MONTH_SESSION_10 int(18) not null default '0',
   MONTH_SESSION_11 int(18) not null default '0',
   MONTH_SESSION_12 int(18) not null default '0',
   MONTH_HIT_1 int(18) not null default '0',
   MONTH_HIT_2 int(18) not null default '0',
   MONTH_HIT_3 int(18) not null default '0',
   MONTH_HIT_4 int(18) not null default '0',
   MONTH_HIT_5 int(18) not null default '0',
   MONTH_HIT_6 int(18) not null default '0',
   MONTH_HIT_7 int(18) not null default '0',
   MONTH_HIT_8 int(18) not null default '0',
   MONTH_HIT_9 int(18) not null default '0',
   MONTH_HIT_10 int(18) not null default '0',
   MONTH_HIT_11 int(18) not null default '0',
   MONTH_HIT_12 int(18) not null default '0',
   MONTH_EVENT_1 int(18) not null default '0',
   MONTH_EVENT_2 int(18) not null default '0',
   MONTH_EVENT_3 int(18) not null default '0',
   MONTH_EVENT_4 int(18) not null default '0',
   MONTH_EVENT_5 int(18) not null default '0',
   MONTH_EVENT_6 int(18) not null default '0',
   MONTH_EVENT_7 int(18) not null default '0',
   MONTH_EVENT_8 int(18) not null default '0',
   MONTH_EVENT_9 int(18) not null default '0',
   MONTH_EVENT_10 int(18) not null default '0',
   MONTH_EVENT_11 int(18) not null default '0',
   MONTH_EVENT_12 int(18) not null default '0',
   MONTH_FAVORITE_1 int(18) not null default '0',
   MONTH_FAVORITE_2 int(18) not null default '0',
   MONTH_FAVORITE_3 int(18) not null default '0',
   MONTH_FAVORITE_4 int(18) not null default '0',
   MONTH_FAVORITE_5 int(18) not null default '0',
   MONTH_FAVORITE_6 int(18) not null default '0',
   MONTH_FAVORITE_7 int(18) not null default '0',
   MONTH_FAVORITE_8 int(18) not null default '0',
   MONTH_FAVORITE_9 int(18) not null default '0',
   MONTH_FAVORITE_10 int(18) not null default '0',
   MONTH_FAVORITE_11 int(18) not null default '0',
   MONTH_FAVORITE_12 int(18) not null default '0',
   primary key (ID),
   unique IX_SITE_ID_DATE_STAT (SITE_ID, DATE_STAT));

create table if not exists b_stat_event (
   ID int(18) not null auto_increment,
   EVENT1 varchar(166),
   EVENT2 varchar(166),
   MONEY decimal(18,4) not null default '0.0000',
   DATE_ENTER datetime,
   DATE_CLEANUP datetime,
   C_SORT int(18) default '100',
   COUNTER int(18) not null default '0',
   ADV_VISIBLE char(1) not null default 'Y',
   NAME varchar(50),
   DESCRIPTION text,
   KEEP_DAYS int(18),
   DYNAMIC_KEEP_DAYS int(18),
   DIAGRAM_DEFAULT char(1) not null default 'Y',
   primary key (ID),
   index IX_EVENT1_EVENT2 (EVENT1, EVENT2));
CREATE INDEX IX_B_STAT_EVENT_2 ON b_stat_event (KEEP_DAYS);

create table if not exists b_stat_event_day (
   ID int(18) not null auto_increment,
   DATE_STAT date,
   DATE_LAST datetime,
   EVENT_ID int(18) not null default '0',
   MONEY decimal(18,4) not null default '0.0000',
   COUNTER int(18) not null default '0',
   primary key (ID),
   index IX_EVENT_ID_DATE_STAT (EVENT_ID, DATE_STAT));

create table if not exists b_stat_event_list (
   ID int(18) not null auto_increment,
   EVENT_ID int(18) not null default '0',
   EVENT3 varchar(255),
   MONEY decimal(18,4) not null default '0.0000',
   DATE_ENTER datetime not null,
   REFERER_URL text,
   URL text,
   REDIRECT_URL text,
   SESSION_ID int(18),
   GUEST_ID int(18),
   ADV_ID int(18),
   ADV_BACK char(1) not null default 'N',
   HIT_ID int(18),
   COUNTRY_ID char(2),
   KEEP_DAYS int(18),
   CHARGEBACK char(1) not null default 'N',
   SITE_ID char(2),
   REFERER_SITE_ID char(2),
   primary key (ID),
   index IX_GUEST_ID (GUEST_ID));
CREATE INDEX IX_B_STAT_EVENT_LIST_2 ON b_stat_event_list (EVENT_ID, DATE_ENTER);
CREATE INDEX IX_B_STAT_EVENT_LIST_3 ON b_stat_event_list (KEEP_DAYS, DATE_ENTER);

create table if not exists b_stat_guest (
   ID int(18) not null auto_increment,
   TIMESTAMP_X timestamp,
   FAVORITES char(1) not null default 'N',
   C_EVENTS int(18) not null default '0',
   SESSIONS int(18) not null default '0',
   HITS int(18) not null default '0',
   REPAIR char(1) not null default 'N',
   FIRST_SESSION_ID int(18),
   FIRST_DATE datetime,
   FIRST_URL_FROM text,
   FIRST_URL_TO text,
   FIRST_URL_TO_404 char(1) not null default 'N',
   FIRST_SITE_ID char(2),
   FIRST_ADV_ID int(18),
   FIRST_REFERER1 varchar(255),
   FIRST_REFERER2 varchar(255),
   FIRST_REFERER3 varchar(255),
   LAST_SESSION_ID int(18),
   LAST_DATE datetime,
   LAST_USER_ID int(18),
   LAST_USER_AUTH char(1),
   LAST_URL_LAST text,
   LAST_URL_LAST_404 char(1) not null default 'N',
   LAST_USER_AGENT text,
   LAST_IP varchar(15),
   LAST_COOKIE text,
   LAST_LANGUAGE varchar(255),
   LAST_ADV_ID int(18),
   LAST_ADV_BACK char(1) not null default 'N',
   LAST_REFERER1 varchar(255),
   LAST_REFERER2 varchar(255),
   LAST_REFERER3 varchar(255),
   LAST_SITE_ID char(2),
   LAST_COUNTRY_ID char(2),
   LAST_CITY_ID int(18),
   LAST_CITY_INFO text,
   primary key (ID),
   index IX_LAST_DATE (LAST_DATE));

create table if not exists b_stat_hit (
   ID int(18) not null auto_increment,
   SESSION_ID int(18) not null default '0',
   DATE_HIT datetime,
   GUEST_ID int(18),
   NEW_GUEST char(1) not null default 'N',
   USER_ID int(18),
   USER_AUTH char(1),
   URL text,
   URL_404 char(1) not null default 'N',
   URL_FROM text,
   IP varchar(15),
   METHOD varchar(10),
   COOKIES text,
   USER_AGENT text,
   STOP_LIST_ID int(18),
   COUNTRY_ID char(2),
   CITY_ID int(18),
   SITE_ID char(2),
   primary key (ID),
   index IX_DATE_HIT (DATE_HIT));

create table if not exists b_stat_searcher_hit (
   ID int(18) not null auto_increment,
   DATE_HIT datetime,
   SEARCHER_ID int(18) not null default '0',
   URL text not null,
   URL_404 char(1) not null default 'N',
   IP varchar(15),
   USER_AGENT text,
   HIT_KEEP_DAYS int(18),
   SITE_ID char(2),
   primary key (ID));
CREATE INDEX IX_B_STAT_SEARCHER_HIT_1 ON b_stat_searcher_hit (SEARCHER_ID, DATE_HIT);
CREATE INDEX IX_B_STAT_SEARCHER_HIT_2 ON b_stat_searcher_hit (HIT_KEEP_DAYS, DATE_HIT);

create table if not exists b_stat_phrase_list (
   ID int(18) not null auto_increment,
   DATE_HIT datetime,
   SEARCHER_ID int(18),
   REFERER_ID int(18),
   PHRASE varchar(255) not null,
   URL_FROM text,
   URL_TO text,
   URL_TO_404 char(1) not null default 'N',
   SESSION_ID int(18),
   SITE_ID char(2),
   primary key (ID),
   index IX_DATE_HIT (DATE_HIT),
   index IX_URL_TO_SEARCHER_ID (URL_TO(100), SEARCHER_ID)
);

create table if not exists b_stat_referer (
   ID int(18) not null auto_increment,
   DATE_FIRST datetime,
   DATE_LAST datetime not null,
   SITE_NAME varchar(255) not null,
   SESSIONS int(18) not null default '0',
   HITS int(18) not null default '0',
   primary key (ID),
   index IX_SITE_NAME (SITE_NAME));
CREATE INDEX IX_B_STAT_REFERER_2 ON b_stat_referer(DATE_LAST, ID);

create table if not exists b_stat_referer_list (
   ID int(18) not null auto_increment,
   REFERER_ID int(18),
   DATE_HIT datetime,
   PROTOCOL varchar(10) not null,
   SITE_NAME varchar(255) not null,
   URL_FROM text not null,
   URL_TO text,
   URL_TO_404 char(1) not null default 'N',
   SESSION_ID int(18),
   ADV_ID int(18),
   SITE_ID char(2),
   primary key (ID),
   index IX_DATE_HIT (DATE_HIT),
   index IX_SITE_NAME (SITE_NAME(100), URL_TO(100))
);

create table if not exists b_stat_searcher (
   ID int(18) not null auto_increment,
   DATE_CLEANUP datetime,
   TOTAL_HITS int(18) not null default '0',
   SAVE_STATISTIC char(1) not null default 'Y',
   ACTIVE char(1) not null default 'Y',
   NAME varchar(255) not null,
   USER_AGENT text,
   DIAGRAM_DEFAULT char(1) not null default 'N',
   HIT_KEEP_DAYS int(18),
   DYNAMIC_KEEP_DAYS int(18),
   PHRASES int(18) not null default '0',
   PHRASES_HITS int(18) not null default '0',
   CHECK_ACTIVITY char(1) not null default 'Y',
   primary key (ID));
CREATE INDEX IX_B_STAT_SEARCHER_1 ON b_stat_searcher (HIT_KEEP_DAYS);

create table if not exists b_stat_searcher_params (
   ID int(18) not null auto_increment,
   SEARCHER_ID int(18) not null default '0',
   DOMAIN varchar(255),
   VARIABLE varchar(255),
   CHAR_SET varchar(255),
   primary key (ID),
   index IX_SEARCHER_DOMAIN (SEARCHER_ID, DOMAIN));

create table if not exists b_stat_session (
   ID int(18) not null auto_increment,
   GUEST_ID int(18),
   NEW_GUEST char(1) not null default 'N',
   USER_ID int(18),
   USER_AUTH char(1),
   C_EVENTS int(18) not null default '0',
   HITS int(18) not null default '0',
   FAVORITES char(1) not null default 'N',
   URL_FROM text,
   URL_TO text,
   URL_TO_404 char(1) not null default 'N',
   URL_LAST text,
   URL_LAST_404 char(1) not null default 'N',
   USER_AGENT text,
   DATE_STAT date,
   DATE_FIRST datetime,
   DATE_LAST datetime,
   IP_FIRST varchar(15),
   IP_FIRST_NUMBER bigint(20),
   IP_LAST varchar(15),
   IP_LAST_NUMBER bigint(20),
   FIRST_HIT_ID int(18),
   LAST_HIT_ID int(18),
   PHPSESSID varchar(255),
   ADV_ID int(18),
   ADV_BACK char(1),
   REFERER1 varchar(255),
   REFERER2 varchar(255),
   REFERER3 varchar(255),
   STOP_LIST_ID int(18),
   COUNTRY_ID char(2),
   CITY_ID int(18),
   FIRST_SITE_ID char(2),
   LAST_SITE_ID char(2),
   primary key (ID),
   index IX_IP_FIRST_NUMBER_DATE_STAT (IP_FIRST_NUMBER, DATE_STAT),
   index IX_B_STAT_SESSION_4 (USER_ID, DATE_STAT),
   index IX_DATE_STAT (DATE_STAT),
   INDEX IX_B_STAT_SESSION_5 (DATE_LAST),
   INDEX IX_B_STAT_SESSION_6 (GUEST_ID)
);

create table if not exists b_stat_page (
   ID int(11) not null auto_increment,
   DATE_STAT date not null,
   DIR char(1) not null default 'N',
   URL text not null,
   URL_404 char(1) not null default 'N',
   URL_HASH int(32),
   SITE_ID char(2),
   COUNTER int(11) not null default '0',
   ENTER_COUNTER int(18) not null default '0',
   EXIT_COUNTER int(18) not null default '0',
   primary key (ID),
   index IX_DATE_STAT (DATE_STAT),
   index IX_URL_HASH (URL_HASH));

create table if not exists b_stop_list (
   ID int(18) not null auto_increment,
   TIMESTAMP_X timestamp,
   DATE_START datetime,
   DATE_END datetime,
   ACTIVE char(1) not null default 'Y',
   SAVE_STATISTIC char(1) not null default 'N',
   IP_1 int(18),
   IP_2 int(18),
   IP_3 int(18),
   IP_4 int(18),
   MASK_1 int(18),
   MASK_2 int(18),
   MASK_3 int(18),
   MASK_4 int(18),
   USER_AGENT text,
   USER_AGENT_IS_NULL char(1) not null default 'N',
   URL_TO text,
   URL_FROM text,
   MESSAGE text,
   MESSAGE_LID char(2) not null default 'en',
   URL_REDIRECT text,
   COMMENTS text,
   TEST char(1) not null default 'N',
   SITE_ID char(2),
   primary key (ID));

create table if not exists b_stat_browser (
   ID int(18) not null auto_increment,
   USER_AGENT varchar(255) not null,
   primary key (ID));

create table if not exists b_stat_adv_day (
   ID int(18) not null auto_increment,
   ADV_ID int(18) not null default '0',
   DATE_STAT date,
   GUESTS int(18) not null default '0',
   GUESTS_DAY int(18) not null default '0',
   NEW_GUESTS int(18) not null default '0',
   FAVORITES int(18) not null default '0',
   C_HOSTS int(18) not null default '0',
   C_HOSTS_DAY int(18) not null default '0',
   SESSIONS int(18) not null default '0',
   HITS int(18) not null default '0',
   GUESTS_BACK int(18) not null default '0',
   GUESTS_DAY_BACK int(18) not null default '0',
   FAVORITES_BACK int(18) not null default '0',
   HOSTS_BACK int(18) not null default '0',
   HOSTS_DAY_BACK int(18) not null default '0',
   SESSIONS_BACK int(18) not null default '0',
   HITS_BACK int(18) not null default '0',
   primary key (ID),
   index IX_ADV_ID_DATE_STAT (ADV_ID, DATE_STAT),
   index IX_DATE_STAT (DATE_STAT));

create table if not exists b_stat_adv_event_day (
   ID int(18) not null auto_increment,
   ADV_ID int(18) default '0',
   EVENT_ID int(18) default '0',
   DATE_STAT date,
   COUNTER int(18) not null default '0',
   COUNTER_BACK int(18) not null default '0',
   MONEY decimal(18,4) not null default '0.0000',
   MONEY_BACK decimal(18,4) not null default '0.0000',
   primary key (ID),
   index IX_ADV_ID_EVENT_ID_DATE_STAT (ADV_ID, EVENT_ID, DATE_STAT),
   index IX_DATE_STAT (DATE_STAT));

create table if not exists b_stat_searcher_day (
   ID int(18) not null auto_increment,
   DATE_STAT date,
   DATE_LAST datetime,
   SEARCHER_ID int(18) not null default '0',
   TOTAL_HITS int(18) not null default '0',
   primary key (ID),
   index IX_SEARCHER_ID_DATE_STAT (SEARCHER_ID, DATE_STAT));

create table if not exists b_stat_country (
   ID char(2) not null,
   SHORT_NAME char(3),
   NAME varchar(50),
   SESSIONS int(18) not null default '0',
   NEW_GUESTS int(18) not null default '0',
   HITS int(18) not null default '0',
   C_EVENTS int(18) not null default '0',
   primary key (ID));

create table if not exists b_stat_city (
   ID int(18) not null auto_increment,
   COUNTRY_ID char(2) not null,
   REGION varchar(200),
   NAME varchar(255),
   XML_ID varchar(255),
   SESSIONS int(18) not null default '0',
   NEW_GUESTS int(18) not null default '0',
   HITS int(18) not null default '0',
   C_EVENTS int(18) not null default '0',
   primary key (ID),
   index UX_B_STAT_CITY(COUNTRY_ID, REGION(50), NAME(50)),
   index IX_B_STAT_CITY_XML_ID(XML_ID));

create table if not exists b_stat_city_day (
   ID int(18) not null auto_increment,
   CITY_ID int(18) not null,
   DATE_STAT date not null,
   SESSIONS int(18) not null default '0',
   NEW_GUESTS int(18) not null default '0',
   HITS int(18) not null default '0',
   C_EVENTS int(18) not null default '0',
   primary key (ID),
   index IX_B_STAT_CITY_DAY_1(CITY_ID, DATE_STAT),
   index IX_B_STAT_CITY_DAY_2(DATE_STAT));

create table if not exists b_stat_city_ip (
   START_IP bigint(18) not null,
   END_IP bigint(18) not null,
   COUNTRY_ID char(2) not null,
   CITY_ID int(18) not null,
   primary key (START_IP),
   index IX_B_STAT_CITY_IP_END_IP(END_IP));

create table if not exists b_stat_session_data (
  ID int(18) not null auto_increment,
  DATE_FIRST datetime null,
  DATE_LAST datetime null,
  GUEST_MD5 varchar(255) not null,
  SESS_SESSION_ID int(18) null,
  SESSION_DATA text null,
  primary key (ID),
  index IX_GUEST_MD5(GUEST_MD5));

create table if not exists b_stat_country_day (
   ID int(18) not null auto_increment,
   COUNTRY_ID char(2) not null,
   DATE_STAT date,
   SESSIONS int(18) not null default '0',
   NEW_GUESTS int(18) not null default '0',
   HITS int(18) not null default '0',
   C_EVENTS int(18) not null default '0',
   primary key (ID),
   index IX_COUNTRY_ID_DATE_STAT (COUNTRY_ID, DATE_STAT));

create table if not exists b_stat_path (
   ID int(18) not null auto_increment,
   PATH_ID int(32) not null default '0',
   PARENT_PATH_ID int(32),
   DATE_STAT date,
   COUNTER int(18) not null default '0',
   COUNTER_ABNORMAL int(18) not null default '0',
   COUNTER_FULL_PATH int(18) not null default '0',
   PAGES text,
   FIRST_PAGE varchar(255),
   FIRST_PAGE_404 char(1) not null default 'N',
   FIRST_PAGE_SITE_ID char(2),
   PREV_PAGE varchar(255),
   PREV_PAGE_HASH int(32),
   LAST_PAGE varchar(255),
   LAST_PAGE_404 char(1) not null default 'N',
   LAST_PAGE_SITE_ID char(2),
   LAST_PAGE_HASH int(32),
   STEPS int(18) not null default '1',
   primary key (ID),
   index IX_PATH_ID_DATE_STAT (PATH_ID, DATE_STAT),
   index IX_PREV_PAGE_HASH_LAST_PAGE_HASH (PREV_PAGE_HASH, LAST_PAGE_HASH),
   index IX_DATE_STAT (DATE_STAT));

create table if not exists b_stat_path_adv (
   ID int(18) not null auto_increment,
   ADV_ID int(18) not null default '0',
   PATH_ID int(32) not null default '0',
   DATE_STAT date,
   COUNTER int(18) not null default '0',
   COUNTER_BACK int(18) not null default '0',
   COUNTER_FULL_PATH int(18) not null default '0',
   COUNTER_FULL_PATH_BACK int(18) not null default '0',
   STEPS int(18) not null default '0',
   primary key (ID),
   index IX_PATH_ID_ADV_ID_DATE_STAT (PATH_ID, ADV_ID, DATE_STAT),
   index IX_DATE_STAT(DATE_STAT));

create table if not exists b_stat_path_cache (
   ID int(18) not null auto_increment,
   SESSION_ID int(18) not null default '0',
   DATE_HIT datetime,
   PATH_ID int(32),
   PATH_PAGES text,
   PATH_FIRST_PAGE varchar(255),
   PATH_FIRST_PAGE_404 char(1) not null default 'N',
   PATH_FIRST_PAGE_SITE_ID char(2),
   PATH_LAST_PAGE varchar(255),
   PATH_LAST_PAGE_404 char(1) not null default 'N',
   PATH_LAST_PAGE_SITE_ID char(2),
   PATH_STEPS int(18) not null default '1',
   IS_LAST_PAGE char(1) not null default 'Y',
   primary key (ID),
   index IX_SESSION_ID (SESSION_ID));

create table if not exists b_stat_page_adv (
   ID int(18) not null auto_increment,
   DATE_STAT date,
   PAGE_ID int(18) not null default '0',
   ADV_ID int(18) not null default '0',
   COUNTER int(18) not null default '0',
   ENTER_COUNTER int(18) not null default '0',
   EXIT_COUNTER int(18) not null default '0',
   COUNTER_BACK int(18) not null default '0',
   ENTER_COUNTER_BACK int(18) not null default '0',
   EXIT_COUNTER_BACK int(18) not null default '0',
   primary key (ID),
   index IX_PAGE_ID_ADV_ID (PAGE_ID, ADV_ID),
   index IX_DATE_STAT (DATE_STAT));

create table if not exists b_stat_ddl (
   ID int(18) not null auto_increment,
   SQL_TEXT varchar(255) not null,
   primary key (ID));
