
CREATE TABLE b_socialservices_user (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LOGIN varchar(100) NOT NULL,
  NAME varchar(100),
  LAST_NAME varchar(100),
  EMAIL varchar(100),
  PERSONAL_PHOTO int,
  EXTERNAL_AUTH_ID varchar(100) NOT NULL,
  USER_ID int NOT NULL,
  XML_ID varchar(100) NOT NULL,
  CAN_DELETE char(1) NOT NULL DEFAULT 'Y',
  PERSONAL_WWW varchar(100),
  PERMISSIONS varchar(555),
  OATOKEN text,
  OATOKEN_EXPIRES int,
  OASECRET text,
  REFRESH_TOKEN text,
  SEND_ACTIVITY char(1) DEFAULT 'Y',
  SITE_ID varchar(50),
  INITIALIZED char(1) DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_socialservices_user_xml_id_external_auth_id ON b_socialservices_user (xml_id, external_auth_id);
CREATE INDEX ix_b_socialservices_user_login ON b_socialservices_user (login);
CREATE INDEX ix_b_socialservices_user_user_id_external_auth_id ON b_socialservices_user (user_id, external_auth_id);

CREATE TABLE b_socialservices_message (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  SOCSERV_USER_ID int NOT NULL,
  PROVIDER varchar(100) NOT NULL,
  MESSAGE varchar(1000),
  INSERT_DATE timestamp,
  SUCCES_SENT char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);

CREATE TABLE b_socialservices_user_link (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  SOCSERV_USER_ID int NOT NULL,
  LINK_USER_ID int,
  LINK_UID varchar(100) NOT NULL,
  LINK_NAME varchar(255),
  LINK_LAST_NAME varchar(255),
  LINK_PICTURE varchar(255),
  LINK_EMAIL varchar(255),
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_socialservices_user_link_socserv_user_id ON b_socialservices_user_link (socserv_user_id);
CREATE INDEX ix_b_socialservices_user_link_link_user_id_timestamp_x ON b_socialservices_user_link (link_user_id, timestamp_x);
CREATE INDEX ix_b_socialservices_user_link_link_uid ON b_socialservices_user_link (link_uid);

CREATE TABLE b_socialservices_contact (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  USER_ID int NOT NULL,
  CONTACT_USER_ID int,
  CONTACT_XML_ID int,
  CONTACT_NAME varchar(255),
  CONTACT_LAST_NAME varchar(255),
  CONTACT_PHOTO varchar(255),
  LAST_AUTHORIZE timestamp,
  NOTIFY char(1) DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_socialservices_contact_user_id ON b_socialservices_contact (user_id);
CREATE INDEX ix_b_socialservices_contact_contact_user_id ON b_socialservices_contact (contact_user_id);
CREATE INDEX ix_b_socialservices_contact_timestamp_x ON b_socialservices_contact (timestamp_x);
CREATE INDEX ix_b_socialservices_contact_last_authorize ON b_socialservices_contact (last_authorize);

CREATE TABLE b_socialservices_contact_connect (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  CONTACT_ID int,
  LINK_ID int,
  CONTACT_PROFILE_ID int NOT NULL,
  CONTACT_PORTAL varchar(255) NOT NULL,
  CONNECT_TYPE char(1) DEFAULT 'P',
  LAST_AUTHORIZE timestamp,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_socialservices_contact_connect_contact_id ON b_socialservices_contact_connect (contact_id);
CREATE INDEX ix_b_socialservices_contact_connect_link_id ON b_socialservices_contact_connect (link_id);
CREATE INDEX ix_b_socialservices_contact_connect_last_authorize ON b_socialservices_contact_connect (last_authorize);

CREATE TABLE b_socialservices_ap (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  USER_ID int NOT NULL,
  DOMAIN varchar(255) NOT NULL,
  ENDPOINT varchar(255),
  LOGIN varchar(50),
  PASSWORD varchar(50),
  LAST_AUTHORIZE timestamp,
  SETTINGS varchar(1000),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_socialservices_ap_user_id_domain ON b_socialservices_ap (user_id, domain);

CREATE TABLE b_socialservices_zoom_meeting (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE_ID varchar(10) NOT NULL,
  ENTITY_ID int NOT NULL,
  CONFERENCE_URL varchar(255) NOT NULL,
  CONFERENCE_EXTERNAL_ID int8 NOT NULL,
  CONFERENCE_PASSWORD text,
  JOINED char(1),
  CONFERENCE_CREATED timestamp,
  CONFERENCE_STARTED timestamp,
  CONFERENCE_ENDED timestamp,
  DURATION int,
  TITLE text,
  SHORT_LINK varchar(255),
  HAS_RECORDING char(1),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_socialservices_zoom_meeting_conference_external_id ON b_socialservices_zoom_meeting (conference_external_id);
CREATE INDEX ix_b_socialservices_zoom_meeting_entity_type_id_entity_id ON b_socialservices_zoom_meeting (entity_type_id, entity_id);

CREATE TABLE b_socialservices_zoom_meeting_recording (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  EXTERNAL_ID varchar(64) NOT NULL,
  MEETING_ID int NOT NULL,
  START_DATE timestamp NOT NULL,
  END_DATE timestamp NOT NULL,
  FILE_TYPE varchar(16) NOT NULL,
  FILE_SIZE int NOT NULL,
  PLAY_URL varchar(500),
  DOWNLOAD_URL varchar(500),
  RECORDING_TYPE varchar(64) NOT NULL,
  DOWNLOAD_TOKEN text,
  PASSWORD text,
  FILE_ID int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_socialservices_zoom_meeting_recording_meeting_id ON b_socialservices_zoom_meeting_recording (meeting_id);
