
CREATE TABLE b_seo_keywords (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SITE_ID char(2) NOT NULL,
  URL varchar(255),
  KEYWORDS text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_seo_keywords_url_site_id ON b_seo_keywords (url, site_id);

CREATE TABLE b_seo_search_engine (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(50) NOT NULL,
  ACTIVE char(1) DEFAULT 'Y',
  SORT int DEFAULT 100,
  NAME varchar(255) NOT NULL,
  CLIENT_ID varchar(255),
  CLIENT_SECRET varchar(255),
  REDIRECT_URI varchar(255),
  SETTINGS text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_seo_search_engine_code ON b_seo_search_engine (code);
INSERT INTO b_seo_search_engine (CODE, ACTIVE, SORT, NAME, CLIENT_ID, CLIENT_SECRET, REDIRECT_URI) VALUES ('google', 'Y', 200, 'Google', '868942902147-qrrd6ce1ajfkpse8ieq4gkpdeanvtnno.apps.googleusercontent.com', 'EItMlJpZLC2WRPKB6QsA5bV9', 'urn:ietf:wg:oauth:2.0:oob');
INSERT INTO b_seo_search_engine (CODE, ACTIVE, SORT, NAME, CLIENT_ID, CLIENT_SECRET, REDIRECT_URI) VALUES ('yandex', 'Y', 300, 'Yandex', 'f848c7bfc1d34a94ba6d05439f81bbd7', 'da0e73b2d9cc4e809f3170e49cb9df01', 'https://oauth.yandex.ru/verification_code');
INSERT INTO b_seo_search_engine (CODE, ACTIVE, SORT, NAME, CLIENT_ID, CLIENT_SECRET, REDIRECT_URI) VALUES ('yandex_direct', 'Y', 400, 'Yandex.Direct', '', '', 'https://oauth.yandex.ru/verification_code');


CREATE TABLE b_seo_sitemap (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp,
  SITE_ID char(2) NOT NULL,
  ACTIVE char(1) DEFAULT 'Y',
  NAME varchar(255) DEFAULT '',
  DATE_RUN timestamp DEFAULT NULL,
  SETTINGS text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_seo_sitemap_job (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SITEMAP_ID int NOT NULL DEFAULT 0,
  RUNNING char(1) NOT NULL DEFAULT 'N',
  STATUS char(1) NOT NULL DEFAULT 'R',
  STATUS_MESSAGE varchar(255),
  STEP int NOT NULL DEFAULT 0,
  STATE text,
  DATE_MODIFY timestamp,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_seo_sitemap_job_sitemap_id ON b_seo_sitemap_job (sitemap_id);
CREATE INDEX ix_b_seo_sitemap_job_sitemap_id_status ON b_seo_sitemap_job (sitemap_id, status);

CREATE TABLE b_seo_sitemap_runtime (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PID int NOT NULL,
  PROCESSED char(1) NOT NULL DEFAULT 'N',
  ITEM_PATH varchar(700),
  ITEM_ID int,
  ITEM_TYPE char(1) NOT NULL DEFAULT 'D',
  ACTIVE char(1) DEFAULT 'Y',
  ACTIVE_ELEMENT char(1) DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_seo_sitemap_runtime_pid_processed_item_type_item_id ON b_seo_sitemap_runtime (pid, processed, item_type, item_id);

CREATE TABLE b_seo_sitemap_iblock (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  IBLOCK_ID int NOT NULL,
  SITEMAP_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_seo_sitemap_iblock_iblock_id ON b_seo_sitemap_iblock (iblock_id);
CREATE INDEX ix_b_seo_sitemap_iblock_sitemap_id ON b_seo_sitemap_iblock (sitemap_id);

CREATE TABLE b_seo_sitemap_entity (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE varchar(255) NOT NULL,
  ENTITY_ID int NOT NULL,
  SITEMAP_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_seo_sitemap_entity_entity_type_entity_id ON b_seo_sitemap_entity (entity_type, entity_id);
CREATE INDEX ix_b_seo_sitemap_entity_sitemap_id ON b_seo_sitemap_entity (sitemap_id);

CREATE TABLE b_seo_adv_campaign (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENGINE_ID int NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  OWNER_ID varchar(255) NOT NULL,
  OWNER_NAME varchar(255) NOT NULL,
  XML_ID varchar(255) NOT NULL,
  NAME varchar(255) NOT NULL,
  LAST_UPDATE timestamp,
  SETTINGS text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_seo_adv_campaign_engine_id_xml_id ON b_seo_adv_campaign (engine_id, xml_id);

CREATE TABLE b_seo_adv_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENGINE_ID int NOT NULL,
  OWNER_ID varchar(255) NOT NULL,
  OWNER_NAME varchar(255) NOT NULL,
  ACTIVE char(1) DEFAULT 'Y',
  XML_ID varchar(255) NOT NULL,
  LAST_UPDATE timestamp,
  NAME varchar(255) NOT NULL,
  SETTINGS text,
  CAMPAIGN_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_seo_adv_group_engine_id_xml_id ON b_seo_adv_group (engine_id, xml_id);
CREATE INDEX ix_b_seo_adv_group_campaign_id ON b_seo_adv_group (campaign_id);

CREATE TABLE b_seo_adv_banner (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENGINE_ID int NOT NULL,
  OWNER_ID varchar(255) NOT NULL,
  OWNER_NAME varchar(255) NOT NULL,
  ACTIVE char(1) DEFAULT 'Y',
  XML_ID varchar(255) NOT NULL,
  LAST_UPDATE timestamp,
  NAME varchar(255) NOT NULL,
  SETTINGS text,
  CAMPAIGN_ID int NOT NULL,
  GROUP_ID int,
  AUTO_QUANTITY_OFF char(1) DEFAULT 'N',
  AUTO_QUANTITY_ON char(1) DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_seo_adv_banner_engine_id_xml_id ON b_seo_adv_banner (engine_id, xml_id);
CREATE INDEX ix_b_seo_adv_banner_campaign_id ON b_seo_adv_banner (campaign_id);
CREATE INDEX ix_b_seo_adv_banner_auto_quantity_off_auto_quantity_on ON b_seo_adv_banner (auto_quantity_off, auto_quantity_on);

CREATE TABLE b_seo_adv_region (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENGINE_ID int NOT NULL,
  OWNER_ID varchar(255) NOT NULL,
  OWNER_NAME varchar(255) NOT NULL,
  ACTIVE char(1) DEFAULT 'Y',
  XML_ID varchar(255) NOT NULL,
  LAST_UPDATE timestamp,
  NAME varchar(255) NOT NULL,
  SETTINGS text,
  PARENT_ID int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_seo_adv_region_engine_id_xml_id ON b_seo_adv_region (engine_id, xml_id);
CREATE INDEX ix_b_seo_adv_region_parent_id ON b_seo_adv_region (parent_id);

CREATE TABLE b_seo_adv_link (
  LINK_TYPE char(1) NOT NULL,
  LINK_ID int NOT NULL,
  BANNER_ID int NOT NULL,
  PRIMARY KEY (LINK_TYPE, LINK_ID, BANNER_ID)
);

CREATE TABLE b_seo_adv_order (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENGINE_ID int NOT NULL,
  TIMESTAMP_X timestamp NOT NULL,
  CAMPAIGN_ID int NOT NULL,
  BANNER_ID int NOT NULL,
  ORDER_ID int NOT NULL,
  SUM real DEFAULT 0,
  PROCESSED char(1) DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_seo_adv_order_engine_id_campaign_id_banner_id_order_id ON b_seo_adv_order (engine_id, campaign_id, banner_id, order_id);
CREATE INDEX ix_b_seo_adv_order_order_id_processed ON b_seo_adv_order (order_id, processed);

CREATE TABLE b_seo_adv_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENGINE_ID int NOT NULL,
  TIMESTAMP_X timestamp NOT NULL,
  REQUEST_URI varchar(100) NOT NULL,
  REQUEST_DATA text,
  RESPONSE_TIME real NOT NULL,
  RESPONSE_STATUS int,
  RESPONSE_DATA text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_seo_adv_log_engine_id ON b_seo_adv_log (engine_id);
CREATE INDEX ix_b_seo_adv_log_timestamp_x ON b_seo_adv_log (timestamp_x);

CREATE TABLE b_seo_adv_autolog (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENGINE_ID int NOT NULL,
  TIMESTAMP_X timestamp NOT NULL,
  CAMPAIGN_ID int NOT NULL,
  CAMPAIGN_XML_ID varchar(255) NOT NULL,
  BANNER_ID int NOT NULL,
  BANNER_XML_ID varchar(255) NOT NULL,
  CAUSE_CODE int DEFAULT 0,
  SUCCESS char(1) DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_seo_adv_autolog_engine_id ON b_seo_adv_autolog (engine_id);
CREATE INDEX ix_b_seo_adv_autolog_timestamp_x ON b_seo_adv_autolog (timestamp_x);

CREATE TABLE b_seo_yandex_direct_stat (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CAMPAIGN_ID int NOT NULL,
  BANNER_ID int NOT NULL,
  DATE_DAY date NOT NULL,
  CURRENCY char(3),
  SUM real DEFAULT 0,
  SUM_SEARCH real DEFAULT 0,
  SUM_CONTEXT real DEFAULT 0,
  CLICKS int DEFAULT 0,
  CLICKS_SEARCH int DEFAULT 0,
  CLICKS_CONTEXT int DEFAULT 0,
  SHOWS int DEFAULT 0,
  SHOWS_SEARCH int DEFAULT 0,
  SHOWS_CONTEXT int DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_seo_yandex_direct_stat_banner_id_date_day ON b_seo_yandex_direct_stat (banner_id, date_day);
CREATE INDEX ix_b_seo_yandex_direct_stat_campaign_id ON b_seo_yandex_direct_stat (campaign_id);

CREATE TABLE b_seo_service_rtg_queue (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp DEFAULT NULL,
  TYPE varchar(20) NOT NULL,
  CLIENT_ID varchar(50) DEFAULT NULL,
  ACCOUNT_ID varchar(50) DEFAULT NULL,
  AUDIENCE_ID varchar(50) NOT NULL,
  PARENT_ID varchar(100) DEFAULT NULL,
  CONTACT_TYPE varchar(15) NOT NULL,
  VALUE varchar(255) NOT NULL,
  ACTION char(3) NOT NULL,
  DATE_AUTO_REMOVE timestamp DEFAULT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_seo_service_rtg_queue_action_date_auto_remove ON b_seo_service_rtg_queue (action, date_auto_remove);
CREATE INDEX ix_b_seo_service_rtg_queue_type_action ON b_seo_service_rtg_queue (type, action);

CREATE TABLE b_seo_service_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  TYPE varchar(20) NOT NULL,
  CODE varchar(20) DEFAULT NULL,
  MESSAGE varchar(1000) NOT NULL,
  GROUP_ID varchar(20) NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_seo_service_webhook (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp,
  TYPE varchar(20) NOT NULL,
  EXTERNAL_ID varchar(50) NOT NULL,
  SECURITY_CODE varchar(32) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_seo_service_webhook_type_external_id ON b_seo_service_webhook (type, external_id);

CREATE TABLE b_seo_service_subscription (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_INSERT timestamp,
  TYPE varchar(20) NOT NULL,
  GROUP_ID varchar(50) NOT NULL,
  CALLBACK_SERVER_ID varchar(50),
  HAS_AUTH char(1) NOT NULL DEFAULT 'N',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_seo_service_subscription_type_group_id ON b_seo_service_subscription (type, group_id);

CREATE TABLE b_seo_service_queue (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE varchar(20) NOT NULL,
  SERVICE_TYPE varchar(20) NOT NULL,
  CLIENT_ID int NOT NULL,
  SORT int NOT NULL DEFAULT 100,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_seo_service_queue_type ON b_seo_service_queue (type);
CREATE INDEX ix_b_seo_service_queue_service_type_client_id ON b_seo_service_queue (service_type, client_id);
