CREATE TABLE b_sec_filter_mask (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SORT int NOT NULL DEFAULT 10,
  SITE_ID char(2),
  FILTER_MASK varchar(250),
  LIKE_MASK varchar(250),
  PREG_MASK varchar(250),
  PRIMARY KEY (ID)
);

CREATE TABLE b_sec_iprule (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  RULE_TYPE char(1) NOT NULL DEFAULT 'M',
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  ADMIN_SECTION char(1) NOT NULL DEFAULT 'Y',
  SITE_ID char(2),
  SORT int NOT NULL DEFAULT 500,
  ACTIVE_FROM timestamp,
  ACTIVE_FROM_TIMESTAMP int,
  ACTIVE_TO timestamp,
  ACTIVE_TO_TIMESTAMP int,
  NAME varchar(250),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sec_iprule_active_to ON b_sec_iprule (active_to);

CREATE TABLE b_sec_iprule_incl_mask (
  IPRULE_ID int NOT NULL,
  RULE_MASK varchar(250),
  SORT int NOT NULL DEFAULT 500,
  LIKE_MASK varchar(250),
  PREG_MASK varchar(250),
  PRIMARY KEY (IPRULE_ID, RULE_MASK)
);

CREATE TABLE b_sec_iprule_excl_mask (
  IPRULE_ID int NOT NULL,
  RULE_MASK varchar(250),
  SORT int NOT NULL DEFAULT 500,
  LIKE_MASK varchar(250),
  PREG_MASK varchar(250),
  PRIMARY KEY (IPRULE_ID, RULE_MASK)
);

CREATE TABLE b_sec_iprule_incl_ip (
  IPRULE_ID int NOT NULL,
  RULE_IP varchar(50) NOT NULL,
  SORT int NOT NULL DEFAULT 500,
  IP_START int8,
  IP_END int8,
  PRIMARY KEY (IPRULE_ID, RULE_IP)
);

CREATE TABLE b_sec_iprule_excl_ip (
  IPRULE_ID int NOT NULL,
  RULE_IP varchar(50) NOT NULL,
  SORT int NOT NULL DEFAULT 500,
  IP_START int8,
  IP_END int8,
  PRIMARY KEY (IPRULE_ID, RULE_IP)
);

CREATE TABLE b_sec_session (
  SESSION_ID varchar(250) NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  SESSION_DATA text,
  PRIMARY KEY (SESSION_ID)
);
CREATE INDEX ix_b_sec_session_timestamp_x ON b_sec_session (timestamp_x);

CREATE TABLE b_sec_user (
  USER_ID int NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'N',
  SECRET varchar(64),
  TYPE varchar(16) NOT NULL,
  INIT_PARAMS text,
  PARAMS text,
  ATTEMPTS int,
  INITIAL_DATE timestamp,
  SKIP_MANDATORY char(1) NOT NULL DEFAULT 'N',
  DEACTIVATE_UNTIL timestamp,
  PRIMARY KEY (USER_ID)
);

CREATE TABLE b_sec_redirect_url (
  IS_SYSTEM char(1) NOT NULL DEFAULT 'Y',
  SORT int NOT NULL DEFAULT 500,
  URL varchar(250) NOT NULL,
  PARAMETER_NAME varchar(250) NOT NULL
);

CREATE TABLE b_sec_white_list (
  ID int NOT NULL,
  WHITE_SUBSTR varchar(250) NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sec_virus (
  ID varchar(32) NOT NULL,
  TIMESTAMP_X timestamp NOT NULL,
  SITE_ID char(2),
  SENT char(1) NOT NULL DEFAULT 'N',
  INFO text NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sec_frame_mask (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SORT int NOT NULL DEFAULT 10,
  SITE_ID char(2),
  FRAME_MASK varchar(250),
  LIKE_MASK varchar(250),
  PREG_MASK varchar(250),
  PRIMARY KEY (ID)
);

CREATE TABLE b_security_sitecheck (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TEST_DATE timestamp,
  RESULTS text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_sec_recovery_codes (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  CODE varchar(255) NOT NULL,
  USED varchar(1) NOT NULL DEFAULT 'N',
  USING_DATE timestamp,
  USING_IP varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_sec_recovery_codes_user_id ON b_sec_recovery_codes (user_id);

CREATE TABLE b_sec_xscan_results (
  id int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  type varchar(5) NOT NULL,
  src varchar(255) NOT NULL,
  message varchar(255) NOT NULL,
  score double precision NOT NULL,
  mtime timestamp,
  ctime timestamp,
  tags text,
  PRIMARY KEY (id)
);
