CREATE TABLE b_search_content
(
	ID INT(11) NOT NULL auto_increment,
	DATE_CHANGE DATETIME NOT NULL,
	MODULE_ID VARCHAR(50) NOT NULL,
	ITEM_ID VARCHAR(255) NOT NULL,
	CUSTOM_RANK INT(11) NOT NULL DEFAULT 0,
	USER_ID INT(11),
	ENTITY_TYPE_ID VARCHAR(50),
	ENTITY_ID VARCHAR(255),
	URL TEXT,
	TITLE TEXT,
	BODY LONGTEXT,
	TAGS TEXT,
	PARAM1 TEXT,
	PARAM2 TEXT,
	UPD varchar(32),
	DATE_FROM DATETIME,
	DATE_TO DATETIME,
	PRIMARY KEY PK_B_SEARCH_CONTENT (ID),
	UNIQUE UX_B_SEARCH_CONTENT (MODULE_ID, ITEM_ID),
	KEY IX_B_SEARCH_CONTENT_1 (MODULE_ID, PARAM1(50), PARAM2(50)),
	KEY IX_B_SEARCH_CONTENT_2 (ENTITY_ID(50), ENTITY_TYPE_ID)
);

CREATE TABLE b_search_content_text
(
	SEARCH_CONTENT_ID INT(11) NOT NULL,
	SEARCH_CONTENT_MD5 CHAR(32) NOT NULL,
	SEARCHABLE_CONTENT LONGTEXT,
	PRIMARY KEY PK_B_SEARCH_CONTENT_TEXT (SEARCH_CONTENT_ID)
);

CREATE TABLE b_search_content_param
(
	SEARCH_CONTENT_ID INT(11) NOT NULL,
	PARAM_NAME VARCHAR(100) NOT NULL,
	PARAM_VALUE VARCHAR(100) NOT NULL,
	KEY IX_B_SEARCH_CONTENT_PARAM (SEARCH_CONTENT_ID, PARAM_NAME),
	KEY IX_B_SEARCH_CONTENT_PARAM_1 (PARAM_NAME, PARAM_VALUE(50), SEARCH_CONTENT_ID)
);

CREATE TABLE b_search_content_right
(
	SEARCH_CONTENT_ID INT(11) NOT NULL,
	GROUP_CODE VARCHAR(100) NOT NULL,
	UNIQUE UX_B_SEARCH_CONTENT_RIGHT (SEARCH_CONTENT_ID, GROUP_CODE)
);

CREATE TABLE b_search_user_right
(
	USER_ID INT(11) NOT NULL,
	GROUP_CODE VARCHAR(100) NOT NULL,
	UNIQUE UX_B_SEARCH_USER_RIGHT (USER_ID, GROUP_CODE)
);

CREATE TABLE b_search_content_site
(
	SEARCH_CONTENT_ID INT(18) NOT NULL,
	SITE_ID CHAR(2) NOT NULL,
	URL TEXT,
	PRIMARY KEY PK_B_IBLOCK_SITE (SEARCH_CONTENT_ID, SITE_ID)
);

CREATE TABLE b_search_content_stem
(
	SEARCH_CONTENT_ID INT(11) NOT NULL,
	LANGUAGE_ID CHAR(2) NOT NULL,
	STEM INT(11) NOT NULL,
	TF FLOAT NOT NULL,
	PS FLOAT NOT NULL,
	UNIQUE KEY UX_B_SEARCH_CONTENT_STEM (STEM, LANGUAGE_ID, TF, PS, SEARCH_CONTENT_ID),
	KEY IND_B_SEARCH_CONTENT_STEM (SEARCH_CONTENT_ID)
)
DELAY_KEY_WRITE=1;

CREATE TABLE b_search_stem
(
	ID INT(11) NOT NULL auto_increment,
	STEM VARCHAR(50) BINARY NOT NULL,
	PRIMARY KEY PK_B_SEARCH_STEM (ID),
	UNIQUE KEY UX_B_SEARCH_STEM (STEM)
);

CREATE TABLE b_search_content_title
(
	SEARCH_CONTENT_ID INT(11) NOT NULL,
	SITE_ID CHAR(2) NOT NULL,
	POS INT(11) NOT NULL,
	WORD VARCHAR(100) NOT NULL,
	UNIQUE KEY UX_B_SEARCH_CONTENT_TITLE (SITE_ID, WORD, SEARCH_CONTENT_ID, POS),
	KEY IND_B_SEARCH_CONTENT_TITLE (SEARCH_CONTENT_ID)
)
DELAY_KEY_WRITE=1;

CREATE TABLE b_search_content_freq
(
	STEM INT NOT NULL DEFAULT '0',
	LANGUAGE_ID CHAR(2) NOT NULL,
	SITE_ID CHAR(2),
	FREQ FLOAT,
	TF FLOAT,
	UNIQUE KEY UX_B_SEARCH_CONTENT_FREQ (STEM, LANGUAGE_ID, SITE_ID)
);

CREATE TABLE b_search_custom_rank
(
	ID INT(11) NOT NULL auto_increment,
	APPLIED CHAR(1) NOT NULL DEFAULT 'N',
	`RANK` INT(11) NOT NULL DEFAULT 0,
	SITE_ID CHAR(2) NOT NULL,
	MODULE_ID VARCHAR(200) NOT NULL,
	PARAM1 TEXT,
	PARAM2 TEXT,
	ITEM_ID VARCHAR(255),
	PRIMARY KEY PK_B_SEARCH_CUSTOM_RANK (ID),
	KEY IND_B_SEARCH_CUSTOM_RANK (SITE_ID,MODULE_ID)
);

CREATE TABLE b_search_tags
(
	SEARCH_CONTENT_ID INT(11) NOT NULL,
	SITE_ID CHAR(2) NOT NULL,
	NAME VARCHAR(255) binary NOT NULL,
	PRIMARY KEY PK_B_SEARCH_TAGS (SEARCH_CONTENT_ID, SITE_ID, NAME),
	KEY IX_B_SEARCH_TAGS_0 (NAME)
)
DELAY_KEY_WRITE=1;

CREATE TABLE b_search_suggest
(
	ID INT(11) NOT NULL auto_increment,
	SITE_ID CHAR(2) NOT NULL,
	FILTER_MD5 VARCHAR(32) NOT NULL,
	PHRASE VARCHAR(250) NOT NULL,
	RATE FLOAT NOT NULL,
	TIMESTAMP_X DATETIME NOT NULL,
	RESULT_COUNT INT(11) NOT NULL,
	PRIMARY KEY PK_B_SEARCH_SUGGEST (ID),
	KEY IND_B_SEARCH_SUGGEST (FILTER_MD5, PHRASE(50), RATE),
	KEY IND_B_SEARCH_SUGGEST_PHRASE (PHRASE(50), RATE),
	KEY IND_B_SEARCH_SUGGEST_TIME (TIMESTAMP_X)
);
