function JCTitleSearch(arParams)
{
	var _this = this;

	this.arParams = {
		'AJAX_PAGE': arParams.AJAX_PAGE,
		'CONTAINER_ID': arParams.CONTAINER_ID,
		'INPUT_ID': arParams.INPUT_ID,
		'MIN_QUERY_LEN': parseInt(arParams.MIN_QUERY_LEN, 10),
	};
	if (arParams.WAIT_IMAGE)
	{
		this.arParams.WAIT_IMAGE = arParams.WAIT_IMAGE;
	}

	if (this.arParams.MIN_QUERY_LEN <= 0)
	{
		this.arParams.MIN_QUERY_LEN = 1;
	}

	this.cache = [];
	this.cache_key = null;

	this.startText = '';
	this.running = false;
	this.runningCall = false;
	this.currentRow = -1;
	this.RESULT = null;
	this.CONTAINER = null;
	this.INPUT = null;
	this.WAIT = null;

	this.ShowResult = function(result)
	{
		if (BX.type.isString(result))
		{
			_this.RESULT.innerHTML = result;
		}

		_this.RESULT.style.display = _this.RESULT.innerHTML === '' ? 'none' : 'block';
		var pos = _this.adjustResultNode();

		// adjust left column to be an outline
		var resultPosition = null;
		var th = null;
		var tbl = BX.findChild(_this.RESULT, { 'tag': 'table', 'class': 'title-search-result' }, true);
		if (tbl)
		{
			th = BX.findChild(tbl, { 'tag': 'th' }, true);
		}

		if (th)
		{
			var tablePosition = BX.pos(tbl);
			tablePosition.width = tablePosition.right - tablePosition.left;

			var tableHeaderPosition = BX.pos(th);
			tableHeaderPosition.width = tableHeaderPosition.right - tableHeaderPosition.left;
			th.style.width = tableHeaderPosition.width + 'px';

			_this.RESULT.style.width = (pos.width + tableHeaderPosition.width) + 'px';

			// Move table to left by width of the first column
			_this.RESULT.style.left = (pos.left - tableHeaderPosition.width - 1) + 'px';

			// Shrink table when it's too wide
			if ((tablePosition.width - tableHeaderPosition.width) > pos.width)
			{
				_this.RESULT.style.width = (pos.width + tableHeaderPosition.width - 1) + 'px';
			}

			// Check if table is too wide and shrink result div to it's width
			tablePosition = BX.pos(tbl);
			resultPosition = BX.pos(_this.RESULT);
			if (resultPosition.right > tablePosition.right)
			{
				_this.RESULT.style.width = (tablePosition.right - tablePosition.left) + 'px';
			}
		}

		var fade = false;
		if (tbl)
		{
			fade = BX.findChild(_this.RESULT, { 'class': 'title-search-fader' }, true);
		}

		if (fade && th)
		{
			resultPosition = BX.pos(_this.RESULT);
			fade.style.left = (resultPosition.right - resultPosition.left - 18) + 'px';
			fade.style.width = 18 + 'px';
			fade.style.top = 0 + 'px';
			fade.style.height = (resultPosition.bottom - resultPosition.top) + 'px';
			fade.style.display = 'block';
		}
	};

	this.onKeyPress = function(keyCode)
	{
		var tbl = BX.findChild(_this.RESULT, { 'tag': 'table', 'class': 'title-search-result' }, true);
		if (!tbl)
		{
			return false;
		}

		var i = 0;
		var cnt = tbl.rows.length;

		switch (keyCode)
		{
			case 27: // escape key - close search div
				_this.RESULT.style.display = 'none';
				_this.currentRow = -1;
				_this.UnSelectAll();

				return true;
			case 40: // down key - navigate down on search results
				if (_this.RESULT.style.display == 'none')
				{
					_this.RESULT.style.display = 'block';
				}

				var first = -1;
				for (i = 0; i < cnt; i++)
				{
					if (!BX.findChild(tbl.rows[i], { 'class': 'title-search-separator' }, true))
					{
						if (first == -1)
						{
							first = i;
						}

						if (_this.currentRow < i)
						{
							_this.currentRow = i;
							break;
						}
						else if (tbl.rows[i].className == 'title-search-selected')
						{
							tbl.rows[i].className = '';
						}
					}
				}

				if (i == cnt && _this.currentRow != i)
				{
					_this.currentRow = first;
				}

				tbl.rows[_this.currentRow].className = 'title-search-selected';

				return true;
			case 38: // up key - navigate up on search results
				if (_this.RESULT.style.display == 'none')
				{
					_this.RESULT.style.display = 'block';
				}

				var last = -1;
				for (i = cnt - 1; i >= 0; i--)
				{
					if (!BX.findChild(tbl.rows[i], { 'class': 'title-search-separator' }, true))
					{
						if (last == -1)
						{
							last = i;
						}

						if (_this.currentRow > i)
						{
							_this.currentRow = i;
							break;
						}
						else if (tbl.rows[i].className == 'title-search-selected')
						{
							tbl.rows[i].className = '';
						}
					}
				}

				if (i < 0 && _this.currentRow != i)
				{
					_this.currentRow = last;
				}

				tbl.rows[_this.currentRow].className = 'title-search-selected';

				return true;
			case 13: // enter key - choose current search result
				if (_this.RESULT.style.display == 'block')
				{
					for (i = 0; i < cnt; i++)
					{
						if (
							_this.currentRow == i
							&& !BX.findChild(tbl.rows[i], { 'class': 'title-search-separator' }, true)
						)
						{
							var a = BX.findChild(tbl.rows[i], { 'tag': 'a' }, true);
							if (a)
							{
								window.location = a.href;

								return true;
							}
						}
					}
				}

				return false;
			default:
				break;
		}

		return false;
	};

	this.onTimeout = function()
	{
		_this.onChange(function() {
			setTimeout(_this.onTimeout, 500);
		});
	};

	this.onChange = function(callback)
	{
		if (_this.running)
		{
			_this.runningCall = true;

			return;
		}
		_this.running = true;

		if (_this.INPUT.value != _this.oldValue && _this.INPUT.value != _this.startText)
		{
			_this.oldValue = _this.INPUT.value;
			if (_this.INPUT.value.length >= _this.arParams.MIN_QUERY_LEN)
			{
				_this.cache_key = _this.arParams.INPUT_ID + '|' + _this.INPUT.value;
				if (_this.cache[_this.cache_key] == null)
				{
					if (_this.WAIT)
					{
						var pos = BX.pos(_this.INPUT);
						var height = (pos.bottom - pos.top) - 2;
						_this.WAIT.style.top = (pos.top + 1) + 'px';
						_this.WAIT.style.height = height + 'px';
						_this.WAIT.style.width = height + 'px';
						_this.WAIT.style.left = (pos.right - height + 2) + 'px';
						_this.WAIT.style.display = 'block';
					}

					BX.ajax.post(
						_this.arParams.AJAX_PAGE,
						{
							'ajax_call': 'y',
							'INPUT_ID': _this.arParams.INPUT_ID,
							'q': _this.INPUT.value,
							'l': _this.arParams.MIN_QUERY_LEN,
						},
						function(result)
						{
							_this.cache[_this.cache_key] = result;
							_this.ShowResult(result);
							_this.currentRow = -1;
							_this.EnableMouseEvents();
							if (_this.WAIT)
							{
								_this.WAIT.style.display = 'none';
							}

							if (!!callback)
							{
								callback();
							}

							_this.running = false;
							if (_this.runningCall)
							{
								_this.runningCall = false;
								_this.onChange();
							}
						}
					);

					return;
				}

				_this.ShowResult(_this.cache[_this.cache_key]);
				_this.currentRow = -1;
				_this.EnableMouseEvents();
			}
			else
			{
				_this.RESULT.style.display = 'none';
				_this.currentRow = -1;
				_this.UnSelectAll();
			}
		}

		if (!!callback)
		{
			callback();
		}
		_this.running = false;
	};

	this.onScroll = function ()
	{
		if (BX.type.isElementNode(_this.RESULT)
			&& _this.RESULT.style.display !== 'none'
			&& _this.RESULT.innerHTML !== ''
		)
		{
			_this.adjustResultNode();
		}
	};

	this.UnSelectAll = function()
	{
		var tbl = BX.findChild(_this.RESULT, { 'tag': 'table', 'class': 'title-search-result' }, true);
		if (tbl)
		{
			var cnt = tbl.rows.length;
			for (var i = 0; i < cnt; i++)
			{
				tbl.rows[i].className = '';
			}
		}
	};

	this.EnableMouseEvents = function()
	{
		var tbl = BX.findChild(_this.RESULT, { 'tag': 'table', 'class': 'title-search-result' }, true);
		if (tbl)
		{
			var cnt = tbl.rows.length;
			for (var i = 0; i < cnt; i++)
			{
				if (!BX.findChild(tbl.rows[i], { 'class': 'title-search-separator' }, true))
				{
					tbl.rows[i].id = 'row_' + i;
					tbl.rows[i].onmouseover = function (e) {
						if (_this.currentRow != this.id.substr(4))
						{
							_this.UnSelectAll();
							this.className = 'title-search-selected';
							_this.currentRow = this.id.substr(4);
						}
					};

					tbl.rows[i].onmouseout = function (e) {
						this.className = '';
						_this.currentRow = -1;
					};
				}
			}
		}
	};

	this.onFocusLost = function(hide)
	{
		setTimeout(function() { _this.RESULT.style.display = 'none'; }, 250);
	};

	this.onFocusGain = function()
	{
		if (_this.RESULT.innerHTML.length > 0)
		{
			_this.ShowResult();
		}
	};

	this.onKeyDown = function(e)
	{
		if (!e)
		{
			e = window.event;
		}

		if (_this.RESULT.style.display == 'block' && _this.onKeyPress(e.keyCode))
		{
			return BX.PreventDefault(e);
		}
	};

	this.adjustResultNode = function()
	{
		if (!(BX.type.isElementNode(_this.RESULT)
			&& BX.type.isElementNode(_this.CONTAINER))
		)
		{
			return { top: 0, right: 0, bottom: 0, left: 0, width: 0, height: 0 };
		}

		var pos = BX.pos(_this.CONTAINER);

		_this.RESULT.style.position = 'absolute';
		_this.RESULT.style.top = (pos.bottom + 2) + 'px';
		_this.RESULT.style.left = pos.left + 'px';
		_this.RESULT.style.width = pos.width + 'px';

		return pos;
	};

	this.onContainerLayoutChange = function()
	{
		if (BX.type.isElementNode(_this.RESULT)
			&& _this.RESULT.style.display !== 'none'
			&& _this.RESULT.innerHTML !== ''
		)
		{
			_this.adjustResultNode();
		}
	};

	this.Init = function()
	{
		this.CONTAINER = document.getElementById(this.arParams.CONTAINER_ID);
		BX.addCustomEvent(this.CONTAINER, 'OnNodeLayoutChange', this.onContainerLayoutChange);

		this.RESULT = document.body.appendChild(document.createElement("DIV"));
		this.RESULT.className = 'title-search-result';
		this.INPUT = document.getElementById(this.arParams.INPUT_ID);
		this.startText = this.INPUT.value;
		this.oldValue = this.INPUT.value;
		BX.bind(this.INPUT, 'focus', function() { _this.onFocusGain(); });
		BX.bind(this.INPUT, 'blur', function() { _this.onFocusLost(); });
		this.INPUT.onkeydown = this.onKeyDown;

		if (this.arParams.WAIT_IMAGE)
		{
			this.WAIT = document.body.appendChild(document.createElement('DIV'));
			this.WAIT.style.backgroundImage = "url('" + this.arParams.WAIT_IMAGE + "')";
			if (!BX.browser.IsIE())
			{
				this.WAIT.style.backgroundRepeat = 'none';
			}
			this.WAIT.style.display = 'none';
			this.WAIT.style.position = 'absolute';
			this.WAIT.style.zIndex = '1100';
		}

		BX.bind(this.INPUT, 'bxchange', function() {_this.onChange()});

		var fixedParent = BX.findParent(this.CONTAINER, BX.is_fixed);
		if (BX.type.isElementNode(fixedParent))
		{
			BX.bind(window, 'scroll', BX.throttle(this.onScroll, 100, this));
		}
	};

	BX.ready(function() { _this.Init(arParams); });
}
