<?php

namespace Bitrix\Sale\Rest\Entity;

use Bitrix\Main\Error;
use Bitrix\Sale\Rest\Attributes;
use Bitrix\Sale\Result;

class BasketProperties extends Base
{
	public function getFields()
	{
		return [
			'ID' => [
				'TYPE' => self::TYPE_INT,
				'ATTRIBUTES' => [
					Attributes::ReadOnly,
				],
			],
			'BASKET_ID' => [
				'TYPE' => self::TYPE_INT,
				'ATTRIBUTES' => [
					Attributes::Required,
					Attributes::Immutable,
				],
			],
			'NAME' => [
				'TYPE' => self::TYPE_STRING,
				'ATTRIBUTES' => [
					Attributes::Required,
				],
			],
			'VALUE' => [
				'TYPE' => self::TYPE_STRING,
				'ATTRIBUTES' => [
					Attributes::Required,
				],
			],
			'CODE' => [
				'TYPE' => self::TYPE_STRING,
				'ATTRIBUTES' => [
					Attributes::Required,
				],
			],
			'SORT' => [
				'TYPE' => self::TYPE_INT,
			],
			'XML_ID' => [
				'TYPE' => self::TYPE_STRING,
			],
		];
	}

	public function internalizeFieldsModify($fields, $fieldsInfo=[])
	{
		$result = [];

		$fieldsInfo = empty($fieldsInfo) ? $this->getFields() : $fieldsInfo;
		$listFieldsInfoAdd = $this->getListFieldInfo(
			$fieldsInfo,
			[
				'filter' => [
					'ignoredAttributes' => [
						Attributes::Hidden,
						Attributes::ReadOnly,
					],
				],
			]
		);
		$listFieldsInfoUpdate = $this->getListFieldInfo(
			$fieldsInfo,
			[
				'filter' => [
					'ignoredAttributes' => [
						Attributes::Hidden,
						Attributes::ReadOnly,
						Attributes::Immutable,
					],
					'skipFields' => [
						'ID',
					],
				],
			]
		);

		foreach ($fields['BASKET_ITEM']['PROPERTIES'] as $k => $item)
		{
			$result['BASKET_ITEM']['PROPERTIES'][$k] = $this->internalizeFields(
				$item,
				$this->isNewItem($item) ? $listFieldsInfoAdd : $listFieldsInfoUpdate
			);
		}

		return $result;
	}

	public function checkFieldsModify($fields)
	{
		$result = new Result();

		$emptyFields = [];

		if (!isset($fields['BASKET_ITEM']['ID']))
		{
			$emptyFields[] = '[basketItem][id]';
		}
		if (!isset($fields['BASKET_ITEM']['PROPERTIES']) || !is_array($fields['BASKET_ITEM']['PROPERTIES']))
		{
			$emptyFields[] = '[basketItem][properties][]';
		}

		if (!empty($emptyFields))
		{
			$result->addError(new Error(implode(', ', $emptyFields)));
		}
		else
		{
			$result = parent::checkFieldsModify($fields);
		}

		return $result;
	}

	public function checkRequiredFieldsModify($fields)
	{
		$result = new Result();

		$listFieldsInfoAdd = $this->getListFieldInfo(
			$this->getFields(),
			[
				'filter' => [
					'ignoredAttributes' => [
						Attributes::Hidden,
						Attributes::ReadOnly,
					],
				],
			]
		);
		$listFieldsInfoUpdate = $this->getListFieldInfo(
			$this->getFields(),
			[
				'filter' => [
					'ignoredAttributes' => [
						Attributes::Hidden,
						Attributes::ReadOnly,
						Attributes::Immutable,
					],
				],
			]
		);

		foreach ($fields['BASKET_ITEM']['PROPERTIES'] as $k => $item)
		{
			$required = $this->checkRequiredFields(
				$item,
				$this->isNewItem($item) ? $listFieldsInfoAdd : $listFieldsInfoUpdate
			);
			if (!$required->isSuccess())
			{
				$result->addError(new Error(
					'[properties][' . $k . '] - '
						. implode(', ', $required->getErrorMessages())
						. '.'
				));
			}
		}

		return $result;
	}
}
