
CREATE TABLE b_rest_event (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  APP_ID int,
  EVENT_NAME varchar(255) NOT NULL,
  EVENT_HANDLER varchar(255) NOT NULL,
  USER_ID int DEFAULT 0,
  TITLE varchar(255) DEFAULT '',
  COMMENT varchar(255) DEFAULT '',
  DATE_CREATE timestamp,
  APPLICATION_TOKEN varchar(50) DEFAULT '',
  CONNECTOR_ID varchar(255) DEFAULT '',
  INTEGRATION_ID int,
  OPTIONS varchar(1024),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_rest_event_app_id_event_name_event_handler_user_id_connect ON b_rest_event (app_id, event_name, event_handler, user_id, connector_id);
CREATE INDEX ix_b_rest_event_event_name ON b_rest_event (event_name);

CREATE TABLE b_rest_app (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CLIENT_ID varchar(128) NOT NULL,
  CODE varchar(128) NOT NULL,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  INSTALLED char(1) NOT NULL DEFAULT 'N',
  URL varchar(1000) NOT NULL,
  URL_DEMO varchar(1000),
  URL_INSTALL varchar(1000),
  VERSION varchar(4) DEFAULT '1',
  SCOPE varchar(2000) NOT NULL,
  STATUS char(1) NOT NULL DEFAULT 'F',
  DATE_FINISH date,
  IS_TRIALED char(1) DEFAULT 'N',
  SHARED_KEY varchar(32) DEFAULT NULL,
  CLIENT_SECRET varchar(100) DEFAULT NULL,
  APP_NAME varchar(1000) DEFAULT NULL,
  ACCESS varchar(2000) DEFAULT '',
  APPLICATION_TOKEN varchar(50) DEFAULT '',
  MOBILE char(1) DEFAULT 'N',
  USER_INSTALL char(1) DEFAULT 'N',
  URL_SETTINGS varchar(1000),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_rest_app_client_id ON b_rest_app (client_id);

CREATE TABLE b_rest_app_lang (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  APP_ID int NOT NULL,
  LANGUAGE_ID char(2) NOT NULL,
  MENU_NAME varchar(500),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_rest_app_lang_app_id_language_id ON b_rest_app_lang (app_id, language_id);

CREATE TABLE b_rest_ap (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  PASSWORD varchar(50) NOT NULL,
  ACTIVE char(1) DEFAULT 'Y',
  TYPE varchar(15) NOT NULL DEFAULT 'user',
  TITLE varchar(255) DEFAULT '',
  COMMENT varchar(255) DEFAULT '',
  DATE_CREATE timestamp,
  DATE_LOGIN timestamp,
  LAST_IP varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_rest_ap_user_id_password_active ON b_rest_ap (user_id, password, active);

CREATE TABLE b_rest_ap_permission (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PASSWORD_ID int NOT NULL,
  PERM varchar(100) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_rest_ap_permission_password_id_perm ON b_rest_ap_permission (password_id, perm);

CREATE TABLE b_rest_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CLIENT_ID varchar(45),
  PASSWORD_ID int,
  EVENT_ID int,
  SCOPE varchar(50),
  METHOD varchar(255),
  REQUEST_METHOD varchar(10),
  REQUEST_URI varchar(255),
  REQUEST_AUTH text,
  REQUEST_DATA text,
  RESPONSE_STATUS varchar(20),
  RESPONSE_DATA text,
  MESSAGE text,
  PRIMARY KEY (ID)
);

CREATE TABLE b_rest_placement (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  APP_ID int,
  USER_ID int DEFAULT 0,
  PLACEMENT varchar(255) NOT NULL,
  PLACEMENT_HANDLER varchar(255) NOT NULL,
  ICON_ID int,
  TITLE varchar(255) DEFAULT '',
  GROUP_NAME varchar(255) DEFAULT '',
  COMMENT varchar(255) DEFAULT '',
  DATE_CREATE timestamp,
  ADDITIONAL varchar(255),
  OPTIONS varchar(2048),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_rest_placement_app_id_placement_placement_handler ON b_rest_placement (app_id, placement, placement_handler);
CREATE INDEX ix_b_rest_placement_placement_additional ON b_rest_placement (placement, additional);
CREATE INDEX ix_b_rest_placement_placement_user_id ON b_rest_placement (placement, user_id);

CREATE TABLE b_rest_event_offline (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp DEFAULT CURRENT_TIMESTAMP,
  MESSAGE_ID varchar(100) NOT NULL,
  APP_ID int NOT NULL,
  EVENT_NAME varchar(255) NOT NULL,
  EVENT_DATA text,
  EVENT_ADDITIONAL text,
  PROCESS_ID varchar(255) DEFAULT '',
  CONNECTOR_ID varchar(255) DEFAULT '',
  ERROR int DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_rest_event_offline_message_id_app_id_connector_id_process_ ON b_rest_event_offline (message_id, app_id, connector_id, process_id);
CREATE INDEX ix_b_rest_event_offline_timestamp_x ON b_rest_event_offline (timestamp_x);
CREATE INDEX ix_b_rest_event_offline_app_id_connector_id ON b_rest_event_offline (app_id, connector_id);
CREATE INDEX ix_b_rest_event_offline_process_id ON b_rest_event_offline (process_id);

CREATE TABLE b_rest_stat_method (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  NAME varchar(255) NOT NULL,
  METHOD_TYPE char(1) DEFAULT 'M',
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_rest_stat_method_name ON b_rest_stat_method (name);

CREATE TABLE b_rest_stat_app (
  APP_ID int NOT NULL,
  APP_CODE varchar(128) NOT NULL,
  PRIMARY KEY (APP_ID)
);
CREATE INDEX ix_b_rest_stat_app_app_code ON b_rest_stat_app (app_code);

CREATE TABLE b_rest_stat (
  STAT_DATE date NOT NULL,
  APP_ID int NOT NULL,
  METHOD_ID int NOT NULL,
  HOUR_0 int NOT NULL DEFAULT 0,
  HOUR_1 int NOT NULL DEFAULT 0,
  HOUR_2 int NOT NULL DEFAULT 0,
  HOUR_3 int NOT NULL DEFAULT 0,
  HOUR_4 int NOT NULL DEFAULT 0,
  HOUR_5 int NOT NULL DEFAULT 0,
  HOUR_6 int NOT NULL DEFAULT 0,
  HOUR_7 int NOT NULL DEFAULT 0,
  HOUR_8 int NOT NULL DEFAULT 0,
  HOUR_9 int NOT NULL DEFAULT 0,
  HOUR_10 int NOT NULL DEFAULT 0,
  HOUR_11 int NOT NULL DEFAULT 0,
  HOUR_12 int NOT NULL DEFAULT 0,
  HOUR_13 int NOT NULL DEFAULT 0,
  HOUR_14 int NOT NULL DEFAULT 0,
  HOUR_15 int NOT NULL DEFAULT 0,
  HOUR_16 int NOT NULL DEFAULT 0,
  HOUR_17 int NOT NULL DEFAULT 0,
  HOUR_18 int NOT NULL DEFAULT 0,
  HOUR_19 int NOT NULL DEFAULT 0,
  HOUR_20 int NOT NULL DEFAULT 0,
  HOUR_21 int NOT NULL DEFAULT 0,
  HOUR_22 int NOT NULL DEFAULT 0,
  HOUR_23 int NOT NULL DEFAULT 0,
  PRIMARY KEY (APP_ID, STAT_DATE, METHOD_ID)
);

CREATE TABLE b_rest_app_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  APP_ID int NOT NULL,
  ACTION_TYPE varchar(50) NOT NULL,
  USER_ID int NOT NULL,
  USER_ADMIN char(1) DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_rest_app_log_app_id ON b_rest_app_log (app_id);

CREATE TABLE b_rest_usage_entity (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  ENTITY_TYPE char(1) NOT NULL,
  ENTITY_ID int NOT NULL,
  ENTITY_CODE varchar(255) DEFAULT NULL,
  SUB_ENTITY_TYPE char(1),
  SUB_ENTITY_NAME varchar(255),
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_rest_usage_entity_entity_type_entity_id_sub_entity_type_su ON b_rest_usage_entity (entity_type, entity_id, sub_entity_type, sub_entity_name);

CREATE TABLE b_rest_usage_stat (
  STAT_DATE date NOT NULL,
  ENTITY_ID int NOT NULL DEFAULT 0,
  IS_SENT char(1) NOT NULL DEFAULT 'N',
  HOUR_0 int NOT NULL DEFAULT 0,
  HOUR_1 int NOT NULL DEFAULT 0,
  HOUR_2 int NOT NULL DEFAULT 0,
  HOUR_3 int NOT NULL DEFAULT 0,
  HOUR_4 int NOT NULL DEFAULT 0,
  HOUR_5 int NOT NULL DEFAULT 0,
  HOUR_6 int NOT NULL DEFAULT 0,
  HOUR_7 int NOT NULL DEFAULT 0,
  HOUR_8 int NOT NULL DEFAULT 0,
  HOUR_9 int NOT NULL DEFAULT 0,
  HOUR_10 int NOT NULL DEFAULT 0,
  HOUR_11 int NOT NULL DEFAULT 0,
  HOUR_12 int NOT NULL DEFAULT 0,
  HOUR_13 int NOT NULL DEFAULT 0,
  HOUR_14 int NOT NULL DEFAULT 0,
  HOUR_15 int NOT NULL DEFAULT 0,
  HOUR_16 int NOT NULL DEFAULT 0,
  HOUR_17 int NOT NULL DEFAULT 0,
  HOUR_18 int NOT NULL DEFAULT 0,
  HOUR_19 int NOT NULL DEFAULT 0,
  HOUR_20 int NOT NULL DEFAULT 0,
  HOUR_21 int NOT NULL DEFAULT 0,
  HOUR_22 int NOT NULL DEFAULT 0,
  HOUR_23 int NOT NULL DEFAULT 0,
  PRIMARY KEY (STAT_DATE, ENTITY_ID)
);
CREATE INDEX ix_b_rest_usage_stat_entity_id_stat_date ON b_rest_usage_stat (entity_id, stat_date);

CREATE TABLE b_rest_owner_entity (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  OWNER_TYPE char(1) NOT NULL,
  OWNER int NOT NULL,
  ENTITY_TYPE varchar(32) NOT NULL,
  ENTITY varchar(32) NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_rest_owner_entity_entity_type_entity ON b_rest_owner_entity (entity_type, entity);

CREATE TABLE b_rest_integration (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int DEFAULT NULL,
  ELEMENT_CODE varchar(256) NOT NULL,
  TITLE varchar(256) NOT NULL,
  PASSWORD_ID int DEFAULT NULL,
  APP_ID int DEFAULT NULL,
  SCOPE text,
  QUERY text,
  OUTGOING_EVENTS text,
  OUTGOING_NEEDED char(1) DEFAULT NULL,
  OUTGOING_HANDLER_URL varchar(2048) DEFAULT NULL,
  WIDGET_NEEDED char(1) DEFAULT NULL,
  WIDGET_HANDLER_URL varchar(2048) DEFAULT NULL,
  WIDGET_LIST text,
  APPLICATION_TOKEN varchar(50) DEFAULT NULL,
  APPLICATION_NEEDED char(1) DEFAULT NULL,
  APPLICATION_ONLY_API char(1) DEFAULT NULL,
  BOT_ID int DEFAULT NULL,
  BOT_HANDLER_URL varchar(2048) DEFAULT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_rest_configuration_storage (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CREATE_TIME timestamp DEFAULT CURRENT_TIMESTAMP,
  CONTEXT varchar(128) NOT NULL,
  CODE varchar(32) NOT NULL,
  DATA text NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_rest_placement_lang (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  PLACEMENT_ID int NOT NULL,
  LANGUAGE_ID varchar(2) NOT NULL,
  TITLE varchar(255),
  DESCRIPTION varchar(255),
  GROUP_NAME varchar(255),
  PRIMARY KEY (ID),
  UNIQUE (PLACEMENT_ID, LANGUAGE_ID)
);

CREATE TABLE IF NOT EXISTS b_rest_free_app
(
	APP_CODE varchar(128) NOT NULL UNIQUE,
	PRIMARY KEY (APP_CODE)
);
