(function(){"use strict";BX.namespace("BX.Report.Dashboard");BX.Report.Dashboard.Board=function(e){if(!BX.type.isPlainObject(e)){throw new Error("BX.Report.Dashboard.Board: 'options' is not an object.")}if(!BX.type.isDomNode(e.renderTo)){throw new Error("BX.Report.Dashboard.Board: 'renderTo' is not a DOMNode.")}this.renderTo=e.renderTo;this.id=e.id||null;this.rendered=false;this.designerMode=e.designerMode;this.isDefault=e.isDefault||false;this.defaultWidgetClass=e.defaultWidgetClass||"BX.Report.Dashboard.Widget";this.rowsOrder=[];this.layout={outerContainer:null,innerContainer:null,boardContainer:null,emptyBoardContainer:null};this.rowWithPseudoRows=null;this.addRows(e.rows);this.init()};BX.Report.Dashboard.Board.prototype={isEmpty:function(){return this.empty},setEmpty:function(e){this.empty=e;if(this.empty){BX.cleanNode(this.getBoardContainer());this.getBoardContainer().appendChild(this.getEmptyBoardContent())}else{BX.cleanNode(this.getBoardContainer())}},init:function(){BX.Report.Dashboard.BoardRepository.addBoard(this)},getId:function(){return this.id},toggleDesignerMode:function(){if(this.isDesignerMode()){this.setDesignerMode(false)}else{this.setDesignerMode(true)}},setDesignerMode:function(e){this.designerMode=e;if(this.designerMode){this.getInnerContainer().classList.add("report-visualconstructor-dashboard-designer-mode")}else{this.getInnerContainer().classList.remove("report-visualconstructor-dashboard-designer-mode")}},isDesignerMode:function(){return this.designerMode},getRenderToContainer:function(){return this.renderTo},getOuterContainer:function(){if(this.layout.outerContainer){return this.layout.outerContainer}this.layout.outerContainer=BX.create("div",{props:{className:"report-visualconstructor"}});return this.layout.outerContainer},getInnerContainer:function(){if(this.layout.innerContainer){return this.layout.innerContainer}this.layout.innerContainer=BX.create("div",{props:{className:"report-visualconstructor-inner"}});return this.layout.innerContainer},getBoardContainer:function(){if(this.layout.boardContainer){return this.layout.boardContainer}this.layout.boardContainer=BX.create("div",{props:{className:"report-visualconstructor-dashboard-container"}});return this.layout.boardContainer},scrollEventListener:function(){if(this.scrollEventListenerFunc!==undefined){return this.scrollEventListenerFunc}this.scrollEventListenerFunc=BX.throttle(this.lazyLoad,100,this);return this.scrollEventListenerFunc},lazyLoad:function(){var e=this.getRows();var t=document.documentElement.clientHeight;e.forEach(function(e){var r=e.getRowWrapper().getBoundingClientRect();if(r.top>=0&&r.top<=t||r.bottom>=0&&r.bottom<=t){e.lazyLoadWidgets()}})},addRow:function(e,t,r){if(this.isEmpty()){this.setEmpty(false)}var o=this.getRowObject(e);o.setBoard(this);if(r===true){this.addRowBefore(o,t)}else{this.addRowAfter(o,t)}jsDD.refreshDestArea();return o},getRowObject:function(e){var t;if(BX.type.isPlainObject(e)&&!(e instanceof BX.Report.Dashboard.Row)){t=new BX.Report.Dashboard.Row(e)}else if(e instanceof BX.Report.Dashboard.Row){t=e}else{throw new Error("Unable to create or get row object")}return t},addRowToStart:function(e){e.setBoard(this);this.rowsOrder.splice(0,0,e);if(this.isRendered()){BX.prepend(e.render(),this.getBoardContainer())}return e},addRowBefore:function(e,t){t=this.getRow(t);var r=BX.util.array_search(t,this.rowsOrder);if(r>=0){this.rowsOrder.splice(r,0,e);if(this.isRendered()){this.getBoardContainer().insertBefore(e.render(),t.getRowContainer())}}},addRowAfter:function(e,t){t=this.getRow(t);var r=BX.util.array_search(t,this.rowsOrder);var o=this.getNextRowSibling(t);if(r>=0&&o){this.rowsOrder.splice(r+1,0,e);if(this.isRendered()){this.getBoardContainer().insertBefore(e.render(),o.getRowContainer())}}else{this.rowsOrder.push(e);if(this.isRendered()){this.getBoardContainer().appendChild(e.render())}}},addRows:function(e){e.forEach(function(e){this.addRow(e)}.bind(this))},adjustRowsWeight:function(){var e=this.getRows();for(var t=0;t<e.length;t++){e[t].setWeight(t+1)}BX.onCustomEvent(this,"BX.Report.Dashboard.Board:afterRowsAdjust",[e])},getRows:function(){return this.rowsOrder},getRow:function(e){var t=e instanceof BX.Report.Dashboard.Row?e.getId():e;for(var r=0;r<this.rowsOrder.length;r++){if(this.rowsOrder[r]instanceof BX.Report.Dashboard.Row&&this.rowsOrder[r].getId()===t){return this.rowsOrder[r]}}return null},removeRow:function(e){var t=BX.util.array_search(e,this.rowsOrder);e.remove();this.rowsOrder.splice(t,1);BX.onCustomEvent(this,"BX.Report.Dashboard.Board:afterRowRemove",[{row:e}])},moveRow:function(e,t){e=this.getRow(e);t=this.getRow(t);if(!e||e===t){return false}var r=BX.util.array_search(e,this.rowsOrder);this.rowsOrder.splice(r,1);var o=BX.util.array_search(t,this.rowsOrder);if(o>=0){this.rowsOrder.splice(o,0,e);if(this.isRendered()){this.getBoardContainer().insertBefore(e.getRowContainer(),t.getRowContainer())}}else{this.rowsOrder.push(e);if(this.isRendered()){this.getBoardContainer().appendChild(e.getRowContainer())}}this.adjustRowsWeight();return true},getNextRowSibling:function(e){var t=this.getRowIndex(e);var r=this.getRows();return t!==-1&&r[t+1]?r[t+1]:null},getPreviousRowSibling:function(e){var t=this.getRowIndex(e);var r=this.getRows();return t>0&&r[t-1]?r[t-1]:null},getRowIndex:function(e){e=this.getRow(e);return BX.util.array_search(e,this.getRows())},render:function(){this.setDesignerMode(this.isDesignerMode());var e=document.createDocumentFragment();var t=this.getRows();BX.Report.Dashboard.Utils.forEach(t,function(r){e.appendChild(t[r].render())}.bind(this));BX.cleanNode(this.getBoardContainer());this.getBoardContainer().appendChild(e);if(!this.isRendered()){this.renderLayout();this.setRenderStatus(true);BX.onCustomEvent(this,"Dashboard.Board:onFirstRender",[this])}BX.onCustomEvent(this,"Dashboard.Board:onRender",[this]);window.addEventListener("scroll",this.scrollEventListener())},renderLayout:function(){if(this.getOuterContainer().parentNode){return}var e=this.getInnerContainer();e.appendChild(this.getBoardContainer());this.getRenderToContainer().appendChild(e);this.lazyLoad()},getEmptyBoardContent:function(){if(this.layout.emptyBoardContainer){return this.layout.emptyBoardContainer}this.layout.emptyBoardContainer=BX.create("div",{attrs:{className:"report-visualconstructor-empty-board"},text:BX.message("DASHBOARD_EMPTY_BOARD_CONTENT")});return this.layout.emptyBoardContainer},setRenderStatus:function(e){if(BX.type.isBoolean(e)){this.rendered=e}else{throw Error("Render status might be boolean")}},isRendered:function(){return this.rendered},clearRows:function(){this.rowsOrder=[]},destroy:function(){this.rendered=false;BX.remove(this.getBoardContainer());window.removeEventListener("scroll",this.scrollEventListener());var e=this.getRows();for(var t in e){if(e.hasOwnProperty(t)){e[t].destroy()}}},getWidget:function(e){var t=e instanceof BX.Report.Dashboard.Widget?e.getId():e;var r=this.getRows();for(var o=0;o<r.length;o++){if(r[o].getWidget(t)){return r[o].getWidget(t)}}return null},showPriorityPseudoRowsByYPos:function(e,t){var r=this.getRows();for(var o in r){if(!r.hasOwnProperty(o)){continue}var i=r[o];if(i.isPseudo()){continue}var s=i.getRectArea();var n=s.bottom;var a=s.top;if(a<=t&&n>=t){if(!i.hasShownPriorityPseudoRows){for(var d=0;d<e.length;d++){i.pseudoRowsList.push(e[d]);this.addRow(e[d],i,true)}i.hasShownPriorityPseudoRows=true}}else{var h=0;if(i.hasShownPriorityPseudoRows){for(var u=0;u<i.pseudoRowsList.length;u++){var l=i.pseudoRowsList[u];if(l.isRendered()){var f=l.getRectArea();if(!h){h=f.top}else if(h>f.top){h=f.top}}}if(t>n||t<h){this.removePseudoRows()}}}}},removePseudoRows:function(){var e=this.getRows();var t=[];for(var r=0;r<e.length;r++){if(e[r].isPseudo()){t.push(e[r])}else{e[r].hasShownPriorityPseudoRows=false}}for(var o=0;o<t.length;o++){this.removeRow(t[o])}jsDD.refreshDestArea()}};BX.Report.Dashboard.BoardRepository={dashboards:[],addBoard:function(e){this.dashboards.push(e)},getBoard:function(e){var t=this.getBoards();for(var r=0;r<t.length;r++){if(t[r].getId()===e){return t[r]}}return false},getBoards:function(){return this.dashboards},destroyBoards:function(){var e=this.getBoards();for(var t=0;t<e.length;t++){e[t].destroy();e.splice(t,1)}}}})();
//# sourceMappingURL=board.map.js