CREATE TABLE `b_report` (
  `ID` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `OWNER_ID` varchar(20) NULL,
  `TITLE` varchar(255) NOT NULL,
  `DESCRIPTION` text NULL,
  `CREATED_DATE` datetime NOT NULL,
  `CREATED_BY` int(11) unsigned NOT NULL,
  `SETTINGS` text NULL,
  `MARK_DEFAULT` smallint unsigned NULL,
  PRIMARY KEY (`ID`),
  KEY `OWNER_ID` (`OWNER_ID`)
);
CREATE TABLE IF NOT EXISTS `b_report_sharing` (
  ID int(11) NOT NULL AUTO_INCREMENT,
  REPORT_ID int(11) NOT NULL DEFAULT 0,
  ENTITY varchar(50) NOT NULL,
  RIGHTS varchar(50) NOT NULL,
  PRIMARY KEY (ID),
  INDEX IX_ENTITY (ENTITY),
  INDEX IX_REPORT_ID (REPORT_ID)
);
CREATE TABLE IF NOT EXISTS `b_report_visual_report_widget` (
  ID int (11) NOT NULL AUTO_INCREMENT,
  GID varchar(255) NOT NULL,
  VIEW_KEY varchar(255) NOT NULL,
  WIDGET_CLASS varchar(255) NOT NULL,
  BOARD_ID varchar(255) NOT NULL,
  DASHBOARD_ROW_ID int(11) NOT NULL,
  WEIGHT  varchar(25) NOT NULL DEFAULT "",
  CATEGORY_KEY varchar(255) NOT NULL DEFAULT "",
  OWNER_ID INT DEFAULT 0 NOT NULL,
  IS_PATTERN BOOLEAN DEFAULT false,
  PARENT_WIDGET_ID INT DEFAULT 0 NOT NULL,
  CREATED_DATE datetime NOT NULL,
  UPDATED_DATE datetime NOT NULL,
  PRIMARY KEY (ID),
  INDEX IX_BOARD_ID (BOARD_ID)

);
CREATE TABLE IF NOT EXISTS `b_report_visual_report_entity` (
  ID int(11) NOT  NULL  AUTO_INCREMENT,
  GID varchar(255) NOT NULL,
  WIDGET_ID int(11) NOT NULL,
  WEIGHT int(4) NOT NULL DEFAULT 0,
  REPORT_CLASS varchar(255),
  CREATED_DATE datetime NOT NULL,
  UPDATED_DATE datetime NOT NULL,
  PRIMARY KEY  (ID),
  INDEX IX_WIDGET_ID (WIDGET_ID)
);
CREATE TABLE IF NOT EXISTS `b_report_visual_report_configuration` (
  ID int(11) NOT  NULL  AUTO_INCREMENT,
  GID varchar(255) NOT NULL,
  WEIGHT int(4) NOT NULL DEFAULT 0,
  CREATED_DATE datetime NOT NULL,
  UPDATED_DATE datetime NOT NULL,
  UKEY varchar(255) NOT NULL,
  CONFIGURATION_FIELD_CLASS varchar(255) NOT NULL,
  SETTINGS text NULL,
  PRIMARY KEY (ID)
);
CREATE TABLE IF NOT EXISTS `b_report_visual_report_entity_config` (
  REPORT_ID int(11) NOT NULL,
  CONFIGURATION_ID int(11) NOT NULL,
  PRIMARY KEY  (REPORT_ID, CONFIGURATION_ID),
  INDEX IX_CONFIG_REPORT (CONFIGURATION_ID, REPORT_ID)
);
CREATE TABLE IF NOT EXISTS `b_report_visual_report_widget_config` (
  WIDGET_ID int(11) NOT NULL,
  CONFIGURATION_ID int(11) NOT NULL,
  PRIMARY KEY  (WIDGET_ID, CONFIGURATION_ID),
  INDEX IX_CONFIG_WIDGET (CONFIGURATION_ID, WIDGET_ID)
);
CREATE TABLE IF NOT EXISTS `b_report_visual_report_dashboard_row` (
  ID int(11) NOT  NULL  AUTO_INCREMENT,
  GID varchar(255) NOT NULL,
  BOARD_ID int(11) NOT NULL,
  WEIGHT int(4) NOT NULL DEFAULT 0,
  CREATED_DATE datetime NOT NULL,
  UPDATED_DATE datetime NOT NULL,
  LAYOUT_MAP TEXT NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE IF NOT EXISTS `b_report_visual_report_dashboard` (
    ID int(11) NOT  NULL  AUTO_INCREMENT,
    GID varchar(255) NOT NULL,
    VERSION varchar(255) NOT NULL DEFAULT '',
    BOARD_KEY varchar(255) NOT NULL,
    USER_ID INT DEFAULT 0 NOT NULL,
    CREATED_DATE datetime NOT NULL,
    UPDATED_DATE datetime NOT NULL,
    PRIMARY KEY (ID)
);