<?php
/**
 * Generated by Protobuf protoc plugin.
 *
 * File descriptor : descriptor.proto
 */


namespace google\protobuf;

/**
 * Protobuf message : google.protobuf.MethodDescriptorProto
 */
class MethodDescriptorProto extends \Protobuf\AbstractMessage
{

    /**
     * @var \Protobuf\UnknownFieldSet
     */
    protected $unknownFieldSet = null;

    /**
     * @var \Protobuf\Extension\ExtensionFieldMap
     */
    protected $extensions = null;

    /**
     * name optional string = 1
     *
     * @var string
     */
    protected $name = null;

    /**
     * input_type optional string = 2
     *
     * @var string
     */
    protected $input_type = null;

    /**
     * output_type optional string = 3
     *
     * @var string
     */
    protected $output_type = null;

    /**
     * options optional message = 4
     *
     * @var \google\protobuf\MethodOptions
     */
    protected $options = null;

    /**
     * client_streaming optional bool = 5
     *
     * @var bool
     */
    protected $client_streaming = null;

    /**
     * server_streaming optional bool = 6
     *
     * @var bool
     */
    protected $server_streaming = null;

    /**
     * {@inheritdoc}
     */
    public function __construct($stream = null, \Protobuf\Configuration $configuration = null)
    {
        $this->client_streaming = false;
        $this->server_streaming = false;

        parent::__construct($stream, $configuration);
    }

    /**
     * Check if 'name' has a value
     *
     * @return bool
     */
    public function hasName()
    {
        return $this->name !== null;
    }

    /**
     * Get 'name' value
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set 'name' value
     *
     * @param string $value
     */
    public function setName($value = null)
    {
        $this->name = $value;
    }

    /**
     * Check if 'input_type' has a value
     *
     * @return bool
     */
    public function hasInputType()
    {
        return $this->input_type !== null;
    }

    /**
     * Get 'input_type' value
     *
     * @return string
     */
    public function getInputType()
    {
        return $this->input_type;
    }

    /**
     * Set 'input_type' value
     *
     * @param string $value
     */
    public function setInputType($value = null)
    {
        $this->input_type = $value;
    }

    /**
     * Check if 'output_type' has a value
     *
     * @return bool
     */
    public function hasOutputType()
    {
        return $this->output_type !== null;
    }

    /**
     * Get 'output_type' value
     *
     * @return string
     */
    public function getOutputType()
    {
        return $this->output_type;
    }

    /**
     * Set 'output_type' value
     *
     * @param string $value
     */
    public function setOutputType($value = null)
    {
        $this->output_type = $value;
    }

    /**
     * Check if 'options' has a value
     *
     * @return bool
     */
    public function hasOptions()
    {
        return $this->options !== null;
    }

    /**
     * Get 'options' value
     *
     * @return \google\protobuf\MethodOptions
     */
    public function getOptions()
    {
        return $this->options;
    }

    /**
     * Set 'options' value
     *
     * @param \google\protobuf\MethodOptions $value
     */
    public function setOptions(\google\protobuf\MethodOptions $value = null)
    {
        $this->options = $value;
    }

    /**
     * Check if 'client_streaming' has a value
     *
     * @return bool
     */
    public function hasClientStreaming()
    {
        return $this->client_streaming !== null;
    }

    /**
     * Get 'client_streaming' value
     *
     * @return bool
     */
    public function getClientStreaming()
    {
        return $this->client_streaming;
    }

    /**
     * Set 'client_streaming' value
     *
     * @param bool $value
     */
    public function setClientStreaming($value = null)
    {
        $this->client_streaming = $value;
    }

    /**
     * Check if 'server_streaming' has a value
     *
     * @return bool
     */
    public function hasServerStreaming()
    {
        return $this->server_streaming !== null;
    }

    /**
     * Get 'server_streaming' value
     *
     * @return bool
     */
    public function getServerStreaming()
    {
        return $this->server_streaming;
    }

    /**
     * Set 'server_streaming' value
     *
     * @param bool $value
     */
    public function setServerStreaming($value = null)
    {
        $this->server_streaming = $value;
    }

    /**
     * {@inheritdoc}
     */
    public function extensions()
    {
        if ( $this->extensions !== null) {
            return $this->extensions;
        }

        return $this->extensions = new \Protobuf\Extension\ExtensionFieldMap(__CLASS__);
    }

    /**
     * {@inheritdoc}
     */
    public function unknownFieldSet()
    {
        return $this->unknownFieldSet;
    }

    /**
     * {@inheritdoc}
     */
    public static function fromStream($stream, \Protobuf\Configuration $configuration = null)
    {
        return new self($stream, $configuration);
    }

    /**
     * {@inheritdoc}
     */
    public static function fromArray(array $values)
    {
        $message = new self();
        $values  = array_merge([
            'name' => null,
            'input_type' => null,
            'output_type' => null,
            'options' => null,
            'client_streaming' => false,
            'server_streaming' => false
        ], $values);

        $message->setName($values['name']);
        $message->setInputType($values['input_type']);
        $message->setOutputType($values['output_type']);
        $message->setOptions($values['options']);
        $message->setClientStreaming($values['client_streaming']);
        $message->setServerStreaming($values['server_streaming']);

        return $message;
    }

    /**
     * {@inheritdoc}
     */
    public static function descriptor()
    {
        return \google\protobuf\DescriptorProto::fromArray([
            'name'      => 'MethodDescriptorProto',
            'field'     => [
                \google\protobuf\FieldDescriptorProto::fromArray([
                    'number' => 1,
                    'name' => 'name',
                    'type' => \google\protobuf\FieldDescriptorProto\Type::TYPE_STRING(),
                    'label' => \google\protobuf\FieldDescriptorProto\Label::LABEL_OPTIONAL()
                ]),
                \google\protobuf\FieldDescriptorProto::fromArray([
                    'number' => 2,
                    'name' => 'input_type',
                    'type' => \google\protobuf\FieldDescriptorProto\Type::TYPE_STRING(),
                    'label' => \google\protobuf\FieldDescriptorProto\Label::LABEL_OPTIONAL()
                ]),
                \google\protobuf\FieldDescriptorProto::fromArray([
                    'number' => 3,
                    'name' => 'output_type',
                    'type' => \google\protobuf\FieldDescriptorProto\Type::TYPE_STRING(),
                    'label' => \google\protobuf\FieldDescriptorProto\Label::LABEL_OPTIONAL()
                ]),
                \google\protobuf\FieldDescriptorProto::fromArray([
                    'number' => 4,
                    'name' => 'options',
                    'type' => \google\protobuf\FieldDescriptorProto\Type::TYPE_MESSAGE(),
                    'label' => \google\protobuf\FieldDescriptorProto\Label::LABEL_OPTIONAL(),
                    'type_name' => '.google.protobuf.MethodOptions'
                ]),
                \google\protobuf\FieldDescriptorProto::fromArray([
                    'number' => 5,
                    'name' => 'client_streaming',
                    'type' => \google\protobuf\FieldDescriptorProto\Type::TYPE_BOOL(),
                    'label' => \google\protobuf\FieldDescriptorProto\Label::LABEL_OPTIONAL(),
                    'default_value' => false
                ]),
                \google\protobuf\FieldDescriptorProto::fromArray([
                    'number' => 6,
                    'name' => 'server_streaming',
                    'type' => \google\protobuf\FieldDescriptorProto\Type::TYPE_BOOL(),
                    'label' => \google\protobuf\FieldDescriptorProto\Label::LABEL_OPTIONAL(),
                    'default_value' => false
                ]),
            ],
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function toStream(\Protobuf\Configuration $configuration = null)
    {
        $config  = $configuration ?: \Protobuf\Configuration::getInstance();
        $context = $config->createWriteContext();
        $stream  = $context->getStream();

        $this->writeTo($context);
        $stream->seek(0);

        return $stream;
    }

    /**
     * {@inheritdoc}
     */
    public function writeTo(\Protobuf\WriteContext $context)
    {
        $stream      = $context->getStream();
        $writer      = $context->getWriter();
        $sizeContext = $context->getComputeSizeContext();

        if ($this->name !== null) {
            $writer->writeVarint($stream, 10);
            $writer->writeString($stream, $this->name);
        }

        if ($this->input_type !== null) {
            $writer->writeVarint($stream, 18);
            $writer->writeString($stream, $this->input_type);
        }

        if ($this->output_type !== null) {
            $writer->writeVarint($stream, 26);
            $writer->writeString($stream, $this->output_type);
        }

        if ($this->options !== null) {
            $writer->writeVarint($stream, 34);
            $writer->writeVarint($stream, $this->options->serializedSize($sizeContext));
            $this->options->writeTo($context);
        }

        if ($this->client_streaming !== null) {
            $writer->writeVarint($stream, 40);
            $writer->writeBool($stream, $this->client_streaming);
        }

        if ($this->server_streaming !== null) {
            $writer->writeVarint($stream, 48);
            $writer->writeBool($stream, $this->server_streaming);
        }

        if ($this->extensions !== null) {
            $this->extensions->writeTo($context);
        }

        return $stream;
    }

    /**
     * {@inheritdoc}
     */
    public function readFrom(\Protobuf\ReadContext $context)
    {
        $reader = $context->getReader();
        $length = $context->getLength();
        $stream = $context->getStream();

        $limit = ($length !== null)
            ? ($stream->tell() + $length)
            : null;

        while ($limit === null || $stream->tell() < $limit) {

            if ($stream->eof()) {
                break;
            }

            $key  = $reader->readVarint($stream);
            $wire = \Protobuf\WireFormat::getTagWireType($key);
            $tag  = \Protobuf\WireFormat::getTagFieldNumber($key);

            if ($stream->eof()) {
                break;
            }

            if ($tag === 1) {
                \Protobuf\WireFormat::assertWireType($wire, 9);

                $this->name = $reader->readString($stream);

                continue;
            }

            if ($tag === 2) {
                \Protobuf\WireFormat::assertWireType($wire, 9);

                $this->input_type = $reader->readString($stream);

                continue;
            }

            if ($tag === 3) {
                \Protobuf\WireFormat::assertWireType($wire, 9);

                $this->output_type = $reader->readString($stream);

                continue;
            }

            if ($tag === 4) {
                \Protobuf\WireFormat::assertWireType($wire, 11);

                $innerSize    = $reader->readVarint($stream);
                $innerMessage = new \google\protobuf\MethodOptions();

                $this->options = $innerMessage;

                $context->setLength($innerSize);
                $innerMessage->readFrom($context);
                $context->setLength($length);

                continue;
            }

            if ($tag === 5) {
                \Protobuf\WireFormat::assertWireType($wire, 8);

                $this->client_streaming = $reader->readBool($stream);

                continue;
            }

            if ($tag === 6) {
                \Protobuf\WireFormat::assertWireType($wire, 8);

                $this->server_streaming = $reader->readBool($stream);

                continue;
            }

            $extensions = $context->getExtensionRegistry();
            $extension  = $extensions ? $extensions->findByNumber(__CLASS__, $tag) : null;

            if ($extension !== null) {
                $this->extensions()->add($extension, $extension->readFrom($context, $wire));

                continue;
            }

            if ($this->unknownFieldSet === null) {
                $this->unknownFieldSet = new \Protobuf\UnknownFieldSet();
            }

            $data    = $reader->readUnknown($stream, $wire);
            $unknown = new \Protobuf\Unknown($tag, $wire, $data);

            $this->unknownFieldSet->add($unknown);

        }
    }

    /**
     * {@inheritdoc}
     */
    public function serializedSize(\Protobuf\ComputeSizeContext $context)
    {
        $calculator = $context->getSizeCalculator();
        $size       = 0;

        if ($this->name !== null) {
            $size += 1;
            $size += $calculator->computeStringSize($this->name);
        }

        if ($this->input_type !== null) {
            $size += 1;
            $size += $calculator->computeStringSize($this->input_type);
        }

        if ($this->output_type !== null) {
            $size += 1;
            $size += $calculator->computeStringSize($this->output_type);
        }

        if ($this->options !== null) {
            $innerSize = $this->options->serializedSize($context);

            $size += 1;
            $size += $innerSize;
            $size += $calculator->computeVarintSize($innerSize);
        }

        if ($this->client_streaming !== null) {
            $size += 1;
            $size += 1;
        }

        if ($this->server_streaming !== null) {
            $size += 1;
            $size += 1;
        }

        if ($this->extensions !== null) {
            $size += $this->extensions->serializedSize($context);
        }

        return $size;
    }

    /**
     * {@inheritdoc}
     */
    public function clear()
    {
        $this->name = null;
        $this->input_type = null;
        $this->output_type = null;
        $this->options = null;
        $this->client_streaming = false;
        $this->server_streaming = false;
    }

    /**
     * {@inheritdoc}
     */
    public function merge(\Protobuf\Message $message)
    {
        if ( ! $message instanceof \google\protobuf\MethodDescriptorProto) {
            throw new \InvalidArgumentException(sprintf('Argument 1 passed to %s must be a %s, %s given', __METHOD__, __CLASS__, get_class($message)));
        }

        $this->name = ($message->name !== null) ? $message->name : $this->name;
        $this->input_type = ($message->input_type !== null) ? $message->input_type : $this->input_type;
        $this->output_type = ($message->output_type !== null) ? $message->output_type : $this->output_type;
        $this->options = ($message->options !== null) ? $message->options : $this->options;
        $this->client_streaming = ($message->client_streaming !== null) ? $message->client_streaming : $this->client_streaming;
        $this->server_streaming = ($message->server_streaming !== null) ? $message->server_streaming : $this->server_streaming;
    }


}

