this.BX=this.BX||{};(function(exports){"use strict";const REVISION=19;const ConnectionType={WebSocket:"webSocket",LongPolling:"longPolling"};const PullStatus={Online:"online",Offline:"offline",Connecting:"connect"};const CloseReasons={NORMAL_CLOSURE:1e3,SERVER_DIE:1001,CONFIG_REPLACED:3e3,CHANNEL_EXPIRED:3001,SERVER_RESTARTED:3002,CONFIG_EXPIRED:3003,MANUAL:3004,STUCK:3005,BACKEND_ERROR:3006,WRONG_CHANNEL_ID:4010};const SystemCommands={CHANNEL_EXPIRE:"CHANNEL_EXPIRE",CONFIG_EXPIRE:"CONFIG_EXPIRE",SERVER_RESTART:"SERVER_RESTART"};const ServerMode={Shared:"shared",Personal:"personal"};const RpcMethod={Publish:"publish",GetUsersLastSeen:"getUsersLastSeen",Ping:"ping",ListChannels:"listChannels",SubscribeStatusChange:"subscribeStatusChange",UnsubscribeStatusChange:"unsubscribeStatusChange"};const browser={IsChrome(){return navigator.userAgent.toLowerCase().includes("chrome")},IsFirefox(){return navigator.userAgent.toLowerCase().includes("firefox")},IsIe(){return navigator.userAgent.match(/(Trident\/|MSIE\/)/)!==null}};function getTimestamp(){return Date.now()}function isString(e){return e===""?true:e?typeof e==="string"||e instanceof String:false}function isArray(e){return e&&Object.prototype.toString.call(e)==="[object Array]"}function isFunction(e){return e===null?false:typeof e==="function"||e instanceof Function}function isPlainObject(e){return Boolean(e)&&typeof e==="object"&&e.constructor===Object}function isNotEmptyString(e){return isString(e)?e.length>0:false}function isJsonRpcRequest(e){return typeof e==="object"&&e&&"jsonrpc"in e&&isNotEmptyString(e.jsonrpc)&&"method"in e&&isNotEmptyString(e.method)}function isJsonRpcResponse(e){return typeof e==="object"&&e&&"jsonrpc"in e&&isNotEmptyString(e.jsonrpc)&&"id"in e&&("result"in e||"error"in e)}function buildQueryString(e){let t="";for(const n of Object.keys(e)){const r=e[n];if(isArray(r)){for(const[e,i]of r.entries()){const r=encodeURIComponent(`${n}[${e}]`);const s=`${encodeURIComponent(i)}&`;t+=`${r}=${s}`}}else{t+=`${encodeURIComponent(n)}=${encodeURIComponent(r)}&`}}if(t.length>0){t=t.slice(0,Math.max(0,t.length-1))}return t}function getDateForLog(){const e=new Date;return`${e.getFullYear()}-${lpad(e.getMonth(),2,"0")}-${lpad(e.getDate(),2,"0")} ${lpad(e.getHours(),2,"0")}:${lpad(e.getMinutes(),2,"0")}`}function lpad(e,t,n=" "){if(e.length>t){return e}let r="";for(let e=0;e<t-r.length;e++){r+=n}return r+e}class ErrorNotConnected extends Error{constructor(e){super(e);this.name="ErrorNotConnected"}}class ErrorTimeout extends Error{constructor(e){super(e);this.name="ErrorTimeout"}}const JSON_RPC_VERSION="2.0";const RpcError={Parse:{code:-32700,message:"Parse error"},InvalidRequest:{code:-32600,message:"Invalid Request"},MethodNotFound:{code:-32601,message:"Method not found"},InvalidParams:{code:-32602,message:"Invalid params"},Internal:{code:-32603,message:"Internal error"}};class JsonRpc extends EventTarget{constructor(e){super();this.idCounter=0;this.handlers={};this.rpcResponseAwaiters=new Map;this.sender=e.sender;for(const t of Object.keys(e.handlers||{})){this.handle(t,e.handlers[t])}for(const t of Object.keys(e.events||{})){this.addEventListener(t,e.events[t])}}handle(e,t){this.handlers[e]=t}executeOutgoingRpcCommand(e,t,n=5){return new Promise(((r,i)=>{const s=this.createRequest(e,t);if(this.sender.send(JSON.stringify(s))===false){i(new ErrorNotConnected("send failed"))}if(n>0){const e=setTimeout((()=>{this.rpcResponseAwaiters.delete(s.id);i(new ErrorTimeout("no response"))}),n*1e3);this.rpcResponseAwaiters.set(s.id,{resolve:r,reject:i,timeout:e})}else{r()}}))}executeOutgoingRpcBatch(e){const t=[];const n=[];e.forEach((({method:e,params:r,id:i})=>{const s=this.createRequest(e,r,i);t.push(s);n.push(new Promise(((e,t)=>{this.rpcResponseAwaiters.set(s.id,{resolve:e,reject:t})})))}));this.sender.send(JSON.stringify(t));return n}processRpcResponse(e){if("id"in e&&this.rpcResponseAwaiters.has(e.id)){const t=this.rpcResponseAwaiters.get(e.id);if("result"in e){t.resolve(e.result)}else if("error"in e){t.reject(e.error)}else{t.reject(new Error("wrong response structure"))}clearTimeout(t.timeout);this.rpcResponseAwaiters.delete(e.id)}else{this.dispatchEvent(new CustomEvent("error",{error:new Error(`received rpc response with unknown id ${e}`)}))}}async handleIncomingMessage(e){let t={};try{t=JSON.parse(e)}catch(e){throw new Error(`could not decode json rpc message: ${e}`)}if(isArray(t)){this.executeIncomingRpcBatch(t)}else if(isJsonRpcRequest(t)){const e=await this.executeIncomingRpcCommand(t);if(e!==null&&e!==undefined){const n=e.error?this.createErrorResponse(t.id,e.error):this.createResponse(t.id,e);this.sender.send(JSON.stringify(n))}else{this.sender.send(JSON.stringify(this.createResponse(t.id,null)))}}else if(isJsonRpcResponse(t)){this.processRpcResponse(t)}else{throw new Error(`unknown rpc packet: ${t}`)}}async executeIncomingRpcCommand({method:e,params:t}){if(e in this.handlers){try{return this.handlers[e].call(this,t)}catch(e){return{jsonrpc:"2.0",error:e.toString()}}}return{error:RpcError.MethodNotFound}}async executeIncomingRpcBatch(e){const t=[];for(const n of e){if("jsonrpc"in n){if("method"in n){const e=this.executeIncomingRpcCommand(n);if(e){e.jsonrpc=JSON_RPC_VERSION;e.id=n.id;t.push(e)}}else{this.processRpcResponse(n)}}else{this.dispatchEvent(new CustomEvent("error",{error:new Error(`unknown rpc command in batch: ${n}`)}));t.push({jsonrpc:"2.0",error:RpcError.InvalidRequest})}}return t}nextId(){this.idCounter++;return this.idCounter}createPublishRequest(e){const t=e.map((e=>this.createRequest("publish",e)));if(t.length===0){return t[0]}return t}createRequest(e,t,n){return{jsonrpc:JSON_RPC_VERSION,method:e,params:t,id:n!=null?n:this.nextId()}}createResponse(e,t){return{jsonrpc:JSON_RPC_VERSION,id:e,result:t}}createErrorResponse(e,t){return{jsonrpc:JSON_RPC_VERSION,id:e,error:t}}}class ChannelManager{constructor(e){var t;this.publicIds={};this.restClient=(t=e.restClient)!=null?t:BX.rest;this.getPublicListMethod=e.getPublicListMethod}getPublicIds(e){const t=new Date;const n={};const r=[];for(const i of e){if(this.publicIds[i]&&this.publicIds[i].end>t){n[i]=this.publicIds[i]}else{r.push(i)}}if(r.length===0){return Promise.resolve(n)}return new Promise(((e,t)=>{this.restClient.callMethod(this.getPublicListMethod,{users:r}).then((t=>{if(t.error()){e({})}else{const i=t.data();this.setPublicIds(Object.values(i));for(const e of r){n[e]=this.publicIds[e]}e(n)}})).catch((e=>t(e)))}))}setPublicIds(e){for(const t of e){const e=t.user_id;this.publicIds[e]={userId:e,publicId:t.public_id,signature:t.signature,start:new Date(t.start),end:new Date(t.end)}}}}class AbstractConnector{constructor(e){this._connected=false;this.connectionType="";this.disconnectCode="";this.disconnectReason="";this.pathGetter=e.pathGetter;this.callbacks={onOpen:isFunction(e.onOpen)?e.onOpen:function(){},onDisconnect:isFunction(e.onDisconnect)?e.onDisconnect:function(){},onError:isFunction(e.onError)?e.onError:function(){},onMessage:isFunction(e.onMessage)?e.onMessage:function(){}}}get connected(){return this._connected}set connected(e){if(e===this._connected){return}this._connected=e;if(this._connected){this.callbacks.onOpen()}else{this.callbacks.onDisconnect({code:this.disconnectCode,reason:this.disconnectReason})}}get path(){return this.pathGetter()}}class WebSocketConnector extends AbstractConnector{constructor(...e){super(...e);this.connectionType=ConnectionType.WebSocket;this.onSocketOpenHandler=this.onSocketOpen.bind(this);this.onSocketCloseHandler=this.onSocketClose.bind(this);this.onSocketErrorHandler=this.onSocketError.bind(this);this.onSocketMessageHandler=this.onSocketMessage.bind(this)}connect(){if(this.socket){if(this.socket.readyState===WebSocket.OPEN||this.socket.readyState===WebSocket.CONNECTING){return}this.socket.removeEventListener("open",this.onSocketOpenHandler);this.socket.removeEventListener("close",this.onSocketCloseHandler);this.socket.removeEventListener("error",this.onSocketErrorHandler);this.socket.removeEventListener("message",this.onSocketMessageHandler);this.socket.close();this.socket=null}this.createSocket()}disconnect(e,t){if(this.socket!==null){this.socket.removeEventListener("open",this.onSocketOpenHandler);this.socket.removeEventListener("close",this.onSocketCloseHandler);this.socket.removeEventListener("error",this.onSocketErrorHandler);this.socket.removeEventListener("message",this.onSocketMessageHandler);this.socket.close(e,t)}this.socket=null;this.disconnectCode=e;this.disconnectReason=t;this.connected=false}createSocket(){if(this.socket){throw new Error("Socket already exists")}if(!this.path){throw new Error("Websocket connection path is not defined")}this.socket=new WebSocket(this.path);this.socket.binaryType="arraybuffer";this.socket.addEventListener("open",this.onSocketOpenHandler);this.socket.addEventListener("close",this.onSocketCloseHandler);this.socket.addEventListener("error",this.onSocketErrorHandler);this.socket.addEventListener("message",this.onSocketMessageHandler)}send(e){if(!this.socket||this.socket.readyState!==1){console.error(`${getDateForLog()}: Pull: WebSocket is not connected`);return false}this.socket.send(e);return true}onSocketOpen(){this.connected=true}onSocketClose(e){this.socket=null;this.disconnectCode=e.code;this.disconnectReason=e.reason;this.connected=false}onSocketError(e){this.callbacks.onError(e)}onSocketMessage(e){this.callbacks.onMessage(e.data)}destroy(){if(this.socket){this.socket.close();this.socket=null}}}const LONG_POLLING_TIMEOUT=60;class LongPollingConnector extends AbstractConnector{constructor(e){super(e);this.connectionType=ConnectionType.LongPolling;this.active=false;this.requestTimeout=null;this.failureTimeout=null;this.requestAborted=false;this.xhr=this.createXhr();this.isBinary=e.isBinary}createXhr(){const e=new XMLHttpRequest;if(this.isBinary){e.responseType="arraybuffer"}e.addEventListener("readystatechange",this.onXhrReadyStateChange.bind(this));return e}connect(){this.active=true;this.performRequest()}disconnect(e,t){this.active=false;if(this.failureTimeout){clearTimeout(this.failureTimeout);this.failureTimeout=null}if(this.requestTimeout){clearTimeout(this.requestTimeout);this.requestTimeout=null}if(this.xhr){this.requestAborted=true;this.xhr.abort()}this.disconnectCode=e;this.disconnectReason=t;this.connected=false}performRequest(){if(!this.active){return}if(!this.path){throw new Error("Long polling connection path is not defined")}if(this.xhr.readyState!==0&&this.xhr.readyState!==4){return}clearTimeout(this.failureTimeout);clearTimeout(this.requestTimeout);this.failureTimeout=setTimeout((()=>{this.connected=true}),5e3);this.requestTimeout=setTimeout(this.onRequestTimeout.bind(this),LONG_POLLING_TIMEOUT*1e3);this.xhr.open("GET",this.path);this.xhr.send()}onRequestTimeout(){this.requestAborted=true;this.xhr.abort();this.performRequest()}onXhrReadyStateChange(){if(this.xhr.readyState===4){if(!this.requestAborted||this.xhr.status===200){this.onResponse(this.xhr.response)}this.requestAborted=false}}send(e){const t=this.parent.getPublicationPath();if(!t){console.error(`${getDateForLog()}: Pull: publication path is empty`);return}const n=new XMLHttpRequest;n.open("POST",t);n.send(e)}onResponse(e){if(this.failureTimeout){clearTimeout(this.failureTimeout);this.failureTimeout=0}if(this.requestTimeout){clearTimeout(this.requestTimeout);this.requestTimeout=0}if(this.xhr.status===200){this.connected=true;if(isNotEmptyString(e)||e instanceof ArrayBuffer){this.callbacks.onMessage(e)}else{this.parent.session.mid=null}this.performRequest()}else if(this.xhr.status===304){this.connected=true;if(this.xhr.getResponseHeader("Expires")==="Thu, 01 Jan 1973 11:11:01 GMT"){const e=this.xhr.getResponseHeader("Last-Message-Id");if(isNotEmptyString(e)){this.parent.setLastMessageId(e)}}this.performRequest()}else{this.callbacks.onError("Could not connect to the server");this.connected=false}}}
/*!
	 * protobuf.js v6.8.6 (c) 2016, daniel wirtz
	 * compiled mon, 26 feb 2018 11:35:34 utc
	 * licensed under the bsd-3-clause license
	 * see: https://github.com/dcodeio/protobuf.js for details
	 *
	 * Modify list for integration with Bitrix Framework:
	 * - removed integration with RequireJS and AMD package builders;
	 */(function(global,undefined){(function e(t,n,r){function i(e){var r=n[e];if(!r)t[e][0].call(r=n[e]={exports:{}},i,r,r.exports);return r.exports}var s=global.protobuf=i(r[0])})({1:[function(e,t,n){t.exports=r;function r(e,t){var n=new Array(arguments.length-1),r=0,i=2,s=true;while(i<arguments.length)n[r++]=arguments[i++];return new Promise((function i(o,a){n[r]=function e(t){if(s){s=false;if(t)a(t);else{var n=new Array(arguments.length-1),r=0;while(r<n.length)n[r++]=arguments[r];o.apply(null,n)}}};try{e.apply(t||null,n)}catch(e){if(s){s=false;a(e)}}}))}},{}],2:[function(e,t,n){var r=n;r.length=function e(t){var n=t.length;if(!n)return 0;var r=0;while(--n%4>1&&t.charAt(n)==="=")++r;return Math.ceil(t.length*3)/4-r};var i=new Array(64);var s=new Array(123);for(var o=0;o<64;)s[i[o]=o<26?o+65:o<52?o+71:o<62?o-4:o-59|43]=o++;r.encode=function e(t,n,r){var s=null,o=[];var a=0,c=0,u;while(n<r){var l=t[n++];switch(c){case 0:o[a++]=i[l>>2];u=(l&3)<<4;c=1;break;case 1:o[a++]=i[u|l>>4];u=(l&15)<<2;c=2;break;case 2:o[a++]=i[u|l>>6];o[a++]=i[l&63];c=0;break}if(a>8191){(s||(s=[])).push(String.fromCharCode.apply(String,o));a=0}}if(c){o[a++]=i[u];o[a++]=61;if(c===1)o[a++]=61}if(s){if(a)s.push(String.fromCharCode.apply(String,o.slice(0,a)));return s.join("")}return String.fromCharCode.apply(String,o.slice(0,a))};var a="invalid encoding";r.decode=function e(t,n,r){var i=r;var o=0,c;for(var u=0;u<t.length;){var l=t.charCodeAt(u++);if(l===61&&o>1)break;if((l=s[l])===undefined)throw Error(a);switch(o){case 0:c=l;o=1;break;case 1:n[r++]=c<<2|(l&48)>>4;c=l;o=2;break;case 2:n[r++]=(c&15)<<4|(l&60)>>2;c=l;o=3;break;case 3:n[r++]=(c&3)<<6|l;o=0;break}}if(o===1)throw Error(a);return r-i};r.test=function e(t){return/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(t)}},{}],3:[function(e,t,n){t.exports=r;function r(e,t){if(typeof e==="string"){t=e;e=undefined}var n=[];function i(e){if(typeof e!=="string"){var t=s();if(r.verbose)console.log("codegen: "+t);t="return "+t;if(e){var o=Object.keys(e),a=new Array(o.length+1),c=new Array(o.length),u=0;while(u<o.length){a[u]=o[u];c[u]=e[o[u++]]}a[u]=t;return Function.apply(null,a).apply(null,c)}return Function(t)()}var l=new Array(arguments.length-1),f=0;while(f<l.length)l[f]=arguments[++f];f=0;e=e.replace(/%([%dfijs])/g,(function e(t,n){var r=l[f++];switch(n){case"d":case"f":return String(Number(r));case"i":return String(Math.floor(r));case"j":return JSON.stringify(r);case"s":return String(r)}return"%"}));if(f!==l.length)throw Error("parameter count mismatch");n.push(e);return i}function s(r){return"function "+(r||t||"")+"("+(e&&e.join(",")||"")+"){\n  "+n.join("\n  ")+"\n}"}i.toString=s;return i}r.verbose=false},{}],4:[function(e,t,n){t.exports=r;function r(){this._listeners={}}r.prototype.on=function e(t,n,r){(this._listeners[t]||(this._listeners[t]=[])).push({fn:n,ctx:r||this});return this};r.prototype.off=function e(t,n){if(t===undefined)this._listeners={};else{if(n===undefined)this._listeners[t]=[];else{var r=this._listeners[t];for(var i=0;i<r.length;)if(r[i].fn===n)r.splice(i,1);else++i}}return this};r.prototype.emit=function e(t){var n=this._listeners[t];if(n){var r=[],i=1;for(;i<arguments.length;)r.push(arguments[i++]);for(i=0;i<n.length;)n[i].fn.apply(n[i++].ctx,r)}return this}},{}],5:[function(e,t,n){t.exports=o;var r=e(1),i=e(7);var s=i("fs");function o(e,t,n){if(typeof t==="function"){n=t;t={}}else if(!t)t={};if(!n)return r(o,this,e,t);if(!t.xhr&&s&&s.readFile)return s.readFile(e,(function r(i,s){return i&&typeof XMLHttpRequest!=="undefined"?o.xhr(e,t,n):i?n(i):n(null,t.binary?s:s.toString("utf8"))}));return o.xhr(e,t,n)}o.xhr=function e(t,n,r){var i=new XMLHttpRequest;i.onreadystatechange=function e(){if(i.readyState!==4)return undefined;if(i.status!==0&&i.status!==200)return r(Error("status "+i.status));if(n.binary){var t=i.response;if(!t){t=[];for(var s=0;s<i.responseText.length;++s)t.push(i.responseText.charCodeAt(s)&255)}return r(null,typeof Uint8Array!=="undefined"?new Uint8Array(t):t)}return r(null,i.responseText)};if(n.binary){if("overrideMimeType"in i)i.overrideMimeType("text/plain; charset=x-user-defined");i.responseType="arraybuffer"}i.open("GET",t);i.send()}},{1:1,7:7}],6:[function(e,t,n){t.exports=r(r);function r(e){if(typeof Float32Array!=="undefined")(function(){var t=new Float32Array([-0]),n=new Uint8Array(t.buffer),r=n[3]===128;function i(e,r,i){t[0]=e;r[i]=n[0];r[i+1]=n[1];r[i+2]=n[2];r[i+3]=n[3]}function s(e,r,i){t[0]=e;r[i]=n[3];r[i+1]=n[2];r[i+2]=n[1];r[i+3]=n[0]}e.writeFloatLE=r?i:s;e.writeFloatBE=r?s:i;function o(e,r){n[0]=e[r];n[1]=e[r+1];n[2]=e[r+2];n[3]=e[r+3];return t[0]}function a(e,r){n[3]=e[r];n[2]=e[r+1];n[1]=e[r+2];n[0]=e[r+3];return t[0]}e.readFloatLE=r?o:a;e.readFloatBE=r?a:o})();else(function(){function t(e,t,n,r){var i=t<0?1:0;if(i)t=-t;if(t===0)e(1/t>0?0:2147483648,n,r);else if(isNaN(t))e(2143289344,n,r);else if(t>34028234663852886e22)e((i<<31|2139095040)>>>0,n,r);else if(t<11754943508222875e-54)e((i<<31|Math.round(t/1401298464324817e-60))>>>0,n,r);else{var s=Math.floor(Math.log(t)/Math.LN2),o=Math.round(t*Math.pow(2,-s)*8388608)&8388607;e((i<<31|s+127<<23|o)>>>0,n,r)}}e.writeFloatLE=t.bind(null,i);e.writeFloatBE=t.bind(null,s);function n(e,t,n){var r=e(t,n),i=(r>>31)*2+1,s=r>>>23&255,o=r&8388607;return s===255?o?NaN:i*Infinity:s===0?i*1401298464324817e-60*o:i*Math.pow(2,s-150)*(o+8388608)}e.readFloatLE=n.bind(null,o);e.readFloatBE=n.bind(null,a)})();if(typeof Float64Array!=="undefined")(function(){var t=new Float64Array([-0]),n=new Uint8Array(t.buffer),r=n[7]===128;function i(e,r,i){t[0]=e;r[i]=n[0];r[i+1]=n[1];r[i+2]=n[2];r[i+3]=n[3];r[i+4]=n[4];r[i+5]=n[5];r[i+6]=n[6];r[i+7]=n[7]}function s(e,r,i){t[0]=e;r[i]=n[7];r[i+1]=n[6];r[i+2]=n[5];r[i+3]=n[4];r[i+4]=n[3];r[i+5]=n[2];r[i+6]=n[1];r[i+7]=n[0]}e.writeDoubleLE=r?i:s;e.writeDoubleBE=r?s:i;function o(e,r){n[0]=e[r];n[1]=e[r+1];n[2]=e[r+2];n[3]=e[r+3];n[4]=e[r+4];n[5]=e[r+5];n[6]=e[r+6];n[7]=e[r+7];return t[0]}function a(e,r){n[7]=e[r];n[6]=e[r+1];n[5]=e[r+2];n[4]=e[r+3];n[3]=e[r+4];n[2]=e[r+5];n[1]=e[r+6];n[0]=e[r+7];return t[0]}e.readDoubleLE=r?o:a;e.readDoubleBE=r?a:o})();else(function(){function t(e,t,n,r,i,s){var o=r<0?1:0;if(o)r=-r;if(r===0){e(0,i,s+t);e(1/r>0?0:2147483648,i,s+n)}else if(isNaN(r)){e(0,i,s+t);e(2146959360,i,s+n)}else if(r>17976931348623157e292){e(0,i,s+t);e((o<<31|2146435072)>>>0,i,s+n)}else{var a;if(r<22250738585072014e-324){a=r/5e-324;e(a>>>0,i,s+t);e((o<<31|a/4294967296)>>>0,i,s+n)}else{var c=Math.floor(Math.log(r)/Math.LN2);if(c===1024)c=1023;a=r*Math.pow(2,-c);e(a*4503599627370496>>>0,i,s+t);e((o<<31|c+1023<<20|a*1048576&1048575)>>>0,i,s+n)}}}e.writeDoubleLE=t.bind(null,i,0,4);e.writeDoubleBE=t.bind(null,s,4,0);function n(e,t,n,r,i){var s=e(r,i+t),o=e(r,i+n);var a=(o>>31)*2+1,c=o>>>20&2047,u=4294967296*(o&1048575)+s;return c===2047?u?NaN:a*Infinity:c===0?a*5e-324*u:a*Math.pow(2,c-1075)*(u+4503599627370496)}e.readDoubleLE=n.bind(null,o,0,4);e.readDoubleBE=n.bind(null,a,4,0)})();return e}function i(e,t,n){t[n]=e&255;t[n+1]=e>>>8&255;t[n+2]=e>>>16&255;t[n+3]=e>>>24}function s(e,t,n){t[n]=e>>>24;t[n+1]=e>>>16&255;t[n+2]=e>>>8&255;t[n+3]=e&255}function o(e,t){return(e[t]|e[t+1]<<8|e[t+2]<<16|e[t+3]<<24)>>>0}function a(e,t){return(e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3])>>>0}},{}],7:[function(require,module,exports){module.exports=inquire;function inquire(moduleName){try{var mod=eval("quire".replace(/^/,"re"))(moduleName);if(mod&&(mod.length||Object.keys(mod).length))return mod}catch(e){}return null}},{}],8:[function(e,t,n){var r=n;var i=r.isAbsolute=function e(t){return/^(?:\/|\w+:)/.test(t)};var s=r.normalize=function e(t){t=t.replace(/\\/g,"/").replace(/\/{2,}/g,"/");var n=t.split("/"),r=i(t),s="";if(r)s=n.shift()+"/";for(var o=0;o<n.length;){if(n[o]===".."){if(o>0&&n[o-1]!=="..")n.splice(--o,2);else if(r)n.splice(o,1);else++o}else if(n[o]===".")n.splice(o,1);else++o}return s+n.join("/")};r.resolve=function e(t,n,r){if(!r)n=s(n);if(i(n))return n;if(!r)t=s(t);return(t=t.replace(/(?:\/|^)[^/]+$/,"")).length?s(t+"/"+n):n}},{}],9:[function(e,t,n){t.exports=r;function r(e,t,n){var r=n||8192;var i=r>>>1;var s=null;var o=r;return function n(a){if(a<1||a>i)return e(a);if(o+a>r){s=e(r);o=0}var c=t.call(s,o,o+=a);if(o&7)o=(o|7)+1;return c}}},{}],10:[function(e,t,n){var r=n;r.length=function e(t){var n=0,r=0;for(var i=0;i<t.length;++i){r=t.charCodeAt(i);if(r<128)n+=1;else if(r<2048)n+=2;else if((r&64512)===55296&&(t.charCodeAt(i+1)&64512)===56320){++i;n+=4}else n+=3}return n};r.read=function e(t,n,r){var i=r-n;if(i<1)return"";var s=null,o=[],a=0,c;while(n<r){c=t[n++];if(c<128)o[a++]=c;else if(c>191&&c<224)o[a++]=(c&31)<<6|t[n++]&63;else if(c>239&&c<365){c=((c&7)<<18|(t[n++]&63)<<12|(t[n++]&63)<<6|t[n++]&63)-65536;o[a++]=55296+(c>>10);o[a++]=56320+(c&1023)}else o[a++]=(c&15)<<12|(t[n++]&63)<<6|t[n++]&63;if(a>8191){(s||(s=[])).push(String.fromCharCode.apply(String,o));a=0}}if(s){if(a)s.push(String.fromCharCode.apply(String,o.slice(0,a)));return s.join("")}return String.fromCharCode.apply(String,o.slice(0,a))};r.write=function e(t,n,r){var i=r,s,o;for(var a=0;a<t.length;++a){s=t.charCodeAt(a);if(s<128){n[r++]=s}else if(s<2048){n[r++]=s>>6|192;n[r++]=s&63|128}else if((s&64512)===55296&&((o=t.charCodeAt(a+1))&64512)===56320){s=65536+((s&1023)<<10)+(o&1023);++a;n[r++]=s>>18|240;n[r++]=s>>12&63|128;n[r++]=s>>6&63|128;n[r++]=s&63|128}else{n[r++]=s>>12|224;n[r++]=s>>6&63|128;n[r++]=s&63|128}}return r-i}},{}],11:[function(e,t,n){t.exports=i;var r=/\/|\./;function i(e,t){if(!r.test(e)){e="google/protobuf/"+e+".proto";t={nested:{google:{nested:{protobuf:{nested:t}}}}}}i[e]=t}i("any",{Any:{fields:{type_url:{type:"string",id:1},value:{type:"bytes",id:2}}}});var s;i("duration",{Duration:s={fields:{seconds:{type:"int64",id:1},nanos:{type:"int32",id:2}}}});i("timestamp",{Timestamp:s});i("empty",{Empty:{fields:{}}});i("struct",{Struct:{fields:{fields:{keyType:"string",type:"Value",id:1}}},Value:{oneofs:{kind:{oneof:["nullValue","numberValue","stringValue","boolValue","structValue","listValue"]}},fields:{nullValue:{type:"NullValue",id:1},numberValue:{type:"double",id:2},stringValue:{type:"string",id:3},boolValue:{type:"bool",id:4},structValue:{type:"Struct",id:5},listValue:{type:"ListValue",id:6}}},NullValue:{values:{NULL_VALUE:0}},ListValue:{fields:{values:{rule:"repeated",type:"Value",id:1}}}});i("wrappers",{DoubleValue:{fields:{value:{type:"double",id:1}}},FloatValue:{fields:{value:{type:"float",id:1}}},Int64Value:{fields:{value:{type:"int64",id:1}}},UInt64Value:{fields:{value:{type:"uint64",id:1}}},Int32Value:{fields:{value:{type:"int32",id:1}}},UInt32Value:{fields:{value:{type:"uint32",id:1}}},BoolValue:{fields:{value:{type:"bool",id:1}}},StringValue:{fields:{value:{type:"string",id:1}}},BytesValue:{fields:{value:{type:"bytes",id:1}}}});i("field_mask",{FieldMask:{fields:{paths:{rule:"repeated",type:"string",id:1}}}});i.get=function e(t){return i[t]||null}},{}],12:[function(e,t,n){var r=n;var i=e(15),s=e(37);function o(e,t,n,r){if(t.resolvedType){if(t.resolvedType instanceof i){e("switch(d%s){",r);for(var s=t.resolvedType.values,o=Object.keys(s),a=0;a<o.length;++a){if(t.repeated&&s[o[a]]===t.typeDefault)e("default:");e("case%j:",o[a])("case %i:",s[o[a]])("m%s=%j",r,s[o[a]])("break")}e("}")}else e('if(typeof d%s!=="object")',r)("throw TypeError(%j)",t.fullName+": object expected")("m%s=types[%i].fromObject(d%s)",r,n,r)}else{var c=false;switch(t.type){case"double":case"float":e("m%s=Number(d%s)",r,r);break;case"uint32":case"fixed32":e("m%s=d%s>>>0",r,r);break;case"int32":case"sint32":case"sfixed32":e("m%s=d%s|0",r,r);break;case"uint64":c=true;case"int64":case"sint64":case"fixed64":case"sfixed64":e("if(util.Long)")("(m%s=util.Long.fromValue(d%s)).unsigned=%j",r,r,c)('else if(typeof d%s==="string")',r)("m%s=parseInt(d%s,10)",r,r)('else if(typeof d%s==="number")',r)("m%s=d%s",r,r)('else if(typeof d%s==="object")',r)("m%s=new util.LongBits(d%s.low>>>0,d%s.high>>>0).toNumber(%s)",r,r,r,c?"true":"");break;case"bytes":e('if(typeof d%s==="string")',r)("util.base64.decode(d%s,m%s=util.newBuffer(util.base64.length(d%s)),0)",r,r,r)("else if(d%s.length)",r)("m%s=d%s",r,r);break;case"string":e("m%s=String(d%s)",r,r);break;case"bool":e("m%s=Boolean(d%s)",r,r);break}}return e}r.fromObject=function e(t){var n=t.fieldsArray;var r=s.codegen(["d"],t.name+"$fromObject")("if(d instanceof this.ctor)")("return d");if(!n.length)return r("return new this.ctor");r("var m=new this.ctor");for(var a=0;a<n.length;++a){var c=n[a].resolve(),u=s.safeProp(c.name);if(c.map){r("if(d%s){",u)('if(typeof d%s!=="object")',u)("throw TypeError(%j)",c.fullName+": object expected")("m%s={}",u)("for(var ks=Object.keys(d%s),i=0;i<ks.length;++i){",u);o(r,c,a,u+"[ks[i]]")("}")("}")}else if(c.repeated){r("if(d%s){",u)("if(!Array.isArray(d%s))",u)("throw TypeError(%j)",c.fullName+": array expected")("m%s=[]",u)("for(var i=0;i<d%s.length;++i){",u);o(r,c,a,u+"[i]")("}")("}")}else{if(!(c.resolvedType instanceof i))r("if(d%s!=null){",u);o(r,c,a,u);if(!(c.resolvedType instanceof i))r("}")}}return r("return m")};function a(e,t,n,r){if(t.resolvedType){if(t.resolvedType instanceof i)e("d%s=o.enums===String?types[%i].values[m%s]:m%s",r,n,r,r);else e("d%s=types[%i].toObject(m%s,o)",r,n,r)}else{var s=false;switch(t.type){case"double":case"float":e("d%s=o.json&&!isFinite(m%s)?String(m%s):m%s",r,r,r,r);break;case"uint64":s=true;case"int64":case"sint64":case"fixed64":case"sfixed64":e('if(typeof m%s==="number")',r)("d%s=o.longs===String?String(m%s):m%s",r,r,r)("else")("d%s=o.longs===String?util.Long.prototype.toString.call(m%s):o.longs===Number?new util.LongBits(m%s.low>>>0,m%s.high>>>0).toNumber(%s):m%s",r,r,r,r,s?"true":"",r);break;case"bytes":e("d%s=o.bytes===String?util.base64.encode(m%s,0,m%s.length):o.bytes===Array?Array.prototype.slice.call(m%s):m%s",r,r,r,r,r);break;default:e("d%s=m%s",r,r);break}}return e}r.toObject=function e(t){var n=t.fieldsArray.slice().sort(s.compareFieldsById);if(!n.length)return s.codegen()("return {}");var r=s.codegen(["m","o"],t.name+"$toObject")("if(!o)")("o={}")("var d={}");var o=[],c=[],u=[],l=0;for(;l<n.length;++l)if(!n[l].partOf)(n[l].resolve().repeated?o:n[l].map?c:u).push(n[l]);if(o.length){r("if(o.arrays||o.defaults){");for(l=0;l<o.length;++l)r("d%s=[]",s.safeProp(o[l].name));r("}")}if(c.length){r("if(o.objects||o.defaults){");for(l=0;l<c.length;++l)r("d%s={}",s.safeProp(c[l].name));r("}")}if(u.length){r("if(o.defaults){");for(l=0;l<u.length;++l){var f=u[l],h=s.safeProp(f.name);if(f.resolvedType instanceof i)r("d%s=o.enums===String?%j:%j",h,f.resolvedType.valuesById[f.typeDefault],f.typeDefault);else if(f.long)r("if(util.Long){")("var n=new util.Long(%i,%i,%j)",f.typeDefault.low,f.typeDefault.high,f.typeDefault.unsigned)("d%s=o.longs===String?n.toString():o.longs===Number?n.toNumber():n",h)("}else")("d%s=o.longs===String?%j:%i",h,f.typeDefault.toString(),f.typeDefault.toNumber());else if(f.bytes)r("d%s=o.bytes===String?%j:%s",h,String.fromCharCode.apply(String,f.typeDefault),"["+Array.prototype.slice.call(f.typeDefault).join(",")+"]");else r("d%s=%j",h,f.typeDefault)}r("}")}var p=false;for(l=0;l<n.length;++l){var f=n[l],d=t._fieldsArray.indexOf(f),h=s.safeProp(f.name);if(f.map){if(!p){p=true;r("var ks2")}r("if(m%s&&(ks2=Object.keys(m%s)).length){",h,h)("d%s={}",h)("for(var j=0;j<ks2.length;++j){");a(r,f,d,h+"[ks2[j]]")("}")}else if(f.repeated){r("if(m%s&&m%s.length){",h,h)("d%s=[]",h)("for(var j=0;j<m%s.length;++j){",h);a(r,f,d,h+"[j]")("}")}else{r("if(m%s!=null&&m.hasOwnProperty(%j)){",h,f.name);a(r,f,d,h);if(f.partOf)r("if(o.oneofs)")("d%s=%j",s.safeProp(f.partOf.name),f.name)}r("}")}return r("return d")}},{15:15,37:37}],13:[function(e,t,n){t.exports=a;var r=e(15),i=e(36),s=e(37);function o(e){return"missing required '"+e.name+"'"}function a(e){var t=s.codegen(["r","l"],e.name+"$decode")("if(!(r instanceof Reader))")("r=Reader.create(r)")("var c=l===undefined?r.len:r.pos+l,m=new this.ctor"+(e.fieldsArray.filter((function(e){return e.map})).length?",k":""))("while(r.pos<c){")("var t=r.uint32()");if(e.group)t("if((t&7)===4)")("break");t("switch(t>>>3){");var n=0;for(;n<e.fieldsArray.length;++n){var a=e._fieldsArray[n].resolve(),c=a.resolvedType instanceof r?"int32":a.type,u="m"+s.safeProp(a.name);t("case %i:",a.id);if(a.map){t("r.skip().pos++")("if(%s===util.emptyObject)",u)("%s={}",u)("k=r.%s()",a.keyType)("r.pos++");if(i.long[a.keyType]!==undefined){if(i.basic[c]===undefined)t('%s[typeof k==="object"?util.longToHash(k):k]=types[%i].decode(r,r.uint32())',u,n);else t('%s[typeof k==="object"?util.longToHash(k):k]=r.%s()',u,c)}else{if(i.basic[c]===undefined)t("%s[k]=types[%i].decode(r,r.uint32())",u,n);else t("%s[k]=r.%s()",u,c)}}else if(a.repeated){t("if(!(%s&&%s.length))",u,u)("%s=[]",u);if(i.packed[c]!==undefined)t("if((t&7)===2){")("var c2=r.uint32()+r.pos")("while(r.pos<c2)")("%s.push(r.%s())",u,c)("}else");if(i.basic[c]===undefined)t(a.resolvedType.group?"%s.push(types[%i].decode(r))":"%s.push(types[%i].decode(r,r.uint32()))",u,n);else t("%s.push(r.%s())",u,c)}else if(i.basic[c]===undefined)t(a.resolvedType.group?"%s=types[%i].decode(r)":"%s=types[%i].decode(r,r.uint32())",u,n);else t("%s=r.%s()",u,c);t("break")}t("default:")("r.skipType(t&7)")("break")("}")("}");for(n=0;n<e._fieldsArray.length;++n){var l=e._fieldsArray[n];if(l.required)t("if(!m.hasOwnProperty(%j))",l.name)("throw util.ProtocolError(%j,{instance:m})",o(l))}return t("return m")}},{15:15,36:36,37:37}],14:[function(e,t,n){t.exports=a;var r=e(15),i=e(36),s=e(37);function o(e,t,n,r){return t.resolvedType.group?e("types[%i].encode(%s,w.uint32(%i)).uint32(%i)",n,r,(t.id<<3|3)>>>0,(t.id<<3|4)>>>0):e("types[%i].encode(%s,w.uint32(%i).fork()).ldelim()",n,r,(t.id<<3|2)>>>0)}function a(e){var t=s.codegen(["m","w"],e.name+"$encode")("if(!w)")("w=Writer.create()");var n,a;var c=e.fieldsArray.slice().sort(s.compareFieldsById);for(var n=0;n<c.length;++n){var u=c[n].resolve(),l=e._fieldsArray.indexOf(u),f=u.resolvedType instanceof r?"int32":u.type,h=i.basic[f];a="m"+s.safeProp(u.name);if(u.map){t("if(%s!=null&&m.hasOwnProperty(%j)){",a,u.name)("for(var ks=Object.keys(%s),i=0;i<ks.length;++i){",a)("w.uint32(%i).fork().uint32(%i).%s(ks[i])",(u.id<<3|2)>>>0,8|i.mapKey[u.keyType],u.keyType);if(h===undefined)t("types[%i].encode(%s[ks[i]],w.uint32(18).fork()).ldelim().ldelim()",l,a);else t(".uint32(%i).%s(%s[ks[i]]).ldelim()",16|h,f,a);t("}")("}")}else if(u.repeated){t("if(%s!=null&&%s.length){",a,a);if(u.packed&&i.packed[f]!==undefined){t("w.uint32(%i).fork()",(u.id<<3|2)>>>0)("for(var i=0;i<%s.length;++i)",a)("w.%s(%s[i])",f,a)("w.ldelim()")}else{t("for(var i=0;i<%s.length;++i)",a);if(h===undefined)o(t,u,l,a+"[i]");else t("w.uint32(%i).%s(%s[i])",(u.id<<3|h)>>>0,f,a)}t("}")}else{if(u.optional)t("if(%s!=null&&m.hasOwnProperty(%j))",a,u.name);if(h===undefined)o(t,u,l,a);else t("w.uint32(%i).%s(%s)",(u.id<<3|h)>>>0,f,a)}}return t("return w")}},{15:15,36:36,37:37}],15:[function(e,t,n){t.exports=o;var r=e(24);((o.prototype=Object.create(r.prototype)).constructor=o).className="Enum";var i=e(23),s=e(37);function o(e,t,n,i,s){r.call(this,e,n);if(t&&typeof t!=="object")throw TypeError("values must be an object");this.valuesById={};this.values=Object.create(this.valuesById);this.comment=i;this.comments=s||{};this.reserved=undefined;if(t)for(var o=Object.keys(t),a=0;a<o.length;++a)if(typeof t[o[a]]==="number")this.valuesById[this.values[o[a]]=t[o[a]]]=o[a]}o.fromJSON=function e(t,n){var r=new o(t,n.values,n.options,n.comment,n.comments);r.reserved=n.reserved;return r};o.prototype.toJSON=function e(t){var n=t?Boolean(t.keepComments):false;return s.toObject(["options",this.options,"values",this.values,"reserved",this.reserved&&this.reserved.length?this.reserved:undefined,"comment",n?this.comment:undefined,"comments",n?this.comments:undefined])};o.prototype.add=function e(t,n,r){if(!s.isString(t))throw TypeError("name must be a string");if(!s.isInteger(n))throw TypeError("id must be an integer");if(this.values[t]!==undefined)throw Error("duplicate name '"+t+"' in "+this);if(this.isReservedId(n))throw Error("id "+n+" is reserved in "+this);if(this.isReservedName(t))throw Error("name '"+t+"' is reserved in "+this);if(this.valuesById[n]!==undefined){if(!(this.options&&this.options.allow_alias))throw Error("duplicate id "+n+" in "+this);this.values[t]=n}else this.valuesById[this.values[t]=n]=t;this.comments[t]=r||null;return this};o.prototype.remove=function e(t){if(!s.isString(t))throw TypeError("name must be a string");var n=this.values[t];if(n==null)throw Error("name '"+t+"' does not exist in "+this);delete this.valuesById[n];delete this.values[t];delete this.comments[t];return this};o.prototype.isReservedId=function e(t){return i.isReservedId(this.reserved,t)};o.prototype.isReservedName=function e(t){return i.isReservedName(this.reserved,t)}},{23:23,24:24,37:37}],16:[function(e,t,n){t.exports=u;var r=e(24);((u.prototype=Object.create(r.prototype)).constructor=u).className="Field";var i=e(15),s=e(36),o=e(37);var a;var c=/^required|optional|repeated$/;u.fromJSON=function e(t,n){return new u(t,n.id,n.type,n.rule,n.extend,n.options,n.comment)};function u(e,t,n,i,a,u,l){if(o.isObject(i)){l=a;u=i;i=a=undefined}else if(o.isObject(a)){l=u;u=a;a=undefined}r.call(this,e,u);if(!o.isInteger(t)||t<0)throw TypeError("id must be a non-negative integer");if(!o.isString(n))throw TypeError("type must be a string");if(i!==undefined&&!c.test(i=i.toString().toLowerCase()))throw TypeError("rule must be a string rule");if(a!==undefined&&!o.isString(a))throw TypeError("extend must be a string");this.rule=i&&i!=="optional"?i:undefined;this.type=n;this.id=t;this.extend=a||undefined;this.required=i==="required";this.optional=!this.required;this.repeated=i==="repeated";this.map=false;this.message=null;this.partOf=null;this.typeDefault=null;this.defaultValue=null;this.long=o.Long?s.long[n]!==undefined:false;this.bytes=n==="bytes";this.resolvedType=null;this.extensionField=null;this.declaringField=null;this._packed=null;this.comment=l}Object.defineProperty(u.prototype,"packed",{get:function(){if(this._packed===null)this._packed=this.getOption("packed")!==false;return this._packed}});u.prototype.setOption=function e(t,n,i){if(t==="packed")this._packed=null;return r.prototype.setOption.call(this,t,n,i)};u.prototype.toJSON=function e(t){var n=t?Boolean(t.keepComments):false;return o.toObject(["rule",this.rule!=="optional"&&this.rule||undefined,"type",this.type,"id",this.id,"extend",this.extend,"options",this.options,"comment",n?this.comment:undefined])};u.prototype.resolve=function e(){if(this.resolved)return this;if((this.typeDefault=s.defaults[this.type])===undefined){this.resolvedType=(this.declaringField?this.declaringField.parent:this.parent).lookupTypeOrEnum(this.type);if(this.resolvedType instanceof a)this.typeDefault=null;else this.typeDefault=this.resolvedType.values[Object.keys(this.resolvedType.values)[0]]}if(this.options&&this.options["default"]!=null){this.typeDefault=this.options["default"];if(this.resolvedType instanceof i&&typeof this.typeDefault==="string")this.typeDefault=this.resolvedType.values[this.typeDefault]}if(this.options){if(this.options.packed===true||this.options.packed!==undefined&&this.resolvedType&&!(this.resolvedType instanceof i))delete this.options.packed;if(!Object.keys(this.options).length)this.options=undefined}if(this.long){this.typeDefault=o.Long.fromNumber(this.typeDefault,this.type.charAt(0)==="u");if(Object.freeze)Object.freeze(this.typeDefault)}else if(this.bytes&&typeof this.typeDefault==="string"){var t;if(o.base64.test(this.typeDefault))o.base64.decode(this.typeDefault,t=o.newBuffer(o.base64.length(this.typeDefault)),0);else o.utf8.write(this.typeDefault,t=o.newBuffer(o.utf8.length(this.typeDefault)),0);this.typeDefault=t}if(this.map)this.defaultValue=o.emptyObject;else if(this.repeated)this.defaultValue=o.emptyArray;else this.defaultValue=this.typeDefault;if(this.parent instanceof a)this.parent.ctor.prototype[this.name]=this.defaultValue;return r.prototype.resolve.call(this)};u.d=function e(t,n,r,i){if(typeof n==="function")n=o.decorateType(n).name;else if(n&&typeof n==="object")n=o.decorateEnum(n).name;return function e(s,a){o.decorateType(s.constructor).add(new u(a,t,n,r,{default:i}))}};u._configure=function e(t){a=t}},{15:15,24:24,36:36,37:37}],17:[function(e,t,n){var r=t.exports=e(18);r.build="light";function i(e,t,n){if(typeof t==="function"){n=t;t=new r.Root}else if(!t)t=new r.Root;return t.load(e,n)}r.load=i;function s(e,t){if(!t)t=new r.Root;return t.loadSync(e)}r.loadSync=s;r.encoder=e(14);r.decoder=e(13);r.verifier=e(40);r.converter=e(12);r.ReflectionObject=e(24);r.Namespace=e(23);r.Root=e(29);r.Enum=e(15);r.Type=e(35);r.Field=e(16);r.OneOf=e(25);r.MapField=e(20);r.Service=e(33);r.Method=e(22);r.Message=e(21);r.wrappers=e(41);r.types=e(36);r.util=e(37);r.ReflectionObject._configure(r.Root);r.Namespace._configure(r.Type,r.Service);r.Root._configure(r.Type);r.Field._configure(r.Type)},{12:12,13:13,14:14,15:15,16:16,18:18,20:20,21:21,22:22,23:23,24:24,25:25,29:29,33:33,35:35,36:36,37:37,40:40,41:41}],18:[function(e,t,n){var r=n;r.build="minimal";r.Writer=e(42);r.BufferWriter=e(43);r.Reader=e(27);r.BufferReader=e(28);r.util=e(39);r.rpc=e(31);r.roots=e(30);r.configure=i;function i(){r.Reader._configure(r.BufferReader);r.util._configure()}r.Writer._configure(r.BufferWriter);i()},{27:27,28:28,30:30,31:31,39:39,42:42,43:43}],19:[function(e,t,n){var r=t.exports=e(17);r.build="full";r.tokenize=e(34);r.parse=e(26);r.common=e(11);r.Root._configure(r.Type,r.parse,r.common)},{11:11,17:17,26:26,34:34}],20:[function(e,t,n){t.exports=o;var r=e(16);((o.prototype=Object.create(r.prototype)).constructor=o).className="MapField";var i=e(36),s=e(37);function o(e,t,n,i,o,a){r.call(this,e,t,i,undefined,undefined,o,a);if(!s.isString(n))throw TypeError("keyType must be a string");this.keyType=n;this.resolvedKeyType=null;this.map=true}o.fromJSON=function e(t,n){return new o(t,n.id,n.keyType,n.type,n.options,n.comment)};o.prototype.toJSON=function e(t){var n=t?Boolean(t.keepComments):false;return s.toObject(["keyType",this.keyType,"type",this.type,"id",this.id,"extend",this.extend,"options",this.options,"comment",n?this.comment:undefined])};o.prototype.resolve=function e(){if(this.resolved)return this;if(i.mapKey[this.keyType]===undefined)throw Error("invalid key type: "+this.keyType);return r.prototype.resolve.call(this)};o.d=function e(t,n,r){if(typeof r==="function")r=s.decorateType(r).name;else if(r&&typeof r==="object")r=s.decorateEnum(r).name;return function e(i,a){s.decorateType(i.constructor).add(new o(a,t,n,r))}}},{16:16,36:36,37:37}],21:[function(e,t,n){t.exports=i;var r=e(39);function i(e){if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)this[t[n]]=e[t[n]]}i.create=function e(t){return this.$type.create(t)};i.encode=function e(t,n){return this.$type.encode(t,n)};i.encodeDelimited=function e(t,n){return this.$type.encodeDelimited(t,n)};i.decode=function e(t){return this.$type.decode(t)};i.decodeDelimited=function e(t){return this.$type.decodeDelimited(t)};i.verify=function e(t){return this.$type.verify(t)};i.fromObject=function e(t){return this.$type.fromObject(t)};i.toObject=function e(t,n){return this.$type.toObject(t,n)};i.prototype.toJSON=function e(){return this.$type.toObject(this,r.toJSONOptions)}},{39:39}],22:[function(e,t,n){t.exports=s;var r=e(24);((s.prototype=Object.create(r.prototype)).constructor=s).className="Method";var i=e(37);function s(e,t,n,s,o,a,c,u){if(i.isObject(o)){c=o;o=a=undefined}else if(i.isObject(a)){c=a;a=undefined}if(!(t===undefined||i.isString(t)))throw TypeError("type must be a string");if(!i.isString(n))throw TypeError("requestType must be a string");if(!i.isString(s))throw TypeError("responseType must be a string");r.call(this,e,c);this.type=t||"rpc";this.requestType=n;this.requestStream=o?true:undefined;this.responseType=s;this.responseStream=a?true:undefined;this.resolvedRequestType=null;this.resolvedResponseType=null;this.comment=u}s.fromJSON=function e(t,n){return new s(t,n.type,n.requestType,n.responseType,n.requestStream,n.responseStream,n.options,n.comment)};s.prototype.toJSON=function e(t){var n=t?Boolean(t.keepComments):false;return i.toObject(["type",this.type!=="rpc"&&this.type||undefined,"requestType",this.requestType,"requestStream",this.requestStream,"responseType",this.responseType,"responseStream",this.responseStream,"options",this.options,"comment",n?this.comment:undefined])};s.prototype.resolve=function e(){if(this.resolved)return this;this.resolvedRequestType=this.parent.lookupType(this.requestType);this.resolvedResponseType=this.parent.lookupType(this.responseType);return r.prototype.resolve.call(this)}},{24:24,37:37}],23:[function(e,t,n){t.exports=l;var r=e(24);((l.prototype=Object.create(r.prototype)).constructor=l).className="Namespace";var i=e(15),s=e(16),o=e(37);var a,c;l.fromJSON=function e(t,n){return new l(t,n.options).addJSON(n.nested)};function u(e,t){if(!(e&&e.length))return undefined;var n={};for(var r=0;r<e.length;++r)n[e[r].name]=e[r].toJSON(t);return n}l.arrayToJSON=u;l.isReservedId=function e(t,n){if(t)for(var r=0;r<t.length;++r)if(typeof t[r]!=="string"&&t[r][0]<=n&&t[r][1]>=n)return true;return false};l.isReservedName=function e(t,n){if(t)for(var r=0;r<t.length;++r)if(t[r]===n)return true;return false};function l(e,t){r.call(this,e,t);this.nested=undefined;this._nestedArray=null}function f(e){e._nestedArray=null;return e}Object.defineProperty(l.prototype,"nestedArray",{get:function(){return this._nestedArray||(this._nestedArray=o.toArray(this.nested))}});l.prototype.toJSON=function e(t){return o.toObject(["options",this.options,"nested",u(this.nestedArray,t)])};l.prototype.addJSON=function e(t){var n=this;if(t){for(var r=Object.keys(t),o=0,u;o<r.length;++o){u=t[r[o]];n.add((u.fields!==undefined?a.fromJSON:u.values!==undefined?i.fromJSON:u.methods!==undefined?c.fromJSON:u.id!==undefined?s.fromJSON:l.fromJSON)(r[o],u))}}return this};l.prototype.get=function e(t){return this.nested&&this.nested[t]||null};l.prototype.getEnum=function e(t){if(this.nested&&this.nested[t]instanceof i)return this.nested[t].values;throw Error("no such enum: "+t)};l.prototype.add=function e(t){if(!(t instanceof s&&t.extend!==undefined||t instanceof a||t instanceof i||t instanceof c||t instanceof l))throw TypeError("object must be a valid nested object");if(!this.nested)this.nested={};else{var n=this.get(t.name);if(n){if(n instanceof l&&t instanceof l&&!(n instanceof a||n instanceof c)){var r=n.nestedArray;for(var o=0;o<r.length;++o)t.add(r[o]);this.remove(n);if(!this.nested)this.nested={};t.setOptions(n.options,true)}else throw Error("duplicate name '"+t.name+"' in "+this)}}this.nested[t.name]=t;t.onAdd(this);return f(this)};l.prototype.remove=function e(t){if(!(t instanceof r))throw TypeError("object must be a ReflectionObject");if(t.parent!==this)throw Error(t+" is not a member of "+this);delete this.nested[t.name];if(!Object.keys(this.nested).length)this.nested=undefined;t.onRemove(this);return f(this)};l.prototype.define=function e(t,n){if(o.isString(t))t=t.split(".");else if(!Array.isArray(t))throw TypeError("illegal path");if(t&&t.length&&t[0]==="")throw Error("path must be relative");var r=this;while(t.length>0){var i=t.shift();if(r.nested&&r.nested[i]){r=r.nested[i];if(!(r instanceof l))throw Error("path conflicts with non-namespace objects")}else r.add(r=new l(i))}if(n)r.addJSON(n);return r};l.prototype.resolveAll=function e(){var t=this.nestedArray,n=0;while(n<t.length)if(t[n]instanceof l)t[n++].resolveAll();else t[n++].resolve();return this.resolve()};l.prototype.lookup=function e(t,n,r){if(typeof n==="boolean"){r=n;n=undefined}else if(n&&!Array.isArray(n))n=[n];if(o.isString(t)&&t.length){if(t===".")return this.root;t=t.split(".")}else if(!t.length)return this;if(t[0]==="")return this.root.lookup(t.slice(1),n);var i=this.get(t[0]);if(i){if(t.length===1){if(!n||n.indexOf(i.constructor)>-1)return i}else if(i instanceof l&&(i=i.lookup(t.slice(1),n,true)))return i}else for(var s=0;s<this.nestedArray.length;++s)if(this._nestedArray[s]instanceof l&&(i=this._nestedArray[s].lookup(t,n,true)))return i;if(this.parent===null||r)return null;return this.parent.lookup(t,n)};l.prototype.lookupType=function e(t){var n=this.lookup(t,[a]);if(!n)throw Error("no such type: "+t);return n};l.prototype.lookupEnum=function e(t){var n=this.lookup(t,[i]);if(!n)throw Error("no such Enum '"+t+"' in "+this);return n};l.prototype.lookupTypeOrEnum=function e(t){var n=this.lookup(t,[a,i]);if(!n)throw Error("no such Type or Enum '"+t+"' in "+this);return n};l.prototype.lookupService=function e(t){var n=this.lookup(t,[c]);if(!n)throw Error("no such Service '"+t+"' in "+this);return n};l._configure=function(e,t){a=e;c=t}},{15:15,16:16,24:24,37:37}],24:[function(e,t,n){t.exports=s;s.className="ReflectionObject";var r=e(37);var i;function s(e,t){if(!r.isString(e))throw TypeError("name must be a string");if(t&&!r.isObject(t))throw TypeError("options must be an object");this.options=t;this.name=e;this.parent=null;this.resolved=false;this.comment=null;this.filename=null}Object.defineProperties(s.prototype,{root:{get:function(){var e=this;while(e.parent!==null)e=e.parent;return e}},fullName:{get:function(){var e=[this.name],t=this.parent;while(t){e.unshift(t.name);t=t.parent}return e.join(".")}}});s.prototype.toJSON=function e(){throw Error()};s.prototype.onAdd=function e(t){if(this.parent&&this.parent!==t)this.parent.remove(this);this.parent=t;this.resolved=false;var n=t.root;if(n instanceof i)n._handleAdd(this)};s.prototype.onRemove=function e(t){var n=t.root;if(n instanceof i)n._handleRemove(this);this.parent=null;this.resolved=false};s.prototype.resolve=function e(){if(this.resolved)return this;if(this.root instanceof i)this.resolved=true;return this};s.prototype.getOption=function e(t){if(this.options)return this.options[t];return undefined};s.prototype.setOption=function e(t,n,r){if(!r||!this.options||this.options[t]===undefined)(this.options||(this.options={}))[t]=n;return this};s.prototype.setOptions=function e(t,n){if(t)for(var r=Object.keys(t),i=0;i<r.length;++i)this.setOption(r[i],t[r[i]],n);return this};s.prototype.toString=function e(){var t=this.constructor.className,n=this.fullName;if(n.length)return t+" "+n;return t};s._configure=function(e){i=e}},{37:37}],25:[function(e,t,n){t.exports=o;var r=e(24);((o.prototype=Object.create(r.prototype)).constructor=o).className="OneOf";var i=e(16),s=e(37);function o(e,t,n,i){if(!Array.isArray(t)){n=t;t=undefined}r.call(this,e,n);if(!(t===undefined||Array.isArray(t)))throw TypeError("fieldNames must be an Array");this.oneof=t||[];this.fieldsArray=[];this.comment=i}o.fromJSON=function e(t,n){return new o(t,n.oneof,n.options,n.comment)};o.prototype.toJSON=function e(t){var n=t?Boolean(t.keepComments):false;return s.toObject(["options",this.options,"oneof",this.oneof,"comment",n?this.comment:undefined])};function a(e){if(e.parent)for(var t=0;t<e.fieldsArray.length;++t)if(!e.fieldsArray[t].parent)e.parent.add(e.fieldsArray[t])}o.prototype.add=function e(t){if(!(t instanceof i))throw TypeError("field must be a Field");if(t.parent&&t.parent!==this.parent)t.parent.remove(t);this.oneof.push(t.name);this.fieldsArray.push(t);t.partOf=this;a(this);return this};o.prototype.remove=function e(t){if(!(t instanceof i))throw TypeError("field must be a Field");var n=this.fieldsArray.indexOf(t);if(n<0)throw Error(t+" is not a member of "+this);this.fieldsArray.splice(n,1);n=this.oneof.indexOf(t.name);if(n>-1)this.oneof.splice(n,1);t.partOf=null;return this};o.prototype.onAdd=function e(t){r.prototype.onAdd.call(this,t);var n=this;for(var i=0;i<this.oneof.length;++i){var s=t.get(this.oneof[i]);if(s&&!s.partOf){s.partOf=n;n.fieldsArray.push(s)}}a(this)};o.prototype.onRemove=function e(t){for(var n=0,i;n<this.fieldsArray.length;++n)if((i=this.fieldsArray[n]).parent)i.parent.remove(i);r.prototype.onRemove.call(this,t)};o.d=function e(){var t=new Array(arguments.length),n=0;while(n<arguments.length)t[n]=arguments[n++];return function e(n,r){s.decorateType(n.constructor).add(new o(r,t));Object.defineProperty(n,r,{get:s.oneOfGetter(t),set:s.oneOfSetter(t)})}}},{16:16,24:24,37:37}],26:[function(e,t,n){t.exports=E;E.filename=null;E.defaults={keepCase:false};var r=e(34),i=e(29),s=e(35),o=e(16),a=e(20),c=e(25),u=e(15),l=e(33),f=e(22),h=e(36),p=e(37);var d=/^[1-9][0-9]*$/,y=/^-?[1-9][0-9]*$/,g=/^0[x][0-9a-fA-F]+$/,m=/^-?0[x][0-9a-fA-F]+$/,v=/^0[0-7]+$/,b=/^-?0[0-7]+$/,w=/^(?![eE])[0-9]*(?:\.[0-9]*)?(?:[eE][+-]?[0-9]+)?$/,k=/^[a-zA-Z_][a-zA-Z_0-9]*$/,S=/^(?:\.?[a-zA-Z_][a-zA-Z_0-9]*)(?:\.[a-zA-Z_][a-zA-Z_0-9]*)*$/,O=/^(?:\.[a-zA-Z_][a-zA-Z_0-9]*)+$/;function E(e,t,n){if(!(t instanceof i)){n=t;t=new i}if(!n)n=E.defaults;var R=r(e,n.alternateCommentMode||false),T=R.next,j=R.push,A=R.peek,C=R.skip,x=R.cmnt;var P=true,_,I,N,M,L=false;var B=t;var D=n.keepCase?function(e){return e}:p.camelCase;function q(e,t,n){var r=E.filename;if(!n)E.filename=null;return Error("illegal "+(t||"token")+" '"+e+"' ("+(r?r+", ":"")+"line "+R.line+")")}function $(){var e=[],t;do{if((t=T())!=='"'&&t!=="'")throw q(t);e.push(T());C(t);t=A()}while(t==='"'||t==="'");return e.join("")}function J(e){var t=T();switch(t){case"'":case'"':j(t);return $();case"true":case"TRUE":return true;case"false":case"FALSE":return false}try{return W(t,true)}catch(n){if(e&&S.test(t))return t;throw q(t,"value")}}function F(e,t){var n,r;do{if(t&&((n=A())==='"'||n==="'"))e.push($());else e.push([r=U(T()),C("to",true)?U(T()):r])}while(C(",",true));C(";")}function W(e,t){var n=1;if(e.charAt(0)==="-"){n=-1;e=e.substring(1)}switch(e){case"inf":case"INF":case"Inf":return n*Infinity;case"nan":case"NAN":case"Nan":case"NaN":return NaN;case"0":return 0}if(d.test(e))return n*parseInt(e,10);if(g.test(e))return n*parseInt(e,16);if(v.test(e))return n*parseInt(e,8);if(w.test(e))return n*parseFloat(e);throw q(e,"number",t)}function U(e,t){switch(e){case"max":case"MAX":case"Max":return 536870911;case"0":return 0}if(!t&&e.charAt(0)==="-")throw q(e,"id");if(y.test(e))return parseInt(e,10);if(m.test(e))return parseInt(e,16);if(b.test(e))return parseInt(e,8);throw q(e,"id")}function V(){if(_!==undefined)throw q("package");_=T();if(!S.test(_))throw q(_,"name");B=B.define(_);C(";")}function H(){var e=A();var t;switch(e){case"weak":t=N||(N=[]);T();break;case"public":T();default:t=I||(I=[]);break}e=$();C(";");t.push(e)}function G(){C("=");M=$();L=M==="proto3";if(!L&&M!=="proto2")throw q(M,"syntax");C(";")}function z(e,t){switch(t){case"option":re(e,t);C(";");return true;case"message":K(e,t);return true;case"enum":te(e,t);return true;case"service":ae(e,t);return true;case"extend":ue(e,t);return true}return false}function X(e,t,n){var r=R.line;if(e){e.comment=x();e.filename=E.filename}if(C("{",true)){var i;while((i=T())!=="}")t(i);C(";",true)}else{if(n)n();C(";");if(e&&typeof e.comment!=="string")e.comment=x(r)}}function K(e,t){if(!k.test(t=T()))throw q(t,"type name");var n=new s(t);X(n,(function e(t){if(z(n,t))return;switch(t){case"map":Y(n,t);break;case"required":case"optional":case"repeated":Z(n,t);break;case"oneof":ee(n,t);break;case"extensions":F(n.extensions||(n.extensions=[]));break;case"reserved":F(n.reserved||(n.reserved=[]),true);break;default:if(!L||!S.test(t))throw q(t);j(t);Z(n,"optional");break}}));e.add(n)}function Z(e,t,n){var r=T();if(r==="group"){Q(e,t);return}if(!S.test(r))throw q(r,"type");var i=T();if(!k.test(i))throw q(i,"name");i=D(i);C("=");var s=new o(i,U(T()),r,t,n);X(s,(function e(t){if(t==="option"){re(s,t);C(";")}else throw q(t)}),(function e(){oe(s)}));e.add(s);if(!L&&s.repeated&&(h.packed[r]!==undefined||h.basic[r]===undefined))s.setOption("packed",false,true)}function Q(e,t){var n=T();if(!k.test(n))throw q(n,"name");var r=p.lcFirst(n);if(n===r)n=p.ucFirst(n);C("=");var i=U(T());var a=new s(n);a.group=true;var c=new o(r,i,n,t);c.filename=E.filename;X(a,(function e(t){switch(t){case"option":re(a,t);C(";");break;case"required":case"optional":case"repeated":Z(a,t);break;default:throw q(t)}}));e.add(a).add(c)}function Y(e){C("<");var t=T();if(h.mapKey[t]===undefined)throw q(t,"type");C(",");var n=T();if(!S.test(n))throw q(n,"type");C(">");var r=T();if(!k.test(r))throw q(r,"name");C("=");var i=new a(D(r),U(T()),t,n);X(i,(function e(t){if(t==="option"){re(i,t);C(";")}else throw q(t)}),(function e(){oe(i)}));e.add(i)}function ee(e,t){if(!k.test(t=T()))throw q(t,"name");var n=new c(D(t));X(n,(function e(t){if(t==="option"){re(n,t);C(";")}else{j(t);Z(n,"optional")}}));e.add(n)}function te(e,t){if(!k.test(t=T()))throw q(t,"name");var n=new u(t);X(n,(function e(t){switch(t){case"option":re(n,t);C(";");break;case"reserved":F(n.reserved||(n.reserved=[]),true);break;default:ne(n,t)}}));e.add(n)}function ne(e,t){if(!k.test(t))throw q(t,"name");C("=");var n=U(T(),true),r={};X(r,(function e(t){if(t==="option"){re(r,t);C(";")}else throw q(t)}),(function e(){oe(r)}));e.add(t,n,r.comment)}function re(e,t){var n=C("(",true);if(!S.test(t=T()))throw q(t,"name");var r=t;if(n){C(")");r="("+r+")";t=A();if(O.test(t)){r+=t;T()}}C("=");ie(e,r)}function ie(e,t){if(C("{",true)){do{if(!k.test(le=T()))throw q(le,"name");if(A()==="{")ie(e,t+"."+le);else{C(":");if(A()==="{")ie(e,t+"."+le);else se(e,t+"."+le,J(true))}}while(!C("}",true))}else se(e,t,J(true))}function se(e,t,n){if(e.setOption)e.setOption(t,n)}function oe(e){if(C("[",true)){do{re(e,"option")}while(C(",",true));C("]")}return e}function ae(e,t){if(!k.test(t=T()))throw q(t,"service name");var n=new l(t);X(n,(function e(t){if(z(n,t))return;if(t==="rpc")ce(n,t);else throw q(t)}));e.add(n)}function ce(e,t){var n=t;if(!k.test(t=T()))throw q(t,"name");var r=t,i,s,o,a;C("(");if(C("stream",true))s=true;if(!S.test(t=T()))throw q(t);i=t;C(")");C("returns");C("(");if(C("stream",true))a=true;if(!S.test(t=T()))throw q(t);o=t;C(")");var c=new f(r,n,i,o,s,a);X(c,(function e(t){if(t==="option"){re(c,t);C(";")}else throw q(t)}));e.add(c)}function ue(e,t){if(!S.test(t=T()))throw q(t,"reference");var n=t;X(null,(function t(r){switch(r){case"required":case"repeated":case"optional":Z(e,r,n);break;default:if(!L||!S.test(r))throw q(r);j(r);Z(e,"optional",n);break}}))}var le;while((le=T())!==null){switch(le){case"package":if(!P)throw q(le);V();break;case"import":if(!P)throw q(le);H();break;case"syntax":if(!P)throw q(le);G();break;case"option":if(!P)throw q(le);re(B,le);C(";");break;default:if(z(B,le)){P=false;continue}throw q(le)}}E.filename=null;return{package:_,imports:I,weakImports:N,syntax:M,root:t}}},{15:15,16:16,20:20,22:22,25:25,29:29,33:33,34:34,35:35,36:36,37:37}],27:[function(e,t,n){t.exports=c;var r=e(39);var i;var s=r.LongBits,o=r.utf8;function a(e,t){return RangeError("index out of range: "+e.pos+" + "+(t||1)+" > "+e.len)}function c(e){this.buf=e;this.pos=0;this.len=e.length}var u=typeof Uint8Array!=="undefined"?function e(t){if(t instanceof Uint8Array||Array.isArray(t))return new c(t);throw Error("illegal buffer")}:function e(t){if(Array.isArray(t))return new c(t);throw Error("illegal buffer")};c.create=r.Buffer?function e(t){return(c.create=function e(t){return r.Buffer.isBuffer(t)?new i(t):u(t)})(t)}:u;c.prototype._slice=r.Array.prototype.subarray||r.Array.prototype.slice;c.prototype.uint32=function e(){var t=4294967295;return function e(){t=(this.buf[this.pos]&127)>>>0;if(this.buf[this.pos++]<128)return t;t=(t|(this.buf[this.pos]&127)<<7)>>>0;if(this.buf[this.pos++]<128)return t;t=(t|(this.buf[this.pos]&127)<<14)>>>0;if(this.buf[this.pos++]<128)return t;t=(t|(this.buf[this.pos]&127)<<21)>>>0;if(this.buf[this.pos++]<128)return t;t=(t|(this.buf[this.pos]&15)<<28)>>>0;if(this.buf[this.pos++]<128)return t;if((this.pos+=5)>this.len){this.pos=this.len;throw a(this,10)}return t}}();c.prototype.int32=function e(){return this.uint32()|0};c.prototype.sint32=function e(){var t=this.uint32();return t>>>1^-(t&1)|0};function l(){var e=new s(0,0);var t=0;if(this.len-this.pos>4){for(;t<4;++t){e.lo=(e.lo|(this.buf[this.pos]&127)<<t*7)>>>0;if(this.buf[this.pos++]<128)return e}e.lo=(e.lo|(this.buf[this.pos]&127)<<28)>>>0;e.hi=(e.hi|(this.buf[this.pos]&127)>>4)>>>0;if(this.buf[this.pos++]<128)return e;t=0}else{for(;t<3;++t){if(this.pos>=this.len)throw a(this);e.lo=(e.lo|(this.buf[this.pos]&127)<<t*7)>>>0;if(this.buf[this.pos++]<128)return e}e.lo=(e.lo|(this.buf[this.pos++]&127)<<t*7)>>>0;return e}if(this.len-this.pos>4){for(;t<5;++t){e.hi=(e.hi|(this.buf[this.pos]&127)<<t*7+3)>>>0;if(this.buf[this.pos++]<128)return e}}else{for(;t<5;++t){if(this.pos>=this.len)throw a(this);e.hi=(e.hi|(this.buf[this.pos]&127)<<t*7+3)>>>0;if(this.buf[this.pos++]<128)return e}}throw Error("invalid varint encoding")}c.prototype.bool=function e(){return this.uint32()!==0};function f(e,t){return(e[t-4]|e[t-3]<<8|e[t-2]<<16|e[t-1]<<24)>>>0}c.prototype.fixed32=function e(){if(this.pos+4>this.len)throw a(this,4);return f(this.buf,this.pos+=4)};c.prototype.sfixed32=function e(){if(this.pos+4>this.len)throw a(this,4);return f(this.buf,this.pos+=4)|0};function h(){if(this.pos+8>this.len)throw a(this,8);return new s(f(this.buf,this.pos+=4),f(this.buf,this.pos+=4))}c.prototype.float=function e(){if(this.pos+4>this.len)throw a(this,4);var t=r.float.readFloatLE(this.buf,this.pos);this.pos+=4;return t};c.prototype.double=function e(){if(this.pos+8>this.len)throw a(this,4);var t=r.float.readDoubleLE(this.buf,this.pos);this.pos+=8;return t};c.prototype.bytes=function e(){var t=this.uint32(),n=this.pos,r=this.pos+t;if(r>this.len)throw a(this,t);this.pos+=t;if(Array.isArray(this.buf))return this.buf.slice(n,r);return n===r?new this.buf.constructor(0):this._slice.call(this.buf,n,r)};c.prototype.string=function e(){var t=this.bytes();return o.read(t,0,t.length)};c.prototype.skip=function e(t){if(typeof t==="number"){if(this.pos+t>this.len)throw a(this,t);this.pos+=t}else{do{if(this.pos>=this.len)throw a(this)}while(this.buf[this.pos++]&128)}return this};c.prototype.skipType=function(e){switch(e){case 0:this.skip();break;case 1:this.skip(8);break;case 2:this.skip(this.uint32());break;case 3:do{if((e=this.uint32()&7)===4)break;this.skipType(e)}while(true);break;case 5:this.skip(4);break;default:throw Error("invalid wire type "+e+" at offset "+this.pos)}return this};c._configure=function(e){i=e;var t=r.Long?"toLong":"toNumber";r.merge(c.prototype,{int64:function e(){return l.call(this)[t](false)},uint64:function e(){return l.call(this)[t](true)},sint64:function e(){return l.call(this).zzDecode()[t](false)},fixed64:function e(){return h.call(this)[t](true)},sfixed64:function e(){return h.call(this)[t](false)}})}},{39:39}],28:[function(e,t,n){t.exports=s;var r=e(27);(s.prototype=Object.create(r.prototype)).constructor=s;var i=e(39);function s(e){r.call(this,e)}if(i.Buffer)s.prototype._slice=i.Buffer.prototype.slice;s.prototype.string=function e(){var t=this.uint32();return this.buf.utf8Slice(this.pos,this.pos=Math.min(this.pos+t,this.len))}},{27:27,39:39}],29:[function(e,t,n){t.exports=f;var r=e(23);((f.prototype=Object.create(r.prototype)).constructor=f).className="Root";var i=e(16),s=e(15),o=e(25),a=e(37);var c,u,l;function f(e){r.call(this,"",e);this.deferred=[];this.files=[]}f.fromJSON=function e(t,n){if(!n)n=new f;if(t.options)n.setOptions(t.options);return n.addJSON(t.nested)};f.prototype.resolvePath=a.path.resolve;function h(){}f.prototype.load=function e(t,n,r){if(typeof n==="function"){r=n;n=undefined}var i=this;if(!r)return a.asPromise(e,i,t,n);var s=r===h;function o(e,t){if(!r)return;var n=r;r=null;if(s)throw e;n(e,t)}function c(e,t){try{if(a.isString(t)&&t.charAt(0)==="{")t=JSON.parse(t);if(!a.isString(t))i.setOptions(t.options).addJSON(t.nested);else{u.filename=e;var r=u(t,i,n),c,l=0;if(r.imports)for(;l<r.imports.length;++l)if(c=i.resolvePath(e,r.imports[l]))f(c);if(r.weakImports)for(l=0;l<r.weakImports.length;++l)if(c=i.resolvePath(e,r.weakImports[l]))f(c,true)}}catch(e){o(e)}if(!s&&!p)o(null,i)}function f(e,t){var n=e.lastIndexOf("google/protobuf/");if(n>-1){var u=e.substring(n);if(u in l)e=u}if(i.files.indexOf(e)>-1)return;i.files.push(e);if(e in l){if(s)c(e,l[e]);else{++p;setTimeout((function(){--p;c(e,l[e])}))}return}if(s){var f;try{f=a.fs.readFileSync(e).toString("utf8")}catch(e){if(!t)o(e);return}c(e,f)}else{++p;a.fetch(e,(function(n,s){--p;if(!r)return;if(n){if(!t)o(n);else if(!p)o(null,i);return}c(e,s)}))}}var p=0;if(a.isString(t))t=[t];for(var d=0,y;d<t.length;++d)if(y=i.resolvePath("",t[d]))f(y);if(s)return i;if(!p)o(null,i);return undefined};f.prototype.loadSync=function e(t,n){if(!a.isNode)throw Error("not supported");return this.load(t,n,h)};f.prototype.resolveAll=function e(){if(this.deferred.length)throw Error("unresolvable extensions: "+this.deferred.map((function(e){return"'extend "+e.extend+"' in "+e.parent.fullName})).join(", "));return r.prototype.resolveAll.call(this)};var p=/^[A-Z]/;function d(e,t){var n=t.parent.lookup(t.extend);if(n){var r=new i(t.fullName,t.id,t.type,t.rule,undefined,t.options);r.declaringField=t;t.extensionField=r;n.add(r);return true}return false}f.prototype._handleAdd=function e(t){if(t instanceof i){if(t.extend!==undefined&&!t.extensionField)if(!d(this,t))this.deferred.push(t)}else if(t instanceof s){if(p.test(t.name))t.parent[t.name]=t.values}else if(!(t instanceof o)){if(t instanceof c)for(var n=0;n<this.deferred.length;)if(d(this,this.deferred[n]))this.deferred.splice(n,1);else++n;for(var r=0;r<t.nestedArray.length;++r)this._handleAdd(t._nestedArray[r]);if(p.test(t.name))t.parent[t.name]=t}};f.prototype._handleRemove=function e(t){if(t instanceof i){if(t.extend!==undefined){if(t.extensionField){t.extensionField.parent.remove(t.extensionField);t.extensionField=null}else{var n=this.deferred.indexOf(t);if(n>-1)this.deferred.splice(n,1)}}}else if(t instanceof s){if(p.test(t.name))delete t.parent[t.name]}else if(t instanceof r){for(var o=0;o<t.nestedArray.length;++o)this._handleRemove(t._nestedArray[o]);if(p.test(t.name))delete t.parent[t.name]}};f._configure=function(e,t,n){c=e;u=t;l=n}},{15:15,16:16,23:23,25:25,37:37}],30:[function(e,t,n){t.exports={}},{}],31:[function(e,t,n){var r=n;r.Service=e(32)},{32:32}],32:[function(e,t,n){t.exports=i;var r=e(39);(i.prototype=Object.create(r.EventEmitter.prototype)).constructor=i;function i(e,t,n){if(typeof e!=="function")throw TypeError("rpcImpl must be a function");r.EventEmitter.call(this);this.rpcImpl=e;this.requestDelimited=Boolean(t);this.responseDelimited=Boolean(n)}i.prototype.rpcCall=function e(t,n,i,s,o){if(!s)throw TypeError("request must be specified");var a=this;if(!o)return r.asPromise(e,a,t,n,i,s);if(!a.rpcImpl){setTimeout((function(){o(Error("already ended"))}),0);return undefined}try{return a.rpcImpl(t,n[a.requestDelimited?"encodeDelimited":"encode"](s).finish(),(function e(n,r){if(n){a.emit("error",n,t);return o(n)}if(r===null){a.end(true);return undefined}if(!(r instanceof i)){try{r=i[a.responseDelimited?"decodeDelimited":"decode"](r)}catch(n){a.emit("error",n,t);return o(n)}}a.emit("data",r,t);return o(null,r)}))}catch(e){a.emit("error",e,t);setTimeout((function(){o(e)}),0);return undefined}};i.prototype.end=function e(t){if(this.rpcImpl){if(!t)this.rpcImpl(null,null,null);this.rpcImpl=null;this.emit("end").off()}return this}},{39:39}],33:[function(e,t,n){t.exports=a;var r=e(23);((a.prototype=Object.create(r.prototype)).constructor=a).className="Service";var i=e(22),s=e(37),o=e(31);function a(e,t){r.call(this,e,t);this.methods={};this._methodsArray=null}a.fromJSON=function e(t,n){var r=new a(t,n.options);if(n.methods)for(var s=Object.keys(n.methods),o=0;o<s.length;++o)r.add(i.fromJSON(s[o],n.methods[s[o]]));if(n.nested)r.addJSON(n.nested);r.comment=n.comment;return r};a.prototype.toJSON=function e(t){var n=r.prototype.toJSON.call(this,t);var i=t?Boolean(t.keepComments):false;return s.toObject(["options",n&&n.options||undefined,"methods",r.arrayToJSON(this.methodsArray,t)||{},"nested",n&&n.nested||undefined,"comment",i?this.comment:undefined])};Object.defineProperty(a.prototype,"methodsArray",{get:function(){return this._methodsArray||(this._methodsArray=s.toArray(this.methods))}});function c(e){e._methodsArray=null;return e}a.prototype.get=function e(t){return this.methods[t]||r.prototype.get.call(this,t)};a.prototype.resolveAll=function e(){var t=this.methodsArray;for(var n=0;n<t.length;++n)t[n].resolve();return r.prototype.resolve.call(this)};a.prototype.add=function e(t){if(this.get(t.name))throw Error("duplicate name '"+t.name+"' in "+this);if(t instanceof i){this.methods[t.name]=t;t.parent=this;return c(this)}return r.prototype.add.call(this,t)};a.prototype.remove=function e(t){if(t instanceof i){if(this.methods[t.name]!==t)throw Error(t+" is not a member of "+this);delete this.methods[t.name];t.parent=null;return c(this)}return r.prototype.remove.call(this,t)};a.prototype.create=function e(t,n,r){var i=new o.Service(t,n,r);for(var a=0,c;a<this.methodsArray.length;++a){var u=s.lcFirst((c=this._methodsArray[a]).resolve().name).replace(/[^$\w_]/g,"");i[u]=s.codegen(["r","c"],s.isReserved(u)?u+"_":u)("return this.rpcCall(m,q,s,r,c)")({m:c,q:c.resolvedRequestType.ctor,s:c.resolvedResponseType.ctor})}return i}},{22:22,23:23,31:31,37:37}],34:[function(e,t,n){t.exports=p;var r=/[\s{}=;:[\],'"()<>]/g,i=/(?:"([^"\\]*(?:\\.[^"\\]*)*)")/g,s=/(?:'([^'\\]*(?:\\.[^'\\]*)*)')/g;var o=/^ *[*/]+ */,a=/^\s*\*?\/*/,c=/\n/g,u=/\s/,l=/\\(.?)/g;var f={0:"\0",r:"\r",n:"\n",t:"\t"};function h(e){return e.replace(l,(function(e,t){switch(t){case"\\":case"":return t;default:return f[t]||""}}))}p.unescape=h;function p(e,t){e=e.toString();var n=0,l=e.length,f=1,p=null,d=null,y=0,g=false;var m=[];var v=null;function b(e){return Error("illegal "+e+" (line "+f+")")}function w(){var t=v==="'"?s:i;t.lastIndex=n-1;var r=t.exec(e);if(!r)throw b("string");n=t.lastIndex;T(v);v=null;return h(r[1])}function k(t){return e.charAt(t)}function S(n,r){p=e.charAt(n++);y=f;g=false;var i;if(t){i=2}else{i=3}var s=n-i,u;do{if(--s<0||(u=e.charAt(s))==="\n"){g=true;break}}while(u===" "||u==="\t");var l=e.substring(n,r).split(c);for(var h=0;h<l.length;++h)l[h]=l[h].replace(t?a:o,"").trim();d=l.join("\n").trim()}function O(t){var n=E(t);var r=e.substring(t,n);var i=/^\s*\/{1,2}/.test(r);return i}function E(e){var t=e;while(t<l&&k(t)!=="\n"){t++}return t}function R(){if(m.length>0)return m.shift();if(v)return w();var i,s,o,a,c;do{if(n===l)return null;i=false;while(u.test(o=k(n))){if(o==="\n")++f;if(++n===l)return null}if(k(n)==="/"){if(++n===l){throw b("comment")}if(k(n)==="/"){if(!t){c=k(a=n+1)==="/";while(k(++n)!=="\n"){if(n===l){return null}}++n;if(c){S(a,n-1)}++f;i=true}else{a=n;c=false;if(O(n)){c=true;do{n=E(n);if(n===l){break}n++}while(O(n))}else{n=Math.min(l,E(n)+1)}if(c){S(a,n)}f++;i=true}}else if((o=k(n))==="*"){a=n+1;c=t||k(a)==="*";do{if(o==="\n"){++f}if(++n===l){throw b("comment")}s=o;o=k(n)}while(s!=="*"||o!=="/");++n;if(c){S(a,n-2)}i=true}else{return"/"}}}while(i);var h=n;r.lastIndex=0;var p=r.test(k(h++));if(!p)while(h<l&&!r.test(k(h)))++h;var d=e.substring(n,n=h);if(d==='"'||d==="'")v=d;return d}function T(e){m.push(e)}function j(){if(!m.length){var e=R();if(e===null)return null;T(e)}return m[0]}function A(e,t){var n=j(),r=n===e;if(r){R();return true}if(!t)throw b("token '"+n+"', '"+e+"' expected");return false}function C(e){var n=null;if(e===undefined){if(y===f-1&&(t||p==="*"||g)){n=d}}else{if(y<e){j()}if(y===e&&!g&&(t||p==="/")){n=d}}return n}return Object.defineProperty({next:R,peek:j,push:T,skip:A,cmnt:C},"line",{get:function(){return f}})}},{}],35:[function(e,t,n){t.exports=v;var r=e(23);((v.prototype=Object.create(r.prototype)).constructor=v).className="Type";var i=e(15),s=e(25),o=e(16),a=e(20),c=e(33),u=e(21),l=e(27),f=e(42),h=e(37),p=e(14),d=e(13),y=e(40),g=e(12),m=e(41);function v(e,t){r.call(this,e,t);this.fields={};this.oneofs=undefined;this.extensions=undefined;this.reserved=undefined;this.group=undefined;this._fieldsById=null;this._fieldsArray=null;this._oneofsArray=null;this._ctor=null}Object.defineProperties(v.prototype,{fieldsById:{get:function(){if(this._fieldsById)return this._fieldsById;this._fieldsById={};for(var e=Object.keys(this.fields),t=0;t<e.length;++t){var n=this.fields[e[t]],r=n.id;if(this._fieldsById[r])throw Error("duplicate id "+r+" in "+this);this._fieldsById[r]=n}return this._fieldsById}},fieldsArray:{get:function(){return this._fieldsArray||(this._fieldsArray=h.toArray(this.fields))}},oneofsArray:{get:function(){return this._oneofsArray||(this._oneofsArray=h.toArray(this.oneofs))}},ctor:{get:function(){return this._ctor||(this.ctor=v.generateConstructor(this)())},set:function(e){var t=e.prototype;if(!(t instanceof u)){(e.prototype=new u).constructor=e;h.merge(e.prototype,t)}e.$type=e.prototype.$type=this;h.merge(e,u,true);this._ctor=e;var n=0;for(;n<this.fieldsArray.length;++n)this._fieldsArray[n].resolve();var r={};for(n=0;n<this.oneofsArray.length;++n)r[this._oneofsArray[n].resolve().name]={get:h.oneOfGetter(this._oneofsArray[n].oneof),set:h.oneOfSetter(this._oneofsArray[n].oneof)};if(n)Object.defineProperties(e.prototype,r)}}});v.generateConstructor=function e(t){var n=h.codegen(["p"],t.name);for(var r=0,i;r<t.fieldsArray.length;++r)if((i=t._fieldsArray[r]).map)n("this%s={}",h.safeProp(i.name));else if(i.repeated)n("this%s=[]",h.safeProp(i.name));return n("if(p)for(var ks=Object.keys(p),i=0;i<ks.length;++i)if(p[ks[i]]!=null)")("this[ks[i]]=p[ks[i]]")};function b(e){e._fieldsById=e._fieldsArray=e._oneofsArray=null;delete e.encode;delete e.decode;delete e.verify;return e}v.fromJSON=function e(t,n){var u=new v(t,n.options);u.extensions=n.extensions;u.reserved=n.reserved;var l=Object.keys(n.fields),f=0;for(;f<l.length;++f)u.add((typeof n.fields[l[f]].keyType!=="undefined"?a.fromJSON:o.fromJSON)(l[f],n.fields[l[f]]));if(n.oneofs)for(l=Object.keys(n.oneofs),f=0;f<l.length;++f)u.add(s.fromJSON(l[f],n.oneofs[l[f]]));if(n.nested)for(l=Object.keys(n.nested),f=0;f<l.length;++f){var h=n.nested[l[f]];u.add((h.id!==undefined?o.fromJSON:h.fields!==undefined?v.fromJSON:h.values!==undefined?i.fromJSON:h.methods!==undefined?c.fromJSON:r.fromJSON)(l[f],h))}if(n.extensions&&n.extensions.length)u.extensions=n.extensions;if(n.reserved&&n.reserved.length)u.reserved=n.reserved;if(n.group)u.group=true;if(n.comment)u.comment=n.comment;return u};v.prototype.toJSON=function e(t){var n=r.prototype.toJSON.call(this,t);var i=t?Boolean(t.keepComments):false;return h.toObject(["options",n&&n.options||undefined,"oneofs",r.arrayToJSON(this.oneofsArray,t),"fields",r.arrayToJSON(this.fieldsArray.filter((function(e){return!e.declaringField})),t)||{},"extensions",this.extensions&&this.extensions.length?this.extensions:undefined,"reserved",this.reserved&&this.reserved.length?this.reserved:undefined,"group",this.group||undefined,"nested",n&&n.nested||undefined,"comment",i?this.comment:undefined])};v.prototype.resolveAll=function e(){var t=this.fieldsArray,n=0;while(n<t.length)t[n++].resolve();var i=this.oneofsArray;n=0;while(n<i.length)i[n++].resolve();return r.prototype.resolveAll.call(this)};v.prototype.get=function e(t){return this.fields[t]||this.oneofs&&this.oneofs[t]||this.nested&&this.nested[t]||null};v.prototype.add=function e(t){if(this.get(t.name))throw Error("duplicate name '"+t.name+"' in "+this);if(t instanceof o&&t.extend===undefined){if(this._fieldsById?this._fieldsById[t.id]:this.fieldsById[t.id])throw Error("duplicate id "+t.id+" in "+this);if(this.isReservedId(t.id))throw Error("id "+t.id+" is reserved in "+this);if(this.isReservedName(t.name))throw Error("name '"+t.name+"' is reserved in "+this);if(t.parent)t.parent.remove(t);this.fields[t.name]=t;t.message=this;t.onAdd(this);return b(this)}if(t instanceof s){if(!this.oneofs)this.oneofs={};this.oneofs[t.name]=t;t.onAdd(this);return b(this)}return r.prototype.add.call(this,t)};v.prototype.remove=function e(t){if(t instanceof o&&t.extend===undefined){if(!this.fields||this.fields[t.name]!==t)throw Error(t+" is not a member of "+this);delete this.fields[t.name];t.parent=null;t.onRemove(this);return b(this)}if(t instanceof s){if(!this.oneofs||this.oneofs[t.name]!==t)throw Error(t+" is not a member of "+this);delete this.oneofs[t.name];t.parent=null;t.onRemove(this);return b(this)}return r.prototype.remove.call(this,t)};v.prototype.isReservedId=function e(t){return r.isReservedId(this.reserved,t)};v.prototype.isReservedName=function e(t){return r.isReservedName(this.reserved,t)};v.prototype.create=function e(t){return new this.ctor(t)};v.prototype.setup=function e(){var t=this.fullName,n=[];for(var r=0;r<this.fieldsArray.length;++r)n.push(this._fieldsArray[r].resolve().resolvedType);this.encode=p(this)({Writer:f,types:n,util:h});this.decode=d(this)({Reader:l,types:n,util:h});this.verify=y(this)({types:n,util:h});this.fromObject=g.fromObject(this)({types:n,util:h});this.toObject=g.toObject(this)({types:n,util:h});var i=m[t];if(i){var s=Object.create(this);s.fromObject=this.fromObject;this.fromObject=i.fromObject.bind(s);s.toObject=this.toObject;this.toObject=i.toObject.bind(s)}return this};v.prototype.encode=function e(t,n){return this.setup().encode(t,n)};v.prototype.encodeDelimited=function e(t,n){return this.encode(t,n&&n.len?n.fork():n).ldelim()};v.prototype.decode=function e(t,n){return this.setup().decode(t,n)};v.prototype.decodeDelimited=function e(t){if(!(t instanceof l))t=l.create(t);return this.decode(t,t.uint32())};v.prototype.verify=function e(t){return this.setup().verify(t)};v.prototype.fromObject=function e(t){return this.setup().fromObject(t)};v.prototype.toObject=function e(t,n){return this.setup().toObject(t,n)};v.d=function e(t){return function e(n){h.decorateType(n,t)}}},{12:12,13:13,14:14,15:15,16:16,20:20,21:21,23:23,25:25,27:27,33:33,37:37,40:40,41:41,42:42}],36:[function(e,t,n){var r=n;var i=e(37);var s=["double","float","int32","uint32","sint32","fixed32","sfixed32","int64","uint64","sint64","fixed64","sfixed64","bool","string","bytes"];function o(e,t){var n=0,r={};t|=0;while(n<e.length)r[s[n+t]]=e[n++];return r}r.basic=o([1,5,0,0,0,5,5,0,0,0,1,1,0,2,2]);r.defaults=o([0,0,0,0,0,0,0,0,0,0,0,0,false,"",i.emptyArray,null]);r.long=o([0,0,0,1,1],7);r.mapKey=o([0,0,0,5,5,0,0,0,1,1,0,2],2);r.packed=o([1,5,0,0,0,5,5,0,0,0,1,1,0])},{37:37}],37:[function(e,t,n){var r=t.exports=e(39);var i=e(30);var s,o;r.codegen=e(3);r.fetch=e(5);r.path=e(8);r.fs=r.inquire("fs");r.toArray=function e(t){if(t){var n=Object.keys(t),r=new Array(n.length),i=0;while(i<n.length)r[i]=t[n[i++]];return r}return[]};r.toObject=function e(t){var n={},r=0;while(r<t.length){var i=t[r++],s=t[r++];if(s!==undefined)n[i]=s}return n};var a=/\\/g,c=/"/g;r.isReserved=function e(t){return/^(?:do|if|in|for|let|new|try|var|case|else|enum|eval|false|null|this|true|void|with|break|catch|class|const|super|throw|while|yield|delete|export|import|public|return|static|switch|typeof|default|extends|finally|package|private|continue|debugger|function|arguments|interface|protected|implements|instanceof)$/.test(t)};r.safeProp=function e(t){if(!/^[$\w_]+$/.test(t)||r.isReserved(t))return'["'+t.replace(a,"\\\\").replace(c,'\\"')+'"]';return"."+t};r.ucFirst=function e(t){return t.charAt(0).toUpperCase()+t.substring(1)};var u=/_([a-z])/g;r.camelCase=function e(t){return t.substring(0,1)+t.substring(1).replace(u,(function(e,t){return t.toUpperCase()}))};r.compareFieldsById=function e(t,n){return t.id-n.id};r.decorateType=function t(n,i){if(n.$type){if(i&&n.$type.name!==i){r.decorateRoot.remove(n.$type);n.$type.name=i;r.decorateRoot.add(n.$type)}return n.$type}if(!s)s=e(35);var o=new s(i||n.name);r.decorateRoot.add(o);o.ctor=n;Object.defineProperty(n,"$type",{value:o,enumerable:false});Object.defineProperty(n.prototype,"$type",{value:o,enumerable:false});return o};var l=0;r.decorateEnum=function t(n){if(n.$type)return n.$type;if(!o)o=e(15);var i=new o("Enum"+l++,n);r.decorateRoot.add(i);Object.defineProperty(n,"$type",{value:i,enumerable:false});return i};Object.defineProperty(r,"decorateRoot",{get:function(){return i["decorated"]||(i["decorated"]=new(e(29)))}})},{15:15,29:29,3:3,30:30,35:35,39:39,5:5,8:8}],38:[function(e,t,n){t.exports=i;var r=e(39);function i(e,t){this.lo=e>>>0;this.hi=t>>>0}var s=i.zero=new i(0,0);s.toNumber=function(){return 0};s.zzEncode=s.zzDecode=function(){return this};s.length=function(){return 1};var o=i.zeroHash="\0\0\0\0\0\0\0\0";i.fromNumber=function e(t){if(t===0)return s;var n=t<0;if(n)t=-t;var r=t>>>0,o=(t-r)/4294967296>>>0;if(n){o=~o>>>0;r=~r>>>0;if(++r>4294967295){r=0;if(++o>4294967295)o=0}}return new i(r,o)};i.from=function e(t){if(typeof t==="number")return i.fromNumber(t);if(r.isString(t)){if(r.Long)t=r.Long.fromString(t);else return i.fromNumber(parseInt(t,10))}return t.low||t.high?new i(t.low>>>0,t.high>>>0):s};i.prototype.toNumber=function e(t){if(!t&&this.hi>>>31){var n=~this.lo+1>>>0,r=~this.hi>>>0;if(!n)r=r+1>>>0;return-(n+r*4294967296)}return this.lo+this.hi*4294967296};i.prototype.toLong=function e(t){return r.Long?new r.Long(this.lo|0,this.hi|0,Boolean(t)):{low:this.lo|0,high:this.hi|0,unsigned:Boolean(t)}};var a=String.prototype.charCodeAt;i.fromHash=function e(t){if(t===o)return s;return new i((a.call(t,0)|a.call(t,1)<<8|a.call(t,2)<<16|a.call(t,3)<<24)>>>0,(a.call(t,4)|a.call(t,5)<<8|a.call(t,6)<<16|a.call(t,7)<<24)>>>0)};i.prototype.toHash=function e(){return String.fromCharCode(this.lo&255,this.lo>>>8&255,this.lo>>>16&255,this.lo>>>24,this.hi&255,this.hi>>>8&255,this.hi>>>16&255,this.hi>>>24)};i.prototype.zzEncode=function e(){var t=this.hi>>31;this.hi=((this.hi<<1|this.lo>>>31)^t)>>>0;this.lo=(this.lo<<1^t)>>>0;return this};i.prototype.zzDecode=function e(){var t=-(this.lo&1);this.lo=((this.lo>>>1|this.hi<<31)^t)>>>0;this.hi=(this.hi>>>1^t)>>>0;return this};i.prototype.length=function e(){var t=this.lo,n=(this.lo>>>28|this.hi<<4)>>>0,r=this.hi>>>24;return r===0?n===0?t<16384?t<128?1:2:t<2097152?3:4:n<16384?n<128?5:6:n<2097152?7:8:r<128?9:10}},{39:39}],39:[function(e,t,n){var r=n;r.asPromise=e(1);r.base64=e(2);r.EventEmitter=e(4);r.float=e(6);r.inquire=e(7);r.utf8=e(10);r.pool=e(9);r.LongBits=e(38);r.emptyArray=Object.freeze?Object.freeze([]):[];r.emptyObject=Object.freeze?Object.freeze({}):{};r.isNode=Boolean(global.process&&global.process.versions&&global.process.versions.node);r.isInteger=Number.isInteger||function e(t){return typeof t==="number"&&isFinite(t)&&Math.floor(t)===t};r.isString=function e(t){return typeof t==="string"||t instanceof String};r.isObject=function e(t){return t&&typeof t==="object"};r.isset=r.isSet=function e(t,n){var r=t[n];if(r!=null&&t.hasOwnProperty(n))return typeof r!=="object"||(Array.isArray(r)?r.length:Object.keys(r).length)>0;return false};r.Buffer=function(){try{var e=r.inquire("buffer").Buffer;return e.prototype.utf8Write?e:null}catch(e){return null}}();r._Buffer_from=null;r._Buffer_allocUnsafe=null;r.newBuffer=function e(t){return typeof t==="number"?r.Buffer?r._Buffer_allocUnsafe(t):new r.Array(t):r.Buffer?r._Buffer_from(t):typeof Uint8Array==="undefined"?t:new Uint8Array(t)};r.Array=typeof Uint8Array!=="undefined"?Uint8Array:Array;r.Long=global.dcodeIO&&global.dcodeIO.Long||r.inquire("long");r.key2Re=/^true|false|0|1$/;r.key32Re=/^-?(?:0|[1-9][0-9]*)$/;r.key64Re=/^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/;r.longToHash=function e(t){return t?r.LongBits.from(t).toHash():r.LongBits.zeroHash};r.longFromHash=function e(t,n){var i=r.LongBits.fromHash(t);if(r.Long)return r.Long.fromBits(i.lo,i.hi,n);return i.toNumber(Boolean(n))};function i(e,t,n){for(var r=Object.keys(t),i=0;i<r.length;++i)if(e[r[i]]===undefined||!n)e[r[i]]=t[r[i]];return e}r.merge=i;r.lcFirst=function e(t){return t.charAt(0).toLowerCase()+t.substring(1)};function s(e){function t(e,n){if(!(this instanceof t))return new t(e,n);Object.defineProperty(this,"message",{get:function(){return e}});if(Error.captureStackTrace)Error.captureStackTrace(this,t);else Object.defineProperty(this,"stack",{value:(new Error).stack||""});if(n)i(this,n)}(t.prototype=Object.create(Error.prototype)).constructor=t;Object.defineProperty(t.prototype,"name",{get:function(){return e}});t.prototype.toString=function e(){return this.name+": "+this.message};return t}r.newError=s;r.ProtocolError=s("ProtocolError");r.oneOfGetter=function e(t){var n={};for(var r=0;r<t.length;++r)n[t[r]]=1;return function(){for(var e=Object.keys(this),t=e.length-1;t>-1;--t)if(n[e[t]]===1&&this[e[t]]!==undefined&&this[e[t]]!==null)return e[t]}};r.oneOfSetter=function e(t){return function(e){for(var n=0;n<t.length;++n)if(t[n]!==e)delete this[t[n]]}};r.toJSONOptions={longs:String,enums:String,bytes:String,json:true};r._configure=function(){var e=r.Buffer;if(!e){r._Buffer_from=r._Buffer_allocUnsafe=null;return}r._Buffer_from=e.from!==Uint8Array.from&&e.from||function t(n,r){return new e(n,r)};r._Buffer_allocUnsafe=e.allocUnsafe||function t(n){return new e(n)}}},{1:1,10:10,2:2,38:38,4:4,6:6,7:7,9:9}],40:[function(e,t,n){t.exports=c;var r=e(15),i=e(37);function s(e,t){return e.name+": "+t+(e.repeated&&t!=="array"?"[]":e.map&&t!=="object"?"{k:"+e.keyType+"}":"")+" expected"}function o(e,t,n,i){if(t.resolvedType){if(t.resolvedType instanceof r){e("switch(%s){",i)("default:")("return%j",s(t,"enum value"));for(var o=Object.keys(t.resolvedType.values),a=0;a<o.length;++a)e("case %i:",t.resolvedType.values[o[a]]);e("break")("}")}else{e("{")("var e=types[%i].verify(%s);",n,i)("if(e)")("return%j+e",t.name+".")("}")}}else{switch(t.type){case"int32":case"uint32":case"sint32":case"fixed32":case"sfixed32":e("if(!util.isInteger(%s))",i)("return%j",s(t,"integer"));break;case"int64":case"uint64":case"sint64":case"fixed64":case"sfixed64":e("if(!util.isInteger(%s)&&!(%s&&util.isInteger(%s.low)&&util.isInteger(%s.high)))",i,i,i,i)("return%j",s(t,"integer|Long"));break;case"float":case"double":e('if(typeof %s!=="number")',i)("return%j",s(t,"number"));break;case"bool":e('if(typeof %s!=="boolean")',i)("return%j",s(t,"boolean"));break;case"string":e("if(!util.isString(%s))",i)("return%j",s(t,"string"));break;case"bytes":e('if(!(%s&&typeof %s.length==="number"||util.isString(%s)))',i,i,i)("return%j",s(t,"buffer"));break}}return e}function a(e,t,n){switch(t.keyType){case"int32":case"uint32":case"sint32":case"fixed32":case"sfixed32":e("if(!util.key32Re.test(%s))",n)("return%j",s(t,"integer key"));break;case"int64":case"uint64":case"sint64":case"fixed64":case"sfixed64":e("if(!util.key64Re.test(%s))",n)("return%j",s(t,"integer|Long key"));break;case"bool":e("if(!util.key2Re.test(%s))",n)("return%j",s(t,"boolean key"));break}return e}function c(e){var t=i.codegen(["m"],e.name+"$verify")('if(typeof m!=="object"||m===null)')("return%j","object expected");var n=e.oneofsArray,r={};if(n.length)t("var p={}");for(var c=0;c<e.fieldsArray.length;++c){var u=e._fieldsArray[c].resolve(),l="m"+i.safeProp(u.name);if(u.optional)t("if(%s!=null&&m.hasOwnProperty(%j)){",l,u.name);if(u.map){t("if(!util.isObject(%s))",l)("return%j",s(u,"object"))("var k=Object.keys(%s)",l)("for(var i=0;i<k.length;++i){");a(t,u,"k[i]");o(t,u,c,l+"[k[i]]")("}")}else if(u.repeated){t("if(!Array.isArray(%s))",l)("return%j",s(u,"array"))("for(var i=0;i<%s.length;++i){",l);o(t,u,c,l+"[i]")("}")}else{if(u.partOf){var f=i.safeProp(u.partOf.name);if(r[u.partOf.name]===1)t("if(p%s===1)",f)("return%j",u.partOf.name+": multiple values");r[u.partOf.name]=1;t("p%s=1",f)}o(t,u,c,l)}if(u.optional)t("}")}return t("return null")}},{15:15,37:37}],41:[function(e,t,n){var r=n;var i=e(21);r[".google.protobuf.Any"]={fromObject:function(e){if(e&&e["@type"]){var t=this.lookup(e["@type"]);if(t){var n=e["@type"].charAt(0)==="."?e["@type"].substr(1):e["@type"];return this.create({type_url:"/"+n,value:t.encode(t.fromObject(e)).finish()})}}return this.fromObject(e)},toObject:function(e,t){if(t&&t.json&&e.type_url&&e.value){var n=e.type_url.substring(e.type_url.lastIndexOf("/")+1);var r=this.lookup(n);if(r)e=r.decode(e.value)}if(!(e instanceof this.ctor)&&e instanceof i){var s=e.$type.toObject(e,t);s["@type"]=e.$type.fullName;return s}return this.toObject(e,t)}}},{21:21}],42:[function(e,t,n){t.exports=f;var r=e(39);var i;var s=r.LongBits,o=r.base64,a=r.utf8;function c(e,t,n){this.fn=e;this.len=t;this.next=undefined;this.val=n}function u(){}function l(e){this.head=e.head;this.tail=e.tail;this.len=e.len;this.next=e.states}function f(){this.len=0;this.head=new c(u,0,0);this.tail=this.head;this.states=null}f.create=r.Buffer?function e(){return(f.create=function e(){return new i})()}:function e(){return new f};f.alloc=function e(t){return new r.Array(t)};if(r.Array!==Array)f.alloc=r.pool(f.alloc,r.Array.prototype.subarray);f.prototype._push=function e(t,n,r){this.tail=this.tail.next=new c(t,n,r);this.len+=n;return this};function h(e,t,n){t[n]=e&255}function p(e,t,n){while(e>127){t[n++]=e&127|128;e>>>=7}t[n]=e}function d(e,t){this.len=e;this.next=undefined;this.val=t}d.prototype=Object.create(c.prototype);d.prototype.fn=p;f.prototype.uint32=function e(t){this.len+=(this.tail=this.tail.next=new d((t=t>>>0)<128?1:t<16384?2:t<2097152?3:t<268435456?4:5,t)).len;return this};f.prototype.int32=function e(t){return t<0?this._push(y,10,s.fromNumber(t)):this.uint32(t)};f.prototype.sint32=function e(t){return this.uint32((t<<1^t>>31)>>>0)};function y(e,t,n){while(e.hi){t[n++]=e.lo&127|128;e.lo=(e.lo>>>7|e.hi<<25)>>>0;e.hi>>>=7}while(e.lo>127){t[n++]=e.lo&127|128;e.lo=e.lo>>>7}t[n++]=e.lo}f.prototype.uint64=function e(t){var n=s.from(t);return this._push(y,n.length(),n)};f.prototype.int64=f.prototype.uint64;f.prototype.sint64=function e(t){var n=s.from(t).zzEncode();return this._push(y,n.length(),n)};f.prototype.bool=function e(t){return this._push(h,1,t?1:0)};function g(e,t,n){t[n]=e&255;t[n+1]=e>>>8&255;t[n+2]=e>>>16&255;t[n+3]=e>>>24}f.prototype.fixed32=function e(t){return this._push(g,4,t>>>0)};f.prototype.sfixed32=f.prototype.fixed32;f.prototype.fixed64=function e(t){var n=s.from(t);return this._push(g,4,n.lo)._push(g,4,n.hi)};f.prototype.sfixed64=f.prototype.fixed64;f.prototype.float=function e(t){return this._push(r.float.writeFloatLE,4,t)};f.prototype.double=function e(t){return this._push(r.float.writeDoubleLE,8,t)};var m=r.Array.prototype.set?function e(t,n,r){n.set(t,r)}:function e(t,n,r){for(var i=0;i<t.length;++i)n[r+i]=t[i]};f.prototype.bytes=function e(t){var n=t.length>>>0;if(!n)return this._push(h,1,0);if(r.isString(t)){var i=f.alloc(n=o.length(t));o.decode(t,i,0);t=i}return this.uint32(n)._push(m,n,t)};f.prototype.string=function e(t){var n=a.length(t);return n?this.uint32(n)._push(a.write,n,t):this._push(h,1,0)};f.prototype.fork=function e(){this.states=new l(this);this.head=this.tail=new c(u,0,0);this.len=0;return this};f.prototype.reset=function e(){if(this.states){this.head=this.states.head;this.tail=this.states.tail;this.len=this.states.len;this.states=this.states.next}else{this.head=this.tail=new c(u,0,0);this.len=0}return this};f.prototype.ldelim=function e(){var t=this.head,n=this.tail,r=this.len;this.reset().uint32(r);if(r){this.tail.next=t.next;this.tail=n;this.len+=r}return this};f.prototype.finish=function e(){var t=this.head.next,n=this.constructor.alloc(this.len),r=0;while(t){t.fn(t.val,n,r);r+=t.len;t=t.next}return n};f._configure=function(e){i=e}},{39:39}],43:[function(e,t,n){t.exports=o;var r=e(42);(o.prototype=Object.create(r.prototype)).constructor=o;var i=e(39);var s=i.Buffer;function o(){r.call(this)}o.alloc=function e(t){return(o.alloc=i._Buffer_allocUnsafe)(t)};var a=s&&s.prototype instanceof Uint8Array&&s.prototype.set.name==="set"?function e(t,n,r){n.set(t,r)}:function e(t,n,r){if(t.copy)t.copy(n,r,0,t.length);else for(var i=0;i<t.length;)n[r++]=t[i++]};o.prototype.bytes=function e(t){if(i.isString(t))t=i._Buffer_from(t,"base64");var n=t.length>>>0;this.uint32(n);if(n)this._push(a,n,t);return this};function c(e,t,n){if(e.length<40)i.utf8.write(e,t,n);else t.utf8Write(e,n)}o.prototype.string=function e(t){var n=s.byteLength(t);this.uint32(n);if(n)this._push(c,n,t);return this}},{39:39,42:42}]},{},[19])})(typeof window==="object"&&window||typeof self==="object"&&self||undefined);(function(e){var t=e.Reader,n=e.Writer,r=e.util;var i=e.roots["push-server"]||(e.roots["push-server"]={});i.RequestBatch=function(){function e(e){this.requests=[];if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.requests=r.emptyArray;e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.requests!=null&&t.requests.length)for(var s=0;s<t.requests.length;++s)i.Request.encode(t.requests[s],r.uint32(10).fork()).ldelim();return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.RequestBatch;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:if(!(o.requests&&o.requests.length))o.requests=[];o.requests.push(i.Request.decode(n,n.uint32()));break;default:n.skipType(a&7);break}}return o};return e}();i.Request=function(){function e(e){if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.incomingMessages=null;e.prototype.channelStats=null;e.prototype.serverStats=null;var s;Object.defineProperty(e.prototype,"command",{get:r.oneOfGetter(s=["incomingMessages","channelStats","serverStats"]),set:r.oneOfSetter(s)});e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.incomingMessages!=null&&t.hasOwnProperty("incomingMessages"))i.IncomingMessagesRequest.encode(t.incomingMessages,r.uint32(10).fork()).ldelim();if(t.channelStats!=null&&t.hasOwnProperty("channelStats"))i.ChannelStatsRequest.encode(t.channelStats,r.uint32(18).fork()).ldelim();if(t.serverStats!=null&&t.hasOwnProperty("serverStats"))i.ServerStatsRequest.encode(t.serverStats,r.uint32(26).fork()).ldelim();return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.Request;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:o.incomingMessages=i.IncomingMessagesRequest.decode(n,n.uint32());break;case 2:o.channelStats=i.ChannelStatsRequest.decode(n,n.uint32());break;case 3:o.serverStats=i.ServerStatsRequest.decode(n,n.uint32());break;default:n.skipType(a&7);break}}return o};return e}();i.IncomingMessagesRequest=function(){function e(e){this.messages=[];if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.messages=r.emptyArray;e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.messages!=null&&t.messages.length)for(var s=0;s<t.messages.length;++s)i.IncomingMessage.encode(t.messages[s],r.uint32(10).fork()).ldelim();return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.IncomingMessagesRequest;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:if(!(o.messages&&o.messages.length))o.messages=[];o.messages.push(i.IncomingMessage.decode(n,n.uint32()));break;default:n.skipType(a&7);break}}return o};return e}();i.IncomingMessage=function(){function e(e){this.receivers=[];if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.receivers=r.emptyArray;e.prototype.sender=null;e.prototype.body="";e.prototype.expiry=0;e.prototype.type="";e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.receivers!=null&&t.receivers.length)for(var s=0;s<t.receivers.length;++s)i.Receiver.encode(t.receivers[s],r.uint32(10).fork()).ldelim();if(t.sender!=null&&t.hasOwnProperty("sender"))i.Sender.encode(t.sender,r.uint32(18).fork()).ldelim();if(t.body!=null&&t.hasOwnProperty("body"))r.uint32(26).string(t.body);if(t.expiry!=null&&t.hasOwnProperty("expiry"))r.uint32(32).uint32(t.expiry);if(t.type!=null&&t.hasOwnProperty("type"))r.uint32(42).string(t.type);return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.IncomingMessage;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:if(!(o.receivers&&o.receivers.length))o.receivers=[];o.receivers.push(i.Receiver.decode(n,n.uint32()));break;case 2:o.sender=i.Sender.decode(n,n.uint32());break;case 3:o.body=n.string();break;case 4:o.expiry=n.uint32();break;case 5:o.type=n.string();break;default:n.skipType(a&7);break}}return o};return e}();i.ChannelStatsRequest=function(){function e(e){this.channels=[];if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.channels=r.emptyArray;e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.channels!=null&&t.channels.length)for(var s=0;s<t.channels.length;++s)i.ChannelId.encode(t.channels[s],r.uint32(10).fork()).ldelim();return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.ChannelStatsRequest;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:if(!(o.channels&&o.channels.length))o.channels=[];o.channels.push(i.ChannelId.decode(n,n.uint32()));break;default:n.skipType(a&7);break}}return o};return e}();i.ChannelId=function(){function e(e){if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.id=r.newBuffer([]);e.prototype.isPrivate=false;e.prototype.signature=r.newBuffer([]);e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.id!=null&&t.hasOwnProperty("id"))r.uint32(10).bytes(t.id);if(t.isPrivate!=null&&t.hasOwnProperty("isPrivate"))r.uint32(16).bool(t.isPrivate);if(t.signature!=null&&t.hasOwnProperty("signature"))r.uint32(26).bytes(t.signature);return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.ChannelId;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:o.id=n.bytes();break;case 2:o.isPrivate=n.bool();break;case 3:o.signature=n.bytes();break;default:n.skipType(a&7);break}}return o};return e}();i.ServerStatsRequest=function(){function e(e){if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.ServerStatsRequest;while(n.pos<s){var a=n.uint32();switch(a>>>3){default:n.skipType(a&7);break}}return o};return e}();i.Sender=function(){function e(e){if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.type=0;e.prototype.id=r.newBuffer([]);e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.type!=null&&t.hasOwnProperty("type"))r.uint32(8).int32(t.type);if(t.id!=null&&t.hasOwnProperty("id"))r.uint32(18).bytes(t.id);return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.Sender;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:o.type=n.int32();break;case 2:o.id=n.bytes();break;default:n.skipType(a&7);break}}return o};return e}();i.SenderType=function(){var e={},t=Object.create(e);t[e[0]="UNKNOWN"]=0;t[e[1]="CLIENT"]=1;t[e[2]="BACKEND"]=2;return t}();i.Receiver=function(){function e(e){if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.id=r.newBuffer([]);e.prototype.isPrivate=false;e.prototype.signature=r.newBuffer([]);e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.id!=null&&t.hasOwnProperty("id"))r.uint32(10).bytes(t.id);if(t.isPrivate!=null&&t.hasOwnProperty("isPrivate"))r.uint32(16).bool(t.isPrivate);if(t.signature!=null&&t.hasOwnProperty("signature"))r.uint32(26).bytes(t.signature);return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.Receiver;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:o.id=n.bytes();break;case 2:o.isPrivate=n.bool();break;case 3:o.signature=n.bytes();break;default:n.skipType(a&7);break}}return o};return e}();i.ResponseBatch=function(){function e(e){this.responses=[];if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.responses=r.emptyArray;e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.responses!=null&&t.responses.length)for(var s=0;s<t.responses.length;++s)i.Response.encode(t.responses[s],r.uint32(10).fork()).ldelim();return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.ResponseBatch;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:if(!(o.responses&&o.responses.length))o.responses=[];o.responses.push(i.Response.decode(n,n.uint32()));break;default:n.skipType(a&7);break}}return o};return e}();i.Response=function(){function e(e){if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.outgoingMessages=null;e.prototype.channelStats=null;e.prototype.serverStats=null;var s;Object.defineProperty(e.prototype,"command",{get:r.oneOfGetter(s=["outgoingMessages","channelStats","serverStats"]),set:r.oneOfSetter(s)});e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.outgoingMessages!=null&&t.hasOwnProperty("outgoingMessages"))i.OutgoingMessagesResponse.encode(t.outgoingMessages,r.uint32(10).fork()).ldelim();if(t.channelStats!=null&&t.hasOwnProperty("channelStats"))i.ChannelStatsResponse.encode(t.channelStats,r.uint32(18).fork()).ldelim();if(t.serverStats!=null&&t.hasOwnProperty("serverStats"))i.JsonResponse.encode(t.serverStats,r.uint32(26).fork()).ldelim();return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.Response;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:o.outgoingMessages=i.OutgoingMessagesResponse.decode(n,n.uint32());break;case 2:o.channelStats=i.ChannelStatsResponse.decode(n,n.uint32());break;case 3:o.serverStats=i.JsonResponse.decode(n,n.uint32());break;default:n.skipType(a&7);break}}return o};return e}();i.OutgoingMessagesResponse=function(){function e(e){this.messages=[];if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.messages=r.emptyArray;e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.messages!=null&&t.messages.length)for(var s=0;s<t.messages.length;++s)i.OutgoingMessage.encode(t.messages[s],r.uint32(10).fork()).ldelim();return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.OutgoingMessagesResponse;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:if(!(o.messages&&o.messages.length))o.messages=[];o.messages.push(i.OutgoingMessage.decode(n,n.uint32()));break;default:n.skipType(a&7);break}}return o};return e}();i.OutgoingMessage=function(){function e(e){if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.id=r.newBuffer([]);e.prototype.body="";e.prototype.expiry=0;e.prototype.created=0;e.prototype.sender=null;e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.id!=null&&t.hasOwnProperty("id"))r.uint32(10).bytes(t.id);if(t.body!=null&&t.hasOwnProperty("body"))r.uint32(18).string(t.body);if(t.expiry!=null&&t.hasOwnProperty("expiry"))r.uint32(24).uint32(t.expiry);if(t.created!=null&&t.hasOwnProperty("created"))r.uint32(37).fixed32(t.created);if(t.sender!=null&&t.hasOwnProperty("sender"))i.Sender.encode(t.sender,r.uint32(42).fork()).ldelim();return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.OutgoingMessage;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:o.id=n.bytes();break;case 2:o.body=n.string();break;case 3:o.expiry=n.uint32();break;case 4:o.created=n.fixed32();break;case 5:o.sender=i.Sender.decode(n,n.uint32());break;default:n.skipType(a&7);break}}return o};return e}();i.ChannelStatsResponse=function(){function e(e){this.channels=[];if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.channels=r.emptyArray;e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.channels!=null&&t.channels.length)for(var s=0;s<t.channels.length;++s)i.ChannelStats.encode(t.channels[s],r.uint32(10).fork()).ldelim();return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.ChannelStatsResponse;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:if(!(o.channels&&o.channels.length))o.channels=[];o.channels.push(i.ChannelStats.decode(n,n.uint32()));break;default:n.skipType(a&7);break}}return o};return e}();i.ChannelStats=function(){function e(e){if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.id=r.newBuffer([]);e.prototype.isPrivate=false;e.prototype.isOnline=false;e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.id!=null&&t.hasOwnProperty("id"))r.uint32(10).bytes(t.id);if(t.isPrivate!=null&&t.hasOwnProperty("isPrivate"))r.uint32(16).bool(t.isPrivate);if(t.isOnline!=null&&t.hasOwnProperty("isOnline"))r.uint32(24).bool(t.isOnline);return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.ChannelStats;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:o.id=n.bytes();break;case 2:o.isPrivate=n.bool();break;case 3:o.isOnline=n.bool();break;default:n.skipType(a&7);break}}return o};return e}();i.JsonResponse=function(){function e(e){if(e)for(var t=Object.keys(e),n=0;n<t.length;++n)if(e[t[n]]!=null)this[t[n]]=e[t[n]]}e.prototype.json="";e.create=function t(n){return new e(n)};e.encode=function e(t,r){if(!r)r=n.create();if(t.json!=null&&t.hasOwnProperty("json"))r.uint32(10).string(t.json);return r};e.decode=function e(n,r){if(!(n instanceof t))n=t.create(n);var s=r===undefined?n.len:n.pos+r,o=new i.JsonResponse;while(n.pos<s){var a=n.uint32();switch(a>>>3){case 1:o.json=n.string();break;default:n.skipType(a&7);break}}return o};return e}();return i})(typeof window==="object"&&typeof window.protobuf==="object"&&window.protobuf||typeof self==="object"&&typeof self.protobuf==="object"&&self.protobuf||typeof protobuf==="object"&&protobuf);const Response=protobuf.roots["push-server"].Response;const ResponseBatch=protobuf.roots["push-server"].ResponseBatch;const Request=protobuf.roots["push-server"].Request;const RequestBatch=protobuf.roots["push-server"].RequestBatch;const IncomingMessagesRequest=protobuf.roots["push-server"].IncomingMessagesRequest;const IncomingMessage=protobuf.roots["push-server"].IncomingMessage;const Receiver=protobuf.roots["push-server"].Receiver;class ProtobufCodec{constructor(e){this.channelManager=e.channelManager}extractMessages(e){const t=[];try{const n=ResponseBatch.decode(new Uint8Array(e));for(let e=0;e<n.responses.length;e++){const r=n.responses[e];if(r.command!=="outgoingMessages"){continue}const i=r.outgoingMessages.messages;for(const e of i){let n={};try{n=JSON.parse(e.body)}catch(e){console.error(`${getDateForLog()}: Pull: Could not parse message body`,e);continue}if(!n.extra){n.extra={}}n.extra.sender={type:e.sender.type};if(e.sender.id instanceof Uint8Array){n.extra.sender.id=decodeId(e.sender.id)}const r={mid:decodeId(e.id),text:n};t.push(r)}}}catch(e){console.error(`${getDateForLog()}: Pull: Could not parse message`,e)}return t}async encodeMessageBatch(e){const t={};for(const n of e){if(n.userList){for(let e=0;e<n.userList.length;e++){t[n.userList[e]]=true}}}const n=await this.channelManager.getPublicIds(Object.keys(t));return this.encodeMessageBatchInternal(e,n)}encodeMessageBatchInternal(e,t){const n=[];e.forEach((e=>{const r=e.body;let i=[];if(e.userList){i=this.createMessageReceivers(e.userList,t)}if(e.channelList){if(!isArray(e.channelList)){throw new TypeError("messageFields.publicChannels must be an array")}e.channelList.forEach((e=>{let t="";let n="";if(typeof e==="string"&&e.includes(".")){const r=e.toString().split(".");t=r[0];n=r[1]}else if(typeof e==="object"&&"publicId"in e&&"signature"in e){t=e.publicId;n=e.signature}else{throw new Error("Public channel MUST be either a string, formatted like \"{publicId}.{signature}\" or an object with fields 'publicId' and 'signature'")}i.push(Receiver.create({id:this.encodeId(t),signature:this.encodeId(n)}))}))}const s=IncomingMessage.create({receivers:i,body:JSON.stringify(r),expiry:e.expiry||0});n.push(s)}));const r=RequestBatch.create({requests:[{incomingMessages:{messages:n}}]});return RequestBatch.encode(r).finish()}createMessageReceivers(e,t){const n=[];for(const r of e){if(!t[r]||!t[r].publicId){throw new Error(`Could not determine public id for user ${r}`)}n.push(Receiver.create({id:this.encodeId(t[r].publicId),signature:this.encodeId(t[r].signature)}))}return n}encodeId(e){if(!e){return new Uint8Array}const t=[];for(let n=0;n<e.length;n+=2){t.push(parseInt(e.slice(n,n+2),16))}return new Uint8Array(t)}}function decodeId(e){if(!(e instanceof Uint8Array)){throw new TypeError("encodedId should be an instance of Uint8Array")}let t="";for(const n of e){const e=n.toString(16);if(e.length===1){t+="0"}t+=e}return t}class LegacyCodec{async encodeMessageBatch(e){return null}extractMessages(e){const t=[];const n=e.match(/#!NGINXNMS!#(.*?)#!NGINXNME!#/gm);if(n===null){const n="\n========= PULL ERROR ===========\n"+"Error type: parseResponse error parsing message\n"+"\n"+`Data string: ${e}\n`+"================================\n\n";console.error(n);return t}for(let e=0;e<n.length;e++){n[e]=n[e].slice(12,-12);if(n[e].length<=0){continue}let r={};try{r=JSON.parse(n[e])}catch{continue}t.push(r)}return t}}const RESTORE_WEBSOCKET_TIMEOUT=30*60;const MAX_IDS_TO_STORE=10;const PING_TIMEOUT=10;const JSON_RPC_PING="ping";const JSON_RPC_PONG="pong";const LS_SESSION="bx-pull-session";const ConnectorEvents={Message:"message",RevisionChanged:"revisionChanged",ChannelReplaced:"channelReplaced",ConfigExpired:"configExpired",ConnectionStatus:"connectionStatus",ConnectionError:"connectionError"};class Connector extends EventTarget{constructor(e={}){super();this.connectors={webSocket:null,longPolling:null};this.connectPromises=[];this.pingWaitTimeout=null;this.reconnectTimeout=null;this.isWebsocketBlocked=false;this.isLongPollingBlocked=false;this.isManualDisconnect=false;this._status=PullStatus.Offline;this.connectionAttempt=0;this.config=e.config;this.logger=e.logger;this.storage=e.storage;this.restClient=e.restClient;this.isSecure=globalThis.location.protocol==="https:";this.connectors.webSocket=new WebSocketConnector({pathGetter:()=>this.getConnectionPathByType(ConnectionType.WebSocket),onOpen:this.onWebSocketOpen.bind(this),onMessage:this.onIncomingMessage.bind(this),onDisconnect:this.onWebSocketDisconnect.bind(this),onError:this.onWebSocketError.bind(this)});this.connectors.longPolling=new LongPollingConnector({pathGetter:()=>this.getConnectionPathByType(ConnectionType.LongPolling),isBinary:this.isProtobufSupported()&&!this.isJsonRpc(),onOpen:this.onLongPollingOpen.bind(this),onMessage:this.onIncomingMessage.bind(this),onDisconnect:this.onLongPollingDisconnect.bind(this),onError:this.onLongPollingError.bind(this)});this.connectionType=this.isWebSocketAllowed()?ConnectionType.WebSocket:ConnectionType.LongPolling;for(const t of Object.keys(e.events||{})){this.addEventListener(t,e.events[t])}this.channelManager=new ChannelManager({restClient:e.restClient,getPublicListMethod:e.getPublicListMethod});this.jsonRpcAdapter=this.createRpcAdapter();this.codec=this.createCodec();this.session={mid:null,tag:null,time:null,history:{},lastMessageIds:[],messageCount:0};if(e.restoreSession&&this.storage){const e=this.storage.get(LS_SESSION);const t=new Date;if(isPlainObject(e)&&"ttl"in e&&e.ttl>=t){this.session.mid=e.mid}}}get status(){return this._status}set status(e){if(this._status===e){return}this._status=e;this.dispatchEvent(new CustomEvent(ConnectorEvents.ConnectionStatus,{detail:{status:e,connectionType:this.connector.connectionType}}))}createRpcAdapter(){return new JsonRpc({sender:this.connectors.webSocket,handlers:{"incoming.message":this.handleRpcIncomingMessage.bind(this)},events:{error:this.onRpcError.bind(this)}})}createCodec(){if(this.isProtobufSupported()){return new ProtobufCodec({channelManager:this.channelManager})}return new LegacyCodec}get connector(){return this.connectors[this.connectionType]}disconnect(e,t){if(this.connector){this.isManualDisconnect=true;this.connector.disconnect(e,t)}}stop(e,t){this.disconnect(e,t);this.stopCheckConfig()}resetSession(){this.session.mid=null;this.session.tag=null;this.session.time=null}setConfig(e){const t=this.isConnected();if(t){this.disconnect(CloseReasons.CONFIG_REPLACED,"config was replaced")}this.config=e;if(e.publicChannels){this.channelManager.setPublicIds(Object.values(e.publicChannels))}if(t){this.connect()}}connect(){if(this.connector.connected){return Promise.resolve()}if(this.reconnectTimeout){clearTimeout(this.reconnectTimeout)}this.isManualDisconnect=false;this.status=PullStatus.Connecting;this.connectionAttempt++;return new Promise(((e,t)=>{this.connectPromises.push({resolve:e,reject:t});this.connector.connect()}))}reconnect(e,t,n=1){this.disconnect(e,t);this.scheduleReconnect(n)}restoreWebSocketConnection(){if(this.connectionType===ConnectionType.WebSocket){return}this.connectors.webSocket.connect()}scheduleReconnect(e){var t;const n=e!=null?e:this.getConnectionAttemptDelay(this.connectionAttempt);if(this.reconnectTimeout){clearTimeout(this.reconnectTimeout)}(t=this.logger)==null?void 0:t.log(`Pull: scheduling reconnection in ${n} seconds; attempt # ${this.connectionAttempt}`);this.reconnectTimeout=setTimeout((()=>{this.connect().catch((e=>{console.error(e)}))}),n*1e3)}scheduleRestoreWebSocketConnection(){var e;(e=this.logger)==null?void 0:e.log(`Pull: scheduling restoration of websocket connection in ${RESTORE_WEBSOCKET_TIMEOUT} seconds`);if(this.restoreWebSocketTimeout){return}this.restoreWebSocketTimeout=setTimeout((()=>{this.restoreWebSocketTimeout=0;this.restoreWebSocketConnection()}),RESTORE_WEBSOCKET_TIMEOUT*1e3)}handleInternalPullEvent(e,t){switch(e.toUpperCase()){case SystemCommands.CHANNEL_EXPIRE:{if(t.params.action==="reconnect"&&"new_channel"in t.params){this.dispatchEvent(new CustomEvent(ConnectorEvents.ChannelReplaced),{detail:{type:t.params.channel.type,newChannel:t.params.new_channel}})}else{this.dispatchEvent(new CustomEvent(ConnectorEvents.ConfigExpired))}break}case SystemCommands.CONFIG_EXPIRE:{this.dispatchEvent(new CustomEvent(ConnectorEvents.ConfigExpired));break}case SystemCommands.SERVER_RESTART:{this.reconnect(CloseReasons.SERVER_RESTARTED,"server was restarted",15);break}default:}}getConnectionBasePath(e){switch(e){case ConnectionType.WebSocket:return this.isSecure?this.config.server.websocket_secure:this.config.server.websocket;case ConnectionType.LongPolling:return this.isSecure?this.config.server.long_pooling_secure:this.config.server.long_polling;default:throw new Error(`Unknown connection type ${e}`)}}getConnectionChannels(){const e=[];for(const t of["private","shared"]){if(t in this.config.channels){e.push(this.config.channels[t].id)}}if(e.length===0){throw new Error("Empty channel list")}return e.join("/")}getConnectionPath(){return this.getConnectionPathByType(this.connectionType)}getConnectionPathByType(e){const t={};const n=this.getConnectionBasePath(e);if(isNotEmptyString(this.config.jwt)){t.token=this.config.jwt}else{t.CHANNEL_ID=this.getConnectionChannels()}if(this.isJsonRpc()){t.jsonRpc="true"}else if(this.isProtobufSupported()){t.binaryMode="true"}if(this.isSharedMode()){if(!this.config.clientId){throw new Error("Push-server is in shared mode, but clientId is not set")}t.clientId=this.config.clientId}if(this.config.server&&this.config.server.hostname){t.hostname=this.config.server.hostname}if(this.session.mid){t.mid=this.session.mid}if(this.session.tag){t.tag=this.session.tag}if(this.session.time){t.time=this.session.time}t.revision=REVISION;return`${n}?${buildQueryString(t)}`}getPublicationPath(){const e=this.isSecure?this.config.server.publish_secure:this.config.server.publish;if(!e){return""}const t=[];for(const e of Object.keys(this.config.channels)){t.push(this.config.channels[e].id)}const n={CHANNEL_ID:t.join("/")};return`${e}?${buildQueryString(n)}`}emitMessage(e){if(!isPlainObject(e.extra)){e.extra={}}if(e.extra.server_time_unix){var t;const n=(t=this.config.server.timeShift)!=null?t:0;const r=(getTimestamp()-e.extra.server_time_unix*1e3)/1e3-n;e.extra.server_time_ago=r>0?r:0}this.dispatchEvent(new CustomEvent(ConnectorEvents.Message,{detail:e}))}getConnectionAttemptDelay(e){let t=60;if(e<1){t=.5}else if(e<3){t=5}else if(e<5){t=25}else if(e<10){t=45}return t+t*Math.random()*.2}onLongPollingOpen(){var e;this.unloading=false;this.starting=false;this.connectionAttempt=0;this.isManualDisconnect=false;this.status=PullStatus.Online;(e=this.logger)==null?void 0:e.log("Pull: Long polling connection with push-server opened");if(this.isWebSocketEnabled()){this.scheduleRestoreWebSocketConnection()}this.connectPromises.forEach((e=>{e.resolve()}));this.connectPromises=[]}onWebSocketOpen(){var e;this.status=PullStatus.Online;this.isWebsocketBlocked=false;this.connectionAttempt=0;this.isLongPollingBlocked=true;if(this.connectionType===ConnectionType.LongPolling){this.connectionType=ConnectionType.WebSocket;this.connectors.longPolling.disconnect()}if(this.restoreWebSocketTimeout){clearTimeout(this.restoreWebSocketTimeout);this.restoreWebSocketTimeout=null}(e=this.logger)==null?void 0:e.log("Pull: Websocket connection with push-server opened");this.connectPromises.forEach((e=>{e.resolve()}));this.connectPromises=[]}onWebSocketDisconnect(e={}){if(this.connectionType===ConnectionType.WebSocket){this.status=PullStatus.Offline}if(this.isManualDisconnect){var t;(t=this.logger)==null?void 0:t.logForce("Pull: Websocket connection with push-server manually closed")}else{var n;(n=this.logger)==null?void 0:n.logForce(`Pull: Websocket connection with push-server closed. Code: ${e.code}, reason: ${e.reason}`);if(e.code===CloseReasons.WRONG_CHANNEL_ID){this.dispatchEvent(new CustomEvent(ConnectorEvents.ConnectionError,{detail:{code:e.code,reason:"wrong channel signature"}}))}else{this.scheduleReconnect()}}this.isLongPollingBlocked=true;this.isManualDisconnect=false;this.clearPingWaitTimeout()}onWebSocketError(e){this.starting=false;if(this.connectionType===ConnectionType.WebSocket){this.status=PullStatus.Offline}console.error(`${getDateForLog()}: Pull: WebSocket connection error`,e);this.scheduleReconnect();this.connectPromises.forEach((e=>{e.reject()}));this.connectPromises=[];this.clearPingWaitTimeout()}onWebSocketBlockChanged(e){const t=e.isWebSocketBlocked;if(t&&this.connectionType===ConnectionType.WebSocket&&!this.isConnected()){clearTimeout(this.reconnectTimeout);this.connectionAttempt=0;this.connectionType=ConnectionType.LongPolling;this.scheduleReconnect(1)}else if(!t&&this.connectionType===ConnectionType.LongPolling){clearTimeout(this.reconnectTimeout);clearTimeout(this.restoreWebSocketTimeout);this.connectionAttempt=0;this.connectionType=ConnectionType.WebSocket;this.scheduleReconnect(1)}}onLongPollingDisconnect(e={}){var t;if(this.connectionType===ConnectionType.LongPolling){this.status=PullStatus.Offline}(t=this.logger)==null?void 0:t.log(`Pull: Long polling connection with push-server closed. Code: ${e.code}, reason: ${e.reason}`);if(!this.isManualDisconnect){this.scheduleReconnect()}this.isManualDisconnect=false;this.clearPingWaitTimeout()}onLongPollingError(e){this.starting=false;if(this.connectionType===ConnectionType.LongPolling){this.status=PullStatus.Offline}console.error(`${getDateForLog()}: Pull: Long polling connection error`,e);this.scheduleReconnect();this.connectPromises.forEach((e=>{e.reject()}));this.connectPromises=[];this.clearPingWaitTimeout()}onIncomingMessage(e){if(this.isJsonRpc()){if(e===JSON_RPC_PING){this.onJsonRpcPing()}else{this.jsonRpcAdapter.handleIncomingMessage(e)}}else{const t=this.codec.extractMessages(e);this.handleIncomingEvents(t)}}handleRpcIncomingMessage(e){this.session.mid=e.mid;const t=e.body;if(!e.body.extra){t.extra={}}t.extra.sender=e.sender;if("user_params"in e&&isPlainObject(e.user_params)){Object.assign(t.params,e.user_params)}if("dictionary"in e&&isPlainObject(e.dictionary)){Object.assign(t.params,e.dictionary)}if(this.checkDuplicate(e.mid)){this.addMessageToStat(t);this.trimDuplicates();if(t.module_id==="pull"){this.handleInternalPullEvent(t.command,t)}else{this.emitMessage(t)}if(t.extra&&t.extra.revision_web){this.checkRevision(t.extra.revision_web)}}this.connector.send(`mack:${e.mid}`);return{}}onRpcError(e){}onJsonRpcPing(){this.updatePingWaitTimeout();this.connector.send(JSON_RPC_PONG)}handleIncomingEvents(e){const t=[];if(e.length===0){this.session.mid=null;return}for(const n of e){this.updateSessionFromEvent(n);if(n.mid&&!this.checkDuplicate(n.mid)){continue}this.addMessageToStat(n.text);t.push(n.text)}this.trimDuplicates();t.forEach((e=>{if(e.module_id==="pull"){this.handleInternalPullEvent(e.command,e)}else{this.emitMessage(e)}if(e.extra&&e.extra.revision_web){this.checkRevision(e.extra.revision_web)}}))}checkRevision(e){if(e>0&&e!==REVISION){var t;(t=this.logger)==null?void 0:t.log(`Pull revision changed from ${REVISION} to ${e}. Reload required`);this.dispatchEvent(new CustomEvent(ConnectorEvents.RevisionChanged,{detail:{revision:e}}))}}updateSessionFromEvent(e){this.session.mid=e.mid||null;this.session.tag=e.tag||null;this.session.time=e.time||null}checkDuplicate(e){if(this.session.lastMessageIds.includes(e)){console.warn(`Duplicate message ${e} skipped`);return false}this.session.lastMessageIds.push(e);return true}trimDuplicates(){if(this.session.lastMessageIds.length>MAX_IDS_TO_STORE){this.session.lastMessageIds=this.session.lastMessageIds.slice(-MAX_IDS_TO_STORE)}}addMessageToStat(e){if(!this.session.history[e.module_id]){this.session.history[e.module_id]={}}if(!this.session.history[e.module_id][e.command]){this.session.history[e.module_id][e.command]=0}this.session.history[e.module_id][e.command]++;this.session.messageCount++}getRevision(){return this.config&&this.config.api?this.config.api.revision_web:null}getServerVersion(){return this.config&&this.config.server?this.config.server.version:0}getServerMode(){return this.config&&this.config.server?this.config.server.mode:null}isConnected(){return this.connector.connected}isWebSocketConnected(){return this.connector.connected&&this.connector.connectionType===ConnectionType.WebSocket}isWebSocketAllowed(){return!this.isWebsocketBlocked&&this.isWebSocketEnabled()}isWebSocketEnabled(){return this.config&&this.config.server&&this.config.server.websocket_enabled===true}isPublishingSupported(){return this.getServerVersion()>3}isPublishingEnabled(){if(!this.isPublishingSupported()){return false}return this.config&&this.config.server&&this.config.server.publish_enabled===true}isProtobufSupported(){return this.getServerVersion()===4&&!browser.IsIe()}isJsonRpc(){return this.getServerVersion()>=5}isSharedMode(){return this.getServerMode()===ServerMode.Shared}setPublicIds(e){this.channelManager.setPublicIds(e)}async sendMessageBatch(e){if(!this.isPublishingEnabled()){throw new Error("Client publishing is not supported or is disabled")}try{const t=await this.codec.encodeMessageBatch(e);this.connector.send(t)}catch(e){console.error("sendMessageBatch error:",e);throw e}}async sendMessage(e,t,n,r,i){const s={userList:e,body:{module_id:t,command:n,params:r},expiry:i};if(this.isJsonRpc()){return this.jsonRpcAdapter.executeOutgoingRpcCommand(RpcMethod.Publish,s)}return this.sendMessageBatch([s])}sendMessageToChannels(e,t,n,r,i){const s={channelList:e,body:{module_id:t,command:n,params:r},expiry:i};if(this.isJsonRpc()){return this.jsonRpcAdapter.executeOutgoingRpcCommand(RpcMethod.Publish,s)}return this.sendMessageBatch([s])}async subscribeUserStatusChange(e){if(typeof e!=="number"){throw new TypeError("userId must be a number")}await this.jsonRpcAdapter.executeOutgoingRpcCommand(RpcMethod.SubscribeStatusChange,{userId:e})}async unsubscribeUserStatusChange(e){if(typeof e!=="number"){throw new TypeError("userId must be a number")}await this.jsonRpcAdapter.executeOutgoingRpcCommand(RpcMethod.UnsubscribeStatusChange,{userId:e})}async getUsersLastSeen(e){if(!isArray(e)||!e.every((e=>typeof e==="number"))){throw new Error("userList must be an array of numbers")}const t={};const n=await this.jsonRpcAdapter.executeOutgoingRpcCommand(RpcMethod.GetUsersLastSeen,{userList:e});const r=[];for(const i of e){if(!(i in n)){r.push(i)}t[i]=n[i]}if(r.length===0){return t}const i={userIds:r,sendToQueueSever:true};const s=await this.restClient.callMethod("pull.api.user.getLastSeen",i);const o=s.data();for(const e of Object.keys(o)){t[e]=o[e]}return t}ping(e){return this.jsonRpcAdapter.executeOutgoingRpcCommand(RpcMethod.Ping,{},e)}listChannels(){return this.jsonRpcAdapter.executeOutgoingRpcCommand(RpcMethod.ListChannels,{})}updatePingWaitTimeout(){clearTimeout(this.pingWaitTimeout);this.pingWaitTimeout=setTimeout(this.onPingTimeout.bind(this),PING_TIMEOUT*2*1e3)}clearPingWaitTimeout(){clearTimeout(this.pingWaitTimeout);this.pingWaitTimeout=null}onPingTimeout(){this.pingWaitTimeout=null;if(!this.isConnected()){return}console.warn(`No pings are received in ${PING_TIMEOUT*2} seconds. Reconnecting`);this.disconnect(CloseReasons.STUCK,"connection stuck");this.scheduleReconnect()}}exports.ConnectorEvents=ConnectorEvents;exports.Connector=Connector})(this.BX.Pull=this.BX.Pull||{});
//# sourceMappingURL=connector.bundle.map.js