
CREATE TABLE b_pull_stack (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CHANNEL_ID varchar(50) NOT NULL,
  MESSAGE text NOT NULL,
  DATE_CREATE timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_pull_stack_channel_id ON b_pull_stack (channel_id);
CREATE INDEX ix_b_pull_stack_date_create ON b_pull_stack (date_create);

CREATE TABLE b_pull_channel (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  CHANNEL_TYPE varchar(255),
  CHANNEL_ID varchar(50) NOT NULL,
  CHANNEL_PUBLIC_ID varchar(50),
  LAST_ID int,
  DATE_CREATE timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_pull_channel_user_id_channel_type ON b_pull_channel (user_id, channel_type);
CREATE INDEX ix_b_pull_channel_channel_id ON b_pull_channel (channel_id);
CREATE INDEX ix_b_pull_channel_channel_public_id ON b_pull_channel (channel_public_id);
CREATE INDEX ix_b_pull_channel_date_create ON b_pull_channel (date_create);

CREATE TABLE b_pull_push (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  DEVICE_TYPE varchar(50),
  APP_ID varchar(50),
  UNIQUE_HASH varchar(50),
  DEVICE_ID varchar(255),
  DEVICE_NAME varchar(50),
  DEVICE_TOKEN varchar(255) NOT NULL DEFAULT '',
  VOIP_TYPE varchar(50),
  VOIP_TOKEN varchar(255),
  DATE_CREATE timestamp NOT NULL,
  DATE_AUTH timestamp,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_pull_push_user_id ON b_pull_push (user_id);
CREATE INDEX ix_b_pull_push_unique_hash ON b_pull_push (unique_hash);
CREATE INDEX ix_b_pull_push_device_token ON b_pull_push (device_token);
CREATE INDEX ix_b_pull_push_voip_token ON b_pull_push (voip_token);

CREATE TABLE b_pull_push_queue (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  TAG varchar(255),
  SUB_TAG varchar(255),
  MESSAGE text,
  PARAMS text,
  ADVANCED_PARAMS text,
  BADGE int,
  DATE_CREATE timestamp,
  APP_ID varchar(50),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_pull_push_queue_user_id_tag ON b_pull_push_queue (user_id, tag);
CREATE INDEX ix_b_pull_push_queue_user_id_sub_tag ON b_pull_push_queue (user_id, sub_tag);
CREATE INDEX ix_b_pull_push_queue_date_create ON b_pull_push_queue (date_create);
CREATE INDEX ix_b_pull_push_queue_app_id ON b_pull_push_queue (app_id);

CREATE TABLE b_pull_watch (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  CHANNEL_ID varchar(50) NOT NULL,
  TAG varchar(255) NOT NULL,
  DATE_CREATE timestamp NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_pull_watch_user_id_tag ON b_pull_watch (user_id, tag);
CREATE INDEX ix_b_pull_watch_date_create ON b_pull_watch (date_create);
CREATE INDEX ix_b_pull_watch_tag ON b_pull_watch (tag);
