
CREATE TABLE b_perf_hit (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  DATE_HIT timestamp,
  IS_ADMIN char(1),
  REQUEST_METHOD varchar(50),
  SERVER_NAME varchar(50),
  SERVER_PORT int,
  SCRIPT_NAME text,
  REQUEST_URI text,
  INCLUDED_FILES int,
  MEMORY_PEAK_USAGE int,
  CACHE_TYPE char(1),
  CACHE_SIZE int,
  CACHE_COUNT_R int,
  CACHE_COUNT_W int,
  CACHE_COUNT_C int,
  QUERIES int,
  QUERIES_TIME real,
  COMPONENTS int,
  COMPONENTS_TIME real,
  SQL_LOG char(1),
  PAGE_TIME real,
  PROLOG_TIME real,
  PROLOG_BEFORE_TIME real,
  AGENTS_TIME real,
  PROLOG_AFTER_TIME real,
  WORK_AREA_TIME real,
  EPILOG_TIME real,
  EPILOG_BEFORE_TIME real,
  EVENTS_TIME real,
  EPILOG_AFTER_TIME real,
  MENU_RECALC int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_perf_hit_date_hit ON b_perf_hit (date_hit);

CREATE TABLE b_perf_component (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  HIT_ID int,
  NN int,
  CACHE_TYPE char(1),
  CACHE_SIZE int,
  CACHE_COUNT_R int,
  CACHE_COUNT_W int,
  CACHE_COUNT_C int,
  COMPONENT_TIME real,
  QUERIES int,
  QUERIES_TIME real,
  COMPONENT_NAME text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_perf_component_hit_id_nn ON b_perf_component (hit_id, nn);

CREATE TABLE b_perf_sql (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  HIT_ID int,
  COMPONENT_ID int,
  NN int,
  QUERY_TIME real,
  NODE_ID int,
  MODULE_NAME text,
  COMPONENT_NAME text,
  SQL_TEXT text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_perf_sql_hit_id_nn ON b_perf_sql (hit_id, nn);
CREATE INDEX ix_b_perf_sql_component_id ON b_perf_sql (component_id);

CREATE TABLE b_perf_sql_backtrace (
  SQL_ID int,
  NN int,
  FILE_NAME varchar(500),
  LINE_NO int,
  CLASS_NAME varchar(500),
  FUNCTION_NAME varchar(500),
  PRIMARY KEY (SQL_ID, NN)
);

CREATE TABLE b_perf_cache (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  HIT_ID int,
  COMPONENT_ID int,
  NN int,
  CACHE_SIZE real,
  OP_MODE char(1),
  MODULE_NAME text,
  COMPONENT_NAME text,
  BASE_DIR text,
  INIT_DIR text,
  FILE_NAME text,
  FILE_PATH text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_perf_cache_hit_id_nn ON b_perf_cache (hit_id, nn);
CREATE INDEX ix_b_perf_cache_component_id ON b_perf_cache (component_id);

CREATE TABLE b_perf_error (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  HIT_ID int,
  ERRNO int,
  ERRSTR text,
  ERRFILE text,
  ERRLINE int,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_perf_error_hit_id ON b_perf_error (hit_id);

CREATE TABLE b_perf_test (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  REFERENCE_ID int,
  NAME varchar(200),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_perf_test_reference_id ON b_perf_test (reference_id);

CREATE TABLE b_perf_cluster (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp,
  THREADS int,
  HITS int,
  ERRORS int,
  PAGES_PER_SECOND real,
  PAGE_EXEC_TIME real,
  PAGE_RESP_TIME real,
  PRIMARY KEY (ID)
);

CREATE TABLE b_perf_index_suggest (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SQL_MD5 char(32),
  SQL_COUNT int,
  SQL_TIME real,
  TABLE_NAME varchar(50),
  TABLE_ALIAS varchar(50),
  COLUMN_NAMES varchar(250),
  SQL_TEXT text,
  SQL_EXPLAIN text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_perf_index_suggest_sql_md5 ON b_perf_index_suggest (sql_md5);

CREATE TABLE b_perf_index_suggest_sql (
  SUGGEST_ID int,
  SQL_ID int,
  PRIMARY KEY (SUGGEST_ID, SQL_ID)
);
CREATE INDEX ix_b_perf_index_suggest_sql_sql_id_suggest_id ON b_perf_index_suggest_sql (sql_id, suggest_id);

CREATE TABLE b_perf_index_ban (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  BAN_TYPE char(1),
  TABLE_NAME varchar(50),
  COLUMN_NAMES varchar(250),
  PRIMARY KEY (ID)
);

CREATE TABLE b_perf_tab_stat (
  TABLE_NAME varchar(50),
  TABLE_SIZE real,
  TABLE_ROWS real,
  PRIMARY KEY (TABLE_NAME)
);

CREATE TABLE b_perf_tab_column_stat (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TABLE_NAME varchar(50),
  COLUMN_NAME varchar(50),
  TABLE_ROWS real,
  COLUMN_ROWS real,
  VALUE varchar(100),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_perf_tab_column_stat_table_name_column_name ON b_perf_tab_column_stat (table_name, column_name);

CREATE TABLE b_perf_index_complete (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  BANNED char(1),
  TABLE_NAME varchar(50),
  COLUMN_NAMES varchar(250),
  INDEX_NAME varchar(50),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_perf_index_complete_table_name ON b_perf_index_complete (table_name);

CREATE TABLE b_perf_history (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp,
  TOTAL_MARK real,
  ACCELERATOR_ENABLED char(1),
  PRIMARY KEY (ID)
);

CREATE TABLE b_perf_table (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TABLE_NAME varchar(64),
  KEY_COLUMN varchar(50),
  REC_COUNT int,
  LAST_ID varchar(250),
  PRIMARY KEY (ID)
);
