CREATE TABLE b_perf_hit
(
	ID INT(11) NOT NULL auto_increment,
	DATE_HIT DATETIME,
	IS_ADMIN CHAR(1),
	REQUEST_METHOD VARCHAR(50),
	SERVER_NAME VARCHAR(50),
	SERVER_PORT INT(11),
	SCRIPT_NAME text,
	REQUEST_URI text,
	INCLUDED_FILES INT(11),
	MEMORY_PEAK_USAGE INT(11),
	CACHE_TYPE CHAR(1),
	CACHE_SIZE INT(11),
	CACHE_COUNT_R INT(11),
	CACHE_COUNT_W INT(11),
	CACHE_COUNT_C INT(11),
	QUERIES INT(11),
	QUERIES_TIME FLOAT,
	COMPONENTS INT(11),
	COMPONENTS_TIME FLOAT,
	SQL_LOG CHAR(1),
	PAGE_TIME FLOAT,
	PROLOG_TIME FLOAT,
	PROLOG_BEFORE_TIME FLOAT,
	AGENTS_TIME FLOAT,
	PROLOG_AFTER_TIME FLOAT,
	WORK_AREA_TIME FLOAT,
	EPILOG_TIME FLOAT,
	EPILOG_BEFORE_TIME FLOAT,
	EVENTS_TIME FLOAT,
	EPILOG_AFTER_TIME FLOAT,
	MENU_RECALC INT(11),
	CONSTRAINT PK_B_PERF_HIT PRIMARY KEY (ID)
);
CREATE INDEX IX_B_PERF_HIT_0 ON b_perf_hit(DATE_HIT);

CREATE TABLE b_perf_component
(
	ID INT(18) NOT NULL auto_increment,
	HIT_ID INT(18),
	NN INT(18),
	CACHE_TYPE CHAR(1),
	CACHE_SIZE INT(11),
	CACHE_COUNT_R INT(11),
	CACHE_COUNT_W INT(11),
	CACHE_COUNT_C INT(11),
	COMPONENT_TIME FLOAT,
	QUERIES INT(11),
	QUERIES_TIME FLOAT,
	COMPONENT_NAME text,
	CONSTRAINT PK_B_PERF_COMPONENT PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX IX_B_PERF_COMPONENT_0 ON b_perf_component(HIT_ID, NN);

CREATE TABLE b_perf_sql
(
	ID INT(18) NOT NULL auto_increment,
	HIT_ID INT(18),
	COMPONENT_ID INT(18),
	NN INT(18),
	QUERY_TIME FLOAT,
	NODE_ID INT(18),
	MODULE_NAME text,
	COMPONENT_NAME text,
	SQL_TEXT TEXT,
	CONSTRAINT PK_B_PERF_SQL PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX IX_B_PERF_SQL_0 ON b_perf_sql(HIT_ID, NN);
CREATE INDEX IX_B_PERF_SQL_1 ON b_perf_sql(COMPONENT_ID);

CREATE TABLE b_perf_sql_backtrace
(
	SQL_ID INT(18),
	NN INT(18),
	FILE_NAME varchar(500),
	LINE_NO INT(18),
	CLASS_NAME varchar(500),
	FUNCTION_NAME varchar(500),
	CONSTRAINT pk_b_perf_sql_backtrace PRIMARY KEY (SQL_ID, NN)
);

CREATE TABLE b_perf_cache
(
	ID INT(18) NOT NULL auto_increment,
	HIT_ID INT(18),
	COMPONENT_ID INT(18),
	NN INT(18),
	CACHE_SIZE FLOAT,
	OP_MODE CHAR(1),
	MODULE_NAME text,
	COMPONENT_NAME text,
	BASE_DIR TEXT,
	INIT_DIR TEXT,
	FILE_NAME TEXT,
	FILE_PATH TEXT,
	CONSTRAINT PK_B_PERF_CACHE PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX IX_B_PERF_CACHE_0 ON b_perf_cache(HIT_ID, NN);
CREATE INDEX IX_B_PERF_CACHE_1 ON b_perf_cache(COMPONENT_ID);

CREATE TABLE b_perf_error
(
	ID INT(18) NOT NULL auto_increment,
	HIT_ID INT(18),
	ERRNO INT(18),
	ERRSTR text,
	ERRFILE text,
	ERRLINE INT(18),
	CONSTRAINT PK_B_PERF_ERROR PRIMARY KEY (ID)
);
CREATE INDEX IX_B_PERF_ERROR_0 ON b_perf_error(HIT_ID);

CREATE TABLE b_perf_test
(
	ID INT(18) NOT NULL auto_increment,
	REFERENCE_ID INT(18),
	NAME varchar(200),
	CONSTRAINT PK_B_PERF_TEST PRIMARY KEY (ID)
);
CREATE INDEX IX_B_PERF_TEST_0 ON b_perf_test(REFERENCE_ID);

CREATE TABLE b_perf_cluster
(
	ID INT(11) NOT NULL auto_increment,
	TIMESTAMP_X DATETIME,
	THREADS INT(11),
	HITS INT(11),
	ERRORS INT(11),
	PAGES_PER_SECOND FLOAT,
	PAGE_EXEC_TIME FLOAT,
	PAGE_RESP_TIME FLOAT,

	PRIMARY KEY pk_b_perf_cluster(ID)
);

CREATE TABLE b_perf_index_suggest
(
	ID INT(11) NOT NULL auto_increment,
	SQL_MD5 CHAR(32),
	SQL_COUNT INT(11),
	SQL_TIME FLOAT,
	TABLE_NAME VARCHAR(50),
	TABLE_ALIAS VARCHAR(50),
	COLUMN_NAMES VARCHAR(250),
	SQL_TEXT TEXT,
	SQL_EXPLAIN LONGTEXT,
	PRIMARY KEY pk_b_perf_index_suggest(ID)
);
CREATE INDEX ix_b_perf_index_suggest_0 ON b_perf_index_suggest(SQL_MD5);

CREATE TABLE b_perf_index_suggest_sql
(
	SUGGEST_ID INT(11),
	SQL_ID INT(11),
	PRIMARY KEY pk_b_perf_index_suggest_sql(SUGGEST_ID, SQL_ID)
);
CREATE INDEX ix_b_perf_index_suggest_sql_0 ON b_perf_index_suggest_sql(SQL_ID, SUGGEST_ID);

CREATE TABLE b_perf_index_ban
(
	ID INT(11) NOT NULL auto_increment,
	BAN_TYPE CHAR(1),
	TABLE_NAME VARCHAR(50),
	COLUMN_NAMES VARCHAR(250),
	PRIMARY KEY pk_b_perf_index_ban(ID)
);

CREATE TABLE b_perf_tab_stat
(
	TABLE_NAME VARCHAR(50),
	TABLE_SIZE FLOAT,
	TABLE_ROWS FLOAT,
	PRIMARY KEY pk_b_perf_tab_stat(TABLE_NAME)
);

CREATE TABLE b_perf_tab_column_stat
(
	ID INT(11) NOT NULL auto_increment,
	TABLE_NAME VARCHAR(50),
	COLUMN_NAME VARCHAR(50),
	TABLE_ROWS FLOAT,
	COLUMN_ROWS FLOAT,
	VALUE VARCHAR(100),
	PRIMARY KEY pk_b_perf_tab_column_stat(ID),
	KEY ix_b_perf_tab_column_stat(TABLE_NAME, COLUMN_NAME)
);

CREATE TABLE b_perf_index_complete
(
	ID INT(11) NOT NULL auto_increment,
	BANNED CHAR(1),
	TABLE_NAME VARCHAR(50),
	COLUMN_NAMES VARCHAR(250),
	INDEX_NAME VARCHAR(50),
	PRIMARY KEY pk_b_perf_index_complete(ID)
);
CREATE INDEX ix_b_perf_index_complete_0 ON b_perf_index_complete(TABLE_NAME);

CREATE TABLE b_perf_history
(
	ID INT(18) NOT NULL auto_increment,
	TIMESTAMP_X DATETIME,
	TOTAL_MARK FLOAT,
	ACCELERATOR_ENABLED CHAR(1),
	CONSTRAINT PK_B_PERF_HISTORY PRIMARY KEY (ID)
);

CREATE TABLE b_perf_table
(
	ID INT(11) NOT NULL auto_increment,
	TABLE_NAME VARCHAR(64),
	KEY_COLUMN VARCHAR(50),
	REC_COUNT INT(11),
	LAST_ID VARCHAR(250),
	PRIMARY KEY pk_b_perf_table(ID)
);
