(function(){"use strict";BX.namespace("BX.SidePanel");BX.SidePanel.Slider=function(e,t){t=BX.type.isPlainObject(t)?t:{};this.options=t;this.contentCallback=BX.type.isFunction(t.contentCallback)?t.contentCallback:null;this.contentCallbackInvoved=false;this.contentClassName=BX.type.isNotEmptyString(t.contentClassName)?t.contentClassName:null;this.url=this.contentCallback?e:this.refineUrl(e);this.offset=null;this.hideControls=t.hideControls===true;this.width=BX.type.isNumber(t.width)?t.width:null;this.cacheable=t.cacheable!==false;this.autoFocus=t.autoFocus!==false;this.printable=t.printable===true;this.allowChangeHistory=t.allowChangeHistory!==false;this.allowChangeTitle=BX.type.isBoolean(t.allowChangeTitle)?t.allowChangeTitle:null;this.allowCrossOrigin=t.allowCrossOrigin===true;this.data=new BX.SidePanel.Dictionary(BX.type.isPlainObject(t.data)?t.data:{});this.customLeftBoundary=null;this.customRightBoundary=null;this.setCustomLeftBoundary(t.customLeftBoundary);this.setCustomRightBoundary(t.customRightBoundary);this.title=null;this.setTitle(t.title);this.iframe=null;this.iframeSrc=null;this.iframeId=null;this.requestMethod=BX.type.isNotEmptyString(t.requestMethod)&&t.requestMethod.toLowerCase()==="post"?"post":"get";this.requestParams=BX.type.isPlainObject(t.requestParams)?t.requestParams:{};this.opened=false;this.hidden=false;this.destroyed=false;this.loaded=false;this.loadedCnt=0;this.minimizing=false;this.maximizing=false;this.handleFrameKeyDown=this.handleFrameKeyDown.bind(this);this.handleFrameFocus=this.handleFrameFocus.bind(this);this.handleFrameUnload=this.handleFrameUnload.bind(this);this.handlePopupInit=this.handlePopupInit.bind(this);this.handleCrossOriginWindowMessage=this.handleCrossOriginWindowMessage.bind(this);this.layout={overlay:null,container:null,loader:null,content:null,closeBtn:null,printBtn:null};this.cache=new BX.Cache.MemoryCache;this.loader=BX.type.isNotEmptyString(t.loader)||BX.type.isElementNode(t.loader)?t.loader:BX.type.isNotEmptyString(t.typeLoader)?t.typeLoader:"default-loader";this.animation=null;this.animationDuration=BX.type.isNumber(t.animationDuration)?t.animationDuration:200;this.startParams={translateX:100,opacity:0,scale:0};this.endParams={translateX:0,opacity:40,scale:100};this.currentParams=null;this.overlayAnimation=false;this.animationName="sliding";this.animationOptions={};this.minimizeOptions=null;const i=t.minimizeOptions;if(BX.Type.isPlainObject(i)&&BX.Type.isStringFilled(i.entityType)&&(BX.Type.isStringFilled(i.entityId)||BX.Type.isNumber(i.entityId))&&BX.Type.isStringFilled(i.url)){this.minimizeOptions=i}this.label=new BX.SidePanel.Label(this,{iconClass:"side-panel-label-icon-close",iconTitle:BX.Loc.getMessage("MAIN_SIDEPANEL_CLOSE"),onclick:function(e,t){t.close()}});var n=BX.type.isPlainObject(t.label)?t.label:{};this.label.setText(n.text);this.label.setColor(n.color);this.label.setBgColor(n.bgColor,n.opacity);this.minimizeLabel=null;this.newWindowLabel=null;this.copyLinkLabel=null;if(!this.isSelfContained()&&this.minimizeOptions!==null){this.minimizeLabel=new BX.SidePanel.Label(this,{iconClass:"side-panel-label-icon-minimize ui-icon-set --arrow-line",iconTitle:BX.Loc.getMessage("MAIN_SIDEPANEL_MINIMIZE"),bgColor:["#d9dcdf",100],onclick:(e,t)=>{if(this.isLoaded()){this.minimize()}}})}if(t.newWindowLabel===true&&(!this.isSelfContained()||BX.Type.isStringFilled(t.newWindowUrl))){this.newWindowLabel=new BX.SidePanel.Label(this,{iconClass:"side-panel-label-icon-new-window",iconTitle:BX.Loc.getMessage("MAIN_SIDEPANEL_NEW_WINDOW"),bgColor:["#d9dcdf",100],onclick:function(e,i){const n=BX.Type.isStringFilled(t.newWindowUrl)?t.newWindowUrl:i.getUrl();Object.assign(document.createElement("a"),{target:"_blank",href:n}).click()}})}if(t.copyLinkLabel===true&&(!this.isSelfContained()||BX.Type.isStringFilled(t.newWindowUrl))){this.copyLinkLabel=new BX.SidePanel.Label(this,{iconClass:"side-panel-label-icon-copy-link",iconTitle:BX.Loc.getMessage("MAIN_SIDEPANEL_COPY_LINK"),bgColor:["#d9dcdf",100]});BX.clipboard.bindCopyClick(this.copyLinkLabel.getIconBox(),{text:()=>{const e=document.createElement("a");e.href=BX.Type.isStringFilled(t.newWindowUrl)?t.newWindowUrl:this.getUrl();return e.href}})}if(this.url.indexOf("crm.activity.planner/slider.php")!==-1&&t.events&&BX.type.isFunction(t.events.onOpen)&&t.events.compatibleEvents!==false){var s=t.events.onOpen;delete t.events.onOpen;t.events.onLoad=function(e){s(e.getSlider())}}if(t.events){for(var a in t.events){if(BX.type.isFunction(t.events[a])){BX.addCustomEvent(this,BX.SidePanel.Slider.getEventFullName(a),t.events[a])}}}};BX.SidePanel.Slider.getEventFullName=function(e){return"SidePanel.Slider:"+e};BX.SidePanel.Slider.prototype={open:function(){if(this.isOpen()){return false}if(!this.canOpen()){return false}if(this.isDestroyed()){return false}if(this.maximizing){this.fireEvent("onMaximizeStart")}this.createLayout();BX.addClass(this.getOverlay(),"side-panel-overlay-open side-panel-overlay-opening");this.adjustLayout();BX.ZIndexManager.bringToFront(this.getOverlay());this.opened=true;this.fireEvent("onOpenStart");this.animateOpening();return true},close:function(e,t){if(!this.isOpen()){return false}if(!this.canClose()){return false}if(this.minimizing){this.fireEvent("onMinimizeStart")}this.fireEvent("onCloseStart");this.opened=false;if(this.isDestroyed()){return false}if(this.animation){this.animation.stop()}this.fireEvent("onClosing");if(e===true||BX.browser.IsMobile()){this.currentParams=this.startParams;this.completeAnimation(t)}else{this.animation=new BX.easing({duration:this.animationDuration,start:this.currentParams,finish:this.startParams,transition:BX.easing.transitions.linear,step:BX.delegate((function(e){this.currentParams=e;this.animateStep(e)}),this),complete:BX.delegate((function(){this.completeAnimation(t)}),this)});this.getContainer().style.opacity=.96;if(this.animationName==="scale"&&BX.Type.isStringFilled(this.animationOptions.origin)){this.getContainer().style.transformOrigin=this.animationOptions.origin}this.animation.animate()}return true},minimize(e,t){this.minimizing=true;const i=this.close(e,t);if(!i){this.minimizing=false}return i},isMinimizing(){return this.minimizing},maximize(){this.maximizing=true;const e=this.open();if(!e){this.maximizing=false}return e},isMaximizing(){return this.maximizing},setAnimation(e,t){this.animationName=e==="scale"?e:"sliding";this.animationOptions=BX.Type.isPlainObject(t)?t:{}},getMinimizeOptions(){return this.minimizeOptions},getUrl:function(){return this.url},setUrl(e){if(BX.Type.isStringFilled(e)){this.url=e}},focus:function(){this.getWindow().focus()},isOpen:function(){return this.opened},setZindex:function(e){},getZindex:function(){var e=BX.ZIndexManager.getComponent(this.getOverlay());return e.getZIndex()},setOffset:function(e){if(BX.type.isNumber(e)||e===null){this.offset=e}},getOffset:function(){return this.offset},setWidth:function(e){if(BX.type.isNumber(e)){this.width=e}},getWidth:function(){return this.width},setTitle:function(e){if(BX.type.isNotEmptyString(e)){this.title=e}},getTitle:function(){return this.title},getData:function(){return this.data},isSelfContained:function(){return this.contentCallback!==null},isPostMethod:function(){return this.requestMethod==="post"},getRequestParams:function(){return this.requestParams},getFrameId:function(){if(this.iframeId===null){this.iframeId="iframe_"+BX.util.getRandomString(10).toLowerCase()}return this.iframeId},getWindow:function(){return this.iframe?this.iframe.contentWindow:window},getFrameWindow:function(){return this.iframe?this.iframe.contentWindow:null},isHidden:function(){return this.hidden},isCacheable:function(){return this.cacheable},isFocusable:function(){return this.autoFocus},isPrintable:function(){return this.printable},isDestroyed:function(){return this.destroyed},isLoaded:function(){return this.loaded},canChangeHistory:function(){return this.allowChangeHistory&&!this.allowCrossOrigin&&!this.isSelfContained()&&!this.getUrl().match(/^\/bitrix\/(components|tools)\//i)},canChangeTitle:function(){if(this.allowChangeTitle===null){if(this.getTitle()!==null){return true}return this.canChangeHistory()}return this.allowChangeTitle},setCacheable:function(e){this.cacheable=e!==false},setAutoFocus:function(e){this.autoFocus=e!==false},setPrintable:function(e){this.printable=e!==false;this.printable?this.showPrintBtn():this.hidePrintBtn()},getLoader:function(){return this.loader},showLoader:function(){var e=this.getLoader();if(!this.layout.loader){this.createLoader(e)}this.layout.loader.style.opacity=1;this.layout.loader.style.display="block"},closeLoader:function(){if(this.layout.loader){this.layout.loader.style.display="none";this.layout.loader.style.opacity=0}},showCloseBtn:function(){this.getLabel().showIcon()},hideCloseBtn:function(){this.getLabel().hideIcon()},showOrLightenCloseBtn:function(){if(BX.Type.isStringFilled(this.getLabel().getText())){this.getLabel().showIcon()}else{this.getLabel().lightenIcon()}},hideOrDarkenCloseBtn:function(){if(BX.Type.isStringFilled(this.getLabel().getText())){this.getLabel().hideIcon()}else{this.getLabel().darkenIcon()}},showPrintBtn:function(){this.getPrintBtn().classList.add("side-panel-print-visible")},hidePrintBtn:function(){this.getPrintBtn().classList.remove("side-panel-print-visible")},showExtraLabels:function(){this.getExtraLabelsContainer().style.removeProperty("display")},hideExtraLabels:function(){this.getExtraLabelsContainer().style.display="none"},setContentClass:function(e){if(BX.type.isNotEmptyString(e)){this.removeContentClass();this.contentClassName=e;this.getContentContainer().classList.add(e)}},removeContentClass:function(){if(this.contentClassName!==null){this.getContentContainer().classList.remove(this.contentClassName);this.contentClassName=null}},applyHacks:function(){},applyPostHacks:function(){},resetHacks:function(){},resetPostHacks:function(){},getTopBoundary:function(){return 0},calculateLeftBoundary:function(){var e=this.getCustomLeftBoundary();if(e!==null){return e}return this.getLeftBoundary()},getLeftBoundary:function(){var e=BX.browser.IsMobile()?window.innerWidth:document.documentElement.clientWidth;return e<1160?this.getMinLeftBoundary():300},getMinLeftBoundary:function(){return this.hideControls&&this.getCustomLeftBoundary()!==null?0:65},getLeftBoundaryOffset:function(){var e=this.getOffset()!==null?this.getOffset():0;return Math.max(this.calculateLeftBoundary(),this.getMinLeftBoundary())+e},setCustomLeftBoundary:function(e){if(BX.type.isNumber(e)||e===null){this.customLeftBoundary=e}},getCustomLeftBoundary:function(){return this.customLeftBoundary},setCustomRightBoundary:function(e){if(BX.type.isNumber(e)||e===null){this.customRightBoundary=e}},getCustomRightBoundary:function(){return this.customRightBoundary},calculateRightBoundary:function(){const e=this.getCustomRightBoundary();if(e!==null){return-window.pageXOffset+e}return this.getRightBoundary()},getRightBoundary:function(){return-window.pageXOffset},destroy:function(){if(this.isDestroyed()){return}this.firePageEvent("onDestroy");this.fireFrameEvent("onDestroy");var e=this.getFrameWindow();if(e&&!this.allowCrossOrigin){e.removeEventListener("keydown",this.handleFrameKeyDown);e.removeEventListener("focus",this.handleFrameFocus);e.removeEventListener("unload",this.handleFrameUnload)}else if(this.allowCrossOrigin){window.removeEventListener("message",this.handleCrossOriginWindowMessage)}BX.Event.EventEmitter.unsubscribe("BX.Main.Popup:onInit",this.handlePopupInit);BX.ZIndexManager.unregister(this.layout.overlay);BX.remove(this.layout.overlay);this.layout.container=null;this.layout.overlay=null;this.layout.content=null;this.layout.closeBtn=null;this.layout.printBtn=null;this.layout.loader=null;this.iframe=null;this.destroyed=true;if(this.options.events){for(var t in this.options.events){BX.removeCustomEvent(this,BX.SidePanel.Slider.getEventFullName(t),this.options.events[t])}}this.firePageEvent("onDestroyComplete");return true},hide:function(){this.hidden=true;this.getContainer().style.display="none";this.getOverlay().style.display="none"},unhide:function(){this.hidden=false;this.getContainer().style.removeProperty("display");this.getOverlay().style.removeProperty("display")},reload:function(){this.loaded=false;if(this.isSelfContained()){this.contentCallbackInvoved=false;this.showLoader();this.setContent()}else{this.showLoader();this.getFrameWindow().location.reload()}},adjustLayout:function(){var e=window.pageYOffset||document.documentElement.scrollTop;var t=BX.browser.IsMobile()?window.innerHeight:document.documentElement.clientHeight;var i=this.getTopBoundary();var n=i-e>0;i=n?i:e;var s=n>0?t-i+e:t;var a=this.getLeftBoundaryOffset();var o=this.calculateRightBoundary();this.getOverlay().style.left=window.pageXOffset+"px";this.getOverlay().style.top=i+"px";this.getOverlay().style.right=o+"px";this.getOverlay().style.height=s+"px";this.getContainer().style.width="calc(100% - "+a+"px)";this.getContainer().style.height=s+"px";if(this.getWidth()!==null){this.getContainer().style.maxWidth=this.getWidth()+"px"}this.getLabel().adjustLayout()},createLayout:function(){if(this.layout.overlay!==null&&this.layout.overlay.parentNode){return}if(this.isSelfContained()){this.getContentContainer().style.overflow="auto";document.body.appendChild(this.getOverlay());this.setContent();BX.Event.EventEmitter.subscribe("BX.Main.Popup:onInit",this.handlePopupInit)}else{this.getContentContainer().appendChild(this.getFrame());document.body.appendChild(this.getOverlay());this.setFrameSrc()}BX.ZIndexManager.register(this.getOverlay())},getFrame:function(){if(this.iframe!==null){return this.iframe}this.iframe=BX.create("iframe",{attrs:{referrerpolicy:this.allowCrossOrigin?"strict-origin":false,src:"about:blank",frameborder:"0"},props:{className:"side-panel-iframe",name:this.getFrameId(),id:this.getFrameId()},events:{load:this.handleFrameLoad.bind(this)}});return this.iframe},getOverlay:function(){if(this.layout.overlay!==null){return this.layout.overlay}this.layout.overlay=BX.create("div",{props:{className:"side-panel side-panel-overlay"},events:{mousedown:this.handleOverlayClick.bind(this)},children:[this.getContainer()]});return this.layout.overlay},unhideOverlay:function(){this.getOverlay().classList.remove("side-panel-overlay-hidden")},hideOverlay:function(){this.getOverlay().classList.add("side-panel-overlay-hidden")},hideShadow:function(){this.getContainer().classList.remove("side-panel-show-shadow")},showShadow:function(){this.getContainer().classList.add("side-panel-show-shadow")},setOverlayAnimation:function(e){if(BX.type.isBoolean(e)){this.overlayAnimation=e}},getOverlayAnimation:function(){return this.overlayAnimation},getContainer:function(){if(this.layout.container!==null){return this.layout.container}this.layout.container=BX.create("div",{props:{className:"side-panel side-panel-container"},children:this.hideControls?[this.getContentContainer()]:[this.getContentContainer(),this.getLabelsContainer(),this.getPrintBtn()]});return this.layout.container},getContentContainer:function(){if(this.layout.content!==null){return this.layout.content}this.layout.content=BX.create("div",{props:{className:"side-panel-content-container"+(this.contentClassName!==null?" "+this.contentClassName:"")}});return this.layout.content},getLabelsContainer:function(){return this.cache.remember("labels-container",function(){return BX.create("div",{props:{className:"side-panel-labels"},children:[this.getLabel().getContainer(),this.getExtraLabelsContainer()]})}.bind(this))},getExtraLabelsContainer:function(){return this.cache.remember("icon-labels",function(){return BX.create("div",{props:{className:"side-panel-extra-labels"},children:[this.minimizeLabel?this.minimizeLabel.getContainer():null,this.newWindowLabel?this.newWindowLabel.getContainer():null,this.copyLinkLabel?this.copyLinkLabel.getContainer():null]})}.bind(this))},getCloseBtn:function(){return this.getLabel().getIconBox()},getLabel:function(){return this.label},getNewWindowLabel:function(){return this.newWindowLabel},getCopyLinkLabel:function(){return this.copyLinkLabel},getMinimizeLabel:function(){return this.minimizeLabel},getPrintBtn:function(){if(this.layout.printBtn!==null){return this.layout.printBtn}this.layout.printBtn=BX.create("span",{props:{className:"side-panel-print",title:BX.message("MAIN_SIDEPANEL_PRINT")},events:{click:this.handlePrintBtnClick.bind(this)}});return this.layout.printBtn},setContent:function(){if(this.contentCallbackInvoved){return}this.contentCallbackInvoved=true;BX.cleanNode(this.getContentContainer());var e=this.contentCallback(this);var t=e&&(Object.prototype.toString.call(e)==="[object Promise]"||e.toString()==="[object BX.Promise]");if(!t){e=Promise.resolve(e)}e.then(function(e){if(this.isDestroyed()){return}if(BX.type.isPlainObject(e)&&BX.type.isNotEmptyString(e.html)){BX.html(this.getContentContainer(),e.html).then(function(){this.removeLoader();this.loaded=true;this.firePageEvent("onLoad")}.bind(this),function(e){this.removeLoader();this.getContentContainer().innerHTML=e}.bind(this))}else{if(BX.type.isDomNode(e)){this.getContentContainer().appendChild(e)}else if(BX.type.isNotEmptyString(e)){this.getContentContainer().innerHTML=e}this.removeLoader();this.loaded=true;this.firePageEvent("onLoad")}}.bind(this),function(e){this.removeLoader();this.getContentContainer().innerHTML=e}.bind(this))},setFrameSrc:function(){if(this.iframeSrc===this.getUrl()){return}var e=BX.util.add_url_param(this.getUrl(),{IFRAME:"Y",IFRAME_TYPE:"SIDE_SLIDER"});if(this.isPostMethod()){var t=document.createElement("form");t.method="POST";t.action=e;t.target=this.getFrameId();t.style.display="none";BX.util.addObjectToForm(this.getRequestParams(),t);document.body.appendChild(t);t.submit();BX.remove(t)}else{this.iframeSrc=this.getUrl();this.iframe.src=e}this.loaded=false;this.listenIframeLoading()},createLoader:function(e){BX.remove(this.layout.loader);e=BX.type.isNotEmptyString(e)||BX.type.isElementNode(e)?e:"default-loader";var t=["task-new-loader","task-edit-loader","task-view-loader","crm-entity-details-loader","crm-button-view-loader","crm-webform-view-loader","create-mail-loader","view-mail-loader"];var i=null;if(BX.type.isElementNode(e)){this.layout.loader=this.createHTMLLoader(e)}else if(BX.util.in_array(e,t)&&this.loaderExists(e)){this.layout.loader=this.createOldLoader(e)}else if(e.charAt(0)==="/"){this.layout.loader=this.createSvgLoader(e)}else if(i=e.match(/^([a-z0-9-_.]+):([a-z0-9-_.]+)$/i)){var n=i[1];var s=i[2];var a="/bitrix/images/"+n+"/slider/"+s+".svg";this.layout.loader=this.createSvgLoader(a)}else{e="default-loader";this.layout.loader=this.createDefaultLoader()}this.getContainer().appendChild(this.layout.loader)},createSvgLoader:function(e){return BX.create("div",{props:{className:"side-panel-loader"},children:[BX.create("div",{props:{className:"side-panel-loader-container"},style:{backgroundImage:'url("'+e+'")'}})]})},createDefaultLoader:function(){return BX.create("div",{props:{className:"side-panel-loader"},children:[BX.create("div",{props:{className:"side-panel-default-loader-container"},html:'<svg class="side-panel-default-loader-circular" viewBox="25 25 50 50">'+"<circle "+'class="side-panel-default-loader-path" '+'cx="50" cy="50" r="20" fill="none" stroke-miterlimit="10"'+"/>"+"</svg>"})]})},createOldLoader:function(e){if(e==="crm-entity-details-loader"){return BX.create("div",{props:{className:"side-panel-loader "+e},children:[BX.create("img",{attrs:{src:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAMAAABhq6zVAAAAA1BMVEX"+"///+nxBvIAAAAAXRSTlMAQObYZgAAAAtJREFUeAFjGMQAAACcAAG25ruvAAAAAElFTkSuQmCC"},props:{className:"side-panel-loader-mask top"}}),BX.create("div",{props:{className:"side-panel-loader-bg left"},children:[BX.create("img",{attrs:{src:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAMAAABhq6zVAAAAA1B"+"MVEX///+nxBvIAAAAAXRSTlMAQObYZgAAAAtJREFUeAFjGMQAAACcAAG25ruvAAAAAElFTkSuQmCC"},props:{className:"side-panel-loader-mask left"}})]}),BX.create("div",{props:{className:"side-panel-loader-bg right"},children:[BX.create("img",{attrs:{src:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAMAAABhq6zVAAAAA1BM"+"VEX///+nxBvIAAAAAXRSTlMAQObYZgAAAAtJREFUeAFjGMQAAACcAAG25ruvAAAAAElFTkSuQmCC"},props:{className:"side-panel-loader-mask right"}})]})]})}else{return BX.create("div",{props:{className:"side-panel-loader "+e},children:[BX.create("img",{attrs:{src:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAMAAABhq6zVAAAAA1BMVEX"+"///+nxBvIAAAAAXRSTlMAQObYZgAAAAtJREFUeAFjGMQAAACcAAG25ruvAAAAAElFTkSuQmCC"},props:{className:"side-panel-loader-mask left"}}),BX.create("img",{attrs:{src:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAMAAABhq6zVAAAAA"+"1BMVEX///+nxBvIAAAAAXRSTlMAQObYZgAAAAtJREFUeAFjGMQAAACcAAG25ruvAAAAAElFTkSuQmCC"},props:{className:"side-panel-loader-mask right"}})]})}},createHTMLLoader:function(e){return BX.create("div",{children:[e]})},loaderExists:function(e){if(!BX.type.isNotEmptyString(e)){return false}for(var t=0;t<document.styleSheets.length;t++){var i=document.styleSheets[t];if(!BX.type.isNotEmptyString(i.href)||i.href.indexOf("sidepanel")===-1){continue}var n;try{n=i.rules||i.cssRules}catch(e){try{n=i.cssRules}catch(e){n=[]}}for(var s=0;s<n.length;s++){var a=n[s];if(BX.type.isNotEmptyString(a.selectorText)&&a.selectorText.indexOf(e)!==-1){return true}}}return false},removeLoader:function(){BX.remove(this.layout.loader);this.layout.loader=null},animateOpening:function(){if(this.isPrintable()){this.showPrintBtn()}if(this.animation){this.animation.stop()}this.fireEvent("onOpening");if(BX.browser.IsMobile()){this.currentParams=this.endParams;this.animateStep(this.currentParams);this.completeAnimation();return}this.currentParams=this.currentParams?this.currentParams:this.startParams;this.animation=new BX.easing({duration:this.animationDuration,start:this.currentParams,finish:this.endParams,transition:BX.easing.transitions.linear,step:BX.delegate((function(e){this.currentParams=e;this.animateStep(e)}),this),complete:BX.delegate((function(){this.completeAnimation()}),this)});if(this.animationName==="scale"&&BX.Type.isStringFilled(this.animationOptions.origin)){this.getContainer().style.transformOrigin=this.animationOptions.origin}this.animation.animate()},animateStep:function(e){if(this.animationName==="scale"){this.getContainer().style.transform="scale("+e.scale/100+")"}else{this.getContainer().style.transform="translateX("+e.translateX+"%)"}if(this.getOverlayAnimation()){this.getOverlay().style.backgroundColor="rgba(0, 0, 0, "+e.opacity/100+")"}},completeAnimation:function(e){this.animation=null;if(this.isOpen()){this.currentParams=this.endParams;this.maximizing=false;BX.removeClass(this.getOverlay(),"side-panel-overlay-opening");if(this.animationName==="scale"){this.getContainer().style.removeProperty("transform-origin");this.getContainer().style.transform="translateX(0%)"}this.firePageEvent("onBeforeOpenComplete");this.fireFrameEvent("onBeforeOpenComplete");this.firePageEvent("onOpenComplete");this.fireFrameEvent("onOpenComplete");if(!this.isLoaded()){this.showLoader()}if(this.isFocusable()){this.focus()}}else{this.currentParams=this.startParams;this.minimizing=false;BX.removeClass(this.getOverlay(),"side-panel-overlay-open side-panel-overlay-opening");if(this.animationName==="scale"){this.getContainer().style.removeProperty("transform-origin");this.getContainer().style.transform="translateX(100%)"}this.getContainer().style.removeProperty("width");this.getContainer().style.removeProperty("right");this.getContainer().style.removeProperty("opacity");this.getContainer().style.removeProperty("max-width");this.getContainer().style.removeProperty("min-width");this.getCloseBtn().style.removeProperty("opacity");this.firePageEvent("onBeforeCloseComplete");this.fireFrameEvent("onBeforeCloseComplete");this.firePageEvent("onCloseComplete");this.fireFrameEvent("onCloseComplete");if(BX.type.isFunction(e)){e(this)}if(!this.isCacheable()){this.destroy()}}},firePageEvent:function(e){var t=this.getEvent(e);if(t===null){throw new Error("'eventName' is invalid.")}BX.onCustomEvent(this,t.getFullName(),[t]);if(BX.util.in_array(e,["onClose","onOpen"])){BX.onCustomEvent("BX.Bitrix24.PageSlider:"+e,[this]);BX.onCustomEvent("Bitrix24.Slider:"+e,[this])}return t},fireFrameEvent:function(e){var t=this.getEvent(e);if(t===null){throw new Error("'eventName' is invalid.")}if(this.allowCrossOrigin){return null}var i=this.getFrameWindow();if(i&&i.BX&&i.BX.onCustomEvent){i.BX.onCustomEvent(this,t.getFullName(),[t]);if(BX.util.in_array(e,["onClose","onOpen"])){i.BX.onCustomEvent("BX.Bitrix24.PageSlider:"+e,[this]);i.BX.onCustomEvent("Bitrix24.Slider:"+e,[this])}}return t},fireEvent:function(e){this.firePageEvent(e);this.fireFrameEvent(e)},getEvent:function(e){var t=null;if(BX.type.isNotEmptyString(e)){t=new BX.SidePanel.Event;t.setSlider(this);t.setName(e)}else if(e instanceof BX.SidePanel.Event){t=e}return t},canOpen:function(){return this.canAction("open")},canClose:function(){return this.canAction("close")},canCloseByEsc:function(){return this.canAction("closeByEsc")},canAction:function(e){if(!BX.type.isNotEmptyString(e)){return false}var t="on"+e.charAt(0).toUpperCase()+e.slice(1);var i=this.firePageEvent(t);var n=this.fireFrameEvent(t);return i.isActionAllowed()&&(!n||n.isActionAllowed())},handleCrossOriginWindowMessage:function(e){const t=new URL(this.url);const i=new URL(e.origin);if(i.origin!==t.origin){return}let n={type:"",data:undefined};if(BX.Type.isString(e.data)){n.type=e.data}else if(BX.Type.isPlainObject(e.data)){n.type=e.data.type;n.data=e.data.data}if(n.type==="BX:SidePanel:close"){this.close()}else if(n.type==="BX:SidePanel:load:force"){if(!this.isLoaded()&&!this.isDestroyed()){this.handleFrameLoad()}}else if(n.type==="BX:SidePanel:data:send"){let e=new BX.SidePanel.MessageEvent({sender:this,data:n.data});e.setName("onXDomainMessage");this.firePageEvent(e)}},handleFrameLoad:function(e){if(this.loaded){return}var t=this.iframe.contentWindow;var i=t.location;if(this.allowCrossOrigin){window.addEventListener("message",this.handleCrossOriginWindowMessage)}try{if(i.toString()==="about:blank"){return}}catch(e){if(this.allowCrossOrigin){this.loaded=true;this.closeLoader();return}else{console.warn('SidePanel: Try to use "allowCrossOrigin: true" option.');throw e}}t.addEventListener("keydown",this.handleFrameKeyDown);t.addEventListener("focus",this.handleFrameFocus);t.addEventListener("unload",this.handleFrameUnload);if(BX.browser.IsMobile()){t.document.body.style.paddingBottom=window.innerHeight*2/3+"px"}var n=i.pathname+i.search+i.hash;this.iframeSrc=this.refineUrl(n);this.url=this.iframeSrc;if(this.isPrintable()){this.injectPrintStyles()}this.loaded=true;this.loadedCnt++;if(this.loadedCnt>1){this.firePageEvent("onLoad");this.fireFrameEvent("onLoad");this.firePageEvent("onReload");this.fireFrameEvent("onReload")}else{this.firePageEvent("onLoad");this.fireFrameEvent("onLoad")}if(this.isFocusable()){this.focus()}this.closeLoader()},listenIframeLoading:function(){if(this.allowCrossOrigin){return}const e=setInterval((()=>{if(this.isLoaded()||this.isDestroyed()){clearInterval(e);return}if(this.iframe.contentWindow.location.toString()==="about:blank"){return}if(this.iframe.contentWindow.document.readyState==="complete"||this.iframe.contentWindow.document.readyState==="interactive"){clearInterval(e);this.handleFrameLoad()}}),200)},handleFrameUnload:function(e){this.loaded=false;this.listenIframeLoading()},handleFrameKeyDown:function(e){if(e.keyCode!==27){return}var t=BX.findChildren(this.getWindow().document.body,{className:"popup-window"},false);for(var i=0;i<t.length;i++){var n=t[i];if(n.style.display==="block"){return}}var s=this.getWindow().document.documentElement.clientWidth/2;var a=this.getWindow().document.documentElement.clientHeight/2;var o=this.getWindow().document.elementFromPoint(s,a);if(BX.hasClass(o,"bx-core-dialog-overlay")||BX.hasClass(o,"bx-core-window")){return}if(BX.findParent(o,{className:"bx-core-window"})){return}this.firePageEvent("onEscapePress");this.fireFrameEvent("onEscapePress")},handlePopupInit:function(e){var t=e.getCompatData();var i=t[1];var n=t[2];if(!BX.Type.isElementNode(n.targetContainer)&&BX.Type.isElementNode(i)){if(this.getContentContainer().contains(i)){n.targetContainer=this.getContentContainer()}}},handleFrameFocus:function(e){this.firePageEvent("onFrameFocus")},handleOverlayClick:function(e){if(e.target!==this.getOverlay()||this.animation!==null){return}this.close();e.stopPropagation()},handlePrintBtnClick:function(e){if(this.isSelfContained()){var t=document.createElement("iframe");t.src="about:blank";t.name="sidepanel-print-frame";t.style.display="none";document.body.appendChild(t);var i=t.contentWindow;var n=i.document;n.open();n.write("<html><head>");var s="";var a=document.head.querySelectorAll("link, style");for(var o=0;o<a.length;o++){var r=a[o];s+=r.outerHTML}s+="<style>html, body { background: #fff !important; height: 100%; }</style>";n.write(s);n.write("</head><body>");n.write(this.getContentContainer().innerHTML);n.write("</body></html>");n.close();i.focus();i.print();setTimeout((function(){document.body.removeChild(t);window.focus()}),1e3)}else{this.focus();this.getFrameWindow().print()}},injectPrintStyles:function(){var e=this.getFrameWindow().document;var t="";var i=e.body.classList;for(var n=0;n<i.length;n++){var s=i[n];t+="."+s}var a="@media print { body"+t+" { "+"background: #fff !important; "+"-webkit-print-color-adjust: exact;"+"color-adjust: exact; "+"} }";var o=e.createElement("style");o.type="text/css";if(o.styleSheet){o.styleSheet.cssText=a}else{o.appendChild(e.createTextNode(a))}e.head.appendChild(o)},refineUrl:function(e){if(BX.type.isNotEmptyString(e)&&e.match(/IFRAME/)){return BX.util.remove_url_param(e,["IFRAME","IFRAME_TYPE"])}return e}};BX.SidePanel.Event=function(){this.slider=null;this.action=true;this.name=null};BX.SidePanel.Event.prototype={allowAction:function(){this.action=true},denyAction:function(){this.action=false},isActionAllowed:function(){return this.action},getSliderPage:function(){return this.slider},getSlider:function(){return this.slider},setSlider:function(e){if(e instanceof BX.SidePanel.Slider){this.slider=e}},getName:function(){return this.name},setName:function(e){if(BX.type.isNotEmptyString(e)){this.name=e}},getFullName:function(){return BX.SidePanel.Slider.getEventFullName(this.getName())}};BX.SidePanel.MessageEvent=function(e){BX.SidePanel.Event.apply(this);e=BX.type.isPlainObject(e)?e:{};if(!(e.sender instanceof BX.SidePanel.Slider)){throw new Error("'sender' is not an instance of BX.SidePanel.Slider")}this.setName("onMessage");this.setSlider(e.slider);this.sender=e.sender;this.data="data"in e?e.data:null;this.eventId=BX.type.isNotEmptyString(e.eventId)?e.eventId:null};BX.SidePanel.MessageEvent.prototype={__proto__:BX.SidePanel.Event.prototype,constructor:BX.SidePanel.MessageEvent,getSlider:function(){return this.slider},getSender:function(){return this.sender},getData:function(){return this.data},getEventId:function(){return this.eventId}};BX.SidePanel.Dictionary=function(e){if(e&&!BX.type.isPlainObject(e)){throw new Error("The argument must be a plain object.")}this.data=e?e:{}};BX.SidePanel.Dictionary.prototype={set:function(e,t){if(!BX.type.isNotEmptyString(e)){throw new Error("The 'key' must be a string.")}this.data[e]=t},get:function(e){return this.data[e]},delete:function(e){delete this.data[e]},has:function(e){return e in this.data},clear:function(){this.data={}},entries:function(){return this.data}};BX.SidePanel.Label=function(e,t){this.slider=e;this.color=null;this.bgColor=null;this.iconClass="";this.iconTitle="";this.onclick=null;this.text=null;this.cache=new BX.Cache.MemoryCache;var i=BX.Type.isPlainObject(t)?t:{};this.setBgColor(i.bgColor);this.setColor(i.color);this.setText(i.text);this.setIconClass(i.iconClass);this.setIconTitle(i.iconTitle);this.setOnclick(i.onclick)};BX.SidePanel.Label.MIN_LEFT_OFFSET=25;BX.SidePanel.Label.MIN_TOP_OFFSET=17;BX.SidePanel.Label.INTERVAL_TOP_OFFSET=50;BX.SidePanel.Label.prototype={getContainer:function(){return this.cache.remember("container",function(){return BX.create("div",{props:{className:"side-panel-label"},children:[this.getIconBox(),this.getTextContainer()],events:{click:this.handleClick.bind(this)}})}.bind(this))},adjustLayout:function(){var e=this.getSlider().getOverlay().offsetWidth-this.getSlider().getContainer().offsetWidth;if(e<=this.getSlider().getMinLeftBoundary()){this.hideText()}else{this.showText()}this.getContainer().style.maxWidth=e-BX.SidePanel.Label.MIN_LEFT_OFFSET+"px"},getIconBox:function(){return this.cache.remember("icon-box",function(){return BX.create("div",{props:{className:"side-panel-label-icon-box"},children:[this.getIconContainer()]})}.bind(this))},getIconContainer:function(){return this.cache.remember("icon-container",function(){return BX.create("div",{props:{className:"side-panel-label-icon "+this.getIconClass()}})}.bind(this))},handleClick:function(e){e.stopPropagation();var t=this.getOnclick();if(t){t(this,this.getSlider())}},showIcon:function(){this.getContainer().classList.remove("side-panel-label-icon--hide")},hideIcon:function(){this.getContainer().classList.add("side-panel-label-icon--hide")},darkenIcon:function(){this.getContainer().classList.add("side-panel-label-icon--darken")},lightenIcon:function(){this.getContainer().classList.remove("side-panel-label-icon--darken")},hideText:function(){this.getTextContainer().classList.add("side-panel-label-text-hidden")},showText:function(){this.getTextContainer().classList.remove("side-panel-label-text-hidden")},isTextHidden:function(){return this.getTextContainer().classList.contains("side-panel-label-text-hidden")},getTextContainer:function(){return this.cache.remember("text-container",function(){return BX.create("span",{props:{className:"side-panel-label-text"}})}.bind(this))},setColor:function(e){if(BX.type.isNotEmptyString(e)){this.color=e;this.getTextContainer().style.color=e}},getColor:function(){return this.color},setBgColor:function(e,t){if(BX.Type.isArray(e)){t=e[1];e=e[0]}if(BX.type.isNotEmptyString(e)){var i=e.match(/^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/);if(i){var n=i[1];if(n.length===3){n=n.replace(/([a-f0-9])/gi,"$1$1")}t=BX.type.isNumber(t)&&t>=0&&t<=100?t:95;var s=BX.util.hex2rgb(n);e="rgba("+s.r+","+s.g+","+s.b+","+t/100+")"}this.bgColor=e;this.getContainer().style.backgroundColor=e}else if(e===null){this.bgColor=e;this.getContainer().style.removeProperty("backgroundColor")}},getBgColor:function(){return this.bgColor},setText:function(e){if(BX.type.isNotEmptyString(e)){this.text=e;this.getTextContainer().textContent=e}else if(e===null){this.text=e;this.getTextContainer().textContent=""}},getText:function(){return this.text},setIconClass:function(e){if(BX.Type.isStringFilled(e)){BX.Dom.removeClass(this.getIconContainer(),this.iconClass);this.iconClass=e;BX.Dom.addClass(this.getIconContainer(),this.iconClass)}else if(e===null){BX.Dom.removeClass(this.getIconContainer(),this.iconClass);this.iconClass=e}},getIconClass:function(){return this.iconClass},setIconTitle:function(e){if(BX.Type.isStringFilled(e)||e===null){BX.Dom.attr(this.getIconBox(),"title",e);this.iconTitle=e}},getIconTitle:function(){return this.iconTitle},setOnclick:function(e){if(BX.Type.isFunction(e)||e===null){this.onclick=e}},getOnclick:function(){return this.onclick},getSlider:function(){return this.slider},moveAt:function(e){if(BX.type.isNumber(e)&&e>=0){this.getSlider().getLabelsContainer().style.top=BX.SidePanel.Label.MIN_TOP_OFFSET+e*BX.SidePanel.Label.INTERVAL_TOP_OFFSET+"px"}}}})();
//# sourceMappingURL=slider.map.js