(function(){"use strict";BX.namespace("BX.SidePanel");var e=null;Object.defineProperty(BX.SidePanel,"Instance",{enumerable:false,get:function(){var t=BX.PageObject.getRootWindow();if(t!==window){return t.BX.SidePanel.Instance}if(e===null){e=new BX.SidePanel.Manager({})}return e}});BX.SidePanel.Manager=function(e){this.anchorRules=[];this.anchorBinding=true;this.openSliders=[];this.lastOpenSlider=null;this.opened=false;this.hidden=false;this.hacksApplied=false;this.pageUrl=this.getCurrentUrl();this.pageTitle=this.getCurrentTitle();this.titleChanged=false;this.toolbar=null;this.fullScreenSlider=null;this.handleAnchorClick=this.handleAnchorClick.bind(this);this.handleDocumentKeyDown=this.handleDocumentKeyDown.bind(this);this.handleWindowResize=BX.throttle(this.handleWindowResize,300,this);this.handleWindowScroll=this.handleWindowScroll.bind(this);this.handleTouchMove=this.handleTouchMove.bind(this);this.handleSliderOpenStart=this.handleSliderOpenStart.bind(this);this.handleSliderOpenComplete=this.handleSliderOpenComplete.bind(this);this.handleSliderMaximizeStart=this.handleSliderMaximizeStart.bind(this);this.handleSliderCloseStart=this.handleSliderCloseStart.bind(this);this.handleSliderCloseComplete=this.handleSliderCloseComplete.bind(this);this.handleSliderMinimizeStart=this.handleSliderMinimizeStart.bind(this);this.handleSliderLoad=this.handleSliderLoad.bind(this);this.handleSliderDestroy=this.handleSliderDestroy.bind(this);this.handleEscapePress=this.handleEscapePress.bind(this);this.handleFullScreenChange=this.handleFullScreenChange.bind(this);BX.addCustomEvent("SidePanel:open",this.open.bind(this));BX.addCustomEvent("SidePanel:close",this.close.bind(this));BX.addCustomEvent("SidePanel:closeAll",this.closeAll.bind(this));BX.addCustomEvent("SidePanel:destroy",this.destroy.bind(this));BX.addCustomEvent("SidePanel:hide",this.hide.bind(this));BX.addCustomEvent("SidePanel:unhide",this.unhide.bind(this));BX.addCustomEvent("SidePanel:postMessage",this.postMessage.bind(this));BX.addCustomEvent("SidePanel:postMessageAll",this.postMessageAll.bind(this));BX.addCustomEvent("SidePanel:postMessageTop",this.postMessageTop.bind(this));BX.addCustomEvent("BX.Bitrix24.PageSlider:close",this.close.bind(this));BX.addCustomEvent("Bitrix24.Slider:postMessage",this.handlePostMessageCompatible.bind(this))};var t=null;BX.SidePanel.Manager.registerSliderClass=function(e){if(BX.type.isNotEmptyString(e)){t=e}};BX.SidePanel.Manager.getSliderClass=function(){var e=t!==null?BX.getClass(t):null;return e!==null?e:BX.SidePanel.Slider};BX.SidePanel.Manager.prototype={open:function(e,t){const i=this.createSlider(e,t);if(i===null){return false}return this.tryApplyHacks(i,(()=>i.open()))},createSlider(e,t){if(!BX.type.isNotEmptyString(e)){return null}e=this.refineUrl(e);if(this.isHidden()){this.unhide()}const i=this.getTopSlider();if(i&&i.isOpen()&&i.getUrl()===e){return null}let n=null;if(this.getLastOpenSlider()&&this.getLastOpenSlider().getUrl()===e){n=this.getLastOpenSlider()}else{const o=this.getUrlRule(e);const a=o!==null&&BX.Type.isPlainObject(o.options)?o.options:{};if(BX.Type.isUndefined(t)){t=a}else if(BX.Type.isPlainObject(a.minimizeOptions)&&BX.Type.isPlainObject(t)&&!BX.Type.isPlainObject(t.minimizeOptions)){t.minimizeOptions=a.minimizeOptions}if(this.getToolbar()===null&&t.minimizeOptions){t.minimizeOptions=null}var s=BX.SidePanel.Manager.getSliderClass();n=new s(e,t);var r=null;if(n.getWidth()===null&&n.getCustomLeftBoundary()===null){r=0;var l=this.getLastOffset();if(i&&l!==null){r=Math.min(l+this.getMinOffset(),this.getMaxOffset())}}n.setOffset(r);if(i&&i.getCustomRightBoundary()!==null){const e=n.calculateRightBoundary();if(e>i.getCustomRightBoundary()){n.setCustomRightBoundary(i.getCustomRightBoundary())}}BX.addCustomEvent(n,"SidePanel.Slider:onOpenStart",this.handleSliderOpenStart);BX.addCustomEvent(n,"SidePanel.Slider:onBeforeOpenComplete",this.handleSliderOpenComplete);BX.addCustomEvent(n,"SidePanel.Slider:onMaximizeStart",this.handleSliderMaximizeStart);BX.addCustomEvent(n,"SidePanel.Slider:onCloseStart",this.handleSliderCloseStart);BX.addCustomEvent(n,"SidePanel.Slider:onBeforeCloseComplete",this.handleSliderCloseComplete);BX.addCustomEvent(n,"SidePanel.Slider:onMinimizeStart",this.handleSliderMinimizeStart);BX.addCustomEvent(n,"SidePanel.Slider:onLoad",this.handleSliderLoad);BX.addCustomEvent(n,"SidePanel.Slider:onDestroy",this.handleSliderDestroy);BX.addCustomEvent(n,"SidePanel.Slider:onEscapePress",this.handleEscapePress)}return n},getMinimizeOptions(e){const t=this.getUrlRule(e);const i=t!==null&&BX.Type.isPlainObject(t.options)?t.options:{};return BX.Type.isPlainObject(i.minimizeOptions)?i.minimizeOptions:null},maximize(e,t){const i=this.createSlider(e,t);if(i===null){return false}return this.tryApplyHacks(i,(()=>i.maximize()))},tryApplyHacks(e,t){if(!this.isOpen()){this.applyHacks(e)}const i=t();if(!i){this.resetHacks(e)}return i},isOpen:function(){return this.opened},close:function(e,t){var i=this.getTopSlider();if(i){i.close(e,t)}},closeAll:function(e){var t=this.getOpenSliders();for(var i=t.length-1;i>=0;i--){var n=t[i];var s=n.close(e);if(!s){break}}},minimize(e,t){const i=this.getTopSlider();if(i){i.minimize(e,t)}},hide:function(){if(this.hidden){return false}var e=this.getTopSlider();this.getOpenSliders().forEach((function(e){e.hide()}));this.hidden=true;this.resetHacks(e);return true},unhide:function(){if(!this.hidden){return false}this.getOpenSliders().forEach((function(e){e.unhide()}));this.hidden=false;setTimeout(function(){this.applyHacks(this.getTopSlider())}.bind(this),0);return true},isHidden:function(){return this.hidden},destroy:function(e){if(!BX.type.isNotEmptyString(e)){return}e=this.refineUrl(e);var t=this.getSlider(e);if(this.getLastOpenSlider()&&(t||this.getLastOpenSlider().getUrl()===e)){this.getLastOpenSlider().destroy()}if(t!==null){var i=this.getOpenSliders();for(var n=i.length-1;n>=0;n--){var s=i[n];s.destroy();if(s===t){break}}}},reload:function(){var e=this.getTopSlider();if(e){e.reload()}},getTopSlider:function(){var e=this.openSliders.length;return this.openSliders[e-1]?this.openSliders[e-1]:null},getPreviousSlider:function(e){var t=null;var i=this.getOpenSliders();e=e||this.getTopSlider();for(var n=i.length-1;n>=0;n--){var s=i[n];if(s===e){t=i[n-1]?i[n-1]:null;break}}return t},getSlider:function(e){e=this.refineUrl(e);var t=this.getOpenSliders();for(var i=0;i<t.length;i++){var n=t[i];if(n.getUrl()===e){return n}}return null},getSliderByWindow:function(e){var t=this.getOpenSliders();for(var i=0;i<t.length;i++){var n=t[i];if(n.getFrameWindow()===e){return n}}return null},getOpenSliders:function(){return this.openSliders},getOpenSlidersCount:function(){return this.openSliders.length},addOpenSlider:function(e){if(!(e instanceof BX.SidePanel.Slider)){throw new Error("Slider is not an instance of BX.SidePanel.Slider")}this.openSliders.push(e)},removeOpenSlider:function(e){var t=this.getOpenSliders();for(var i=0;i<t.length;i++){var n=t[i];if(n===e){this.openSliders.splice(i,1);return true}}return false},getLastOpenSlider:function(){return this.lastOpenSlider},setLastOpenSlider:function(e){if(this.lastOpenSlider!==e){if(this.lastOpenSlider){this.lastOpenSlider.destroy()}this.lastOpenSlider=e}},resetLastOpenSlider:function(){if(this.lastOpenSlider&&this.getTopSlider()!==this.lastOpenSlider){this.lastOpenSlider.destroy()}this.lastOpenSlider=null},adjustLayout:function(){this.getOpenSliders().forEach((function(e){e.adjustLayout()}))},createToolbar(e){if(this.toolbar===null){this.toolbar=new i(e)}return this.toolbar},getToolbar(){return this.toolbar},getLastOffset:function(){var e=this.getOpenSliders();for(var t=e.length-1;t>=0;t--){var i=e[t];if(i.getOffset()!==null){return i.getOffset()}}return null},refineUrl:function(e){if(BX.type.isNotEmptyString(e)&&e.match(/IFRAME/)){return BX.util.remove_url_param(e,["IFRAME","IFRAME_TYPE"])}return e},getPageUrl:function(){return this.pageUrl},getCurrentUrl:function(){return window.location.pathname+window.location.search+window.location.hash},getPageTitle:function(){return this.pageTitle},getCurrentTitle:function(){var e=document.title;if(typeof BXIM!=="undefined"){e=e.replace(/^\([0-9]+\) /,"")}return e},enterFullScreen:function(){if(!this.getTopSlider()||this.getFullScreenSlider()){return}var e=document.body;if(e.requestFullscreen){BX.bind(document,"fullscreenchange",this.handleFullScreenChange);e.requestFullscreen()}else if(e.webkitRequestFullScreen){BX.bind(document,"webkitfullscreenchange",this.handleFullScreenChange);e.webkitRequestFullScreen()}else if(e.msRequestFullscreen){BX.bind(document,"MSFullscreenChange",this.handleFullScreenChange);e.msRequestFullscreen()}else if(e.mozRequestFullScreen){BX.bind(document,"mozfullscreenchange",this.handleFullScreenChange);e.mozRequestFullScreen()}else{console.log("Slider: Full Screen mode is not supported.")}},exitFullScreen:function(){if(!this.getFullScreenSlider()){return}if(document.exitFullscreen){document.exitFullscreen()}else if(document.webkitExitFullscreen){document.webkitExitFullscreen()}else if(document.msExitFullscreen){document.msExitFullscreen()}else if(document.mozCancelFullScreen){document.mozCancelFullScreen()}},getFullScreenElement:function(){return document.fullscreenElement||document.webkitFullscreenElement||document.mozFullScreenElement||document.msFullscreenElement||null},getFullScreenSlider:function(){return this.fullScreenSlider},handleFullScreenChange:function(e){if(this.getFullScreenElement()){this.fullScreenSlider=this.getTopSlider();BX.addClass(this.fullScreenSlider.getOverlay(),"side-panel-fullscreen");this.fullScreenSlider.fireEvent("onFullScreenEnter")}else{if(this.getFullScreenSlider()){BX.removeClass(this.getFullScreenSlider().getOverlay(),"side-panel-fullscreen");this.fullScreenSlider.fireEvent("onFullScreenExit");this.fullScreenSlider=null}BX.unbind(document,e.type,this.handleFullScreenChange);window.scrollTo(0,this.pageScrollTop);setTimeout(function(){this.adjustLayout();var e=document.createEvent("Event");e.initEvent("resize",true,true);window.dispatchEvent(e)}.bind(this),1e3)}},postMessage:function(e,t,i){var n=this.getSliderFromSource(e);if(!n){return}var s=null;var r=this.getOpenSliders();for(var l=r.length-1;l>=0;l--){var o=r[l];if(o===n){s=r[l-1]?r[l-1]:null;break}}var a=s&&s.getWindow()||window;a.BX.onCustomEvent("Bitrix24.Slider:onMessage",[o,i]);var d=new BX.SidePanel.MessageEvent({sender:n,slider:s?s:null,data:i,eventId:t});if(s){s.firePageEvent(d);s.fireFrameEvent(d)}else{BX.onCustomEvent(window,d.getFullName(),[d])}},postMessageAll:function(e,t,i){var n=this.getSliderFromSource(e);if(!n){return}var s=null;var r=this.getOpenSliders();for(var l=r.length-1;l>=0;l--){var o=r[l];if(o===n){continue}s=new BX.SidePanel.MessageEvent({sender:n,slider:o,data:i,eventId:t});o.firePageEvent(s);o.fireFrameEvent(s)}s=new BX.SidePanel.MessageEvent({sender:n,slider:null,data:i,eventId:t});BX.onCustomEvent(window,s.getFullName(),[s])},postMessageTop:function(e,t,i){var n=this.getSliderFromSource(e);if(!n){return}var s=new BX.SidePanel.MessageEvent({sender:n,slider:null,data:i,eventId:t});BX.onCustomEvent(window,s.getFullName(),[s])},getMinOffset:function(){return 63},getMaxOffset:function(){return this.getMinOffset()*3},bindAnchors:function(e){e=e||{};if(BX.type.isArray(e.rules)&&e.rules.length){if(this.anchorRules.length===0){this.registerAnchorListener(window.document)}if(!(e.rules instanceof Object)){console.error("BX.SitePanel: anchor rules were created in a different context. "+"This might be a reason for a memory leak.");console.trace()}e.rules.forEach(function(e){if(BX.type.isArray(e.condition)){for(var t=0;t<e.condition.length;t++){if(BX.type.isString(e.condition[t])){e.condition[t]=new RegExp(e.condition[t],"i")}}}e.options=BX.type.isPlainObject(e.options)?e.options:{};if(BX.type.isNotEmptyString(e.loader)&&!BX.type.isNotEmptyString(e.options.loader)){e.options.loader=e.loader;delete e.loader}this.anchorRules.push(e)}.bind(this))}},isAnchorBinding:function(){return this.anchorBinding},enableAnchorBinding:function(){this.anchorBinding=true},disableAnchorBinding:function(){this.anchorBinding=false},registerAnchorListener:function(e){e.addEventListener("click",this.handleAnchorClick,true)},unregisterAnchorListener:function(e){e.removeEventListener("click",this.handleAnchorClick,true)},handleSliderOpenStart:function(e){if(!e.isActionAllowed()){return}var t=e.getSlider();if(t.isDestroyed()){return}if(this.getTopSlider()){this.exitFullScreen();this.getTopSlider().hideOverlay();var i=this.getTopSlider().getOffset()===t.getOffset()&&this.getTopSlider().getWidth()===t.getWidth()&&this.getTopSlider().getCustomLeftBoundary()===t.getCustomLeftBoundary();if(!i){this.getTopSlider().showShadow()}this.getTopSlider().hideOrDarkenCloseBtn();this.getTopSlider().hidePrintBtn();this.getTopSlider().hideExtraLabels()}else{t.setOverlayAnimation(true)}this.addOpenSlider(t);this.getOpenSliders().forEach((function(e,t,i){e.getLabel().moveAt(i.length-t-1)}),this);this.losePageFocus();if(!this.opened){this.pageUrl=this.getCurrentUrl();this.pageTitle=this.getCurrentTitle()}this.opened=true;this.resetLastOpenSlider()},handleSliderOpenComplete:function(e){this.setBrowserHistory(e.getSlider());this.updateBrowserTitle();e.getSlider().setAnimation("sliding")},handleSliderCloseStart:function(e){if(!e.isActionAllowed()){return}if(e.getSlider()&&e.getSlider().isDestroyed()){return}var t=this.getPreviousSlider();var i=this.getTopSlider();this.exitFullScreen();this.getOpenSliders().forEach((function(e,t,i){e.getLabel().moveAt(i.length-t-2)}),this);if(t){t.unhideOverlay();t.hideShadow();t.showOrLightenCloseBtn();if(i){i.hideOverlay();i.hideShadow()}}},handleSliderMaximizeStart:function(e){if(!e.isActionAllowed()||this.getToolbar()===null){return}const t=e.getSlider();if(t&&t.isDestroyed()){return}const{entityType:i,entityId:n}=t.getMinimizeOptions()||{};const s=this.getToolbar().getItem(i,n);this.getToolbar().request("maximize",s);const r=this.getItemOrigin(t,s);t.setAnimation("scale",{origin:r})},handleSliderMinimizeStart:function(e){if(!e.isActionAllowed()||this.getToolbar()===null){return}const t=e.getSlider();if(t&&t.isDestroyed()){return}if(!this.getToolbar().isShown()){this.getToolbar().show()}let i=t.getTitle();if(!i){i=t.getFrameWindow()?t.getFrameWindow().document.title:null}this.getToolbar().expand(true);const n=this.getMinimizeOptions(t.getUrl());const{entityType:s,entityId:r,url:l}=n||t.getMinimizeOptions()||{};const o=this.getToolbar().minimizeItem({title:i,url:BX.Type.isStringFilled(l)?l:t.getUrl(),entityType:s,entityId:r});const a=this.getItemOrigin(t,o);t.setAnimation("scale",{origin:a})},getItemOrigin(e,t){if(t&&t.getContainer().offsetWidth>0){const i=t.getContainer().getBoundingClientRect();const n=e.getContainer().getBoundingClientRect().left;const s=i.left-n+i.width/2;return`${s}px ${i.top}px`}return"50% 100%"},handleSliderCloseComplete:function(e){var t=e.getSlider();if(t===this.getTopSlider()){this.setLastOpenSlider(t)}e.getSlider().setAnimation("sliding");this.cleanUpClosedSlider(t)},handleSliderDestroy:function(e){var t=e.getSlider();BX.removeCustomEvent(t,"SidePanel.Slider:onOpenStart",this.handleSliderOpenStart);BX.removeCustomEvent(t,"SidePanel.Slider:onBeforeOpenComplete",this.handleSliderOpenComplete);BX.removeCustomEvent(t,"SidePanel.Slider:onMaximizeStart",this.handleSliderMaximizeStart);BX.removeCustomEvent(t,"SidePanel.Slider:onCloseStart",this.handleSliderCloseStart);BX.removeCustomEvent(t,"SidePanel.Slider:onBeforeCloseComplete",this.handleSliderCloseComplete);BX.removeCustomEvent(t,"SidePanel.Slider:onMinimizeStart",this.handleSliderMinimizeStart);BX.removeCustomEvent(t,"SidePanel.Slider:onLoad",this.handleSliderLoad);BX.removeCustomEvent(t,"SidePanel.Slider:onDestroy",this.handleSliderDestroy);BX.removeCustomEvent(t,"SidePanel.Slider:onEscapePress",this.handleEscapePress);var i=e.getSlider().getFrameWindow();if(i&&!e.getSlider().allowCrossOrigin){this.unregisterAnchorListener(i.document)}if(t===this.getLastOpenSlider()){this.lastOpenSlider=null}this.cleanUpClosedSlider(t)},handleEscapePress:function(e){if(this.isOnTop()&&this.getTopSlider()){if(this.getTopSlider().canCloseByEsc()){this.getTopSlider().close()}}},cleanUpClosedSlider:function(e){this.removeOpenSlider(e);e.unhideOverlay();e.hideShadow();this.getOpenSliders().forEach((function(e,t,i){e.getLabel().moveAt(i.length-t-1)}),this);if(this.getTopSlider()){this.getTopSlider().showOrLightenCloseBtn();this.getTopSlider().unhideOverlay();this.getTopSlider().hideShadow();this.getTopSlider().showExtraLabels();if(this.getTopSlider().isPrintable()){this.getTopSlider().showPrintBtn()}this.getTopSlider().focus()}else{window.focus()}if(!this.getOpenSlidersCount()){this.resetHacks(e);this.opened=false}this.resetBrowserHistory();this.updateBrowserTitle()},handleSliderLoad:function(e){var t=e.getSlider().getFrameWindow();if(t){this.registerAnchorListener(t.document)}this.setBrowserHistory(e.getSlider());this.updateBrowserTitle()},handlePostMessageCompatible:function(e,t){this.postMessage(e,"",t)},getSliderFromSource:function(e){if(e instanceof BX.SidePanel.Slider){return e}else if(BX.type.isNotEmptyString(e)){return this.getSlider(e)}else if(e!==null&&e===e.window&&window!==e){return this.getSliderByWindow(e)}return null},applyHacks:function(e){if(this.hacksApplied){return false}e&&e.applyHacks();this.disablePageScrollbar();this.bindEvents();e&&e.applyPostHacks();this.hacksApplied=true;return true},resetHacks:function(e){if(!this.hacksApplied){return false}e&&e.resetPostHacks();this.enablePageScrollbar();this.unbindEvents();e&&e.resetHacks();this.hacksApplied=false;return true},bindEvents:function(){BX.bind(document,"keydown",this.handleDocumentKeyDown);BX.bind(window,"resize",this.handleWindowResize);BX.bind(window,"scroll",this.handleWindowScroll);if(BX.browser.IsMobile()){BX.bind(document.body,"touchmove",this.handleTouchMove)}},unbindEvents:function(){BX.unbind(document,"keydown",this.handleDocumentKeyDown);BX.unbind(window,"resize",this.handleWindowResize);BX.unbind(window,"scroll",this.handleWindowScroll);if(BX.browser.IsMobile()){BX.unbind(document.body,"touchmove",this.handleTouchMove)}},disablePageScrollbar:function(){var e=window.innerWidth-document.documentElement.clientWidth;document.body.style.paddingRight=e+"px";BX.Dom.style(document.body,"--scroll-shift-width",`${e}px`);BX.addClass(document.body,"side-panel-disable-scrollbar");this.pageScrollTop=window.pageYOffset||document.documentElement.scrollTop},enablePageScrollbar:function(){document.body.style.removeProperty("padding-right");BX.Dom.style(document.body,"--scroll-shift-width",null);BX.removeClass(document.body,"side-panel-disable-scrollbar")},losePageFocus:function(){if(BX.type.isDomNode(document.activeElement)){document.activeElement.blur()}},handleDocumentKeyDown:function(e){if(e.keyCode!==27){return}e.preventDefault();if(this.isOnTop()&&this.getTopSlider()){if(this.getTopSlider().canCloseByEsc()){this.getTopSlider().close()}}},handleWindowResize:function(){this.adjustLayout()},handleWindowScroll:function(){window.scrollTo(0,this.pageScrollTop);this.adjustLayout()},handleTouchMove:function(e){e.preventDefault()},isOnTop:function(){var e=document.documentElement.clientWidth/2;var t=document.documentElement.clientHeight/2;var i=document.elementFromPoint(e,t);return BX.hasClass(i,"side-panel")||BX.findParent(i,{className:"side-panel"})!==null},extractLinkFromEvent:function(e){e=e||window.event;var t=e.target;if(e.which!==1||!BX.type.isDomNode(t)||e.ctrlKey||e.metaKey){return null}var i=t;if(t.nodeName!=="A"){i=BX.findParent(t,{tag:"A"},1)}if(!BX.type.isDomNode(i)){return null}var n=i.getAttribute("href");if(n){return{url:n,anchor:i,target:i.getAttribute("target")}}return null},handleAnchorClick:function(e){if(!this.isAnchorBinding()){return}var t=this.extractLinkFromEvent(e);if(!t||BX.data(t.anchor,"slider-ignore-autobinding")){return}if(BX.data(e.target,"slider-ignore-autobinding")){return}var i=this.getUrlRule(t.url,t);if(!this.isValidLink(i,t)){return}if(BX.type.isFunction(i.handler)){i.handler(e,t)}else{e.preventDefault();this.open(t.url,i.options)}},emulateAnchorClick:function(e){var t={url:e,anchor:null,target:null};var i=this.getUrlRule(e,t);if(!this.isValidLink(i,t)){BX.reload(e)}else if(BX.type.isFunction(i.handler)){i.handler(new Event("slider",{bubbles:false,cancelable:true}),t)}else{this.open(t.url,i.options)}},getUrlRule:function(e,t){if(!BX.type.isNotEmptyString(e)){return null}if(!BX.Type.isPlainObject(t)){const i=document.createElement("a");i.href=e;t={url:e,anchor:i,target:""}}for(var i=0;i<this.anchorRules.length;i++){var n=this.anchorRules[i];if(!BX.type.isArray(n.condition)){continue}for(var s=0;s<n.condition.length;s++){var r=e.match(n.condition[s]);if(r&&!this.hasStopParams(e,n.stopParameters)){t.matches=r;const e=BX.Type.isFunction(n.minimizeOptions)?n.minimizeOptions(t):null;if(BX.Type.isPlainObject(e)){if(BX.Type.isPlainObject(n.options)){n.options.minimizeOptions=e}else{n.options={minimizeOptions:e}}}return n}}}return null},isValidLink:function(e,t){if(!e){return false}if(e.allowCrossDomain!==true&&BX.ajax.isCrossDomain(t.url)){return false}if(e.mobileFriendly!==true&&BX.browser.IsMobile()){return false}if(BX.type.isFunction(e.validate)&&!e.validate(t)){return false}return true},setBrowserHistory:function(e){if(!(e instanceof BX.SidePanel.Slider)){return}if(e.canChangeHistory()&&e.isOpen()&&e.isLoaded()){window.history.replaceState({},"",e.getUrl())}},resetBrowserHistory:function(){var e=null;var t=this.getOpenSliders();for(var i=t.length-1;i>=0;i--){var n=t[i];if(n.canChangeHistory()&&n.isOpen()&&n.isLoaded()){e=n;break}}var s=e?e.getUrl():this.getPageUrl();if(s){window.history.replaceState({},"",s)}},updateBrowserTitle:function(){var e=null;var t=this.getOpenSliders();for(var i=t.length-1;i>=0;i--){e=this.getBrowserTitle(t[i]);if(BX.type.isNotEmptyString(e)){break}}if(BX.type.isNotEmptyString(e)){document.title=e;this.titleChanged=true}else if(this.titleChanged){document.title=this.getPageTitle();this.titleChanged=false}},getBrowserTitle:function(e){if(!e||!e.canChangeTitle()||!e.isOpen()||!e.isLoaded()){return null}var t=e.getTitle();if(!t&&!e.isSelfContained()){t=e.getFrameWindow()?e.getFrameWindow().document.title:null}return BX.type.isNotEmptyString(t)?t:null},hasStopParams:function(e,t){if(!t||!BX.type.isArray(t)||!BX.type.isNotEmptyString(e)){return false}var i=e.indexOf("?");if(i===-1){return false}var n=e.substring(i);for(var s=0;s<t.length;s++){var r=t[s];if(n.match(new RegExp("[?&]"+r+"=","i"))){return true}}return false},getLastOpenPage:function(){return this.getLastOpenSlider()},getCurrentPage:function(){return this.getTopSlider()}};class i extends BX.Event.EventEmitter{constructor(e){super();this.setEventNamespace("BX.Main.SidePanel.Toolbar");const t=BX.Type.isPlainObject(e)?e:{};if(!BX.Type.isStringFilled(t.context)){throw new Error('BX.Main.SidePanel.Toolbar: "context" parameter is required.')}this.context=t.context;this.items=[];this.rendered=false;this.refs=new BX.Cache.MemoryCache;this.container=null;this.lsKey="bx.sidepanel.toolbar.item";this.initialPosition={right:"5px",bottom:"20px"};this.shiftedPosition={right:"5px",bottom:"20px"};if(BX.Type.isPlainObject(t.position)){this.initialPosition=t.position}if(BX.Type.isPlainObject(t.shiftedPosition)){this.shiftedPosition=t.shiftedPosition}this.collapsed=t.collapsed!==false;this.muted=false;this.shifted=false;this.maxVisibleItems=BX.Type.isNumber(t.maxVisibleItems)?Math.max(t.maxVisibleItems,1):5;this.addItems(t.items);const i=this.restoreItemFromLocalStorage();if(i!==null){const{entityType:e,entityId:t}=i;if(this.getItem(e,t)){this.clearLocalStorage()}else{this.minimizeItem(i)}}}show(){BX.Dom.addClass(this.getContainer(),"--show")}isShown(){return BX.Dom.hasClass(this.getContainer(),"--show")}hide(){BX.Dom.removeClass(this.getContainer(),"--show")}mute(){if(this.muted){return false}this.muted=true;BX.Dom.addClass(this.getContainer(),"--muted");return true}unmute(){if(!this.muted){return false}this.muted=false;BX.Dom.removeClass(this.getContainer(),"--muted");return true}isMuted(){return this.muted}toggleMuteness(){if(this.canShowOnTop()){return this.unmute()}return this.mute()}shift(){if(this.shifted){return false}this.shifted=true;BX.Dom.addClass(this.getContainer(),"--shifted");BX.Dom.style(document.body,"--side-panel-toolbar-shifted",1);this.setPosition(this.getContainer(),this.shiftedPosition);return true}unshift(){if(!this.shifted){return false}this.shifted=false;BX.Dom.removeClass(this.getContainer(),"--shifted");BX.Dom.style(document.body,"--side-panel-toolbar-shifted",null);this.setPosition(this.getContainer(),this.initialPosition);return true}isShifted(){return this.shifted}toggleShift(){const e=BX.SidePanel.Instance.getOpenSliders();if(e.length===0||e.length===1&&!e[0].isOpen()){return this.unshift()}return this.shift()}setPosition(e,t){for(const i of["top","right","bottom","left"]){BX.Dom.style(e,i,null);if(BX.Type.isStringFilled(t[i])){BX.Dom.style(e,i,t[i])}}}collapse(e){if(this.collapsed){return}if(e===true){BX.Dom.addClass(this.getContainer(),"--collapsed");BX.Dom.style(this.getContentContainer(),"width",null)}else{const e=this.getContentContainer().scrollWidth;BX.Dom.style(this.getContentContainer(),"width",`${e}px`);BX.Event.unbindAll(this.getContentContainer(),"transitionend");requestAnimationFrame((()=>{requestAnimationFrame((()=>{BX.Dom.style(this.getContentContainer(),"width",0);BX.Event.bindOnce(this.getContentContainer(),"transitionend",(()=>{BX.Dom.addClass(this.getContainer(),"--collapsed");BX.Dom.style(this.getContentContainer(),"width",null)}))}))}))}this.collapsed=true}expand(e){if(!this.collapsed){return}if(e===true){BX.Dom.removeClass(this.getContainer(),"--collapsed");BX.Dom.style(this.getContentContainer(),"width",null)}else{BX.Dom.removeClass(this.getContainer(),"--collapsed");const e=this.getContentContainer().scrollWidth;BX.Dom.style(this.getContentContainer(),"width",0);BX.Event.unbindAll(this.getContentContainer(),"transitionend");requestAnimationFrame((()=>{requestAnimationFrame((()=>{BX.Dom.style(this.getContentContainer(),"width",`${e}px`);BX.Event.bindOnce(this.getContentContainer(),"transitionend",(()=>{BX.Dom.style(this.getContentContainer(),"width",null)}))}))}))}this.collapsed=false}toggle(){if(this.collapsed){this.request("expand");this.expand()}else{this.request("collapse");this.collapse()}}isCollapsed(){return this.collapsed}getItems(){return this.items}getItemsCount(){return this.items.length}addItems(e){if(BX.Type.isArrayFilled(e)){e.forEach((e=>{this.addItem(e)}))}}addItem(e){const t=this.createItem(e);if(t===null){return null}this.items.push(t);if(this.rendered){this.redraw()}return t}prependItem(e){const t=this.createItem(e);if(t===null){return null}this.items.unshift(t);if(this.rendered){this.redraw()}return t}createItem(e){const t=BX.Type.isPlainObject(e)?e:{};if(!BX.Type.isStringFilled(t.entityType)||!(BX.Type.isStringFilled(t.entityId)||BX.Type.isNumber(t.entityId))||!BX.Type.isStringFilled(t.title)||!BX.Type.isStringFilled(t.url)){return null}const i=new n(t);if(!BX.Type.isStringFilled(i.getEntityName())){const e=BX.SidePanel.Instance.getMinimizeOptions(i.getUrl());if(BX.Type.isPlainObject(e)&&BX.Type.isStringFilled(e.entityName)){i.setEntityName(e.entityName)}}i.subscribe("onRemove",this.handleItemRemove.bind(this));return i}minimizeItem(e){const{entityType:t,entityId:i}=e;let n=this.getItem(t,i);const s=n!==null;if(!s){n=this.prependItem(e)}if(n!==null){if(!s){this.saveItemToLocalStorage(n)}this.request("minimize",n).then((e=>{if(e.status==="success"){this.clearLocalStorage()}})).catch((()=>{this.clearLocalStorage();this.removeItem(n)}))}return n}saveItemToLocalStorage(e){const t={item:e,ttl:Date.now()};localStorage.setItem(this.lsKey,JSON.stringify(t))}restoreItemFromLocalStorage(){const e=localStorage.getItem(this.lsKey);if(BX.Type.isStringFilled(e)){const{item:t,ttl:i}=JSON.parse(e);if(Date.now()-i>1e4){this.clearLocalStorage();return null}if(BX.Type.isPlainObject(t)){return t}}return null}clearLocalStorage(){localStorage.removeItem(this.lsKey)}getContext(){return this.context}request(e,t,i){const n=BX.Type.isPlainObject(i)?i:{};return BX.ajax.runAction(`main.api.sidepanel.toolbar.${e}`,{json:{toolbar:{context:this.getContext()},item:t?t.toJSON():null,...n}})}handleItemRemove(e){const t=e.getTarget();t.hideTooltip();this.removeItem(t)}handleMenuItemRemove(e){e.preventDefault();e.stopPropagation();const t=e.currentTarget.dataset.menuItemId;const i=this.getItemById(t);if(i){this.removeItem(i)}const n=this.getMenu();if(n){n.removeMenuItem(t);const e=this.getItems().reduce(((e,t)=>t.isRendered()?e:e+1),0);if(e>0){n.getPopupWindow().adjustPosition()}else{n.close()}}}removeItem(e){e.remove();this.items=this.items.filter((t=>t!==e));const t=this.restoreItemFromLocalStorage();if(t!==null){const{entityType:i,entityId:n}=t;if(e.getEntityType()===i&&e.getEntityId()===n){this.clearLocalStorage()}}if(this.rendered){this.redraw();this.request("remove",e);if(this.getItemsCount()===0){this.hide()}}}redraw(){let e=0;for(let t=0;t<this.getItems().length;t++){const i=this.getItems()[t];if(e>=this.maxVisibleItems){if(i.isRendered()){i.remove()}}else{if(!i.isRendered()){const e=this.getItems()[t-1]||null;const n=this.getItems()[t+1]||null;if(e){i.insertAfter(e.getContainer())}else if(n){i.insertBefore(n.getContainer())}else{i.appendTo(this.getItemsContainer())}}e++}}}removeAll(){this.getItemsContainer().innerHTML="";this.items=[];this.clearLocalStorage()}getItem(e,t){return this.items.find((i=>i.getEntityType()===e&&i.getEntityId()===t))||null}getItemByUrl(e){return this.items.find((t=>t.getUrl()===e))||null}getItemById(e){return this.items.find((t=>t.getId()===e))||null}getContainer(){return this.refs.remember("container",(()=>{const e=[];if(this.collapsed){e.push("--collapsed")}const t=BX.Tag.render`
				<div class="side-panel-toolbar ${e.join(" ")}">
					${this.getContentContainer()}
					<div class="side-panel-toolbar-toggle" onclick="${this.handleToggleClick.bind(this)}"></div>
				</div>
			`;this.setPosition(t,this.initialPosition);BX.Dom.append(t,document.body);BX.ZIndexManager.register(t,{alwaysOnTop:true});this.rendered=true;const i=BX.Runtime.debounce(this.toggleMuteness,50,this);BX.Event.EventEmitter.subscribe("BX.Main.Popup:onShow",i);BX.Event.EventEmitter.subscribe("BX.Main.Popup:onClose",i);BX.Event.EventEmitter.subscribe("BX.Main.Popup:onDestroy",i);BX.Event.EventEmitter.subscribe("onWindowClose",i);BX.Event.EventEmitter.subscribe("onWindowRegister",i);let n=false;const s=()=>{this.toggleMuteness();if(this.isMuted()){return}this.toggleShift();if(!this.isShifted()&&n){n=false;this.expand()}};BX.Event.EventEmitter.subscribe("SidePanel.Slider:onClosing",s);BX.Event.EventEmitter.subscribe("SidePanel.Slider:onCloseComplete",s);BX.Event.EventEmitter.subscribe("SidePanel.Slider:onDestroyComplete",s);BX.Event.EventEmitter.subscribe("SidePanel.Slider:onOpening",(()=>{this.toggleMuteness();if(this.isMuted()){return}if(!this.isCollapsed()){n=true;this.collapse()}this.toggleShift()}));BX.Event.EventEmitter.subscribe("BX.UI.Viewer.Controller:onBeforeShow",i);BX.Event.EventEmitter.subscribe("BX.UI.Viewer.Controller:onClose",BX.Runtime.debounce(this.toggleMuteness,500,this));BX.Event.bind(window,"resize",BX.Runtime.throttle((()=>{const e=this.getMenu();if(e!==null){e.close()}}),300));return t}))}getContentContainer(){return this.refs.remember("content-container",(()=>BX.Tag.render`
				<div class="side-panel-toolbar-content">
					<div class="side-panel-toolbar-collapse-btn" onclick="${this.handleToggleClick.bind(this)}">
						<div class="ui-icon-set --chevron-right"></div>
					</div>
					${this.getItemsContainer()}
					${this.getMoreButton()}
				</div>
			`))}getItemsContainer(){return this.refs.remember("items-container",(()=>{const e=BX.Tag.render`<div class="side-panel-toolbar-items"></div>`;[...this.items].slice(0,this.maxVisibleItems).forEach((t=>{t.appendTo(e)}));return e}))}getMoreButton(){return this.refs.remember("more-button",(()=>BX.Tag.render`
				<div class="side-panel-toolbar-more-btn" onclick="${this.handleMoreBtnClick.bind(this)}">
					<div class="ui-icon-set --more"></div>
				</div>
			`))}handleMoreBtnClick(e){const t=this.getMoreButton();const i=t.getBoundingClientRect();const n=i.width;const s=[...this.items].filter((e=>!e.isRendered())).map((e=>{const t=BX.Type.isStringFilled(e.getEntityName())?`${e.getEntityName()}\n${e.getTitle()}`:e.getTitle();return{id:e.getId(),html:this.createMenuItemText(e),title:t,href:e.getUrl(),onclick:()=>{r.close()}}}));if(s.length>0){s.push({delimiter:true})}s.push({text:BX.Loc.getMessage("MAIN_SIDEPANEL_REMOVE_ALL"),onclick:()=>{this.removeAll();this.hide();r.close();this.request("removeAll")}});const r=BX.Main.MenuManager.create({id:"sidepanel-toolbar-more-btn",cacheable:false,bindElement:i,bindOptions:{forceBindPosition:true,forceTop:true,position:"top"},maxWidth:260,fixed:true,offsetTop:0,maxHeight:305,items:s,events:{onShow:e=>{const t=e.getTarget();const i=t.getPopupContainer().offsetWidth;const s=n/2-i/2;const r=BX.Main.Popup.getOption("angleLeftOffset")-BX.Main.Popup.getOption("angleMinTop");t.setAngle({offset:i/2-r});t.setOffset({offsetLeft:s+BX.Main.Popup.getOption("angleLeftOffset")})}}});r.show()}canShowOnTop(){const e=BX.Main.PopupManager.getPopups();for(const t of e){if(!t.isShown()){continue}if(t.getId().startsWith("timeman_weekly_report_popup_")||t.getId().startsWith("timeman_daily_report_popup_")||BX.Dom.hasClass(t.getPopupContainer(),"b24-whatsnew__popup")){return false}}if(BX.Reflection.getClass("BX.UI.Viewer.Instance")&&BX.UI.Viewer.Instance.isOpen()){return false}const t=BX.SidePanel.Instance.getOpenSliders();for(const e of t){const t=e.getUrl().toString();if(t.startsWith("im:slider")||t.startsWith("release-slider")||t.startsWith("main:helper")||t.startsWith("ui:info_helper")){return false}}const i=BX.ZIndexManager.getStack(document.body);const n=i===null?[]:i.getComponents();for(const e of n){if(e.getOverlay()!==null&&e.getOverlay().offsetWidth>0){return false}}return true}getMenu(){return BX.Main.MenuManager.getMenuById("sidepanel-toolbar-more-btn")}createMenuItemText(e){return BX.Tag.render`
			<span class="side-panel-toolbar-menu-item">${[BX.Tag.render`
					<span class="side-panel-toolbar-menu-item-title">${BX.Text.encode(e.getTitle())}</span>
				`,BX.Tag.render`
					<span
						class="side-panel-toolbar-menu-item-remove"
						data-slider-ignore-autobinding="true"
						data-menu-item-id="${e.getId()}"
						onclick="${this.handleMenuItemRemove.bind(this)}"
					>
						<span class="ui-icon-set --cross-20" data-slider-ignore-autobinding="true"></span>
					</span>
				`]}</span>
		`}handleToggleClick(){this.toggle()}}class n extends BX.Event.EventEmitter{constructor(e){super();this.setEventNamespace("BX.Main.SidePanel.ToolbarItem");const t=BX.Type.isPlainObject(e)?e:{};this.id=BX.Type.isStringFilled(t.id)?t.id:`toolbar-item-${BX.Text.getRandom().toLowerCase()}`;this.title="";this.url="";this.entityType="";this.entityId=0;this.entityName="";this.refs=new BX.Cache.MemoryCache;this.rendered=false;this.setTitle(t.title);this.setUrl(t.url);this.setEntityType(t.entityType);this.setEntityId(t.entityId)}getId(){return this.id}getUrl(){return this.url}setUrl(e){if(BX.Type.isStringFilled(e)){this.url=e;if(this.rendered){this.getContainer().href=e}}}getTitle(){return this.title}setTitle(e){if(BX.Type.isStringFilled(e)){this.title=e;if(this.rendered){this.getTitleContainer().textContent=e}}}getEntityType(){return this.entityType}setEntityType(e){if(BX.Type.isStringFilled(e)){this.entityType=e}}getEntityId(){return this.entityId}setEntityId(e){if(BX.Type.isNumber(e)||BX.Type.isStringFilled(e)){this.entityId=e}}getEntityName(){return this.entityName}setEntityName(e){if(BX.Type.isStringFilled(e)){this.entityName=e}}getContainer(){return this.refs.remember("container",(()=>BX.Tag.render`
				<div class="side-panel-toolbar-item" 
					onclick="${this.handleClick.bind(this)}"
					onmouseenter="${this.handleMouseEnter.bind(this)}"
					onmouseleave="${this.handleMouseLeave.bind(this)}"
				>
					${this.getTitleContainer()}
					<div class="side-panel-toolbar-item-remove-btn" onclick="${this.handleRemoveBtnClick.bind(this)}">
						<div class="ui-icon-set --cross-20" style="--ui-icon-set__icon-size: 100%;"></div>
					</div>
				</div>
			`))}isRendered(){return this.rendered}getTitleContainer(){return this.refs.remember("title",(()=>BX.Tag.render`
				<a 
					class="side-panel-toolbar-item-title"
					href="${encodeURI(this.getUrl())}"
					data-slider-ignore-autobinding="true"
				>${BX.Text.encode(this.getTitle())}</a>
			`))}prependTo(e){if(BX.Type.isDomNode(e)){BX.Dom.prepend(this.getContainer(),e);this.rendered=true}}appendTo(e){if(BX.Type.isDomNode(e)){BX.Dom.append(this.getContainer(),e);this.rendered=true}}insertBefore(e){if(BX.Type.isDomNode(e)){BX.Dom.insertBefore(this.getContainer(),e);this.rendered=true}}insertAfter(e){if(BX.Type.isDomNode(e)){BX.Dom.insertAfter(this.getContainer(),e);this.rendered=true}}remove(){BX.Dom.remove(this.getContainer());this.rendered=false}showTooltip(){const e=this.getContainer();const t=e.getBoundingClientRect();const i=t.width;const n=Math.min(Math.max(100,this.getTitleContainer().scrollWidth+20),300);const s=BX.Main.PopupManager.create({id:"sidepanel-toolbar-item-hint",cacheable:false,bindElement:t,bindOptions:{forceBindPosition:true,forceTop:true,position:"top"},width:n,content:BX.Tag.render`
				<div class="sidepanel-toolbar-item-hint">
					<div class="sidepanel-toolbar-item-hint-title">${BX.Text.encode(this.getEntityName())}</div>
					<div class="sidepanel-toolbar-item-hint-content">${BX.Text.encode(this.getTitle())}</div>
				</div>
			`,darkMode:true,fixed:true,offsetTop:0,events:{onShow:e=>{const t=e.getTarget();const s=i/2-n/2;const r=BX.Main.Popup.getOption("angleLeftOffset")-BX.Main.Popup.getOption("angleMinTop");t.setAngle({offset:n/2-r});t.setOffset({offsetLeft:s+BX.Main.Popup.getOption("angleLeftOffset")})}}});s.show();s.adjustPosition()}hideTooltip(){const e=BX.Main.PopupManager.getPopupById("sidepanel-toolbar-item-hint");if(e){e.close()}}handleClick(e){if(e.ctrlKey||e.metaKey){return}e.preventDefault();BX.SidePanel.Instance.maximize(this.getUrl())}handleMouseEnter(e){this.showTooltip()}handleMouseLeave(e){this.hideTooltip()}handleRemoveBtnClick(e){e.stopPropagation();this.emit("onRemove")}toJSON(){return{title:this.getTitle(),url:this.getUrl(),entityType:this.getEntityType(),entityId:this.getEntityId()}}}})();
//# sourceMappingURL=manager.map.js