(function(){"use strict";BX.namespace("BX.Kanban");BX.Kanban.DropZone=function(t){t=t||{};if(!BX.Kanban.Utils.isValidId(t.id)){throw new Error("BX.Kanban.DropZone: 'id' parameter is not valid.")}this.id=t.id;this.name=null;this.color=null;this.data=Object.create(null);this.dropZoneArea=null;this.setOptions(t);this.layout={container:null,name:null,bg:null,cancel:null};this.droppedItem=null;this.captureTimeout=null};BX.Kanban.DropZone.DEFAULT_COLOR="1eae43";BX.Kanban.DropZone.prototype={getId:function(){return this.id},setOptions:function(t){if(!t){return}this.setName(t.name);this.setColor(t.color);this.setData(t.data)},setName:function(t){if(BX.type.isNotEmptyString(t)){this.name=t}},getName:function(){return this.name},setColor:function(t){if(BX.Kanban.Utils.isValidColor(t)){this.color=t.toLowerCase()}},getColor:function(){return this.color!==null?this.color:BX.Kanban.DropZone.DEFAULT_COLOR},getData:function(){return this.data},setData:function(t){if(BX.type.isPlainObject(t)){this.data=t}},getGridData:function(){return this.getGrid().getData()},setDropZoneArea:function(t){this.dropZoneArea=t},getDropZoneArea:function(){return this.dropZoneArea},getGrid:function(){return this.getDropZoneArea().getGrid()},makeDroppable:function(){var t=this.getContainer();t.onbxdestdraghover=BX.delegate(this.onDragEnter,this);t.onbxdestdraghout=BX.delegate(this.onDragLeave,this);t.onbxdestdragfinish=BX.delegate(this.onDragDrop,this);jsDD.registerDest(t,10)},setActive:function(){this.getContainer().classList.add("main-kanban-dropzone-active")},unsetActive:function(){this.getContainer().classList.remove("main-kanban-dropzone-active")},setCaptured:function(){this.getContainer().classList.add("main-kanban-dropzone-captured")},unsetCaptured:function(){this.getContainer().classList.remove("main-kanban-dropzone-captured")},onDragEnter:function(t,e,n){this.setActive();this.getDropZoneArea().setActive()},onDragLeave:function(t,e,n){this.unsetActive();this.getDropZoneArea().unsetActive()},onDragDrop:function(t,e,n){var i=this.getGrid().getItemByElement(t);this.captureItem(i);this.getDropZoneArea().unsetActive()},captureItem:function(t){var e=new BX.Kanban.DropZoneEvent;e.setItem(t);e.setDropZone(this);BX.onCustomEvent(this.getGrid(),"Kanban.DropZone:onBeforeItemCaptured",[e]);if(!e.isActionAllowed()){return}this.empty();this.droppedItem=t;this.getDropZoneArea().show();this.setCaptured();this.unsetActive();this.animateRemove(t.layout.container);this.getGrid().hideItem(t);BX.onCustomEvent(this.getGrid(),"Kanban.DropZone:onItemCaptured",[t,this]);this.captureTimeout=setTimeout(function(){this.empty();this.getDropZoneArea().hide()}.bind(this),this.getDropZoneArea().getDropZoneTimeout())},animateRemove:function(t){this.dropZoneArea.layout.container.parentNode.style.overflow="hidden";setTimeout(function(){this.dropZoneArea.layout.container.parentNode.style.overflow="inherit"}.bind(this),250)},restore:function(){if(this.captureTimeout){clearTimeout(this.captureTimeout)}if(this.droppedItem===null){return}var t=new BX.Kanban.DropZoneEvent;t.setItem(this.droppedItem);t.setDropZone(this);BX.onCustomEvent(this.getGrid(),"Kanban.DropZone:onBeforeItemRestored",[t]);if(!t.isActionAllowed()){return}this.unsetActive();this.unsetCaptured();this.getGrid().unhideItem(this.droppedItem);BX.onCustomEvent(this.getGrid(),"Kanban.DropZone:onItemRestored",[this.droppedItem,this]);this.droppedItem=null},empty:function(){if(this.captureTimeout){clearTimeout(this.captureTimeout)}if(this.droppedItem===null){return}this.unsetActive();this.unsetCaptured();this.getGrid().removeItem(this.droppedItem);BX.onCustomEvent(this.getGrid(),"Kanban.DropZone:onItemEmptied",[this.droppedItem,this]);this.droppedItem=null},getContainer:function(){if(this.layout.container!==null){return this.layout.container}this.layout.container=BX.create("div",{attrs:{className:"main-kanban-dropzone","data-id":this.getId()},children:[this.getNameContainer(),this.getCancelLink(),this.getBgContainer()]});this.makeDroppable();return this.layout.container},getNameContainer:function(){if(!this.layout.name){var t=BX.Kanban.Utils.isDarkColor(this.getColor());this.layout.name=BX.create("div",{attrs:{className:t?"main-kanban-dropzone-title":"main-kanban-dropzone-title main-kanban-dropzone-title-light"}})}return this.layout.name},getCancelLink:function(){if(!this.layout.cancel){this.layout.cancel=BX.create("div",{attrs:{className:"main-kanban-dropzone-cancel"},children:[BX.create("span",{attrs:{className:"main-kanban-dropzone-cancel-link"},events:{click:this.handleCancelClick.bind(this)},html:this.getGrid().getMessage("DROPZONE_CANCEL")})]})}return this.layout.cancel},handleCancelClick:function(t){this.restore();this.getDropZoneArea().hide()},getBgContainer:function(){if(!this.layout.bg){this.layout.bg=BX.create("div",{attrs:{className:"main-kanban-dropzone-bg"}})}return this.layout.bg},render:function(){this.getNameContainer().textContent=this.getName();this.getBgContainer().style.backgroundColor="#"+this.getColor();return this.getContainer()}};BX.Kanban.DropZoneEvent=function(t){t=BX.type.isPlainObject(t)||{};this.action=BX.type.isBoolean(t.action)?t.action:true;this.item=null;this.dropZone=null};BX.Kanban.DropZoneEvent.prototype={allowAction:function(){this.action=true},denyAction:function(){this.action=false},isActionAllowed:function(){return this.action},setItem:function(t){this.item=t},getItem:function(){return this.item},setDropZone:function(t){this.dropZone=t},getDropZone:function(){return this.dropZone}}})();
//# sourceMappingURL=dropzone.map.js