import {Loc} from 'main.core';

const locale = {
	pesdk: {
		common: {
			title: {
				error: Loc.getMessage('IMAGE_EDITOR_ERROR'),
			},
			text: {
				loading: Loc.getMessage('IMAGE_EDITOR_LOADING'),
				updating: Loc.getMessage('IMAGE_EDITOR_UPDATING'),
			},
			button: {
				cancel: Loc.getMessage('IMAGE_EDITOR_CANCEL'),
			},
		},
		editor: {
			button: {
				export: Loc.getMessage('IMAGE_EDITOR_EXPORT'),
				save: Loc.getMessage('IMAGE_EDITOR_EXPORT'),
				load: Loc.getMessage('IMAGE_EDITOR_NEW'),
				close: Loc.getMessage('IMAGE_EDITOR_CLOSE'),
				newImageChangesLostWarningYes: Loc.getMessage('IMAGE_EDITOR_YES'),
				newImageChangesLostWarningNo: Loc.getMessage('IMAGE_EDITOR_NO'),
				discardChangesWarningKeep: Loc.getMessage('IMAGE_EDITOR_DISCARD_CHANGES_KEEP_CHANGES_BUTTON'),
				discardChangesWarningDiscard: Loc.getMessage('IMAGE_EDITOR_DISCARD_CHANGES_DISCARD_BUTTON'),
			},
			title: {
				newImageChangesLostWarning: Loc.getMessage('IMAGE_EDITOR_IMAGE_NEW_IMAGE_TITLE'),
				imageResizedWarning_maxMegaPixels: Loc.getMessage('IMAGE_EDITOR_IMAGE_RESIZED_TITLE'),
				imageResizedWarning_maxDimensions: Loc.getMessage('IMAGE_EDITOR_IMAGE_RESIZED_TITLE'),
				fontLoadingError: Loc.getMessage('IMAGE_EDITOR_ERROR_FONT_LOADING_ERROR'),
				discardChangesWarning: Loc.getMessage('IMAGE_EDITOR_DISCARD_CHANGES_DISCARD_BUTTON'),
			},
			text: {
				newImageChangesLostWarning: Loc.getMessage('IMAGE_EDITOR_IMAGE_NEW_IMAGE_TITLE'),
				imageResizedWarning_maxMegaPixels: Loc.getMessage('IMAGE_EDITOR_IMAGE_RESIZED_DESCRIPTION'),
				imageResizedWarning_maxDimensions: Loc.getMessage('IMAGE_EDITOR_IMAGE_RESIZED_DESCRIPTION'),
				renderingError: 'An error has occurred while rendering the image.',
				exporting: Loc.getMessage('IMAGE_EDITOR_EXPORTING'),
				saving: Loc.getMessage('IMAGE_EDITOR_EXPORTING'),
				loading: Loc.getMessage('IMAGE_EDITOR_LOADING'),
				resizing: Loc.getMessage('IMAGE_EDITOR_RESIZING'),
				loadingFonts: Loc.getMessage('IMAGE_EDITOR_LOADING_FONTS'),
				// eslint-disable-next-line
				fontLoadingError: 'The following fonts could not be loaded: ${fonts}.',
				webcamUnavailableError: Loc.getMessage('IMAGE_EDITOR_ERROR_WEBCAM_UNAVAILABLE'),
				invalidFileTypeError: Loc.getMessage('IMAGE_EDITOR_ERROR_UNSUPPORTED_FILE_TYPE'),
				imageLoadingError: Loc.getMessage('IMAGE_EDITOR_POPUP_ERROR_MESSAGE_TEXT'),
				discardChangesWarning: 'You have unsaved changes. Are you sure you want to discard the changes?',
			},
		},
		library: {
			title: {
				name: Loc.getMessage('IMAGE_EDITOR_LIBRARY_TITLE'),
			},
			button: {
				fileDropZone: Loc.getMessage('IMAGE_EDITOR_LIBRARY_DROP_ZONE'),
				fileDropZoneHovered: Loc.getMessage('IMAGE_EDITOR_LIBRARY_DROP_ZONE_HOVERED'),
			},
			placeholder: {
				search: Loc.getMessage('IMAGE_EDITOR_LIBRARY_SEARCH'),
			},
			text: {
				noResults: 'No results',
			},
		},
		transform: {
			title: {
				name: Loc.getMessage('IMAGE_EDITOR_TRANSFORM_TITLE'),
			},
			dimensions: {
				lock: Loc.getMessage('IMAGE_EDITOR_LOCK_RESOLUTION'),
			},
			button: {
				reset: Loc.getMessage('IMAGE_EDITOR_TRANSFORM_RESET_TO_DEFAULT'),
			},
			asset: {
				imgly_transforms_common: {
					name: Loc.getMessage('IMAGE_EDITOR_COMMON_CROPS'),
					asset: {
						imgly_transform_common_custom: Loc.getMessage('IMAGE_EDITOR_RATIOS_CUSTOM'),
						imgly_transform_common_square: Loc.getMessage('IMAGE_EDITOR_RATIOS_SQUARE'),
						'imgly_transform_common_4-3': '4:3',
						'imgly_transform_common_16-9': '16:9',
					},
				},
				imgly_transforms_facebook: {
					name: Loc.getMessage('IMAGE_EDITOR_TRANSFORM_FACEBOOK'),
					asset: {
						imgly_transform_facebook_ad: Loc.getMessage('IMAGE_EDITOR_TRANSFORM_FACEBOOK_AD'),
						imgly_transform_facebook_post: Loc.getMessage('IMAGE_EDITOR_TRANSFORM_FACEBOOK_POST'),
						imgly_transform_facebook_cover: Loc.getMessage('IMAGE_EDITOR_TRANSFORM_FACEBOOK_COVER'),
						imgly_transform_facebook_profile: Loc.getMessage('IMAGE_EDITOR_TRANSFORM_FACEBOOK_PROFILE'),
					},
				},
			},
			placeholder: {
				width: Loc.getMessage('IMAGE_EDITOR_SIZE_WIDTH'),
				height: Loc.getMessage('IMAGE_EDITOR_SIZE_WIDTH'),
			},
		},
		filter: {
			asset: {
				identity: Loc.getMessage('IMAGE_EDITOR_FILTERS_NONE'),
				imgly_lut_celsius: 'Inferno',
				imgly_lut_chest: 'Chestnut',
				imgly_lut_fixie: 'Fixie',
				imgly_lut_fridge: 'Fridge',
				imgly_lut_front: 'Sunny 70s',
				imgly_lut_k2: 'Flat Black',
				imgly_lut_mellow: 'Mellow',
				imgly_lut_sin: 'Hard Stuff',
				imgly_lut_texas: 'Oldtimer',
				imgly_lut_ad1920: '1920 A.D.',
				imgly_lut_ancient: 'Ancient',
				imgly_lut_bleached: 'Kalmen',
				imgly_lut_bleachedblue: 'Joran',
				imgly_lut_blues: 'Polaroid',
				imgly_lut_blueshadows: 'Zephyr',
				imgly_lut_breeze: 'Levante',
				imgly_lut_bw: 'Greyed',
				imgly_lut_classic: 'Classic',
				imgly_lut_colorful: 'Colorful',
				imgly_lut_cool: 'Snappy',
				imgly_lut_cottoncandy: 'Cotton Candy',
				imgly_lut_creamy: 'Creamy',
				imgly_lut_eighties: 'Low Fire',
				imgly_lut_elder: 'Colla',
				imgly_lut_evening: 'Sunrise',
				imgly_lut_fall: 'Moss',
				imgly_lut_food: 'Food',
				imgly_lut_glam: 'Glam',
				imgly_lut_gobblin: 'Gobblin',
				imgly_lut_highcarb: 'High Carb',
				imgly_lut_highcontrast: 'High Contrast',
				imgly_lut_k1: 'K1',
				imgly_lut_k6: 'K6',
				imgly_lut_kdynamic: 'Pebble',
				imgly_lut_keen: 'Keen',
				imgly_lut_lenin: 'Lemon',
				imgly_lut_litho: 'Litho',
				imgly_lut_lomo: 'Lomo',
				imgly_lut_lomo100: 'Lomo 100',
				imgly_lut_lucid: 'Lucid',
				imgly_lut_neat: 'Neat',
				imgly_lut_nogreen: 'Pumpkin',
				imgly_lut_orchid: 'Solanus',
				imgly_lut_pale: 'Pale',
				imgly_lut_pitched: 'Pitched',
				imgly_lut_plate: 'Weathered',
				imgly_lut_pola669: 'Green Gap',
				imgly_lut_polasx: 'Pola SX',
				imgly_lut_pro400: 'Pro 400',
				imgly_lut_quozi: 'Quozi',
				imgly_lut_sepiahigh: 'Sepia',
				imgly_lut_settled: 'Settled',
				imgly_lut_seventies: 'Seventies',
				imgly_lut_soft: 'Soft',
				imgly_lut_steel: 'Steel',
				imgly_lut_summer: 'Summer',
				imgly_lut_sunset: 'Golden',
				imgly_lut_tender: 'Tender',
				imgly_lut_twilight: 'Twilight',
				imgly_lut_winter: 'Softy',
				imgly_lut_x400: 'Dusty',
				imgly_duotone_desert: 'Desert',
				imgly_duotone_peach: 'Peach',
				imgly_duotone_clash: 'Clash',
				imgly_duotone_plum: 'Plum',
				imgly_duotone_breezy: 'Breezy',
				imgly_duotone_deepblue: 'Deep Blue',
				imgly_duotone_frog: 'Frog',
				imgly_duotone_sunset: 'Sunset',
			},
			title: {
				name: Loc.getMessage('IMAGE_EDITOR_FILTERS_TITLE'),
			},
		},
		adjustments: {
			button: {
				reset: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_RESET'),
			},
			title: {
				name: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT'),
				basics: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_BASIC'),
				refinements: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_REFINEMENTS_1'),
			},
			text: {
				brightness: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_BRIGHTNESS'),
				saturation: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_SATURATION'),
				contrast: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_CONTRAST'),
				gamma: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_GAMMA'),
				clarity: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_CLARITY'),
				exposure: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_EXPOSURE'),
				shadows: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_SHADOWS'),
				highlights: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_HIGHLIGHTS'),
				whites: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_WHITES'),
				blacks: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_BLACKS'),
				temperature: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_TEMPERATURE'),
				sharpness: Loc.getMessage('IMAGE_EDITOR_ADJUSTMENT_SHARPNESS'),
			},
		},
		focus: {
			title: {
				name: Loc.getMessage('IMAGE_EDITOR_FOCUS_TITLE'),
			},
			button: {
				none: Loc.getMessage('IMAGE_EDITOR_FOCUS_NONE'),
				radial: Loc.getMessage('IMAGE_EDITOR_FOCUS_RADIAL'),
				mirrored: Loc.getMessage('IMAGE_EDITOR_FOCUS_MIRRORED'),
				linear: Loc.getMessage('IMAGE_EDITOR_FOCUS_LINEAR'),
				gaussian: Loc.getMessage('IMAGE_EDITOR_FOCUS_GAUSSIAN'),
			},
		},
		text: {
			title: {
				name: Loc.getMessage('IMAGE_EDITOR_TEXT_TITLE'),
				font: Loc.getMessage('IMAGE_EDITOR_TEXT_FONT'),
				size: Loc.getMessage('IMAGE_EDITOR_TEXT_SIZE'),
				spacing: Loc.getMessage('IMAGE_EDITOR_TEXT_PARAMS'),
				line: Loc.getMessage('IMAGE_EDITOR_TEXT_LINE_HEIGHT'),
				background: 'Background',
			},
			placeholder: {
				defaultText: Loc.getMessage('IMAGE_EDITOR_TEXT_DEFAULT_TEXT'),
			},
			button: {
				new: Loc.getMessage('IMAGE_EDITOR_TEXT_NEW_TEXT'),
			},
		},
		textdesign: {
			title: {
				name: Loc.getMessage('IMAGE_EDITOR_TEXT_DESIGN'),
				input: 'Text',
			},
			button: {
				invert: 'Text as mask',
				new: 'New Text Design',
			},
		},
		sticker: {
			title: {
				name: Loc.getMessage('IMAGE_EDITOR_STICKERS_TITLE'),
				opacity: Loc.getMessage('IMAGE_EDITOR_STICKERS_OPACITY'),
			},
			text: {
				// eslint-disable-next-line
				stickerLoadingError: 'Failed to load sticker ${path}.',
			},
			button: {
				replace: Loc.getMessage('IMAGE_EDITOR_STICKERS_REPLACE'),
				new: Loc.getMessage('IMAGE_EDITOR_STICKERS_NEW'),
				upload: Loc.getMessage('IMAGE_EDITOR_STICKERS_NEW'),
				fill: Loc.getMessage('IMAGE_EDITOR_STICKERS_FILL'),
			},
			asset: {
				imgly_sticker_custom: 'Eigene Sticker',
				imgly_sticker_emoticons: 'Emoticons',
				imgly_sticker_emoticons_alien: 'Alien',
				imgly_sticker_emoticons_angel: 'Angel',
				imgly_sticker_emoticons_angry: 'Angry',
				imgly_sticker_emoticons_anxious: 'Anxious',
				imgly_sticker_emoticons_asleep: 'Asleep',
				imgly_sticker_emoticons_attention: 'Attention',
				imgly_sticker_emoticons_baby_chicken: 'Baby Chicken',
				imgly_sticker_emoticons_batman: 'Batman',
				imgly_sticker_emoticons_beer: 'Beer',
				imgly_sticker_emoticons_black: 'Black',
				imgly_sticker_emoticons_blue: 'Blue',
				imgly_sticker_emoticons_blush: 'Blush',
				imgly_sticker_emoticons_boxer: 'Boxer',
				imgly_sticker_emoticons_business: 'Business',
				imgly_sticker_emoticons_chicken: 'Chicken',
				imgly_sticker_emoticons_cool: 'Cool',
				imgly_sticker_emoticons_cry: 'Cry',
				imgly_sticker_emoticons_deceased: 'Deceased',
				imgly_sticker_emoticons_devil: 'Devil',
				imgly_sticker_emoticons_duckface: 'Duckface',
				imgly_sticker_emoticons_furious: 'Furious',
				imgly_sticker_emoticons_grin: 'Grin',
				imgly_sticker_emoticons_guitar: 'Guitar',
				imgly_sticker_emoticons_harry_potter: 'Harry Potter',
				imgly_sticker_emoticons_hippie: 'Hippie',
				imgly_sticker_emoticons_hitman: 'Hitman',
				imgly_sticker_emoticons_humourous: 'Humourous',
				imgly_sticker_emoticons_idea: 'Idea',
				imgly_sticker_emoticons_impatient: 'Impatient',
				imgly_sticker_emoticons_kiss: 'Kiss',
				imgly_sticker_emoticons_kisses: 'Kisses',
				imgly_sticker_emoticons_laugh: 'Laugh',
				imgly_sticker_emoticons_loud_cry: 'Loud Cry',
				imgly_sticker_emoticons_loving: 'Loving',
				imgly_sticker_emoticons_masked: 'Masked',
				imgly_sticker_emoticons_music: 'Music',
				imgly_sticker_emoticons_nerd: 'Nerd',
				imgly_sticker_emoticons_ninja: 'Ninja',
				imgly_sticker_emoticons_not_speaking_to_you: 'Not speaking to you',
				imgly_sticker_emoticons_pig: 'Pig',
				imgly_sticker_emoticons_pumpkin: 'Pumpkin',
				imgly_sticker_emoticons_question: 'Question',
				imgly_sticker_emoticons_rabbit: 'Rabbit',
				imgly_sticker_emoticons_sad: 'Sad',
				imgly_sticker_emoticons_sick: 'Sick',
				imgly_sticker_emoticons_skateboard: 'Skateboard',
				imgly_sticker_emoticons_skull: 'Skull',
				imgly_sticker_emoticons_sleepy: 'Sleepy',
				imgly_sticker_emoticons_smile: 'Smile',
				imgly_sticker_emoticons_smoking: 'Smoking',
				imgly_sticker_emoticons_sobbing: 'Sobbing',
				imgly_sticker_emoticons_star: 'Star',
				imgly_sticker_emoticons_steaming_furious: 'Steaming Furious',
				imgly_sticker_emoticons_sunbathing: 'Sunbathing',
				imgly_sticker_emoticons_tired: 'Tired',
				imgly_sticker_emoticons_tongue_out_wink: 'Tongue out wink',
				imgly_sticker_emoticons_wave: 'Wave',
				imgly_sticker_emoticons_wide_grin: 'Wide Grin',
				imgly_sticker_emoticons_wink: 'Wink',
				imgly_sticker_emoticons_wrestler: 'Wrestler',
				imgly_sticker_shapes: 'Shapes',
				imgly_sticker_shapes_arrow_02: 'Arrow 1',
				imgly_sticker_shapes_arrow_03: 'Arrow 2',
				imgly_sticker_shapes_badge_01: 'Badge 1',
				imgly_sticker_shapes_badge_11: 'Badge 5',
				imgly_sticker_shapes_badge_12: 'Badge 6',
				imgly_sticker_shapes_badge_13: 'Badge 7',
				imgly_sticker_shapes_badge_15: 'Badge 8',
				imgly_sticker_shapes_badge_18: 'Badge 9',
				imgly_sticker_shapes_badge_19: 'Badge 10',
				imgly_sticker_shapes_badge_20: 'Badge 11',
				imgly_sticker_shapes_badge_28: 'Badge 12',
				imgly_sticker_shapes_badge_32: 'Badge 13',
				imgly_sticker_shapes_badge_35: 'Badge 14',
				imgly_sticker_shapes_badge_36: 'Badge 15',
				imgly_sticker_shapes_badge_04: 'Badge 2',
				imgly_sticker_shapes_badge_06: 'Badge 3',
				imgly_sticker_shapes_badge_08: 'Badge 4',
				imgly_sticker_shapes_spray_01: 'Spray 1',
				imgly_sticker_shapes_spray_03: 'Spray 2',
				imgly_sticker_shapes_spray_04: 'Spray 3',
			},
		},
		brush: {
			title: {
				name: Loc.getMessage('IMAGE_EDITOR_BRUSH_TITLE'),
				width: Loc.getMessage('IMAGE_EDITOR_BRUSH_WIDTH'),
				hardness: Loc.getMessage('IMAGE_EDITOR_BRUSH_HARDNESS'),
				settings: Loc.getMessage('IMAGE_EDITOR_BRUSH_SETTINGS'),
			},
		},
		frame: {
			title: {
				name: Loc.getMessage('IMAGE_EDITOR_FRAME_TITLE'),
				opacity: Loc.getMessage('IMAGE_EDITOR_FRAME_OPACITY'),
				width: Loc.getMessage('IMAGE_EDITOR_FRAME_WIDTH'),
			},
			button: {
				fill: Loc.getMessage('IMAGE_EDITOR_FRAME_FILL'),
				replace: Loc.getMessage('IMAGE_EDITOR_FRAME_REPLACE'),
				none: Loc.getMessage('IMAGE_EDITOR_FRAME_NONE'),
			},
			asset: {
				imgly_frame_dia: 'Dia',
				imgly_frame_art_decor: 'Art Decor',
				imgly_frame_black_passepartout: 'Black Passepartout',
				imgly_frame_lowpoly_shadow: 'Low Poly',
				imgly_frame_wood_passepartout: 'Wood Passepartout',
			},
		},
		artfilter: {
			title: {
				name: 'Art Filters',
			},
			asset: {
				none: 'None',
				imgly_art_filter_june_tree: 'Natasha Wescoat',
				imgly_art_filter_hive: 'Hive',
				imgly_art_filter_udnie: 'Udnie',
				imgly_art_filter_vince_low: 'Vince Low',
				imgly_art_filter_mosaic: 'Mosaic',
				imgly_art_filter_wave: 'Wave',
				imgly_art_filter_watercolor: 'Malikova Darya',
			},
		},
		overlay: {
			title: {
				name: Loc.getMessage('IMAGE_EDITOR_OVERLAY_TITLE'),
				blending: 'Blending',
				none: 'None',
				normal: 'Normal',
				overlay: 'Overlay',
				hardLight: 'Hard Light',
				softLight: 'Soft Light',
				multiply: 'Multiply',
				darken: 'Darken',
				lighten: 'Lighten',
				screen: 'Screen',
				colorBurn: 'Color Burn',
			},
			button: {
				none: Loc.getMessage('IMAGE_EDITOR_OVERLAY_NONE'),
			},
			asset: {
				imgly_overlay_bokeh: 'Bokeh',
				imgly_overlay_chop: 'Chop',
				imgly_overlay_clouds: 'Clouds',
				imgly_overlay_golden: 'Golden',
				imgly_overlay_grain: 'Grain',
				imgly_overlay_hearts: 'Hearts',
				imgly_overlay_lightleak1: 'Light Leak 1',
				imgly_overlay_lightleak2: 'Light Leak 2',
				imgly_overlay_metal: 'Metal',
				imgly_overlay_mosaic: 'Mosaic',
				imgly_overlay_painting: 'Painting',
				imgly_overlay_paper: 'Paper',
				imgly_overlay_rain: 'Rain',
				imgly_overlay_vintage: 'Vintage',
				imgly_overlay_wall1: 'Wall',
				imgly_overlay_wall2: 'Wall 2',
				imgly_overlay_wood: 'Wood',
			},
		},
	},
};

export default locale;