(function(){"use strict";BX.namespace("BX.Grid");BX.Grid.RowDragEvent=function(t){this.allowMoveRow=true;this.allowInsertBeforeTarget=true;this.dragItem=null;this.targetItem=null;this.eventName=!!t?t:"";this.errorMessage=""};BX.Grid.RowDragEvent.prototype={allowMove:function(){this.allowMoveRow=true;this.errorMessage=""},allowInsertBefore:function(){this.allowInsertBeforeTarget=true},disallowMove:function(t){this.allowMoveRow=false;this.errorMessage=t||""},disallowInsertBefore:function(){this.allowInsertBeforeTarget=false},getDragItem:function(){return this.dragItem},getTargetItem:function(){return this.targetItem},getEventName:function(){return this.eventName},setDragItem:function(t){return this.dragItem=t},setTargetItem:function(t){return this.targetItem=t},setEventName:function(t){return this.eventName=t},isAllowedMove:function(){return this.allowMoveRow},isAllowedInsertBefore:function(){return this.allowInsertBeforeTarget},getErrorMessage:function(){return this.errorMessage}};BX.Grid.RowsSortable=function(t){this.parent=null;this.list=null;this.setDefaultProps();this.init(t)};BX.Grid.RowsSortable.prototype={init:function(t){this.parent=t;this.list=this.getList();this.prepareListItems();jsDD.Enable();if(!this.inited){this.inited=true;this.onscrollDebounceHandler=BX.debounce(this._onWindowScroll,300,this);BX.addCustomEvent("Grid::thereEditedRows",BX.proxy(this.disable,this));BX.addCustomEvent("Grid::noEditedRows",BX.proxy(this.enable,this));document.addEventListener("scroll",this.onscrollDebounceHandler,BX.Grid.Utils.listenerParams({passive:true}))}},destroy:function(){BX.removeCustomEvent("Grid::thereEditedRows",BX.proxy(this.disable,this));BX.removeCustomEvent("Grid::noEditedRows",BX.proxy(this.enable,this));document.removeEventListener("scroll",this.onscrollDebounceHandler,BX.Grid.Utils.listenerParams({passive:true}));this.unregisterObjects()},_onWindowScroll:function(){this.windowScrollTop=BX.scrollTop(window);this.rowsRectList=null},disable:function(){this.unregisterObjects()},enable:function(){this.reinit()},reinit:function(){this.unregisterObjects();this.setDefaultProps();this.init(this.parent)},getList:function(){return this.parent.getRows().getSourceBodyChild()},unregisterObjects:function(){this.list.forEach(this.unregister,this)},prepareListItems:function(){this.list.forEach(this.register,this)},register:function(t){var e=this.parent.getRows();if(e.get(t).isDraggable()){t.onbxdragstart=BX.delegate(this._onDragStart,this);t.onbxdrag=BX.delegate(this._onDrag,this);t.onbxdragstop=BX.delegate(this._onDragEnd,this);jsDD.registerObject(t)}},unregister:function(t){jsDD.unregisterObject(t)},getIndex:function(t){return BX.Grid.Utils.getIndex(this.list,t)},calcOffset:function(){var t=this.dragRect.height;if(this.additionalDragItems.length){this.additionalDragItems.forEach(function(e){t+=e.clientHeight})}return t},getTheadCells:function(t){return[].map.call(t,function(e,r){return{block:"",tag:"th",attrs:{style:"width: "+BX.width(t[r])+"px;"}}})},createFake:function(){var t=[];this.cloneDragItem=BX.clone(this.dragItem);this.cloneDragAdditionalDragItems=[];this.cloneDragAdditionalDragItemRows=[];var e=this.getTheadCells(this.dragItem.cells);t.push(this.cloneDragItem);this.additionalDragItems.forEach(function(e){var r=BX.clone(e);t.push(r);this.cloneDragAdditionalDragItems.push(r);this.cloneDragAdditionalDragItemRows.push(new BX.Grid.Row(this.parent,r))},this);var r=BX.width(this.parent.getTable());this.fake=BX.decl({block:"main-grid-fake-container",attrs:{style:"position: absolute; top: "+this.getDragStartRect().top+"px; width: "+r+"px"},content:{block:"main-grid-table",mix:"main-grid-table-fake",tag:"table",attrs:{style:"width: "+r+"px"},content:[{block:"main-grid-header",tag:"thead",content:{block:"main-grid-row-head",tag:"tr",content:e}},{block:"",tag:"tbody",content:t}]}});BX.insertAfter(this.fake,this.parent.getTable());this.cloneDragItem=new BX.Grid.Row(this.parent,this.cloneDragItem);return this.fake},getDragStartRect:function(){return BX.pos(this.dragItem,this.parent.getTable())},_onDragStart:function(){this.dragItem=jsDD.current_node;this.targetItem=this.dragItem;this.additionalDragItems=this.getAdditionalDragItems(this.dragItem);this.dragIndex=this.getIndex(this.dragItem);this.dragRect=this.getRowRect(this.dragItem,this.dragIndex);this.offset=this.calcOffset();this.dragStartOffset=jsDD.start_y-this.dragRect.top;this.dragEvent=new BX.Grid.RowDragEvent;this.dragEvent.setEventName("BX.Main.grid:rowDragStart");this.dragEvent.setDragItem(this.dragItem);this.dragEvent.setTargetItem(this.targetItem);this.dragEvent.allowInsertBefore();var t=this.parent.getRows().get(this.dragItem);this.startDragDepth=t.getDepth();this.startDragParentId=t.getParentId();this.createFake();BX.addClass(this.parent.getContainer(),this.parent.settings.get("classOnDrag"));BX.addClass(this.dragItem,this.parent.settings.get("classDragActive"));BX.onCustomEvent(window,"BX.Main.grid:rowDragStart",[this.dragEvent,this.parent])},getAdditionalDragItems:function(t){var e=this.parent.getRows();return e.getRowsByParentId(e.get(t).getId(),true).map(function(t){return t.getNode()})},moveRow:function(t,e,r){if(!!t){var i=BX.type.isNumber(r)?r:300;t.style.transition=i+"ms";t.style.transform="translate3d(0px, "+e+"px, 0px)"}},getDragOffset:function(){return jsDD.y-this.dragRect.top-this.dragStartOffset},getWindowScrollTop:function(){if(this.windowScrollTop===null){this.windowScrollTop=BX.scrollTop(window)}return this.windowScrollTop},getSortOffset:function(){return jsDD.y},getRowRect:function(t,e){if(!this.rowsRectList){this.rowsRectList={};this.list.forEach(function(t,e){this.rowsRectList[e]=t.getBoundingClientRect()},this)}return this.rowsRectList[e]},getRowCenter:function(t,e){var r=this.getRowRect(t,e);return r.top+this.getWindowScrollTop()+r.height/2},isDragToBottom:function(t,e){var r=this.getRowCenter(t,e);var i=this.getSortOffset();return e>this.dragIndex&&r<i},isMovedToBottom:function(t){return t.style.transform==="translate3d(0px, "+-this.offset+"px, 0px)"},isDragToTop:function(t,e){var r=this.getRowCenter(t,e);var i=this.getSortOffset();return e<this.dragIndex&&r>i},isMovedToTop:function(t){return t.style.transform==="translate3d(0px, "+this.offset+"px, 0px)"},isDragToBack:function(t,e){var r=this.getRowCenter(t,e);var i=this.dragIndex;var s=jsDD.y;return e>i&&s<r||e<i&&s>r},isMoved:function(t){return t.style.transform!=="translate3d(0px, 0px, 0px)"&&t.style.transform!==""},_onDrag:function(){var t=0;var e=0;this.moveRow(this.dragItem,this.getDragOffset(),t);this.moveRow(this.fake,this.getDragOffset(),t);BX.Grid.Utils.styleForEach(this.additionalDragItems,{transition:t+"ms",transform:"translate3d(0px, "+this.getDragOffset()+"px, 0px)"});this.list.forEach(function(t,r){if(!!t&&t!==this.dragItem&&this.additionalDragItems.indexOf(t)===-1){if(this.isDragToTop(t,r)&&!this.isMovedToTop(t)){this.targetItem=t;this.moveRow(t,this.offset);this.dragEvent.setEventName("BX.Main.grid:rowDragMove");this.dragEvent.setTargetItem(this.targetItem);BX.onCustomEvent(window,"BX.Main.grid:rowDragMove",[this.dragEvent,this.parent]);this.checkError(this.dragEvent);this.updateProperties(this.dragItem,this.targetItem);this.isDragetToTop=true}if(this.isDragToBottom(t,r)&&!this.isMovedToBottom(t)){this.targetItem=this.findNextVisible(this.list,r);this.moveRow(t,-this.offset);this.dragEvent.setEventName("BX.Main.grid:rowDragMove");this.dragEvent.setTargetItem(this.targetItem);BX.onCustomEvent(window,"BX.Main.grid:rowDragMove",[this.dragEvent,this.parent]);this.checkError(this.dragEvent);this.updateProperties(this.dragItem,this.targetItem);this.isDragetToTop=false}if(this.isDragToBack(t,r)&&this.isMoved(t)){this.moveRow(t,e);this.targetItem=t;if(this.isDragetToTop){this.targetItem=this.findNextVisible(this.list,r)}this.dragEvent.setEventName("BX.Main.grid:rowDragMove");this.dragEvent.setTargetItem(this.targetItem);BX.onCustomEvent(window,"BX.Main.grid:rowDragMove",[this.dragEvent,this.parent]);this.checkError(this.dragEvent);this.updateProperties(this.dragItem,this.targetItem)}}},this)},createError:function(t,e){var r=BX.decl({block:"main-grid-error",content:!!e?e:""});!!t&&t.appendChild(r);setTimeout(function(){BX.addClass(r,"main-grid-error-show")},0);return r},checkError:function(t){if(!t.isAllowedMove()&&!this.error){this.error=this.createError(this.fake,t.getErrorMessage())}if(t.isAllowedMove()&&this.error){BX.remove(this.error);this.error=null}},findNextVisible:function(t,e){var r=null;var i=this.parent.getRows();t.forEach(function(t,s){if(!r&&s>e){var n=i.get(t);if(n.isShown()){r=t}}});return r},updateProperties:function(t,e){var r=this.parent.getRows();var i=r.get(t);var s=0;var n=0;if(!!e){var a=r.get(e);s=a.getDepth();n=a.getParentId()}i.setDepth(s);i.setParentId(n);this.cloneDragItem.setDepth(s);this.cloneDragAdditionalDragItemRows.forEach(function(t,e){t.setDepth(BX.data(this.additionalDragItems[e],"depth"))},this)},resetDragProperties:function(){var t=this.parent.getRows().get(this.dragItem);t.setDepth(this.startDragDepth);t.setParentId(this.startDragParentId)},_onDragOver:function(){},_onDragLeave:function(){},_onDragEnd:function(){BX.onCustomEvent(window,"BX.Main.grid:rowDragEnd",[this.dragEvent,this.parent]);BX.removeClass(this.parent.getContainer(),this.parent.settings.get("classOnDrag"));BX.removeClass(this.dragItem,this.parent.settings.get("classDragActive"));BX.Grid.Utils.styleForEach(this.list,{transition:"",transform:""});if(this.dragEvent.isAllowedMove()){this.sortRows(this.dragItem,this.targetItem);this.sortAdditionalDragItems(this.dragItem,this.additionalDragItems);this.list=this.getList();this.parent.getRows().reset();var t=this.parent.getRows().get(this.dragItem);var e=this.parent.getRows().getBodyChild().map(function(t){return t.getId()});this.saveRowsSort(e);BX.onCustomEvent(window,"Grid::rowMoved",[e,t,this.parent])}else{this.resetDragProperties()}BX.remove(this.fake);this.setDefaultProps()},sortAdditionalDragItems:function(t,e){e.reduce(function(t,e){!!e&&BX.insertAfter(e,t);return e},t)},sortRows:function(t,e){if(!!e){e.parentNode.insertBefore(t,e)}else{t.parentNode.appendChild(t)}},saveRowsSort:function(t){var e={ids:t,action:this.parent.getUserOptions().getAction("GRID_SAVE_ROWS_SORT")};this.parent.getData().request(null,"POST",e)},setDefaultProps:function(){this.dragItem=null;this.targetItem=null;this.dragRect=null;this.dragIndex=null;this.offset=null;this.realX=null;this.realY=null;this.dragStartOffset=null;this.windowScrollTop=null;this.rowsRectList=null;this.error=false}}})();
//# sourceMappingURL=rows-sortable.map.js