
CREATE TABLE b_location (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CODE varchar(100) NOT NULL,
  EXTERNAL_ID varchar(255),
  SOURCE_CODE varchar(15),
  LATITUDE decimal,
  LONGITUDE decimal,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  TYPE int NOT NULL,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_location_code ON b_location (code);
CREATE UNIQUE INDEX ux_b_location_external_id_source_code ON b_location (external_id, source_code);
CREATE INDEX ix_b_location_latitude ON b_location (latitude);
CREATE INDEX ix_b_location_longitude ON b_location (longitude);
CREATE INDEX ix_b_location_type ON b_location (type);

CREATE TABLE b_location_name (
  LOCATION_ID int NOT NULL,
  LANGUAGE_ID char(2) NOT NULL,
  NAME varchar(1000) NOT NULL,
  NAME_NORMALIZED varchar(1000) NOT NULL,
  PRIMARY KEY (LOCATION_ID, LANGUAGE_ID)
);
CREATE INDEX ix_b_location_name_name_normalized_language_id ON b_location_name (name_normalized, language_id);

CREATE TABLE b_location_hierarchy (
  ANCESTOR_ID int NOT NULL,
  DESCENDANT_ID int NOT NULL,
  LEVEL int NOT NULL,
  PRIMARY KEY (ANCESTOR_ID, DESCENDANT_ID)
);
CREATE INDEX ix_b_location_hierarchy_descendant_id ON b_location_hierarchy (descendant_id);

CREATE TABLE b_location_field (
  LOCATION_ID int NOT NULL,
  TYPE int NOT NULL,
  VALUE varchar(255),
  PRIMARY KEY (LOCATION_ID, TYPE)
);
CREATE INDEX ix_b_location_field_value ON b_location_field (value);

CREATE TABLE b_location_address (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  LOCATION_ID int DEFAULT 0,
  LANGUAGE_ID char(2) NOT NULL,
  LATITUDE decimal,
  LONGITUDE decimal,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_location_address_location_id ON b_location_address (location_id);

CREATE TABLE b_location_addr_fld (
  ADDRESS_ID int NOT NULL,
  TYPE int NOT NULL,
  VALUE varchar(1024),
  VALUE_NORMALIZED varchar(1024),
  PRIMARY KEY (ADDRESS_ID, TYPE)
);

CREATE TABLE b_location_addr_link (
  ADDRESS_ID int NOT NULL,
  ENTITY_ID varchar(100) NOT NULL,
  ENTITY_TYPE varchar(50) NOT NULL,
  PRIMARY KEY (ADDRESS_ID, ENTITY_ID, ENTITY_TYPE)
);
CREATE INDEX ix_b_location_addr_link_entity_id_entity_type ON b_location_addr_link (entity_id, entity_type);

CREATE TABLE b_location_source (
  CODE varchar(15) NOT NULL,
  NAME varchar(255) NOT NULL,
  CONFIG text,
  PRIMARY KEY (CODE)
);

CREATE TABLE b_location_area (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TYPE varchar(100) NOT NULL,
  CODE varchar(100) DEFAULT NULL,
  SORT int NOT NULL,
  GEOMETRY text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_location_area_type_code ON b_location_area (type, code);

CREATE TABLE b_location_recent_address (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  USER_ID int NOT NULL,
  ADDRESS text,
  USED_AT timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_location_recent_address_user_id_used_at ON b_location_recent_address (user_id, used_at);
CREATE INDEX ix_b_location_recent_address_used_at ON b_location_recent_address (used_at);

CREATE TABLE b_location_static_map_file (
	HASH char(40) NOT NULL,
	FILE_ID int NOT NULL,
	PRIMARY KEY (HASH)
);
