(function(){"use strict";BX.namespace("BX.Landing.UI.Panel");var t=BX.Landing.Utils.addClass;var e=BX.Landing.Utils.removeClass;BX.Landing.UI.Panel.Content=function(t,e){BX.Landing.UI.Panel.BasePanel.apply(this,arguments);this.layout.classList.remove("landing-ui-hide");this.data=Object.freeze(BX.type.isPlainObject(e)?e:{});this.layout.classList.add("landing-ui-panel-content");this.overlay=BX.Landing.UI.Panel.Content.createOverlay();this.overlay.classList.add(this.classHide);this.header=BX.Landing.UI.Panel.Content.createHeader();this.title=BX.Landing.UI.Panel.Content.createTitle();this.body=BX.Landing.UI.Panel.Content.createBody();this.footer=BX.Landing.UI.Panel.Content.createFooter();this.sidebar=BX.Landing.UI.Panel.Content.createSidebar();this.content=BX.Landing.UI.Panel.Content.createContent();this.scrollTarget=this.content;this.forms=new BX.Landing.UI.Collection.FormCollection;this.buttons=new BX.Landing.UI.Collection.ButtonCollection;this.sidebarButtons=new BX.Landing.UI.Collection.ButtonCollection;this.closeButton=new BX.Landing.UI.Button.BaseButton("close",{className:"landing-ui-panel-content-close",onClick:this.hide.bind(this),attrs:{title:BX.Landing.Loc.getMessage("LANDING_TITLE_OF_SLIDER_CLOSE")}});this.shouldAdjustTopPanelControls=this.shouldAdjustTopPanelControls!==false&&BX.Landing.Env.getInstance().getType()!=="EXTERNAL";if(!!e&&typeof e.className==="string"){this.layout.classList.add(e.className);this.overlay.classList.add(e.className+"-overlay")}this.header.appendChild(this.title);if(!!e&&typeof e.subTitle==="string"&&!!e.subTitle){this.subTitle=BX.create("div",{props:{className:"landing-ui-panel-content-subtitle"},html:e.subTitle});this.header.appendChild(this.subTitle);this.layout.classList.add("landing-ui-panel-content-with-subtitle")}this.body.appendChild(this.sidebar);this.body.appendChild(this.content);this.layout.appendChild(this.header);this.layout.appendChild(this.body);this.layout.appendChild(this.footer);this.layout.appendChild(this.closeButton.layout);if(typeof window.onwheel!=="undefined"){this.wheelEventName="wheel"}else if(typeof window.onmousewheel!=="undefined"){this.wheelEventName="mousewheel"}this.init();var n=BX.Landing.PageObject.getRootWindow();n.addEventListener("keydown",this.onKeydown.bind(this));BX.Landing.PageObject.getInstance().view().then(function(t){void(!!t&&t.contentWindow.addEventListener("keydown",this.onKeydown.bind(this)))}.bind(this),console.warn);if(this.data.scrollAnimation){this.scrollObserver=new IntersectionObserver(this.onIntersecting.bind(this))}};BX.Landing.UI.Panel.Content.createOverlay=function(){return BX.create("div",{props:{className:"landing-ui-panel-content-overlay landing-ui-hide"},attrs:{"data-is-shown":"false",hidden:true}})};BX.Landing.UI.Panel.Content.createHeader=function(){return BX.create("div",{props:{className:["landing-ui-panel-content-element","landing-ui-panel-content-header"].join(" ")}})};BX.Landing.UI.Panel.Content.createTitle=function(){return BX.create("div",{props:{className:"landing-ui-panel-content-title"}})};BX.Landing.UI.Panel.Content.createBody=function(){return BX.create("div",{props:{className:["landing-ui-panel-content-element","landing-ui-panel-content-body"].join(" ")}})};BX.Landing.UI.Panel.Content.createSidebar=function(){return BX.create("div",{props:{className:"landing-ui-panel-content-body-sidebar"}})};BX.Landing.UI.Panel.Content.createContent=function(){return BX.create("div",{props:{className:"landing-ui-panel-content-body-content"}})};BX.Landing.UI.Panel.Content.createFooter=function(){return BX.create("div",{props:{className:["landing-ui-panel-content-element","landing-ui-panel-content-footer"].join(" ")}})};BX.Landing.UI.Panel.Content.calculateTransitionDuration=function(t){var e=300;t=parseInt(t);t=t===t?t:0;return Math.min(400/500*t,e)};BX.Landing.UI.Panel.Content.scrollTo=function(t,e){return new Promise((function(n){var i=0;var a=0;if(e){var o=20;var s=Math.max(parseInt(BX.style(e,"margin-top")),o);var l=t.scrollTop;if(!(t instanceof HTMLIFrameElement)){i=e.offsetTop-(t.offsetTop||0)-s}else{l=t.contentWindow.scrollY;i=BX.pos(e).top-s-100}a=BX.Landing.UI.Panel.Content.calculateTransitionDuration(Math.abs(i-l));var d=Math.max(l,0);var r=Math.max(i,0);if(d!==r){new BX.easing({duration:a,start:{scrollTop:d},finish:{scrollTop:r},step:function(e){if(!(t instanceof HTMLIFrameElement)){t.scrollTop=e.scrollTop}else{t.contentWindow.scrollTo(0,Math.max(e.scrollTop,0))}}.bind(this)}).animate();setTimeout(n,a)}else{n()}}else{n()}}))};BX.Landing.UI.Panel.Content.getDeltaFromEvent=function(t){var e=t.deltaX;var n=-1*t.deltaY;if(typeof e==="undefined"||typeof n==="undefined"){e=-1*t.wheelDeltaX/6;n=t.wheelDeltaY/6}if(t.deltaMode&&t.deltaMode===1){e*=10;n*=10}if(e!==e&&n!==n){e=0;n=t.wheelDelta}return{x:e,y:n}};BX.Landing.UI.Panel.Content.prototype={constructor:BX.Landing.UI.Panel.Content,__proto__:BX.Landing.UI.Panel.BasePanel.prototype,init:function(){document.body.appendChild(this.overlay);this.overlay.addEventListener("click",this.hide.bind(this));this.layout.addEventListener("mouseenter",this.onMouseEnter.bind(this));this.layout.addEventListener("mouseleave",this.onMouseLeave.bind(this));this.content.addEventListener("mouseenter",this.onMouseEnter.bind(this));this.content.addEventListener("mouseleave",this.onMouseLeave.bind(this));this.sidebar.addEventListener("mouseenter",this.onMouseEnter.bind(this));this.sidebar.addEventListener("mouseleave",this.onMouseLeave.bind(this));this.header.addEventListener("mouseenter",this.onMouseEnter.bind(this));this.header.addEventListener("mouseleave",this.onMouseLeave.bind(this));this.footer.addEventListener("mouseenter",this.onMouseEnter.bind(this));this.footer.addEventListener("mouseleave",this.onMouseLeave.bind(this));requestAnimationFrame(function(){if(this.right){this.right.addEventListener("mouseenter",this.onMouseEnter.bind(this));this.right.addEventListener("mouseleave",this.onMouseLeave.bind(this))}}.bind(this));if("title"in this.data){this.setTitle(this.data.title)}if("footer"in this.data){if(BX.type.isArray(this.data.footer)){this.data.footer.forEach((function(t){if(t instanceof BX.Landing.UI.Button.BaseButton){this.appendFooterButton(t)}if(BX.type.isDomNode(t)){this.footer.appendChild(t)}}),this)}}},onIntersecting:function(n){n.forEach((function(n){if(n.isIntersecting){e(n.target,"landing-ui-is-not-visible");t(n.target,"landing-ui-is-visible")}else{t(n.target,"landing-ui-is-not-visible");e(n.target,"landing-ui-is-visible")}}))},onKeydown:function(t){if(t.keyCode===27){this.hide()}},onMouseEnter:function(t){t.stopPropagation();BX.bind(this.layout,this.wheelEventName,BX.proxy(this.onMouseWheel,this));BX.bind(this.layout,"touchmove",BX.proxy(this.onMouseWheel,this));if(this.sidebar.contains(t.target)||this.content.contains(t.target)||this.header.contains(t.target)||this.footer.contains(t.target)||this.right&&this.right.contains(t.target)){this.scrollTarget=t.currentTarget}},onMouseLeave:function(t){t.stopPropagation();BX.unbind(this.layout,this.wheelEventName,BX.proxy(this.onMouseWheel,this));BX.unbind(this.layout,"touchmove",BX.proxy(this.onMouseWheel,this))},onMouseWheel:function(t){t.preventDefault();t.stopPropagation();var e=BX.Landing.UI.Panel.Content.getDeltaFromEvent(t);var n=this.scrollTarget.scrollTop;requestAnimationFrame(function(){this.scrollTarget.scrollTop=n-e.y}.bind(this))},scrollTo:function(t){BX.Landing.UI.Panel.Content.scrollTo(this.content,t)},isShown:function(){return this.state==="shown"},show:function(){if(!this.isShown()){if(this.shouldAdjustTopPanelControls){BX.Landing.UI.Panel.Top.getInstance().disableHistory();BX.Landing.UI.Panel.Top.getInstance().disableDevices()}void BX.Landing.Utils.Show(this.overlay);return BX.Landing.Utils.Show(this.layout).then(function(){this.state="shown"}.bind(this))}return Promise.resolve(true)},hide:function(){var t=Promise.resolve(true);if(this.isShown()){if(this.shouldAdjustTopPanelControls){BX.Landing.UI.Panel.Top.getInstance().enableHistory();BX.Landing.UI.Panel.Top.getInstance().enableDevices()}void BX.Landing.Utils.Hide(this.overlay);return BX.Landing.Utils.Hide(this.layout).then(function(){this.state="hidden"}.bind(this))}return t},appendForm:function(t){this.forms.add(t);this.content.appendChild(t.getNode())},appendCard:function(e){if(this.data.scrollAnimation){t(e.layout,"landing-ui-is-not-visible");this.scrollObserver.observe(e.layout)}this.content.appendChild(e.layout)},clear:function(){this.clearContent();this.clearSidebar();this.forms.clear()},clearContent:function(){this.content.innerHTML=""},clearSidebar:function(){this.sidebar.innerHTML=""},setTitle:function(t){this.title.innerHTML=t},appendFooterButton:function(t){this.buttons.add(t);this.footer.appendChild(t.layout)},appendSidebarButton:function(t){this.sidebarButtons.add(t);this.sidebar.appendChild(t.layout)}}})();
//# sourceMappingURL=content_panel.map.js