(function(){"use strict";BX.namespace("BX.Landing.UI.Field");var e=BX.Landing.Utils.isBoolean;var t=BX.Landing.Utils.isArray;var i=BX.Landing.Utils.isString;var n=BX.Landing.Utils.isEmpty;var a=BX.Landing.Utils.append;var s=BX.Landing.Utils.remove;var l=BX.Landing.Utils.data;var o=BX.Landing.Utils.attr;var r=BX.Landing.Utils.addClass;var c=BX.Landing.Utils.removeClass;var h=BX.Landing.Utils.proxy;var d=BX.Landing.Utils.htmlToElement;var u=BX.Landing.Utils.bind;var g=BX.Landing.Utils.unbind;var L=BX.Landing.Utils.join;var p=BX.Landing.Utils.fireEvent;var f=BX.Landing.Utils.hash;var m=BX.Landing.Utils.encodeDataValue;var y=BX.Landing.Utils.capitalize;var b=BX.Landing.Utils.style;var B=BX.Landing.UI.Button.BaseButton;var T=BX.Landing.UI.Field.Dropdown;var I="block";var v="alias";var _="landing";var k="crmFormPopup";var E="crmPhone";var w="system";var P="catalog";var X="element";var N="section";var S="diskFile";var U="";var D="tel:";var C="skype:";var F="sms:";var R="mailto:";var H={catalog:new RegExp("^#catalog#(Element|Section)([0-9]+)"),catalogElement:new RegExp("^#catalogElement([0-9]+)"),catalogSection:new RegExp("^#catalogSection([0-9]+)"),block:new RegExp("^#block([0-9]+)"),page:new RegExp("^#landing([0-9]+)"),crmForm:new RegExp("^#crmFormPopup([0-9]+)"),crmPhone:new RegExp("^#crmPhone([0-9]+)"),diskFile:new RegExp("^#diskFile([0-9]+)"),system:new RegExp("^#system_[a-z_-]+"),alias:new RegExp("^#.*")};BX.Landing.UI.Field.LinkURL=function(i){BX.Landing.UI.Field.Text.apply(this,arguments);r(this.layout,"landing-ui-field-link-url");this.requestOptions=i.options||{};this.allowedTypes=t(i.allowedTypes)?i.allowedTypes:[I,_];this.disableBlocks=e(i.disableBlocks)?i.disableBlocks:false;this.disableCustomURL=e(i.disableCustomURL)?i.disableCustomURL:false;this.disallowType=e(i.disallowType)?i.disallowType:false;this.iblocks=t(i.iblocks)?i.iblocks:null;this.allowedCatalogEntityTypes=t(i.allowedCatalogEntityTypes)?i.allowedCatalogEntityTypes:null;this.onInitHandler=BX.type.isFunction(i.onInit)?i.onInit:function(){};this.onNewPageHandler=BX.type.isFunction(i.onNewPage)?i.onNewPage:function(){};this.enableAreas=i.enableAreas;this.customPlaceholder=i.customPlaceholder;this.detailPageMode=i.detailPageMode===true;this.sourceField=i.sourceField;this.currentPageOnly=i.currentPageOnly;this.panelTitle=i.panelTitle;this.onListShow=this.onListShow.bind(this,this.requestOptions);this.onSelectButtonClick=this.onSelectButtonClick.bind(this);this.onTypeChange=this.onTypeChange.bind(this);this.onListItemClick=this.onListItemClick.bind(this);this.popup=null;this.dynamic=null;this.value=null;this.button=this.createButton();this.hrefTypeSwithcer=this.createTypeSwitcher();this.grid=this.createGridLayout();this.gridLeftCell=this.grid.querySelector('[class*="left"]');this.gridCenterCell=this.grid.querySelector('[class*="center"]');this.gridRightCell=this.grid.querySelector('[class*="right"]');s(this.hrefTypeSwithcer.header);a(this.hrefTypeSwithcer.layout,this.gridLeftCell);a(this.input,this.gridCenterCell);a(this.button.layout,this.gridRightCell);a(this.grid,this.layout);this.setHrefPlaceholderByType(this.getHrefStringType());this.setHrefTypeSwitcherValue(this.getHrefStringType());this.removeHrefTypeFromHrefString();this.makeDisplayedHrefValue();if(this.disallowType){void b(this.gridLeftCell,{display:"none"})}};BX.Landing.UI.Field.LinkURL.cache=new BX.Cache.MemoryCache;BX.Landing.UI.Field.LinkURL.TYPE_BLOCK=I;BX.Landing.UI.Field.LinkURL.TYPE_PAGE=_;BX.Landing.UI.Field.LinkURL.TYPE_CRM_FORM=k;BX.Landing.UI.Field.LinkURL.TYPE_CRM_PHONE=E;BX.Landing.UI.Field.LinkURL.TYPE_CATALOG=P;BX.Landing.UI.Field.LinkURL.TYPE_CATALOG_ELEMENT=X;BX.Landing.UI.Field.LinkURL.TYPE_CATALOG_SECTION=N;BX.Landing.UI.Field.LinkURL.TYPE_DISK_FILE=S;BX.Landing.UI.Field.LinkURL.matchers=H;BX.Landing.UI.Field.LinkURL.prototype={constructor:BX.Landing.UI.Field.LinkURL,__proto__:BX.Landing.UI.Field.Text.prototype,setIblocks:function(e){this.iblocks=t(e)?e:null},makeDisplayedHrefValue:function(){var e=this.getValue();var t=this.getPlaceholderType();var i;switch(t){case I:i=this.getBlockData(e);break;case _:i=this.getPageData(e);break;case k:i=this.getCrmFormData(e);break;case E:i=this.getCrmPhoneData(e);break;case X:i=this.getCatalogElementData(e);break;case N:i=this.getCatalogSectionData(e);break;case S:i=this.getDiskFileData(e);break;case w:i=this.getSystemPage(e);break}if(i){i.then(h(this.createPlaceholder,this)).then(function(e){this.setValue(e,true);if(!this.inited){this.inited=true;this.onInitHandler()}return e}.bind(this)).catch((function(){}));this.disableHrefTypeSwitcher();this.setHrefTypeSwitcherValue(U)}this.enableHrefTypeSwitcher()},getPlaceholderData:function(e){e=e||this.getValue();var t=this.getPlaceholderType(e);var i=Promise.resolve({});switch(t){case I:i=this.getBlockData(e);break;case _:i=this.getPageData(e);break;case X:i=this.getCatalogElementData(e);break;case N:i=this.getCatalogSectionData(e);break;case S:i=this.getDiskFileData(e);break;case w:i=this.getSystemPage(e);break}return i},removeHrefTypeFromHrefString:function(){var e=this.getValue().replace(new RegExp(this.getHrefStringType(),"g"),"");this.setValue(e,true)},setHrefTypeSwitcherValue:function(e){this.hrefTypeSwithcer.setValue(e)},disableHrefTypeSwitcher:function(){this.hrefTypeSwithcer.disable()},enableHrefTypeSwitcher:function(){this.hrefTypeSwithcer.enable()},getSelectedHrefType:function(){return this.hrefTypeSwithcer.getValue()},getHrefStringType:function(){var e=this.getValue().split(":")[0];var t=U;switch(L(e,":")){case D:t=D;break;case F:t=F;break;case C:t=C;break;case R:t=R;break}return t},setHrefPlaceholderByType:function(e){var t=this.placeholder||BX.Landing.Loc.getMessage("FIELD_LINK_HREF_PLACEHOLDER");switch(e){case U:if(this.disableBlocks&&this.disableCustomURL){t=BX.Landing.Loc.getMessage("FIELD_LINK_HREF_PLACEHOLDER_PAGES_ONLY")}if(!this.disableBlocks&&this.disableCustomURL){t=BX.Landing.Loc.getMessage("FIELD_LINK_HREF_PLACEHOLDER_WITHOUT_CUSTOM_URL")}if(this.allowedTypes.length===1&&this.allowedTypes[0]===P){t=BX.Landing.Loc.getMessage("FIELD_LINK_HREF_PLACEHOLDER_CATALOG_ONLY")}if(this.customPlaceholder){t=this.customPlaceholder}break;case D:t=BX.Landing.Loc.getMessage("LANDING_LINK_FIELD_URL_TYPE_PHONE_PLACEHOLDER");break;case C:t=BX.Landing.Loc.getMessage("LANDING_LINK_FIELD_URL_TYPE_SKYPE_PLACEHOLDER");break;case F:t=BX.Landing.Loc.getMessage("LANDING_LINK_FIELD_URL_TYPE_SMS_PLACEHOLDER");break;case R:t=BX.Landing.Loc.getMessage("LANDING_LINK_FIELD_URL_TYPE_EMAIL_PLACEHOLDER");break}l(this.input,"data-placeholder",t)},getPlaceholderType:function(e){e=e||this.getValue();if(H.block.test(e)){return I}if(H.page.test(e)){return _}if(H.crmForm.test(e)){return k}if(H.crmPhone.test(e)){return E}if(H.catalogElement.test(e)){return X}if(H.catalogSection.test(e)){return N}if(H.diskFile.test(e)){return S}if(H.system.test(e)){return w}if(H.alias.test(e)){return v}return U},containsPlaceholder:function(){return this.input.innerHTML.indexOf("span")!==-1},createGridLayout:function(){return d('<div class="landing-ui-field-link-url-grid">'+'<div class="landing-ui-field-link-url-grid-left"></div>'+'<div class="landing-ui-field-link-url-grid-center"></div>'+'<div class="landing-ui-field-link-url-grid-right"></div>'+"</div>")},createTypeSwitcher:function(){return new T({items:[{name:BX.Landing.Loc.getMessage("LANDING_LINK_FIELD_URL_TYPE_LINK"),value:U},{name:BX.Landing.Loc.getMessage("LANDING_LINK_FIELD_URL_TYPE_PHONE"),value:D},{name:BX.Landing.Loc.getMessage("LANDING_LINK_FIELD_URL_TYPE_SKYPE"),value:C},{name:BX.Landing.Loc.getMessage("LANDING_LINK_FIELD_URL_TYPE_SMS"),value:F},{name:BX.Landing.Loc.getMessage("LANDING_LINK_FIELD_URL_TYPE_EMAIL"),value:R}],onValueChange:this.onTypeChange})},createButton:function(){return new B("dropdown_button",{text:BX.Landing.Loc.getMessage("LINK_URL_SUGGESTS_SELECT"),className:"landing-ui-button-select-link",onClick:this.onSelectButtonClick})},onTypeChange:function(e){var t=e.getValue();switch(t){case U:g(this.gridRightCell,"mouseover",h(this.onButtonMouseover,this));g(this.gridRightCell,"mouseout",h(this.onButtonMouseout,this));this.button.enable();break;case D:case F:case C:case R:u(this.gridRightCell,"mouseover",h(this.onButtonMouseover,this));u(this.gridRightCell,"mouseout",h(this.onButtonMouseout,this));this.button.disable();break}this.setHrefPlaceholderByType(t)},onButtonMouseover:function(){this.customTypeSuggestTimeout=setTimeout(function(){BX.Landing.UI.Tool.Suggest.getInstance().show(this.button.layout,{description:BX.Landing.Loc.getMessage("LANDING_LINK_FIELD_URL_TYPE_CUSTOM_BUTTON_TITLE")});this.pulseTimeout=setTimeout(function(){r(this.hrefTypeSwithcer.input,"landing-ui-pulse")}.bind(this),1e3)}.bind(this),100)},onButtonMouseout:function(){clearTimeout(this.customTypeSuggestTimeout);BX.Landing.UI.Tool.Suggest.getInstance().hide();clearTimeout(this.pulseTimeout);c(this.hrefTypeSwithcer.input,"landing-ui-pulse")},getBlockData:function(e){return BX.Landing.Backend.getInstance().getBlock({blockId:e.replace("#block","")}).then((function(e){return e.type="block",e}))},getPageData:function(e){return BX.Landing.UI.Field.LinkURL.cache.remember(e,function(){var t=parseInt(e.replace("#landing",""));return BX.Landing.Backend.getInstance().getLanding({landingId:t}).then(function(e){if(!e){if(BX.Text.toNumber(t)===0){this.onNewPageHandler();return{type:"landing",id:0,name:BX.Landing.Loc.getMessage("LANDING_LINK_PLACEHOLDER_NEW_PAGE"),siteId:BX.Landing.Main.getInstance().options.site_id}}else{return null}}return{type:"landing",id:e.ID,name:e.TITLE,siteId:e.SITE_ID}}.bind(this))}.bind(this))},getCrmFormData:function(e){return BX.Landing.UI.Field.LinkURL.cache.remember(e,function(){var t=e.replace("#crmFormPopup","");return BX.Landing.Backend.getInstance().action("Form::getList").then(function(e){var i=e.find((function(e){return String(e.ID)===String(t)}));if(i){return{type:"crmFormPopup",id:i.ID,name:i.NAME}}return null}.bind(this))}.bind(this))},getCrmPhoneData:function(e){return new Promise(function(t){var i=e.replace("#crmPhone","");var n=BX.Landing.Env.getInstance().getOptions().references.find((function(e){return String(e.value)===String(i)}));if(n){t({type:"crmPhone",id:n.value,name:n.text})}else{t(null)}}.bind(this))},getSystemPage:function(e){return BX.Landing.UI.Field.LinkURL.cache.remember(e,function(){var e=this.content.replace("#system_","");var t=BX.Landing.Main.getInstance().options.syspages;if(e in t){return Promise.resolve({type:"system",id:"_"+e,name:t[e].name})}return Promise.reject()}.bind(this))},getCatalogElementData:function(e){return BX.Landing.UI.Field.LinkURL.cache.remember(e,function(){var t=e.match(H.catalogElement)[1];var i={elementId:t};return BX.Landing.Backend.getInstance().action("Utils::getCatalogElement",i)}.bind(this))},getCatalogSectionData:function(e){return BX.Landing.UI.Field.LinkURL.cache.remember(e,function(){var t=e.match(H.catalogSection)[1];var i={sectionId:t};return BX.Landing.Backend.getInstance().action("Utils::getCatalogSection",i)}.bind(this))},getDiskFileData:function(e){return BX.Landing.UI.Field.LinkURL.cache.remember(e,function(){var t=e.replace("#diskFile","");return BX.Landing.Backend.getInstance().action("Block::getFileDisk",{fileId:t}).then(function(e){if(e){return{type:S,id:e.ID,name:e.NAME}}return null}.bind(this))}.bind(this))},createPopup:function(){var e=[];if(this.allowedTypes.includes(I)){e.push({text:BX.Landing.Loc.getMessage("LANDING_LINKS_BUTTON_BLOCKS"),onclick:this.onListShow.bind(this,I)})}if(this.allowedTypes.includes(_)){e.push({text:BX.Landing.Loc.getMessage("LANDING_LINKS_BUTTON_LANDINGS"),onclick:this.onListShow.bind(this,_)})}if(this.allowedTypes.includes(k)){e.push({text:BX.Landing.Loc.getMessage("LANDING_LINKS_BUTTON_FORMS"),onclick:this.onListShow.bind(this,k)})}if(this.allowedTypes.includes(E)){e.push({text:BX.Landing.Loc.getMessage("LANDING_LINKS_BUTTON_PHONES"),onclick:this.onListShow.bind(this,E)})}if(this.allowedTypes.includes(P)){e.push({text:BX.Landing.Loc.getMessage("LANDING_LINKS_BUTTON_CATALOG"),onclick:this.onListShow.bind(this,P)})}if(this.allowedTypes.includes(S)){e.push({text:BX.Landing.Loc.getMessage("LANDING_LINKS_BUTTON_DISK_FILE"),onclick:this.onDiskFileShow.bind(this)})}this.popup=new BX.PopupMenuWindow({id:"link_list_"+ +new Date,bindElement:this.button.layout,targetContainer:this.contentRoot,items:e,autoHide:true,events:{onPopupClose:this.button.deactivate.bind(this.button)}});if(!this.contentRoot){a(this.popup.popupWindow.popupContainer,this.button.layout.parentNode)}return this.popup},onSelectButtonClick:function(){if(this.allowedTypes.length===1){this.onListShow(this.allowedTypes[0]);return}this.popup=this.popup||this.createPopup();this.button.enable();this.popup.show();var e=BX.pos(this.button.layout,this.button.layout.parentNode);this.popup.popupWindow.popupContainer.style.top=e.bottom+"px";this.popup.popupWindow.popupContainer.style.left="auto";this.popup.popupWindow.popupContainer.style.right="0"},onListShow:function(e,i){if(this.popup){this.popup.close()}if(i===P){var n=this.iblocks;if(!t(n)){n=BX.Landing.Main.getInstance().options.iblocks}void BX.Landing.UI.Panel.Catalog.getInstance().show(n,this.allowedCatalogEntityTypes).then(this.onListItemClick);return}e.enableAreas=this.enableAreas;e.dynamicMode=true;e.currentPageOnly=this.currentPageOnly;e.panelTitle=this.panelTitle;if(this.detailPageMode){e.source=this.sourceField.getValue().source;void BX.Landing.UI.Panel.DetailPage.getInstance().show(e).then(this.onListItemClick)}else{var a=BX.Landing.UI.Panel.URLList.getInstance();void a.show(i,e).then(this.onListItemClick)}},onDiskFileShow:function(){if(this.popup){this.popup.close()}var e="/bitrix/tools/disk/uf.php?action=selectFile&dialog2=Y&SITE_ID="+BX.message("SITE_ID");var t="LandingDiskFile";BX.ajax.get(e,"multiselect=N&dialogName="+t,BX.delegate((function(){setTimeout(BX.delegate((function(){BX.DiskFileDialog.obElementBindPopup[t].overlay={backgroundColor:"#cdcdcd",opacity:".1"};BX.DiskFileDialog.obCallback[t]={saveButton:function(e,t,i){var n=i[Object.keys(i)[0]];if(!n){return}var a=n.id;if(a[0]==="n"){a=a.substr(1)}this.getDiskFileData("#diskFile"+a).then(function(e){this.setValue(this.createPlaceholder(e),true)}.bind(this));this.setHrefTypeSwitcherValue(U);this.disableHrefTypeSwitcher()}.bind(this)};BX.DiskFileDialog.openDialog(t)}),this),10)}),this))},isEditPrevented:function(){if(!e(this.editPrevented)){this.editPrevented=this.disableCustomURL||this.containsPlaceholder()}return this.editPrevented},setEditPrevented:function(e){this.editPrevented=e},enableEdit:function(){if(!this.isEditPrevented()&&!this.disableCustomURL){BX.Landing.UI.Field.Text.prototype.enableEdit.apply(this)}},createPlaceholder:function(e){if(i(e)){return e}var t=d('<span class="landing-ui-field-url-placeholder">'+'<span class="landing-ui-field-url-placeholder-preview"></span>'+'<span class="landing-ui-field-url-placeholder-text">'+m(e.name)+"</span>"+'<span class="landing-ui-field-url-placeholder-delete"></span>'+"</span>");const a=t.querySelector('[class*="delete"]');BX.Event.bind(a,"click",h(this.onPlaceholderRemoveClick,this));if(!n(e.image)&&i(e.image)){var s=t.querySelector('[class*="preview"]');o(s,{style:"background-image: url('"+e.image+"')"});if(e.subType===N){r(s,"section")}}if(e.type===P){e.chain.push(e.name);var l=L(e.name,"\n",e.chain.join(" / "));o(t,{"data-dynamic":{type:L(P,y(e.subType)),value:e.id},"data-placeholder":L("#",e.type,y(e.subType),e.id),"data-url":L("#",e.type,y(e.subType),e.id)});t.setAttribute("title",l);return t}o(t,{"data-placeholder":L("#",e.type,e.id),"data-url":L("#",e.type,e.id)});t.setAttribute("title",e.name);return t},onPlaceholderRemoveClick:function(e){this.setEditPrevented(false);this.enableEdit();s(e.target.parentNode);this.setValue("");p(this.layout,"input");this.onInputHandler(this.input.innerText)},onListItemClick:function(e){var t=Promise.resolve(e);if(e.type==="block"){t=this.getBlockData("#block"+e.id)}t.then(function(e){this.setValue(this.createPlaceholder(e));this.disableHrefTypeSwitcher();this.setHrefTypeSwitcherValue(U);p(this.layout,"input")}.bind(this))},getNewLabel:function(){if(!this.newLabel){this.newLabel=BX.create({tag:"div",props:{className:"landing-ui-field-link-new-label"},text:BX.Landing.Loc.getMessage("LANDING_LINK_NEW_PAGE_LABEL")})}return this.newLabel},showNewLabel:function(){BX.Dom.style(this.gridCenterCell,{position:"relative",overflow:"visible"});BX.Dom.append(this.getNewLabel(),this.gridCenterCell)},hideNewLabel:function(){BX.Dom.style(this.gridCenterCell,"overflow",null);BX.Dom.remove(this.getNewLabel())},setValue:function(e,t){if(typeof e==="object"&&!BX.Type.isNil(e)){this.disableEdit();this.setEditPrevented(true);this.input.innerHTML="";a(e,this.input);this.value=e.dataset.placeholder;this.dynamic=e.dataset.dynamic;if(this.value==="#landing0"){this.showNewLabel()}else{this.hideNewLabel()}if(!t){this.onInputHandler(this.input.innerText)}}else if(!BX.Type.isNil(e)){this.setEditPrevented(false);this.input.innerText=e.toString().trim();this.value=null;this.dynamic=null;this.enableHrefTypeSwitcher();this.hideNewLabel()}if(!t){if(BX.type.isString(this.value)){this.getPlaceholderData(this.value).then(function(e){this.onValueChangeHandler(e)}.bind(this)).catch((function(){}));return}this.onValueChangeHandler(null)}},getDynamic:function(){return this.dynamic},getValue:function(){var e=this.value?this.value:this.input.innerText;if(e.includes(":")){return e}return this.getSelectedHrefType()+e}}})();
//# sourceMappingURL=link_url_field.map.js