CREATE TABLE b_landing
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	CODE varchar(255) DEFAULT null,
	INITIATOR_APP_CODE varchar(255) DEFAULT null,
	RULE varchar(255) DEFAULT null,
	ACTIVE char(1) NOT NULL DEFAULT 'Y',
	DELETED char(1) NOT NULL DEFAULT 'N',
	PUBLIC char(1) NOT NULL DEFAULT 'Y',
	SYS char(1) NOT NULL DEFAULT 'N',
	VIEWS int NOT NULL DEFAULT 0,
	TITLE varchar(255) NOT NULL,
	XML_ID varchar(255) DEFAULT null,
	DESCRIPTION varchar(255) DEFAULT null,
	TPL_ID int,
	TPL_CODE varchar(255) DEFAULT null,
	SITE_ID int NOT NULL,
	SITEMAP char(1) NOT NULL DEFAULT 'N',
	FOLDER char(1) NOT NULL DEFAULT 'N',
	FOLDER_ID int,
	SEARCH_CONTENT text DEFAULT null,
	VERSION int NOT NULL DEFAULT 1,
	HISTORY_STEP int NOT NULL DEFAULT 0,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	DATE_PUBLIC timestamp DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_code ON b_landing (code);
CREATE INDEX ix_b_landing_active ON b_landing (active);
CREATE INDEX ix_b_landing_deleted ON b_landing (deleted);
CREATE INDEX ix_b_landing_sys ON b_landing (sys);
CREATE INDEX ix_b_landing_xml_id ON b_landing (xml_id);
CREATE INDEX ix_b_landing_site_id ON b_landing (site_id);
CREATE INDEX ix_b_landing_sitemap ON b_landing (sitemap);
CREATE INDEX ix_b_landing_folder ON b_landing (folder);
CREATE INDEX ix_b_landing_folder_id ON b_landing (folder_id);

CREATE TABLE b_landing_block
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	PARENT_ID int DEFAULT null,
	LID int NOT NULL,
	CODE varchar(255) NOT NULL,
	TPL_CODE varchar(255) DEFAULT null,
	XML_ID varchar(255) DEFAULT null,
	INITIATOR_APP_CODE varchar(255) NOT NULL,
	ANCHOR varchar(255),
	SORT int DEFAULT 500,
	ACTIVE char(1) NOT NULL DEFAULT 'Y',
	PUBLIC char(1) NOT NULL DEFAULT 'Y',
	DELETED char(1) NOT NULL DEFAULT 'N',
	DESIGNED char(1) NOT NULL DEFAULT 'N',
	ACCESS char(1) NOT NULL DEFAULT 'X',
	SOURCE_PARAMS text DEFAULT null,
	CONTENT text NOT NULL,
	SEARCH_CONTENT text DEFAULT null,
	ASSETS text DEFAULT null,
	FAVORITE_META text DEFAULT null,
	HISTORY_STEP_DESIGNER int NOT NULL DEFAULT 0,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_block_lid ON b_landing_block (lid);
CREATE INDEX ix_b_landing_block_lid_public ON b_landing_block (lid, public);
CREATE INDEX ix_b_landing_block_code ON b_landing_block (code);
CREATE INDEX ix_b_landing_block_active ON b_landing_block (active);
CREATE INDEX ix_b_landing_block_public_date_create ON b_landing_block (public, date_create);
CREATE INDEX ix_b_landing_block_deleted ON b_landing_block (deleted);

CREATE TABLE b_landing_site
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	CODE varchar(255) NOT NULL,
	ACTIVE char(1) NOT NULL DEFAULT 'Y',
	DELETED char(1) NOT NULL DEFAULT 'N',
	TITLE varchar(255) NOT NULL,
	XML_ID varchar(255) DEFAULT null,
	DESCRIPTION varchar(255) DEFAULT null,
	TYPE varchar(50) NOT NULL DEFAULT 'PAGE',
	TPL_ID int,
	TPL_CODE varchar(255) DEFAULT null,
	DOMAIN_ID int NOT NULL,
	SMN_SITE_ID char(2) DEFAULT null,
	LANDING_ID_INDEX int DEFAULT null,
	LANDING_ID_404 int DEFAULT null,
	LANDING_ID_503 int DEFAULT null,
	LANG char(2) DEFAULT null,
	SPECIAL char(1) NOT NULL DEFAULT 'N',
	VERSION int DEFAULT null,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_site_code ON b_landing_site (code);
CREATE INDEX ix_b_landing_site_active ON b_landing_site (active);
CREATE INDEX ix_b_landing_site_deleted ON b_landing_site (deleted);
CREATE INDEX ix_b_landing_site_xml_id ON b_landing_site (xml_id);
CREATE INDEX ix_b_landing_site_special ON b_landing_site (special);

CREATE TABLE b_landing_domain
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	ACTIVE char(1) NOT NULL DEFAULT 'Y',
	DOMAIN varchar(255) NOT NULL,
	PREV_DOMAIN varchar(255) DEFAULT null,
	XML_ID varchar(255) DEFAULT null,
	PROTOCOL varchar(10) NOT NULL,
	PROVIDER varchar(50) DEFAULT null,
	FAIL_COUNT int DEFAULT null,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_domain_active ON b_landing_domain (active);
CREATE INDEX ix_b_landing_domain_domain ON b_landing_domain (domain);
CREATE INDEX ix_b_landing_domain_provider ON b_landing_domain (provider);
CREATE INDEX ix_b_landing_domain_xml_id ON b_landing_domain (xml_id);

CREATE TABLE b_landing_template
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	ACTIVE char(1) NOT NULL DEFAULT 'Y',
	TITLE varchar(255) NOT NULL,
	SORT int DEFAULT 100,
	XML_ID varchar(255) DEFAULT null,
	CONTENT text NOT NULL,
	AREA_COUNT int NOT NULL,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);

CREATE TABLE b_landing_template_ref
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	ENTITY_ID int NOT NULL,
	ENTITY_TYPE char(1) NOT NULL,
	AREA int NOT NULL,
	LANDING_ID int NOT NULL,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_template_ref_landing_id ON b_landing_template_ref (landing_id);
CREATE INDEX ix_b_landing_template_ref_entity_id_entity_type ON b_landing_template_ref (entity_id, entity_type);

CREATE TABLE b_landing_repo
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	XML_ID varchar(255) NOT NULL,
	APP_CODE varchar(255) DEFAULT null,
	ACTIVE char(1) NOT NULL DEFAULT 'Y',
	NAME varchar(255) NOT NULL,
	DESCRIPTION varchar(255) DEFAULT null,
	SECTIONS varchar(255) DEFAULT null,
	SITE_TEMPLATE_ID varchar(255) DEFAULT null,
	PREVIEW varchar(255) DEFAULT null,
	MANIFEST text DEFAULT null,
	CONTENT text NOT NULL,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_repo_active ON b_landing_repo (active);
CREATE INDEX ix_b_landing_repo_xml_id ON b_landing_repo (xml_id);
CREATE INDEX ix_b_landing_repo_app_code ON b_landing_repo (app_code);
CREATE INDEX ix_b_landing_repo_site_template_id ON b_landing_repo (site_template_id);

CREATE TABLE b_landing_hook_data
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	ENTITY_ID int NOT NULL,
	ENTITY_TYPE char(1) NOT NULL,
	HOOK varchar(50) NOT NULL,
	CODE varchar(50) NOT NULL,
	VALUE text DEFAULT null,
	PUBLIC char(1) NOT NULL DEFAULT 'N',
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_hook_data_entity_id_entity_type ON b_landing_hook_data (entity_id, entity_type);
CREATE INDEX ix_b_landing_hook_data_hook_code ON b_landing_hook_data (hook, code);

CREATE TABLE b_landing_file
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	ENTITY_ID int NOT NULL,
	ENTITY_TYPE char(1) NOT NULL,
	FILE_ID int NOT NULL,
	TEMP char(1) NOT NULL DEFAULT 'N',
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_file_entity_id_entity_type ON b_landing_file (entity_id, entity_type);
CREATE INDEX ix_b_landing_file_file_id ON b_landing_file (file_id);
CREATE INDEX ix_b_landing_file_temp ON b_landing_file (temp);

CREATE TABLE b_landing_syspage
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	SITE_ID int NOT NULL,
	TYPE varchar(50) NOT NULL,
	LANDING_ID int NOT NULL,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_syspage_site_id ON b_landing_syspage (site_id);
CREATE INDEX ix_b_landing_syspage_landing_id ON b_landing_syspage (landing_id);

CREATE TABLE b_landing_demo
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	XML_ID varchar(255) NOT NULL,
	APP_CODE varchar(255) DEFAULT null,
	ACTIVE char(1) NOT NULL DEFAULT 'Y',
	TYPE varchar(10) NOT NULL,
	TPL_TYPE char(1) NOT NULL,
	SHOW_IN_LIST char(1) NOT NULL DEFAULT 'N',
	TITLE varchar(255) NOT NULL,
	DESCRIPTION varchar(255) DEFAULT null,
	PREVIEW_URL varchar(255) DEFAULT null,
	PREVIEW varchar(255) DEFAULT null,
	PREVIEW2X varchar(255) DEFAULT null,
	PREVIEW3X varchar(255) DEFAULT null,
	MANIFEST text DEFAULT null,
	LANG text DEFAULT null,
	SITE_TEMPLATE_ID varchar(255) DEFAULT null,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_demo_active ON b_landing_demo (active);
CREATE INDEX ix_b_landing_demo_show_in_list ON b_landing_demo (show_in_list);
CREATE INDEX ix_b_landing_demo_xml_id ON b_landing_demo (xml_id);
CREATE INDEX ix_b_landing_demo_app_code ON b_landing_demo (app_code);
CREATE INDEX ix_b_landing_demo_site_template_id ON b_landing_demo (site_template_id);

CREATE TABLE b_landing_placement
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	APP_ID int,
	PLACEMENT varchar(255) NOT NULL,
	PLACEMENT_HANDLER varchar(255) NOT NULL,
	TITLE varchar(255) DEFAULT '',
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);

CREATE TABLE b_landing_update_block
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	CODE varchar(255) NOT NULL,
	LAST_BLOCK_ID int DEFAULT 0,
	PARAMS text DEFAULT null,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_update_block_code ON b_landing_update_block (code);

CREATE TABLE b_landing_urlrewrite
(
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  SITE_ID int NOT NULL,
  RULE varchar(255) NOT NULL,
  LANDING_ID int NOT NULL,
  CREATED_BY_ID int NOT NULL,
  MODIFIED_BY_ID int NOT NULL,
  DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
  DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_urlrewrite_site_id_rule ON b_landing_urlrewrite (site_id, rule);
CREATE INDEX ix_b_landing_urlrewrite_landing_id ON b_landing_urlrewrite (landing_id);

CREATE TABLE b_landing_entity_rights
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	ENTITY_ID int NOT NULL,
	ENTITY_TYPE char(1) NOT NULL,
	TASK_ID int NOT NULL,
	ACCESS_CODE varchar(50) NOT NULL,
	ROLE_ID int DEFAULT 0,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_entity_rights_entity_id_entity_type ON b_landing_entity_rights (entity_id, entity_type);
CREATE INDEX ix_b_landing_entity_rights_role_id ON b_landing_entity_rights (role_id);

CREATE TABLE b_landing_role
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	TITLE varchar(255) DEFAULT null,
	XML_ID varchar(255) DEFAULT null,
	TYPE varchar(255) DEFAULT null,
	ACCESS_CODES text DEFAULT null,
	ADDITIONAL_RIGHTS text DEFAULT null,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_role_type ON b_landing_role (type);

CREATE TABLE b_landing_filter_entity
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	SOURCE_ID varchar(255) NOT NULL,
	FILTER_HASH char(32) NOT NULL,
	FILTER text DEFAULT null,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_landing_filter_entity_filter_hash ON b_landing_filter_entity (filter_hash);

CREATE TABLE b_landing_filter_block
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	FILTER_ID int NOT NULL,
	BLOCK_ID int NOT NULL,
	PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_landing_filter_block_filter_id_block_id ON b_landing_filter_block (filter_id, block_id);

CREATE TABLE b_landing_view
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	LID int NOT NULL,
	USER_ID int NOT NULL,
	VIEWS int NOT NULL,
	FIRST_VIEW timestamp NOT NULL,
	LAST_VIEW timestamp NOT NULL,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_view_lid_user_id ON b_landing_view (lid, user_id);

CREATE TABLE b_landing_binding
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	ENTITY_ID int NOT NULL,
	ENTITY_TYPE char(1) NOT NULL,
	BINDING_ID varchar(50) NOT NULL,
	BINDING_TYPE char(1) NOT NULL,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_binding_binding_id_binding_type ON b_landing_binding (binding_id, binding_type);
CREATE INDEX ix_b_landing_binding_entity_id_entity_type ON b_landing_binding (entity_id, entity_type);
CREATE INDEX ix_b_landing_binding_binding_type ON b_landing_binding (binding_type);

CREATE TABLE b_landing_chat
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	CHAT_ID int NOT NULL,
	TITLE varchar(255) NOT NULL,
	AVATAR int DEFAULT null,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_chat_chat_id ON b_landing_chat (chat_id);

CREATE TABLE b_landing_chat_binding
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	INTERNAL_CHAT_ID int NOT NULL,
	ENTITY_ID int NOT NULL,
	ENTITY_TYPE char(1) NOT NULL,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_chat_binding_internal_chat_id ON b_landing_chat_binding (internal_chat_id);
CREATE INDEX ix_b_landing_chat_binding_entity_id_entity_type ON b_landing_chat_binding (entity_id, entity_type);

CREATE TABLE b_landing_cookies_agreement
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	ACTIVE char(1) NOT NULL DEFAULT 'Y',
	SITE_ID int NOT NULL,
	CODE varchar(50) NOT NULL,
	TITLE varchar(255) DEFAULT null,
	CONTENT text NOT NULL,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_cookies_agreement_site_id_code ON b_landing_cookies_agreement (site_id, code);

CREATE TABLE b_landing_designer_repo
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	XML_ID varchar(255) NOT NULL,
	TITLE varchar(255) DEFAULT null,
	SORT int DEFAULT 100,
	HTML text NOT NULL,
	MANIFEST text NOT NULL,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_designer_repo_xml_id ON b_landing_designer_repo (xml_id);

CREATE TABLE b_landing_entity_lock
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	ENTITY_ID int NOT NULL,
	ENTITY_TYPE char(1) NOT NULL,
	LOCK_TYPE char(1) NOT NULL,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_entity_lock_entity_id_entity_type ON b_landing_entity_lock (entity_id, entity_type);
CREATE INDEX ix_b_landing_entity_lock_lock_type ON b_landing_entity_lock (lock_type);

CREATE TABLE b_landing_folder
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	PARENT_ID int DEFAULT null,
	SITE_ID int NOT NULL,
	INDEX_ID int DEFAULT null,
	ACTIVE char(1) NOT NULL DEFAULT 'N',
	DELETED char(1) NOT NULL DEFAULT 'N',
	TITLE varchar(255) NOT NULL,
	CODE varchar(255) DEFAULT null,
	CREATED_BY_ID int NOT NULL,
	MODIFIED_BY_ID int NOT NULL,
	DATE_CREATE timestamp DEFAULT CURRENT_TIMESTAMP,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_folder_site_id ON b_landing_folder (site_id);
CREATE INDEX ix_b_landing_folder_active ON b_landing_folder (active);
CREATE INDEX ix_b_landing_folder_deleted ON b_landing_folder (deleted);
CREATE INDEX ix_b_landing_folder_parent_id ON b_landing_folder (parent_id);

CREATE TABLE b_landing_urlchecker_whitelist
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	DOMAIN varchar(255) NOT NULL,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_urlchecker_whitelist_domain ON b_landing_urlchecker_whitelist (domain);

CREATE TABLE b_landing_urlchecker_status
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	URL varchar(255) NOT NULL,
	HASH char(32) NOT NULL,
	STATUS varchar(255) DEFAULT null,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_urlchecker_status_hash ON b_landing_urlchecker_status (hash);

CREATE TABLE b_landing_urlchecker_host
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	STATUS_ID int NOT NULL,
	HOST varchar(255) NOT NULL,
	DATE_MODIFY timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_urlchecker_host_status_id_host ON b_landing_urlchecker_host (status_id, host);

CREATE TABLE b_landing_block_last_used
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	USER_ID int NOT NULL,
	CODE varchar(255) NOT NULL,
	DATE_CREATE timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_block_last_used_user_id ON b_landing_block_last_used (user_id);
CREATE INDEX ix_b_landing_block_last_used_code ON b_landing_block_last_used (code);
CREATE INDEX ix_b_landing_block_last_used_user_id_code ON b_landing_block_last_used (user_id, code);

CREATE TABLE b_landing_history
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	ENTITY_TYPE char(1) NOT NULL DEFAULT 'L',
	ENTITY_ID int NOT NULL,
	ACTION text NOT NULL,
	ACTION_PARAMS text NOT NULL,
	MULTIPLY_ID int,
	CREATED_BY_ID int NOT NULL,
	DATE_CREATE timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_history_entity_id_entity_type ON b_landing_history (entity_id, entity_type);

CREATE TABLE b_landing_history_step
(
	ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
	ENTITY_TYPE char(1) NOT NULL DEFAULT 'L',
	ENTITY_ID int NOT NULL,
	STEP int NOT NULL,
	PRIMARY KEY (ID)
);
CREATE INDEX ix_b_landing_history_step_entity_id_entity_type ON b_landing_history_step (entity_id, entity_type);
