<?php

if (!defined('B_PROLOG_INCLUDED') || B_PROLOG_INCLUDED !== true)
{
	die();
}

use \Bitrix\Main\Localization\Loc;

Loc::loadMessages(
	\Bitrix\Landing\Manager::getDocRoot() . '/bitrix/modules/landing/blocks/.style.php'
);

return [
	'style' => [
		'font-size' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_FONT_SIZE'),
			'property' => 'font-size',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-font-size-0'],
				['name' => '5', 'value' => 'g-font-size-5'],
				['name' => '8', 'value' => 'g-font-size-8'],
				['name' => '9', 'value' => 'g-font-size-9'],
				['name' => '10', 'value' => 'g-font-size-10'],
				['name' => '11', 'value' => 'g-font-size-11'],
				['name' => '12', 'value' => 'g-font-size-12'],
				['name' => '13', 'value' => 'g-font-size-13'],
				['name' => '14', 'value' => 'g-font-size-14'],
				['name' => '15', 'value' => 'g-font-size-15'],
				['name' => '16', 'value' => 'g-font-size-16'],
				['name' => '17', 'value' => 'g-font-size-17'],
				['name' => '18', 'value' => 'g-font-size-18'],
				['name' => '20', 'value' => 'g-font-size-20'],
				['name' => '22', 'value' => 'g-font-size-22'],
				['name' => '23', 'value' => 'g-font-size-23'],
				['name' => '24', 'value' => 'g-font-size-24'],
				['name' => '25', 'value' => 'g-font-size-25'],
				['name' => '26', 'value' => 'g-font-size-26'],
				['name' => '27', 'value' => 'g-font-size-27'],
				['name' => '28', 'value' => 'g-font-size-28'],
				['name' => '30', 'value' => 'g-font-size-30'],
				['name' => '32', 'value' => 'g-font-size-32'],
				['name' => '33', 'value' => 'g-font-size-33'],
				['name' => '35', 'value' => 'g-font-size-35'],
				['name' => '36', 'value' => 'g-font-size-36'],
				['name' => '38', 'value' => 'g-font-size-38'],
				['name' => '40', 'value' => 'g-font-size-40'],
				['name' => '42', 'value' => 'g-font-size-42'],
				['name' => '45', 'value' => 'g-font-size-45'],
				['name' => '46', 'value' => 'g-font-size-46'],
				['name' => '48', 'value' => 'g-font-size-48'],
				['name' => '50', 'value' => 'g-font-size-50'],
				['name' => '55', 'value' => 'g-font-size-55'],
				['name' => '60', 'value' => 'g-font-size-60'],
				['name' => '65', 'value' => 'g-font-size-65'],
				['name' => '70', 'value' => 'g-font-size-70'],
				['name' => '75', 'value' => 'g-font-size-75'],
				['name' => '80', 'value' => 'g-font-size-80'],
				['name' => '85', 'value' => 'g-font-size-85'],
				['name' => '90', 'value' => 'g-font-size-90'],
				['name' => '100', 'value' => 'g-font-size-100'],
				['name' => '110', 'value' => 'g-font-size-110'],
				['name' => '120', 'value' => 'g-font-size-120'],
				['name' => '150', 'value' => 'g-font-size-150'],
				['name' => '180', 'value' => 'g-font-size-180'],
				['name' => '200', 'value' => 'g-font-size-200'],
			],
		],
		'font-family' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_FONT_FAMILY'),
			'property' => 'font-family',
			'type' => 'list',
			'items' => [
				['name' => 'Open Sans', 'value' => 'g-font-open-sans'],
				['name' => 'Montserrat', 'value' => 'g-font-montserrat'],
				['name' => 'Roboto', 'value' => 'g-font-roboto'],
				['name' => 'Roboto Slab', 'value' => 'g-font-roboto-slab'],
				['name' => 'PT Sans', 'value' => 'g-font-pt-sans'],
				['name' => 'PT Sans Narrow', 'value' => 'g-font-pt-sans-narrow'],
				['name' => 'PT Sans Caption', 'value' => 'g-font-pt-sans-caption'],
				['name' => 'Cormorant Infant', 'value' => 'g-font-cormorant-infant'],
				['name' => 'Alegreya Sans', 'value' => 'g-font-alegreya-sans'],
				['name' => 'Lobster', 'value' => 'g-font-lobster'],
				['name' => 'Menlo', 'value' => 'g-font-code'],
			],
		],
		'font-weight' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_TEXT_FONT_WEIGHT'),
			'property' => 'font-weight',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-font-weight-auto'],
				['name' => '100', 'value' => 'g-font-weight-100'],
				['name' => '200', 'value' => 'g-font-weight-200'],
				['name' => '300', 'value' => 'g-font-weight-300'],
				['name' => '400', 'value' => 'g-font-weight-400'],
				['name' => '500', 'value' => 'g-font-weight-500'],
				['name' => '600', 'value' => 'g-font-weight-600'],
				['name' => '700', 'value' => 'g-font-weight-700'],
				['name' => '800', 'value' => 'g-font-weight-800'],
				['name' => '900', 'value' => 'g-font-weight-900'],
			],
			'help' => Loc::getMessage('LANDING_BLOCK_STYLE_TEXT_FONT_WEIGHT_HELP'),
		],
		'text-decoration' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_TEXT_DECORATION'),
			'property' => 'text-transform',
			'type' => 'buttons',
			'multiple' => true,
			'items' => [
				[
					'name' => '<span class="landing-ui-icon-editor-italic"></span>',
					'value' => 'font-italic',
					'title' => Loc::getMessage('LANDING_STYLE_ITALIC'),
				],
				[
					'name' => '<span class="landing-ui-icon-editor-underline"></span>',
					'value' => 'g-text-underline',
					'title' => Loc::getMessage('LANDING_STYLE_UNDERLINE2'),
				],
				[
					'name' => '<span class="landing-ui-icon-editor-strike"></span>',
					'value' => 'g-text-strike',
					'title' => Loc::getMessage('LANDING_STYLE_STRIKE2'),
				],
			],
		],
		'text-transform' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_TEXT_TRANSFORM2'),
			'property' => 'text-transform',
			'type' => 'list',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_DEFAULT'), 'value' => 'g-text-transform-none'],
				['name' => Loc::getMessage('LANDING_STYLE_UPPERCASE'), 'value' => 'text-uppercase'],
				['name' => Loc::getMessage('LANDING_STYLE_LOWERCASE'), 'value' => 'text-lowercase'],
				['name' => Loc::getMessage('LANDING_STYLE_CAPITALIZE'), 'value' => 'text-capitalize'],
			],
		],
		'line-height' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_LINE_HEIGHT'),
			'property' => 'line-height',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-line-height-0'],
				['name' => '0.7', 'value' => 'g-line-height-0_7'],
				['name' => '0.8', 'value' => 'g-line-height-0_8'],
				['name' => '0.9', 'value' => 'g-line-height-0_9'],
				['name' => '1', 'value' => 'g-line-height-1'],
				['name' => '1.1', 'value' => 'g-line-height-1_1'],
				['name' => '1.2', 'value' => 'g-line-height-1_2'],
				['name' => '1.3', 'value' => 'g-line-height-1_3'],
				['name' => '1.4', 'value' => 'g-line-height-1_4'],
				['name' => '1.5', 'value' => 'g-line-height-1_5'],
				['name' => '1.6', 'value' => 'g-line-height-1_6'],
				['name' => '1.7', 'value' => 'g-line-height-1_7'],
				['name' => '1.8', 'value' => 'g-line-height-1_8'],
				['name' => '2', 'value' => 'g-line-height-2'],
			],
		],
		'letter-spacing' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_LETTER_SPACING'),
			'property' => 'letter-spacing',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-letter-spacing-inherit'],
				['name' => '-2', 'value' => 'g-letter-spacing-minus-2'],
				['name' => '0', 'value' => 'g-letter-spacing-0'],
				['name' => '0.5', 'value' => 'g-letter-spacing-0_5'],
				['name' => '1', 'value' => 'g-letter-spacing-1'],
				['name' => '1.5', 'value' => 'g-letter-spacing-1_5'],
				['name' => '2', 'value' => 'g-letter-spacing-2'],
				['name' => '3', 'value' => 'g-letter-spacing-3'],
				['name' => '4', 'value' => 'g-letter-spacing-4'],
				['name' => '5', 'value' => 'g-letter-spacing-5'],
				['name' => '6', 'value' => 'g-letter-spacing-6'],
				['name' => '7', 'value' => 'g-letter-spacing-7'],
				['name' => '8', 'value' => 'g-letter-spacing-8'],
				['name' => '9', 'value' => 'g-letter-spacing-9'],
				['name' => '10', 'value' => 'g-letter-spacing-10'],
				['name' => '11', 'value' => 'g-letter-spacing-11'],
				['name' => '12', 'value' => 'g-letter-spacing-12'],
			],
		],
		'text-align' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_TEXT_ALIGN_SHORT'),
			'property' => 'text-align',
			'type' => 'buttons',
			'items' => [
				[
					'name' => '<span class="landing-ui-align landing-ui-align-left"><em></em></span>',
					'value' => 'text-left',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-center"><em></em></span>',
					'value' => 'text-center',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-right"><em></em></span>',
					'value' => 'text-right',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-justify"><em></em></span>',
					'value' => 'text-justify',
				],
			],
		],
		'word-break' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_WORD_BREAK'),
			'help' => Loc::getMessage('LANDING_BLOCK_STYLE_WORD_BREAK_HELP'),
			'property' => 'font-family',
			'type' => 'list',
			'items' => [
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_WORD_BREAK_NORMAL'), 'value' => 'word-break-normal'],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_WORD_BREAK_BREAK_ALL'),
					'value' => 'word-break-break-all',
				],
				//['name' => Loc::getMessage('LANDING_BLOCK_STYLE_WORD_BREAK_KEEP_ALL'), 'value' => 'word-break-keep-all'],
			],
		],
		'row-align' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ROW_ALIGN'),
			'type' => 'buttons',
			'items' => [
				[
					'name' => '<span class="landing-ui-align landing-ui-align-left"><em></em></span>',
					'value' => 'justify-content-start',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-center"><em></em></span>',
					'value' => 'justify-content-center',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-right"><em></em></span>',
					'value' => 'justify-content-end',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-around"><em></em></span>',
					'value' => 'justify-content-around',
				],
			],
		],
		'row-align-column' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ALIGN_ITEMS'),
			'type' => 'buttons',
			'items' => [
				[
					'name' => '<span class="landing-ui-align landing-ui-align-items-start"></span>',
					'value' => 'justify-content-start',
					'id' => 'justify-content-column-start',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-items-center"></span>',
					'value' => 'justify-content-center',
					'id' => 'justify-content-column-center',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-items-around"></span>',
					'value' => 'justify-content-around',
					'id' => 'justify-content-column-around',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-items-end"></span>',
					'value' => 'justify-content-end',
					'id' => 'justify-content-column-end',
				],
			],
		],
		'align-items' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ALIGN_ITEMS'),
			'property' => 'align-items',
			'type' => 'buttons',
			'items' => [
				[
					'name' => '<span class="landing-ui-align landing-ui-align-items-start"></span>',
					'value' => 'align-items-start',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-items-center"></span>',
					'value' => 'align-items-center',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-items-end"></span>',
					'value' => 'align-items-end',
				],
			],
		],
		'align-items-column' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ROW_ALIGN'),
			'property' => 'align-items',
			'type' => 'buttons',
			'items' => [
				[
					'name' => '<span class="landing-ui-align landing-ui-align-left"><em></em></span>',
					'value' => 'align-items-start',
					'id' => 'align-items-column-start',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-center"><em></em></span>',
					'value' => 'align-items-center',
					'id' => 'align-items-column-center',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-right"><em></em></span>',
					'value' => 'align-items-end',
					'id' => 'align-items-column-end',
				],
			],
		],
		'align-self' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ALIGN_ITEMS'),
			'property' => 'align-self',
			'type' => 'buttons',
			'items' => [
				[
					'name' => '<span class="landing-ui-align landing-ui-align-items-start"></span>',
					'value' => 'align-self-start',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-items-center"></span>',
					'value' => 'align-self-center',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-items-end"></span>',
					'value' => 'align-self-end',
				],
			],
		],

		'color' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_TEXT_COLOR'),
			'type' => 'color',
			'subtype' => 'color',
			// old items for delete old classes when change and for reset
			// todo: move items from .style to dynamic generation in processors
			'items' => [
				['name' => 'g-color-primary', 'value' => 'g-color-primary'],
				['name' => 'g-color-primary-opacity-0_3', 'value' => 'g-color-primary-opacity-0_3'],
				['name' => 'g-color-primary-opacity-0_4', 'value' => 'g-color-primary-opacity-0_4'],
				['name' => 'g-color-primary-opacity-0_8', 'value' => 'g-color-primary-opacity-0_8'],
				['name' => 'g-color-main', 'value' => 'g-color-main'],
				['name' => 'g-color-black', 'value' => 'g-color-black'],
				['name' => 'g-color-black-opacity-0_1', 'value' => 'g-color-black-opacity-0_1'],
				['name' => 'g-color-black-opacity-0_3', 'value' => 'g-color-black-opacity-0_3'],
				['name' => 'g-color-black-opacity-0_5', 'value' => 'g-color-black-opacity-0_5'],
				['name' => 'g-color-black-opacity-0_6', 'value' => 'g-color-black-opacity-0_6'],
				['name' => 'g-color-black-opacity-0_7', 'value' => 'g-color-black-opacity-0_7'],
				['name' => 'g-color-black-opacity-0_8', 'value' => 'g-color-black-opacity-0_8'],
				['name' => 'g-color-black-opacity-0_9', 'value' => 'g-color-black-opacity-0_9'],
				['name' => 'g-color-white', 'value' => 'g-color-white'],
				['name' => 'g-color-white-opacity-0_1', 'value' => 'g-color-white-opacity-0_1'],
				['name' => 'g-color-white-opacity-0_2', 'value' => 'g-color-white-opacity-0_2'],
				['name' => 'g-color-white-opacity-0_3', 'value' => 'g-color-white-opacity-0_3'],
				['name' => 'g-color-white-opacity-0_5', 'value' => 'g-color-white-opacity-0_5'],
				['name' => 'g-color-white-opacity-0_6', 'value' => 'g-color-white-opacity-0_6'],
				['name' => 'g-color-white-opacity-0_7', 'value' => 'g-color-white-opacity-0_7'],
				['name' => 'g-color-white-opacity-0_8', 'value' => 'g-color-white-opacity-0_8'],
				['name' => 'g-color-white-opacity-0_9', 'value' => 'g-color-white-opacity-0_9'],
				['name' => 'g-color-gray-light-v1', 'value' => 'g-color-gray-light-v1'],
				['name' => 'g-color-gray-light-v2', 'value' => 'g-color-gray-light-v2'],
				['name' => 'g-color-gray-light-v3', 'value' => 'g-color-gray-light-v3'],
				['name' => 'g-color-gray-light-v4', 'value' => 'g-color-gray-light-v4'],
				['name' => 'g-color-gray-light-v5', 'value' => 'g-color-gray-light-v5'],
				['name' => 'g-color-gray-dark-v1', 'value' => 'g-color-gray-dark-v1'],
				['name' => 'g-color-gray-dark-v2', 'value' => 'g-color-gray-dark-v2'],
				['name' => 'g-color-gray-dark-v3', 'value' => 'g-color-gray-dark-v3'],
				['name' => 'g-color-gray-dark-v4', 'value' => 'g-color-gray-dark-v4'],
				['name' => 'g-color-gray-dark-v5', 'value' => 'g-color-gray-dark-v5'],
				['name' => 'g-color-green', 'value' => 'g-color-green'],
				['name' => 'g-color-blue', 'value' => 'g-color-blue'],
				['name' => 'g-color-blue-dark-v1', 'value' => 'g-color-blue-dark-v1'],
				['name' => 'g-color-lightblue', 'value' => 'g-color-lightblue'],
				['name' => 'g-color-lightblue-v1', 'value' => 'g-color-lightblue-v1'],
				['name' => 'g-color-darkblue', 'value' => 'g-color-darkblue'],
				['name' => 'g-color-indigo', 'value' => 'g-color-indigo'],
				['name' => 'g-color-red', 'value' => 'g-color-red'],
				['name' => 'g-color-lightred', 'value' => 'g-color-lightred'],
				['name' => 'g-color-darkred', 'value' => 'g-color-darkred'],
				['name' => 'g-color-purple', 'value' => 'g-color-purple'],
				['name' => 'g-color-darkpurple', 'value' => 'g-color-darkpurple'],
				['name' => 'g-color-pink', 'value' => 'g-color-pink'],
				['name' => 'g-color-pink-dark-v1', 'value' => 'g-color-pink-dark-v1'],
				['name' => 'g-color-orange', 'value' => 'g-color-orange'],
				['name' => 'g-color-deeporange', 'value' => 'g-color-deeporange'],
				['name' => 'g-color-yellow', 'value' => 'g-color-yellow'],
				['name' => 'g-color-aqua', 'value' => 'g-color-aqua'],
				['name' => 'g-color-aqua-dark-v1', 'value' => 'g-color-aqua-dark-v1'],
				['name' => 'g-color-cyan', 'value' => 'g-color-cyan'],
				['name' => 'g-color-teal', 'value' => 'g-color-teal'],
				['name' => 'g-color-brown', 'value' => 'g-color-brown'],
				['name' => 'g-color-bluegray', 'value' => 'g-color-bluegray'],

				['name' => 'g-theme-event-color-gray-dark-v1', 'value' => 'g-theme-event-color-gray-dark-v1'],
				['name' => 'g-theme-bitrix-color-v4', 'value' => 'g-theme-bitrix-color-v4'],
			],
		],
		'color-hover' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_COLOR_HOVER'),
			'type' => 'color',
			'subtype' => 'color-hover',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'g-color-primary--hover', 'value' => 'g-color-primary--hover'],
				['name' => 'g-color-primary-opacity-0_3--hover', 'value' => 'g-color-primary-opacity-0_3--hover'],
				['name' => 'g-color-primary-opacity-0_4--hover', 'value' => 'g-color-primary-opacity-0_4--hover'],
				['name' => 'g-color-primary-opacity-0_8--hover', 'value' => 'g-color-primary-opacity-0_8--hover'],
				['name' => 'g-color-main--hover', 'value' => 'g-color-main--hover'],
				['name' => 'g-color-black--hover', 'value' => 'g-color-black--hover'],
				['name' => 'g-color-black-opacity-0_1--hover', 'value' => 'g-color-black-opacity-0_1--hover'],
				['name' => 'g-color-black-opacity-0_3--hover', 'value' => 'g-color-black-opacity-0_3--hover'],
				['name' => 'g-color-black-opacity-0_5--hover', 'value' => 'g-color-black-opacity-0_5--hover'],
				['name' => 'g-color-black-opacity-0_6--hover', 'value' => 'g-color-black-opacity-0_6--hover'],
				['name' => 'g-color-black-opacity-0_7--hover', 'value' => 'g-color-black-opacity-0_7--hover'],
				['name' => 'g-color-black-opacity-0_8--hover', 'value' => 'g-color-black-opacity-0_8--hover'],
				['name' => 'g-color-black-opacity-0_9--hover', 'value' => 'g-color-black-opacity-0_9--hover'],
				['name' => 'g-color-white--hover', 'value' => 'g-color-white--hover'],
				['name' => 'g-color-white-opacity-0_1--hover', 'value' => 'g-color-white-opacity-0_1--hover'],
				['name' => 'g-color-white-opacity-0_2--hover', 'value' => 'g-color-white-opacity-0_2--hover'],
				['name' => 'g-color-white-opacity-0_3--hover', 'value' => 'g-color-white-opacity-0_3--hover'],
				['name' => 'g-color-white-opacity-0_5--hover', 'value' => 'g-color-white-opacity-0_5--hover'],
				['name' => 'g-color-white-opacity-0_6--hover', 'value' => 'g-color-white-opacity-0_6--hover'],
				['name' => 'g-color-white-opacity-0_7--hover', 'value' => 'g-color-white-opacity-0_7--hover'],
				['name' => 'g-color-white-opacity-0_8--hover', 'value' => 'g-color-white-opacity-0_8--hover'],
				['name' => 'g-color-white-opacity-0_9--hover', 'value' => 'g-color-white-opacity-0_9--hover'],
				['name' => 'g-color-gray-light-v1--hover', 'value' => 'g-color-gray-light-v1--hover'],
				['name' => 'g-color-gray-light-v2--hover', 'value' => 'g-color-gray-light-v2--hover'],
				['name' => 'g-color-gray-light-v3--hover', 'value' => 'g-color-gray-light-v3--hover'],
				['name' => 'g-color-gray-light-v4--hover', 'value' => 'g-color-gray-light-v4--hover'],
				['name' => 'g-color-gray-light-v5--hover', 'value' => 'g-color-gray-light-v5--hover'],
				['name' => 'g-color-gray-dark-v1--hover', 'value' => 'g-color-gray-dark-v1--hover'],
				['name' => 'g-color-gray-dark-v2--hover', 'value' => 'g-color-gray-dark-v2--hover'],
				['name' => 'g-color-gray-dark-v3--hover', 'value' => 'g-color-gray-dark-v3--hover'],
				['name' => 'g-color-gray-dark-v4--hover', 'value' => 'g-color-gray-dark-v4--hover'],
				['name' => 'g-color-gray-dark-v5--hover', 'value' => 'g-color-gray-dark-v5--hover'],
				['name' => 'g-color-green--hover', 'value' => 'g-color-green--hover'],
				['name' => 'g-color-blue--hover', 'value' => 'g-color-blue--hover'],
				['name' => 'g-color-blue-dark-v1--hover', 'value' => 'g-color-blue-dark-v1--hover'],
				['name' => 'g-color-lightblue--hover', 'value' => 'g-color-lightblue--hover'],
				['name' => 'g-color-lightblue-v1--hover', 'value' => 'g-color-lightblue-v1--hover'],
				['name' => 'g-color-darkblue--hover', 'value' => 'g-color-darkblue--hover'],
				['name' => 'g-color-indigo--hover', 'value' => 'g-color-indigo--hover'],
				['name' => 'g-color-red--hover', 'value' => 'g-color-red--hover'],
				['name' => 'g-color-lightred--hover', 'value' => 'g-color-lightred--hover'],
				['name' => 'g-color-darkred--hover', 'value' => 'g-color-darkred--hover'],
				['name' => 'g-color-purple--hover', 'value' => 'g-color-purple--hover'],
				['name' => 'g-color-darkpurple--hover', 'value' => 'g-color-darkpurple--hover'],
				['name' => 'g-color-pink--hover', 'value' => 'g-color-pink--hover'],
				['name' => 'g-color-pink-dark-v1--hover', 'value' => 'g-color-pink-dark-v1--hover'],
				['name' => 'g-color-orange--hover', 'value' => 'g-color-orange--hover'],
				['name' => 'g-color-deeporange--hover', 'value' => 'g-color-deeporange--hover'],
				['name' => 'g-color-yellow--hover', 'value' => 'g-color-yellow--hover'],
				['name' => 'g-color-aqua--hover', 'value' => 'g-color-aqua--hover'],
				['name' => 'g-color-aqua-dark-v1--hover', 'value' => 'g-color-aqua-dark-v1--hover'],
				['name' => 'g-color-cyan--hover', 'value' => 'g-color-cyan--hover'],
				['name' => 'g-color-teal--hover', 'value' => 'g-color-teal--hover'],
				['name' => 'g-color-brown--hover', 'value' => 'g-color-brown--hover'],
				['name' => 'g-color-bluegray--hover', 'value' => 'g-color-bluegray--hover'],
				[
					'name' => 'g-theme-event-color-gray-dark-v1--hover',
					'value' => 'g-theme-event-color-gray-dark-v1--hover',
				],
				['name' => 'g-theme-bitrix-color-v4--hover', 'value' => 'g-theme-bitrix-color-v4--hover'],
			],
		],
		// dont forget add new usage this style in \Bitrix\Landing\Node\StyleImg::STYLES_WITH_IMAGE
		'background' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_COLOR_NEW'),
			'type' => 'color',
			'subtype' => 'bg',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'g-bg-transparent', 'value' => 'g-bg-transparent'],
				['name' => 'g-bg-primary', 'value' => 'g-bg-primary'],
				['name' => 'g-bg-primary-opacity-0_1', 'value' => 'g-bg-primary-opacity-0_1'],
				['name' => 'g-bg-primary-opacity-0_2', 'value' => 'g-bg-primary-opacity-0_2'],
				['name' => 'g-bg-primary-opacity-0_3', 'value' => 'g-bg-primary-opacity-0_3'],
				['name' => 'g-bg-primary-opacity-0_4', 'value' => 'g-bg-primary-opacity-0_4'],
				['name' => 'g-bg-primary-opacity-0_6', 'value' => 'g-bg-primary-opacity-0_6'],
				['name' => 'g-bg-primary-opacity-0_8', 'value' => 'g-bg-primary-opacity-0_8'],
				['name' => 'g-bg-primary-opacity-0_9', 'value' => 'g-bg-primary-opacity-0_9'],
				['name' => 'g-bg-primary-dark-v1', 'value' => 'g-bg-primary-dark-v1'],
				['name' => 'g-bg-primary-dark-v2', 'value' => 'g-bg-primary-dark-v2'],
				['name' => 'g-bg-primary-dark-v3', 'value' => 'g-bg-primary-dark-v3'],
				['name' => 'g-bg-main', 'value' => 'g-bg-main'],
				['name' => 'g-bg-secondary', 'value' => 'g-bg-secondary'],
				['name' => 'g-bg-black', 'value' => 'g-bg-black'],
				['name' => 'g-bg-black-opacity-0_1', 'value' => 'g-bg-black-opacity-0_1'],
				['name' => 'g-bg-black-opacity-0_2', 'value' => 'g-bg-black-opacity-0_2'],
				['name' => 'g-bg-black-opacity-0_3', 'value' => 'g-bg-black-opacity-0_3'],
				['name' => 'g-bg-black-opacity-0_4', 'value' => 'g-bg-black-opacity-0_4'],
				['name' => 'g-bg-black-opacity-0_5', 'value' => 'g-bg-black-opacity-0_5'],
				['name' => 'g-bg-black-opacity-0_6', 'value' => 'g-bg-black-opacity-0_6'],
				['name' => 'g-bg-black-opacity-0_7', 'value' => 'g-bg-black-opacity-0_7'],
				['name' => 'g-bg-black-opacity-0_8', 'value' => 'g-bg-black-opacity-0_8'],
				['name' => 'g-bg-black-opacity-0_9', 'value' => 'g-bg-black-opacity-0_9'],
				['name' => 'g-bg-white', 'value' => 'g-bg-white'],
				['name' => 'g-bg-white-opacity-0_1', 'value' => 'g-bg-white-opacity-0_1'],
				['name' => 'g-bg-white-opacity-0_2', 'value' => 'g-bg-white-opacity-0_2'],
				['name' => 'g-bg-white-opacity-0_3', 'value' => 'g-bg-white-opacity-0_3'],
				['name' => 'g-bg-white-opacity-0_4', 'value' => 'g-bg-white-opacity-0_4'],
				['name' => 'g-bg-white-opacity-0_5', 'value' => 'g-bg-white-opacity-0_5'],
				['name' => 'g-bg-white-opacity-0_6', 'value' => 'g-bg-white-opacity-0_6'],
				['name' => 'g-bg-white-opacity-0_7', 'value' => 'g-bg-white-opacity-0_7'],
				['name' => 'g-bg-white-opacity-0_8', 'value' => 'g-bg-white-opacity-0_8'],
				['name' => 'g-bg-white-opacity-0_9', 'value' => 'g-bg-white-opacity-0_9'],
				['name' => 'g-bg-gray-dark-v1', 'value' => 'g-bg-gray-dark-v1'],
				['name' => 'g-bg-gray-dark-v2', 'value' => 'g-bg-gray-dark-v2'],
				['name' => 'g-bg-gray-dark-v3', 'value' => 'g-bg-gray-dark-v3'],
				['name' => 'g-bg-gray-dark-v4', 'value' => 'g-bg-gray-dark-v4'],
				['name' => 'g-bg-gray-dark-v5', 'value' => 'g-bg-gray-dark-v5'],
				['name' => 'g-bg-gray-light-v1', 'value' => 'g-bg-gray-light-v1'],
				['name' => 'g-bg-gray-light-v2', 'value' => 'g-bg-gray-light-v2'],
				['name' => 'g-bg-gray-light-v3', 'value' => 'g-bg-gray-light-v3'],
				['name' => 'g-bg-gray-light-v4', 'value' => 'g-bg-gray-light-v4'],
				['name' => 'g-bg-gray-light-v5', 'value' => 'g-bg-gray-light-v5'],
				['name' => 'g-bg-beige', 'value' => 'g-bg-beige'],
				['name' => 'g-bg-green', 'value' => 'g-bg-green'],
				['name' => 'g-bg-green-opacity-0_1', 'value' => 'g-bg-green-opacity-0_1'],
				['name' => 'g-bg-green-opacity-0_3', 'value' => 'g-bg-green-opacity-0_3'],
				['name' => 'g-bg-green-opacity-0_5', 'value' => 'g-bg-green-opacity-0_5'],
				['name' => 'g-bg-green-opacity-0_7', 'value' => 'g-bg-green-opacity-0_7'],
				['name' => 'g-bg-blue', 'value' => 'g-bg-blue'],
				['name' => 'g-bg-blue-opacity-0_1', 'value' => 'g-bg-blue-opacity-0_1'],
				['name' => 'g-bg-blue-opacity-0_7', 'value' => 'g-bg-blue-opacity-0_7'],
				['name' => 'g-bg-blue-opacity-0_9', 'value' => 'g-bg-blue-opacity-0_9'],
				['name' => 'g-bg-lightblue', 'value' => 'g-bg-lightblue'],
				['name' => 'g-bg-lightblue-opacity-0_1', 'value' => 'g-bg-lightblue-opacity-0_1'],
				['name' => 'g-bg-lightblue-v1', 'value' => 'g-bg-lightblue-v1'],
				['name' => 'g-bg-lightblue-v1-opacity-0_1', 'value' => 'g-bg-lightblue-v1-opacity-0_1'],
				['name' => 'g-bg-darkblue', 'value' => 'g-bg-darkblue'],
				['name' => 'g-bg-darkblue-opacity-0_1', 'value' => 'g-bg-darkblue-opacity-0_1'],
				['name' => 'g-bg-darkblue-opacity-0_7', 'value' => 'g-bg-darkblue-opacity-0_7'],
				['name' => 'g-bg-indigo', 'value' => 'g-bg-indigo'],
				['name' => 'g-bg-indigo-opacity-0_1', 'value' => 'g-bg-indigo-opacity-0_1'],
				['name' => 'g-bg-red', 'value' => 'g-bg-red'],
				['name' => 'g-bg-red-opacity-0_1', 'value' => 'g-bg-red-opacity-0_1'],
				['name' => 'g-bg-red-opacity-0_2', 'value' => 'g-bg-red-opacity-0_2'],
				['name' => 'g-bg-red-opacity-0_5', 'value' => 'g-bg-red-opacity-0_5'],
				['name' => 'g-bg-red-opacity-0_8', 'value' => 'g-bg-red-opacity-0_8'],
				['name' => 'g-bg-lightred', 'value' => 'g-bg-lightred'],
				['name' => 'g-bg-lightred-opacity-0_1', 'value' => 'g-bg-lightred-opacity-0_1'],
				['name' => 'g-bg-darkred', 'value' => 'g-bg-darkred'],
				['name' => 'g-bg-darkred-opacity-0_1', 'value' => 'g-bg-darkred-opacity-0_1'],
				['name' => 'g-bg-purple', 'value' => 'g-bg-purple'],
				['name' => 'g-bg-purple-opacity-0_1', 'value' => 'g-bg-purple-opacity-0_1'],
				['name' => 'g-bg-purple-opacity-0_7', 'value' => 'g-bg-purple-opacity-0_7'],
				['name' => 'g-bg-purple-opacity-0_9', 'value' => 'g-bg-purple-opacity-0_9'],
				['name' => 'g-bg-darkpurple', 'value' => 'g-bg-darkpurple'],
				['name' => 'g-bg-darkpurple-opacity-0_1', 'value' => 'g-bg-darkpurple-opacity-0_1'],
				['name' => 'g-bg-pink', 'value' => 'g-bg-pink'],
				['name' => 'g-bg-pink-opacity-0_1', 'value' => 'g-bg-pink-opacity-0_1'],
				['name' => 'g-bg-pink-opacity-0_9', 'value' => 'g-bg-pink-opacity-0_9'],
				['name' => 'g-bg-orange', 'value' => 'g-bg-orange'],
				['name' => 'g-bg-orange-opacity-0_1', 'value' => 'g-bg-orange-opacity-0_1'],
				['name' => 'g-bg-orange-opacity-0_2', 'value' => 'g-bg-orange-opacity-0_2'],
				['name' => 'g-bg-deeporange', 'value' => 'g-bg-deeporange'],
				['name' => 'g-bg-deeporange-opacity-0_1', 'value' => 'g-bg-deeporange-opacity-0_1'],
				['name' => 'g-bg-yellow', 'value' => 'g-bg-yellow'],
				['name' => 'g-bg-yellow-opacity-0_1', 'value' => 'g-bg-yellow-opacity-0_1'],
				['name' => 'g-bg-yellow-opacity-0_7', 'value' => 'g-bg-yellow-opacity-0_7'],
				['name' => 'g-bg-aqua', 'value' => 'g-bg-aqua'],
				['name' => 'g-bg-aqua-opacity-0_1', 'value' => 'g-bg-aqua-opacity-0_1'],
				['name' => 'g-bg-aqua-opacity-0_9', 'value' => 'g-bg-aqua-opacity-0_9'],
				['name' => 'g-bg-cyan', 'value' => 'g-bg-cyan'],
				['name' => 'g-bg-cyan-opacity-0_1', 'value' => 'g-bg-cyan-opacity-0_1'],
				['name' => 'g-bg-cyan-opacity-0_9', 'value' => 'g-bg-cyan-opacity-0_9'],
				['name' => 'g-bg-teal', 'value' => 'g-bg-teal'],
				['name' => 'g-bg-teal-opacity-0_1', 'value' => 'g-bg-teal-opacity-0_1'],
				['name' => 'g-bg-teal-opacity-0_9', 'value' => 'g-bg-teal-opacity-0_9'],
				['name' => 'g-bg-brown', 'value' => 'g-bg-brown'],
				['name' => 'g-bg-brown-opacity-0_1', 'value' => 'g-bg-brown-opacity-0_1'],
				['name' => 'g-bg-bluegray', 'value' => 'g-bg-bluegray'],
				['name' => 'g-bg-bluegray-opacity-0_3', 'value' => 'g-bg-bluegray-opacity-0_3'],
				['name' => 'g-bg-bluegray-opacity-0_5', 'value' => 'g-bg-bluegray-opacity-0_5'],
				['name' => 'g-bg-bluegray-opacity-0_7', 'value' => 'g-bg-bluegray-opacity-0_7'],

				['name' => 'g-theme-business-bg-blue-dark-v1', 'value' => 'g-theme-business-bg-blue-dark-v1'],
				[
					'name' => 'g-theme-business-bg-blue-dark-v1-opacity-0_9',
					'value' => 'g-theme-business-bg-blue-dark-v1-opacity-0_9',
				],
				['name' => 'g-theme-business-bg-blue-dark-v2', 'value' => 'g-theme-business-bg-blue-dark-v2'],
				['name' => 'g-theme-business-bg-blue-dark-v3', 'value' => 'g-theme-business-bg-blue-dark-v3'],
				['name' => 'g-theme-architecture-bg-blue-dark-v1', 'value' => 'g-theme-architecture-bg-blue-dark-v1'],
				['name' => 'g-theme-architecture-bg-blue-dark-v3', 'value' => 'g-theme-architecture-bg-blue-dark-v3'],
				['name' => 'g-theme-architecture-bg-blue-dark-v4', 'value' => 'g-theme-architecture-bg-blue-dark-v4'],
				['name' => 'g-theme-lawyer-bg-gray-dark-v1', 'value' => 'g-theme-lawyer-bg-gray-dark-v1'],
				['name' => 'g-theme-event-bg-blue-dark-v2', 'value' => 'g-theme-event-bg-blue-dark-v2'],
				['name' => 'g-theme-travel-bg-black-v1', 'value' => 'g-theme-travel-bg-black-v1'],
				[
					'name' => 'g-theme-travel-bg-black-v1-opacity-0_8',
					'value' => 'g-theme-travel-bg-black-v1-opacity-0_8',
				],
				['name' => 'g-theme-photography-bg-gray-dark-v2', 'value' => 'g-theme-photography-bg-gray-dark-v2'],
				['name' => 'g-theme-photography-bg-gray-dark-v3', 'value' => 'g-theme-photography-bg-gray-dark-v3'],
				['name' => 'g-theme-photography-bg-gray-dark-v4', 'value' => 'g-theme-photography-bg-gray-dark-v4'],
				['name' => 'g-theme-bitrix-bg-dark-v1', 'value' => 'g-theme-bitrix-bg-dark-v1'],
				['name' => 'g-theme-bitrix-bg-dark-v3', 'value' => 'g-theme-bitrix-bg-dark-v3'],

				['name' => 'g-bg-facebook', 'value' => 'g-bg-facebook'],
				['name' => 'g-bg-twitter', 'value' => 'g-bg-twitter'],
				['name' => 'g-bg-skype', 'value' => 'g-bg-skype'],
				['name' => 'g-bg-pinterest', 'value' => 'g-bg-pinterest'],
				['name' => 'g-bg-vine', 'value' => 'g-bg-vine'],
				['name' => 'g-bg-youtube', 'value' => 'g-bg-youtube'],
				['name' => 'g-bg-google-plus', 'value' => 'g-bg-google-plus'],
				['name' => 'g-bg-dribbble', 'value' => 'g-bg-dribbble'],
				['name' => 'g-bg-vk', 'value' => 'g-bg-vk'],
				['name' => 'g-bg-linkedin', 'value' => 'g-bg-linkedin'],
				['name' => 'g-bg-instagram', 'value' => 'g-bg-instagram'],
				['name' => 'g-theme-bitrix-bg-dark-v2', 'value' => 'g-theme-bitrix-bg-dark-v2'],
				['name' => 'g-theme-bitrix-bg-v3', 'value' => 'g-theme-bitrix-bg-v3'],

				['name' => 'g-bg-gray-lineargradient', 'value' => 'g-bg-gray-lineargradient'],
				['name' => 'g-bg-bluepink-lineargradien', 'value' => 'g-bg-bluepink-lineargradien'],
				['name' => 'g-bg-blue-lineargradient', 'value' => 'g-bg-blue-lineargradient'],
				['name' => 'g-bg-blue-lineargradient-v2', 'value' => 'g-bg-blue-lineargradient-v2'],
				['name' => 'g-bg-blue-lineargradient-v3', 'value' => 'g-bg-blue-lineargradient-v3'],
				['name' => 'g-bg-blue-lineargradient-v4', 'value' => 'g-bg-blue-lineargradient-v4'],
				['name' => 'g-bg-blue-lineargradient-v5', 'value' => 'g-bg-blue-lineargradient-v5'],
				['name' => 'g-bg-orange-lineargradient', 'value' => 'g-bg-orange-lineargradient'],
				['name' => 'g-bg-orange-lineargradient-v2', 'value' => 'g-bg-orange-lineargradient-v2'],
				['name' => 'g-bg-yellow-lineargradient', 'value' => 'g-bg-yellow-lineargradient'],
				['name' => 'g-bg-darkpurple-lineargradient', 'value' => 'g-bg-darkpurple-lineargradient'],
				['name' => 'g-bg-bluegray-lineargradient', 'value' => 'g-bg-bluegray-lineargradient'],
				['name' => 'g-bg-pink-lineargradient', 'value' => 'g-bg-pink-lineargradient'],
				['name' => 'g-bg-pink-lineargradient-v2', 'value' => 'g-bg-pink-lineargradient-v2'],
				['name' => 'g-bg-red-lineargradient', 'value' => 'g-bg-red-lineargradient'],
				['name' => 'g-bg-black-gradient-opacity-v1', 'value' => 'g-bg-black-gradient-opacity-v1'],
				['name' => 'g-bg-green-gradient-opacity-v1', 'value' => 'g-bg-green-gradient-opacity-v1'],
				['name' => 'g-bg-purple-gradient-opacity-v1', 'value' => 'g-bg-purple-gradient-opacity-v1'],
				['name' => 'g-bg-pink-gradient-opacity-v1', 'value' => 'g-bg-pink-gradient-opacity-v1'],
				['name' => 'g-bg-cyan-gradient-opacity-v1', 'value' => 'g-bg-cyan-gradient-opacity-v1'],
				['name' => 'g-bg-lightblue-radialgradient-ellipse', 'value' => 'g-bg-lightblue-radialgradient-ellipse'],
				['name' => 'g-bg-gray-radialgradient-ellipse', 'value' => 'g-bg-gray-radialgradient-ellipse'],
				['name' => 'g-bg-graylight-radialgradient-ellipse', 'value' => 'g-bg-graylight-radialgradient-ellipse'],
				['name' => 'g-bg-lightblue-radialgradient-circle', 'value' => 'g-bg-lightblue-radialgradient-circle'],
				['name' => 'g-bg-blue-radialgradient-circle', 'value' => 'g-bg-blue-radialgradient-circle'],
				['name' => 'g-bg-darkgray-radialgradient-circle', 'value' => 'g-bg-darkgray-radialgradient-circle'],
				[
					'name' => 'g-bg-blue-radialgradient-circle-endless',
					'value' => 'g-bg-blue-radialgradient-circle-endless',
				],
				['name' => 'g-bg-gray-verticalstripes-endless', 'value' => 'g-bg-gray-verticalstripes-endless'],
				['name' => 'g-bg-pattern-gray-v1', 'value' => 'g-bg-pattern-gray-v1'],
				['name' => 'g-bg-pattern-green-v1', 'value' => 'g-bg-pattern-green-v1'],
				['name' => 'g-bg-pattern-dark-v1', 'value' => 'g-bg-pattern-dark-v1'],
			],
		],
		'background-color' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_COLOR_NEW'),
			'type' => 'color',
			'subtype' => 'bg-color',
			// old items for delete old classes when change and for reset, equal for background-color
			'items' => [
				['name' => 'g-bg-transparent', 'value' => 'g-bg-transparent'],
				['name' => 'g-bg-primary', 'value' => 'g-bg-primary'],
				['name' => 'g-bg-primary-opacity-0_1', 'value' => 'g-bg-primary-opacity-0_1'],
				['name' => 'g-bg-primary-opacity-0_2', 'value' => 'g-bg-primary-opacity-0_2'],
				['name' => 'g-bg-primary-opacity-0_3', 'value' => 'g-bg-primary-opacity-0_3'],
				['name' => 'g-bg-primary-opacity-0_4', 'value' => 'g-bg-primary-opacity-0_4'],
				['name' => 'g-bg-primary-opacity-0_6', 'value' => 'g-bg-primary-opacity-0_6'],
				['name' => 'g-bg-primary-opacity-0_8', 'value' => 'g-bg-primary-opacity-0_8'],
				['name' => 'g-bg-primary-opacity-0_9', 'value' => 'g-bg-primary-opacity-0_9'],
				['name' => 'g-bg-primary-dark-v1', 'value' => 'g-bg-primary-dark-v1'],
				['name' => 'g-bg-primary-dark-v2', 'value' => 'g-bg-primary-dark-v2'],
				['name' => 'g-bg-primary-dark-v3', 'value' => 'g-bg-primary-dark-v3'],
				['name' => 'g-bg-main', 'value' => 'g-bg-main'],
				['name' => 'g-bg-secondary', 'value' => 'g-bg-secondary'],
				['name' => 'g-bg-black', 'value' => 'g-bg-black'],
				['name' => 'g-bg-black-opacity-0_1', 'value' => 'g-bg-black-opacity-0_1'],
				['name' => 'g-bg-black-opacity-0_2', 'value' => 'g-bg-black-opacity-0_2'],
				['name' => 'g-bg-black-opacity-0_3', 'value' => 'g-bg-black-opacity-0_3'],
				['name' => 'g-bg-black-opacity-0_4', 'value' => 'g-bg-black-opacity-0_4'],
				['name' => 'g-bg-black-opacity-0_5', 'value' => 'g-bg-black-opacity-0_5'],
				['name' => 'g-bg-black-opacity-0_6', 'value' => 'g-bg-black-opacity-0_6'],
				['name' => 'g-bg-black-opacity-0_7', 'value' => 'g-bg-black-opacity-0_7'],
				['name' => 'g-bg-black-opacity-0_8', 'value' => 'g-bg-black-opacity-0_8'],
				['name' => 'g-bg-black-opacity-0_9', 'value' => 'g-bg-black-opacity-0_9'],
				['name' => 'g-bg-white', 'value' => 'g-bg-white'],
				['name' => 'g-bg-white-opacity-0_1', 'value' => 'g-bg-white-opacity-0_1'],
				['name' => 'g-bg-white-opacity-0_2', 'value' => 'g-bg-white-opacity-0_2'],
				['name' => 'g-bg-white-opacity-0_3', 'value' => 'g-bg-white-opacity-0_3'],
				['name' => 'g-bg-white-opacity-0_4', 'value' => 'g-bg-white-opacity-0_4'],
				['name' => 'g-bg-white-opacity-0_5', 'value' => 'g-bg-white-opacity-0_5'],
				['name' => 'g-bg-white-opacity-0_6', 'value' => 'g-bg-white-opacity-0_6'],
				['name' => 'g-bg-white-opacity-0_7', 'value' => 'g-bg-white-opacity-0_7'],
				['name' => 'g-bg-white-opacity-0_8', 'value' => 'g-bg-white-opacity-0_8'],
				['name' => 'g-bg-white-opacity-0_9', 'value' => 'g-bg-white-opacity-0_9'],
				['name' => 'g-bg-gray-dark-v1', 'value' => 'g-bg-gray-dark-v1'],
				['name' => 'g-bg-gray-dark-v2', 'value' => 'g-bg-gray-dark-v2'],
				['name' => 'g-bg-gray-dark-v3', 'value' => 'g-bg-gray-dark-v3'],
				['name' => 'g-bg-gray-dark-v4', 'value' => 'g-bg-gray-dark-v4'],
				['name' => 'g-bg-gray-dark-v5', 'value' => 'g-bg-gray-dark-v5'],
				['name' => 'g-bg-gray-light-v1', 'value' => 'g-bg-gray-light-v1'],
				['name' => 'g-bg-gray-light-v2', 'value' => 'g-bg-gray-light-v2'],
				['name' => 'g-bg-gray-light-v3', 'value' => 'g-bg-gray-light-v3'],
				['name' => 'g-bg-gray-light-v4', 'value' => 'g-bg-gray-light-v4'],
				['name' => 'g-bg-gray-light-v5', 'value' => 'g-bg-gray-light-v5'],
				['name' => 'g-bg-beige', 'value' => 'g-bg-beige'],
				['name' => 'g-bg-green', 'value' => 'g-bg-green'],
				['name' => 'g-bg-green-opacity-0_1', 'value' => 'g-bg-green-opacity-0_1'],
				['name' => 'g-bg-green-opacity-0_3', 'value' => 'g-bg-green-opacity-0_3'],
				['name' => 'g-bg-green-opacity-0_5', 'value' => 'g-bg-green-opacity-0_5'],
				['name' => 'g-bg-green-opacity-0_7', 'value' => 'g-bg-green-opacity-0_7'],
				['name' => 'g-bg-blue', 'value' => 'g-bg-blue'],
				['name' => 'g-bg-blue-opacity-0_1', 'value' => 'g-bg-blue-opacity-0_1'],
				['name' => 'g-bg-blue-opacity-0_7', 'value' => 'g-bg-blue-opacity-0_7'],
				['name' => 'g-bg-blue-opacity-0_9', 'value' => 'g-bg-blue-opacity-0_9'],
				['name' => 'g-bg-lightblue', 'value' => 'g-bg-lightblue'],
				['name' => 'g-bg-lightblue-opacity-0_1', 'value' => 'g-bg-lightblue-opacity-0_1'],
				['name' => 'g-bg-lightblue-v1', 'value' => 'g-bg-lightblue-v1'],
				['name' => 'g-bg-lightblue-v1-opacity-0_1', 'value' => 'g-bg-lightblue-v1-opacity-0_1'],
				['name' => 'g-bg-darkblue', 'value' => 'g-bg-darkblue'],
				['name' => 'g-bg-darkblue-opacity-0_1', 'value' => 'g-bg-darkblue-opacity-0_1'],
				['name' => 'g-bg-darkblue-opacity-0_7', 'value' => 'g-bg-darkblue-opacity-0_7'],
				['name' => 'g-bg-indigo', 'value' => 'g-bg-indigo'],
				['name' => 'g-bg-indigo-opacity-0_1', 'value' => 'g-bg-indigo-opacity-0_1'],
				['name' => 'g-bg-red', 'value' => 'g-bg-red'],
				['name' => 'g-bg-red-opacity-0_1', 'value' => 'g-bg-red-opacity-0_1'],
				['name' => 'g-bg-red-opacity-0_2', 'value' => 'g-bg-red-opacity-0_2'],
				['name' => 'g-bg-red-opacity-0_5', 'value' => 'g-bg-red-opacity-0_5'],
				['name' => 'g-bg-red-opacity-0_8', 'value' => 'g-bg-red-opacity-0_8'],
				['name' => 'g-bg-lightred', 'value' => 'g-bg-lightred'],
				['name' => 'g-bg-lightred-opacity-0_1', 'value' => 'g-bg-lightred-opacity-0_1'],
				['name' => 'g-bg-darkred', 'value' => 'g-bg-darkred'],
				['name' => 'g-bg-darkred-opacity-0_1', 'value' => 'g-bg-darkred-opacity-0_1'],
				['name' => 'g-bg-purple', 'value' => 'g-bg-purple'],
				['name' => 'g-bg-purple-opacity-0_1', 'value' => 'g-bg-purple-opacity-0_1'],
				['name' => 'g-bg-purple-opacity-0_7', 'value' => 'g-bg-purple-opacity-0_7'],
				['name' => 'g-bg-purple-opacity-0_9', 'value' => 'g-bg-purple-opacity-0_9'],
				['name' => 'g-bg-darkpurple', 'value' => 'g-bg-darkpurple'],
				['name' => 'g-bg-darkpurple-opacity-0_1', 'value' => 'g-bg-darkpurple-opacity-0_1'],
				['name' => 'g-bg-pink', 'value' => 'g-bg-pink'],
				['name' => 'g-bg-pink-opacity-0_1', 'value' => 'g-bg-pink-opacity-0_1'],
				['name' => 'g-bg-pink-opacity-0_9', 'value' => 'g-bg-pink-opacity-0_9'],
				['name' => 'g-bg-orange', 'value' => 'g-bg-orange'],
				['name' => 'g-bg-orange-opacity-0_1', 'value' => 'g-bg-orange-opacity-0_1'],
				['name' => 'g-bg-orange-opacity-0_2', 'value' => 'g-bg-orange-opacity-0_2'],
				['name' => 'g-bg-deeporange', 'value' => 'g-bg-deeporange'],
				['name' => 'g-bg-deeporange-opacity-0_1', 'value' => 'g-bg-deeporange-opacity-0_1'],
				['name' => 'g-bg-yellow', 'value' => 'g-bg-yellow'],
				['name' => 'g-bg-yellow-opacity-0_1', 'value' => 'g-bg-yellow-opacity-0_1'],
				['name' => 'g-bg-yellow-opacity-0_7', 'value' => 'g-bg-yellow-opacity-0_7'],
				['name' => 'g-bg-aqua', 'value' => 'g-bg-aqua'],
				['name' => 'g-bg-aqua-opacity-0_1', 'value' => 'g-bg-aqua-opacity-0_1'],
				['name' => 'g-bg-aqua-opacity-0_9', 'value' => 'g-bg-aqua-opacity-0_9'],
				['name' => 'g-bg-cyan', 'value' => 'g-bg-cyan'],
				['name' => 'g-bg-cyan-opacity-0_1', 'value' => 'g-bg-cyan-opacity-0_1'],
				['name' => 'g-bg-cyan-opacity-0_9', 'value' => 'g-bg-cyan-opacity-0_9'],
				['name' => 'g-bg-teal', 'value' => 'g-bg-teal'],
				['name' => 'g-bg-teal-opacity-0_1', 'value' => 'g-bg-teal-opacity-0_1'],
				['name' => 'g-bg-teal-opacity-0_9', 'value' => 'g-bg-teal-opacity-0_9'],
				['name' => 'g-bg-brown', 'value' => 'g-bg-brown'],
				['name' => 'g-bg-brown-opacity-0_1', 'value' => 'g-bg-brown-opacity-0_1'],
				['name' => 'g-bg-bluegray', 'value' => 'g-bg-bluegray'],
				['name' => 'g-bg-bluegray-opacity-0_3', 'value' => 'g-bg-bluegray-opacity-0_3'],
				['name' => 'g-bg-bluegray-opacity-0_5', 'value' => 'g-bg-bluegray-opacity-0_5'],
				['name' => 'g-bg-bluegray-opacity-0_7', 'value' => 'g-bg-bluegray-opacity-0_7'],

				['name' => 'g-theme-business-bg-blue-dark-v1', 'value' => 'g-theme-business-bg-blue-dark-v1'],
				[
					'name' => 'g-theme-business-bg-blue-dark-v1-opacity-0_9',
					'value' => 'g-theme-business-bg-blue-dark-v1-opacity-0_9',
				],
				['name' => 'g-theme-business-bg-blue-dark-v2', 'value' => 'g-theme-business-bg-blue-dark-v2'],
				['name' => 'g-theme-business-bg-blue-dark-v3', 'value' => 'g-theme-business-bg-blue-dark-v3'],
				['name' => 'g-theme-architecture-bg-blue-dark-v1', 'value' => 'g-theme-architecture-bg-blue-dark-v1'],
				['name' => 'g-theme-architecture-bg-blue-dark-v3', 'value' => 'g-theme-architecture-bg-blue-dark-v3'],
				['name' => 'g-theme-architecture-bg-blue-dark-v4', 'value' => 'g-theme-architecture-bg-blue-dark-v4'],
				['name' => 'g-theme-lawyer-bg-gray-dark-v1', 'value' => 'g-theme-lawyer-bg-gray-dark-v1'],
				['name' => 'g-theme-event-bg-blue-dark-v2', 'value' => 'g-theme-event-bg-blue-dark-v2'],
				['name' => 'g-theme-travel-bg-black-v1', 'value' => 'g-theme-travel-bg-black-v1'],
				[
					'name' => 'g-theme-travel-bg-black-v1-opacity-0_8',
					'value' => 'g-theme-travel-bg-black-v1-opacity-0_8',
				],
				['name' => 'g-theme-photography-bg-gray-dark-v2', 'value' => 'g-theme-photography-bg-gray-dark-v2'],
				['name' => 'g-theme-photography-bg-gray-dark-v3', 'value' => 'g-theme-photography-bg-gray-dark-v3'],
				['name' => 'g-theme-photography-bg-gray-dark-v4', 'value' => 'g-theme-photography-bg-gray-dark-v4'],
				['name' => 'g-theme-bitrix-bg-dark-v1', 'value' => 'g-theme-bitrix-bg-dark-v1'],
				['name' => 'g-theme-bitrix-bg-dark-v3', 'value' => 'g-theme-bitrix-bg-dark-v3'],

				['name' => 'g-bg-facebook', 'value' => 'g-bg-facebook'],
				['name' => 'g-bg-twitter', 'value' => 'g-bg-twitter'],
				['name' => 'g-bg-skype', 'value' => 'g-bg-skype'],
				['name' => 'g-bg-pinterest', 'value' => 'g-bg-pinterest'],
				['name' => 'g-bg-vine', 'value' => 'g-bg-vine'],
				['name' => 'g-bg-youtube', 'value' => 'g-bg-youtube'],
				['name' => 'g-bg-google-plus', 'value' => 'g-bg-google-plus'],
				['name' => 'g-bg-dribbble', 'value' => 'g-bg-dribbble'],
				['name' => 'g-bg-vk', 'value' => 'g-bg-vk'],
				['name' => 'g-bg-linkedin', 'value' => 'g-bg-linkedin'],
				['name' => 'g-bg-instagram', 'value' => 'g-bg-instagram'],
				['name' => 'g-theme-bitrix-bg-dark-v2', 'value' => 'g-theme-bitrix-bg-dark-v2'],
				['name' => 'g-theme-bitrix-bg-v3', 'value' => 'g-theme-bitrix-bg-v3'],

				['name' => 'g-bg-gray-lineargradient', 'value' => 'g-bg-gray-lineargradient'],
				['name' => 'g-bg-bluepink-lineargradien', 'value' => 'g-bg-bluepink-lineargradien'],
				['name' => 'g-bg-blue-lineargradient', 'value' => 'g-bg-blue-lineargradient'],
				['name' => 'g-bg-blue-lineargradient-v2', 'value' => 'g-bg-blue-lineargradient-v2'],
				['name' => 'g-bg-blue-lineargradient-v3', 'value' => 'g-bg-blue-lineargradient-v3'],
				['name' => 'g-bg-blue-lineargradient-v4', 'value' => 'g-bg-blue-lineargradient-v4'],
				['name' => 'g-bg-blue-lineargradient-v5', 'value' => 'g-bg-blue-lineargradient-v5'],
				['name' => 'g-bg-orange-lineargradient', 'value' => 'g-bg-orange-lineargradient'],
				['name' => 'g-bg-orange-lineargradient-v2', 'value' => 'g-bg-orange-lineargradient-v2'],
				['name' => 'g-bg-yellow-lineargradient', 'value' => 'g-bg-yellow-lineargradient'],
				['name' => 'g-bg-darkpurple-lineargradient', 'value' => 'g-bg-darkpurple-lineargradient'],
				['name' => 'g-bg-bluegray-lineargradient', 'value' => 'g-bg-bluegray-lineargradient'],
				['name' => 'g-bg-pink-lineargradient', 'value' => 'g-bg-pink-lineargradient'],
				['name' => 'g-bg-pink-lineargradient-v2', 'value' => 'g-bg-pink-lineargradient-v2'],
				['name' => 'g-bg-red-lineargradient', 'value' => 'g-bg-red-lineargradient'],
				['name' => 'g-bg-black-gradient-opacity-v1', 'value' => 'g-bg-black-gradient-opacity-v1'],
				['name' => 'g-bg-green-gradient-opacity-v1', 'value' => 'g-bg-green-gradient-opacity-v1'],
				['name' => 'g-bg-purple-gradient-opacity-v1', 'value' => 'g-bg-purple-gradient-opacity-v1'],
				['name' => 'g-bg-pink-gradient-opacity-v1', 'value' => 'g-bg-pink-gradient-opacity-v1'],
				['name' => 'g-bg-cyan-gradient-opacity-v1', 'value' => 'g-bg-cyan-gradient-opacity-v1'],
				['name' => 'g-bg-lightblue-radialgradient-ellipse', 'value' => 'g-bg-lightblue-radialgradient-ellipse'],
				['name' => 'g-bg-gray-radialgradient-ellipse', 'value' => 'g-bg-gray-radialgradient-ellipse'],
				['name' => 'g-bg-graylight-radialgradient-ellipse', 'value' => 'g-bg-graylight-radialgradient-ellipse'],
				['name' => 'g-bg-lightblue-radialgradient-circle', 'value' => 'g-bg-lightblue-radialgradient-circle'],
				['name' => 'g-bg-blue-radialgradient-circle', 'value' => 'g-bg-blue-radialgradient-circle'],
				['name' => 'g-bg-darkgray-radialgradient-circle', 'value' => 'g-bg-darkgray-radialgradient-circle'],
				[
					'name' => 'g-bg-blue-radialgradient-circle-endless',
					'value' => 'g-bg-blue-radialgradient-circle-endless',
				],
				['name' => 'g-bg-gray-verticalstripes-endless', 'value' => 'g-bg-gray-verticalstripes-endless'],
				['name' => 'g-bg-pattern-gray-v1', 'value' => 'g-bg-pattern-gray-v1'],
				['name' => 'g-bg-pattern-green-v1', 'value' => 'g-bg-pattern-green-v1'],
				['name' => 'g-bg-pattern-dark-v1', 'value' => 'g-bg-pattern-dark-v1'],
			],
		],
		// NOT use 'background-hover'!!!
		// It is name for background-color-hover in old control, but now it means color+image in hover. A dubious idea.
		'background-color-hover' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_HOVER'),
			'type' => 'color',
			'subtype' => 'bg-color-hover',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'g-bg-transparent--hover', 'value' => 'g-bg-transparent--hover'],
				['name' => 'g-bg-primary--hover', 'value' => 'g-bg-primary--hover'],
				['name' => 'g-bg-primary-opacity-0_1--hover', 'value' => 'g-bg-primary-opacity-0_1--hover'],
				['name' => 'g-bg-primary-opacity-0_2--hover', 'value' => 'g-bg-primary-opacity-0_2--hover'],
				['name' => 'g-bg-primary-opacity-0_3--hover', 'value' => 'g-bg-primary-opacity-0_3--hover'],
				['name' => 'g-bg-primary-opacity-0_4--hover', 'value' => 'g-bg-primary-opacity-0_4--hover'],
				['name' => 'g-bg-primary-opacity-0_6--hover', 'value' => 'g-bg-primary-opacity-0_6--hover'],
				['name' => 'g-bg-primary-opacity-0_8--hover', 'value' => 'g-bg-primary-opacity-0_8--hover'],
				['name' => 'g-bg-primary-opacity-0_9--hover', 'value' => 'g-bg-primary-opacity-0_9--hover'],
				['name' => 'g-bg-primary-dark-v1--hover', 'value' => 'g-bg-primary-dark-v1--hover'],
				['name' => 'g-bg-primary-dark-v2--hover', 'value' => 'g-bg-primary-dark-v2--hover'],
				['name' => 'g-bg-primary-dark-v3--hover', 'value' => 'g-bg-primary-dark-v3--hover'],
				['name' => 'g-bg-main--hover', 'value' => 'g-bg-main--hover'],
				['name' => 'g-bg-secondary--hover', 'value' => 'g-bg-secondary--hover'],
				['name' => 'g-bg-black--hover', 'value' => 'g-bg-black--hover'],
				['name' => 'g-bg-black-opacity-0_1--hover', 'value' => 'g-bg-black-opacity-0_1--hover'],
				['name' => 'g-bg-black-opacity-0_2--hover', 'value' => 'g-bg-black-opacity-0_2--hover'],
				['name' => 'g-bg-black-opacity-0_3--hover', 'value' => 'g-bg-black-opacity-0_3--hover'],
				['name' => 'g-bg-black-opacity-0_4--hover', 'value' => 'g-bg-black-opacity-0_4--hover'],
				['name' => 'g-bg-black-opacity-0_5--hover', 'value' => 'g-bg-black-opacity-0_5--hover'],
				['name' => 'g-bg-black-opacity-0_6--hover', 'value' => 'g-bg-black-opacity-0_6--hover'],
				['name' => 'g-bg-black-opacity-0_7--hover', 'value' => 'g-bg-black-opacity-0_7--hover'],
				['name' => 'g-bg-black-opacity-0_8--hover', 'value' => 'g-bg-black-opacity-0_8--hover'],
				['name' => 'g-bg-black-opacity-0_9--hover', 'value' => 'g-bg-black-opacity-0_9--hover'],
				['name' => 'g-bg-white--hover', 'value' => 'g-bg-white--hover'],
				['name' => 'g-bg-white-opacity-0_1--hover', 'value' => 'g-bg-white-opacity-0_1--hover'],
				['name' => 'g-bg-white-opacity-0_2--hover', 'value' => 'g-bg-white-opacity-0_2--hover'],
				['name' => 'g-bg-white-opacity-0_3--hover', 'value' => 'g-bg-white-opacity-0_3--hover'],
				['name' => 'g-bg-white-opacity-0_4--hover', 'value' => 'g-bg-white-opacity-0_4--hover'],
				['name' => 'g-bg-white-opacity-0_5--hover', 'value' => 'g-bg-white-opacity-0_5--hover'],
				['name' => 'g-bg-white-opacity-0_6--hover', 'value' => 'g-bg-white-opacity-0_6--hover'],
				['name' => 'g-bg-white-opacity-0_7--hover', 'value' => 'g-bg-white-opacity-0_7--hover'],
				['name' => 'g-bg-white-opacity-0_8--hover', 'value' => 'g-bg-white-opacity-0_8--hover'],
				['name' => 'g-bg-white-opacity-0_9--hover', 'value' => 'g-bg-white-opacity-0_9--hover'],
				['name' => 'g-bg-gray-dark-v1--hover', 'value' => 'g-bg-gray-dark-v1--hover'],
				['name' => 'g-bg-gray-dark-v2--hover', 'value' => 'g-bg-gray-dark-v2--hover'],
				['name' => 'g-bg-gray-dark-v3--hover', 'value' => 'g-bg-gray-dark-v3--hover'],
				['name' => 'g-bg-gray-dark-v4--hover', 'value' => 'g-bg-gray-dark-v4--hover'],
				['name' => 'g-bg-gray-dark-v5--hover', 'value' => 'g-bg-gray-dark-v5--hover'],
				['name' => 'g-bg-gray-light-v1--hover', 'value' => 'g-bg-gray-light-v1--hover'],
				['name' => 'g-bg-gray-light-v2--hover', 'value' => 'g-bg-gray-light-v2--hover'],
				['name' => 'g-bg-gray-light-v3--hover', 'value' => 'g-bg-gray-light-v3--hover'],
				['name' => 'g-bg-gray-light-v4--hover', 'value' => 'g-bg-gray-light-v4--hover'],
				['name' => 'g-bg-gray-light-v5--hover', 'value' => 'g-bg-gray-light-v5--hover'],
				['name' => 'g-bg-beige--hover', 'value' => 'g-bg-beige--hover'],
				['name' => 'g-bg-green--hover', 'value' => 'g-bg-green--hover'],
				['name' => 'g-bg-green-opacity-0_1--hover', 'value' => 'g-bg-green-opacity-0_1--hover'],
				['name' => 'g-bg-green-opacity-0_3--hover', 'value' => 'g-bg-green-opacity-0_3--hover'],
				['name' => 'g-bg-green-opacity-0_5--hover', 'value' => 'g-bg-green-opacity-0_5--hover'],
				['name' => 'g-bg-green-opacity-0_7--hover', 'value' => 'g-bg-green-opacity-0_7--hover'],
				['name' => 'g-bg-blue--hover', 'value' => 'g-bg-blue--hover'],
				['name' => 'g-bg-blue-opacity-0_1--hover', 'value' => 'g-bg-blue-opacity-0_1--hover'],
				['name' => 'g-bg-blue-opacity-0_7--hover', 'value' => 'g-bg-blue-opacity-0_7--hover'],
				['name' => 'g-bg-blue-opacity-0_9--hover', 'value' => 'g-bg-blue-opacity-0_9--hover'],
				['name' => 'g-bg-lightblue--hover', 'value' => 'g-bg-lightblue--hover'],
				['name' => 'g-bg-lightblue-opacity-0_1--hover', 'value' => 'g-bg-lightblue-opacity-0_1--hover'],
				['name' => 'g-bg-lightblue-v1--hover', 'value' => 'g-bg-lightblue-v1--hover'],
				['name' => 'g-bg-lightblue-v1-opacity-0_1--hover', 'value' => 'g-bg-lightblue-v1-opacity-0_1--hover'],
				['name' => 'g-bg-darkblue--hover', 'value' => 'g-bg-darkblue--hover'],
				['name' => 'g-bg-darkblue-opacity-0_1--hover', 'value' => 'g-bg-darkblue-opacity-0_1--hover'],
				['name' => 'g-bg-indigo--hover', 'value' => 'g-bg-indigo--hover'],
				['name' => 'g-bg-indigo-opacity-0_1--hover', 'value' => 'g-bg-indigo-opacity-0_1--hover'],
				['name' => 'g-bg-red--hover', 'value' => 'g-bg-red--hover'],
				['name' => 'g-bg-red-opacity-0_1--hover', 'value' => 'g-bg-red-opacity-0_1--hover'],
				['name' => 'g-bg-red-opacity-0_2--hover', 'value' => 'g-bg-red-opacity-0_2--hover'],
				['name' => 'g-bg-red-opacity-0_5--hover', 'value' => 'g-bg-red-opacity-0_5--hover'],
				['name' => 'g-bg-red-opacity-0_8--hover', 'value' => 'g-bg-red-opacity-0_8--hover'],
				['name' => 'g-bg-lightred--hover', 'value' => 'g-bg-lightred--hover'],
				['name' => 'g-bg-lightred-opacity-0_1--hover', 'value' => 'g-bg-lightred-opacity-0_1--hover'],
				['name' => 'g-bg-darkred--hover', 'value' => 'g-bg-darkred--hover'],
				['name' => 'g-bg-darkred-opacity-0_1--hover', 'value' => 'g-bg-darkred-opacity-0_1--hover'],
				['name' => 'g-bg-purple--hover', 'value' => 'g-bg-purple--hover'],
				['name' => 'g-bg-purple-opacity-0_1--hover', 'value' => 'g-bg-purple-opacity-0_1--hover'],
				['name' => 'g-bg-purple-opacity-0_7--hover', 'value' => 'g-bg-purple-opacity-0_7--hover'],
				['name' => 'g-bg-purple-opacity-0_9--hover', 'value' => 'g-bg-purple-opacity-0_9--hover'],
				['name' => 'g-bg-darkpurple--hover', 'value' => 'g-bg-darkpurple--hover'],
				['name' => 'g-bg-darkpurple-opacity-0_1--hover', 'value' => 'g-bg-darkpurple-opacity-0_1--hover'],
				['name' => 'g-bg-pink--hover', 'value' => 'g-bg-pink--hover'],
				['name' => 'g-bg-pink-opacity-0_1--hover', 'value' => 'g-bg-pink-opacity-0_1--hover'],
				['name' => 'g-bg-pink-opacity-0_9--hover', 'value' => 'g-bg-pink-opacity-0_9--hover'],
				['name' => 'g-bg-orange--hover', 'value' => 'g-bg-orange--hover'],
				['name' => 'g-bg-orange-opacity-0_1--hover', 'value' => 'g-bg-orange-opacity-0_1--hover'],
				['name' => 'g-bg-orange-opacity-0_2--hover', 'value' => 'g-bg-orange-opacity-0_2--hover'],
				['name' => 'g-bg-deeporange--hover', 'value' => 'g-bg-deeporange--hover'],
				['name' => 'g-bg-deeporange-opacity-0_1--hover', 'value' => 'g-bg-deeporange-opacity-0_1--hover'],
				['name' => 'g-bg-yellow--hover', 'value' => 'g-bg-yellow--hover'],
				['name' => 'g-bg-yellow-opacity-0_1--hover', 'value' => 'g-bg-yellow-opacity-0_1--hover'],
				['name' => 'g-bg-yellow-opacity-0_7--hover', 'value' => 'g-bg-yellow-opacity-0_7--hover'],
				['name' => 'g-bg-aqua--hover', 'value' => 'g-bg-aqua--hover'],
				['name' => 'g-bg-aqua-opacity-0_1--hover', 'value' => 'g-bg-aqua-opacity-0_1--hover'],
				['name' => 'g-bg-aqua-opacity-0_9--hover', 'value' => 'g-bg-aqua-opacity-0_9--hover'],
				['name' => 'g-bg-cyan--hover', 'value' => 'g-bg-cyan--hover'],
				['name' => 'g-bg-cyan-opacity-0_1--hover', 'value' => 'g-bg-cyan-opacity-0_1--hover'],
				['name' => 'g-bg-cyan-opacity-0_9--hover', 'value' => 'g-bg-cyan-opacity-0_9--hover'],
				['name' => 'g-bg-teal--hover', 'value' => 'g-bg-teal--hover'],
				['name' => 'g-bg-teal-opacity-0_1--hover', 'value' => 'g-bg-teal-opacity-0_1--hover'],
				['name' => 'g-bg-teal-opacity-0_9--hover', 'value' => 'g-bg-teal-opacity-0_9--hover'],
				['name' => 'g-bg-brown--hover', 'value' => 'g-bg-brown--hover'],
				['name' => 'g-bg-brown-opacity-0_1--hover', 'value' => 'g-bg-brown-opacity-0_1--hover'],
				['name' => 'g-bg-bluegray--hover', 'value' => 'g-bg-bluegray--hover'],
				['name' => 'g-bg-bluegray-opacity-0_3--hover', 'value' => 'g-bg-bluegray-opacity-0_3--hover'],
				['name' => 'g-bg-bluegray-opacity-0_5--hover', 'value' => 'g-bg-bluegray-opacity-0_5--hover'],
				['name' => 'g-bg-bluegray-opacity-0_7--hover', 'value' => 'g-bg-bluegray-opacity-0_7--hover'],

				[
					'name' => 'g-theme-business-bg-blue-dark-v1--hover',
					'value' => 'g-theme-business-bg-blue-dark-v1--hover',
				],
				[
					'name' => 'g-theme-business-bg-blue-dark-v1-opacity-0_9--hover',
					'value' => 'g-theme-business-bg-blue-dark-v1-opacity-0_9--hover',
				],
				[
					'name' => 'g-theme-business-bg-blue-dark-v2--hover',
					'value' => 'g-theme-business-bg-blue-dark-v2--hover',
				],
				[
					'name' => 'g-theme-business-bg-blue-dark-v3--hover',
					'value' => 'g-theme-business-bg-blue-dark-v3--hover',
				],
				[
					'name' => 'g-theme-architecture-bg-blue-dark-v1--hover',
					'value' => 'g-theme-architecture-bg-blue-dark-v1--hover',
				],
				[
					'name' => 'g-theme-architecture-bg-blue-dark-v3--hover',
					'value' => 'g-theme-architecture-bg-blue-dark-v3--hover',
				],
				[
					'name' => 'g-theme-architecture-bg-blue-dark-v4--hover',
					'value' => 'g-theme-architecture-bg-blue-dark-v4--hover',
				],
				['name' => 'g-theme-lawyer-bg-gray-dark-v1--hover', 'value' => 'g-theme-lawyer-bg-gray-dark-v1--hover'],
				['name' => 'g-theme-event-bg-blue-dark-v2--hover', 'value' => 'g-theme-event-bg-blue-dark-v2--hover'],
				['name' => 'g-theme-travel-bg-black-v1--hover', 'value' => 'g-theme-travel-bg-black-v1--hover'],
				[
					'name' => 'g-theme-travel-bg-black-v1-opacity-0_8--hover',
					'value' => 'g-theme-travel-bg-black-v1-opacity-0_8--hover',
				],
				[
					'name' => 'g-theme-photography-bg-gray-dark-v2--hover',
					'value' => 'g-theme-photography-bg-gray-dark-v2--hover',
				],
				[
					'name' => 'g-theme-photography-bg-gray-dark-v3--hover',
					'value' => 'g-theme-photography-bg-gray-dark-v3--hover',
				],
				[
					'name' => 'g-theme-photography-bg-gray-dark-v4--hover',
					'value' => 'g-theme-photography-bg-gray-dark-v4--hover',
				],
				['name' => 'g-theme-bitrix-bg-dark-v1--hover', 'value' => 'g-theme-bitrix-bg-dark-v1--hover'],

				['name' => 'g-bg-facebook--hover', 'value' => 'g-bg-facebook--hover'],
				['name' => 'g-bg-twitter--hover', 'value' => 'g-bg-twitter--hover'],
				['name' => 'g-bg-skype--hover', 'value' => 'g-bg-skype--hover'],
				['name' => 'g-bg-pinterest--hover', 'value' => 'g-bg-pinterest--hover'],
				['name' => 'g-bg-vine--hover', 'value' => 'g-bg-vine--hover'],
				['name' => 'g-bg-youtube--hover', 'value' => 'g-bg-youtube--hover'],
				['name' => 'g-bg-google-plus--hover', 'value' => 'g-bg-google-plus--hover'],
				['name' => 'g-bg-dribbble--hover', 'value' => 'g-bg-dribbble--hover'],
				['name' => 'g-bg-vk--hover', 'value' => 'g-bg-vk--hover'],
				['name' => 'g-bg-linkedin--hover', 'value' => 'g-bg-linkedin--hover'],
				['name' => 'g-bg-instagram--hover', 'value' => 'g-bg-instagram--hover'],
				['name' => 'g-theme-bitrix-bg-dark-v2--hover', 'value' => 'g-theme-bitrix-bg-dark-v2--hover'],
				['name' => 'g-theme-bitrix-bg-v3--hover', 'value' => 'g-theme-bitrix-bg-v3--hover'],
			],
		],
		'background-attachment' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_ATTACHMENT'),
			'property' => 'background-attachment',
			'type' => 'list',
			'items' => [
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_ATTACHMENT_SCROLL'),
					'value' => 'g-bg-attachment-scroll',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_ATTACHMENT_FIXED'),
					'value' => 'g-bg-attachment-fixed',
				],
			],
		],
		'background-overlay' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_OVERLAY'),
			'type' => 'color',
			'subtype' => 'bg-color-after',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'g-bg-none--after', 'value' => 'g-bg-none--after'],
				['name' => 'g-bg-primary-opacity-0_2--after', 'value' => 'g-bg-primary-opacity-0_2--after'],
				['name' => 'g-bg-primary-opacity-0_3--after', 'value' => 'g-bg-primary-opacity-0_3--after'],
				['name' => 'g-bg-primary-opacity-0_4--after', 'value' => 'g-bg-primary-opacity-0_4--after'],
				['name' => 'g-bg-primary-opacity-0_6--after', 'value' => 'g-bg-primary-opacity-0_6--after'],
				['name' => 'g-bg-primary-opacity-0_8--after', 'value' => 'g-bg-primary-opacity-0_8--after'],
				['name' => 'g-bg-primary-opacity-0_9--after', 'value' => 'g-bg-primary-opacity-0_9--after'],
				['name' => 'g-bg-black-opacity-0_1--after', 'value' => 'g-bg-black-opacity-0_1--after'],
				['name' => 'g-bg-black-opacity-0_2--after', 'value' => 'g-bg-black-opacity-0_2--after'],
				['name' => 'g-bg-black-opacity-0_3--after', 'value' => 'g-bg-black-opacity-0_3--after'],
				['name' => 'g-bg-black-opacity-0_4--after', 'value' => 'g-bg-black-opacity-0_4--after'],
				['name' => 'g-bg-black-opacity-0_5--after', 'value' => 'g-bg-black-opacity-0_5--after'],
				['name' => 'g-bg-black-opacity-0_6--after', 'value' => 'g-bg-black-opacity-0_6--after'],
				['name' => 'g-bg-black-opacity-0_7--after', 'value' => 'g-bg-black-opacity-0_7--after'],
				['name' => 'g-bg-black-opacity-0_8--after', 'value' => 'g-bg-black-opacity-0_8--after'],
				['name' => 'g-bg-black-opacity-0_9--after', 'value' => 'g-bg-black-opacity-0_9--after'],
				['name' => 'g-bg-white-opacity-0_1--after', 'value' => 'g-bg-white-opacity-0_1--after'],
				['name' => 'g-bg-white-opacity-0_3--after', 'value' => 'g-bg-white-opacity-0_3--after'],
				['name' => 'g-bg-white-opacity-0_5--after', 'value' => 'g-bg-white-opacity-0_5--after'],
				['name' => 'g-bg-white-opacity-0_7--after', 'value' => 'g-bg-white-opacity-0_7--after'],
				['name' => 'g-bg-white-opacity-0_8--after', 'value' => 'g-bg-white-opacity-0_8--after'],
				['name' => 'g-bg-white-opacity-0_9--after', 'value' => 'g-bg-white-opacity-0_9--after'],

				['name' => 'g-bg-red-opacity-0_3--after', 'value' => 'g-bg-red-opacity-0_3--after'],
				['name' => 'g-bg-red-opacity-0_5--after', 'value' => 'g-bg-red-opacity-0_5--after'],
				['name' => 'g-bg-red-opacity-0_7--after', 'value' => 'g-bg-red-opacity-0_7--after'],

				['name' => 'g-bg-yellow-opacity-0_3--after', 'value' => 'g-bg-yellow-opacity-0_3--after'],
				['name' => 'g-bg-yellow-opacity-0_5--after', 'value' => 'g-bg-yellow-opacity-0_5--after'],
				['name' => 'g-bg-yellow-opacity-0_7--after', 'value' => 'g-bg-yellow-opacity-0_7--after'],

				['name' => 'g-bg-green-opacity-0_3--after', 'value' => 'g-bg-green-opacity-0_3--after'],
				['name' => 'g-bg-green-opacity-0_5--after', 'value' => 'g-bg-green-opacity-0_5--after'],
				['name' => 'g-bg-green-opacity-0_7--after', 'value' => 'g-bg-green-opacity-0_7--after'],

				['name' => 'g-bg-teal-opacity-0_3--after', 'value' => 'g-bg-teal-opacity-0_3--after'],
				['name' => 'g-bg-teal-opacity-0_5--after', 'value' => 'g-bg-teal-opacity-0_5--after'],
				['name' => 'g-bg-teal-opacity-0_7--after', 'value' => 'g-bg-teal-opacity-0_7--after'],

				['name' => 'g-bg-cyan-opacity-0_3--after', 'value' => 'g-bg-cyan-opacity-0_3--after'],
				['name' => 'g-bg-cyan-opacity-0_5--after', 'value' => 'g-bg-cyan-opacity-0_5--after'],
				['name' => 'g-bg-cyan-opacity-0_7--after', 'value' => 'g-bg-cyan-opacity-0_7--after'],
				['name' => 'g-bg-cyan-opacity-0_9--after', 'value' => 'g-bg-cyan-opacity-0_9--after'],

				['name' => 'g-bg-blue-opacity-0_3--after', 'value' => 'g-bg-blue-opacity-0_3--after'],
				['name' => 'g-bg-blue-opacity-0_5--after', 'value' => 'g-bg-blue-opacity-0_5--after'],
				['name' => 'g-bg-blue-opacity-0_7--after', 'value' => 'g-bg-blue-opacity-0_7--after'],

				['name' => 'g-bg-purple-opacity-0_3--after', 'value' => 'g-bg-purple-opacity-0_3--after'],
				['name' => 'g-bg-purple-opacity-0_5--after', 'value' => 'g-bg-purple-opacity-0_5--after'],
				['name' => 'g-bg-purple-opacity-0_7--after', 'value' => 'g-bg-purple-opacity-0_7--after'],
				['name' => 'g-bg-purple-opacity-0_9--after', 'value' => 'g-bg-purple-opacity-0_9--after'],

				['name' => 'g-bg-bluegray-opacity-0_2--after', 'value' => 'g-bg-bluegray-opacity-0_2--after'],
				['name' => 'g-bg-bluegray-opacity-0_3--after', 'value' => 'g-bg-bluegray-opacity-0_3--after'],

				['name' => 'g-bg-darkblue-opacity-0_3--after', 'value' => 'g-bg-darkblue-opacity-0_3--after'],
				['name' => 'g-bg-darkblue-opacity-0_5--after', 'value' => 'g-bg-darkblue-opacity-0_5--after'],
				['name' => 'g-bg-darkblue-opacity-0_7--after', 'value' => 'g-bg-darkblue-opacity-0_7--after'],
			],
		],
		'background-color-before' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BG_COLOR_BEFORE'),
			'type' => 'color',
			'subtype' => 'bg-color-before',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'g-bg-primary--before', 'value' => 'g-bg-primary--before'],
				['name' => 'g-bg-primary-opacity-0_1--before', 'value' => 'g-bg-primary-opacity-0_1--before'],
				['name' => 'g-bg-primary-opacity-0_2--before', 'value' => 'g-bg-primary-opacity-0_2--before'],
				['name' => 'g-bg-primary-opacity-0_3--before', 'value' => 'g-bg-primary-opacity-0_3--before'],
				['name' => 'g-bg-primary-opacity-0_4--before', 'value' => 'g-bg-primary-opacity-0_4--before'],
				['name' => 'g-bg-primary-opacity-0_6--before', 'value' => 'g-bg-primary-opacity-0_6--before'],
				['name' => 'g-bg-primary-opacity-0_8--before', 'value' => 'g-bg-primary-opacity-0_8--before'],
				['name' => 'g-bg-primary-opacity-0_9--before', 'value' => 'g-bg-primary-opacity-0_9--before'],
				['name' => 'g-bg-bluegray--before', 'value' => 'g-bg-bluegray--before'],
				['name' => 'g-bg-bluegray-opacity-0_2--before', 'value' => 'g-bg-bluegray-opacity-0_2--before'],
				['name' => 'g-bg-bluegray-opacity-0_3--before', 'value' => 'g-bg-bluegray-opacity-0_3--before'],
				['name' => 'g-bg-black--before', 'value' => 'g-bg-black--before'],
				['name' => 'g-bg-black-opacity-0_1--before', 'value' => 'g-bg-black-opacity-0_1--before'],
				['name' => 'g-bg-black-opacity-0_2--before', 'value' => 'g-bg-black-opacity-0_2--before'],
				['name' => 'g-bg-black-opacity-0_3--before', 'value' => 'g-bg-black-opacity-0_3--before'],
				['name' => 'g-bg-black-opacity-0_4--before', 'value' => 'g-bg-black-opacity-0_4--before'],
				['name' => 'g-bg-black-opacity-0_5--before', 'value' => 'g-bg-black-opacity-0_5--before'],
				['name' => 'g-bg-black-opacity-0_6--before', 'value' => 'g-bg-black-opacity-0_6--before'],
				['name' => 'g-bg-black-opacity-0_7--before', 'value' => 'g-bg-black-opacity-0_7--before'],
				['name' => 'g-bg-black-opacity-0_8--before', 'value' => 'g-bg-black-opacity-0_8--before'],
				['name' => 'g-bg-black-opacity-0_9--before', 'value' => 'g-bg-black-opacity-0_9--before'],
				['name' => 'g-bg-white--before', 'value' => 'g-bg-white--before'],
				['name' => 'g-bg-white-opacity-0_1--before', 'value' => 'g-bg-white-opacity-0_1--before'],
				['name' => 'g-bg-white-opacity-0_2--before', 'value' => 'g-bg-white-opacity-0_2--before'],
				['name' => 'g-bg-white-opacity-0_3--before', 'value' => 'g-bg-white-opacity-0_3--before'],
				['name' => 'g-bg-white-opacity-0_4--before', 'value' => 'g-bg-white-opacity-0_4--before'],
				['name' => 'g-bg-white-opacity-0_5--before', 'value' => 'g-bg-white-opacity-0_5--before'],
				['name' => 'g-bg-white-opacity-0_7--before', 'value' => 'g-bg-white-opacity-0_7--before'],
				['name' => 'g-bg-white-opacity-0_8--before', 'value' => 'g-bg-white-opacity-0_8--before'],
				['name' => 'g-bg-white-opacity-0_9--before', 'value' => 'g-bg-white-opacity-0_9--before'],
				['name' => 'g-bg-gray-dark-v1--before', 'value' => 'g-bg-gray-dark-v1--before'],
				['name' => 'g-bg-gray-dark-v2--before', 'value' => 'g-bg-gray-dark-v2--before'],
				['name' => 'g-bg-gray-dark-v3--before', 'value' => 'g-bg-gray-dark-v3--before'],
				['name' => 'g-bg-gray-dark-v4--before', 'value' => 'g-bg-gray-dark-v4--before'],
				['name' => 'g-bg-gray-dark-v5--before', 'value' => 'g-bg-gray-dark-v5--before'],
				['name' => 'g-bg-gray-light-v1--before', 'value' => 'g-bg-gray-light-v1--before'],
				['name' => 'g-bg-gray-light-v2--before', 'value' => 'g-bg-gray-light-v2--before'],
				['name' => 'g-bg-gray-light-v3--before', 'value' => 'g-bg-gray-light-v3--before'],
				['name' => 'g-bg-gray-light-v4--before', 'value' => 'g-bg-gray-light-v4--before'],
				['name' => 'g-bg-gray-light-v5--before', 'value' => 'g-bg-gray-light-v5--before'],
				['name' => 'g-bg-beige--before', 'value' => 'g-bg-beige--before'],
				['name' => 'g-bg-green--before', 'value' => 'g-bg-green--before'],
				['name' => 'g-bg-blue--before', 'value' => 'g-bg-blue--before'],
				['name' => 'g-bg-lightblue--before', 'value' => 'g-bg-lightblue--before'],
				['name' => 'g-bg-lightblue-v1--before', 'value' => 'g-bg-lightblue-v1--before'],
				['name' => 'g-bg-darkblue--before', 'value' => 'g-bg-darkblue--before'],
				['name' => 'g-bg-indigo--before', 'value' => 'g-bg-indigo--before'],
				['name' => 'g-bg-red--before', 'value' => 'g-bg-red--before'],
				['name' => 'g-bg-lightred--before', 'value' => 'g-bg-lightred--before'],
				['name' => 'g-bg-darkred--before', 'value' => 'g-bg-darkred--before'],
				['name' => 'g-bg-purple--before', 'value' => 'g-bg-purple--before'],
				['name' => 'g-bg-darkpurple--before', 'value' => 'g-bg-darkpurple--before'],
				['name' => 'g-bg-pink--before', 'value' => 'g-bg-pink--before'],
				['name' => 'g-bg-orange--before', 'value' => 'g-bg-orange--before'],
				['name' => 'g-bg-deeporange--before', 'value' => 'g-bg-deeporange--before'],
				['name' => 'g-bg-yellow--before', 'value' => 'g-bg-yellow--before'],
				['name' => 'g-bg-aqua--before', 'value' => 'g-bg-aqua--before'],
				['name' => 'g-bg-cyan--before', 'value' => 'g-bg-cyan--before'],
				['name' => 'g-bg-teal--before', 'value' => 'g-bg-teal--before'],
				['name' => 'g-bg-brown--before', 'value' => 'g-bg-brown--before'],
			],
		],
		'background-size' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_SIZE'),
			'property' => 'background-size',
			'type' => 'list',
			'items' => [
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_SIZE_COVER'), 'value' => 'g-bg-size-cover'],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_SIZE_CONTAIN'),
					'value' => 'g-bg-size-contain-no-repeat',
				],
			],
		],
		'background-size-img' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_SIZE'),
			'property' => 'object-fit',
			'type' => 'list',
			'items' => [
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_SIZE_NONE'),
					'value' => 'g-object-fit-none',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_SIZE_COVER'),
					'value' => 'g-object-fit-cover',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_SIZE_CONTAIN'),
					'value' => 'g-object-fit-contain',
				],
			],
		],
		'navbar-color' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_COLOR'),
			'type' => 'color',
			'subtype' => 'navbar-color',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'u-navbar-color-primary', 'value' => 'u-navbar-color-primary'],
				['name' => 'u-navbar-color-main', 'value' => 'u-navbar-color-main'],
				['name' => 'u-navbar-color-black', 'value' => 'u-navbar-color-black'],
				['name' => 'u-navbar-color-white', 'value' => 'u-navbar-color-white'],
				['name' => 'u-navbar-color-gray-light-v1', 'value' => 'u-navbar-color-gray-light-v1'],
				['name' => 'u-navbar-color-gray-light-v2', 'value' => 'u-navbar-color-gray-light-v2'],
				['name' => 'u-navbar-color-gray-light-v3', 'value' => 'u-navbar-color-gray-light-v3'],
				['name' => 'u-navbar-color-gray-light-v4', 'value' => 'u-navbar-color-gray-light-v4'],
				['name' => 'u-navbar-color-gray-light-v5', 'value' => 'u-navbar-color-gray-light-v5'],
				['name' => 'u-navbar-color-gray-dark-v1', 'value' => 'u-navbar-color-gray-dark-v1'],
				['name' => 'u-navbar-color-gray-dark-v2', 'value' => 'u-navbar-color-gray-dark-v2'],
				['name' => 'u-navbar-color-gray-dark-v3', 'value' => 'u-navbar-color-gray-dark-v3'],
				['name' => 'u-navbar-color-gray-dark-v4', 'value' => 'u-navbar-color-gray-dark-v4'],
				['name' => 'u-navbar-color-gray-dark-v5', 'value' => 'u-navbar-color-gray-dark-v5'],
				['name' => 'u-navbar-color-green', 'value' => 'u-navbar-color-green'],
				['name' => 'u-navbar-color-blue', 'value' => 'u-navbar-color-blue'],
				['name' => 'u-navbar-color-blue-dark-v1', 'value' => 'u-navbar-color-blue-dark-v1'],
				['name' => 'u-navbar-color-lightblue', 'value' => 'u-navbar-color-lightblue'],
				['name' => 'u-navbar-color-lightblue-v1', 'value' => 'u-navbar-color-lightblue-v1'],
				['name' => 'u-navbar-color-darkblue', 'value' => 'u-navbar-color-darkblue'],
				['name' => 'u-navbar-color-indigo', 'value' => 'u-navbar-color-indigo'],
				['name' => 'u-navbar-color-red', 'value' => 'u-navbar-color-red'],
				['name' => 'u-navbar-color-lightred', 'value' => 'u-navbar-color-lightred'],
				['name' => 'u-navbar-color-darkred', 'value' => 'u-navbar-color-darkred'],
				['name' => 'u-navbar-color-purple', 'value' => 'u-navbar-color-purple'],
				['name' => 'u-navbar-color-darkpurple', 'value' => 'u-navbar-color-darkpurple'],
				['name' => 'u-navbar-color-pink', 'value' => 'u-navbar-color-pink'],
				['name' => 'u-navbar-color-pink-dark-v1', 'value' => 'u-navbar-color-pink-dark-v1'],
				['name' => 'u-navbar-color-orange', 'value' => 'u-navbar-color-orange'],
				['name' => 'u-navbar-color-deeporange', 'value' => 'u-navbar-color-deeporange'],
				['name' => 'u-navbar-color-yellow', 'value' => 'u-navbar-color-yellow'],
				['name' => 'u-navbar-color-aqua', 'value' => 'u-navbar-color-aqua'],
				['name' => 'u-navbar-color-aqua-dark-v1', 'value' => 'u-navbar-color-aqua-dark-v1'],
				['name' => 'u-navbar-color-cyan', 'value' => 'u-navbar-color-cyan'],
				['name' => 'u-navbar-color-teal', 'value' => 'u-navbar-color-teal'],
				['name' => 'u-navbar-color-brown', 'value' => 'u-navbar-color-brown'],
				['name' => 'u-navbar-color-bluegray', 'value' => 'u-navbar-color-bluegray'],
			],
		],
		'navbar-color-hover' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_COLOR_HOVER'),
			'type' => 'color',
			'subtype' => 'navbar-color-hover',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'u-navbar-color-primary--hover', 'value' => 'u-navbar-color-primary--hover'],
				['name' => 'u-navbar-color-main--hover', 'value' => 'u-navbar-color-main--hover'],
				['name' => 'u-navbar-color-black--hover', 'value' => 'u-navbar-color-black--hover'],
				['name' => 'u-navbar-color-white--hover', 'value' => 'u-navbar-color-white--hover'],
				['name' => 'u-navbar-color-gray-light-v1--hover', 'value' => 'u-navbar-color-gray-light-v1--hover'],
				['name' => 'u-navbar-color-gray-light-v2--hover', 'value' => 'u-navbar-color-gray-light-v2--hover'],
				['name' => 'u-navbar-color-gray-light-v3--hover', 'value' => 'u-navbar-color-gray-light-v3--hover'],
				['name' => 'u-navbar-color-gray-light-v4--hover', 'value' => 'u-navbar-color-gray-light-v4--hover'],
				['name' => 'u-navbar-color-gray-light-v5--hover', 'value' => 'u-navbar-color-gray-light-v5--hover'],
				['name' => 'u-navbar-color-gray-dark-v1--hover', 'value' => 'u-navbar-color-gray-dark-v1--hover'],
				['name' => 'u-navbar-color-gray-dark-v2--hover', 'value' => 'u-navbar-color-gray-dark-v2--hover'],
				['name' => 'u-navbar-color-gray-dark-v3--hover', 'value' => 'u-navbar-color-gray-dark-v3--hover'],
				['name' => 'u-navbar-color-gray-dark-v4--hover', 'value' => 'u-navbar-color-gray-dark-v4--hover'],
				['name' => 'u-navbar-color-gray-dark-v5--hover', 'value' => 'u-navbar-color-gray-dark-v5--hover'],
				['name' => 'u-navbar-color-green--hover', 'value' => 'u-navbar-color-green--hover'],
				['name' => 'u-navbar-color-blue--hover', 'value' => 'u-navbar-color-blue--hover'],
				['name' => 'u-navbar-color-blue-dark-v1--hover', 'value' => 'u-navbar-color-blue-dark-v1--hover'],
				['name' => 'u-navbar-color-lightblue--hover', 'value' => 'u-navbar-color-lightblue--hover'],
				['name' => 'u-navbar-color-lightblue-v1--hover', 'value' => 'u-navbar-color-lightblue-v1--hover'],
				['name' => 'u-navbar-color-darkblue--hover', 'value' => 'u-navbar-color-darkblue--hover'],
				['name' => 'u-navbar-color-indigo--hover', 'value' => 'u-navbar-color-indigo--hover'],
				['name' => 'u-navbar-color-red--hover', 'value' => 'u-navbar-color-red--hover'],
				['name' => 'u-navbar-color-lightred--hover', 'value' => 'u-navbar-color-lightred--hover'],
				['name' => 'u-navbar-color-darkred--hover', 'value' => 'u-navbar-color-darkred--hover'],
				['name' => 'u-navbar-color-purple--hover', 'value' => 'u-navbar-color-purple--hover'],
				['name' => 'u-navbar-color-darkpurple--hover', 'value' => 'u-navbar-color-darkpurple--hover'],
				['name' => 'u-navbar-color-pink--hover', 'value' => 'u-navbar-color-pink--hover'],
				['name' => 'u-navbar-color-pink-dark-v1--hover', 'value' => 'u-navbar-color-pink-dark-v1--hover'],
				['name' => 'u-navbar-color-orange--hover', 'value' => 'u-navbar-color-orange--hover'],
				['name' => 'u-navbar-color-deeporange--hover', 'value' => 'u-navbar-color-deeporange--hover'],
				['name' => 'u-navbar-color-yellow--hover', 'value' => 'u-navbar-color-yellow--hover'],
				['name' => 'u-navbar-color-aqua--hover', 'value' => 'u-navbar-color-aqua--hover'],
				['name' => 'u-navbar-color-aqua-dark-v1--hover', 'value' => 'u-navbar-color-aqua-dark-v1--hover'],
				['name' => 'u-navbar-color-cyan--hover', 'value' => 'u-navbar-color-cyan--hover'],
				['name' => 'u-navbar-color-teal--hover', 'value' => 'u-navbar-color-teal--hover'],
				['name' => 'u-navbar-color-brown--hover', 'value' => 'u-navbar-color-brown--hover'],
				['name' => 'u-navbar-color-bluegray--hover', 'value' => 'u-navbar-color-bluegray--hover'],
			],
		],
		'navbar-color-fix-moment' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_COLOR_FIX_MOMENT'),
			'type' => 'color',
			'subtype' => 'navbar-color-fix-moment',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'u-navbar-color-primary--fix-moment', 'value' => 'u-navbar-color-primary--fix-moment'],
				['name' => 'u-navbar-color-main--fix-moment', 'value' => 'u-navbar-color-main--fix-moment'],
				['name' => 'u-navbar-color-black--fix-moment', 'value' => 'u-navbar-color-black--fix-moment'],
				['name' => 'u-navbar-color-white--fix-moment', 'value' => 'u-navbar-color-white--fix-moment'],
				[
					'name' => 'u-navbar-color-gray-light-v1--fix-moment',
					'value' => 'u-navbar-color-gray-light-v1--fix-moment',
				],
				[
					'name' => 'u-navbar-color-gray-light-v2--fix-moment',
					'value' => 'u-navbar-color-gray-light-v2--fix-moment',
				],
				[
					'name' => 'u-navbar-color-gray-light-v3--fix-moment',
					'value' => 'u-navbar-color-gray-light-v3--fix-moment',
				],
				[
					'name' => 'u-navbar-color-gray-light-v4--fix-moment',
					'value' => 'u-navbar-color-gray-light-v4--fix-moment',
				],
				[
					'name' => 'u-navbar-color-gray-light-v5--fix-moment',
					'value' => 'u-navbar-color-gray-light-v5--fix-moment',
				],
				[
					'name' => 'u-navbar-color-gray-dark-v1--fix-moment',
					'value' => 'u-navbar-color-gray-dark-v1--fix-moment',
				],
				[
					'name' => 'u-navbar-color-gray-dark-v2--fix-moment',
					'value' => 'u-navbar-color-gray-dark-v2--fix-moment',
				],
				[
					'name' => 'u-navbar-color-gray-dark-v3--fix-moment',
					'value' => 'u-navbar-color-gray-dark-v3--fix-moment',
				],
				[
					'name' => 'u-navbar-color-gray-dark-v4--fix-moment',
					'value' => 'u-navbar-color-gray-dark-v4--fix-moment',
				],
				[
					'name' => 'u-navbar-color-gray-dark-v5--fix-moment',
					'value' => 'u-navbar-color-gray-dark-v5--fix-moment',
				],
				['name' => 'u-navbar-color-green--fix-moment', 'value' => 'u-navbar-color-green--fix-moment'],
				['name' => 'u-navbar-color-blue--fix-moment', 'value' => 'u-navbar-color-blue--fix-moment'],
				[
					'name' => 'u-navbar-color-blue-dark-v1--fix-moment',
					'value' => 'u-navbar-color-blue-dark-v1--fix-moment',
				],
				['name' => 'u-navbar-color-lightblue--fix-moment', 'value' => 'u-navbar-color-lightblue--fix-moment'],
				[
					'name' => 'u-navbar-color-lightblue-v1--fix-moment',
					'value' => 'u-navbar-color-lightblue-v1--fix-moment',
				],
				['name' => 'u-navbar-color-darkblue--fix-moment', 'value' => 'u-navbar-color-darkblue--fix-moment'],
				['name' => 'u-navbar-color-indigo--fix-moment', 'value' => 'u-navbar-color-indigo--fix-moment'],
				['name' => 'u-navbar-color-red--fix-moment', 'value' => 'u-navbar-color-red--fix-moment'],
				['name' => 'u-navbar-color-lightred--fix-moment', 'value' => 'u-navbar-color-lightred--fix-moment'],
				['name' => 'u-navbar-color-darkred--fix-moment', 'value' => 'u-navbar-color-darkred--fix-moment'],
				['name' => 'u-navbar-color-purple--fix-moment', 'value' => 'u-navbar-color-purple--fix-moment'],
				['name' => 'u-navbar-color-darkpurple--fix-moment', 'value' => 'u-navbar-color-darkpurple--fix-moment'],
				['name' => 'u-navbar-color-pink--fix-moment', 'value' => 'u-navbar-color-pink--fix-moment'],
				[
					'name' => 'u-navbar-color-pink-dark-v1--fix-moment',
					'value' => 'u-navbar-color-pink-dark-v1--fix-moment',
				],
				['name' => 'u-navbar-color-orange--fix-moment', 'value' => 'u-navbar-color-orange--fix-moment'],
				['name' => 'u-navbar-color-deeporange--fix-moment', 'value' => 'u-navbar-color-deeporange--fix-moment'],
				['name' => 'u-navbar-color-yellow--fix-moment', 'value' => 'u-navbar-color-yellow--fix-moment'],
				['name' => 'u-navbar-color-aqua--fix-moment', 'value' => 'u-navbar-color-aqua--fix-moment'],
				[
					'name' => 'u-navbar-color-aqua-dark-v1--fix-moment',
					'value' => 'u-navbar-color-aqua-dark-v1--fix-moment',
				],
				['name' => 'u-navbar-color-cyan--fix-moment', 'value' => 'u-navbar-color-cyan--fix-moment'],
				['name' => 'u-navbar-color-teal--fix-moment', 'value' => 'u-navbar-color-teal--fix-moment'],
				['name' => 'u-navbar-color-brown--fix-moment', 'value' => 'u-navbar-color-brown--fix-moment'],
				['name' => 'u-navbar-color-bluegray--fix-moment', 'value' => 'u-navbar-color-bluegray--fix-moment'],
			],
		],
		'navbar-color-fix-moment-hover' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_COLOR_FIX_MOMENT_HOVER'),
			'type' => 'color',
			'subtype' => 'navbar-color-fix-moment-hover',
			// old items for delete old classes when change and for reset
			'items' => [
				[
					'name' => 'u-navbar-color-primary--fix-moment--hover',
					'value' => 'u-navbar-color-primary--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-main--fix-moment--hover',
					'value' => 'u-navbar-color-main--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-black--fix-moment--hover',
					'value' => 'u-navbar-color-black--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-white--fix-moment--hover',
					'value' => 'u-navbar-color-white--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-gray-light-v1--fix-moment--hover',
					'value' => 'u-navbar-color-gray-light-v1--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-gray-light-v2--fix-moment--hover',
					'value' => 'u-navbar-color-gray-light-v2--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-gray-light-v3--fix-moment--hover',
					'value' => 'u-navbar-color-gray-light-v3--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-gray-light-v4--fix-moment--hover',
					'value' => 'u-navbar-color-gray-light-v4--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-gray-light-v5--fix-moment--hover',
					'value' => 'u-navbar-color-gray-light-v5--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-gray-dark-v1--fix-moment--hover',
					'value' => 'u-navbar-color-gray-dark-v1--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-gray-dark-v2--fix-moment--hover',
					'value' => 'u-navbar-color-gray-dark-v2--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-gray-dark-v3--fix-moment--hover',
					'value' => 'u-navbar-color-gray-dark-v3--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-gray-dark-v4--fix-moment--hover',
					'value' => 'u-navbar-color-gray-dark-v4--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-gray-dark-v5--fix-moment--hover',
					'value' => 'u-navbar-color-gray-dark-v5--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-green--fix-moment--hover',
					'value' => 'u-navbar-color-green--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-blue--fix-moment--hover',
					'value' => 'u-navbar-color-blue--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-blue-dark-v1--fix-moment--hover',
					'value' => 'u-navbar-color-blue-dark-v1--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-lightblue--fix-moment--hover',
					'value' => 'u-navbar-color-lightblue--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-lightblue-v1--fix-moment--hover',
					'value' => 'u-navbar-color-lightblue-v1--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-darkblue--fix-moment--hover',
					'value' => 'u-navbar-color-darkblue--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-indigo--fix-moment--hover',
					'value' => 'u-navbar-color-indigo--fix-moment--hover',
				],
				['name' => 'u-navbar-color-red--fix-moment--hover', 'value' => 'u-navbar-color-red--fix-moment--hover'],
				[
					'name' => 'u-navbar-color-lightred--fix-moment--hover',
					'value' => 'u-navbar-color-lightred--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-darkred--fix-moment--hover',
					'value' => 'u-navbar-color-darkred--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-purple--fix-moment--hover',
					'value' => 'u-navbar-color-purple--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-darkpurple--fix-moment--hover',
					'value' => 'u-navbar-color-darkpurple--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-pink--fix-moment--hover',
					'value' => 'u-navbar-color-pink--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-pink-dark-v1--fix-moment--hover',
					'value' => 'u-navbar-color-pink-dark-v1--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-orange--fix-moment--hover',
					'value' => 'u-navbar-color-orange--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-deeporange--fix-moment--hover',
					'value' => 'u-navbar-color-deeporange--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-yellow--fix-moment--hover',
					'value' => 'u-navbar-color-yellow--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-aqua--fix-moment--hover',
					'value' => 'u-navbar-color-aqua--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-aqua-dark-v1--fix-moment--hover',
					'value' => 'u-navbar-color-aqua-dark-v1--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-cyan--fix-moment--hover',
					'value' => 'u-navbar-color-cyan--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-teal--fix-moment--hover',
					'value' => 'u-navbar-color-teal--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-brown--fix-moment--hover',
					'value' => 'u-navbar-color-brown--fix-moment--hover',
				],
				[
					'name' => 'u-navbar-color-bluegray--fix-moment--hover',
					'value' => 'u-navbar-color-bluegray--fix-moment--hover',
				],
			],
		],
		'navbar-bg' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_BG'),
			'type' => 'color',
			'subtype' => 'navbar-bg-color',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'u-navbar-bg-primary', 'value' => 'u-navbar-bg-primary'],
				['name' => 'u-navbar-bg-main', 'value' => 'u-navbar-bg-main'],
				['name' => 'u-navbar-bg-black', 'value' => 'u-navbar-bg-black'],
				['name' => 'u-navbar-bg-white', 'value' => 'u-navbar-bg-white'],
				['name' => 'u-navbar-bg-gray-light-v1', 'value' => 'u-navbar-bg-gray-light-v1'],
				['name' => 'u-navbar-bg-gray-light-v2', 'value' => 'u-navbar-bg-gray-light-v2'],
				['name' => 'u-navbar-bg-gray-light-v3', 'value' => 'u-navbar-bg-gray-light-v3'],
				['name' => 'u-navbar-bg-gray-light-v4', 'value' => 'u-navbar-bg-gray-light-v4'],
				['name' => 'u-navbar-bg-gray-light-v5', 'value' => 'u-navbar-bg-gray-light-v5'],
				['name' => 'u-navbar-bg-gray-dark-v1', 'value' => 'u-navbar-bg-gray-dark-v1'],
				['name' => 'u-navbar-bg-gray-dark-v2', 'value' => 'u-navbar-bg-gray-dark-v2'],
				['name' => 'u-navbar-bg-gray-dark-v3', 'value' => 'u-navbar-bg-gray-dark-v3'],
				['name' => 'u-navbar-bg-gray-dark-v4', 'value' => 'u-navbar-bg-gray-dark-v4'],
				['name' => 'u-navbar-bg-gray-dark-v5', 'value' => 'u-navbar-bg-gray-dark-v5'],
				['name' => 'u-navbar-bg-green', 'value' => 'u-navbar-bg-green'],
				['name' => 'u-navbar-bg-blue', 'value' => 'u-navbar-bg-blue'],
				['name' => 'u-navbar-bg-blue-dark-v1', 'value' => 'u-navbar-bg-blue-dark-v1'],
				['name' => 'u-navbar-bg-lightblue', 'value' => 'u-navbar-bg-lightblue'],
				['name' => 'u-navbar-bg-lightblue-v1', 'value' => 'u-navbar-bg-lightblue-v1'],
				['name' => 'u-navbar-bg-darkblue', 'value' => 'u-navbar-bg-darkblue'],
				['name' => 'u-navbar-bg-indigo', 'value' => 'u-navbar-bg-indigo'],
				['name' => 'u-navbar-bg-red', 'value' => 'u-navbar-bg-red'],
				['name' => 'u-navbar-bg-lightred', 'value' => 'u-navbar-bg-lightred'],
				['name' => 'u-navbar-bg-darkred', 'value' => 'u-navbar-bg-darkred'],
				['name' => 'u-navbar-bg-purple', 'value' => 'u-navbar-bg-purple'],
				['name' => 'u-navbar-bg-darkpurple', 'value' => 'u-navbar-bg-darkpurple'],
				['name' => 'u-navbar-bg-pink', 'value' => 'u-navbar-bg-pink'],
				['name' => 'u-navbar-bg-pink-dark-v1', 'value' => 'u-navbar-bg-pink-dark-v1'],
				['name' => 'u-navbar-bg-orange', 'value' => 'u-navbar-bg-orange'],
				['name' => 'u-navbar-bg-deeporange', 'value' => 'u-navbar-bg-deeporange'],
				['name' => 'u-navbar-bg-yellow', 'value' => 'u-navbar-bg-yellow'],
				['name' => 'u-navbar-bg-aqua', 'value' => 'u-navbar-bg-aqua'],
				['name' => 'u-navbar-bg-aqua-dark-v1', 'value' => 'u-navbar-bg-aqua-dark-v1'],
				['name' => 'u-navbar-bg-cyan', 'value' => 'u-navbar-bg-cyan'],
				['name' => 'u-navbar-bg-teal', 'value' => 'u-navbar-bg-teal'],
				['name' => 'u-navbar-bg-brown', 'value' => 'u-navbar-bg-brown'],
				['name' => 'u-navbar-bg-bluegray', 'value' => 'u-navbar-bg-bluegray'],
				['name' => 'u-navbar-bg-transparent', 'value' => 'u-navbar-bg-transparent'],
			],
		],
		'navbar-bg-hover' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_BG_HOVER'),
			'type' => 'color',
			'subtype' => 'navbar-bg-color-hover',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'u-navbar-bg-primary--hover', 'value' => 'u-navbar-bg-primary--hover'],
				['name' => 'u-navbar-bg-main--hover', 'value' => 'u-navbar-bg-main--hover'],
				['name' => 'u-navbar-bg-black--hover', 'value' => 'u-navbar-bg-black--hover'],
				['name' => 'u-navbar-bg-white--hover', 'value' => 'u-navbar-bg-white--hover'],
				['name' => 'u-navbar-bg-gray-light-v1--hover', 'value' => 'u-navbar-bg-gray-light-v1--hover'],
				['name' => 'u-navbar-bg-gray-light-v2--hover', 'value' => 'u-navbar-bg-gray-light-v2--hover'],
				['name' => 'u-navbar-bg-gray-light-v3--hover', 'value' => 'u-navbar-bg-gray-light-v3--hover'],
				['name' => 'u-navbar-bg-gray-light-v4--hover', 'value' => 'u-navbar-bg-gray-light-v4--hover'],
				['name' => 'u-navbar-bg-gray-light-v5--hover', 'value' => 'u-navbar-bg-gray-light-v5--hover'],
				['name' => 'u-navbar-bg-gray-dark-v1--hover', 'value' => 'u-navbar-bg-gray-dark-v1--hover'],
				['name' => 'u-navbar-bg-gray-dark-v2--hover', 'value' => 'u-navbar-bg-gray-dark-v2--hover'],
				['name' => 'u-navbar-bg-gray-dark-v3--hover', 'value' => 'u-navbar-bg-gray-dark-v3--hover'],
				['name' => 'u-navbar-bg-gray-dark-v4--hover', 'value' => 'u-navbar-bg-gray-dark-v4--hover'],
				['name' => 'u-navbar-bg-gray-dark-v5--hover', 'value' => 'u-navbar-bg-gray-dark-v5--hover'],
				['name' => 'u-navbar-bg-green--hover', 'value' => 'u-navbar-bg-green--hover'],
				['name' => 'u-navbar-bg-blue--hover', 'value' => 'u-navbar-bg-blue--hover'],
				['name' => 'u-navbar-bg-blue-dark-v1--hover', 'value' => 'u-navbar-bg-blue-dark-v1--hover'],
				['name' => 'u-navbar-bg-lightblue--hover', 'value' => 'u-navbar-bg-lightblue--hover'],
				['name' => 'u-navbar-bg-lightblue-v1--hover', 'value' => 'u-navbar-bg-lightblue-v1--hover'],
				['name' => 'u-navbar-bg-darkblue--hover', 'value' => 'u-navbar-bg-darkblue--hover'],
				['name' => 'u-navbar-bg-indigo--hover', 'value' => 'u-navbar-bg-indigo--hover'],
				['name' => 'u-navbar-bg-red--hover', 'value' => 'u-navbar-bg-red--hover'],
				['name' => 'u-navbar-bg-lightred--hover', 'value' => 'u-navbar-bg-lightred--hover'],
				['name' => 'u-navbar-bg-darkred--hover', 'value' => 'u-navbar-bg-darkred--hover'],
				['name' => 'u-navbar-bg-purple--hover', 'value' => 'u-navbar-bg-purple--hover'],
				['name' => 'u-navbar-bg-darkpurple--hover', 'value' => 'u-navbar-bg-darkpurple--hover'],
				['name' => 'u-navbar-bg-pink--hover', 'value' => 'u-navbar-bg-pink--hover'],
				['name' => 'u-navbar-bg-pink-dark-v1--hover', 'value' => 'u-navbar-bg-pink-dark-v1--hover'],
				['name' => 'u-navbar-bg-orange--hover', 'value' => 'u-navbar-bg-orange--hover'],
				['name' => 'u-navbar-bg-deeporange--hover', 'value' => 'u-navbar-bg-deeporange--hover'],
				['name' => 'u-navbar-bg-yellow--hover', 'value' => 'u-navbar-bg-yellow--hover'],
				['name' => 'u-navbar-bg-aqua--hover', 'value' => 'u-navbar-bg-aqua--hover'],
				['name' => 'u-navbar-bg-aqua-dark-v1--hover', 'value' => 'u-navbar-bg-aqua-dark-v1--hover'],
				['name' => 'u-navbar-bg-cyan--hover', 'value' => 'u-navbar-bg-cyan--hover'],
				['name' => 'u-navbar-bg-teal--hover', 'value' => 'u-navbar-bg-teal--hover'],
				['name' => 'u-navbar-bg-brown--hover', 'value' => 'u-navbar-bg-brown--hover'],
				['name' => 'u-navbar-bg-bluegray--hover', 'value' => 'u-navbar-bg-bluegray--hover'],
				['name' => 'u-navbar-bg-transparent--hover', 'value' => 'u-navbar-bg-transparent--hover'],
			],
		],
		'navbar-collapse-bg' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_COLLAPSE_BG'),
			'type' => 'color',
			'subtype' => 'navbar-collapse-bg-color',
			'items' => [],
		],
		'navbar-align' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_ALIGN'),
			'property' => 'text-align',
			'type' => 'buttons',
			'items' => [
				[
					'name' => '<span class="landing-ui-align landing-ui-align-left"><em></em></span>',
					'value' => 'u-navbar-align-left',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-center"><em></em></span>',
					'value' => 'u-navbar-align-center',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-around"><em></em></span>',
					'value' => 'u-navbar-align-around',
				],
				[
					'name' => '<span class="landing-ui-align landing-ui-align-right"><em></em></span>',
					'value' => 'u-navbar-align-right',
				],
			],
		],
		'navbar-marker' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_MARKER'),
			'type' => 'list',
			'items' => [
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_MARKER_NO'), 'value' => 'u-navbar-marker--no'],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_MARKER_ARROW'),
					'value' => 'u-navbar-marker--arrow',
				],
			],
		],

		// 'navbar-open-type' => array(
		// 	'name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_OPEN_TYPE'),
		// 	'type' => 'list',
		// 	'items' => array(
		// 		array('name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_NO_MODAL'), 'value' => 'u-navbar-no-modal'),
		// 		array('name' => Loc::getMessage('LANDING_BLOCK_STYLE_NAVBAR_MODAL'), 'value' => 'u-navbar-modal'),
		// 	),
		// ),

		'hamburger-size' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_HAMB_SIZE'),
			'type' => 'list',
			'items' => [
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_HAMB_SIZE_MD'), 'value' => 'hamburger--md'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_HAMB_SIZE_SM'), 'value' => 'hamburger--sm'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_HAMB_SIZE_LG'), 'value' => 'hamburger--lg'],
			],
		],
		'hamburger-animation' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_HAMB_ICON'),
			'type' => 'list',
			'items' => [
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_HAMB_ICON_SLIDER'), 'value' => 'hamburger--slider'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_HAMB_ICON_MINUS'), 'value' => 'hamburger--minus'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_HAMB_ICON_ARROW'), 'value' => 'hamburger--arrow'],
			],
		],

		'header-on-scroll' => [
			'name' => Loc::getMessage('LND_BL_STL_HEADER_SCROLL'),
			'type' => 'list',
			'items' => [
				['name' => Loc::getMessage('LND_BL_STL_HEADER_SCROLL_STICKY'), 'value' => 'u-header--sticky'],
				['name' => Loc::getMessage('LND_BL_STL_HEADER_SCROLL_STATIC'), 'value' => 'u-header--static'],
			],
		],
		'header-position' => [
			'name' => Loc::getMessage('LND_BL_STL_HEADER_POS'),
			'type' => 'list',
			'items' => [
				['name' => Loc::getMessage('LND_BL_STL_HEADER_POS_FLOAT'), 'value' => 'u-header--float'],
				['name' => Loc::getMessage('LND_BL_STL_HEADER_POS_REL'), 'value' => 'u-header--relative'],
			],
		],

		'border-color' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BORDER_COLOR'),
			'type' => 'color',
			'subtype' => 'border-color',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'g-brd-primary', 'value' => 'g-brd-primary'],
				['name' => 'g-brd-primary-opacity-0_3', 'value' => 'g-brd-primary-opacity-0_3'],
				['name' => 'g-brd-primary-dark-v1', 'value' => 'g-brd-primary-dark-v1'],
				['name' => 'g-brd-primary-dark-v2', 'value' => 'g-brd-primary-dark-v2'],
				['name' => 'g-brd-primary-dark-v3', 'value' => 'g-brd-primary-dark-v3'],
				['name' => 'g-brd-main', 'value' => 'g-brd-main'],
				['name' => 'g-brd-black', 'value' => 'g-brd-black'],
				['name' => 'g-brd-black-opacity-0_1', 'value' => 'g-brd-black-opacity-0_1'],
				['name' => 'g-brd-black-opacity-0_2', 'value' => 'g-brd-black-opacity-0_2'],
				['name' => 'g-brd-black-opacity-0_3', 'value' => 'g-brd-black-opacity-0_3'],
				['name' => 'g-brd-black-opacity-0_4', 'value' => 'g-brd-black-opacity-0_4'],
				['name' => 'g-brd-black-opacity-0_5', 'value' => 'g-brd-black-opacity-0_5'],
				['name' => 'g-brd-black-opacity-0_6', 'value' => 'g-brd-black-opacity-0_6'],
				['name' => 'g-brd-black-opacity-0_8', 'value' => 'g-brd-black-opacity-0_8'],
				['name' => 'g-brd-white', 'value' => 'g-brd-white'],
				['name' => 'g-brd-white-opacity-0_1', 'value' => 'g-brd-white-opacity-0_1'],
				['name' => 'g-brd-white-opacity-0_2', 'value' => 'g-brd-white-opacity-0_2'],
				['name' => 'g-brd-white-opacity-0_3', 'value' => 'g-brd-white-opacity-0_3'],
				['name' => 'g-brd-white-opacity-0_4', 'value' => 'g-brd-white-opacity-0_4'],
				['name' => 'g-brd-white-opacity-0_5', 'value' => 'g-brd-white-opacity-0_5'],
				['name' => 'g-brd-white-opacity-0_6', 'value' => 'g-brd-white-opacity-0_6'],
				['name' => 'g-brd-white-opacity-0_8', 'value' => 'g-brd-white-opacity-0_8'],
				['name' => 'g-brd-gray-dark-v1', 'value' => 'g-brd-gray-dark-v1'],
				['name' => 'g-brd-gray-dark-v2', 'value' => 'g-brd-gray-dark-v2'],
				['name' => 'g-brd-gray-dark-v3', 'value' => 'g-brd-gray-dark-v3'],
				['name' => 'g-brd-gray-dark-v4', 'value' => 'g-brd-gray-dark-v4'],
				['name' => 'g-brd-gray-dark-v5', 'value' => 'g-brd-gray-dark-v5'],
				['name' => 'g-brd-gray-light-v1', 'value' => 'g-brd-gray-light-v1'],
				['name' => 'g-brd-gray-light-v2', 'value' => 'g-brd-gray-light-v2'],
				['name' => 'g-brd-gray-light-v3', 'value' => 'g-brd-gray-light-v3'],
				['name' => 'g-brd-gray-light-v4', 'value' => 'g-brd-gray-light-v4'],
				['name' => 'g-brd-gray-light-v5', 'value' => 'g-brd-gray-light-v5'],
				['name' => 'g-brd-transparent', 'value' => 'g-brd-transparent'],
				['name' => 'g-brd-green', 'value' => 'g-brd-green'],
				['name' => 'g-brd-blue', 'value' => 'g-brd-blue'],
				['name' => 'g-brd-lightblue', 'value' => 'g-brd-lightblue'],
				['name' => 'g-brd-darkblue', 'value' => 'g-brd-darkblue'],
				['name' => 'g-brd-indigo', 'value' => 'g-brd-indigo'],
				['name' => 'g-brd-purple', 'value' => 'g-brd-purple'],
				['name' => 'g-brd-darkpurple', 'value' => 'g-brd-darkpurple'],
				['name' => 'g-brd-pink', 'value' => 'g-brd-pink'],
				['name' => 'g-brd-red', 'value' => 'g-brd-red'],
				['name' => 'g-brd-lightred', 'value' => 'g-brd-lightred'],
				['name' => 'g-brd-darkred', 'value' => 'g-brd-darkred'],
				['name' => 'g-brd-orange', 'value' => 'g-brd-orange'],
				['name' => 'g-brd-deeporange', 'value' => 'g-brd-deeporange'],
				['name' => 'g-brd-yellow', 'value' => 'g-brd-yellow'],
				['name' => 'g-brd-aqua', 'value' => 'g-brd-aqua'],
				['name' => 'g-brd-cyan', 'value' => 'g-brd-cyan'],
				['name' => 'g-brd-teal', 'value' => 'g-brd-teal'],
				['name' => 'g-brd-brown', 'value' => 'g-brd-brown'],
				['name' => 'g-brd-bluegray', 'value' => 'g-brd-bluegray'],
				['name' => 'g-theme-bitrix-brd-v3', 'value' => 'g-theme-bitrix-brd-v3'],
				['name' => 'g-theme-bitrix-brd-v4', 'value' => 'g-theme-bitrix-brd-v4'],
			],
		],
		'border-color-hover' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BORDER_COLOR_HOVER'),
			'type' => 'color',
			'subtype' => 'border-color-hover',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'g-brd-primary--hover', 'value' => 'g-brd-primary--hover'],
				['name' => 'g-brd-primary-opacity-0_3--hover', 'value' => 'g-brd-primary-opacity-0_3--hover'],
				['name' => 'g-brd-primary-dark-v1--hover', 'value' => 'g-brd-primary-dark-v1--hover'],
				['name' => 'g-brd-primary-dark-v2--hover', 'value' => 'g-brd-primary-dark-v2--hover'],
				['name' => 'g-brd-primary-dark-v3--hover', 'value' => 'g-brd-primary-dark-v3--hover'],
				['name' => 'g-brd-main--hover', 'value' => 'g-brd-main--hover'],
				['name' => 'g-brd-black--hover', 'value' => 'g-brd-black--hover'],
				['name' => 'g-brd-black-opacity-0_1--hover', 'value' => 'g-brd-black-opacity-0_1--hover'],
				['name' => 'g-brd-black-opacity-0_2--hover', 'value' => 'g-brd-black-opacity-0_2--hover'],
				['name' => 'g-brd-black-opacity-0_3--hover', 'value' => 'g-brd-black-opacity-0_3--hover'],
				['name' => 'g-brd-black-opacity-0_4--hover', 'value' => 'g-brd-black-opacity-0_4--hover'],
				['name' => 'g-brd-black-opacity-0_5--hover', 'value' => 'g-brd-black-opacity-0_5--hover'],
				['name' => 'g-brd-black-opacity-0_6--hover', 'value' => 'g-brd-black-opacity-0_6--hover'],
				['name' => 'g-brd-black-opacity-0_8--hover', 'value' => 'g-brd-black-opacity-0_8--hover'],
				['name' => 'g-brd-white--hover', 'value' => 'g-brd-white--hover'],
				['name' => 'g-brd-white-opacity-0_1--hover', 'value' => 'g-brd-white-opacity-0_1--hover'],
				['name' => 'g-brd-white-opacity-0_2--hover', 'value' => 'g-brd-white-opacity-0_2--hover'],
				['name' => 'g-brd-white-opacity-0_3--hover', 'value' => 'g-brd-white-opacity-0_3--hover'],
				['name' => 'g-brd-white-opacity-0_4--hover', 'value' => 'g-brd-white-opacity-0_4--hover'],
				['name' => 'g-brd-white-opacity-0_5--hover', 'value' => 'g-brd-white-opacity-0_5--hover'],
				['name' => 'g-brd-white-opacity-0_6--hover', 'value' => 'g-brd-white-opacity-0_6--hover'],
				['name' => 'g-brd-white-opacity-0_8--hover', 'value' => 'g-brd-white-opacity-0_8--hover'],
				['name' => 'g-brd-gray-dark-v1--hover', 'value' => 'g-brd-gray-dark-v1--hover'],
				['name' => 'g-brd-gray-dark-v2--hover', 'value' => 'g-brd-gray-dark-v2--hover'],
				['name' => 'g-brd-gray-dark-v3--hover', 'value' => 'g-brd-gray-dark-v3--hover'],
				['name' => 'g-brd-gray-dark-v4--hover', 'value' => 'g-brd-gray-dark-v4--hover'],
				['name' => 'g-brd-gray-dark-v5--hover', 'value' => 'g-brd-gray-dark-v5--hover'],
				['name' => 'g-brd-gray-light-v1--hover', 'value' => 'g-brd-gray-light-v1--hover'],
				['name' => 'g-brd-gray-light-v2--hover', 'value' => 'g-brd-gray-light-v2--hover'],
				['name' => 'g-brd-gray-light-v3--hover', 'value' => 'g-brd-gray-light-v3--hover'],
				['name' => 'g-brd-gray-light-v4--hover', 'value' => 'g-brd-gray-light-v4--hover'],
				['name' => 'g-brd-gray-light-v5--hover', 'value' => 'g-brd-gray-light-v5--hover'],
				['name' => 'g-brd-transparent--hover', 'value' => 'g-brd-transparent--hover'],
				['name' => 'g-brd-green--hover', 'value' => 'g-brd-green--hover'],
				['name' => 'g-brd-blue--hover', 'value' => 'g-brd-blue--hover'],
				['name' => 'g-brd-lightblue--hover', 'value' => 'g-brd-lightblue--hover'],
				['name' => 'g-brd-darkblue--hover', 'value' => 'g-brd-darkblue--hover'],
				['name' => 'g-brd-indigo--hover', 'value' => 'g-brd-indigo--hover'],
				['name' => 'g-brd-purple--hover', 'value' => 'g-brd-purple--hover'],
				['name' => 'g-brd-darkpurple--hover', 'value' => 'g-brd-darkpurple--hover'],
				['name' => 'g-brd-pink--hover', 'value' => 'g-brd-pink--hover'],
				['name' => 'g-brd-red--hover', 'value' => 'g-brd-red--hover'],
				['name' => 'g-brd-lightred--hover', 'value' => 'g-brd-lightred--hover'],
				['name' => 'g-brd-darkred--hover', 'value' => 'g-brd-darkred--hover'],
				['name' => 'g-brd-orange--hover', 'value' => 'g-brd-orange--hover'],
				['name' => 'g-brd-deeporange--hover', 'value' => 'g-brd-deeporange--hover'],
				['name' => 'g-brd-yellow--hover', 'value' => 'g-brd-yellow--hover'],
				['name' => 'g-brd-aqua--hover', 'value' => 'g-brd-aqua--hover'],
				['name' => 'g-brd-cyan--hover', 'value' => 'g-brd-cyan--hover'],
				['name' => 'g-brd-teal--hover', 'value' => 'g-brd-teal--hover'],
				['name' => 'g-brd-brown--hover', 'value' => 'g-brd-brown--hover'],
				['name' => 'g-brd-bluegray--hover', 'value' => 'g-brd-bluegray--hover'],
				['name' => 'g-theme-bitrix-brd-v3--hover', 'value' => 'g-theme-bitrix-brd-v3--hover'],
				['name' => 'g-theme-bitrix-brd-v4--hover', 'value' => 'g-theme-bitrix-brd-v4--hover'],
			],
		],
		'border-top-color' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BORDER_TOP_COLOR'),
			'type' => 'color',
			'subtype' => 'border-color-top',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'g-brd-primary-top', 'value' => 'g-brd-primary-top'],
				['name' => 'g-brd-primary-opacity-0_3-top', 'value' => 'g-brd-primary-opacity-0_3-top'],
				['name' => 'g-brd-primary-dark-v1-top', 'value' => 'g-brd-primary-dark-v1-top'],
				['name' => 'g-brd-primary-dark-v2-top', 'value' => 'g-brd-primary-dark-v2-top'],
				['name' => 'g-brd-primary-dark-v3-top', 'value' => 'g-brd-primary-dark-v3-top'],
				['name' => 'g-brd-main-top', 'value' => 'g-brd-main-top'],
				['name' => 'g-brd-black-top', 'value' => 'g-brd-black-top'],
				['name' => 'g-brd-black-opacity-0_1-top', 'value' => 'g-brd-black-opacity-0_1-top'],
				['name' => 'g-brd-black-opacity-0_2-top', 'value' => 'g-brd-black-opacity-0_2-top'],
				['name' => 'g-brd-black-opacity-0_3-top', 'value' => 'g-brd-black-opacity-0_3-top'],
				['name' => 'g-brd-black-opacity-0_4-top', 'value' => 'g-brd-black-opacity-0_4-top'],
				['name' => 'g-brd-black-opacity-0_5-top', 'value' => 'g-brd-black-opacity-0_5-top'],
				['name' => 'g-brd-black-opacity-0_6-top', 'value' => 'g-brd-black-opacity-0_6-top'],
				['name' => 'g-brd-black-opacity-0_8-top', 'value' => 'g-brd-black-opacity-0_8-top'],
				['name' => 'g-brd-white-top', 'value' => 'g-brd-white-top'],
				['name' => 'g-brd-white-opacity-0_1-top', 'value' => 'g-brd-white-opacity-0_1-top'],
				['name' => 'g-brd-white-opacity-0_2-top', 'value' => 'g-brd-white-opacity-0_2-top'],
				['name' => 'g-brd-white-opacity-0_3-top', 'value' => 'g-brd-white-opacity-0_3-top'],
				['name' => 'g-brd-white-opacity-0_4-top', 'value' => 'g-brd-white-opacity-0_4-top'],
				['name' => 'g-brd-white-opacity-0_5-top', 'value' => 'g-brd-white-opacity-0_5-top'],
				['name' => 'g-brd-white-opacity-0_6-top', 'value' => 'g-brd-white-opacity-0_6-top'],
				['name' => 'g-brd-white-opacity-0_8-top', 'value' => 'g-brd-white-opacity-0_8-top'],
				['name' => 'g-brd-gray-dark-v1-top', 'value' => 'g-brd-gray-dark-v1-top'],
				['name' => 'g-brd-gray-dark-v2-top', 'value' => 'g-brd-gray-dark-v2-top'],
				['name' => 'g-brd-gray-dark-v3-top', 'value' => 'g-brd-gray-dark-v3-top'],
				['name' => 'g-brd-gray-dark-v4-top', 'value' => 'g-brd-gray-dark-v4-top'],
				['name' => 'g-brd-gray-dark-v5-top', 'value' => 'g-brd-gray-dark-v5-top'],
				['name' => 'g-brd-gray-light-v1-top', 'value' => 'g-brd-gray-light-v1-top'],
				['name' => 'g-brd-gray-light-v2-top', 'value' => 'g-brd-gray-light-v2-top'],
				['name' => 'g-brd-gray-light-v3-top', 'value' => 'g-brd-gray-light-v3-top'],
				['name' => 'g-brd-gray-light-v4-top', 'value' => 'g-brd-gray-light-v4-top'],
				['name' => 'g-brd-gray-light-v5-top', 'value' => 'g-brd-gray-light-v5-top'],
				['name' => 'g-brd-transparent-top', 'value' => 'g-brd-transparent-top'],
				['name' => 'g-brd-green-top', 'value' => 'g-brd-green-top'],
				['name' => 'g-brd-blue-top', 'value' => 'g-brd-blue-top'],
				['name' => 'g-brd-lightblue-top', 'value' => 'g-brd-lightblue-top'],
				['name' => 'g-brd-darkblue-top', 'value' => 'g-brd-darkblue-top'],
				['name' => 'g-brd-indigo-top', 'value' => 'g-brd-indigo-top'],
				['name' => 'g-brd-purple-top', 'value' => 'g-brd-purple-top'],
				['name' => 'g-brd-darkpurple-top', 'value' => 'g-brd-darkpurple-top'],
				['name' => 'g-brd-pink-top', 'value' => 'g-brd-pink-top'],
				['name' => 'g-brd-red-top', 'value' => 'g-brd-red-top'],
				['name' => 'g-brd-lightred-top', 'value' => 'g-brd-lightred-top'],
				['name' => 'g-brd-darkred-top', 'value' => 'g-brd-darkred-top'],
				['name' => 'g-brd-orange-top', 'value' => 'g-brd-orange-top'],
				['name' => 'g-brd-deeporange-top', 'value' => 'g-brd-deeporange-top'],
				['name' => 'g-brd-yellow-top', 'value' => 'g-brd-yellow-top'],
				['name' => 'g-brd-aqua-top', 'value' => 'g-brd-aqua-top'],
				['name' => 'g-brd-cyan-top', 'value' => 'g-brd-cyan-top'],
				['name' => 'g-brd-teal-top', 'value' => 'g-brd-teal-top'],
				['name' => 'g-brd-brown-top', 'value' => 'g-brd-brown-top'],
				['name' => 'g-brd-bluegray-top', 'value' => 'g-brd-bluegray-top'],
				['name' => 'g-theme-bitrix-brd-v3-top', 'value' => 'g-theme-bitrix-brd-v3-top'],
				['name' => 'g-theme-bitrix-brd-v4-top', 'value' => 'g-theme-bitrix-brd-v4-top'],
			],
		],
		'border-radius' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BORDER_RADIUS'),
			'property' => 'border-radius',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-rounded-auto'],
				['name' => '0', 'value' => 'rounded-0'],
				['name' => '1', 'value' => 'g-rounded-1'],
				['name' => '2', 'value' => 'g-rounded-2'],
				['name' => '3', 'value' => 'g-rounded-3'],
				['name' => '4', 'value' => 'g-rounded-4'],
				['name' => '5', 'value' => 'g-rounded-5'],
				['name' => '6', 'value' => 'g-rounded-6'],
				['name' => '7', 'value' => 'g-rounded-7'],
				['name' => '10', 'value' => 'g-rounded-10'],
				['name' => '15', 'value' => 'g-rounded-15'],
				['name' => '20', 'value' => 'g-rounded-20'],
				['name' => '25', 'value' => 'g-rounded-25'],
				['name' => '30', 'value' => 'g-rounded-30'],
				['name' => '50', 'value' => 'g-rounded-50'],
			],
		],
		'border-width' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BORDER_WIDTH'),
			'property' => 'border-width',
			'type' => 'slider',
			'items' => [
				['name' => '0', 'value' => 'g-brd-0'],
				['name' => '1', 'value' => 'g-brd-1'],
				['name' => '2', 'value' => 'g-brd-2'],
				['name' => '3', 'value' => 'g-brd-3'],
				['name' => '4', 'value' => 'g-brd-4'],
				['name' => '5', 'value' => 'g-brd-5'],
				['name' => '6', 'value' => 'g-brd-6'],
				['name' => '7', 'value' => 'g-brd-7'],
				['name' => '10', 'value' => 'g-brd-10'],
				['name' => '12', 'value' => 'g-brd-12'],
				['name' => '15', 'value' => 'g-brd-15'],
			],
		],
		'box-shadow' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW'),
			'property' => 'box-shadow',
			'type' => 'list',
			'items' => [
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_WITHOUT_SHADOW'), 'value' => 'g-box-shadow-none'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 1", 'value' => 'u-shadow-v1-1'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 2", 'value' => 'u-shadow-v1-2'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 3", 'value' => 'u-shadow-v1-3'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 4", 'value' => 'u-shadow-v1-4'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 5", 'value' => 'u-shadow-v1-5'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 6", 'value' => 'u-shadow-v1-6'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 7", 'value' => 'u-shadow-v1-7'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 8", 'value' => 'u-shadow-v6'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 9", 'value' => 'u-shadow-v7'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 10", 'value' => 'u-shadow-v8'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 11", 'value' => 'u-shadow-v9'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 12", 'value' => 'u-shadow-v10'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 13", 'value' => 'u-shadow-v11'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 14", 'value' => 'u-shadow-v12'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 15", 'value' => 'u-shadow-v13'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 16", 'value' => 'u-shadow-v14'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 17", 'value' => 'u-shadow-v15'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 18", 'value' => 'u-shadow-v16'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 19", 'value' => 'u-shadow-v17'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 20", 'value' => 'u-shadow-v18'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 21", 'value' => 'u-shadow-v19'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 22", 'value' => 'u-shadow-v20'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 23", 'value' => 'u-shadow-v21'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 24", 'value' => 'u-shadow-v22'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 25", 'value' => 'u-shadow-v23'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 26", 'value' => 'u-shadow-v24'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 27", 'value' => 'u-shadow-v25'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 28", 'value' => 'u-shadow-v26'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 29", 'value' => 'u-shadow-v27'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 30", 'value' => 'u-shadow-v28'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 31", 'value' => 'u-shadow-v29'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 32", 'value' => 'u-shadow-v30'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 33", 'value' => 'u-shadow-v31'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 34", 'value' => 'u-shadow-v32'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 35", 'value' => 'u-shadow-v33'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 36", 'value' => 'u-shadow-v34'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 37", 'value' => 'u-shadow-v35'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 38", 'value' => 'u-shadow-custom-v1'],
			],
		],
		'text-shadow' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_TEXT_SHADOW'),
			'property' => 'text-shadow',
			'type' => 'list',
			'items' => [
				['name' => Loc::getMessage('LANDING_TEXT_STYLE_WITHOUT_SHADOW'), 'value' => 'g-text-shadow-none'],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 1",
					'value' => 'custom-text-shadow-1',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 2",
					'value' => 'custom-text-shadow-2',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 3",
					'value' => 'custom-text-shadow-3',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 4",
					'value' => 'custom-text-shadow-4',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 5",
					'value' => 'custom-text-shadow-5',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 6",
					'value' => 'custom-text-shadow-6',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 7",
					'value' => 'custom-text-shadow-7',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 8",
					'value' => 'custom-text-shadow-8',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 9",
					'value' => 'custom-text-shadow-9',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 10",
					'value' => 'custom-text-shadow-10',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SHADOW_NAME') . " 11",
					'value' => 'custom-text-shadow-11',
				],
			],
		],
		'opacity' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_OPACITY'),
			'property' => 'opacity',
			'type' => 'slider',
			'items' => [
				['name' => '0', 'value' => 'opacity-1'],
				['name' => '20%', 'value' => 'g-opacity-0_8'],
				['name' => '30%', 'value' => 'g-opacity-0_7'],
				['name' => '40%', 'value' => 'g-opacity-0_6'],
				['name' => '50%', 'value' => 'g-opacity-0_5'],
				['name' => '60%', 'value' => 'g-opacity-0_4'],
				['name' => '70%', 'value' => 'g-opacity-0_3'],
				['name' => '100%', 'value' => 'opacity-0'],
			],
		],
		'padding-top' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_PADDING_TOP'),
			'property' => 'padding-top',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-pt-auto'],
				['name' => '0', 'value' => 'g-pt-0'],
				['name' => '1', 'value' => 'g-pt-1'],
				['name' => '2', 'value' => 'g-pt-2'],
				['name' => '3', 'value' => 'g-pt-3'],
				['name' => '4', 'value' => 'g-pt-4'],
				['name' => '5', 'value' => 'g-pt-5'],
				['name' => '6', 'value' => 'g-pt-6'],
				['name' => '7', 'value' => 'g-pt-7'],
				['name' => '8', 'value' => 'g-pt-8'],
				['name' => '9', 'value' => 'g-pt-9'],
				['name' => '10', 'value' => 'g-pt-10'],
				['name' => '14', 'value' => 'g-pt-14'],
				['name' => '15', 'value' => 'g-pt-15'],
				['name' => '20', 'value' => 'g-pt-20'],
				['name' => '25', 'value' => 'g-pt-25'],
				['name' => '30', 'value' => 'g-pt-30'],
				['name' => '35', 'value' => 'g-pt-35'],
				['name' => '40', 'value' => 'g-pt-40'],
				['name' => '45', 'value' => 'g-pt-45'],
				['name' => '50', 'value' => 'g-pt-50'],
				['name' => '55', 'value' => 'g-pt-55'],
				['name' => '60', 'value' => 'g-pt-60'],
				['name' => '65', 'value' => 'g-pt-65'],
				['name' => '70', 'value' => 'g-pt-70'],
				['name' => '75', 'value' => 'g-pt-75'],
				['name' => '80', 'value' => 'g-pt-80'],
				['name' => '85', 'value' => 'g-pt-85'],
				['name' => '90', 'value' => 'g-pt-90'],
				['name' => '95', 'value' => 'g-pt-95'],
				['name' => '100', 'value' => 'g-pt-100'],
				['name' => '105', 'value' => 'g-pt-105'],
				['name' => '110', 'value' => 'g-pt-110'],
				['name' => '115', 'value' => 'g-pt-115'],
				['name' => '120', 'value' => 'g-pt-120'],
				['name' => '125', 'value' => 'g-pt-125'],
				['name' => '130', 'value' => 'g-pt-130'],
				['name' => '135', 'value' => 'g-pt-135'],
				['name' => '140', 'value' => 'g-pt-140'],
				['name' => '145', 'value' => 'g-pt-145'],
				['name' => '150', 'value' => 'g-pt-150'],
			],
		],
		'padding-bottom' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_PADDING_BOTTOM'),
			'property' => 'padding-bottom',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-pb-auto'],
				['name' => '0', 'value' => 'g-pb-0'],
				['name' => '1', 'value' => 'g-pb-1'],
				['name' => '2', 'value' => 'g-pb-2'],
				['name' => '3', 'value' => 'g-pb-3'],
				['name' => '4', 'value' => 'g-pb-4'],
				['name' => '5', 'value' => 'g-pb-5'],
				['name' => '6', 'value' => 'g-pb-6'],
				['name' => '7', 'value' => 'g-pb-7'],
				['name' => '8', 'value' => 'g-pb-8'],
				['name' => '9', 'value' => 'g-pb-9'],
				['name' => '10', 'value' => 'g-pb-10'],
				['name' => '14', 'value' => 'g-pb-14'],
				['name' => '15', 'value' => 'g-pb-15'],
				['name' => '20', 'value' => 'g-pb-20'],
				['name' => '25', 'value' => 'g-pb-25'],
				['name' => '30', 'value' => 'g-pb-30'],
				['name' => '35', 'value' => 'g-pb-35'],
				['name' => '40', 'value' => 'g-pb-40'],
				['name' => '45', 'value' => 'g-pb-45'],
				['name' => '50', 'value' => 'g-pb-50'],
				['name' => '55', 'value' => 'g-pb-55'],
				['name' => '60', 'value' => 'g-pb-60'],
				['name' => '65', 'value' => 'g-pb-65'],
				['name' => '70', 'value' => 'g-pb-70'],
				['name' => '75', 'value' => 'g-pb-75'],
				['name' => '80', 'value' => 'g-pb-80'],
				['name' => '85', 'value' => 'g-pb-85'],
				['name' => '90', 'value' => 'g-pb-90'],
				['name' => '95', 'value' => 'g-pb-95'],
				['name' => '100', 'value' => 'g-pb-100'],
				['name' => '105', 'value' => 'g-pb-105'],
				['name' => '110', 'value' => 'g-pb-110'],
				['name' => '115', 'value' => 'g-pb-115'],
				['name' => '120', 'value' => 'g-pb-120'],
				['name' => '125', 'value' => 'g-pb-125'],
				['name' => '130', 'value' => 'g-pb-130'],
				['name' => '135', 'value' => 'g-pb-135'],
				['name' => '140', 'value' => 'g-pb-140'],
				['name' => '145', 'value' => 'g-pb-145'],
				['name' => '150', 'value' => 'g-pb-150'],
			],
		],
		'padding-left' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_PADDING_LEFT'),
			'property' => 'padding-left',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-pl-auto'],
				['name' => '0', 'value' => 'g-pl-0'],
				['name' => '1', 'value' => 'g-pl-1'],
				['name' => '2', 'value' => 'g-pl-2'],
				['name' => '3', 'value' => 'g-pl-3'],
				['name' => '4', 'value' => 'g-pl-4'],
				['name' => '5', 'value' => 'g-pl-5'],
				['name' => '6', 'value' => 'g-pl-6'],
				['name' => '7', 'value' => 'g-pl-7'],
				['name' => '8', 'value' => 'g-pl-8'],
				['name' => '9', 'value' => 'g-pl-9'],
				['name' => '10', 'value' => 'g-pl-10'],
				['name' => '15', 'value' => 'g-pl-15'],
				['name' => '20', 'value' => 'g-pl-20'],
				['name' => '25', 'value' => 'g-pl-25'],
				['name' => '30', 'value' => 'g-pl-30'],
				['name' => '35', 'value' => 'g-pl-35'],
				['name' => '40', 'value' => 'g-pl-40'],
				['name' => '45', 'value' => 'g-pl-45'],
				['name' => '50', 'value' => 'g-pl-50'],
				['name' => '55', 'value' => 'g-pl-55'],
				['name' => '60', 'value' => 'g-pl-60'],
				['name' => '65', 'value' => 'g-pl-65'],
				['name' => '70', 'value' => 'g-pl-70'],
				['name' => '75', 'value' => 'g-pl-75'],
				['name' => '80', 'value' => 'g-pl-80'],
				['name' => '85', 'value' => 'g-pl-85'],
				['name' => '90', 'value' => 'g-pl-90'],
				['name' => '95', 'value' => 'g-pl-95'],
				['name' => '100', 'value' => 'g-pl-100'],
				['name' => '105', 'value' => 'g-pl-105'],
				['name' => '110', 'value' => 'g-pl-110'],
				['name' => '115', 'value' => 'g-pl-115'],
				['name' => '120', 'value' => 'g-pl-120'],
				['name' => '125', 'value' => 'g-pl-125'],
				['name' => '130', 'value' => 'g-pl-130'],
				['name' => '135', 'value' => 'g-pl-135'],
				['name' => '140', 'value' => 'g-pl-140'],
				['name' => '145', 'value' => 'g-pl-145'],
				['name' => '150', 'value' => 'g-pl-150'],
				['name' => '155', 'value' => 'g-pl-155'],
				['name' => '160', 'value' => 'g-pl-160'],
				['name' => '165', 'value' => 'g-pl-165'],
				['name' => '170', 'value' => 'g-pl-170'],
			],
		],
		'padding-right' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_PADDING_RIGHT'),
			'property' => 'padding-right',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-pr-auto'],
				['name' => '0', 'value' => 'g-pr-0'],
				['name' => '1', 'value' => 'g-pr-1'],
				['name' => '2', 'value' => 'g-pr-2'],
				['name' => '3', 'value' => 'g-pr-3'],
				['name' => '4', 'value' => 'g-pr-4'],
				['name' => '5', 'value' => 'g-pr-5'],
				['name' => '6', 'value' => 'g-pr-6'],
				['name' => '7', 'value' => 'g-pr-7'],
				['name' => '8', 'value' => 'g-pr-8'],
				['name' => '9', 'value' => 'g-pr-9'],
				['name' => '10', 'value' => 'g-pr-10'],
				['name' => '15', 'value' => 'g-pr-15'],
				['name' => '20', 'value' => 'g-pr-20'],
				['name' => '25', 'value' => 'g-pr-25'],
				['name' => '30', 'value' => 'g-pr-30'],
				['name' => '35', 'value' => 'g-pr-35'],
				['name' => '40', 'value' => 'g-pr-40'],
				['name' => '45', 'value' => 'g-pr-45'],
				['name' => '50', 'value' => 'g-pr-50'],
				['name' => '55', 'value' => 'g-pr-55'],
				['name' => '60', 'value' => 'g-pr-60'],
				['name' => '65', 'value' => 'g-pr-65'],
				['name' => '70', 'value' => 'g-pr-70'],
				['name' => '75', 'value' => 'g-pr-75'],
				['name' => '80', 'value' => 'g-pr-80'],
				['name' => '85', 'value' => 'g-pr-85'],
				['name' => '90', 'value' => 'g-pr-90'],
				['name' => '95', 'value' => 'g-pr-95'],
				['name' => '100', 'value' => 'g-pr-100'],
				['name' => '105', 'value' => 'g-pr-105'],
				['name' => '110', 'value' => 'g-pr-110'],
				['name' => '115', 'value' => 'g-pr-115'],
				['name' => '120', 'value' => 'g-pr-120'],
				['name' => '125', 'value' => 'g-pr-125'],
				['name' => '130', 'value' => 'g-pr-130'],
				['name' => '135', 'value' => 'g-pr-135'],
				['name' => '140', 'value' => 'g-pr-140'],
				['name' => '145', 'value' => 'g-pr-145'],
				['name' => '150', 'value' => 'g-pr-150'],
				['name' => '155', 'value' => 'g-pr-155'],
				['name' => '160', 'value' => 'g-pr-160'],
				['name' => '165', 'value' => 'g-pr-165'],
				['name' => '170', 'value' => 'g-pr-170'],
			],
		],
		'button-padding' => [
			'name' => Loc::getMessage('LANDING_BLOCK_BUTTON_WIDTH'),
			'property' => 'padding',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-btn-px-auto'],
				['name' => 'S', 'value' => 'g-btn-px-s'],
				['name' => 'M', 'value' => 'g-btn-px-m'],
				['name' => 'L', 'value' => 'g-btn-px-l'],
				['name' => '100%', 'value' => 'g-width-100x'],
			],
		],
		'margin-top' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_MARGIN_TOP_1'),
			'property' => 'margin-top',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-mt-auto'],
				['name' => '-10', 'value' => 'g-mt-minus-10'],
				['name' => '-5', 'value' => 'g-mt-minus-5'],
				['name' => '0', 'value' => 'g-mt-0'],
				['name' => '1', 'value' => 'g-mt-1'],
				['name' => '2', 'value' => 'g-mt-2'],
				['name' => '3', 'value' => 'g-mt-3'],
				['name' => '4', 'value' => 'g-mt-4'],
				['name' => '5', 'value' => 'g-mt-5'],
				['name' => '6', 'value' => 'g-mt-6'],
				['name' => '7', 'value' => 'g-mt-7'],
				['name' => '8', 'value' => 'g-mt-8'],
				['name' => '9', 'value' => 'g-mt-9'],
				['name' => '10', 'value' => 'g-mt-10'],
				['name' => '15', 'value' => 'g-mt-15'],
				['name' => '20', 'value' => 'g-mt-20'],
				['name' => '25', 'value' => 'g-mt-25'],
				['name' => '30', 'value' => 'g-mt-30'],
				['name' => '35', 'value' => 'g-mt-35'],
				['name' => '40', 'value' => 'g-mt-40'],
				['name' => '45', 'value' => 'g-mt-45'],
				['name' => '50', 'value' => 'g-mt-50'],
				['name' => '55', 'value' => 'g-mt-55'],
				['name' => '60', 'value' => 'g-mt-60'],
				['name' => '65', 'value' => 'g-mt-65'],
				['name' => '70', 'value' => 'g-mt-70'],
				['name' => '75', 'value' => 'g-mt-75'],
				['name' => '80', 'value' => 'g-mt-80'],
				['name' => '85', 'value' => 'g-mt-85'],
				['name' => '90', 'value' => 'g-mt-90'],
				['name' => '95', 'value' => 'g-mt-95'],
				['name' => '100', 'value' => 'g-mt-100'],
				['name' => '105', 'value' => 'g-mt-105'],
				['name' => '110', 'value' => 'g-mt-110'],
				['name' => '115', 'value' => 'g-mt-115'],
				['name' => '120', 'value' => 'g-mt-120'],
				['name' => '125', 'value' => 'g-mt-125'],
				['name' => '130', 'value' => 'g-mt-130'],
				['name' => '135', 'value' => 'g-mt-135'],
				['name' => '140', 'value' => 'g-mt-140'],
				['name' => '145', 'value' => 'g-mt-145'],
				['name' => '150', 'value' => 'g-mt-150'],
				['name' => '155', 'value' => 'g-mt-155'],
				['name' => '160', 'value' => 'g-mt-160'],
				['name' => '165', 'value' => 'g-mt-165'],
				['name' => '170', 'value' => 'g-mt-170'],
			],
		],
		'margin-bottom' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_MARGIN_BOTTOM'),
			'property' => 'margin-bottom',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-mb-auto'],
				['name' => '-20', 'value' => 'g-mb-minus-20'],
				['name' => '-15', 'value' => 'g-mb-minus-15'],
				['name' => '-10', 'value' => 'g-mb-minus-10'],
				['name' => '-5', 'value' => 'g-mb-minus-5'],
				['name' => '0', 'value' => 'g-mb-0'],
				['name' => '1', 'value' => 'g-mb-1'],
				['name' => '2', 'value' => 'g-mb-2'],
				['name' => '3', 'value' => 'g-mb-3'],
				['name' => '4', 'value' => 'g-mb-4'],
				['name' => '5', 'value' => 'g-mb-5'],
				['name' => '6', 'value' => 'g-mb-6'],
				['name' => '7', 'value' => 'g-mb-7'],
				['name' => '8', 'value' => 'g-mb-8'],
				['name' => '9', 'value' => 'g-mb-9'],
				['name' => '10', 'value' => 'g-mb-10'],
				['name' => '15', 'value' => 'g-mb-15'],
				['name' => '20', 'value' => 'g-mb-20'],
				['name' => '25', 'value' => 'g-mb-25'],
				['name' => '30', 'value' => 'g-mb-30'],
				['name' => '35', 'value' => 'g-mb-35'],
				['name' => '40', 'value' => 'g-mb-40'],
				['name' => '45', 'value' => 'g-mb-45'],
				['name' => '50', 'value' => 'g-mb-50'],
				['name' => '55', 'value' => 'g-mb-55'],
				['name' => '60', 'value' => 'g-mb-60'],
				['name' => '65', 'value' => 'g-mb-65'],
				['name' => '70', 'value' => 'g-mb-70'],
				['name' => '75', 'value' => 'g-mb-75'],
				['name' => '80', 'value' => 'g-mb-80'],
				['name' => '85', 'value' => 'g-mb-85'],
				['name' => '90', 'value' => 'g-mb-90'],
				['name' => '95', 'value' => 'g-mb-95'],
				['name' => '100', 'value' => 'g-mb-100'],
				['name' => '105', 'value' => 'g-mb-105'],
				['name' => '110', 'value' => 'g-mb-110'],
				['name' => '115', 'value' => 'g-mb-115'],
				['name' => '120', 'value' => 'g-mb-120'],
				['name' => '125', 'value' => 'g-mb-125'],
				['name' => '130', 'value' => 'g-mb-130'],
				['name' => '135', 'value' => 'g-mb-135'],
				['name' => '140', 'value' => 'g-mb-140'],
				['name' => '145', 'value' => 'g-mb-145'],
				['name' => '150', 'value' => 'g-mb-150'],
				['name' => '155', 'value' => 'g-mb-155'],
				['name' => '160', 'value' => 'g-mb-160'],
				['name' => '165', 'value' => 'g-mb-165'],
				['name' => '170', 'value' => 'g-mb-170'],
			],
		],
		'margin-left' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_MARGIN_LEFT'),
			'property' => 'margin-left',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-ml-auto'],
				['name' => '-10', 'value' => 'g-ml-minus-10'],
				['name' => '-5', 'value' => 'g-ml-minus-5'],
				['name' => '0', 'value' => 'g-ml-0'],
				['name' => '1', 'value' => 'g-ml-1'],
				['name' => '2', 'value' => 'g-ml-2'],
				['name' => '3', 'value' => 'g-ml-3'],
				['name' => '4', 'value' => 'g-ml-4'],
				['name' => '5', 'value' => 'g-ml-5'],
				['name' => '6', 'value' => 'g-ml-6'],
				['name' => '7', 'value' => 'g-ml-7'],
				['name' => '8', 'value' => 'g-ml-8'],
				['name' => '9', 'value' => 'g-ml-9'],
				['name' => '10', 'value' => 'g-ml-10'],
				['name' => '15', 'value' => 'g-ml-15'],
				['name' => '20', 'value' => 'g-ml-20'],
				['name' => '25', 'value' => 'g-ml-25'],
				['name' => '30', 'value' => 'g-ml-30'],
				['name' => '35', 'value' => 'g-ml-35'],
				['name' => '40', 'value' => 'g-ml-40'],
				['name' => '45', 'value' => 'g-ml-45'],
				['name' => '50', 'value' => 'g-ml-50'],
				['name' => '55', 'value' => 'g-ml-55'],
				['name' => '60', 'value' => 'g-ml-60'],
				['name' => '65', 'value' => 'g-ml-65'],
				['name' => '70', 'value' => 'g-ml-70'],
				['name' => '75', 'value' => 'g-ml-75'],
				['name' => '80', 'value' => 'g-ml-80'],
				['name' => '85', 'value' => 'g-ml-85'],
				['name' => '90', 'value' => 'g-ml-90'],
				['name' => '95', 'value' => 'g-ml-95'],
				['name' => '100', 'value' => 'g-ml-100'],
				['name' => '105', 'value' => 'g-ml-105'],
				['name' => '110', 'value' => 'g-ml-110'],
				['name' => '115', 'value' => 'g-ml-115'],
				['name' => '120', 'value' => 'g-ml-120'],
				['name' => '125', 'value' => 'g-ml-125'],
				['name' => '130', 'value' => 'g-ml-130'],
				['name' => '135', 'value' => 'g-ml-135'],
				['name' => '140', 'value' => 'g-ml-140'],
				['name' => '145', 'value' => 'g-ml-145'],
				['name' => '150', 'value' => 'g-ml-150'],
				['name' => '155', 'value' => 'g-ml-155'],
				['name' => '160', 'value' => 'g-ml-160'],
				['name' => '165', 'value' => 'g-ml-165'],
				['name' => '170', 'value' => 'g-ml-170'],
			],
		],
		'margin-right' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_MARGIN_RIGHT'),
			'property' => 'margin-right',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-mr-auto'],
				['name' => '-10', 'value' => 'g-mr-minus-10'],
				['name' => '-5', 'value' => 'g-mr-minus-5'],
				['name' => '0', 'value' => 'g-mr-0'],
				['name' => '1', 'value' => 'g-mr-1'],
				['name' => '2', 'value' => 'g-mr-2'],
				['name' => '3', 'value' => 'g-mr-3'],
				['name' => '4', 'value' => 'g-mr-4'],
				['name' => '5', 'value' => 'g-mr-5'],
				['name' => '6', 'value' => 'g-mr-6'],
				['name' => '7', 'value' => 'g-mr-7'],
				['name' => '8', 'value' => 'g-mr-8'],
				['name' => '9', 'value' => 'g-mr-9'],
				['name' => '10', 'value' => 'g-mr-10'],
				['name' => '15', 'value' => 'g-mr-15'],
				['name' => '20', 'value' => 'g-mr-20'],
				['name' => '25', 'value' => 'g-mr-25'],
				['name' => '30', 'value' => 'g-mr-30'],
				['name' => '35', 'value' => 'g-mr-35'],
				['name' => '40', 'value' => 'g-mr-40'],
				['name' => '45', 'value' => 'g-mr-45'],
				['name' => '50', 'value' => 'g-mr-50'],
				['name' => '55', 'value' => 'g-mr-55'],
				['name' => '60', 'value' => 'g-mr-60'],
				['name' => '65', 'value' => 'g-mr-65'],
				['name' => '70', 'value' => 'g-mr-70'],
				['name' => '75', 'value' => 'g-mr-75'],
				['name' => '80', 'value' => 'g-mr-80'],
				['name' => '85', 'value' => 'g-mr-85'],
				['name' => '90', 'value' => 'g-mr-90'],
				['name' => '95', 'value' => 'g-mr-95'],
				['name' => '100', 'value' => 'g-mr-100'],
				['name' => '105', 'value' => 'g-mr-105'],
				['name' => '110', 'value' => 'g-mr-110'],
				['name' => '115', 'value' => 'g-mr-115'],
				['name' => '120', 'value' => 'g-mr-120'],
				['name' => '125', 'value' => 'g-mr-125'],
				['name' => '130', 'value' => 'g-mr-130'],
				['name' => '135', 'value' => 'g-mr-135'],
				['name' => '140', 'value' => 'g-mr-140'],
				['name' => '145', 'value' => 'g-mr-145'],
				['name' => '150', 'value' => 'g-mr-150'],
				['name' => '155', 'value' => 'g-mr-155'],
				['name' => '160', 'value' => 'g-mr-160'],
				['name' => '165', 'value' => 'g-mr-165'],
				['name' => '170', 'value' => 'g-mr-170'],
			],
		],
		'height-vh' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_HEIGHT_VH'),
			'property' => 'height',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-height-auto'],
				['name' => '25%', 'value' => 'g-min-height-25vh'],
				['name' => '33%', 'value' => 'g-min-height-33vh'],
				['name' => '40%', 'value' => 'g-min-height-40vh'],
				['name' => '50%', 'value' => 'g-min-height-50vh'],
				['name' => '60%', 'value' => 'g-min-height-60vh'],
				['name' => '70%', 'value' => 'g-min-height-70vh'],
				['name' => '75%', 'value' => 'g-min-height-75vh'],
				['name' => '80%', 'value' => 'g-min-height-80vh'],
				['name' => '90%', 'value' => 'g-min-height-90vh'],
				['name' => '95%', 'value' => 'g-min-height-95vh'],
				['name' => '100%', 'value' => 'g-min-height-100vh'],
			],
		],
		'height--md' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_HEIGHT'),
			'property' => 'height',
			'type' => 'slider',
			'items' => [
				['name' => '40px', 'value' => 'g-height-40--md'],
				['name' => '50px', 'value' => 'g-height-50--md'],
				['name' => '60px', 'value' => 'g-height-60--md'],
				['name' => '70px', 'value' => 'g-height-70--md'],
				['name' => '80px', 'value' => 'g-height-80--md'],
				['name' => '90px', 'value' => 'g-height-90--md'],
				['name' => '100px', 'value' => 'g-height-100--md'],
			],
		],
		'height-increased--md' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_HEIGHT'),
			'property' => 'height',
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-height-auto--md'],
				['name' => '40px', 'value' => 'g-height-40--md'],
				['name' => '50px', 'value' => 'g-height-50--md'],
				['name' => '60px', 'value' => 'g-height-60--md'],
				['name' => '70px', 'value' => 'g-height-70--md'],
				['name' => '80px', 'value' => 'g-height-80--md'],
				['name' => '90px', 'value' => 'g-height-90--md'],
				['name' => '100px', 'value' => 'g-height-100--md'],
				['name' => '125px', 'value' => 'g-height-125--md'],
				['name' => '150px', 'value' => 'g-height-150--md'],
				['name' => '175px', 'value' => 'g-height-175--md'],
				['name' => '200px', 'value' => 'g-height-200--md'],
				['name' => '225px', 'value' => 'g-height-225--md'],
				['name' => '250px', 'value' => 'g-height-250--md'],
				['name' => '275px', 'value' => 'g-height-275--md'],
				['name' => '300px', 'value' => 'g-height-300--md'],
			],
		],
		'fill-first' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_COLOR'),
			'type' => 'color',
			'subtype' => 'fill-color',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'g-fill-transparent--first', 'value' => 'g-fill-transparent--first'],
				['name' => 'g-fill-primary--first', 'value' => 'g-fill-primary--first'],
				['name' => 'g-fill-primary-opacity-0_1--first', 'value' => 'g-fill-primary-opacity-0_1--first'],
				['name' => 'g-fill-primary-opacity-0_2--first', 'value' => 'g-fill-primary-opacity-0_2--first'],
				['name' => 'g-fill-primary-opacity-0_3--first', 'value' => 'g-fill-primary-opacity-0_3--first'],
				['name' => 'g-fill-primary-opacity-0_4--first', 'value' => 'g-fill-primary-opacity-0_4--first'],
				['name' => 'g-fill-primary-opacity-0_6--first', 'value' => 'g-fill-primary-opacity-0_6--first'],
				['name' => 'g-fill-primary-opacity-0_8--first', 'value' => 'g-fill-primary-opacity-0_8--first'],
				['name' => 'g-fill-primary-opacity-0_9--first', 'value' => 'g-fill-primary-opacity-0_9--first'],
				['name' => 'g-fill-primary-dark-v1--first', 'value' => 'g-fill-primary-dark-v1--first'],
				['name' => 'g-fill-primary-dark-v2--first', 'value' => 'g-fill-primary-dark-v2--first'],
				['name' => 'g-fill-primary-dark-v3--first', 'value' => 'g-fill-primary-dark-v3--first'],
				['name' => 'g-fill-main--first', 'value' => 'g-fill-main--first'],
				['name' => 'g-fill-secondary--first', 'value' => 'g-fill-secondary--first'],
				['name' => 'g-fill-black--first', 'value' => 'g-fill-black--first'],
				['name' => 'g-fill-black-opacity-0_1--first', 'value' => 'g-fill-black-opacity-0_1--first'],
				['name' => 'g-fill-black-opacity-0_2--first', 'value' => 'g-fill-black-opacity-0_2--first'],
				['name' => 'g-fill-black-opacity-0_3--first', 'value' => 'g-fill-black-opacity-0_3--first'],
				['name' => 'g-fill-black-opacity-0_4--first', 'value' => 'g-fill-black-opacity-0_4--first'],
				['name' => 'g-fill-black-opacity-0_5--first', 'value' => 'g-fill-black-opacity-0_5--first'],
				['name' => 'g-fill-black-opacity-0_6--first', 'value' => 'g-fill-black-opacity-0_6--first'],
				['name' => 'g-fill-black-opacity-0_7--first', 'value' => 'g-fill-black-opacity-0_7--first'],
				['name' => 'g-fill-black-opacity-0_8--first', 'value' => 'g-fill-black-opacity-0_8--first'],
				['name' => 'g-fill-black-opacity-0_9--first', 'value' => 'g-fill-black-opacity-0_9--first'],
				['name' => 'g-fill-white--first', 'value' => 'g-fill-white--first'],
				['name' => 'g-fill-white-opacity-0_1--first', 'value' => 'g-fill-white-opacity-0_1--first'],
				['name' => 'g-fill-white-opacity-0_2--first', 'value' => 'g-fill-white-opacity-0_2--first'],
				['name' => 'g-fill-white-opacity-0_3--first', 'value' => 'g-fill-white-opacity-0_3--first'],
				['name' => 'g-fill-white-opacity-0_4--first', 'value' => 'g-fill-white-opacity-0_4--first'],
				['name' => 'g-fill-white-opacity-0_5--first', 'value' => 'g-fill-white-opacity-0_5--first'],
				['name' => 'g-fill-white-opacity-0_6--first', 'value' => 'g-fill-white-opacity-0_6--first'],
				['name' => 'g-fill-white-opacity-0_7--first', 'value' => 'g-fill-white-opacity-0_7--first'],
				['name' => 'g-fill-white-opacity-0_8--first', 'value' => 'g-fill-white-opacity-0_8--first'],
				['name' => 'g-fill-white-opacity-0_9--first', 'value' => 'g-fill-white-opacity-0_9--first'],
				['name' => 'g-fill-gray-dark-v1--first', 'value' => 'g-fill-gray-dark-v1--first'],
				['name' => 'g-fill-gray-dark-v2--first', 'value' => 'g-fill-gray-dark-v2--first'],
				['name' => 'g-fill-gray-dark-v3--first', 'value' => 'g-fill-gray-dark-v3--first'],
				['name' => 'g-fill-gray-dark-v4--first', 'value' => 'g-fill-gray-dark-v4--first'],
				['name' => 'g-fill-gray-dark-v5--first', 'value' => 'g-fill-gray-dark-v5--first'],
				['name' => 'g-fill-gray-light-v1--first', 'value' => 'g-fill-gray-light-v1--first'],
				['name' => 'g-fill-gray-light-v2--first', 'value' => 'g-fill-gray-light-v2--first'],
				['name' => 'g-fill-gray-light-v3--first', 'value' => 'g-fill-gray-light-v3--first'],
				['name' => 'g-fill-gray-light-v4--first', 'value' => 'g-fill-gray-light-v4--first'],
				['name' => 'g-fill-gray-light-v5--first', 'value' => 'g-fill-gray-light-v5--first'],
				['name' => 'g-fill-beige--first', 'value' => 'g-fill-beige--first'],
				['name' => 'g-fill-green--first', 'value' => 'g-fill-green--first'],
				['name' => 'g-fill-green-opacity-0_1--first', 'value' => 'g-fill-green-opacity-0_1--first'],
				['name' => 'g-fill-green-opacity-0_3--first', 'value' => 'g-fill-green-opacity-0_3--first'],
				['name' => 'g-fill-green-opacity-0_5--first', 'value' => 'g-fill-green-opacity-0_5--first'],
				['name' => 'g-fill-green-opacity-0_7--first', 'value' => 'g-fill-green-opacity-0_7--first'],
				['name' => 'g-fill-blue--first', 'value' => 'g-fill-blue--first'],
				['name' => 'g-fill-blue-opacity-0_1--first', 'value' => 'g-fill-blue-opacity-0_1--first'],
				['name' => 'g-fill-blue-opacity-0_7--first', 'value' => 'g-fill-blue-opacity-0_7--first'],
				['name' => 'g-fill-blue-opacity-0_9--first', 'value' => 'g-fill-blue-opacity-0_9--first'],
				['name' => 'g-fill-lightblue--first', 'value' => 'g-fill-lightblue--first'],
				['name' => 'g-fill-lightblue-opacity-0_1--first', 'value' => 'g-fill-lightblue-opacity-0_1--first'],
				['name' => 'g-fill-lightblue-v1--first', 'value' => 'g-fill-lightblue-v1--first'],
				[
					'name' => 'g-fill-lightblue-v1-opacity-0_1--first',
					'value' => 'g-fill-lightblue-v1-opacity-0_1--first',
				],
				['name' => 'g-fill-darkblue--first', 'value' => 'g-fill-darkblue--first'],
				['name' => 'g-fill-darkblue-opacity-0_1--first', 'value' => 'g-fill-darkblue-opacity-0_1--first'],
				['name' => 'g-fill-indigo--first', 'value' => 'g-fill-indigo--first'],
				['name' => 'g-fill-indigo-opacity-0_1--first', 'value' => 'g-fill-indigo-opacity-0_1--first'],
				['name' => 'g-fill-red--first', 'value' => 'g-fill-red--first'],
				['name' => 'g-fill-red-opacity-0_1--first', 'value' => 'g-fill-red-opacity-0_1--first'],
				['name' => 'g-fill-red-opacity-0_2--first', 'value' => 'g-fill-red-opacity-0_2--first'],
				['name' => 'g-fill-red-opacity-0_5--first', 'value' => 'g-fill-red-opacity-0_5--first'],
				['name' => 'g-fill-red-opacity-0_8--first', 'value' => 'g-fill-red-opacity-0_8--first'],
				['name' => 'g-fill-lightred--first', 'value' => 'g-fill-lightred--first'],
				['name' => 'g-fill-lightred-opacity-0_1--first', 'value' => 'g-fill-lightred-opacity-0_1--first'],
				['name' => 'g-fill-darkred--first', 'value' => 'g-fill-darkred--first'],
				['name' => 'g-fill-darkred-opacity-0_1--first', 'value' => 'g-fill-darkred-opacity-0_1--first'],
				['name' => 'g-fill-purple--first', 'value' => 'g-fill-purple--first'],
				['name' => 'g-fill-purple-opacity-0_1--first', 'value' => 'g-fill-purple-opacity-0_1--first'],
				['name' => 'g-fill-purple-opacity-0_7--first', 'value' => 'g-fill-purple-opacity-0_7--first'],
				['name' => 'g-fill-purple-opacity-0_9--first', 'value' => 'g-fill-purple-opacity-0_9--first'],
				['name' => 'g-fill-darkpurple--first', 'value' => 'g-fill-darkpurple--first'],
				['name' => 'g-fill-darkpurple-opacity-0_1--first', 'value' => 'g-fill-darkpurple-opacity-0_1--first'],
				['name' => 'g-fill-pink--first', 'value' => 'g-fill-pink--first'],
				['name' => 'g-fill-pink-opacity-0_1--first', 'value' => 'g-fill-pink-opacity-0_1--first'],
				['name' => 'g-fill-pink-opacity-0_9--first', 'value' => 'g-fill-pink-opacity-0_9--first'],
				['name' => 'g-fill-orange--first', 'value' => 'g-fill-orange--first'],
				['name' => 'g-fill-orange-opacity-0_1--first', 'value' => 'g-fill-orange-opacity-0_1--first'],
				['name' => 'g-fill-orange-opacity-0_2--first', 'value' => 'g-fill-orange-opacity-0_2--first'],
				['name' => 'g-fill-deeporange--first', 'value' => 'g-fill-deeporange--first'],
				['name' => 'g-fill-deeporange--opacity-0_1-first', 'value' => 'g-fill-deeporange-opacity-0_1--first'],
				['name' => 'g-fill-yellow--first', 'value' => 'g-fill-yellow--first'],
				['name' => 'g-fill-yellow-opacity-0_1--first', 'value' => 'g-fill-yellow-opacity-0_1--first'],
				['name' => 'g-fill-yellow-opacity-0_7--first', 'value' => 'g-fill-yellow-opacity-0_7--first'],
				['name' => 'g-fill-aqua--first', 'value' => 'g-fill-aqua--first'],
				['name' => 'g-fill-aqua-opacity-0_1--first', 'value' => 'g-fill-aqua-opacity-0_1--first'],
				['name' => 'g-fill-aqua-opacity-0_9--first', 'value' => 'g-fill-aqua-opacity-0_9--first'],
				['name' => 'g-fill-cyan--first', 'value' => 'g-fill-cyan--first'],
				['name' => 'g-fill-cyan-opacity-0_1--first', 'value' => 'g-fill-cyan-opacity-0_1--first'],
				['name' => 'g-fill-cyan-opacity-0_9--first', 'value' => 'g-fill-cyan-opacity-0_9--first'],
				['name' => 'g-fill-teal--first', 'value' => 'g-fill-teal--first'],
				['name' => 'g-fill-teal-opacity-0_1--first', 'value' => 'g-fill-teal-opacity-0_1--first'],
				['name' => 'g-fill-teal-opacity-0_9--first', 'value' => 'g-fill-teal-opacity-0_9--first'],
				['name' => 'g-fill-brown--first', 'value' => 'g-fill-brown--first'],
				['name' => 'g-fill-brown-opacity-0_1--first', 'value' => 'g-fill-brown-opacity-0_1--first'],
				['name' => 'g-fill-bluegray--first', 'value' => 'g-fill-bluegray--first'],
				['name' => 'g-fill-bluegray-opacity-0_3--first', 'value' => 'g-fill-bluegray-opacity-0_3--first'],
				['name' => 'g-fill-bluegray-opacity-0_5--first', 'value' => 'g-fill-bluegray-opacity-0_5--first'],
				['name' => 'g-fill-bluegray-opacity-0_7--first', 'value' => 'g-fill-bluegray-opacity-0_7--first'],

				[
					'name' => 'g-theme-business-fill-blue-dark-v1--first',
					'value' => 'g-theme-business-fill-blue-dark-v1--first',
				],
				[
					'name' => 'g-theme-business-fill-blue-dark-v1-opacity-0_9--first',
					'value' => 'g-theme-business-fill-blue-dark-v1-opacity-0_9--first',
				],
				[
					'name' => 'g-theme-business-fill-blue-dark-v2--first',
					'value' => 'g-theme-business-fill-blue-dark-v2--first',
				],
				[
					'name' => 'g-theme-business-fill-blue-dark-v3--first',
					'value' => 'g-theme-business-fill-blue-dark-v3--first',
				],
				[
					'name' => 'g-theme-architecture-fill-blue-dark-v1--first',
					'value' => 'g-theme-architecture-fill-blue-dark-v1--first',
				],
				[
					'name' => 'g-theme-architecture-fill-blue-dark-v3--first',
					'value' => 'g-theme-architecture-fill-blue-dark-v3--first',
				],
				[
					'name' => 'g-theme-architecture-fill-blue-dark-v4--first',
					'value' => 'g-theme-architecture-fill-blue-dark-v4--first',
				],
				[
					'name' => 'g-theme-lawyer-fill-gray-dark-v1--first',
					'value' => 'g-theme-lawyer-fill-gray-dark-v1--first',
				],
				[
					'name' => 'g-theme-event-fill-blue-dark-v2--first',
					'value' => 'g-theme-event-fill-blue-dark-v2--first',
				],
				['name' => 'g-theme-travel-fill-black-v1--first', 'value' => 'g-theme-travel-fill-black-v1--first'],
				[
					'name' => 'g-theme-travel-fill-black-v1-opacity-0_8--first',
					'value' => 'g-theme-travel-fill-black-v1-opacity-0_8--first',
				],
				[
					'name' => 'g-theme-photography-fill-gray-dark-v2--first',
					'value' => 'g-theme-photography-fill-gray-dark-v2--first',
				],
				[
					'name' => 'g-theme-photography-fill-gray-dark-v3--first',
					'value' => 'g-theme-photography-fill-gray-dark-v3--first',
				],
				[
					'name' => 'g-theme-photography-fill-gray-dark-v4--first',
					'value' => 'g-theme-photography-fill-gray-dark-v4--first',
				],
				['name' => 'g-theme-bitrix-fill-dark-v1--first', 'value' => 'g-theme-bitrix-fill-dark-v1--first'],

				['name' => 'g-fill-facebook--first', 'value' => 'g-fill-facebook--first'],
				['name' => 'g-fill-twitter--first', 'value' => 'g-fill-twitter--first'],
				['name' => 'g-fill-skype--first', 'value' => 'g-fill-skype--first'],
				['name' => 'g-fill-pinterest--first', 'value' => 'g-fill-pinterest--first'],
				['name' => 'g-fill-vine--first', 'value' => 'g-fill-vine--first'],
				['name' => 'g-fill-youtube--first', 'value' => 'g-fill-youtube--first'],
				['name' => 'g-fill-google-plus--first', 'value' => 'g-fill-google-plus--first'],
				['name' => 'g-fill-dribbble--first', 'value' => 'g-fill-dribbble--first'],
				['name' => 'g-fill-vk--first', 'value' => 'g-fill--vk'],
				['name' => 'g-fill-linkedin--first', 'value' => 'g-fill-linkedin--first'],

				['name' => 'g-theme-bitrix-fill-dark-v2--first', 'value' => 'g-theme-bitrix-fill-dark-v2--first'],
				['name' => 'g-theme-bitrix-fill-v3--first', 'value' => 'g-theme-bitrix-fill-v3--first'],
			],
		],
		'fill-second' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BACKGROUND_COLOR'),
			'type' => 'color',
			'subtype' => 'fill-color-second',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'g-fill-transparent--second', 'value' => 'g-fill-transparent--second'],
				['name' => 'g-fill-primary--second', 'value' => 'g-fill-primary--second'],
				['name' => 'g-fill-primary-opacity-0_1--second', 'value' => 'g-fill-primary-opacity-0_1--second'],
				['name' => 'g-fill-primary-opacity-0_2--second', 'value' => 'g-fill-primary-opacity-0_2--second'],
				['name' => 'g-fill-primary-opacity-0_3--second', 'value' => 'g-fill-primary-opacity-0_3--second'],
				['name' => 'g-fill-primary-opacity-0_4--second', 'value' => 'g-fill-primary-opacity-0_4--second'],
				['name' => 'g-fill-primary-opacity-0_6--second', 'value' => 'g-fill-primary-opacity-0_6--second'],
				['name' => 'g-fill-primary-opacity-0_8--second', 'value' => 'g-fill-primary-opacity-0_8--second'],
				['name' => 'g-fill-primary-opacity-0_9--second', 'value' => 'g-fill-primary-opacity-0_9--second'],
				['name' => 'g-fill-primary-dark-v1--second', 'value' => 'g-fill-primary-dark-v1--second'],
				['name' => 'g-fill-primary-dark-v2--second', 'value' => 'g-fill-primary-dark-v2--second'],
				['name' => 'g-fill-primary-dark-v3--second', 'value' => 'g-fill-primary-dark-v3--second'],
				['name' => 'g-fill-main--second', 'value' => 'g-fill-main--second'],
				['name' => 'g-fill-secondary--second', 'value' => 'g-fill-secondary--second'],
				['name' => 'g-fill-black--second', 'value' => 'g-fill-black--second'],
				['name' => 'g-fill-black-opacity-0_1--second', 'value' => 'g-fill-black-opacity-0_1--second'],
				['name' => 'g-fill-black-opacity-0_2--second', 'value' => 'g-fill-black-opacity-0_2--second'],
				['name' => 'g-fill-black-opacity-0_3--second', 'value' => 'g-fill-black-opacity-0_3--second'],
				['name' => 'g-fill-black-opacity-0_4--second', 'value' => 'g-fill-black-opacity-0_4--second'],
				['name' => 'g-fill-black-opacity-0_5--second', 'value' => 'g-fill-black-opacity-0_5--second'],
				['name' => 'g-fill-black-opacity-0_6--second', 'value' => 'g-fill-black-opacity-0_6--second'],
				['name' => 'g-fill-black-opacity-0_7--second', 'value' => 'g-fill-black-opacity-0_7--second'],
				['name' => 'g-fill-black-opacity-0_8--second', 'value' => 'g-fill-black-opacity-0_8--second'],
				['name' => 'g-fill-black-opacity-0_9--second', 'value' => 'g-fill-black-opacity-0_9--second'],
				['name' => 'g-fill-white--second', 'value' => 'g-fill-white--second'],
				['name' => 'g-fill-white-opacity-0_1--second', 'value' => 'g-fill-white-opacity-0_1--second'],
				['name' => 'g-fill-white-opacity-0_2--second', 'value' => 'g-fill-white-opacity-0_2--second'],
				['name' => 'g-fill-white-opacity-0_3--second', 'value' => 'g-fill-white-opacity-0_3--second'],
				['name' => 'g-fill-white-opacity-0_4--second', 'value' => 'g-fill-white-opacity-0_4--second'],
				['name' => 'g-fill-white-opacity-0_5--second', 'value' => 'g-fill-white-opacity-0_5--second'],
				['name' => 'g-fill-white-opacity-0_6--second', 'value' => 'g-fill-white-opacity-0_6--second'],
				['name' => 'g-fill-white-opacity-0_7--second', 'value' => 'g-fill-white-opacity-0_7--second'],
				['name' => 'g-fill-white-opacity-0_8--second', 'value' => 'g-fill-white-opacity-0_8--second'],
				['name' => 'g-fill-white-opacity-0_9--second', 'value' => 'g-fill-white-opacity-0_9--second'],
				['name' => 'g-fill-gray-dark-v1--second', 'value' => 'g-fill-gray-dark-v1--second'],
				['name' => 'g-fill-gray-dark-v2--second', 'value' => 'g-fill-gray-dark-v2--second'],
				['name' => 'g-fill-gray-dark-v3--second', 'value' => 'g-fill-gray-dark-v3--second'],
				['name' => 'g-fill-gray-dark-v4--second', 'value' => 'g-fill-gray-dark-v4--second'],
				['name' => 'g-fill-gray-dark-v5--second', 'value' => 'g-fill-gray-dark-v5--second'],
				['name' => 'g-fill-gray-light-v1--second', 'value' => 'g-fill-gray-light-v1--second'],
				['name' => 'g-fill-gray-light-v2--second', 'value' => 'g-fill-gray-light-v2--second'],
				['name' => 'g-fill-gray-light-v3--second', 'value' => 'g-fill-gray-light-v3--second'],
				['name' => 'g-fill-gray-light-v4--second', 'value' => 'g-fill-gray-light-v4--second'],
				['name' => 'g-fill-gray-light-v5--second', 'value' => 'g-fill-gray-light-v5--second'],
				['name' => 'g-fill-beige--second', 'value' => 'g-fill-beige--second'],
				['name' => 'g-fill-green--second', 'value' => 'g-fill-green--second'],
				['name' => 'g-fill-green-opacity-0_1--second', 'value' => 'g-fill-green-opacity-0_1--second'],
				['name' => 'g-fill-green-opacity-0_3--second', 'value' => 'g-fill-green-opacity-0_3--second'],
				['name' => 'g-fill-green-opacity-0_5--second', 'value' => 'g-fill-green-opacity-0_5--second'],
				['name' => 'g-fill-green-opacity-0_7--second', 'value' => 'g-fill-green-opacity-0_7--second'],
				['name' => 'g-fill-blue--second', 'value' => 'g-fill-blue--second'],
				['name' => 'g-fill-blue-opacity-0_1--second', 'value' => 'g-fill-blue-opacity-0_1--second'],
				['name' => 'g-fill-blue-opacity-0_7--second', 'value' => 'g-fill-blue-opacity-0_7--second'],
				['name' => 'g-fill-blue-opacity-0_9--second', 'value' => 'g-fill-blue-opacity-0_9--second'],
				['name' => 'g-fill-lightblue--second', 'value' => 'g-fill-lightblue--second'],
				['name' => 'g-fill-lightblue-opacity-0_1--second', 'value' => 'g-fill-lightblue-opacity-0_1--second'],
				['name' => 'g-fill-lightblue-v1--second', 'value' => 'g-fill-lightblue-v1--second'],
				[
					'name' => 'g-fill-lightblue-v1-opacity-0_1--second',
					'value' => 'g-fill-lightblue-v1-opacity-0_1--second',
				],
				['name' => 'g-fill-darkblue--second', 'value' => 'g-fill-darkblue--second'],
				['name' => 'g-fill-darkblue-opacity-0_1--second', 'value' => 'g-fill-darkblue-opacity-0_1--second'],
				['name' => 'g-fill-indigo--second', 'value' => 'g-fill-indigo--second'],
				['name' => 'g-fill-indigo-opacity-0_1--second', 'value' => 'g-fill-indigo-opacity-0_1--second'],
				['name' => 'g-fill-red--second', 'value' => 'g-fill-red--second'],
				['name' => 'g-fill-red-opacity-0_1--second', 'value' => 'g-fill-red-opacity-0_1--second'],
				['name' => 'g-fill-red-opacity-0_2--second', 'value' => 'g-fill-red-opacity-0_2--second'],
				['name' => 'g-fill-red-opacity-0_5--second', 'value' => 'g-fill-red-opacity-0_5--second'],
				['name' => 'g-fill-red-opacity-0_8--second', 'value' => 'g-fill-red-opacity-0_8--second'],
				['name' => 'g-fill-lightred--second', 'value' => 'g-fill-lightred--second'],
				['name' => 'g-fill-lightred-opacity-0_1--second', 'value' => 'g-fill-lightred-opacity-0_1--second'],
				['name' => 'g-fill-darkred--second', 'value' => 'g-fill-darkred--second'],
				['name' => 'g-fill-darkred-opacity-0_1--second', 'value' => 'g-fill-darkred-opacity-0_1--second'],
				['name' => 'g-fill-purple--second', 'value' => 'g-fill-purple--second'],
				['name' => 'g-fill-purple-opacity-0_1--second', 'value' => 'g-fill-purple-opacity-0_1--second'],
				['name' => 'g-fill-purple-opacity-0_7--second', 'value' => 'g-fill-purple-opacity-0_7--second'],
				['name' => 'g-fill-purple-opacity-0_9--second', 'value' => 'g-fill-purple-opacity-0_9--second'],
				['name' => 'g-fill-darkpurple--second', 'value' => 'g-fill-darkpurple--second'],
				['name' => 'g-fill-darkpurple-opacity-0_1--second', 'value' => 'g-fill-darkpurple-opacity-0_1--second'],
				['name' => 'g-fill-pink--second', 'value' => 'g-fill-pink--second'],
				['name' => 'g-fill-pink-opacity-0_1--second', 'value' => 'g-fill-pink-opacity-0_1--second'],
				['name' => 'g-fill-pink-opacity-0_9--second', 'value' => 'g-fill-pink-opacity-0_9--second'],
				['name' => 'g-fill-orange--second', 'value' => 'g-fill-orange--second'],
				['name' => 'g-fill-orange-opacity-0_1--second', 'value' => 'g-fill-orange-opacity-0_1--second'],
				['name' => 'g-fill-orange-opacity-0_2--second', 'value' => 'g-fill-orange-opacity-0_2--second'],
				['name' => 'g-fill-deeporange--second', 'value' => 'g-fill-deeporange--second'],
				['name' => 'g-fill-deeporange-opacity-0_1--second', 'value' => 'g-fill-deeporange-opacity-0_1--second'],
				['name' => 'g-fill-yellow--second', 'value' => 'g-fill-yellow--second'],
				['name' => 'g-fill-yellow-opacity-0_1--second', 'value' => 'g-fill-yellow-opacity-0_1--second'],
				['name' => 'g-fill-yellow-opacity-0_7--second', 'value' => 'g-fill-yellow-opacity-0_7--second'],
				['name' => 'g-fill-aqua--second', 'value' => 'g-fill-aqua--second'],
				['name' => 'g-fill-aqua-opacity-0_1--second', 'value' => 'g-fill-aqua-opacity-0_1--second'],
				['name' => 'g-fill-aqua-opacity-0_9--second', 'value' => 'g-fill-aqua-opacity-0_9--second'],
				['name' => 'g-fill-cyan--second', 'value' => 'g-fill-cyan--second'],
				['name' => 'g-fill-cyan-opacity-0_1--second', 'value' => 'g-fill-cyan-opacity-0_1--second'],
				['name' => 'g-fill-cyan-opacity-0_9--second', 'value' => 'g-fill-cyan-opacity-0_9--second'],
				['name' => 'g-fill-teal--second', 'value' => 'g-fill-teal--second'],
				['name' => 'g-fill-teal-opacity-0_1--second', 'value' => 'g-fill-teal-opacity-0_1--second'],
				['name' => 'g-fill-teal-opacity-0_9--second', 'value' => 'g-fill-teal-opacity-0_9--second'],
				['name' => 'g-fill-brown--second', 'value' => 'g-fill-brown--second'],
				['name' => 'g-fill-brown-opacity-0_1--second', 'value' => 'g-fill-brown-opacity-0_1--second'],
				['name' => 'g-fill-bluegray--second', 'value' => 'g-fill-bluegray--second'],
				['name' => 'g-fill-bluegray-opacity-0_3--second', 'value' => 'g-fill-bluegray-opacity-0_3--second'],
				['name' => 'g-fill-bluegray-opacity-0_5--second', 'value' => 'g-fill-bluegray-opacity-0_5--second'],
				['name' => 'g-fill-bluegray-opacity-0_7--second', 'value' => 'g-fill-bluegray-opacity-0_7--second'],

				[
					'name' => 'g-theme-business-fill-blue-dark-v1--second',
					'value' => 'g-theme-business-fill-blue-dark-v1--second',
				],
				[
					'name' => 'g-theme-business-fill-blue-dark-v1-opacity-0_9--second',
					'value' => 'g-theme-business-fill-blue-dark-v1-opacity-0_9--second',
				],
				[
					'name' => 'g-theme-business-fill-blue-dark-v2--second',
					'value' => 'g-theme-business-fill-blue-dark-v2--second',
				],
				[
					'name' => 'g-theme-business-fill-blue-dark-v3--second',
					'value' => 'g-theme-business-fill-blue-dark-v3--second',
				],
				[
					'name' => 'g-theme-architecture-fill-blue-dark-v1--second',
					'value' => 'g-theme-architecture-fill-blue-dark-v1--second',
				],
				[
					'name' => 'g-theme-architecture-fill-blue-dark-v3--second',
					'value' => 'g-theme-architecture-fill-blue-dark-v3--second',
				],
				[
					'name' => 'g-theme-architecture-fill-blue-dark-v4--second',
					'value' => 'g-theme-architecture-fill-blue-dark-v4--second',
				],
				[
					'name' => 'g-theme-lawyer-fill-gray-dark-v1--second',
					'value' => 'g-theme-lawyer-fill-gray-dark-v1--second',
				],
				[
					'name' => 'g-theme-event-fill-blue-dark-v2--second',
					'value' => 'g-theme-event-fill-blue-dark-v2--second',
				],
				['name' => 'g-theme-travel-fill-black-v1--second', 'value' => 'g-theme-travel-fill-black-v1--second'],
				[
					'name' => 'g-theme-travel-fill-black-v1-opacity-0_8--second',
					'value' => 'g-theme-travel-fill-black-v1-opacity-0_8--second',
				],
				[
					'name' => 'g-theme-photography-fill-gray-dark-v2--second',
					'value' => 'g-theme-photography-fill-gray-dark-v2--second',
				],
				[
					'name' => 'g-theme-photography-fill-gray-dark-v3--second',
					'value' => 'g-theme-photography-fill-gray-dark-v3--second',
				],
				[
					'name' => 'g-theme-photography-fill-gray-dark-v4--second',
					'value' => 'g-theme-photography-fill-gray-dark-v4--second',
				],
				['name' => 'g-theme-bitrix-fill-dark-v1--second', 'value' => 'g-theme-bitrix-fill-dark-v1--second'],

				['name' => 'g-fill-facebook--second', 'value' => 'g-fill-facebook--second'],
				['name' => 'g-fill-twitter--second', 'value' => 'g-fill-twitter--second'],
				['name' => 'g-fill-skype--second', 'value' => 'g-fill-skype--second'],
				['name' => 'g-fill-pinterest--second', 'value' => 'g-fill-pinterest--second'],
				['name' => 'g-fill-vine--second', 'value' => 'g-fill-vine--second'],
				['name' => 'g-fill-youtube--second', 'value' => 'g-fill-youtube--second'],
				['name' => 'g-fill-google-plus--second', 'value' => 'g-fill-google-plus--second'],
				['name' => 'g-fill-dribbble--second', 'value' => 'g-fill-dribbble--second'],
				['name' => 'g-fill-vk--second', 'value' => 'g-fill-vk--second'],
				['name' => 'g-fill-linkedin--second', 'value' => 'g-fill-linkedin--second'],

				['name' => 'g-theme-bitrix-fill-dark-v2--second', 'value' => 'g-theme-bitrix-fill-dark-v2--second'],
				['name' => 'g-theme-bitrix-fill-v3--second', 'value' => 'g-theme-bitrix-fill-v3--second'],
			],
		],
		'columns' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_COLUMNS_ON_ROW'),
			'property' => 'columns',
			'type' => 'slider',
			'items' => [
				['name' => '1', 'value' => 'col-lg-12'],
				['name' => '2', 'value' => 'col-lg-6'],
				['name' => '3', 'value' => 'col-lg-4'],
				['name' => '4', 'value' => 'col-lg-3'],
				['name' => '6', 'value' => 'col-lg-2'],
				['name' => '12', 'value' => 'col-lg-1'],
			],
		],
		'display' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_DEVICE_DISPLAY'),
			'property' => 'display',
			'type' => 'display',
			'items' => [
				['name' => '<span class="landing-ui-button-desktop"></span>', 'value' => 'l-d-lg-none'],
				['name' => '<span class="landing-ui-button-tablet"></span>', 'value' => 'l-d-md-none'],
				['name' => '<span class="landing-ui-button-mobile"></span>', 'value' => 'l-d-xs-none'],
			],
		],
		'button-color' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_BUTTON_COLOR'),
			'type' => 'color',
			'subtype' => 'button-color',
			// old items for delete old classes when change and for reset
			'items' => [
				['name' => 'g-btn-primary', 'value' => 'g-btn-primary'],
				['name' => 'g-btn-white', 'value' => 'g-btn-white'],
				['name' => 'g-btn-black', 'value' => 'g-btn-black'],
				['name' => 'g-btn-darkgray', 'value' => 'g-btn-darkgray'],
				['name' => 'g-btn-gray', 'value' => 'g-btn-gray'],
				['name' => 'g-btn-lightgray', 'value' => 'g-btn-lightgray'],
				['name' => 'g-btn-red', 'value' => 'g-btn-red'],
				['name' => 'g-btn-lightred', 'value' => 'g-btn-lightred'],
				['name' => 'g-btn-darkred', 'value' => 'g-btn-darkred'],
				['name' => 'g-btn-blue', 'value' => 'g-btn-blue'],
				['name' => 'g-btn-indigo', 'value' => 'g-btn-indigo'],
				['name' => 'g-btn-purple', 'value' => 'g-btn-purple'],
				['name' => 'g-btn-darkpurple', 'value' => 'g-btn-darkpurple'],
				['name' => 'g-btn-pink', 'value' => 'g-btn-pink'],
				['name' => 'g-btn-orange', 'value' => 'g-btn-orange'],
				['name' => 'g-btn-deeporange', 'value' => 'g-btn-deeporange'],
				['name' => 'g-btn-yellow', 'value' => 'g-btn-yellow'],
				['name' => 'g-btn-aqua', 'value' => 'g-btn-aqua'],
				['name' => 'g-btn-cyan', 'value' => 'g-btn-cyan'],
				['name' => 'g-btn-teal', 'value' => 'g-btn-teal'],
				['name' => 'g-btn-brown', 'value' => 'g-btn-brown'],
				['name' => 'g-btn-bluegray', 'value' => 'g-btn-bluegray'],
				['name' => 'g-btn-facebook', 'value' => 'g-btn-facebook'],
				['name' => 'g-btn-twitter', 'value' => 'g-btn-twitter'],
				['name' => 'g-theme-bitrix-btn-v4', 'value' => 'g-theme-bitrix-btn-v4'],
				['name' => 'g-theme-bitrix-btn-v6', 'value' => 'g-theme-bitrix-btn-v6'],
			],
		],
		'animation' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ANIMATION'),
			'property' => 'animation-name',
			'type' => 'list',
			'items' => [
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_ANIMATION_NONE'), 'value' => 'animation-none'],
				['name' => 'bounce', 'value' => 'bounce'],
				['name' => 'flash', 'value' => 'flash'],
				['name' => 'pulse', 'value' => 'pulse'],
				['name' => 'rubberBand', 'value' => 'rubberBand'],
				['name' => 'shake', 'value' => 'shake'],
				['name' => 'headShake', 'value' => 'headShake'],
				['name' => 'swing', 'value' => 'swing'],
				['name' => 'tada', 'value' => 'tada'],
				['name' => 'wobble', 'value' => 'wobble'],
				['name' => 'jello', 'value' => 'jello'],
				['name' => 'bounceIn', 'value' => 'bounceIn'],
				['name' => 'bounceInDown', 'value' => 'bounceInDown'],
				['name' => 'bounceInLeft', 'value' => 'bounceInLeft'],
				['name' => 'bounceInRight', 'value' => 'bounceInRight'],
				['name' => 'bounceInUp', 'value' => 'bounceInUp'],
				['name' => 'fadeIn', 'value' => 'fadeIn'],
				['name' => 'fadeInDown', 'value' => 'fadeInDown'],
				['name' => 'fadeInDownBig', 'value' => 'fadeInDownBig'],
				['name' => 'fadeInLeft', 'value' => 'fadeInLeft'],
				['name' => 'fadeInLeftBig', 'value' => 'fadeInLeftBig'],
				['name' => 'fadeInRight', 'value' => 'fadeInRight'],
				['name' => 'fadeInRightBig', 'value' => 'fadeInRightBig'],
				['name' => 'fadeInUp', 'value' => 'fadeInUp'],
				['name' => 'fadeInUpBig', 'value' => 'fadeInUpBig'],
				['name' => 'flip', 'value' => 'flip'],
				['name' => 'flipInX', 'value' => 'flipInX'],
				['name' => 'flipInY', 'value' => 'flipInY'],
				['name' => 'lightSpeedIn', 'value' => 'lightSpeedIn'],
				['name' => 'rotateIn', 'value' => 'rotateIn'],
				['name' => 'rotateInDownLeft', 'value' => 'rotateInDownLeft'],
				['name' => 'rotateInDownRight', 'value' => 'rotateInDownRight'],
				['name' => 'rotateInUpLeft', 'value' => 'rotateInUpLeft'],
				['name' => 'rotateInUpRight', 'value' => 'rotateInUpRight'],
				['name' => 'rollIn', 'value' => 'rollIn'],
				['name' => 'zoomIn', 'value' => 'zoomIn'],
				['name' => 'zoomToIn', 'value' => 'zoomToIn'],
				['name' => 'zoomInDown', 'value' => 'zoomInDown'],
				['name' => 'zoomInLeft', 'value' => 'zoomInLeft'],
				['name' => 'zoomInRight', 'value' => 'zoomInRight'],
				['name' => 'zoomInUp', 'value' => 'zoomInUp'],
				['name' => 'slideInDown', 'value' => 'slideInDown'],
				['name' => 'slideInLeft', 'value' => 'slideInLeft'],
				['name' => 'slideInRight', 'value' => 'slideInRight'],
				['name' => 'slideInUp', 'value' => 'slideInUp'],
			],
		],
		'block-border-type' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER'),
			'type' => 'list',
			'items' => [
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER_N'),
					'value' => 'u-block-border-none',
					'hide' => ['block-border-margin', 'border-radius', 'block-border-position'],
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER_Y'),
					'value' => 'u-block-border',
					'show' => ['block-border-margin', 'border-radius', 'block-border-position'],
				],
			],
		],
		'block-border-margin' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER_MARGIN'),
			'type' => 'list',
			'items' => [
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER_MARGIN_N'),
					'value' => 'u-block-border-margin-none',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER_MARGIN_SM'),
					'value' => 'u-block-border-margin-sm',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER_MARGIN_MD'),
					'value' => 'u-block-border-margin-md',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER_MARGIN_LG'),
					'value' => 'u-block-border-margin-lg',
				],
			],
		],
		'block-border-position' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER_POSITION'),
			'type' => 'list',
			'items' => [
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER_POSITION_ALL'),
					'value' => 'u-block-border-all',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER_POSITION_START'),
					'value' => 'u-block-border-first',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER_POSITION_MIDDLE'),
					'value' => 'u-block-border-middle',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE-BLOCK_BORDER_POSITION_END'),
					'value' => 'u-block-border-end',
				],
			],
		],
		'container-max-width' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE-CONTENT_CONTAINER'),
			'type' => 'list',
			'items' => [
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE-TEXT_CONTAINER_CONTAINER'),
					'value' => 'g-max-width-container',
				],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE-TEXT_CONTAINER_FULL'), 'value' => 'g-max-width-100x'],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE-TEXT_CONTAINER_MINI'), 'value' => 'g-max-width-800'],
			],
		],
		'button-type' => [
			'name' => Loc::getMessage('LANDING_BLOCK_BUTTON_STYLE'),
			'type' => 'list',
			'items' => [
				['name' => Loc::getMessage('LANDING_BLOCK_BUTTON_STYLE_SOLID'), 'value' => 'g-btn-type-solid'],
				['name' => Loc::getMessage('LANDING_BLOCK_BUTTON_STYLE_OUTLINE'), 'value' => 'g-btn-type-outline'],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_BUTTON_STYLE_SOLID_DOUBLE'),
					'value' => 'g-btn-type-solid-double',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_BUTTON_STYLE_OUTLINE_DOUBLE'),
					'value' => 'g-btn-type-outline-double',
				],
			],
		],
		'button-size' => [
			'name' => Loc::getMessage('LANDING_BLOCK_BUTTON_SIZE'),
			'type' => 'slider',
			'items' => [
				['name' => Loc::getMessage('LANDING_STYLE_AUTO'), 'value' => 'g-btn-size-auto'],
				['name' => 'XS', 'value' => 'g-btn-size-sm'],
				['name' => 'S', 'value' => 'g-btn-size-md'],
				['name' => 'M', 'value' => 'g-btn-size-special'],
				['name' => 'L', 'value' => 'g-btn-size-xl'],
				['name' => 'XL', 'value' => 'g-btn-size-xxl'],
			],
		],
		'heading-v2' => [
			'name' => Loc::getMessage('LANDING_BLOCK_TITLE_STYLE'),
			'type' => 'slider',
			'items' => [
				['name' => '0', 'value' => 'u-heading-v2-0'],
				['name' => '1', 'value' => 'u-heading-v2-2--bottom'],
				['name' => '2', 'value' => 'u-heading-v2-3--bottom'],
				['name' => '3', 'value' => 'u-heading-v2-4--bottom'],
				['name' => '4', 'value' => 'u-heading-v2-6--bottom'],
				['name' => '5', 'value' => 'u-heading-v2-8--bottom'],
				['name' => '6', 'value' => 'u-heading-v2-8-2--bottom'],
				['name' => '7', 'value' => 'u-heading-v2-8-3--bottom'],
				['name' => '8', 'value' => 'u-heading-v2-3--top'],
				['name' => '9', 'value' => 'u-heading-v2-4--top'],
				['name' => '10', 'value' => 'u-heading-v2-6--top'],
				['name' => '11', 'value' => 'u-heading-v2-8--top'],
				['name' => '12', 'value' => 'u-heading-v2-8-2--top'],
				['name' => '13', 'value' => 'u-heading-v2-8-3--top'],
				['name' => '14', 'value' => 'u-heading-v2-9--1'],
				['name' => '15', 'value' => 'u-heading-v2-9--2'],
				['name' => '16', 'value' => 'u-heading-v2-10'],
				['name' => '17', 'value' => 'u-heading-v2-10--5'],
				['name' => '18', 'value' => 'u-heading-v2-12--1'],
				['name' => '19', 'value' => 'u-heading-v2-12--2'],
				['name' => '20', 'value' => 'u-heading-v2-13-2--left'],
				['name' => '21', 'value' => 'u-heading-v2-13-2--right'],
			],
		],
		'orientation-free' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO'),
			'type' => 'list',
			'items' => [
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_H') . ', 16:9',
					'value' => 'embed-responsive-16by9',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_V') . ', 9:16',
					'value' => 'embed-responsive-9by16',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_H') . ', 4:3',
					'value' => 'embed-responsive-4by3',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_V') . ', 3:4',
					'value' => 'embed-responsive-3by4',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_H') . ', 21:9',
					'value' => 'embed-responsive-21by9',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_V') . ', 9:21',
					'value' => 'embed-responsive-9by21',
				],
				['name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_S'), 'value' => 'embed-responsive-1by1'],
			],
		],
		'orientation' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO') . ' ',
			'type' => 'list',
			'items' => [
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_H') . ', 4:3',
					'value' => 'embed-responsive-4by3',
					'hide' => ['video-scale'],
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_V') . ', 3:4',
					'value' => 'embed-responsive-3by4',
					'show' => ['video-scale'],
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_H') . ', 16:9',
					'value' => 'embed-responsive-16by9',
					'hide' => ['video-scale'],
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_V') . ', 9:16',
					'value' => 'embed-responsive-9by16',
					'show' => ['video-scale'],
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_H') . ', 21:9',
					'value' => 'embed-responsive-21by9',
					'hide' => ['video-scale'],
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_V') . ', 9:21',
					'value' => 'embed-responsive-9by21',
					'show' => ['video-scale'],
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_ORIENT_VIDEO_S'),
					'value' => 'embed-responsive-1by1',
					'hide' => ['video-scale'],
				],
			],
		],
		'video-scale' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_SCALE_VIDEO'),
			'type' => 'slider',
			'items' => [
				['name' => '75%', 'value' => 'scale-75'],
				['name' => '100%', 'value' => 'scale-100'],
				['name' => '125%', 'value' => 'scale-125'],
				['name' => '150%', 'value' => 'scale-150'],
				['name' => '200%', 'value' => 'scale-200'],
			],
		],
		//todo: change phrases
		'widget-type' => [
			'name' => Loc::getMessage('LANDING_BLOCK_STYLE_WIDGET_TYPE'),
			'type' => 'list',
			'items' => [
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_WIDGET_TYPE_BASIC'),
					'value' => 'widget-type-basic'
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_WIDGET_TYPE_ROUNDED'),
					'value' => 'widget-type-rounded',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_WIDGET_TYPE_ROUNDED_TOP'),
					'value' => 'widget-type-rounded-top',
				],
				[
					'name' => Loc::getMessage('LANDING_BLOCK_STYLE_WIDGET_TYPE_ROUNDED_BOTTOM'),
					'value' => 'widget-type-rounded-bottom',
				],
			],
		],
	],
	'group' => [
		'block-default' => [
			'display',
			'background',
			'padding-top',
			'padding-bottom',
			'padding-left',
			'padding-right',
			'margin-top',
		],
		'block-default-background-overlay' => [
			'display',
			'background-attachment',
			'background-size',
			'padding-top',
			'padding-bottom',
			'padding-left',
			'padding-right',
			'margin-top',
			'background-overlay',
		],
		'block-default-background-overlay-height-vh' => [
			'display',
			'background-attachment',
			'background-size',
			'height-vh',
			'padding-top',
			'padding-bottom',
			'padding-left',
			'padding-right',
			'margin-top',
			'background-overlay',
		],
		'block-default-background' => [
			'display',
			'background',
			'padding-top',
			'padding-bottom',
			'padding-left',
			'padding-right',
			'margin-top',
		],
		'block-default-background-height-vh' => [
			'display',
			'background',
			'height-vh',
			'padding-top',
			'padding-bottom',
			'padding-left',
			'padding-right',
			'margin-top',
		],
		'block-default-wo-background' => [
			'display',
			'padding-top',
			'padding-bottom',
			'padding-left',
			'padding-right',
			'margin-top',
		],
		'block-default-wo-paddings' => ['display', 'background-color'],
		'block-default-wo-background-vh-animation' => [
			'display',
			'padding-top',
			'padding-bottom',
			'padding-left',
			'padding-right',
			'margin-top',
			'height-vh',
			'animation',
		],
		'block-border' => [
			'background',
			'block-border-type',
			'block-border-margin',
			'border-radius',
			'block-border-position',
		],
		'paddings' => ['padding-top', 'padding-bottom', 'padding-left', 'padding-right'],
		'margins' => ['margin-top', 'margin-bottom', 'margin-left', 'margin-right'],
		'typo' => [
			'text-align',
			'color',
			'font-size',
			'font-family',
			'font-weight',
			'text-decoration',
			'text-transform',
			'line-height',
			'letter-spacing',
			'word-break',
			'text-shadow',
			'padding-top',
			'padding-left',
			'padding-right',
			'margin-bottom',
		],
		'typo-simple' => [
			'font-size',
			'font-family',
			'font-weight',
			'text-decoration',
			'text-transform',
			'line-height',
			'letter-spacing',
		],
		'typo-link' => [
			'color',
			'color-hover',
			'font-size',
			'font-family',
			'font-weight',
			'text-decoration',
			'text-transform',
			'letter-spacing',
			'text-shadow',
		],
		'box' => [
			'background-color',
			'box-shadow',
			'opacity',
		],
		'button' => [
			'button-color',
			'button-type',
			'button-size',
			'button-padding',
			'border-radius',
			'color',
			'color-hover',
			'font-family',
			'text-transform',
		],
		'navbar' => ['navbar-align', 'navbar-color', 'navbar-color-hover'],
		'navbar-bg-color' => ['navbar-align', 'navbar-color', 'navbar-bg', 'navbar-color-hover', 'navbar-bg-hover'],
		'navbar-full' => [
			'navbar-align',
			'navbar-color',
			'navbar-color-hover',
			'navbar-color-fix-moment',
			'navbar-color-fix-moment-hover',
		],
		'container' => ['container-max-width', 'padding-left', 'padding-right'],
		'heading' => ['text-align', 'heading-v2', 'border-color', 'border-color-hover', 'margin-bottom'],
		'border-colors' => ['border-color', 'border-color-hover'],
		// backward compatibility for new color control
		'bg' => ['background-color'],
		'background-gradient' => ['background-color'],
		'background-hover' => ['background-color-hover'],
		// dont forget add new usage 'background' style in \Bitrix\Landing\Node\StyleImg::STYLES_WITH_IMAGE

		'widget' => ['background', 'widget-type', 'margin-bottom'],
	],
];