(function(t){"use strict";var e=Object.freeze({self:"self",opponent:"opponent",system:"system"});var s=Object.freeze({messages:BX.Messenger.Model.Messages.getName(),dialogues:BX.Messenger.Model.Dialogues.getName(),users:BX.Messenger.Model.Users.getName(),files:BX.Messenger.Model.Files.getName()});BX.Vue.component("bx-messenger-message",{props:{userId:{default:0},dialogId:{default:0},chatId:{default:0},enableEmotions:{default:true},enableDateActions:{default:true},enableCreateContent:{default:true},showAvatar:{default:true},showMenu:{default:true},showName:{default:true},referenceContentClassName:{default:""},referenceContentBodyClassName:{default:""},message:{type:Object,default:BX.Messenger.Model.Messages.getMessageBlank}},data:function t(){return{componentBodyId:"bx-messenger-message-body"}},methods:{clickByUserName:function t(e){this.$emit("clickByUserName",e)},clickByMessageMenu:function t(e,s){this.$emit("clickByMessageMenu",{message:e,event:s})},clickByMessageRetry:function t(e,s){this.$emit("clickByMessageRetry",{message:e,event:s})}},computed:{MessageType:function t(){return e},type:function t(){if(this.message.system||this.message.authorId==0){return e.system}else if(this.message.authorId===-1||this.message.authorId==this.userId){return e.self}else{return e.opponent}},localize:function t(){var t=BX.Vue.getFilteredPhrases("IM_MESSENGER_MESSAGE_",this.$root.$bitrixMessages);return Object.freeze(Object.assign({},t,{IM_MESSENGER_MESSAGE_MENU_TITLE:t.IM_MESSENGER_MESSAGE_MENU_TITLE.replace("#SHORTCUT#",BX.Messenger.Utils.platform.isMac()?"CMD":"CTRL")}))},userData:function t(){var e;if(typeof this.$store.state[s.users].collection[this.message.authorId]!=="undefined"){e=this.$store.state[s.users].collection[this.message.authorId]}else{e=BX.Messenger.Model.Users.getUserBlank({defaultName:this.localize.IM_MESSENGER_MESSAGE_USER_ANONYM})}return e},filesData:function t(){var e;if(typeof this.$store.state[s.files].index[this.chatId]!=="undefined"){e=this.$store.state[s.files].index[this.chatId]}else{e={}}return e},isEdited:function t(){return this.message.params.IS_EDITED=="Y"},isDeleted:function t(){return this.message.params.IS_DELETED=="Y"}},template:'\n\t\t<div :class="[\'bx-im-message\', {\n\t\t\t\'bx-im-message-without-menu\': !showMenu,\n\t\t\t\'bx-im-message-without-avatar\': !showAvatar,\n\t\t\t\'bx-im-message-type-system\': type == MessageType.system,\n\t\t\t\'bx-im-message-type-self\': type == MessageType.self,\n\t\t\t\'bx-im-message-type-opponent\': type == MessageType.opponent,\n\t\t\t\'bx-im-message-status-error\': message.error,\n\t\t\t\'bx-im-message-status-unread\': message.unread,\n\t\t\t\'bx-im-message-status-blink\': message.blink,\n\t\t\t\'bx-im-message-status-edited\': isEdited,\n\t\t\t\'bx-im-message-status-deleted\': isDeleted,\n\t\t}]">\n\t\t\t<template v-if="type == MessageType.opponent">\n\t\t\t\t<div v-if="showAvatar" class="bx-im-message-avatar" @click="clickByUserName(userData, $event)">\n\t\t\t\t\t<div :class="[\'bx-im-message-avatar-image\', {\n\t\t\t\t\t\t\t\'bx-im-message-avatar-image-default\': !userData.avatar\n\t\t\t\t\t\t}]"\n\t\t\t\t\t\t:style="{\n\t\t\t\t\t\t\tbackgroundColor: !userData.avatar? userData.color: \'\', \n\t\t\t\t\t\t\tbackgroundImage: userData.avatar? \'url(\'+userData.avatar+\')\': \'\'\n\t\t\t\t\t\t}" \n\t\t\t\t\t\t:title="userData.name"\n\t\t\t\t\t></div>\t\n\t\t\t\t</div>\n\t\t\t</template>\n\t\t\t<div class="bx-im-message-box">\n\t\t\t\t<component :is="componentBodyId"\n\t\t\t\t\t:userId="userId" \n\t\t\t\t\t:dialogId="dialogId"\n\t\t\t\t\t:chatId="chatId"\n\t\t\t\t\t:messageType="type"\n\t\t\t\t\t:message="message"\n\t\t\t\t\t:user="userData"\n\t\t\t\t\t:files="filesData"\n\t\t\t\t\t:showAvatar="showAvatar"\n\t\t\t\t\t:showName="showName"\n\t\t\t\t\t:enableEmotions="enableEmotions"\n\t\t\t\t\t:referenceContentBodyClassName="referenceContentBodyClassName"\n\t\t\t\t\t@clickByUserName="clickByUserName"\n\t\t\t\t/>\n\t\t\t</div>\t\n\t\t\t<template v-if="type == MessageType.self">\n\t\t\t\t<div class="bx-im-message-box-status">\n\t\t\t\t\t<transition name="bx-im-message-sending">\n\t\t\t\t\t\t<template v-if="message.sending">\n\t\t\t\t\t\t\t<div class="bx-im-message-sending"></div>\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</transition>\n\t\t\t\t\t<transition name="bx-im-message-status-retry">\n\t\t\t\t\t\t<template v-if="!message.sending && message.error">\n\t\t\t\t\t\t\t<div class="bx-im-message-status-retry" :title="localize.IM_MESSENGER_MESSAGE_RETRY_TITLE" @click="clickByMessageRetry(message, $event)">\n\t\t\t\t\t\t\t\t<span class="bx-im-message-retry-icon"></span>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</template>\n\t\t\t\t\t</transition>\n\t\t\t\t\t<template v-if="showMenu && !message.sending && !message.error">\n\t\t\t\t\t\t<div class="bx-im-message-status-menu" :title="localize.IM_MESSENGER_MESSAGE_MENU_TITLE" @click="clickByMessageMenu(message, $event)">\n\t\t\t\t\t\t\t<span class="bx-im-message-menu-icon"></span>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</template> \n\t\t\t\t</div>\n\t\t\t</template> \n\t\t\t<template v-else-if="showMenu">\n\t\t\t\t<div class="bx-im-message-menu" :title="localize.IM_MESSENGER_MESSAGE_MENU_TITLE" @click="clickByMessageMenu(message, $event)">\n\t\t\t\t\t<span class="bx-im-message-menu-icon"></span>\n\t\t\t\t</div>\n\t\t\t</template> \n\t\t</div>\n\t'})})(this.window=this.window||{});
//# sourceMappingURL=messenger.component.message.bundle.map.js