(function(t,e,n,i,l,a,m){"use strict";
/**
	 * Bitrix Messenger
	 * Vue component
	 *
	 * Delimiter (attach type)
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2019 Bitrix
	 */var o={property:"DELIMITER",name:"bx-im-view-element-attach-delimiter",component:{props:{config:{type:Object,default:{}},color:{type:String,default:"transparent"}},computed:{styles:function t(){return{width:this.config.DELIMITER.SIZE?this.config.DELIMITER.SIZE+"px":"",backgroundColor:this.config.DELIMITER.COLOR?this.config.DELIMITER.COLOR:this.color}}},template:'<div class="bx-im-element-attach-type-delimiter" :style="styles"></div>'}};
/**
	 * Bitrix Messenger
	 * Vue component
	 *
	 * File (attach type)
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2019 Bitrix
	 */var r={property:"FILE",name:"bx-im-element-attach-file",component:{props:{config:{type:Object,default:{}},color:{type:String,default:"transparent"}},methods:{openLink:function t(e){a.Utils.platform.openNewPage(e.LINK)},file:function t(){return{name:this.config.FILE.NAME,extension:this.config.FILE.NAME.split(".").splice(-1)[0],size:this.config.FILE.SIZE}},fileName:function t(e){var n=70;if(!e.NAME||e.NAME.length<n){return e.NAME}var i=10;var l=e.NAME.split(".").splice(-1)[0];var a=e.NAME.substring(e.NAME.length-1-(l.length+1+i));var m=e.NAME.substring(0,n-a.length-3);return m.trim()+"..."+a.trim()},fileNameFull:function t(e){return e.NAME},fileSize:function t(e){var n=e.SIZE;if(!n||n<=0){n=0}var i=["BYTE","KB","MB","GB","TB"];var l=0;while(n>=1024&&l<4){n/=1024;l++}return Math.round(n)+" "+this.$Bitrix.Loc.getMessage("IM_MESSENGER_ATTACH_FILE_SIZE_"+i[l])},fileIcon:function t(e){return l.FilesModel.getIconType(e.NAME.split(".").splice(-1)[0])}},template:'\n\t\t\t<div class="bx-im-element-attach-type-file-element">\n\t\t\t\t<template v-for="(element, index) in config.FILE">\n\t\t\t\t\t<div class="bx-im-element-attach-type-file" @click="openLink(element)">\n\t\t\t\t\t\t<div class="bx-im-element-attach-type-file-icon">\n\t\t\t\t\t\t\t<div :class="[\'ui-icon\', \'ui-icon-file-\'+fileIcon(element)]"><i></i></div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class="bx-im-element-attach-type-file-block">\n\t\t\t\t\t\t\t<div class="bx-im-element-attach-type-file-name" :title="fileNameFull(element)">\n\t\t\t\t\t\t\t\t{{fileName(element)}}\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class="bx-im-element-attach-type-file-size">{{fileSize(element)}}</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</template>\n\t\t\t</div>\n\t\t'}};var c={methods:{openLink:function t(e){var n=e.element;var i=e.event;if(!a.Utils.platform.isBitrixMobile()&&n.LINK){return}if(n.LINK&&i.target.tagName!=="A"){a.Utils.platform.openNewPage(n.LINK)}else if(!n.LINK){var l={id:null,type:null};if(n.hasOwnProperty("USER_ID")&&n.USER_ID>0){l.id=n.USER_ID;l.type="user"}if(n.hasOwnProperty("CHAT_ID")&&n.CHAT_ID>0){l.id=n.CHAT_ID;l.type="chat"}if(l.id&&l.type&&window.top["BXIM"]){var m=!BX.MessengerTheme.isDark();window.top["BXIM"].messenger.openPopupExternalData(i.target,l.type,m,{ID:l.id})}else if(navigator.userAgent.toLowerCase().includes("bitrixmobile")){var o="";if(l.type==="chat"){o="chat".concat(l.id)}else{o=l.id}if(o!==""){BXMobileApp.Events.postToComponent("onOpenDialog",[{dialogId:o},true],"im.recent")}}}}}};
/**
	 * Bitrix Messenger
	 * Vue component
	 *
	 * Grid (attach type)
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2019 Bitrix
	 */var s={property:"GRID",name:"bx-im-view-element-attach-grid",component:{mixins:[c],props:{config:{type:Object,default:{}},color:{type:String,default:"transparent"}},created:function t(){if(a.Utils.platform.isBitrixMobile()){this.maxCellWith=Math.floor(Math.min(screen.availWidth,screen.availHeight)/4)}else{this.maxCellWith=null}},methods:{getWidth:function t(e){if(e.DISPLAY!=="row"){return e.WIDTH?e.WIDTH+"px":""}if(!e.VALUE){return false}if(this.maxCellWith&&e.WIDTH>this.maxCellWith){return this.maxCellWith+"px"}return e.WIDTH?e.WIDTH+"px":""},getValueColor:function t(e){if(!e.COLOR){return false}return e.COLOR},getValue:function t(e){if(!e.VALUE){return""}return a.Utils.text.decode(e.VALUE)}},template:'\n\t\t\t<div class="bx-im-element-attach-type-grid">\n\t\t\t\t<template v-for="(element, index) in config.GRID">\n\t\t\t\t\t<template v-if="element.DISPLAY.toLowerCase() === \'block\'">\n\t\t\t\t\t\t<div class="bx-im-element-attach-type-grid-display bx-im-element-attach-type-display-block" :style="{width: getWidth(element)}">\n\t\t\t\t\t\t\t<div class="bx-im-element-attach-type-grid-element-name">{{element.NAME}}</div>\n\t\t\t\t\t\t\t<template v-if="element.LINK">\n\t\t\t\t\t\t\t\t<div class="bx-im-element-attach-type-grid-element-value bx-im-element-attach-type-grid-element-value-link">\n\t\t\t\t\t\t\t\t\t<a :href="element.LINK" target="_blank" @click="openLink({element: element, event: $event})" :style="{color: getValueColor(element)}" v-html="getValue(element)"></a>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t<template v-else>\n\t\t\t\t\t\t\t\t<div class="bx-im-element-attach-type-grid-element-value" :style="{color: getValueColor(element)}" v-html="getValue(element)"></div>\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</template>\n\t\t\t\t\t<template v-else-if="element.DISPLAY.toLowerCase() === \'line\'">\n\t\t\t\t\t\t<div class="bx-im-element-attach-type-grid-display bx-im-element-attach-type-display-card" :style="{width: getWidth(element)}">\n\t\t\t\t\t\t\t<div class="bx-im-element-attach-type-grid-element-name">{{element.NAME}}</div>\n\t\t\t\t\t\t\t<template v-if="element.LINK">\n\t\t\t\t\t\t\t\t<div\n\t\t\t\t\t\t\t\t\tclass="bx-im-element-attach-type-grid-element-value bx-im-element-attach-type-grid-element-value-link"\n\t\t\t\t\t\t\t\t\t:style="{color: element.COLOR? element.COLOR: \'\'}"\n\t\t\t\t\t\t\t\t>\n\t\t\t\t\t\t\t\t\t<a :href="element.LINK" target="_blank" @click="openLink({element: element, event: $event})" v-html="getValue(element)"></a>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t<template v-else>\n\t\t\t\t\t\t\t\t<div class="bx-im-element-attach-type-grid-element-value" :style="{color: element.COLOR? element.COLOR: \'\'}" v-html="getValue(element)"></div>\n\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</template>\n\t\t\t\t\t<template v-else-if="element.DISPLAY.toLowerCase() === \'row\'">\n\t\t\t\t\t\t<div class="bx-im-element-attach-type-grid-display bx-im-element-attach-type-display-column">\n\t\t\t\t\t\t\t<table class="bx-im-element-attach-type-display-column-table">\n\t\t\t\t\t\t\t\t<tbody>\n\t\t\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t\t\t<template v-if="element.NAME">\n\t\t\t\t\t\t\t\t\t\t\t<td class="bx-im-element-attach-type-grid-element-name" :colspan="element.VALUE? 1: 2" :style="{width: getWidth(element)}">{{element.NAME}}</td>\n\t\t\t\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t\t\t\t<template v-if="element.VALUE">\n\t\t\t\t\t\t\t\t\t\t\t<template v-if="element.LINK">\n\t\t\t\t\t\t\t\t\t\t\t\t<td\n\t\t\t\t\t\t\t\t\t\t\t\t\tclass="bx-im-element-attach-type-grid-element-value bx-im-element-attach-type-grid-element-value-link"\n\t\t\t\t\t\t\t\t\t\t\t\t\t:colspan="element.NAME? 1: 2"\n\t\t\t\t\t\t\t\t\t\t\t\t\t:style="{color: element.COLOR? element.COLOR: \'\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<a :href="element.LINK" target="_blank" @click="openLink({element: element, event: $event})" v-html="getValue(element)"></a>\n\t\t\t\t\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t\t\t\t\t<template v-else>\n\t\t\t\t\t\t\t\t\t\t\t\t<td class="bx-im-element-attach-type-grid-element-value" :colspan="element.NAME? 1: 2" :style="{color: element.COLOR? element.COLOR: \'\'}" v-html="getValue(element)"></td>\n\t\t\t\t\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t\t\t\t</template>\n\t\t\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t\t\t</tbody>\n\t\t\t\t\t\t\t</table>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</template>\n\t\t\t\t</template>\n\t\t\t</div>\n\t\t'}};
/**
	 * Bitrix Messenger
	 * Vue component
	 *
	 * Rich Attach type
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2019 Bitrix
	 */var p={property:"HTML",name:"bx-im-view-element-attach-html",component:{props:{config:{type:Object,default:{}},color:{type:String,default:"transparent"}},computed:{html:function t(){var e=this.config.HTML.replace(/&nbsp;/gi," ");return a.Utils.text.decode(e)}},template:'<div class="bx-im-element-attach-type-html" v-html="html"></div>'}};
/**
	 * Bitrix Messenger
	 * Vue component
	 *
	 * Image (attach type)
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2019 Bitrix
	 */var d={property:"IMAGE",name:"bx-im-view-element-attach-image",component:{props:{config:{type:Object,default:{}},color:{type:String,default:"transparent"}},methods:{open:function t(e){if(!e){return false}if(a.Utils.platform.isBitrixMobile()){BXMobileApp.UI.Photo.show({photos:[{url:e}],default_photo:e})}else{window.open(e,"_blank")}},getImageSize:function t(e,n,i){var l;if(e>i){l=i/e}else{l=1}return{width:e*l,height:n*l}},getElementSource:function t(e){return e.PREVIEW?e.PREVIEW:e.LINK},lazyLoadCallback:function t(e){if(!e.element.style.width){e.element.style.width=e.element.offsetWidth+"px"}if(!e.element.style.height){e.element.style.height=e.element.offsetHeight+"px"}},styleFileSizes:function t(e){if(!(e.WIDTH&&e.HEIGHT)){return{maxHeight:"100%",backgroundSize:"contain"}}var n=this.getImageSize(e.WIDTH,e.HEIGHT,250);return{width:n.width+"px",height:n.height+"px",backgroundSize:n.width<100||n.height<100?"contain":"initial"}},styleBoxSizes:function t(e){if(!(e.WIDTH&&e.HEIGHT)){return{height:"150px"}}if(parseInt(this.styleFileSizes(e).height)<=250){return{}}return{height:"280px"}}},template:'\n\t\t\t<div class="bx-im-element-attach-type-image">\n\t\t\t\t<template v-for="(image, index) in config.IMAGE">\n\t\t\t\t\t<div class="bx-im-element-attach-type-image-block" @click="open(image.LINK)" :style="styleBoxSizes(image)" :key="index">\n\t\t\t\t\t\t<img v-bx-lazyload="{callback: lazyLoadCallback}"\n\t\t\t\t\t\t\tclass="bx-im-element-attach-type-image-source"\n\t\t\t\t\t\t\t:data-lazyload-src="getElementSource(image)"\n\t\t\t\t\t\t\t:style="styleFileSizes(image)"\n\t\t\t\t\t\t\t:title="image.NAME"\n\t\t\t\t\t\t/>\n\t\t\t\t\t</div>\n\t\t\t\t</template>\n\t\t\t</div>\n\t\t'}};
/**
	 * Bitrix Messenger
	 * Vue component
	 *
	 * Link (attach type)
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2019 Bitrix
	 */var v={property:"LINK",name:"bx-im-view-element-attach-link",component:{mixins:[c],props:{config:{type:Object,default:{}},color:{type:String,default:"transparent"}},methods:{getImageConfig:function t(e){return{IMAGE:[{NAME:e.NAME,PREVIEW:e.PREVIEW,WIDTH:e.WIDTH,HEIGHT:e.HEIGHT}]}},getLinkName:function t(e){return e.NAME?e.NAME:e.LINK},getDescription:function t(e){var n=e.HTML?e.HTML:e.DESC;return a.Utils.text.decode(n)}},computed:{imageComponentName:function t(){return d.name}},components:babelHelpers.defineProperty({},d.name,d.component),template:'\n\t\t\t<div class="bx-im-element-attach-type-link">\n\t\t\t\t<template v-for="(element, index) in config.LINK">\n\t\t\t\t\t<div class="bx-im-element-attach-type-link-element" :key="index">\n\t\t\t\t\t\t<a \n\t\t\t\t\t\t\tv-if="element.LINK"\n\t\t\t\t\t\t\t:href="element.LINK"\n\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\tclass="bx-im-element-attach-type-link-name" \n\t\t\t\t\t\t\t@click="openLink({element: element, event: $event})"\n\t\t\t\t\t\t>\n\t\t\t\t\t\t\t{{getLinkName(element)}}\n\t\t\t\t\t\t</a>\n\t\t\t\t\t\t<span \n\t\t\t\t\t\t\tv-else\n\t\t\t\t\t\t\tclass="bx-im-element-attach-type-ajax-link"\n\t\t\t\t\t\t\t@click="openLink({element: element, event: $event})"\n\t\t\t\t\t\t>\n\t\t\t\t\t\t\t{{getLinkName(element)}}\n\t\t\t\t\t\t</span>\n\t\t\t\t\t\t<div v-if="element.DESC || element.HTML" class="bx-im-element-attach-type-link-desc" v-html="getDescription(element)"></div>\n\t\t\t\t\t\t<div \n\t\t\t\t\t\t\tv-if="element.PREVIEW" \n\t\t\t\t\t\t\tclass="bx-im-element-attach-type-link-image"\n\t\t\t\t\t\t\t@click="openLink({element: element, event: $event})"\n\t\t\t\t\t\t>\n\t\t\t\t\t\t\t<component :is="imageComponentName" :config="getImageConfig(element)" :color="color"/>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</template>\n\t\t\t</div>\n\t\t'}};
/**
	 * Bitrix Messenger
	 * Vue component
	 *
	 * Message (attach type)
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2019 Bitrix
	 */var f={property:"MESSAGE",name:"bx-im-view-element-attach-message",component:{props:{config:{type:Object,default:{}},color:{type:String,default:"transparent"}},computed:{message:function t(){return a.Utils.text.decode(this.config.MESSAGE)}},template:'<div class="bx-im-element-attach-type-message" v-html="message"></div>'}};
/**
	 * Bitrix Messenger
	 * Vue component
	 *
	 * Rich (attach type)
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2019 Bitrix
	 */var h={property:"RICH_LINK",name:"bx-im-view-element-attach-rich",component:{mixins:[c],props:{config:{type:Object,default:{}},color:{type:String,default:"transparent"}},methods:{getImageConfig:function t(e){return{IMAGE:[{NAME:e.NAME,PREVIEW:e.PREVIEW,WIDTH:e.WIDTH,HEIGHT:e.HEIGHT}]}}},computed:{imageComponentName:function t(){return d.name}},components:babelHelpers.defineProperty({},d.name,d.component),template:'\n\t\t\t<div class="bx-im-element-attach-type-rich">\n\t\t\t\t<template v-for="(element, index) in config.RICH_LINK">\n\t\t\t\t\t<div class="bx-im-element-attach-type-rich-element" :key="index">\n\t\t\t\t\t\t<div v-if="element.PREVIEW" class="bx-im-element-attach-type-rich-image" @click="openLink({element: element, event: $event})">\n\t\t\t\t\t\t\t<component :is="imageComponentName" :config="getImageConfig(element)" :color="color"/>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class="bx-im-element-attach-type-rich-name" @click="openLink({element: element, event: $event})">{{element.NAME}}</div>\n\t\t\t\t\t\t<div v-if="element.HTML || element.DESC" class="bx-im-element-attach-type-rich-desc">{{element.HTML || element.DESC}}</div>\n\t\t\t\t\t</div>\n\t\t\t\t</template>\n\t\t\t</div>\n\t\t'}};
/**
	 * Bitrix Messenger
	 * Vue component
	 *
	 * User (Attach type)
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2019 Bitrix
	 */var g={property:"USER",name:"bx-im-view-element-attach-user",component:{mixins:[c],props:{config:{type:Object,default:{}},color:{type:String,default:"transparent"}},methods:{getAvatarType:function t(e){if(e.AVATAR){return""}var n="user";if(e.AVATAR_TYPE==="CHAT"){n="chat"}else if(e.AVATAR_TYPE==="BOT"){n="bot"}return"bx-im-element-attach-type-user-avatar-type-"+n}},template:'\n\t\t\t<div class="bx-im-element-attach-type-user">\n\t\t\t\t<template v-for="(element, index) in config.USER">\n\t\t\t\t\t<div class="bx-im-element-attach-type-user-body">\n\t\t\t\t\t\t<div class="bx-im-element-attach-type-user-avatar">\n\t\t\t\t\t\t\t<div :class="[\'bx-im-element-attach-type-user-avatar-type\', getAvatarType(element)]" :style="{backgroundColor: element.AVATAR? \'\': color}">\n\t\t\t\t\t\t\t\t<img v-if="element.AVATAR" \n\t\t\t\t\t\t\t\t\tv-bx-lazyload\n\t\t\t\t\t\t\t\t\tclass="bx-im-element-attach-type-user-avatar-source"\n\t\t\t\t\t\t\t\t\t:data-lazyload-src="element.AVATAR"\n\t\t\t\t\t\t\t\t/>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<a\n\t\t\t\t\t\t\tv-if="element.LINK"\n\t\t\t\t\t\t\t:href="element.LINK" \n\t\t\t\t\t\t\tclass="bx-im-element-attach-type-user-name"\n\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t@click="openLink({element: element, event: $event})"\n\t\t\t\t\t\t>\n\t\t\t\t\t\t\t{{element.NAME}}\n\t\t\t\t\t\t</a>\n\t\t\t\t\t\t<span v-else @click.prevent="openLink({element: element, event: $event})">\n\t\t\t\t\t\t\t{{element.NAME}}\n\t\t\t\t\t\t</span>\n\t\t\t\t\t</div>\n\t\t\t\t</template>\n\t\t\t</div>\n\t\t'}};
/**
	 * Bitrix Messenger
	 * Attach element Vue component
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2019 Bitrix
	 */var u=[o,r,s,p,d,v,f,h,g];var y={};u.forEach((function(t){y[t.name]=t.component}));m.BitrixVue.component("bx-im-view-element-attach",{props:{config:{type:Object,default:{}},baseColor:{type:String,default:"#17a3ea"}},methods:{getComponentForBlock:function t(e){for(var n=0,i=u;n<i.length;n++){var l=i[n];if(typeof e[l.property]!=="undefined"){return l.name}}return""}},computed:{color:function t(){if(typeof this.config.COLOR==="undefined"||!this.config.COLOR){return this.baseColor}if(this.config.COLOR==="transparent"){return""}return this.config.COLOR}},components:y,template:'\n\t\t<div class="bx-im-element-attach">\n\t\t\t<div v-if="color" class="bx-im-element-attach-border" :style="{borderColor: color}"></div>\n\t\t\t<div class="bx-im-element-attach-content">\n\t\t\t\t<template v-for="(block, index) in config.BLOCKS">\n\t\t\t\t\t<component :is="getComponentForBlock(block)" :config="block" :color="color" :key="index" />\n\t\t\t\t</template>\n\t\t\t</div>\n\t\t</div>\n\t'})})(this.window=this.window||{},BX,BX,window,BX.Messenger.Model,BX.Messenger.Lib,BX);
//# sourceMappingURL=attach.bundle.map.js