this.BX=this.BX||{};this.BX.Messenger=this.BX.Messenger||{};(function(e,t,i,n,a,r,o,s){"use strict";
/**
	 * Bitrix Messenger
	 * Application model (Vuex Builder model)
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2020 Bitrix
	 */var l=function(e){babelHelpers.inherits(t,e);function t(){babelHelpers.classCallCheck(this,t);return babelHelpers.possibleConstructorReturn(this,babelHelpers.getPrototypeOf(t).apply(this,arguments))}babelHelpers.createClass(t,[{key:"getName",value:function e(){return"application"}},{key:"getState",value:function e(){return{common:{host:this.getVariable("common.host",location.protocol+"//"+location.host),siteId:this.getVariable("common.siteId","default"),userId:this.getVariable("common.userId",0),languageId:this.getVariable("common.languageId","en")},dialog:{dialogId:this.getVariable("dialog.dialogId","0"),chatId:this.getVariable("dialog.chatId",0),diskFolderId:this.getVariable("dialog.diskFolderId",0),messageLimit:this.getVariable("dialog.messageLimit",20),enableReadMessages:this.getVariable("dialog.enableReadMessages",true),messageExtraCount:0},disk:{enabled:false,maxFileSize:5242880},call:{serverEnabled:false,maxParticipants:24},mobile:{keyboardShow:false},device:{type:this.getVariable("device.type",s.DeviceType.desktop),orientation:this.getVariable("device.orientation",s.DeviceOrientation.portrait)},options:{quoteEnable:this.getVariable("options.quoteEnable",true),quoteFromRight:this.getVariable("options.quoteFromRight",true),autoplayVideo:this.getVariable("options.autoplayVideo",true),darkBackground:this.getVariable("options.darkBackground",false),showSmiles:false},error:{active:false,code:"",description:""}}}},{key:"getStateSaveException",value:function e(){return Object.assign({common:this.getVariable("saveException.common",null),dialog:this.getVariable("saveException.dialog",null),mobile:this.getVariable("saveException.mobile",null),device:this.getVariable("saveException.device",null),error:this.getVariable("saveException.error",null)})}},{key:"getActions",value:function e(){var t=this;return{set:function e(i,n){i.commit("set",t.validate(n))},showSmiles:function e(t,i){t.commit("showSmiles")},hideSmiles:function e(t,i){t.commit("hideSmiles")}}}},{key:"getMutations",value:function e(){var t=this;return{set:function e(i,n){var a=false;for(var r in n){if(!n.hasOwnProperty(r)){continue}for(var o in n[r]){if(!n[r].hasOwnProperty(o)){continue}i[r][o]=n[r][o];a=true}}if(a&&t.isSaveNeeded(n)){t.saveState(i)}},increaseDialogExtraCount:function e(t){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var n=i.count,a=n===void 0?1:n;t.dialog.messageExtraCount+=a},decreaseDialogExtraCount:function e(t){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var n=i.count,a=n===void 0?1:n;var r=t.dialog.messageExtraCount-a;if(r<=0){r=0}t.dialog.messageExtraCount=r},clearDialogExtraCount:function e(t){t.dialog.messageExtraCount=0},showSmiles:function e(t){t.options.showSmiles=true},hideSmiles:function e(t){t.options.showSmiles=false}}}},{key:"validate",value:function e(t){var i={};if(babelHelpers["typeof"](t.common)==="object"&&t.common){i.common={};if(typeof t.common.userId==="number"){i.common.userId=t.common.userId}if(typeof t.common.languageId==="string"){i.common.languageId=t.common.languageId}}if(babelHelpers["typeof"](t.dialog)==="object"&&t.dialog){i.dialog={};if(typeof t.dialog.dialogId==="number"){i.dialog.dialogId=t.dialog.dialogId.toString();i.dialog.chatId=0}else if(typeof t.dialog.dialogId==="string"){i.dialog.dialogId=t.dialog.dialogId;if(typeof t.dialog.chatId!=="number"){var n=t.dialog.dialogId;if(n.startsWith("chat")){n=t.dialog.dialogId.substr(4)}n=parseInt(n);i.dialog.chatId=!isNaN(n)?n:0;t.dialog.chatId=i.dialog.chatId}}if(typeof t.dialog.chatId==="number"){i.dialog.chatId=t.dialog.chatId}if(typeof t.dialog.diskFolderId==="number"){i.dialog.diskFolderId=t.dialog.diskFolderId}if(typeof t.dialog.messageLimit==="number"){i.dialog.messageLimit=t.dialog.messageLimit}if(typeof t.dialog.messageExtraCount==="number"){i.dialog.messageExtraCount=t.dialog.messageExtraCount}if(typeof t.dialog.enableReadMessages==="boolean"){i.dialog.enableReadMessages=t.dialog.enableReadMessages}}if(babelHelpers["typeof"](t.disk)==="object"&&t.disk){i.disk={};if(typeof t.disk.enabled==="boolean"){i.disk.enabled=t.disk.enabled}if(typeof t.disk.maxFileSize==="number"){i.disk.maxFileSize=t.disk.maxFileSize}}if(babelHelpers["typeof"](t.call)==="object"&&t.call){i.call={};if(typeof t.call.serverEnabled==="boolean"){i.call.serverEnabled=t.call.serverEnabled}if(typeof t.call.maxParticipants==="number"){i.call.maxParticipants=t.call.maxParticipants}}if(babelHelpers["typeof"](t.mobile)==="object"&&t.mobile){i.mobile={};if(typeof t.mobile.keyboardShow==="boolean"){i.mobile.keyboardShow=t.mobile.keyboardShow}}if(babelHelpers["typeof"](t.device)==="object"&&t.device){i.device={};if(typeof t.device.type==="string"&&typeof s.DeviceType[t.device.type]!=="undefined"){i.device.type=t.device.type}if(typeof t.device.orientation==="string"&&typeof s.DeviceOrientation[t.device.orientation]!=="undefined"){i.device.orientation=t.device.orientation}}if(babelHelpers["typeof"](t.error)==="object"&&t.error){if(typeof t.error.active==="boolean"){i.error={active:t.error.active,code:t.error.code.toString()||"",description:t.error.description.toString()||""}}}return i}}]);return t}(r.VuexBuilderModel);
/**
	 * Bitrix Messenger
	 * Call Application model (Vuex Builder model)
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2020 Bitrix
	 */var c=function(e){babelHelpers.inherits(t,e);function t(){babelHelpers.classCallCheck(this,t);return babelHelpers.possibleConstructorReturn(this,babelHelpers.getPrototypeOf(t).apply(this,arguments))}babelHelpers.createClass(t,[{key:"getName",value:function e(){return"conference"}},{key:"getState",value:function e(){return{common:{inited:false,passChecked:true,showChat:false,userCount:0,messageCount:0,userInCallCount:0,state:s.ConferenceStateType.preparation,callEnded:false,showSmiles:false,error:"",conferenceTitle:"",alias:"",permissionsRequested:false,conferenceStarted:null,conferenceStartDate:null,joinWithVideo:null,userReadyToJoin:false,isBroadcast:false,users:[],usersInCall:[],presenters:[],rightPanelMode:s.ConferenceRightPanelMode.hidden,hasErrorInCall:false},user:{id:-1,hash:""}}}},{key:"getActions",value:function e(){return{showChat:function e(t,i){if(typeof i.newState!=="boolean"){return false}t.commit("showChat",i)},changeRightPanelMode:function e(t,i){if(!s.ConferenceRightPanelMode[i.mode]){return false}t.commit("changeRightPanelMode",i)},setPermissionsRequested:function e(t,i){if(typeof i.status!=="boolean"){return false}t.commit("setPermissionsRequested",i)},setPresenters:function e(t,i){if(!Array.isArray(i.presenters)){i.presenters=[i.presenters]}t.commit("setPresenters",i)},setUsers:function e(t,i){if(!Array.isArray(i.users)){i.users=[i.users]}t.commit("setUsers",i)},removeUsers:function e(t,i){if(!Array.isArray(i.users)){i.users=[i.users]}t.commit("removeUsers",i)},setUsersInCall:function e(t,i){if(!Array.isArray(i.users)){i.users=[i.users]}t.commit("setUsersInCall",i)},removeUsersInCall:function e(t,i){if(!Array.isArray(i.users)){i.users=[i.users]}t.commit("removeUsersInCall",i)},setConferenceTitle:function e(t,i){if(typeof i.conferenceTitle!=="string"){return false}t.commit("setConferenceTitle",i)},setBroadcastMode:function e(t,i){if(typeof i.broadcastMode!=="boolean"){return false}t.commit("setBroadcastMode",i)}}}},{key:"getMutations",value:function e(){var t=this;return{common:function e(t,i){if(typeof i.inited==="boolean"){t.common.inited=i.inited}if(typeof i.passChecked==="boolean"){t.common.passChecked=i.passChecked}if(typeof i.userCount==="number"||typeof i.userCount==="string"){t.common.userCount=parseInt(i.userCount)}if(typeof i.messageCount==="number"||typeof i.messageCount==="string"){t.common.messageCount=parseInt(i.messageCount)}if(typeof i.userInCallCount==="number"||typeof i.userInCallCount==="string"){t.common.userInCallCount=parseInt(i.userInCallCount)}if(typeof i.componentError==="string"){t.common.componentError=i.componentError}if(typeof i.isBroadcast==="boolean"){t.common.isBroadcast=i.isBroadcast}if(Array.isArray(i.presenters)){t.common.presenters=i.presenters}if(typeof i.hasErrorInCall==="boolean"){t.common.hasErrorInCall=i.hasErrorInCall}},user:function e(i,n){if(typeof n.id==="number"){i.user.id=n.id}if(typeof n.hash==="string"&&n.hash!==i.user.hash){i.user.hash=n.hash}if(t.isSaveNeeded({user:n})){t.saveState(i)}},showChat:function e(t,i){var n=i.newState;t.common.showChat=n},changeRightPanelMode:function e(t,i){var n=i.mode;t.common.rightPanelMode=n},setPermissionsRequested:function e(t,i){t.common.permissionsRequested=i.status},startCall:function e(t,i){t.common.state=s.ConferenceStateType.call;t.common.callEnded=false},endCall:function e(t,i){t.common.state=s.ConferenceStateType.preparation;t.common.callEnded=true},returnToPreparation:function e(t,i){t.common.state=s.ConferenceStateType.preparation},toggleSmiles:function e(t,i){t.common.showSmiles=!t.common.showSmiles},setError:function e(t,i){if(typeof i.errorCode==="string"){t.common.error=i.errorCode}},setConferenceTitle:function e(t,i){t.common.conferenceTitle=i.conferenceTitle},setBroadcastMode:function e(t,i){t.common.isBroadcast=i.broadcastMode},setAlias:function e(t,i){if(typeof i.alias==="string"){t.common.alias=i.alias}},setJoinType:function e(t,i){if(typeof i.joinWithVideo==="boolean"){t.common.joinWithVideo=i.joinWithVideo}},setConferenceStatus:function e(t,i){if(typeof i.conferenceStarted==="boolean"){t.common.conferenceStarted=i.conferenceStarted}},setConferenceHasErrorInCall:function e(t,i){if(typeof i.hasErrorInCall==="boolean"){t.common.hasErrorInCall=i.hasErrorInCall}},setConferenceStartDate:function e(t,i){if(i.conferenceStartDate instanceof Date){t.common.conferenceStartDate=i.conferenceStartDate}},setUserReadyToJoin:function e(t,i){t.common.userReadyToJoin=true},setPresenters:function e(t,i){if(i.replace){t.common.presenters=i.presenters}else{i.presenters.forEach((function(e){e=parseInt(e);if(!t.common.presenters.includes(e)){t.common.presenters.push(e)}}))}},setUsers:function e(t,i){i.users.forEach((function(e){e=parseInt(e);if(!t.common.users.includes(e)){t.common.users.push(e)}}))},removeUsers:function e(t,i){t.common.users=t.common.users.filter((function(e){return!i.users.includes(parseInt(e))}))},setUsersInCall:function e(t,i){i.users.forEach((function(e){e=parseInt(e);if(!t.common.usersInCall.includes(e)){t.common.usersInCall.push(e)}}))},removeUsersInCall:function e(t,i){t.common.usersInCall=t.common.usersInCall.filter((function(e){return!i.users.includes(parseInt(e))}))}}}},{key:"getStateSaveException",value:function e(){return{common:{inited:null,state:null,showSmiles:null,userCount:null,messageCount:null,userInCallCount:null,error:null,conferenceTitle:null,alias:null,conferenceStarted:null,conferenceStartDate:null,joinWithVideo:null,userReadyToJoin:null,rightPanelMode:null,presenters:null,users:null,hasErrorInCall:null}}}}]);return t}(r.VuexBuilderModel);function u(e,t){var i=typeof Symbol!=="undefined"&&e[Symbol.iterator]||e["@@iterator"];if(!i){if(Array.isArray(e)||(i=d(e))||t&&e&&typeof e.length==="number"){if(i)e=i;var n=0;var a=function e(){};return{s:a,n:function t(){if(n>=e.length)return{done:true};return{done:false,value:e[n++]}},e:function e(t){throw t},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var r=true,o=false,s;return{s:function t(){i=i.call(e)},n:function e(){var t=i.next();r=t.done;return t},e:function e(t){o=true;s=t},f:function e(){try{if(!r&&i["return"]!=null)i["return"]()}finally{if(o)throw s}}}}function d(e,t){if(!e)return;if(typeof e==="string")return f(e,t);var i=Object.prototype.toString.call(e).slice(8,-1);if(i==="Object"&&e.constructor)i=e.constructor.name;if(i==="Map"||i==="Set")return Array.from(e);if(i==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i))return f(e,t)}function f(e,t){if(t==null||t>e.length)t=e.length;for(var i=0,n=new Array(t);i<t;i++)n[i]=e[i];return n}var p={empty:"empty",equal:"equal",none:"none",found:"found",foundReverse:"foundReverse"};var h=function(e){babelHelpers.inherits(r,e);function r(){babelHelpers.classCallCheck(this,r);return babelHelpers.possibleConstructorReturn(this,babelHelpers.getPrototypeOf(r).apply(this,arguments))}babelHelpers.createClass(r,[{key:"getName",value:function e(){return"messages"}},{key:"getState",value:function e(){return{created:0,collection:{},mutationType:{},saveMessageList:{},saveFileList:{},saveUserList:{},host:this.getVariable("host",location.protocol+"//"+location.host)}}},{key:"getElementState",value:function e(){return{templateId:0,templateType:"message",placeholderType:0,id:0,chatId:0,authorId:0,date:new Date,text:"",textConverted:"",params:{TYPE:"default",COMPONENT_ID:"bx-im-view-message"},push:false,unread:false,sending:false,error:false,retry:false,blink:false}}},{key:"getGetters",value:function e(){var t=this;return{getMutationType:function e(t){return function(e){if(!t.mutationType[e]){return{initialType:s.MutationType.none,appliedType:s.MutationType.none}}return t.mutationType[e]}},getLastId:function e(t){return function(e){if(!t.collection[e]||t.collection[e].length<=0){return null}var i=0;for(var n=0;n<t.collection[e].length;n++){var a=t.collection[e][n];if(a.push||a.sending||a.id.toString().startsWith("temporary")){continue}if(i<a.id){i=a.id}}return i?i:null}},getMessage:function e(t){return function(e,i){if(!t.collection[e]||t.collection[e].length<=0){return null}for(var n=t.collection[e].length-1;n>=0;n--){if(t.collection[e][n].id===i){return t.collection[e][n]}}return null}},get:function e(t){return function(e){if(!t.collection[e]||t.collection[e].length<=0){return[]}return t.collection[e]}},getBlank:function e(i){return function(e){return t.getElementState()}},getSaveFileList:function e(t){return function(e){return t.saveFileList}},getSaveUserList:function e(t){return function(e){return t.saveUserList}}}}},{key:"getActions",value:function e(){var t=this;return{add:function e(i,n){var a=t.validate(Object.assign({},n));a.params=Object.assign({},t.getElementState().params,a.params);if(n.id){if(i.state.collection[n.chatId]){var r=i.state.collection[n.chatId].length-1;for(var o=r;o>=0;o--){var s=i.state.collection[n.chatId][o];if(s.templateId===n.id){return}}}a.id=n.id}else{a.id="temporary"+(new Date).getTime()+i.state.created}a.templateId=a.id;a.unread=false;i.commit("add",Object.assign({},t.getElementState(),a));if(n.sending!==false){i.dispatch("actionStart",{id:a.id,chatId:a.chatId})}return a.id},actionStart:function e(t,i){if(/^\d+$/.test(i.id)){i.id=parseInt(i.id)}i.chatId=parseInt(i.chatId);a.Vue.nextTick((function(){t.commit("update",{id:i.id,chatId:i.chatId,fields:{sending:true}})}))},actionError:function e(t,i){if(/^\d+$/.test(i.id)){i.id=parseInt(i.id)}i.chatId=parseInt(i.chatId);a.Vue.nextTick((function(){t.commit("update",{id:i.id,chatId:i.chatId,fields:{sending:false,error:true,retry:i.retry!==false}})}))},actionFinish:function e(t,i){if(/^\d+$/.test(i.id)){i.id=parseInt(i.id)}i.chatId=parseInt(i.chatId);a.Vue.nextTick((function(){t.commit("update",{id:i.id,chatId:i.chatId,fields:{sending:false,error:false,retry:false}})}))},set:function e(i,n){if(n instanceof Array){n=n.map((function(e){return t.prepareMessage(e,{host:i.state.host})}))}else{var a=t.prepareMessage(n,{host:i.state.host});(n=[]).push(a)}i.commit("set",{insertType:s.MutationType.set,data:n});return"set is done"},addPlaceholders:function e(i,n){if(n.placeholders instanceof Array){n.placeholders=n.placeholders.map((function(e){return t.prepareMessage(e,{host:i.state.host})}))}else{return false}var a=n.requestMode==="history"?s.MutationType.setBefore:s.MutationType.setAfter;if(a===s.MutationType.setBefore){n.placeholders=n.placeholders.reverse()}i.commit("set",{insertType:a,data:n.placeholders});return n.placeholders[0].id},clearPlaceholders:function e(t,i){t.commit("clearPlaceholders",i)},updatePlaceholders:function e(i,n){if(n.data instanceof Array){n.data=n.data.map((function(e){return t.prepareMessage(e,{host:i.state.host})}))}else{return false}i.commit("updatePlaceholders",n);return true},setAfter:function e(i,n){if(n instanceof Array){n=n.map((function(e){return t.prepareMessage(e)}))}else{var a=t.prepareMessage(n);(n=[]).push(a)}i.commit("set",{insertType:s.MutationType.setAfter,data:n})},setBefore:function e(i,n){if(n instanceof Array){n=n.map((function(e){return t.prepareMessage(e)}))}else{var a=t.prepareMessage(n);(n=[]).push(a)}i.commit("set",{insertType:s.MutationType.setBefore,data:n})},update:function e(i,n){if(/^\d+$/.test(n.id)){n.id=parseInt(n.id)}if(/^\d+$/.test(n.chatId)){n.chatId=parseInt(n.chatId)}i.commit("initCollection",{chatId:n.chatId});if(!i.state.collection[n.chatId]){return false}var a=i.state.collection[n.chatId].findIndex((function(e){return e.id===n.id}));if(a<0){return false}var r=t.validate(Object.assign({},n.fields));if(r.params){r.params=Object.assign({},t.getElementState().params,i.state.collection[n.chatId][a].params,r.params)}i.commit("update",{id:n.id,chatId:n.chatId,index:a,fields:r});if(n.fields.blink){setTimeout((function(){i.commit("update",{id:n.id,chatId:n.chatId,fields:{blink:false}})}),1e3)}return true},delete:function e(t,i){if(!(i.id instanceof Array)){i.id=[i.id]}i.id=i.id.map((function(e){if(/^\d+$/.test(e)){e=parseInt(e)}return e}));t.commit("delete",{chatId:i.chatId,elements:i.id});return true},clear:function e(t,i){i.chatId=parseInt(i.chatId);if(i.keepPlaceholders){t.commit("clearMessages",{chatId:i.chatId})}else{t.commit("clear",{chatId:i.chatId})}return true},applyMutationType:function e(t,i){i.chatId=parseInt(i.chatId);t.commit("applyMutationType",{chatId:i.chatId});return true},readMessages:function e(t,i){i.readId=parseInt(i.readId)||0;i.chatId=parseInt(i.chatId);if(typeof t.state.collection[i.chatId]==="undefined"){return{count:0}}var n=0;for(var a=t.state.collection[i.chatId].length-1;a>=0;a--){var r=t.state.collection[i.chatId][a];if(!r.unread)continue;if(i.readId===0||r.id<=i.readId){n++}}t.commit("readMessages",{chatId:i.chatId,readId:i.readId});return{count:n}},unreadMessages:function e(t,i){i.unreadId=parseInt(i.unreadId)||0;i.chatId=parseInt(i.chatId);if(typeof t.state.collection[i.chatId]==="undefined"||!i.unreadId){return{count:0}}var n=0;for(var a=t.state.collection[i.chatId].length-1;a>=0;a--){var r=t.state.collection[i.chatId][a];if(r.unread)continue;if(r.id>=i.unreadId){n++}}t.commit("unreadMessages",{chatId:i.chatId,unreadId:i.unreadId});return{count:n}}}}},{key:"getMutations",value:function e(){var n=this;return{initCollection:function e(t,i){return n.initCollection(t,i)},add:function e(i,a){n.initCollection(i,{chatId:a.chatId});i.collection[a.chatId].push(a);i.saveMessageList[a.chatId].push(a.id);i.created+=1;i.collection[a.chatId].sort((function(e,t){return e.id-t.id}));n.saveState(i,a.chatId);t.Logger.warn("Messages model: saving state after add")},clearPlaceholders:function e(t,i){if(!t.collection[i.chatId]){return false}t.collection[i.chatId]=t.collection[i.chatId].filter((function(e){return!e.id.toString().startsWith("placeholder")}))},updatePlaceholders:function e(i,a){var r="placeholder".concat(a.firstMessage);var o=i.collection[a.chatId].findIndex((function(e){return e.id===r}));if(o>=0){var s;i.collection[a.chatId].splice(o,a.amount);(s=i.collection[a.chatId]).splice.apply(s,[o,0].concat(babelHelpers.toConsumableArray(a.data)))}i.collection[a.chatId].sort((function(e,t){return e.id-t.id}));t.Logger.warn("Messages model: saving state after updating placeholders");n.saveState(i,a.chatId)},set:function e(a,o){t.Logger.warn("Messages model: set mutation",o);var l=[];var c=[];var d=false;o.data=r.getPayloadWithTempMessages(a,o);var f=o.insertType;if(o.insertType===s.MutationType.set){o.insertType=s.MutationType.setAfter;var h={};o.data.forEach((function(e){if(!h[e.chatId]){h[e.chatId]=[]}h[e.chatId].push(e.id)}));var m=function e(i){if(!h.hasOwnProperty(i))return"continue";n.initCollection(a,{chatId:i});t.Logger.warn("Messages model: messages before adding from request - ",a.collection[i].length);if(a.saveMessageList[i].length>h[i].length||h[i].length<s.StorageLimit.messages){a.collection[i]=a.collection[i].filter((function(e){return h[i].includes(e.id)}));a.saveMessageList[i]=a.saveMessageList[i].filter((function(e){return h[i].includes(e)}))}t.Logger.warn("Messages model: cache length",a.saveMessageList[i].length);var r=n.manageCacheBeforeSet(babelHelpers.toConsumableArray(a.saveMessageList[i].reverse()),h[i]);t.Logger.warn("Messages model: set intersection with cache",r);if(r.type===p.none){if(r.foundElements.length>0){a.collection[i]=a.collection[i].filter((function(e){return!r.foundElements.includes(e.id)}));a.saveMessageList[i]=a.saveMessageList[i].filter((function(e){return!r.foundElements.includes(e)}))}t.Logger.warn("Messages model: no intersection - removing cache");n.removeIntersectionCacheElements=a.collection[i].map((function(e){return e.id}));a.collection[i]=a.collection[i].filter((function(e){return!n.removeIntersectionCacheElements.includes(e.id)}));a.saveMessageList[i]=a.saveMessageList[i].filter((function(e){return!n.removeIntersectionCacheElements.includes(e)}));n.removeIntersectionCacheElements=[]}else if(r.type===p.foundReverse){t.Logger.warn("Messages model: found reverse intersection");o.insertType=s.MutationType.setBefore;o.data=o.data.reverse()}};for(var g in h){var y=m(g);if(y==="continue")continue}}t.Logger.warn("Messages model: adding messages to model",o.data);var v=u(o.data),b;try{var I=function e(){var t=b.value;n.initCollection(a,{chatId:t.chatId});var i=a.collection[t.chatId].findIndex((function(e){if(r.isTemporaryMessage(e)){return e.templateId===t.templateId}return e.id===t.id}));if(i>-1){a.collection[t.chatId][i]=Object.assign(a.collection[t.chatId][i],t)}else if(o.insertType===s.MutationType.setBefore){a.collection[t.chatId].unshift(t)}else if(o.insertType===s.MutationType.setAfter){a.collection[t.chatId].push(t)}l.push(t.chatId);if(n.store.getters["dialogues/canSaveChat"]&&n.store.getters["dialogues/canSaveChat"](t.chatId)){c.push(t.chatId)}};for(v.s();!(b=v.n()).done;){I()}}catch(e){v.e(e)}finally{v.f()}l=babelHelpers.toConsumableArray(new Set(l));c=babelHelpers.toConsumableArray(new Set(c));d=o.data.every((function(e){return e.push===true}));t.Logger.warn("Is it fake push message?",d);l.forEach((function(e){a.collection[e].sort((function(e,t){return e.id-t.id}));if(!d){t.Logger.warn("setting messagesSet = true for chatId = ",e);setTimeout((function(){i.EventEmitter.emit(s.EventType.dialog.messagesSet,{chatId:e});i.EventEmitter.emit(s.EventType.dialog.readVisibleMessages,{chatId:e})}),100)}}));if(f!==s.MutationType.setBefore){c.forEach((function(e){t.Logger.warn("Messages model: saving state after set");n.saveState(a,e)}))}},update:function e(i,a){n.initCollection(i,{chatId:a.chatId});var r=-1;if(typeof a.index!=="undefined"&&i.collection[a.chatId][a.index]){r=a.index}else{r=i.collection[a.chatId].findIndex((function(e){return e.id===a.id}))}if(r>=0){var o=i.saveMessageList[a.chatId].includes(i.collection[a.chatId][r].id)||a.fields.id&&!a.fields.id.toString().startsWith("temporary")&&i.collection[a.chatId][r].id.toString().startsWith("temporary");i.collection[a.chatId][r]=Object.assign(i.collection[a.chatId][r],a.fields);if(o){t.Logger.warn("Messages model: saving state after update");n.saveState(i,a.chatId)}}},delete:function e(i,a){n.initCollection(i,{chatId:a.chatId});i.collection[a.chatId]=i.collection[a.chatId].filter((function(e){return!a.elements.includes(e.id)}));if(i.saveMessageList[a.chatId].length>0){var r=u(a.elements),o;try{for(r.s();!(o=r.n()).done;){var s=o.value;if(i.saveMessageList[a.chatId].includes(s)){t.Logger.warn("Messages model: saving state after delete");n.saveState(i,a.chatId);break}}}catch(e){r.e(e)}finally{r.f()}}},clear:function e(t,i){n.initCollection(t,{chatId:i.chatId});t.collection[i.chatId]=[];t.saveMessageList[i.chatId]=[]},clearMessages:function e(t,i){n.initCollection(t,{chatId:i.chatId});t.collection[i.chatId]=t.collection[i.chatId].filter((function(e){return e.id.toString().startsWith("placeholder")}));t.saveMessageList[i.chatId]=[]},applyMutationType:function e(t,i){if(typeof t.mutationType[i.chatId]==="undefined"){a.Vue.set(t.mutationType,i.chatId,{applied:false,initialType:s.MutationType.none,appliedType:s.MutationType.none,scrollStickToTop:0,scrollMessageId:0})}t.mutationType[i.chatId].applied=true},readMessages:function e(i,a){n.initCollection(i,{chatId:a.chatId});var r=false;for(var o=i.collection[a.chatId].length-1;o>=0;o--){var s=i.collection[a.chatId][o];if(!s.unread)continue;if(a.readId===0||s.id<=a.readId){i.collection[a.chatId][o]=Object.assign(i.collection[a.chatId][o],{unread:false});r=true}}if(r){t.Logger.warn("Messages model: saving state after reading");n.saveState(i,a.chatId)}},unreadMessages:function e(i,a){n.initCollection(i,{chatId:a.chatId});var r=false;for(var o=i.collection[a.chatId].length-1;o>=0;o--){var s=i.collection[a.chatId][o];if(s.unread)continue;if(s.id>=a.unreadId){i.collection[a.chatId][o]=Object.assign(i.collection[a.chatId][o],{unread:true});r=true}}if(r){t.Logger.warn("Messages model: saving state after unreading");n.saveState(i,a.chatId);n.updateSubordinateStates()}}}}},{key:"initCollection",value:function e(t,i){if(typeof i.chatId==="undefined"){return false}if(typeof i.chatId==="undefined"||typeof t.collection[i.chatId]!=="undefined"){return true}a.Vue.set(t.collection,i.chatId,i.messages?[].concat(i.messages):[]);a.Vue.set(t.saveMessageList,i.chatId,[]);a.Vue.set(t.saveFileList,i.chatId,[]);a.Vue.set(t.saveUserList,i.chatId,[]);return true}},{key:"prepareMessage",value:function e(t){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var n=this.validate(Object.assign({},t),i);n.params=Object.assign({},this.getElementState().params,n.params);if(!n.templateId){n.templateId=n.id}return Object.assign({},this.getElementState(),n)}},{key:"manageCacheBeforeSet",value:function e(i,n){var a=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;t.Logger.warn("manageCacheBeforeSet",i,n);var r={type:p.empty,foundElements:[],noneElements:[]};if(!i||i.length<=0){return r}var o=u(n),s;try{for(o.s();!(s=o.n()).done;){var l=s.value;if(i.includes(l)){if(r.type===p.empty){r.type=p.found}r.foundElements.push(l)}else{if(r.type===p.empty){r.type=p.none}r.noneElements.push(l)}}}catch(e){o.e(e)}finally{o.f()}if(r.type===p.found&&i.length===n.length&&r.foundElements.length===n.length){r.type=p.equal}else if(r.type===p.none&&!a&&r.foundElements.length>0){var c=this.manageCacheBeforeSet(i.reverse(),n.reverse(),true);if(c.type===p.found){c.type=p.foundReverse;return c}}return r}},{key:"updateSaveLists",value:function e(t,i){if(!this.isSaveAvailable()){return true}if(!i||!this.store.getters["dialogues/canSaveChat"]||!this.store.getters["dialogues/canSaveChat"](i)){return false}this.initCollection(t,{chatId:i});var n=0;var a=[];var r=[];var o=[];var l=this.store.getters["dialogues/getByChatId"](i);if(l&&l.type==="private"){o.push(parseInt(l.dialogId))}var c=0;for(var u=t.collection[i].length-1;u>=0;u--){if(t.collection[i][u].id.toString().startsWith("temporary")){continue}if(!t.collection[i][u].unread){c++}if(n>=s.StorageLimit.messages&&c>=50){break}a.unshift(t.collection[i][u].id);n++}a=a.slice(0,s.StorageLimit.messages);t.collection[i].filter((function(e){return a.includes(e.id)})).forEach((function(e){if(e.authorId>0){o.push(e.authorId)}if(e.params.FILE_ID instanceof Array){r=e.params.FILE_ID.concat(r)}}));t.saveMessageList[i]=a;t.saveFileList[i]=babelHelpers.toConsumableArray(new Set(r));t.saveUserList[i]=babelHelpers.toConsumableArray(new Set(o));return true}},{key:"getSaveTimeout",value:function e(){return 150}},{key:"saveState",value:function e(i,n){if(!this.updateSaveLists(i,n)){return false}babelHelpers.get(babelHelpers.getPrototypeOf(r.prototype),"saveState",this).call(this,(function(){var e={collection:{},saveMessageList:{},saveUserList:{},saveFileList:{}};var n=function n(a){if(!i.saveMessageList.hasOwnProperty(a)){return"continue"}if(!i.collection[a]){return"continue"}if(!e.collection[a]){e.collection[a]=[]}i.collection[a].filter((function(e){return i.saveMessageList[a].includes(e.id)})).forEach((function(t){if(t.templateType!=="placeholder"){e.collection[a].push(t)}}));t.Logger.warn("Cache after updating",e.collection[a]);e.saveMessageList[a]=i.saveMessageList[a];e.saveFileList[a]=i.saveFileList[a];e.saveUserList[a]=i.saveUserList[a]};for(var a in i.saveMessageList){var r=n(a);if(r==="continue")continue}return e}))}},{key:"updateSubordinateStates",value:function e(){this.store.dispatch("users/saveState");this.store.dispatch("files/saveState")}},{key:"validate",value:function e(t,i){var a={};if(typeof t.id==="number"){a.id=t.id}else if(typeof t.id==="string"){if(t.id.startsWith("temporary")||t.id.startsWith("placeholder")||n.Utils.types.isUuidV4(t.id)){a.id=t.id}else{a.id=parseInt(t.id)}}if(typeof t.uuid==="string"){a.templateId=t.uuid}else if(typeof t.templateId==="number"){a.templateId=t.templateId}else if(typeof t.templateId==="string"){if(t.templateId.startsWith("temporary")||n.Utils.types.isUuidV4(t.templateId)){a.templateId=t.templateId}else{a.templateId=parseInt(t.templateId)}}if(typeof t.templateType==="string"){a.templateType=t.templateType}if(typeof t.placeholderType==="number"){a.placeholderType=t.placeholderType}if(typeof t.chat_id!=="undefined"){t.chatId=t.chat_id}if(typeof t.chatId==="number"||typeof t.chatId==="string"){a.chatId=parseInt(t.chatId)}if(typeof t.date!=="undefined"){a.date=n.Utils.date.cast(t.date)}if(typeof t.textLegacy==="string"||typeof t.textLegacy==="number"){if(typeof t.text==="string"||typeof t.text==="number"){a.text=t.text.toString()}a.textConverted=this.convertToHtml({text:t.textLegacy.toString(),isConverted:true});if(typeof t.text==="string"||typeof t.text==="number"){a.text=t.text}}else{if(typeof t.text_converted!=="undefined"){t.textConverted=t.text_converted}if(typeof t.textConverted==="string"||typeof t.textConverted==="number"){a.textConverted=t.textConverted.toString()}if(typeof t.text==="string"||typeof t.text==="number"){a.text=t.text.toString();var r=typeof a.textConverted!=="undefined";a.textConverted=this.convertToHtml({text:r?a.textConverted:a.text,isConverted:r})}}if(typeof t.senderId!=="undefined"){t.authorId=t.senderId}else if(typeof t.author_id!=="undefined"){t.authorId=t.author_id}if(typeof t.authorId==="number"||typeof t.authorId==="string"){if(t.system===true||t.system==="Y"){a.authorId=0}else{a.authorId=parseInt(t.authorId)}}if(babelHelpers["typeof"](t.params)==="object"&&t.params!==null){var o=this.validateParams(t.params,i);if(o){a.params=o}}if(typeof t.push==="boolean"){a.push=t.push}if(typeof t.sending==="boolean"){a.sending=t.sending}if(typeof t.unread==="boolean"){a.unread=t.unread}if(typeof t.blink==="boolean"){a.blink=t.blink}if(typeof t.error==="boolean"||typeof t.error==="string"){a.error=t.error}if(typeof t.retry==="boolean"){a.retry=t.retry}return a}},{key:"validateParams",value:function e(t,i){var a={};try{for(var r in t){if(!t.hasOwnProperty(r)){continue}if(r==="COMPONENT_ID"){if(typeof t[r]==="string"&&BX.Vue.isComponent(t[r])){a[r]=t[r]}}else if(r==="LIKE"){if(t[r]instanceof Array){a["REACTION"]={like:t[r].map((function(e){return parseInt(e)}))}}}else if(r==="CHAT_LAST_DATE"){a[r]=n.Utils.date.cast(t[r])}else if(r==="AVATAR"){if(t[r]){a[r]=t[r].startsWith("http")?t[r]:i.host+t[r]}}else if(r==="NAME"){if(t[r]){a[r]=t[r]}}else if(r==="LINK_ACTIVE"){if(t[r]){a[r]=t[r].map((function(e){return parseInt(e)}))}}else if(r==="ATTACH"){a[r]=t[r]}else{a[r]=t[r]}}}catch(e){}var o=false;for(var s in a){if(!a.hasOwnProperty(s)){continue}o=true;break}return o?a:null}},{key:"convertToHtml",value:function e(){var t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var i=t.quote,a=i===void 0?true:i,r=t.image,o=r===void 0?true:r,s=t.text,l=s===void 0?"":s,c=t.isConverted,u=c===void 0?false:c,d=t.enableBigSmile,f=d===void 0?true:d;l=l.trim();if(!u){l=l.replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}if(l.startsWith("/me")){l="<i>".concat(l.substr(4),"</i>")}else if(l.startsWith("/loud")){l="<b>".concat(l.substr(6),"</b>")}var p="&gt;&gt;";if(a&&l.indexOf(p)>=0){var h=l.split(u?"<br />":"\n");for(var m=0;m<h.length;m++){if(h[m].startsWith(p)){h[m]=h[m].replace(p,'<div class="bx-im-message-content-quote"><div class="bx-im-message-content-quote-wrap">');while(++m<h.length&&h[m].startsWith(p)){h[m]=h[m].replace(p,"")}h[m-1]+="</div></div><br>"}}l=h.join("<br />")}l=l.replace(/\n/gi,"<br />");l=l.replace(/\t/gi,"&nbsp;&nbsp;&nbsp;&nbsp;");l=n.Utils.text.decodeBbCode(l,f);if(a){l=l.replace(/------------------------------------------------------<br \/>(.*?)\[(.*?)\](?: #(?:(?:chat)?\d+|\d+:\d+)\/\d+)?<br \/>(.*?)------------------------------------------------------(<br \/>)?/g,(function(e,t,i,n,a,r){return(r>0?"<br>":"")+'<div class="bx-im-message-content-quote"><div class="bx-im-message-content-quote-wrap"><div class="bx-im-message-content-quote-name"><span class="bx-im-message-content-quote-name-text">'+t+'</span><span class="bx-im-message-content-quote-name-time">'+i+"</span></div>"+n+"</div></div><br />"}));l=l.replace(/------------------------------------------------------<br \/>(.*?)------------------------------------------------------(<br \/>)?/g,(function(e,t,i,n,a){return(a>0?"<br>":"")+'<div class="bx-im-message-content-quote"><div class="bx-im-message-content-quote-wrap">'+t+"</div></div><br />"}))}if(o){var g=false;l=l.replace(/<a(.*?)>(http[s]{0,1}:\/\/.*?)<\/a>/gi,(function(e,t,i,n){if(!i.match(/(\.(jpg|jpeg|png|gif|webp)\?|\.(jpg|jpeg|png|gif|webp)$)/i)||i.indexOf("/docs/pub/")>0||i.indexOf("logout=yes")>0){return e}else{g=true;return(n>0?"<br />":"")+"<a"+t+' target="_blank" class="bx-im-element-file-image"><img src="'+i+'" class="bx-im-element-file-image-source-text" onerror="BX.Messenger.Model.MessagesModel.hideErrorImage(this)"></a></span>'}}));if(g){l=l.replace(/<\/span>(\n?)<br(\s\/?)>/gi,"</span>").replace(/<br(\s\/?)>(\n?)<br(\s\/?)>(\n?)<span/gi,"<br /><span")}}if(f){l=l.replace(/^(\s*<img\s+src=[^>]+?data-code=[^>]+?data-definition="UHD"[^>]+?style="width:)(\d+)(px[^>]+?height:)(\d+)(px[^>]+?class="bx-smile"\s*\/?>\s*)$/,(function e(t,i,n,a,r,o){return i+parseInt(n,10)*1.7+a+parseInt(r,10)*1.7+o}))}if(l.substr(-6)=="<br />"){l=l.substr(0,l.length-6)}l=l.replace(/<br><br \/>/gi,"<br />");l=l.replace(/<br \/><br>/gi,"<br />");return l}},{key:"decodeBbCode",value:function e(t){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;var n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:true;return r.decodeBbCode({text:t,textOnly:i,enableBigSmile:n})}},{key:"decodeAttach",value:function e(t){var i=this;if(Array.isArray(t)){t.forEach((function(e){e=i.decodeAttach(e)}))}else if(babelHelpers["typeof"](t)==="object"&&t!==null){for(var a in t){if(t.hasOwnProperty(a)){t[a]=this.decodeAttach(t[a])}}}else{if(typeof t==="string"){t=n.Utils.text.htmlspecialcharsback(t)}}return t}}],[{key:"decodeBbCode",value:function e(){var t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var i=t.text,a=t.textOnly,r=a===void 0?false:a,o=t.enableBigSmile,s=o===void 0?true:o;var l=[];i=i.replace(/\[PUT(?:=(.+?))?\](.+?)?\[\/PUT\]/gi,(function(e){var t=l.length;l.push(e);return"####REPLACEMENT_PUT_"+t+"####"}));var c=[];i=i.replace(/\[SEND(?:=(.+?))?\](.+?)?\[\/SEND\]/gi,(function(e){var t=c.length;c.push(e);return"####REPLACEMENT_SEND_"+t+"####"}));var u=[];i=i.replace(/\[CODE\]\n?([\s\S]*?)\[\/CODE\]/gi,(function(e,t){var i=u.length;u.push(t);return"####REPLACEMENT_CODE_"+i+"####"}));i=i.replace(/\[url=([^\]]+)\]([\s\S]*?)\[\/url\]/gi,(function(e,t,i){var a=document.createElement("a");a.href=n.Utils.text.htmlspecialcharsback(t);a.target="_blank";a.text=n.Utils.text.htmlspecialcharsback(i);var r=["http:","https:","ftp:","file:","tel:","callto:","mailto:","skype:","viber:"];if(r.indexOf(a.protocol)<=-1){return e}return a.outerHTML}));i=i.replace(/\[url\]([^\]]+)\[\/url\]/gi,(function(e,t){t=n.Utils.text.htmlspecialcharsback(t);var i=document.createElement("a");i.href=t;i.target="_blank";i.text=t;var a=["http:","https:","ftp:","file:","tel:","callto:","mailto:","skype:","viber:"];if(a.indexOf(i.protocol)<=-1){return e}return i.outerHTML}));i=i.replace(/\[LIKE\]/gi,'<span class="bx-smile bx-im-smile-like"></span>');i=i.replace(/\[DISLIKE\]/gi,'<span class="bx-smile bx-im-smile-dislike"></span>');i=i.replace(/\[BR\]/gi,"<br/>");i=i.replace(/\[([buis])\](.*?)\[(\/[buis])\]/gi,(function(e,t,i,n){return"<"+t+">"+i+"<"+n+">"}));i=i.replace(/\[CHAT=(imol\|)?([0-9]{1,})\](.*?)\[\/CHAT\]/gi,(function(e,t,i,n){return t?n:'<span class="bx-im-mention" data-type="CHAT" data-value="chat'+i+'">'+n+"</span>"}));i=i.replace(/\[CALL(?:=(.+?))?\](.+?)?\[\/CALL\]/gi,(function(e,t,i){return'<span class="bx-im-mention" data-type="CALL" data-value="'+n.Utils.text.htmlspecialchars(t)+'">'+i+"</span>"}));i=i.replace(/\[PCH=([0-9]{1,})\](.*?)\[\/PCH\]/gi,(function(e,t,i){return i}));var d=0;if(s){d=i.replace(/\[icon\=([^\]]*)\]/gi,"").trim().length}i=i.replace(/\[icon\=([^\]]*)\]/gi,(function(e){var t=e.match(/icon\=(\S+[^\s.,> )\];\'\"!?])/i);if(t&&t[1]){t=t[1]}else{return""}var i={src:t,border:0};var a=e.match(/size\=(\d+)/i);if(a&&a[1]){i["width"]=a[1];i["height"]=a[1]}else{var r=e.match(/width\=(\d+)/i);if(r&&r[1]){i["width"]=r[1]}var o=e.match(/height\=(\d+)/i);if(o&&o[1]){i["height"]=o[1]}if(i["width"]&&!i["height"]){i["height"]=i["width"]}else if(i["height"]&&!i["width"]){i["width"]=i["height"]}else if(i["height"]&&i["width"]);else{i["width"]=20;i["height"]=20}}i["width"]=i["width"]>100?100:i["width"];i["height"]=i["height"]>100?100:i["height"];if(s&&d===0&&i["width"]===i["height"]&&i["width"]===20){i["width"]=40;i["height"]=40}var l=e.match(/title\=(.*[^\s\]])/i);if(l&&l[1]){l=l[1];if(l.indexOf("width=")>-1){l=l.substr(0,l.indexOf("width="))}if(l.indexOf("height=")>-1){l=l.substr(0,l.indexOf("height="))}if(l.indexOf("size=")>-1){l=l.substr(0,l.indexOf("size="))}if(l){i["title"]=n.Utils.text.htmlspecialchars(l).trim();i["alt"]=i["title"]}}var c="";for(var u in i){if(i.hasOwnProperty(u)){c+=u+'="'+i[u]+'" '}}return'<img class="bx-smile bx-icon" '+c+">"}));c.forEach((function(e,t){i=i.replace("####REPLACEMENT_SEND_"+t+"####",e)}));i=i.replace(/\[SEND(?:=(?:.+?))?\](?:.+?)?\[\/SEND]/gi,(function(e){return e.replace(/\[SEND(?:=(.+))?\](.+?)?\[\/SEND]/gi,(function(e,t,i){var n="";i=i?i:t;t=(t?t:i).replace("<br />","\n");if(!r&&i){i=i.replace(/<([\w]+)[^>]*>(.*?)<\\1>/i,"$2",i);i=i.replace(/\[([\w]+)[^\]]*\](.*?)\[\/\1\]/i,"$2",i);t=t.split("####REPLACEMENT_PUT_").join("####REPLACEMENT_SP_");n="\x3c!--IM_COMMAND_START--\x3e"+'<span class="bx-im-message-command-wrap">'+'<span class="bx-im-message-command" data-entity="send">'+i+"</span>"+'<span class="bx-im-message-command-data">'+t+"</span>"+"</span>"+"\x3c!--IM_COMMAND_END--\x3e"}else{n=i}return n}))}));l.forEach((function(e,t){i=i.replace("####REPLACEMENT_PUT_"+t+"####",e)}));i=i.replace(/\[PUT(?:=(?:.+?))?\](?:.+?)?\[\/PUT]/gi,(function(e){return e.replace(/\[PUT(?:=(.+))?\](.+?)?\[\/PUT]/gi,(function(e,t,i){var n="";i=i?i:t;t=(t?t:i).replace("<br />","\n");if(!r&&i){i=i.replace(/<([\w]+)[^>]*>(.*?)<\/\1>/i,"$2",i);i=i.replace(/\[([\w]+)[^\]]*\](.*?)\[\/\1\]/i,"$2",i);n="\x3c!--IM_COMMAND_START--\x3e"+'<span class="bx-im-message-command-wrap">'+'<span class="bx-im-message-command" data-entity="put">'+i+"</span>"+'<span class="bx-im-message-command-data">'+t+"</span>"+"</span>"+"\x3c!--IM_COMMAND_END--\x3e"}else{n=i}return n}))}));u.forEach((function(e,t){i=i.replace("####REPLACEMENT_CODE_"+t+"####",!r?'<div class="bx-im-message-content-code">'+e+"</div>":e)}));if(c.length>0){do{c.forEach((function(e,t){i=i.replace("####REPLACEMENT_SEND_"+t+"####",e)}))}while(i.includes("####REPLACEMENT_SEND_"))}i=i.split("####REPLACEMENT_SP_").join("####REPLACEMENT_PUT_");if(l.length>0){do{l.forEach((function(e,t){i=i.replace("####REPLACEMENT_PUT_"+t+"####",e)}))}while(i.includes("####REPLACEMENT_PUT_"))}return i}},{key:"hideErrorImage",value:function e(t){if(t.parentNode&&t.parentNode){t.parentNode.innerHTML='<a href="'+t.src+'" target="_blank">'+t.src+"</a>"}return true}},{key:"isTemporaryMessage",value:function e(t){return t.id&&(n.Utils.types.isUuidV4(t.id)||t.id.toString().startsWith("temporary"))}},{key:"getPayloadWithTempMessages",value:function e(t,i){var a=babelHelpers.toConsumableArray(i.data);if(!n.Utils.platform.isBitrixMobile()){return a}if(!i.data||i.data.length<=0){return a}var o=i.data[0].chatId;if(!t.collection[o]){return a}t.collection[o].forEach((function(e){if(r.isTemporaryMessage(e)&&!r.existsInPayload(i,e.templateId)&&r.doesTaskExist(e)){a.push(e)}}));return a}},{key:"existsInPayload",value:function e(t,i){return t.data.find((function(e){return e.templateId===i}))}},{key:"doesTaskExist",value:function e(t){if(Array.isArray(t.params.FILE_ID)){var i=false;t.params.FILE_ID.forEach((function(e){if(!i){i=window.imDialogUploadTasks.find((function(t){return t.taskId.split("|")[1]===e}))}}));return!!i}if(t.templateId){var n=window.imDialogMessagesTasks.find((function(e){return e.taskId.split("|")[1]===t.templateId}));return!!n}return false}}]);return r}(r.VuexBuilderModel);function m(e,t){var i=typeof Symbol!=="undefined"&&e[Symbol.iterator]||e["@@iterator"];if(!i){if(Array.isArray(e)||(i=g(e))||t&&e&&typeof e.length==="number"){if(i)e=i;var n=0;var a=function e(){};return{s:a,n:function t(){if(n>=e.length)return{done:true};return{done:false,value:e[n++]}},e:function e(t){throw t},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var r=true,o=false,s;return{s:function t(){i=i.call(e)},n:function e(){var t=i.next();r=t.done;return t},e:function e(t){o=true;s=t},f:function e(){try{if(!r&&i["return"]!=null)i["return"]()}finally{if(o)throw s}}}}function g(e,t){if(!e)return;if(typeof e==="string")return y(e,t);var i=Object.prototype.toString.call(e).slice(8,-1);if(i==="Object"&&e.constructor)i=e.constructor.name;if(i==="Map"||i==="Set")return Array.from(e);if(i==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i))return y(e,t)}function y(e,t){if(t==null||t>e.length)t=e.length;for(var i=0,n=new Array(t);i<t;i++)n[i]=e[i];return n}var v=function(e){babelHelpers.inherits(t,e);function t(){babelHelpers.classCallCheck(this,t);return babelHelpers.possibleConstructorReturn(this,babelHelpers.getPrototypeOf(t).apply(this,arguments))}babelHelpers.createClass(t,[{key:"getName",value:function e(){return"dialogues"}},{key:"getState",value:function e(){return{host:this.getVariable("host",location.protocol+"//"+location.host),collection:{},saveDialogList:[],saveChatList:[]}}},{key:"getStateSaveException",value:function e(){return{host:null}}},{key:"getElementStateSaveException",value:function e(){return{writingList:null,quoteId:null}}},{key:"getElementState",value:function e(){return{dialogId:"0",chatId:0,counter:0,userCounter:0,messageCount:0,unreadId:0,lastMessageId:0,managerList:[],readedList:[],writingList:[],muteList:[],textareaMessage:"",quoteId:0,editId:0,init:false,name:"",owner:0,extranet:false,avatar:"",color:"#17A3EA",type:"chat",entityType:"",entityId:"",entityData1:"",entityData2:"",entityData3:"",dateCreate:new Date,restrictions:{avatar:true,extend:true,leave:true,leaveOwner:true,rename:true,send:true,userList:true,mute:true,call:true},public:{code:"",link:""}}}},{key:"getGetters",value:function e(){var t=this;return{get:function e(t){return function(e){if(!t.collection[e]){return null}return t.collection[e]}},getByChatId:function e(t){return function(e){e=parseInt(e);for(var i in t.collection){if(!t.collection.hasOwnProperty(i)){continue}if(t.collection[i].chatId===e){return t.collection[i]}}return null}},getBlank:function e(i){return function(e){return t.getElementState()}},getQuoteId:function e(t){return function(e){if(!t.collection[e]){return 0}return t.collection[e].quoteId}},getEditId:function e(t){return function(e){if(!t.collection[e]){return 0}return t.collection[e].editId}},canSaveChat:function e(t){return function(e){if(/^\d+$/.test(e)){e=parseInt(e)}return t.saveChatList.includes(parseInt(e))}},canSaveDialog:function e(t){return function(e){return t.saveDialogList.includes(e.toString())}},isPrivateDialog:function e(t){return function(e){e=e.toString();return t.collection[e.toString()]&&t.collection[e].type==="private"}}}}},{key:"getActions",value:function e(){var t=this;return{set:function e(i,n){if(n instanceof Array){n=n.map((function(e){return Object.assign({},t.validate(Object.assign({},e),{host:i.state.host}),{init:true})}))}else{var a=[];a.push(Object.assign({},t.validate(Object.assign({},n),{host:i.state.host}),{init:true}));n=a}i.commit("set",n)},update:function e(i,n){if(typeof i.state.collection[n.dialogId]==="undefined"||i.state.collection[n.dialogId].init===false){return true}i.commit("update",{dialogId:n.dialogId,fields:t.validate(Object.assign({},n.fields),{host:i.state.host})});return true},delete:function e(t,i){t.commit("delete",i.dialogId);return true},updateWriting:function e(i,n){if(typeof i.state.collection[n.dialogId]==="undefined"||i.state.collection[n.dialogId].init===false){return true}var a=i.state.collection[n.dialogId].writingList.findIndex((function(e){return e.userId===n.userId}));if(n.action){if(a>=0){return true}else{var r=[].concat(i.state.collection[n.dialogId].writingList);r.unshift({userId:n.userId,userName:n.userName});i.commit("update",{actionName:"updateWriting/1",dialogId:n.dialogId,fields:t.validate({writingList:r},{host:i.state.host})})}}else{if(a>=0){var o=i.state.collection[n.dialogId].writingList.filter((function(e){return e.userId!==n.userId}));i.commit("update",{actionName:"updateWriting/2",dialogId:n.dialogId,fields:t.validate({writingList:o},{host:i.state.host})});return true}else{return true}}return false},updateReaded:function e(i,n){if(typeof i.state.collection[n.dialogId]==="undefined"||i.state.collection[n.dialogId].init===false){return true}var a=i.state.collection[n.dialogId].readedList.filter((function(e){return e.userId!==n.userId}));if(n.action){a.push({userId:n.userId,userName:n.userName||"",messageId:n.messageId,date:n.date||new Date})}i.commit("update",{actionName:"updateReaded",dialogId:n.dialogId,fields:t.validate({readedList:a},{host:i.state.host})});return false},increaseCounter:function e(t,i){var n;if(typeof t.state.collection[i.dialogId]==="undefined"||t.state.collection[i.dialogId].init===false){return true}var a=t.state.collection[i.dialogId].counter;if(a===100){return true}var r=a+i.count;if(r>100){r=100}var o=(n=t.rootState.application)===null||n===void 0?void 0:n.common.userId;var s=o&&t.state.collection[i.dialogId].muteList.includes(o);t.commit("update",{actionName:"increaseCounter",dialogId:i.dialogId,dialogMuted:s,fields:{counter:r,previousCounter:a}});return false},decreaseCounter:function e(t,i){if(typeof t.state.collection[i.dialogId]==="undefined"||t.state.collection[i.dialogId].init===false){return true}var n=t.state.collection[i.dialogId].counter;if(n===100){return true}var a=n-i.count;if(a<0){a=0}var r=i.unreadId>t.state.collection[i.dialogId].unreadId?i.unreadId:t.state.collection[i.dialogId].unreadId;if(t.state.collection[i.dialogId].unreadId!==r||t.state.collection[i.dialogId].counter!==a){var o;var s=t.state.collection[i.dialogId].counter;if(a===0){r=0}var l=(o=t.rootState.application)===null||o===void 0?void 0:o.common.userId;var c=l&&t.state.collection[i.dialogId].muteList.includes(l);t.commit("update",{actionName:"decreaseCounter",dialogId:i.dialogId,dialogMuted:c,fields:{counter:a,previousCounter:s,unreadId:r}})}return false},increaseMessageCounter:function e(t,i){if(typeof t.state.collection[i.dialogId]==="undefined"||t.state.collection[i.dialogId].init===false){return true}var n=t.state.collection[i.dialogId].messageCount;t.commit("update",{actionName:"increaseMessageCount",dialogId:i.dialogId,fields:{messageCount:n+i.count}})},saveDialog:function e(t,i){if(typeof t.state.collection[i.dialogId]==="undefined"||t.state.collection[i.dialogId].init===false){return true}t.commit("saveDialog",{dialogId:i.dialogId,chatId:i.chatId});return false}}}},{key:"getMutations",value:function e(){var t=this;return{initCollection:function e(i,n){t.initCollection(i,n)},saveDialog:function e(i,n){if(!(n.chatId>0&&n.dialogId.length>0)){return false}var a=i.saveDialogList.filter((function(e){return e!==n.dialogId}));a.unshift(n.dialogId);a=a.slice(0,s.StorageLimit.dialogues);if(i.saveDialogList.join(",")===a.join(",")){return true}i.saveDialogList=a;var r=i.saveChatList.filter((function(e){return e!==n.chatId}));r.unshift(n.chatId);i.saveChatList=r.slice(0,s.StorageLimit.dialogues);t.saveState(i)},set:function e(i,n){var a=m(n),r;try{for(a.s();!(r=a.n()).done;){var o=r.value;t.initCollection(i,{dialogId:o.dialogId});i.collection[o.dialogId]=Object.assign(t.getElementState(),i.collection[o.dialogId],o)}}catch(e){a.e(e)}finally{a.f()}t.saveState(i)},update:function e(i,n){t.initCollection(i,n);i.collection[n.dialogId]=Object.assign(i.collection[n.dialogId],n.fields);t.saveState(i)},delete:function e(i,n){delete i.collection[n.dialogId];t.saveState(i)}}}},{key:"initCollection",value:function e(t,i){if(typeof t.collection[i.dialogId]!=="undefined"){return true}a.Vue.set(t.collection,i.dialogId,this.getElementState());if(i.fields){t.collection[i.dialogId]=Object.assign(t.collection[i.dialogId],this.validate(Object.assign({},i.fields),{host:t.host}))}return true}},{key:"getSaveTimeout",value:function e(){return 100}},{key:"saveState",value:function e(){var i=this;var n=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};if(!this.isSaveAvailable()){return true}babelHelpers.get(babelHelpers.getPrototypeOf(t.prototype),"saveState",this).call(this,(function(){var e={collection:{},saveDialogList:[].concat(n.saveDialogList),saveChatList:[].concat(n.saveChatList)};n.saveDialogList.forEach((function(t){if(!n.collection[t])return false;e.collection[t]=Object.assign(i.getElementState(),i.cloneState(n.collection[t],i.getElementStateSaveException()))}));return e}))}},{key:"validate",value:function e(t){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var a={};i.host=i.host||this.getState().host;if(typeof t.dialog_id!=="undefined"){t.dialogId=t.dialog_id}if(typeof t.dialogId==="number"||typeof t.dialogId==="string"){a.dialogId=t.dialogId.toString()}if(typeof t.chat_id!=="undefined"){t.chatId=t.chat_id}else if(typeof t.id!=="undefined"){t.chatId=t.id}if(typeof t.chatId==="number"||typeof t.chatId==="string"){a.chatId=parseInt(t.chatId)}if(typeof t.quoteId==="number"){a.quoteId=parseInt(t.quoteId)}if(typeof t.editId==="number"){a.editId=parseInt(t.editId)}if(typeof t.counter==="number"||typeof t.counter==="string"){a.counter=parseInt(t.counter)}if(typeof t.user_counter==="number"||typeof t.user_counter==="string"){a.userCounter=parseInt(t.user_counter)}if(typeof t.userCounter==="number"||typeof t.userCounter==="string"){a.userCounter=parseInt(t.userCounter)}if(typeof t.message_count==="number"||typeof t.message_count==="string"){a.messageCount=parseInt(t.message_count)}if(typeof t.messageCount==="number"||typeof t.messageCount==="string"){a.messageCount=parseInt(t.messageCount)}if(typeof t.unread_id!=="undefined"){t.unreadId=t.unread_id}if(typeof t.unreadId==="number"||typeof t.unreadId==="string"){a.unreadId=parseInt(t.unreadId)}if(typeof t.last_message_id!=="undefined"){t.lastMessageId=t.last_message_id}if(typeof t.lastMessageId==="number"||typeof t.lastMessageId==="string"){a.lastMessageId=parseInt(t.lastMessageId)}if(typeof t.readed_list!=="undefined"){t.readedList=t.readed_list}if(typeof t.readedList!=="undefined"){a.readedList=[];if(t.readedList instanceof Array){t.readedList.forEach((function(e){var t={};if(typeof e.user_id!=="undefined"){e.userId=e.user_id}if(typeof e.user_name!=="undefined"){e.userName=e.user_name}if(typeof e.message_id!=="undefined"){e.messageId=e.message_id}if(!e.userId||!e.userName||!e.messageId){return false}t.userId=parseInt(e.userId);t.userName=e.userName.toString();t.messageId=parseInt(e.messageId);t.date=n.Utils.date.cast(e.date);a.readedList.push(t)}))}}if(typeof t.writing_list!=="undefined"){t.writingList=t.writing_list}if(typeof t.writingList!=="undefined"){a.writingList=[];if(t.writingList instanceof Array){t.writingList.forEach((function(e){var t={};if(!e.userId){return false}t.userId=parseInt(e.userId);t.userName=n.Utils.text.htmlspecialcharsback(e.userName);a.writingList.push(t)}))}}if(typeof t.manager_list!=="undefined"){t.managerList=t.manager_list}if(typeof t.managerList!=="undefined"){a.managerList=[];if(t.managerList instanceof Array){t.managerList.forEach((function(e){e=parseInt(e);if(e>0){a.managerList.push(e)}}))}}if(typeof t.mute_list!=="undefined"){t.muteList=t.mute_list}if(typeof t.muteList!=="undefined"){a.muteList=[];if(t.muteList instanceof Array){t.muteList.forEach((function(e){e=parseInt(e);if(e>0){a.muteList.push(e)}}))}else if(babelHelpers["typeof"](t.muteList)==="object"){Object.entries(t.muteList).forEach((function(e){if(e[1]===true){var t=parseInt(e[0]);if(t>0){a.muteList.push(t)}}}))}}if(typeof t.textareaMessage!=="undefined"){a.textareaMessage=t.textareaMessage.toString()}if(typeof t.title!=="undefined"){t.name=t.title}if(typeof t.name==="string"||typeof t.name==="number"){a.name=n.Utils.text.htmlspecialcharsback(t.name.toString())}if(typeof t.owner!=="undefined"){t.ownerId=t.owner}if(typeof t.ownerId==="number"||typeof t.ownerId==="string"){a.ownerId=parseInt(t.ownerId)}if(typeof t.extranet==="boolean"){a.extranet=t.extranet}if(typeof t.avatar==="string"){var r;if(!t.avatar||t.avatar.endsWith("/js/im/images/blank.gif")){r=""}else if(t.avatar.startsWith("http")){r=t.avatar}else{r=i.host+t.avatar}if(r){a.avatar=encodeURI(r)}}if(typeof t.color==="string"){a.color=t.color.toString()}if(typeof t.type==="string"){a.type=t.type.toString()}if(typeof t.entity_type!=="undefined"){t.entityType=t.entity_type}if(typeof t.entityType==="string"){a.entityType=t.entityType.toString()}if(typeof t.entity_id!=="undefined"){t.entityId=t.entity_id}if(typeof t.entityId==="string"||typeof t.entityId==="number"){a.entityId=t.entityId.toString()}if(typeof t.entity_data_1!=="undefined"){t.entityData1=t.entity_data_1}if(typeof t.entityData1==="string"){a.entityData1=t.entityData1.toString()}if(typeof t.entity_data_2!=="undefined"){t.entityData2=t.entity_data_2}if(typeof t.entityData2==="string"){a.entityData2=t.entityData2.toString()}if(typeof t.entity_data_3!=="undefined"){t.entityData3=t.entity_data_3}if(typeof t.entityData3==="string"){a.entityData3=t.entityData3.toString()}if(typeof t.date_create!=="undefined"){t.dateCreate=t.date_create}if(typeof t.dateCreate!=="undefined"){a.dateCreate=n.Utils.date.cast(t.dateCreate)}if(typeof t.dateLastOpen!=="undefined"){a.dateLastOpen=n.Utils.date.cast(t.dateLastOpen)}if(babelHelpers["typeof"](t.restrictions)==="object"&&t.restrictions){a.restrictions={};if(typeof t.restrictions.avatar==="boolean"){a.restrictions.avatar=t.restrictions.avatar}if(typeof t.restrictions.extend==="boolean"){a.restrictions.extend=t.restrictions.extend}if(typeof t.restrictions.leave==="boolean"){a.restrictions.leave=t.restrictions.leave}if(typeof t.restrictions.leave_owner==="boolean"){a.restrictions.leaveOwner=t.restrictions.leave_owner}if(typeof t.restrictions.rename==="boolean"){a.restrictions.rename=t.restrictions.rename}if(typeof t.restrictions.send==="boolean"){a.restrictions.send=t.restrictions.send}if(typeof t.restrictions.user_list==="boolean"){a.restrictions.userList=t.restrictions.user_list}if(typeof t.restrictions.mute==="boolean"){a.restrictions.mute=t.restrictions.mute}if(typeof t.restrictions.call==="boolean"){a.restrictions.call=t.restrictions.call}}if(babelHelpers["typeof"](t["public"])==="object"&&t["public"]){a["public"]={};if(typeof t["public"].code==="string"){a["public"].code=t["public"].code}if(typeof t["public"].link==="string"){a["public"].link=t["public"].link}}return a}}]);return t}(r.VuexBuilderModel);function b(e,t){var i=typeof Symbol!=="undefined"&&e[Symbol.iterator]||e["@@iterator"];if(!i){if(Array.isArray(e)||(i=I(e))||t&&e&&typeof e.length==="number"){if(i)e=i;var n=0;var a=function e(){};return{s:a,n:function t(){if(n>=e.length)return{done:true};return{done:false,value:e[n++]}},e:function e(t){throw t},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var r=true,o=false,s;return{s:function t(){i=i.call(e)},n:function e(){var t=i.next();r=t.done;return t},e:function e(t){o=true;s=t},f:function e(){try{if(!r&&i["return"]!=null)i["return"]()}finally{if(o)throw s}}}}function I(e,t){if(!e)return;if(typeof e==="string")return S(e,t);var i=Object.prototype.toString.call(e).slice(8,-1);if(i==="Object"&&e.constructor)i=e.constructor.name;if(i==="Map"||i==="Set")return Array.from(e);if(i==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i))return S(e,t)}function S(e,t){if(t==null||t>e.length)t=e.length;for(var i=0,n=new Array(t);i<t;i++)n[i]=e[i];return n}var C=function(e){babelHelpers.inherits(t,e);function t(){babelHelpers.classCallCheck(this,t);return babelHelpers.possibleConstructorReturn(this,babelHelpers.getPrototypeOf(t).apply(this,arguments))}babelHelpers.createClass(t,[{key:"getName",value:function e(){return"users"}},{key:"getState",value:function e(){this.startOnlineCheckInterval();return{host:this.getVariable("host",location.protocol+"//"+location.host),collection:{},onlineList:[],mobileOnlineList:[],absentList:[]}}},{key:"getElementState",value:function e(){var t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var i=t.id,n=i===void 0?0:i,a=t.name,r=a===void 0?this.getVariable("default.name",""):a,o=t.firstName,s=o===void 0?this.getVariable("default.name",""):o,l=t.lastName,c=l===void 0?"":l;return{id:n,name:r,firstName:s,lastName:c,workPosition:"",color:"#048bd0",avatar:"",gender:"M",birthday:false,isBirthday:false,extranet:false,network:false,bot:false,connector:false,externalAuthId:"default",status:"online",idle:false,lastActivityDate:false,mobileLastDate:false,isOnline:false,isMobileOnline:false,absent:false,isAbsent:false,departments:[],phones:{workPhone:"",personalMobile:"",personalPhone:"",innerPhone:""},init:false}}},{key:"getGetters",value:function e(){var t=this;return{get:function e(i){return function(e){var n=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;e=parseInt(e);if(e<=0){if(n){e=0}else{return null}}if(!n&&(!i.collection[e]||!i.collection[e].init)){return null}if(!i.collection[e]){return t.getElementState({id:e})}return i.collection[e]}},getBlank:function e(i){return function(e){return t.getElementState(e)}},getList:function e(i){return function(e){var n=[];if(!Array.isArray(e)){return null}e.forEach((function(e){if(i.collection[e]){n.push(i.collection[e])}else{n.push(t.getElementState({id:e}))}}));return n}}}}},{key:"getActions",value:function e(){var t=this;return{set:function e(i,n){if(n instanceof Array){n=n.map((function(e){return Object.assign({},t.getElementState(),t.validate(Object.assign({},e),{host:i.state.host}),{init:true})}))}else{var a=[];a.push(Object.assign({},t.getElementState(),t.validate(Object.assign({},n),{host:i.state.host}),{init:true}));n=a}i.commit("set",n)},update:function e(i,n){n.id=parseInt(n.id);if(typeof i.state.collection[n.id]==="undefined"||i.state.collection[n.id].init===false){return true}i.commit("update",{id:n.id,fields:t.validate(Object.assign({},n.fields),{host:i.state.host})});return true},delete:function e(t,i){t.commit("delete",i.id);return true},saveState:function e(t,i){t.commit("saveState",{});return true}}}},{key:"getMutations",value:function e(){var t=this;return{set:function e(i,a){var r=b(a),o;try{var s=function e(){var a=o.value;t.initCollection(i,{id:a.id});i.collection[a.id]=Object.assign(i.collection[a.id],a);var r=n.Utils.user.getOnlineStatus(a);if(r.isOnline){i.collection[a.id].isOnline=true;t.addToOnlineList(i,a.id)}var s=n.Utils.user.isMobileActive(a);if(s){i.collection[a.id].isMobileOnline=true;t.addToMobileOnlineList(i,a.id)}if(a.birthday){var l=n.Utils.date.format(new Date,"d-m");if(a.birthday===l){i.collection[a.id].isBirthday=true;var c=t.getTimeToNextMidnight();setTimeout((function(){i.collection[a.id].isBirthday=false}),c)}}if(a.absent){a.isAbsent=true;if(!i.absentList.includes(a.id)){t.addToAbsentList(i,a.id);var u=t.getTimeToNextMidnight();var d=1e3*60*60*24;setTimeout((function(){setInterval((function(){return t.startAbsentCheckInterval(i)}),d)}),u)}}t.saveState(i)};for(r.s();!(o=r.n()).done;){s()}}catch(e){r.e(e)}finally{r.f()}},update:function e(i,a){t.initCollection(i,a);if(typeof a.fields.lastActivityDate!=="undefined"&&i.collection[a.id].lastActivityDate){var r=i.collection[a.id].lastActivityDate.getTime();var o=a.fields.lastActivityDate.getTime();if(o>r){var s=n.Utils.user.getOnlineStatus(a.fields);if(s.isOnline){i.collection[a.id].isOnline=true;t.addToOnlineList(i,a.fields.id)}}}if(typeof a.fields.mobileLastDate!=="undefined"&&i.collection[a.id].mobileLastDate!==a.fields.mobileLastDate){var l=n.Utils.user.isMobileActive(a.fields);if(l){i.collection[a.id].isMobileOnline=true;t.addToMobileOnlineList(i,a.fields.id)}}i.collection[a.id]=Object.assign(i.collection[a.id],a.fields);t.saveState(i)},delete:function e(i,n){delete i.collection[n.id];t.saveState(i)},saveState:function e(i,n){t.saveState(i)}}}},{key:"initCollection",value:function e(t,i){if(typeof t.collection[i.id]!=="undefined"){return true}a.Vue.set(t.collection,i.id,this.getElementState());return true}},{key:"getSaveUserList",value:function e(){if(!this.db){return[]}if(!this.store.getters["messages/getSaveUserList"]){return[]}var t=this.store.getters["messages/getSaveUserList"]();if(!t){return[]}return t}},{key:"getSaveTimeout",value:function e(){return 250}},{key:"saveState",value:function e(i){var n=this;if(!this.isSaveAvailable()){return false}babelHelpers.get(babelHelpers.getPrototypeOf(t.prototype),"saveState",this).call(this,(function(){var e=n.getSaveUserList();if(!e){return false}var t={collection:{}};var a={absent:true,idle:true,mobileLastDate:true,lastActivityDate:true};for(var r in e){if(!e.hasOwnProperty(r)){continue}e[r].forEach((function(e){if(!i.collection[e]){return false}t.collection[e]=n.cloneState(i.collection[e],a)}))}return t}))}},{key:"validate",value:function e(t){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var a={};i.host=i.host||this.getState().host;if(typeof t.id==="number"||typeof t.id==="string"){a.id=parseInt(t.id)}if(typeof t.first_name!=="undefined"){t.firstName=n.Utils.text.htmlspecialcharsback(t.first_name)}if(typeof t.last_name!=="undefined"){t.lastName=n.Utils.text.htmlspecialcharsback(t.last_name)}if(typeof t.name==="string"||typeof t.name==="number"){t.name=n.Utils.text.htmlspecialcharsback(t.name.toString());a.name=t.name}if(typeof t.firstName==="string"||typeof t.firstName==="number"){a.firstName=n.Utils.text.htmlspecialcharsback(t.firstName.toString())}if(typeof t.lastName==="string"||typeof t.lastName==="number"){a.lastName=n.Utils.text.htmlspecialcharsback(t.lastName.toString())}if(typeof t.work_position!=="undefined"){t.workPosition=t.work_position}if(typeof t.workPosition==="string"||typeof t.workPosition==="number"){a.workPosition=t.workPosition.toString()}if(typeof t.color==="string"){a.color=t.color}if(typeof t.avatar==="string"){var r;if(!t.avatar||t.avatar.endsWith("/js/im/images/blank.gif")){r=""}else if(t.avatar.startsWith("http")){r=t.avatar}else{r=i.host+t.avatar}if(r){a.avatar=encodeURI(r)}}if(typeof t.gender!=="undefined"){a.gender=t.gender==="F"?"F":"M"}if(typeof t.birthday==="string"){a.birthday=t.birthday}if(typeof t.extranet==="boolean"){a.extranet=t.extranet}if(typeof t.network==="boolean"){a.network=t.network}if(typeof t.bot==="boolean"){a.bot=t.bot}if(typeof t.connector==="boolean"){a.connector=t.connector}if(typeof t.external_auth_id!=="undefined"){t.externalAuthId=t.external_auth_id}if(typeof t.externalAuthId==="string"&&t.externalAuthId){a.externalAuthId=t.externalAuthId}if(typeof t.status==="string"){a.status=t.status}if(typeof t.idle!=="undefined"){a.idle=n.Utils.date.cast(t.idle,false)}if(typeof t.last_activity_date!=="undefined"){t.lastActivityDate=t.last_activity_date}if(typeof t.lastActivityDate!=="undefined"){a.lastActivityDate=n.Utils.date.cast(t.lastActivityDate,false)}if(typeof t.mobile_last_date!=="undefined"){t.mobileLastDate=t.mobile_last_date}if(typeof t.mobileLastDate!=="undefined"){a.mobileLastDate=n.Utils.date.cast(t.mobileLastDate,false)}if(typeof t.absent!=="undefined"){a.absent=n.Utils.date.cast(t.absent,false)}if(typeof t.departments!=="undefined"){a.departments=[];if(t.departments instanceof Array){t.departments.forEach((function(e){e=parseInt(e);if(e>0){a.departments.push(e)}}))}}if(babelHelpers["typeof"](t.phones)==="object"&&t.phones){a.phones={};if(typeof t.phones.work_phone!=="undefined"){t.phones.workPhone=t.phones.work_phone}if(typeof t.phones.workPhone==="string"||typeof t.phones.workPhone==="number"){a.phones.workPhone=t.phones.workPhone.toString()}if(typeof t.phones.personal_mobile!=="undefined"){t.phones.personalMobile=t.phones.personal_mobile}if(typeof t.phones.personalMobile==="string"||typeof t.phones.personalMobile==="number"){a.phones.personalMobile=t.phones.personalMobile.toString()}if(typeof t.phones.personal_phone!=="undefined"){t.phones.personalPhone=t.phones.personal_phone}if(typeof t.phones.personalPhone==="string"||typeof t.phones.personalPhone==="number"){a.phones.personalPhone=t.phones.personalPhone.toString()}if(typeof t.phones.inner_phone!=="undefined"){t.phones.innerPhone=t.phones.inner_phone}if(typeof t.phones.innerPhone==="string"||typeof t.phones.innerPhone==="number"){a.phones.innerPhone=t.phones.innerPhone.toString()}}return a}},{key:"addToOnlineList",value:function e(t,i){if(!t.onlineList.includes(i)){t.onlineList.push(i)}}},{key:"addToMobileOnlineList",value:function e(t,i){if(!t.mobileOnlineList.includes(i)){t.mobileOnlineList.push(i)}}},{key:"addToAbsentList",value:function e(t,i){if(!t.absentList.includes(i)){t.absentList.push(i)}}},{key:"getTimeToNextMidnight",value:function e(){var t=new Date((new Date).setHours(24,0,0)).getTime();return t-new Date}},{key:"startAbsentCheckInterval",value:function e(t){var i=b(t.absentList),n;try{var a=function e(){var i=n.value;var a=t.collection[i];if(!a){return"continue"}var r=(new Date).getTime();var o=new Date(t.collection[i].absent).getTime();if(o<=r){t.absentList=t.absentList.filter((function(e){return e!==i}));a.isAbsent=false}};for(i.s();!(n=i.n()).done;){var r=a();if(r==="continue")continue}}catch(e){i.e(e)}finally{i.f()}}},{key:"startOnlineCheckInterval",value:function e(){var t=this;var i=6e4;setInterval((function(){var e=b(t.store.state.users.onlineList),i;try{var a=function e(){var a=i.value;var r=t.store.state.users.collection[a];if(!r){return"continue"}var o=n.Utils.user.getOnlineStatus(r);if(o.isOnline){r.isOnline=true}else{r.isOnline=false;t.store.state.users.onlineList=t.store.state.users.onlineList.filter((function(e){return e!==a}))}};for(e.s();!(i=e.n()).done;){var r=a();if(r==="continue")continue}}catch(t){e.e(t)}finally{e.f()}var o=b(t.store.state.users.mobileOnlineList),s;try{var l=function e(){var i=s.value;var a=t.store.state.users.collection[i];if(!a){return"continue"}var r=n.Utils.user.isMobileActive(a);if(r){a.isMobileOnline=true}else{a.isMobileOnline=false;t.store.state.users.mobileOnlineList=t.store.state.users.mobileOnlineList.filter((function(e){return e!==i}))}};for(o.s();!(s=o.n()).done;){var c=l();if(c==="continue")continue}}catch(e){o.e(e)}finally{o.f()}}),i)}}]);return t}(r.VuexBuilderModel);function T(e,t){var i=typeof Symbol!=="undefined"&&e[Symbol.iterator]||e["@@iterator"];if(!i){if(Array.isArray(e)||(i=x(e))||t&&e&&typeof e.length==="number"){if(i)e=i;var n=0;var a=function e(){};return{s:a,n:function t(){if(n>=e.length)return{done:true};return{done:false,value:e[n++]}},e:function e(t){throw t},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var r=true,o=false,s;return{s:function t(){i=i.call(e)},n:function e(){var t=i.next();r=t.done;return t},e:function e(t){o=true;s=t},f:function e(){try{if(!r&&i["return"]!=null)i["return"]()}finally{if(o)throw s}}}}function x(e,t){if(!e)return;if(typeof e==="string")return k(e,t);var i=Object.prototype.toString.call(e).slice(8,-1);if(i==="Object"&&e.constructor)i=e.constructor.name;if(i==="Map"||i==="Set")return Array.from(e);if(i==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i))return k(e,t)}function k(e,t){if(t==null||t>e.length)t=e.length;for(var i=0,n=new Array(t);i<t;i++)n[i]=e[i];return n}var M=function(e){babelHelpers.inherits(t,e);function t(){babelHelpers.classCallCheck(this,t);return babelHelpers.possibleConstructorReturn(this,babelHelpers.getPrototypeOf(t).apply(this,arguments))}babelHelpers.createClass(t,[{key:"getName",value:function e(){return"files"}},{key:"getState",value:function e(){return{created:0,host:this.getVariable("host",location.protocol+"//"+location.host),collection:{},index:{}}}},{key:"getElementState",value:function e(){var t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};var i=t.id,n=i===void 0?0:i,a=t.chatId,r=a===void 0?0:a,o=t.name,l=o===void 0?this.getVariable("default.name",""):o;return{id:n,chatId:r,name:l,templateId:n,date:new Date,type:"file",extension:"",icon:"empty",size:0,image:false,status:s.FileStatus.done,progress:100,authorId:0,authorName:"",urlPreview:"",urlShow:"",urlDownload:"",init:false,viewerAttrs:{}}}},{key:"getGetters",value:function e(){var t=this;return{get:function e(t){return function(e,i){var n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;if(!e||!i){return null}if(!t.index[e]||!t.index[e][i]){return null}if(!n&&!t.index[e][i].init){return null}return t.index[e][i]}},getList:function e(t){return function(e){if(!t.index[e]){return null}return t.index[e]}},getBlank:function e(i){return function(e){return t.getElementState(e)}}}}},{key:"getActions",value:function e(){var t=this;return{add:function e(i,n){var a=t.validate(Object.assign({},n),{host:i.state.host});if(n.id){a.id=n.id}else{a.id="temporary"+(new Date).getTime()+i.state.created}a.templateId=a.id;a.init=true;i.commit("add",Object.assign({},t.getElementState(),a));return a.id},set:function e(i,n){if(n instanceof Array){n=n.map((function(e){var n=t.validate(Object.assign({},e),{host:i.state.host});n.templateId=n.id;return Object.assign({},t.getElementState(),n,{init:true})}))}else{var a=t.validate(Object.assign({},n),{host:i.state.host});a.templateId=a.id;n=[];n.push(Object.assign({},t.getElementState(),a,{init:true}))}i.commit("set",{insertType:s.MutationType.setAfter,data:n})},setBefore:function e(i,n){if(n instanceof Array){n=n.map((function(e){var n=t.validate(Object.assign({},e),{host:i.state.host});n.templateId=n.id;return Object.assign({},t.getElementState(),n,{init:true})}))}else{var a=t.validate(Object.assign({},n),{host:i.state.host});a.templateId=a.id;n=[];n.push(Object.assign({},t.getElementState(),a,{init:true}))}i.commit("set",{actionName:"setBefore",insertType:s.MutationType.setBefore,data:n})},update:function e(i,n){var a=t.validate(Object.assign({},n.fields),{host:i.state.host});i.commit("initCollection",{chatId:n.chatId});var r=i.state.collection[n.chatId].findIndex((function(e){return e.id===n.id}));if(r<0){return false}i.commit("update",{id:n.id,chatId:n.chatId,index:r,fields:a});if(n.fields.blink){setTimeout((function(){i.commit("update",{id:n.id,chatId:n.chatId,fields:{blink:false}})}),1e3)}return true},delete:function e(t,i){t.commit("delete",{id:i.id,chatId:i.chatId});return true},saveState:function e(t,i){t.commit("saveState",{});return true}}}},{key:"getMutations",value:function e(){var t=this;return{initCollection:function e(i,n){t.initCollection(i,n)},add:function e(i,n){t.initCollection(i,n);i.collection[n.chatId].push(n);i.index[n.chatId][n.id]=n;i.created+=1;t.saveState(i)},set:function e(i,n){var a=T(n.data),r;try{var o=function e(){var a=r.value;t.initCollection(i,{chatId:a.chatId});var o=i.collection[a.chatId].findIndex((function(e){return e.id===a.id}));if(o>-1){delete a.templateId;i.collection[a.chatId][o]=Object.assign(i.collection[a.chatId][o],a)}else if(n.insertType===s.MutationType.setBefore){i.collection[a.chatId].unshift(a)}else{i.collection[a.chatId].push(a)}i.index[a.chatId][a.id]=a;t.saveState(i)};for(a.s();!(r=a.n()).done;){o()}}catch(e){a.e(e)}finally{a.f()}},update:function e(i,n){t.initCollection(i,n);var a=-1;if(typeof n.index!=="undefined"&&i.collection[n.chatId][n.index]){a=n.index}else{a=i.collection[n.chatId].findIndex((function(e){return e.id===n.id}))}if(a>=0){delete n.fields.templateId;var r=Object.assign(i.collection[n.chatId][a],n.fields);i.collection[n.chatId][a]=r;i.index[n.chatId][r.id]=r;t.saveState(i)}},delete:function e(i,n){t.initCollection(i,n);i.collection[n.chatId]=i.collection[n.chatId].filter((function(e){return e.id!==n.id}));delete i.index[n.chatId][n.id];t.saveState(i)},saveState:function e(i,n){t.saveState(i)}}}},{key:"initCollection",value:function e(t,i){if(typeof t.collection[i.chatId]!=="undefined"){return true}a.Vue.set(t.collection,i.chatId,[]);a.Vue.set(t.index,i.chatId,{});return true}},{key:"getLoadedState",value:function e(t){if(!t||babelHelpers["typeof"](t)!=="object"){return t}if(babelHelpers["typeof"](t.collection)!=="object"){return t}t.index={};var i=function e(i){if(!t.collection.hasOwnProperty(i)){return"continue"}t.index[i]={};t.collection[i].filter((function(e){return e!=null})).forEach((function(e){t.index[i][e.id]=e}))};for(var n in t.collection){var a=i(n);if(a==="continue")continue}return t}},{key:"getSaveFileList",value:function e(){if(!this.db){return[]}if(!this.store.getters["messages/getSaveFileList"]){return[]}var t=this.store.getters["messages/getSaveFileList"]();if(!t){return[]}return t}},{key:"getSaveTimeout",value:function e(){return 250}},{key:"saveState",value:function e(i){var n=this;if(!this.isSaveAvailable()){return false}babelHelpers.get(babelHelpers.getPrototypeOf(t.prototype),"saveState",this).call(this,(function(){var e=n.getSaveFileList();if(!e){return false}var t={collection:{}};var a=function n(a){if(!e.hasOwnProperty(a)){return"continue"}e[a].forEach((function(e){if(!i.index[a]){return false}if(!i.index[a][e]){return false}if(!t.collection[a]){t.collection[a]=[]}t.collection[a].push(i.index[a][e])}))};for(var r in e){var o=a(r);if(o==="continue")continue}return t}))}},{key:"validate",value:function e(i){var a=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var r={};a.host=a.host||this.getState().host;if(typeof i.id==="number"){r.id=i.id}else if(typeof i.id==="string"){if(i.id.startsWith("temporary")){r.id=i.id}else{r.id=parseInt(i.id)}}if(typeof i.templateId==="number"){r.templateId=i.templateId}else if(typeof i.templateId==="string"){if(i.templateId.startsWith("temporary")){r.templateId=i.templateId}else{r.templateId=parseInt(i.templateId)}}if(typeof i.chatId==="number"||typeof i.chatId==="string"){r.chatId=parseInt(i.chatId)}if(typeof i.date!=="undefined"){r.date=n.Utils.date.cast(i.date)}if(typeof i.type==="string"){r.type=i.type}if(typeof i.extension==="string"){r.extension=i.extension.toString();if(r.type==="image"){r.icon="img"}else if(r.type==="video"){r.icon="mov"}else{r.icon=t.getIconType(r.extension)}}if(typeof i.name==="string"||typeof i.name==="number"){r.name=i.name.toString()}if(typeof i.size==="number"||typeof i.size==="string"){r.size=parseInt(i.size)}if(typeof i.image==="boolean"){r.image=false}else if(babelHelpers["typeof"](i.image)==="object"&&i.image){r.image={width:0,height:0};if(typeof i.image.width==="string"||typeof i.image.width==="number"){r.image.width=parseInt(i.image.width)}if(typeof i.image.height==="string"||typeof i.image.height==="number"){r.image.height=parseInt(i.image.height)}if(r.image.width<=0||r.image.height<=0){r.image=false}}if(typeof i.status==="string"&&typeof s.FileStatus[i.status]!=="undefined"){r.status=i.status}if(typeof i.progress==="number"||typeof i.progress==="string"){r.progress=parseInt(i.progress)}if(typeof i.authorId==="number"||typeof i.authorId==="string"){r.authorId=parseInt(i.authorId)}if(typeof i.authorName==="string"||typeof i.authorName==="number"){r.authorName=i.authorName.toString()}if(typeof i.urlPreview==="string"){if(!i.urlPreview||i.urlPreview.startsWith("http")||i.urlPreview.startsWith("bx")||i.urlPreview.startsWith("file")||i.urlPreview.startsWith("blob")){r.urlPreview=i.urlPreview}else{r.urlPreview=a.host+i.urlPreview}}if(typeof i.urlDownload==="string"){if(!i.urlDownload||i.urlDownload.startsWith("http")||i.urlDownload.startsWith("bx")||i.urlPreview.startsWith("file")){r.urlDownload=i.urlDownload}else{r.urlDownload=a.host+i.urlDownload}}if(typeof i.urlShow==="string"){if(!i.urlShow||i.urlShow.startsWith("http")||i.urlShow.startsWith("bx")||i.urlShow.startsWith("file")){r.urlShow=i.urlShow}else{r.urlShow=a.host+i.urlShow}}if(babelHelpers["typeof"](i.viewerAttrs)==="object"){if(r.type==="image"&&!n.Utils.platform.isBitrixMobile()){r.viewerAttrs=i.viewerAttrs}if(r.type==="video"&&!n.Utils.platform.isBitrixMobile()&&r.size>t.maxDiskFileSize){r.viewerAttrs=i.viewerAttrs}}return r}}],[{key:"getType",value:function e(t){t=t.toString().toLowerCase().split(".").splice(-1)[0];switch(t){case"png":case"jpe":case"jpg":case"jpeg":case"gif":case"heic":case"bmp":case"webp":return s.FileType.image;case"mp4":case"mkv":case"webm":case"mpeg":case"hevc":case"avi":case"3gp":case"flv":case"m4v":case"ogg":case"wmv":case"mov":return s.FileType.video;case"mp3":return s.FileType.audio}return s.FileType.file}},{key:"getIconType",value:function e(t){var i="empty";switch(t.toString()){case"png":case"jpe":case"jpg":case"jpeg":case"gif":case"heic":case"bmp":case"webp":i="img";break;case"mp4":case"mkv":case"webm":case"mpeg":case"hevc":case"avi":case"3gp":case"flv":case"m4v":case"ogg":case"wmv":case"mov":i="mov";break;case"txt":i="txt";break;case"doc":case"docx":i="doc";break;case"xls":case"xlsx":i="xls";break;case"php":i="php";break;case"pdf":i="pdf";break;case"ppt":case"pptx":i="ppt";break;case"rar":i="rar";break;case"zip":case"7z":case"tar":case"gz":case"gzip":i="zip";break;case"set":i="set";break;case"conf":case"ini":case"plist":i="set";break}return i}}]);return t}(r.VuexBuilderModel);babelHelpers.defineProperty(M,"maxDiskFileSize",5242880);
/**
	 * Bitrix Messenger
	 * Recent model (Vuex Builder model)
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2020 Bitrix
	 */var w=function(e){babelHelpers.inherits(t,e);function t(){babelHelpers.classCallCheck(this,t);return babelHelpers.possibleConstructorReturn(this,babelHelpers.getPrototypeOf(t).apply(this,arguments))}babelHelpers.createClass(t,[{key:"getName",value:function e(){return"recent"}},{key:"getState",value:function e(){return{host:this.getVariable("host",location.protocol+"//"+location.host),collection:[]}}},{key:"getElementState",value:function e(){return{id:0,templateId:"",template:s.TemplateTypes.item,chatType:s.ChatTypes.chat,sectionCode:s.RecentSection.general,avatar:"",color:"#048bd0",title:"",lines:{id:0,status:0},message:{id:0,text:"",date:new Date,senderId:0,status:s.MessageStatus.received},counter:0,pinned:false,chatId:0,userId:0}}},{key:"getGetters",value:function e(){var t=this;return{get:function e(i){return function(e){if(o.Type.isNumber(e)){e=e.toString()}var i=t.findItem(e);if(i){return i}return false}}}}},{key:"getActions",value:function e(){var t=this;return{set:function e(i,n){var a=[];if(n instanceof Array){a=n.map((function(e){return t.prepareItem(e,{host:i.state.host})}))}if(a.length===0){return false}a.forEach((function(e){var n=t.findItem(e.id);if(n){i.commit("update",{index:n.index,fields:e})}else{i.commit("add",{fields:e})}}));i.state.collection.sort(t.sortListByMessageDate)},addPlaceholders:function e(t,i){i.forEach((function(e){t.commit("addPlaceholder",{fields:e})}))},updatePlaceholders:function e(i,n){n.items=n.items.map((function(e){return t.prepareItem(e)}));n.items.forEach((function(e,a){var r="placeholder"+(n.firstMessage+a);var o=t.findItem(r,"templateId");var s=t.findItem(e.id);if(s){i.commit("update",{index:s.index,fields:e});i.commit("delete",{index:o.index})}else{i.commit("update",{index:o.index,fields:e})}}))},update:function e(i,n){if(typeof n.id==="string"&&!n.id.startsWith("chat")&&n.id!=="notify"){n.id=parseInt(n.id)}var a=t.findItem(n.id);if(!a){return false}n.fields=t.validate(Object.assign({},n.fields));i.commit("update",{index:a.index,fields:n.fields});i.state.collection.sort(t.sortListByMessageDate)},pin:function e(i,n){if(typeof n.id==="string"&&!n.id.startsWith("chat")&&n.id!=="notify"){n.id=parseInt(n.id)}var a=t.findItem(n.id);if(!a){return false}i.commit("update",{index:a.index,fields:Object.assign({},a.element,{pinned:n.action})});i.state.collection.sort(t.sortListByMessageDate)},clearPlaceholders:function e(t){t.commit("clearPlaceholders")},delete:function e(i,n){if(typeof n.id==="string"&&!n.id.startsWith("chat")&&n.id!=="notify"){n.id=parseInt(n.id)}var a=t.findItem(n.id);if(!a){return false}i.commit("delete",{index:a.index});i.state.collection.sort(t.sortListByMessageDate)}}}},{key:"getMutations",value:function e(){var t=this;return{add:function e(i,n){i.collection.push(Object.assign({},t.getElementState(),n.fields))},update:function e(t,i){t.collection.splice(i.index,1,Object.assign({},t.collection[i.index],i.fields))},delete:function e(t,i){t.collection.splice(i.index,1)},addPlaceholder:function e(i,n){i.collection.push(Object.assign({},t.getElementState(),n.fields))},clearPlaceholders:function e(t){t.collection=t.collection.filter((function(e){return!e.id.toString().startsWith("placeholder")}))}}}},{key:"validate",value:function e(t){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var a={};if(o.Type.isNumber(t.id)){a.id=t.id.toString()}if(o.Type.isStringFilled(t.id)){a.id=t.id}if(o.Type.isString(t.templateId)){a.templateId=t.templateId}if(o.Type.isString(t.template)){a.template=t.template}if(o.Type.isString(t.type)){if(t.type===s.ChatTypes.chat){if(t.chat.type===s.ChatTypes.open){a.chatType=s.ChatTypes.open}else if(t.chat.type===s.ChatTypes.chat){a.chatType=s.ChatTypes.chat}}else if(t.type===s.ChatTypes.user){a.chatType=s.ChatTypes.user}else if(t.type===s.ChatTypes.notification){a.chatType=s.ChatTypes.notification;t.title="Notifications"}else{a.chatType=s.ChatTypes.chat}}if(o.Type.isString(t.avatar)){var r;if(!t.avatar||t.avatar.endsWith("/js/im/images/blank.gif")){r=""}else if(t.avatar.startsWith("http")){r=t.avatar}else{r=i.host+t.avatar}if(r){a.avatar=encodeURI(r)}}if(o.Type.isString(t.color)){a.color=t.color}if(o.Type.isString(t.title)){a.title=t.title}if(o.Type.isPlainObject(t.message)){var l={};if(o.Type.isNumber(t.message.id)){l.id=t.message.id}if(o.Type.isString(t.message.text)){var c={};if(t.message.withAttach){c.WITH_ATTACH=true}else if(t.message.withFile){c.WITH_FILE=true}l.text=n.Utils.text.purify(t.message.text,c)}if(o.Type.isDate(t.message.date)||o.Type.isString(t.message.date)){l.date=t.message.date}if(o.Type.isNumber(t.message.author_id)){l.senderId=t.message.author_id}if(o.Type.isNumber(t.message.senderId)){l.senderId=t.message.senderId}if(o.Type.isStringFilled(t.message.status)){l.status=t.message.status}a.message=l}if(o.Type.isNumber(t.counter)){a.counter=t.counter}if(o.Type.isBoolean(t.pinned)){a.pinned=t.pinned}if(o.Type.isNumber(t.chatId)){a.chatId=t.chatId}if(o.Type.isNumber(t.userId)){a.userId=t.userId}return a}},{key:"sortListByMessageDate",value:function e(t,i){if(t.message&&i.message){var n=new Date(t.message.date).getTime();var a=new Date(i.message.date).getTime();return a-n}}},{key:"prepareItem",value:function e(t){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var n=this.validate(Object.assign({},t));return Object.assign({},this.getElementState(),n,i)}},{key:"findItem",value:function e(t){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"id";var n={};if(i==="id"&&o.Type.isNumber(t)){t=t.toString()}var a=this.store.state.recent.collection.findIndex((function(e,n){return e[i]===t}));if(a!==-1){n.index=a;n.element=this.store.state.recent.collection[a];return n}return false}}]);return t}(r.VuexBuilderModel);function L(e,t){var i=typeof Symbol!=="undefined"&&e[Symbol.iterator]||e["@@iterator"];if(!i){if(Array.isArray(e)||(i=E(e))||t&&e&&typeof e.length==="number"){if(i)e=i;var n=0;var a=function e(){};return{s:a,n:function t(){if(n>=e.length)return{done:true};return{done:false,value:e[n++]}},e:function e(t){throw t},f:a}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var r=true,o=false,s;return{s:function t(){i=i.call(e)},n:function e(){var t=i.next();r=t.done;return t},e:function e(t){o=true;s=t},f:function e(){try{if(!r&&i["return"]!=null)i["return"]()}finally{if(o)throw s}}}}function E(e,t){if(!e)return;if(typeof e==="string")return A(e,t);var i=Object.prototype.toString.call(e).slice(8,-1);if(i==="Object"&&e.constructor)i=e.constructor.name;if(i==="Map"||i==="Set")return Array.from(e);if(i==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i))return A(e,t)}function A(e,t){if(t==null||t>e.length)t=e.length;for(var i=0,n=new Array(t);i<t;i++)n[i]=e[i];return n}var O=function(e){babelHelpers.inherits(t,e);function t(){babelHelpers.classCallCheck(this,t);return babelHelpers.possibleConstructorReturn(this,babelHelpers.getPrototypeOf(t).apply(this,arguments))}babelHelpers.createClass(t,[{key:"getName",value:function e(){return"notifications"}},{key:"getState",value:function e(){return{collection:[],searchCollection:[],chat_id:0,total:0,host:this.getVariable("host",location.protocol+"//"+location.host),unreadCounter:0,schema:{}}}},{key:"getElementState",value:function e(){return{id:0,authorId:0,date:new Date,text:"",sectionCode:s.NotificationTypesCodes.simple,textConverted:"",title:"",unread:false,display:true,settingName:"im|default"}}},{key:"getGetters",value:function e(){var t=this;return{get:function e(t){return function(){return t.collection}},getById:function e(i){return function(e){if(o.Type.isString(e)){e=parseInt(e)}var n=t.findItemInArr(i.collection,e);if(!n.element){return false}return n.element}},getSearchItemById:function e(i){return function(e){if(o.Type.isString(e)){e=parseInt(e)}var n=t.findItemInArr(i.searchCollection,e);if(!n.element){return false}return n.element}},getBlank:function e(i){return function(e){return t.getElementState()}}}}},{key:"getActions",value:function e(){var t=this;return{set:function e(i,n){var a={notification:[]};if(n.notification instanceof Array){a.notification=n.notification.map((function(e){return t.prepareNotification(e,{host:i.state.host})}))}if(o.Type.isNumber(n.total)||o.Type.isString(n.total)){a.total=parseInt(n.total)}i.commit("set",a)},setSearchResults:function e(i,n){var a={notification:[]};if(!(n.notification instanceof Array)){return false}if(n.type==="local"){a.notification=n.notification}else{a.notification=n.notification.map((function(e){return t.prepareNotification(e,{host:i.state.host})}))}i.commit("setSearchResults",{data:a})},deleteSearchResults:function e(t,i){t.commit("deleteSearchResults")},setCounter:function e(t,i){if(o.Type.isNumber(i.unreadTotal)||o.Type.isString(i.unreadTotal)){var n=parseInt(i.unreadTotal);t.commit("setCounter",n)}},setTotal:function e(t,i){if(o.Type.isNumber(i.total)||o.Type.isString(i.total)){t.commit("setTotal",i.total)}},add:function e(i,n){var a=t.prepareNotification(n.data,{host:i.state.host});a.unread=true;var r=t.findItemInArr(i.state.collection,a.id);if(!r.element){i.commit("add",{data:a});i.commit("setTotal",i.state.total+1)}else{i.commit("update",{index:r.index,fields:Object.assign({},n.fields)})}},updatePlaceholders:function e(i,n){if(n.items instanceof Array){n.items=n.items.map((function(e){return t.prepareNotification(e)}))}else{return false}i.commit("updatePlaceholders",n);return true},clearPlaceholders:function e(t,i){t.commit("clearPlaceholders",i)},update:function e(i,n){var a=t.findItemInArr(i.state.collection,n.id);if(a.element){i.commit("update",{index:a.index,fields:Object.assign({},n.fields)})}if(n.searchMode){var r=t.findItemInArr(i.state.searchCollection,n.id);if(r.element){i.commit("update",{searchCollection:true,index:r.index,fields:Object.assign({},n.fields)})}}},read:function e(i,n){var a=L(n.ids),r;try{for(a.s();!(r=a.n()).done;){var o=r.value;var s=t.findItemInArr(i.state.collection,o);if(!s.element){return false}i.commit("read",{index:s.index,action:!n.action})}}catch(e){a.e(e)}finally{a.f()}},readAll:function e(t,i){t.commit("readAll")},delete:function e(i,n){var a=t.findItemInArr(i.state.collection,n.id);if(a.element){i.commit("delete",{searchCollection:false,index:a.index});i.commit("setTotal",i.state.total-1)}if(n.searchMode){var r=t.findItemInArr(i.state.searchCollection,n.id);if(r.element){i.commit("delete",{searchCollection:true,index:r.index})}}},deleteAll:function e(t,i){t.commit("deleteAll")},setSchema:function e(t,i){t.commit("setSchema",{data:i.data})}}}},{key:"getMutations",value:function e(){var t=this;return{set:function e(i,n){i.total=n.hasOwnProperty("total")?n.total:i.total;if(!n.hasOwnProperty("notification")||!o.Type.isArray(n.notification)){return}var a=L(n.notification),r;try{for(a.s();!(r=a.n()).done;){var s=r.value;var l=t.findItemInArr(i.collection,s.id);if(!l.element){i.collection.push(s)}else{if(s.unread!==i.collection[l.index].unread){s.unread=i.collection[l.index].unread;i.unreadCounter=s.unread===true?i.unreadCounter+1:i.unreadCounter-1}i.collection[l.index]=Object.assign(i.collection[l.index],s)}}}catch(e){a.e(e)}finally{a.f()}i.collection.sort(t.sortByType)},setSearchResults:function e(i,n){var a=L(n.data.notification),r;try{for(a.s();!(r=a.n()).done;){var o=r.value;var s=t.findItemInArr(i.searchCollection,o.id);if(!s.element){i.searchCollection.push(o)}else{i.searchCollection[s.index]=Object.assign(i.searchCollection[s.index],o)}}}catch(e){a.e(e)}finally{a.f()}},deleteAll:function e(t,i){t.collection=[]},deleteSearchResults:function e(t,i){t.searchCollection=[]},add:function e(i,n){var a=null;if(n.data.sectionCode===s.NotificationTypesCodes.confirm){i.collection.unshift(n.data)}else{for(var r=0;i.collection.length>r;r++){if(i.collection[r].sectionCode===s.NotificationTypesCodes.simple){a=r;break}}if(a===null){i.collection.push(n.data)}else{i.collection.splice(a,0,n.data)}}i.collection.sort(t.sortByType)},update:function e(t,i){var n=i.searchCollection?"searchCollection":"collection";a.Vue.set(t[n],i.index,Object.assign({},t[n][i.index],i.fields))},delete:function e(t,i){var n=i.searchCollection?"searchCollection":"collection";t[n].splice(i.index,1)},read:function e(t,i){t.collection[i.index].unread=i.action},readAll:function e(t,i){for(var n=0;t.collection.length>n;n++){t.collection[n].unread=false}},updatePlaceholders:function e(i,n){var a=n.searchCollection?"searchCollection":"collection";n.items.forEach((function(e,t){var r="placeholder".concat(n.firstItem+t);var o=i[a].findIndex((function(e){return e.id===r}));var s=i[a].findIndex((function(t){return t.id===e.id}));if(s>=0){i[a][s]=Object.assign(i[a][s],e);i[a].splice(o,1)}else{i[a].splice(o,1,Object.assign({},e))}}));i[a].sort(t.sortByType)},clearPlaceholders:function e(t,i){t.collection=t.collection.filter((function(e){return!e.id.toString().startsWith("placeholder")}));t.searchCollection=t.searchCollection.filter((function(e){return!e.id.toString().startsWith("placeholder")}))},setCounter:function e(t,i){t.unreadCounter=i},setTotal:function e(t,i){t.total=i},setSchema:function e(t,i){t.schema=i.data}}}},{key:"validate",value:function e(i,a){var r={};if(o.Type.isString(i.id)||o.Type.isNumber(i.id)){r.id=i.id}if(!o.Type.isNil(i.date)){r.date=n.Utils.date.cast(i.date)}if(o.Type.isString(i.text)||o.Type.isNumber(i.text)){r.text=i.text.toString();r.textConverted=t.decodeText(r.text)}if(o.Type.isNumber(i.author_id)){if(i.system===true||i.system==="Y"){r.authorId=0}else{r.authorId=i.author_id}}if(o.Type.isNumber(i.userId)){r.authorId=i.userId}if(o.Type.isObjectLike(i.params)){var l=this.validateParams(i.params);if(l){r.params=l}}if(!o.Type.isNil(i.notify_buttons)){r.notifyButtons=JSON.parse(i.notify_buttons)}if(!o.Type.isNil(i.buttons)){r.notifyButtons=i.buttons.map((function(e){return{COMMAND:"notifyConfirm",COMMAND_PARAMS:"".concat(r.id,"|").concat(e.VALUE),TEXT:"".concat(e.TITLE),TYPE:"BUTTON",DISPLAY:"LINE",BG_COLOR:e.VALUE==="Y"?"#8bc84b":"#ef4b57",TEXT_COLOR:"#fff"}}))}if(i.notify_type===s.NotificationTypesCodes.confirm||i.type===s.NotificationTypesCodes.confirm){r.sectionCode=s.NotificationTypesCodes.confirm}else if(i.type===s.NotificationTypesCodes.placeholder){r.sectionCode=s.NotificationTypesCodes.placeholder}if(!o.Type.isNil(i.notify_read)){r.unread=i.notify_read==="N"}if(!o.Type.isNil(i.read)){r.unread=i.read==="N"}if(o.Type.isString(i.setting_name)){r.settingName=i.setting_name}if(o.Type.isString(i.notify_title)&&i.notify_title.length>0){r.title=i.notify_title}if(o.Type.isString(i.title)&&i.title.length>0){r.title=i.title}return r}},{key:"validateParams",value:function e(t){var i={};try{for(var a in t){if(!t.hasOwnProperty(a)){continue}if(a==="COMPONENT_ID"){if(o.Type.isString(t[a])&&BX.Vue.isComponent(t[a])){i[a]=t[a]}}else if(a==="LIKE"){if(t[a]instanceof Array){i["REACTION"]={like:t[a].map((function(e){return parseInt(e)}))}}}else if(a==="CHAT_LAST_DATE"){i[a]=n.Utils.date.cast(t[a])}else if(a==="AVATAR"){if(t[a]){i[a]=t[a].startsWith("http")?t[a]:options.host+t[a]}}else if(a==="NAME"){if(t[a]){i[a]=t[a]}}else{i[a]=t[a]}}}catch(e){}var r=false;for(var s in i){if(!i.hasOwnProperty(s)){continue}r=true;break}return r?i:null}},{key:"prepareNotification",value:function e(t){var i=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var n=this.validate(Object.assign({},t));return Object.assign({},this.getElementState(),n,i)}},{key:"findItemInArr",value:function e(t,i){var n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:"id";var a={};var r=t.findIndex((function(e,t){return e[n]===i}));if(r!==-1){a.index=r;a.element=t[r]}return a}},{key:"sortByType",value:function e(t,i){if(t.sectionCode===s.NotificationTypesCodes.confirm&&i.sectionCode!==s.NotificationTypesCodes.confirm){return-1}else if(t.sectionCode!==s.NotificationTypesCodes.confirm&&i.sectionCode===s.NotificationTypesCodes.confirm){return 1}else{return i.id-t.id}}}],[{key:"decodeText",value:function e(t){t=o.Text.decode(t.toString());t=n.Utils.text.decode(t,{skipImages:true});var i=o.Reflection.getClass("BX.Messenger.v2.Lib.Parser");if(i){t=i.decodeSmileForLegacyCore(t,{enableBigSmile:false})}if(!n.Utils.platform.isBitrixDesktop()){t=t.replace(/<a(.*?)>(.*?)<\/a>/gi,(function(e,t,i){return"<a ".concat(t.replace('target="_blank"','target="_self"'),' class="bx-im-notifications-item-link">').concat(i,"</a>")}))}return t}}]);return t}(r.VuexBuilderModel);
/**
	 * Bitrix Messenger
	 * Call Application model (Vuex Builder model)
	 *
	 * @package bitrix
	 * @subpackage im
	 * @copyright 2001-2020 Bitrix
	 */var _=function(e){babelHelpers.inherits(t,e);function t(){babelHelpers.classCallCheck(this,t);return babelHelpers.possibleConstructorReturn(this,babelHelpers.getPrototypeOf(t).apply(this,arguments))}babelHelpers.createClass(t,[{key:"getName",value:function e(){return"call"}},{key:"getState",value:function e(){return{users:{}}}},{key:"getElementState",value:function e(){var t=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};return{id:t.id?t.id:0,state:s.ConferenceUserState.Idle,talking:false,pinned:false,cameraState:false,microphoneState:false,screenState:false,floorRequestState:false}}},{key:"getGetters",value:function e(){var t=this;return{getUser:function e(i){return function(e){e=parseInt(e,10);if(!i.users[e]){return t.getElementState({id:e})}return i.users[e]}},getBlankUser:function e(i){return function(e){e=parseInt(e,10);return t.getElementState({id:e})}}}}},{key:"getActions",value:function e(){var t=this;return{updateUser:function e(i,n){n.id=parseInt(n.id,10);n.fields=Object.assign({},t.validate(n.fields));i.commit("updateUser",n)},unpinUser:function e(t,i){t.commit("unpinUser")}}}},{key:"getMutations",value:function e(){var t=this;return{updateUser:function e(i,n){if(!i.users[n.id]){a.Vue.set(i.users,n.id,Object.assign(t.getElementState(),n.fields,{id:n.id}))}else{i.users[n.id]=Object.assign(i.users[n.id],n.fields)}},unpinUser:function e(t,i){var n=Object.values(t.users).find((function(e){return e.pinned===true}));if(n){t.users[n.id].pinned=false}}}}},{key:"validate",value:function e(t){var i={};if(o.Type.isNumber(t.id)||o.Type.isString(t.id)){i.id=parseInt(t.id,10)}if(s.ConferenceUserState[t.state]){i.state=t.state}if(o.Type.isBoolean(t.talking)){i.talking=t.talking}if(o.Type.isBoolean(t.pinned)){i.pinned=t.pinned}if(o.Type.isBoolean(t.cameraState)){i.cameraState=t.cameraState}if(o.Type.isBoolean(t.microphoneState)){i.microphoneState=t.microphoneState}if(o.Type.isBoolean(t.screenState)){i.screenState=t.screenState}if(o.Type.isBoolean(t.floorRequestState)){i.floorRequestState=t.floorRequestState}return i}},{key:"getStateSaveException",value:function e(){return{users:false}}}]);return t}(r.VuexBuilderModel);e.ApplicationModel=l;e.ConferenceModel=c;e.MessagesModel=h;e.DialoguesModel=v;e.UsersModel=C;e.FilesModel=M;e.RecentModel=w;e.NotificationsModel=O;e.CallModel=_})(this.BX.Messenger.Model=this.BX.Messenger.Model||{},BX.Messenger.Lib,BX.Event,BX.Messenger.Lib,BX,BX,BX,BX.Messenger.Const);
//# sourceMappingURL=registry.bundle.map.js