(function(){BX.namespace("BX.Call");var e=null;var t={invite:"im.bitrix.im.controller.call.invite",cancel:"im.bitrix.im.controller.call.cancel",answer:"im.bitrix.im.controller.call.answer",decline:"im.bitrix.im.controller.call.decline",hangup:"im.bitrix.im.controller.call.hangup",ping:"im.bitrix.im.controller.call.ping"};BX.Call.JanusCall=function(e){this.superclass.constructor.apply(this,arguments);this.roomId=1234;this.server="https://janus.perevozov.bx:8089/janus";this.apiSecret="";this.isJanusInited=false;this.isJanusConnected=false;this.publishers={main:null,screen:null};this.signaling=new BX.Call.JanusCall.Signaling({call:this});this.peers={};this.initPeers()};BX.extend(BX.Call.JanusCall,BX.Call.AbstractCall);BX.Call.JanusCall.prototype.initPeers=function(){var e=this;for(var t=0;t<this.users.length;t++){var n=this.users[t];if(n==this.userId)continue;this.peers[n]=new BX.Call.JanusCall.Peer({userId:n,roomId:this.roomId,onStreamReceived:function(t){console.log("onStreamReceived: ",t);e.runCallback("onStreamReceived",t)},onStreamRemoved:function(t){console.log("onStreamRemoved: ",t);e.runCallback("onStreamRemoved",t)},onStateChanged:this.__onPeerStateChanged.bind(this)})}};BX.Call.JanusCall.prototype.inviteUsers=function(e){var t=this;var n=BX.type.isArray(e)?e:this.users;this.initJanus().then(this.connect.bind(this)).then(this.publishStream.bind(this)).then(function(){t.signaling.inviteUsers({userIds:n})}).catch(function(e){console.error("xxx: ",e)})};BX.Call.JanusCall.prototype.answer=function(){var e=this;this.initJanus().then(this.connect.bind(this)).then(this.publishStream.bind(this)).then(function(){e.signaling.sendAnswer()})};BX.Call.JanusCall.prototype.decline=function(){this.signaling.sendDecline();this.destroy()};BX.Call.JanusCall.prototype.hangup=function(){for(var e in this.publishers){if(this.publishers[e]){this.publishers[e].destroy()}}this.signaling.sendHangup()};BX.Call.JanusCall.prototype.publishStream=function(e){var t=new BX.Promise;if(!e){e="main"}if(!this.isJanusConnected){return t.reject(new Error("Janus is not connected"))}if(!this.localStreams[e]){return t.reject(new Error("Stream "+e+" is not set"))}if(this.publishers[e]){throw new Error("Publisher for tag "+e+" already exists")}this.publishers[e]=new BX.Call.JanusCall.Publisher({userId:this.userId,tag:e,stream:this.localStreams[e],roomId:this.roomId,onPublished:function(e){if(t.state===null){t.resolve()}},onPublishersUpdated:this._onPublishersUpdated.bind(this),onDestroyed:this._onPublisherDestroyed.bind(this),onError:function(e){console.error("Janus error: ",e)}});return t};BX.Call.JanusCall.prototype.initJanus=function(){var e=this;var t=new BX.Promise;if(this.isJanusInited){t.resolve();return t}Janus.init({debug:"all",callback:function(){e.isJanusInited=true;t.resolve()}});return t};BX.Call.JanusCall.prototype.connect=function(){var t=this;var n=new BX.Promise;if(this.isJanusConnected){return n.resolve()}if(!this.isJanusInited){return n.reject(new Error("Janus is not initialized"))}e=new Janus({server:this.server,apisecret:this.apiSecret,success:function(){t.isJanusConnected=true;n.resolve()},error:function(e){n.reject(e)},destroyed:function(){t.destroy()}});return n};BX.Call.JanusCall.prototype._onPublishersUpdated=function(e){console.log("_onPublishersUpdated: ",e);if(!BX.type.isArray(e)){return}for(var t=0;t<e.length;t++){var n=e[t];if(!BX.type.isNotEmptyString(n.display)||n.display.substr(0,4)!=="user"){continue}var i=parseInt(n.display.substr(4));if(!this.peers[i]){continue}this.peers[i].attachFeed("main",n.id)}};BX.Call.JanusCall.prototype._onPublisherDestroyed=function(e){console.log("_onPublisherDestroyed",e)};BX.Call.JanusCall.prototype.__onPeerStateChanged=function(e){this.runCallback("onUserStateChanged",e);if(e.state==BX.Call.UserState.Failed){if(!this.isAnyoneParticipating()){this.destroy()}}};BX.Call.JanusCall.prototype.isAnyoneParticipating=function(){for(var e in this.peers){if(this.peers[e].isParticipating()){return true}}return false};BX.Call.JanusCall.prototype.destroy=function(){for(var e in this.peers){if(this.peers[e]){this.peers[e].destroy();this.peers[e]=null}}for(var t in this.publishers){if(this.publishers[t]){this.publishers[t].destroy();this.publishers[t]=null}}};BX.Call.JanusCall.Publisher=function(e){this.mediaState={video:null,audio:null};this.webrtcState=null;this.callbacks={onAttached:BX.type.isFunction(e.onAttached)?e.onAttached:BX.DoNothing,onDetached:BX.type.isFunction(e.onDetached)?e.onDetached:BX.DoNothing,onRoomJoined:BX.type.isFunction(e.onRoomJoined)?e.onRoomJoined:BX.DoNothing,onRoomLeft:BX.type.isFunction(e.onRoomLeft)?e.onRoomLeft:BX.DoNothing,onPublished:BX.type.isFunction(e.onPublished)?e.onPublished:BX.DoNothing,onError:BX.type.isFunction(e.onError)?e.onError:BX.DoNothing,onPublishersUpdated:BX.type.isFunction(e.onPublishersUpdated)?e.onPublishersUpdated:BX.DoNothing,onDestroyed:BX.type.isFunction(e.onDestroyed)?e.onDestroyed:BX.DoNothing,onPublisherLeft:BX.type.isFunction(e.onPublisherLeft)?e.onPublisherLeft:BX.DoNothing,onWebrtcState:BX.type.isFunction(e.onWebrtcState)?e.onWebrtcState:BX.DoNothing};this.userId=e.userId;this.tag=e.tag;this.pluginHandle=null;this.localStream=e.stream;this.roomId=e.roomId;this.init()};BX.Call.JanusCall.Publisher.prototype.init=function(){this.attach()};BX.Call.JanusCall.Publisher.prototype.attach=function(){var t=this;e.attach({plugin:"janus.plugin.videoroom",success:this.onAttached.bind(this),error:this.onError.bind(this),consentDialog:BX.DoNothing,webrtcState:function(e){console.log("Publisher webrtcState:",e);t.webrtcState=e},mediaState:function(e,n){console.log("Publisher mediaState:",e,n);if(t.mediaState.hasOwnProperty(e)){t.mediaState[e]=n}if(n){t.callbacks.onPublished({target:t,media:e,state:n})}},onmessage:this.onMessage.bind(this),onlocalstream:BX.DoNothing,onremotestream:BX.DoNothing,oncleanup:BX.DoNothing,ondetached:function(){console.log("Publisher detached")}})};BX.Call.JanusCall.Publisher.prototype.onAttached=function(e){this.pluginHandle=e;console.log("Plugin attached! ("+e.getPlugin()+", id="+e.getId()+")");console.log("  -- This is a publisher/manager");return this.joinRoom()};BX.Call.JanusCall.Publisher.prototype.onError=function(e){console.error("Janus publisher error: ",e);this.callbacks.onError({target:this,errorCode:0,error:e})};BX.Call.JanusCall.Publisher.prototype.joinRoom=function(){var e=this;var t=new BX.Promise;var n={request:"join",room:this.roomId,ptype:"publisher",display:"user"+e.userId};this.pluginHandle.send({message:n,success:function(e){t.resolve(e)},error:function(e){t.reject(e)}});return t};BX.Call.JanusCall.Publisher.prototype.publishStream=function(){var e=this;this.pluginHandle.createOffer({media:{audioRecv:false,videoRecv:false,audioSend:true,videoSend:true},stream:e.localStream,success:function(t){console.debug("Got publisher SDP!");console.debug(t);var n={request:"configure",audio:true,video:true};e.pluginHandle.send({message:n,jsep:t})},error:function(e){console.error("WebRTC error:",e)}})};BX.Call.JanusCall.Publisher.prototype.unpublishStream=function(){var e={request:"unpublish"};this.pluginHandle.send({message:e})};BX.Call.JanusCall.Publisher.prototype.changeStream=function(e){var t=this;var n=new BX.Promise;t.pluginHandle.hangup();setTimeout(function(){t.localStream=e;t.publishStream();n.resolve()},1e3);return n};BX.Call.JanusCall.Publisher.prototype.onMessage=function(e,t){console.log("Received message:",e);var n=e["videoroom"];if(n==="event"){if(e["leaving"]!==undefined&&e["leaving"]!==null){n="leving"}else if(e["unpublished"]!==undefined&&e["unpublished"]!==null){n="unpublished"}else if(e["error"]!==undefined&&e["error"]!==null){n="error"}}var i={joined:this.onMessageJoinedRoom.bind(this),destroyed:this.onMessageRoomDestroyed.bind(this),leaving:this.onMessagePublisherLeaving.bind(this),unpublished:this.onMessagePublisherLeft.bind(this),error:this.onMessageError.bind(this)};if(i[n]){i[n].call(this,e)}if(e["publishers"]!==undefined&&e["publishers"]!==null){this.callbacks.onPublishersUpdated(e["publishers"])}if(t!==undefined&&t!==null){Janus.debug("Handling SDP as well...");Janus.debug(t);this.pluginHandle.handleRemoteJsep({jsep:t})}};BX.Call.JanusCall.Publisher.prototype.onMessageJoinedRoom=function(e){myid=e["id"];console.log("Successfully joined room "+e["room"]+" with ID "+myid);if(this.localStream){this.publishStream()}};BX.Call.JanusCall.Publisher.prototype.onMessageRoomDestroyed=function(e){console.log("The room has been destroyed!");this.destroy()};BX.Call.JanusCall.Publisher.prototype.onMessagePublisherLeaving=function(e){this.callbacks.onPublisherLeft(e["leaving"])};BX.Call.JanusCall.Publisher.prototype.onMessagePublisherLeft=function(e){var t=e["unpublished"];Janus.log("Publisher left: "+t);if(t==="ok"){this.pluginHandle.hangup()}else{this.callbacks.onPublisherLeft(e["unpublished"])}};BX.Call.JanusCall.Publisher.prototype.onMessageError=function(e){this.callbacks.onError({target:this,errorCode:e["error_code"],error:e["error"]})};BX.Call.JanusCall.Publisher.prototype.destroy=function(){if(this.pluginHandle){this.pluginHandle.hangup();this.pluginHandle.detach()}this.pluginHandle=null;this.localStream=null;this.callbacks.onDestroyed()};BX.Call.JanusCall.Peer=function(e){this.userId=e.userId;this.roomId=e.roomId;this.signalingConnected=false;this.ready=false;this.declined=false;this.calculatedState=BX.Call.UserState.Idle;this.feeds={main:null,screen:null};this.callbacks={onStreamReceived:BX.type.isFunction(e.onStreamReceived)?e.onStreamReceived:BX.DoNothing,onStreamRemoved:BX.type.isFunction(e.onStreamRemoved)?e.onStreamRemoved:BX.DoNothing,onStateChanged:BX.type.isFunction(e.onStateChanged)?e.onStateChanged:BX.DoNothing}};BX.Call.JanusCall.Peer.prototype.attachFeed=function(e,t){if(this.feeds[e]){throw new Error("Already attached to the feed "+e)}this.feeds[e]=new BX.Call.JanusCall.Feed({roomId:this.roomId,userId:this.userId,tag:e,feedId:t,onStreamReceived:this._onStreamReceived.bind(this),onStreamRemoved:this._onStreamRemoved.bind(this)})};BX.Call.JanusCall.Peer.prototype.updateCalculatedState=function(){var e=this.calculateState();if(this.calculatedState!=e){this.callbacks.onStateChanged({userId:this.userId,state:e,previousState:this.calculatedState});this.calculatedState=e}};BX.Call.JanusCall.Peer.prototype.calculateState=function(){if(!this.signalingConnected)return BX.Call.UserState.Failed;if(!this.ready)return BX.Call.UserState.Calling;if(this.declined)return BX.Call.UserState.Declined;var e=[];for(var t in this.feeds){if(this.feeds[t]){e.push(this.feeds[t])}}if(e.length===0)return BX.Call.UserState.Ready;for(var n=0;n<e.length;n++){if(e[n].webrtcState==="???"){return BX.Call.UserState.Connected}}return BX.Call.UserState.Connecting};BX.Call.JanusCall.Peer.prototype.isParticipating=function(){if(this.failed)return false;if(this.declined)return false;for(var e in this.feeds){if(this.feeds[e]){var t=this.feeds[e].webrtcState;if(t=="???"){return true}}}return false};BX.Call.JanusCall.Peer.prototype._onStreamReceived=function(e){this.callbacks.onStreamReceived({userId:this.userId,connectionTag:e.tag,stream:e.stream})};BX.Call.JanusCall.Peer.prototype._onStreamRemoved=function(e){this.callbacks.onStreamRemoved({userId:this.userId,connectionTag:e.tag})};BX.Call.JanusCall.Peer.prototype.destroy=function(){for(var e in this.feeds){if(this.feeds[e]){this.feeds[e].destroy();this.feeds[e]=null}}};BX.Call.JanusCall.Feed=function(e){this.userId=e.userId;this.tag=e.tag;this.feedId=e.feedId;this.roomId=e.roomId;this.webrtcState=null;this.pluginHandle=null;this.stream=null;this.callbacks={onStreamReceived:BX.type.isFunction(e.onStreamReceived)?e.onStreamReceived:BX.DoNothing,onStreamRemoved:BX.type.isFunction(e.onStreamRemoved)?e.onStreamRemoved:BX.DoNothing};this.attach()};BX.Call.JanusCall.Feed.prototype.attach=function(){var t=this;e.attach({plugin:"janus.plugin.videoroom",success:this.onAttached.bind(this),error:this.onError.bind(this),webrtcState:function(e){t.webrtcState=e},onmessage:this.onMessage.bind(this),onlocalstream:BX.DoNothing,onremotestream:this.onRemoteStream.bind(this),oncleanup:BX.DoNothing})};BX.Call.JanusCall.Feed.prototype.onAttached=function(e){console.log("feed attached");this.pluginHandle=e;this.joinRoom()};BX.Call.JanusCall.Feed.prototype.onMessage=function(e,t){var n=this;Janus.debug(" ::: Got a message (listener) :::");Janus.debug(JSON.stringify(e));var i=e["videoroom"];Janus.debug("Event: "+i);if(i!=undefined&&i!=null){if(i==="attached"){console.log("Successfully attached to feed ",e)}else if(e["error"]!==undefined&&e["error"]!==null){console.log("Receiver error: ",e["error"])}else{console.log("Empty message from media gateway")}}if(t!==undefined&&t!==null){Janus.debug("Handling SDP as well...");Janus.debug(t);this.pluginHandle.createAnswer({jsep:t,media:{audioRecv:true,videoRecv:true,audioSend:false,videoSend:false},success:function(e){Janus.debug("Got SDP!");Janus.debug(e);var t={request:"start",room:this.roomId};n.pluginHandle.send({message:t,jsep:e})},error:function(e){console.log("WebRTC error:",e)}})}};BX.Call.JanusCall.Feed.prototype.onRemoteStream=function(e){this.stream=e;console.log("remote stream received");var t={target:this,stream:e};this.callbacks.onStreamReceived(t)};BX.Call.JanusCall.Feed.prototype.onError=function(e){console.log("Receiver error: ",e)};BX.Call.JanusCall.Feed.prototype.joinRoom=function(){console.log("feed: ",this.feedId);var e={request:"join",room:this.roomId,ptype:"listener",feed:this.feedId};this.pluginHandle.send({message:e})};BX.Call.JanusCall.Feed.prototype.destroy=function(){this.stream=null;if(this.pluginHandle){this.pluginHandle.hangup();this.pluginHandle.detach()}};BX.Call.JanusCall.Signaling=function(e){this.call=e.call};BX.Call.JanusCall.Signaling.prototype.inviteUsers=function(e){return this.__runAjaxAction(t.invite,e)};BX.Call.JanusCall.Signaling.prototype.sendAnswer=function(e){return this.__runAjaxAction(t.answer,e)};BX.Call.JanusCall.Signaling.prototype.sendHangup=function(e){return this.__runAjaxAction(t.hangup,e)};BX.Call.JanusCall.Signaling.prototype.__runAjaxAction=function(e,t){if(!BX.type.isPlainObject(t)){t={}}t.callId=this.call.id;t.callInstanceId=this.call.instanceId;t.requestId=BX.CallEngine.getUuidv4();return BX.ajax.runAction(e,{data:t})}})();
//# sourceMappingURL=janus_call.map.js