
CREATE TABLE b_controller_group (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  NAME varchar(255) NOT NULL,
  UPDATE_PERIOD int NOT NULL DEFAULT -1,
  DISABLE_DEACTIVATED char(1) NOT NULL DEFAULT 'N',
  DESCRIPTION text,
  MODIFIED_BY int,
  DATE_CREATE timestamp NOT NULL,
  CREATED_BY int,
  INSTALL_INFO text,
  UNINSTALL_INFO text,
  INSTALL_PHP text,
  UNINSTALL_PHP text,
  TRIAL_PERIOD int,
  COUNTER_UPDATE_PERIOD int,
  CHECK_COUNTER_FREE_SPACE char(1),
  CHECK_COUNTER_SITES char(1),
  CHECK_COUNTER_USERS char(1),
  CHECK_COUNTER_LAST_AUTH char(1),
  PRIMARY KEY (ID)
);
ALTER TABLE b_controller_group ALTER COLUMN ID RESTART WITH 2;

CREATE TABLE b_controller_member (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MEMBER_ID varchar(32) NOT NULL,
  SECRET_ID varchar(32) NOT NULL,
  NAME varchar(255) NOT NULL,
  URL varchar(255) NOT NULL,
  HOSTNAME varchar(255),
  EMAIL varchar(255),
  CONTACT_PERSON varchar(255),
  CONTROLLER_GROUP_ID int NOT NULL,
  DISCONNECTED char(1) NOT NULL DEFAULT 'N',
  SHARED_KERNEL char(1) NOT NULL DEFAULT 'N',
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  DATE_ACTIVE_FROM timestamp,
  DATE_ACTIVE_TO timestamp,
  SITE_ACTIVE char(1) NOT NULL DEFAULT 'Y',
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  MODIFIED_BY int,
  DATE_CREATE timestamp NOT NULL,
  CREATED_BY int,
  IN_GROUP_FROM timestamp,
  NOTES text,
  COUNTER_FREE_SPACE double precision,
  COUNTER_SITES int,
  COUNTER_USERS int,
  COUNTER_LAST_AUTH timestamp,
  COUNTERS_UPDATED timestamp,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_controller_member_member_id ON b_controller_member (member_id);
CREATE INDEX ix_b_controller_member_active_controller_group_id ON b_controller_member (active, controller_group_id);

CREATE TABLE b_controller_member_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CONTROLLER_MEMBER_ID int NOT NULL,
  USER_ID int NOT NULL,
  CREATED_DATE timestamp NOT NULL,
  FIELD varchar(50) NOT NULL,
  FROM_VALUE text,
  TO_VALUE text,
  NOTES text,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_controller_member_log_controller_member_id_field_created_d ON b_controller_member_log (controller_member_id, field, created_date);

CREATE TABLE b_controller_task (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  DATE_CREATE timestamp NOT NULL,
  TASK_ID varchar(50) NOT NULL,
  CONTROLLER_MEMBER_ID int NOT NULL,
  DATE_EXECUTE timestamp,
  INIT_EXECUTE text,
  INIT_EXECUTE_PARAMS text,
  INIT_CRC int NOT NULL DEFAULT 0,
  UPDATE_PERIOD int NOT NULL DEFAULT 0,
  RESULT_EXECUTE text,
  STATUS char(1) NOT NULL DEFAULT 'N',
  INDEX_SALT int NOT NULL DEFAULT 0,
  RETRY_COUNT int NOT NULL DEFAULT 0,
  RETRY_TIMEOUT int NOT NULL DEFAULT 0,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_controller_task_date_execute ON b_controller_task (date_execute);
CREATE UNIQUE INDEX ux_b_controller_task_controller_member_id_task_id_date_execute_ ON b_controller_task (controller_member_id, task_id, date_execute, init_crc, index_salt);
CREATE INDEX ix_b_controller_task_status ON b_controller_task (status);

CREATE TABLE b_controller_command (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  MEMBER_ID varchar(32) NOT NULL,
  COMMAND_ID varchar(32) NOT NULL,
  DATE_INSERT timestamp NOT NULL,
  COMMAND text NOT NULL,
  DATE_EXEC timestamp,
  TASK_ID int,
  ADD_PARAMS text,
  PRIMARY KEY (ID)
);
CREATE UNIQUE INDEX ux_b_controller_command_member_id_command_id ON b_controller_command (member_id, command_id);

CREATE TABLE b_controller_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  CONTROLLER_MEMBER_ID int NOT NULL,
  NAME varchar(255) NOT NULL,
  DESCRIPTION text,
  TASK_ID int,
  USER_ID int,
  STATUS char(1) NOT NULL DEFAULT 'Y',
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_controller_log_controller_member_id ON b_controller_log (controller_member_id);
CREATE INDEX ix_b_controller_log_task_id ON b_controller_log (task_id);

CREATE TABLE b_controller_counter (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  COUNTER_TYPE char(1) NOT NULL DEFAULT 'F',
  COUNTER_FORMAT char(1),
  NAME varchar(255) NOT NULL,
  COMMAND text NOT NULL,
  PRIMARY KEY (ID)
);

CREATE TABLE b_controller_counter_group (
  CONTROLLER_GROUP_ID int NOT NULL,
  CONTROLLER_COUNTER_ID int NOT NULL
);
CREATE UNIQUE INDEX ux_b_controller_counter_group_controller_group_id_controller_co ON b_controller_counter_group (controller_group_id, controller_counter_id);
CREATE UNIQUE INDEX ux_b_controller_counter_group_controller_counter_id_controller_ ON b_controller_counter_group (controller_counter_id, controller_group_id);

CREATE TABLE b_controller_counter_history (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  COUNTER_ID int,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  USER_ID int,
  NAME varchar(255) NOT NULL,
  COMMAND_FROM text NOT NULL,
  COMMAND_TO text NOT NULL,
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_controller_counter_history_counter_id ON b_controller_counter_history (counter_id);

CREATE TABLE b_controller_counter_value (
  CONTROLLER_MEMBER_ID int NOT NULL,
  CONTROLLER_COUNTER_ID int NOT NULL,
  VALUE_INT int,
  VALUE_FLOAT double precision,
  VALUE_DATE timestamp,
  VALUE_STRING varchar(255),
  PRIMARY KEY (CONTROLLER_MEMBER_ID, CONTROLLER_COUNTER_ID)
);
CREATE UNIQUE INDEX ux_b_controller_counter_value_controller_counter_id_controller_ ON b_controller_counter_value (controller_counter_id, controller_member_id);

CREATE TABLE b_controller_group_map (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  CONTROLLER_GROUP_ID int,
  REMOTE_GROUP_CODE varchar(30),
  LOCAL_GROUP_CODE varchar(30),
  PRIMARY KEY (ID)
);

CREATE TABLE b_controller_auth_log (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  FROM_CONTROLLER_MEMBER_ID int,
  TO_CONTROLLER_MEMBER_ID int,
  TYPE varchar(50),
  STATUS char(1) NOT NULL DEFAULT 'Y',
  USER_ID int,
  USER_NAME varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_controller_auth_log_timestamp_x ON b_controller_auth_log (timestamp_x);
CREATE INDEX ix_b_controller_auth_log_from_controller_member_id ON b_controller_auth_log (from_controller_member_id);
CREATE INDEX ix_b_controller_auth_log_to_controller_member_id ON b_controller_auth_log (to_controller_member_id);

CREATE TABLE b_controller_auth_grant (
  ID int GENERATED BY DEFAULT AS IDENTITY NOT NULL,
  TIMESTAMP_X timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  GRANTED_BY int NOT NULL,
  CONTROLLER_MEMBER_ID int NOT NULL,
  GRANTEE_USER_ID int,
  GRANTEE_GROUP_ID int,
  ACTIVE char(1) NOT NULL DEFAULT 'Y',
  SCOPE varchar(20) NOT NULL,
  DATE_START timestamp,
  DATE_END timestamp,
  NOTE varchar(255),
  PRIMARY KEY (ID)
);
CREATE INDEX ix_b_controller_auth_grant_controller_member_id ON b_controller_auth_grant (controller_member_id);
