(function(){"use strict";BX.namespace("BX.Calendar.UserField");function e(e){this.params=e;this.timeFrom=e.timeFrom||7;this.timeTo=e.timeTo||20;this.scale=parseInt(e.field.settings_data.time.scale)||60;this.inputName=e.field.name+"[]";this.DATE_FORMAT=BX.date.convertBitrixFormat(BX.message("FORMAT_DATE"));this.DATETIME_FORMAT=BX.date.convertBitrixFormat(BX.message("FORMAT_DATETIME"));this.loadedDates=[];this.accessibility={user:{},resource:{}};this.busySlotMatrix={user:{},resource:{}};this.DOM={wrap:this.params.wrap,valueInputs:[]}}BX.Calendar.UserField.CrmFormResourceBookingFieldLiveController=e;e.prototype={init:function(){this.DOM.outerWrap=this.DOM.wrap.appendChild(BX.create("div",{props:{className:"calendar-resbook-webform-wrapper"}}));this.showMainLoader();this.requireFormData().then(BX.delegate(function(){this.hideMainLoader();this.buildFormControls();this.onChangeValues()},this))},check:function(){var e=true;if(this.usersDisplayed()&&!this.getSelectedUser()){this.userControl.showWarning();e=false}if(e&&this.resourcesDisplayed()&&!this.getSelectedResources()){this.resourceControl.showWarning();e=false}if(e&&!this.getCurrentDuration()){if(this.durationControl){this.durationControl.showWarning()}else if(this.serviceControl){this.serviceControl.showWarning()}e=false}if(e&&!this.dateControl.getValue()){this.dateControl.showWarning();e=false}if(e&&this.timeSelectorDisplayed()&&!this.timeControl.getValue()){this.timeControl.showWarning();e=false}return e},buildFormControls:function(){this.DOM.innerWrap=this.DOM.outerWrap.appendChild(BX.create("div",{props:{className:"calendar-resbook-webform-inner"}}));this.DOM.inputsWrap=this.DOM.innerWrap.appendChild(BX.create("div"));if(!this.getFieldParams()){this.statusControl=new BX.Calendar.UserField.ResourceBookingStatusControl({outerWrap:this.DOM.innerWrap});this.statusControl.refresh({});this.statusControl.setError("[UF_NOT_FOUND] "+BX.message("WEBF_RES_BOOKING_UF_WARNING"))}else{this.preparaAutoSelectValues();this.displayUsersControl();this.displayResourcesControl();this.displayServicesControl();this.displayDurationControl();this.displayDateTimeControl();if(this.selectedUserId||this.selectedResourceId){this.refreshControlsState()}}},refreshControlsState:function(){if(this.selectorCanBeShown("resources")&&this.resourceControl&&!this.resourceControl.isShown()){this.resourceControl.display()}if(this.selectorCanBeShown("services")&&this.serviceControl&&!this.serviceControl.isShown()){this.serviceControl.display()}if(this.selectorCanBeShown("duration")&&this.durationControl&&!this.durationControl.isShown()){this.durationControl.display()}var e=this.getSettingsData();if(this.selectorCanBeShown("date")&&this.dateControl){if(!this.dateControl.isShown()){var t;if(e.date.start==="free"){t=this.getFreeDate({resources:this.getSelectedResources(),user:this.getSelectedUser(),duration:this.getCurrentDuration()})}else{t=new Date}this.dateControl.display({selectedValue:t,availableDateIndex:this.getAvailableDateIndex({resources:this.getSelectedResources(),user:this.getSelectedUser(),duration:this.getCurrentDuration()})})}else{this.dateControl.refresh(e.date,{availableDateIndex:this.getAvailableDateIndex({resources:this.getSelectedResources(),user:this.getSelectedUser(),duration:this.getCurrentDuration()})});if(this.timeControl){this.timeControl.refresh(e.time,{slotIndex:this.getSlotIndex({date:this.dateControl.getValue()}),currentDate:this.dateControl.getValue()})}}}this.updateStatusControl();this.onChangeValues();BX.onCustomEvent(window,"crmWebFormFireResize")},onChangeValues:function(){var e="",t="",s=this.getCurrentDate(),i=this.getCurrentDuration()*60,r=this.getCurrentServiceName(),a=[];BX.cleanNode(this.DOM.inputsWrap);this.DOM.valueInputs=[];if(BX.type.isDate(s)){var o=this.getSelectedResources();if(BX.type.isArray(o)){o.forEach(function(e){a=a.concat({type:"resource",id:e})})}var n=this.getSelectedUser();if(n){a=a.concat({type:"user",id:n})}t=BX.date.format(this.DATETIME_FORMAT,s.getTime()/1e3);a.forEach(function(s){var a=s.type+"|"+s.id+"|"+t+"|"+i+"|"+r;e+=a+"#";this.DOM.valueInputs.push(this.DOM.inputsWrap.appendChild(BX.create("INPUT",{attrs:{name:this.inputName,value:a,type:"hidden"}})))},this)}if(!a.length){this.DOM.valueInputs.push(this.DOM.inputsWrap.appendChild(BX.create("INPUT",{attrs:{name:this.inputName,value:"empty",type:"hidden"}})))}},showMainLoader:function(){if(this.DOM.wrap){this.hideMainLoader();this.DOM.mainLoader=this.DOM.outerWrap.appendChild(BX.create("div",{props:{className:"calendar-resbook-webform-wrapper-loader-wrap"},children:[BX.Calendar.UserField.ResourceBooking.getLoader(160)]}))}},hideMainLoader:function(){BX.remove(this.DOM.mainLoader)},showStatusLoader:function(){if(this.DOM.wrap){this.hideMainLoader();this.DOM.mainLoader=this.DOM.outerWrap.appendChild(BX.create("div",{props:{className:"calendar-resbook-webform-wrapper-loader-wrap"},children:[BX.Calendar.UserField.ResourceBooking.getLoader(160)]}))}},hideStatusLoader:function(){BX.remove(this.DOM.mainLoader)},requestAccessibilityData:function(e){if(!this.requestedFormData){this.showStatusLoader();this.requestedFormData=true;var t={from:e.date};this.requireFormData(t).then(BX.delegate(function(){this.hideStatusLoader();this.refreshControlsState();this.dateControl.refreshCurrentValue();this.onChangeValues();this.requestedFormData=false},this))}},requireFormData:function(e){e=e||{};var t={settingsData:this.getSettingsData()||null},s=new BX.Promise;if(!this.userFieldParams){t.fieldName=this.params.field.entity_field_name}var i=BX.type.isDate(e.from)?e.from:new Date,r;if(BX.type.isDate(e.to)){r=e.to}else{r=new Date(i.getTime());r.setDate(i.getDate()+60)}t.from=BX.date.format(this.DATE_FORMAT,i);t.to=BX.date.format(this.DATE_FORMAT,r);this.setLoadedDataLimits(i,r);BX.ajax.runAction("calendar.api.resourcebookingajax.getfillformdata",{data:t}).then(BX.delegate(function(e){if(BX.type.isNumber(e.data.timezoneOffset)){this.timezoneOffset=e.data.timezoneOffset;this.timezoneOffsetLabel=e.data.timezoneOffsetLabel}if(e.data.workTimeStart!==undefined&&e.data.workTimeEnd!==undefined){this.timeFrom=parseInt(e.data.workTimeStart);this.timeTo=parseInt(e.data.workTimeEnd)}if(e.data.fieldSettings){this.userFieldParams=e.data.fieldSettings}if(e.data.userIndex){this.userIndex=e.data.userIndex}this.handleAccessibilityData(e.data.usersAccessibility,"user");this.handleAccessibilityData(e.data.resourcesAccessibility,"resource");s.fulfill(e.data)},this),function(e){});return s},setLoadedDataLimits:function(e,t){this.loadedDataFrom=BX.type.isDate(e)?e:BX.parseDate(e);this.loadedDataTo=BX.type.isDate(t)?t:BX.parseDate(t);this.loadedDates=this.loadedDates||[];this.loadedDatesIndex=this.loadedDatesIndex||{};var s,i=new Date(this.loadedDataFrom.getTime());while(true){s=BX.date.format(this.DATE_FORMAT,i);this.loadedDatesIndex[s]=this.loadedDates.length;this.loadedDates.push({key:BX.date.format(this.DATE_FORMAT,i),slots:{},slotsCount:{}});i.setDate(i.getDate()+1);if(i.getTime()>this.loadedDataTo.getTime()){break}}},fillDataIndex:function(e,t,s,i){var r=this.loadedDatesIndex[e];if(this.loadedDates[r]){if(!this.loadedDates[r].slots[t]){this.loadedDates[r].slots[t]={}}if(this.loadedDates[r].slotsCount[s+i]===undefined){this.loadedDates[r].slotsCount[s+i]=0}this.loadedDates[r].slots[t][s+i]=true;this.loadedDates[r].slotsCount[s+i]++}},handleAccessibilityData:function(e,t){if(BX.type.isPlainObject(e)&&(t==="user"||t==="resource")){for(var s in e){if(e.hasOwnProperty(s)){e[s].forEach(function(e){if(!e.from){e.from=BX.parseDate(e.dateFrom);if(e.from){e.from.setSeconds(0,0);e.fromTimestamp=e.from.getTime()}}if(!e.to){e.to=BX.parseDate(e.dateTo);if(e.to){if(e.fullDay){e.to.setHours(23,59,0,0)}else{e.to.setSeconds(0,0)}e.toTimestamp=e.to.getTime()}}if(e.from&&e.to){this.fillBusySlotMatrix(e,t,s)}},this)}}this.accessibility[t]=BX.mergeEx(this.accessibility[t],e)}},fillBusySlotMatrix:function(e,t,s){if(!this.busySlotMatrix[t][s]){this.busySlotMatrix[t][s]={}}var i=new Date(e.from.getTime()),r=BX.date.format(this.DATE_FORMAT,i),a=BX.date.format(this.DATE_FORMAT,e.to),o=i.getHours()*60+i.getMinutes(),n=Math.round((e.toTimestamp-e.fromTimestamp)/6e4),l=o+n,u=this.getTimeSlots(),h=0,d;if(n>0){while(true){if(!this.busySlotMatrix[t][s][r]){this.busySlotMatrix[t][s][r]={}}for(d=0;d<u.length;d++){if(o<u[d].time+this.scale&&l>u[d].time){this.busySlotMatrix[t][s][r][u[d].time]=true;this.fillDataIndex(r,u[d].time,t,s)}}if(r===a){break}else{i.setDate(i.getDate()+1);r=BX.date.format(this.DATE_FORMAT,i);o=0;if(r===a){l=e.to.getHours()*60+e.to.getMinutes()}else{l=1440}}h++;if(h>1e4){break}}}},getCaption:function(){return this.params.field.caption},getSettingsData:function(){return this.params.field.settings_data},getUserIndex:function(){return this.userIndex},getFieldParams:function(){return this.userFieldParams},getSettings:function(){return{caption:this.getCaption(),data:this.getSettingsData()}},isUserSelectorInAutoMode:function(){return this.usersDisplayed()&&this.getSettingsData().users.show==="N"},isResourceSelectorInAutoMode:function(){return this.resourcesDisplayed()&&this.getSettingsData().resources.show==="N"},autoAdjustUserSelector:function(){var e=this.dateControl.getValue(),t=this.timeControl.getValue();if(BX.type.isDate(e)&&t){var s,i=this.loadedDates[this.loadedDatesIndex[BX.date.format(this.DATE_FORMAT,e)]];if(i.slots[t]){for(s=0;s<this.userControl.values.length;s++){if(!i.slots[t]["user"+this.userControl.values[s]]){this.userControl.setSelectedUser(this.userControl.values[s]);break}}}}},autoAdjustResourceSelector:function(){var e=this.dateControl.getValue(),t=this.timeControl.getValue();if(BX.type.isDate(e)&&t){var s,i,r=this.loadedDates[this.loadedDatesIndex[BX.date.format(this.DATE_FORMAT,e)]];if(r.slots[t]){for(s=0;s<this.resourceControl.resourceList.length;s++){i=parseInt(this.resourceControl.resourceList[s].id);if(!r.slots[t]["resource"+i]){this.resourceControl.setSelectedResource(i);break}}}}},preparaAutoSelectValues:function(){var e=this.getSettingsData(),t=this.usersDisplayed()&&(e.users.defaultMode==="auto"||e.users.show==="N"),s=this.resourcesDisplayed()&&(e.resources.defaultMode==="auto"||e.resources.show==="N"),i=e.date.start==="free",r=60,a,o;this.selectedUserId=false;this.selectedResourceId=false;a=new Date;for(o=0;o<=r;o++){this.getFreeEntitiesForDate(a,{autoSelectUser:t,autoSelectResource:s,slotsAmount:this.getDefaultDurationSlotsAmount()});if((this.selectedUserId||!t)&&(this.selectedResourceId||!s)){break}if(!i){break}a.setDate(a.getDate()+1)}},getFreeEntitiesForDate:function(e,t){var s=this.getSettingsData(),i=t.slotsAmount||1,r,a,o;if(t.autoSelectUser){a=BX.type.isArray(s.users.value)?s.users.value:s.users.value.split("|");for(r=0;r<a.length;r++){if(this.checkSlotsForDate(e,i,{user:parseInt(a[r])})){this.selectedUserId=parseInt(a[r]);break}}}if(t.autoSelectResource){o=BX.type.isArray(s.resources.value)?s.resources.value:s.resources.value.split("|");for(r=0;r<o.length;r++){if(this.checkSlotsForDate(e,i,{resources:[parseInt(o[r])],user:this.selectedUserId||null})){this.selectedResourceId=parseInt(o[r]);break}}}},displayUsersControl:function(){if(this.usersDisplayed()){this.userControl=new BX.Calendar.UserField.ViewFormUsersControl({outerWrap:this.DOM.innerWrap,data:this.getSettingsData().users,userIndex:this.getUserIndex(),previewMode:false,autoSelectDefaultValue:this.selectedUserId,changeValueCallback:BX.proxy(function(e){BX.onCustomEvent(this,"CrmFormResourceBookingFieldLiveController:onUserChanged",[e]);this.refreshControlsState()},this)});this.userControl.display()}},displayResourcesControl:function(){var e={},t=[],s=this.getFieldParams(),i=this.getSettingsData();if(this.resourcesDisplayed()){i.resources.value.split("|").forEach(function(s){s=parseInt(s);if(s>0){e[s]=true;t.push(s)}});var r=[];s.SELECTED_RESOURCES.forEach(function(t){t.id=parseInt(t.id);if(e[t.id]){r.push(t)}},this);this.resourceControl=new BX.Calendar.UserField.ViewFormResourcesControl({outerWrap:this.DOM.innerWrap,data:{show:i.resources.show,defaultMode:i.resources.defaultMode,label:i.resources.label,multiple:i.resources.multiple,value:i.resources.value},resourceList:r,autoSelectDefaultValue:this.selectedResourceId,changeValueCallback:BX.proxy(function(){BX.onCustomEvent(this,"CrmFormResourceBookingFieldLiveController:onResourceChanged",[]);this.refreshControlsState()},this)});if(this.selectorCanBeShown("resources")){this.resourceControl.display()}}},displayServicesControl:function(){var e=this.getFieldParams(),t=this.getSettingsData();if(e.USE_SERVICES==="Y"&&t.services.value){var s=BX.type.isArray(t.services.value)?t.services.value:t.services.value.split("|");this.serviceControl=new BX.Calendar.UserField.ViewFormServicesControl({outerWrap:this.DOM.innerWrap,data:t.services,serviceList:e.SERVICE_LIST,selectedValue:BX.type.isArray(s)&&s.length>0?s[0]:null,changeValueCallback:BX.proxy(function(){BX.onCustomEvent(this,"CrmFormResourceBookingFieldLiveController:onServiceChanged",[]);this.refreshControlsState()},this)});if(this.selectorCanBeShown("services")){this.serviceControl.display()}}},displayDurationControl:function(){var e=this.getFieldParams(),t=this.getSettingsData();if(!this.serviceControl){this.durationControl=new BX.Calendar.UserField.ViewFormDurationControl({outerWrap:this.DOM.innerWrap,data:t.duration,fullDay:e.FULL_DAY==="Y",changeValueCallback:BX.proxy(function(){BX.onCustomEvent(this,"CrmFormResourceBookingFieldLiveController:onDurationChanged",[]);this.refreshControlsState()},this)});if(this.selectorCanBeShown("duration")){this.durationControl.display()}}},displayDateTimeControl:function(){var e=null,t=this.getSettingsData(),s=this.getFieldParams();this.dateControl=new BX.Calendar.UserField.DateSelector({outerWrap:this.DOM.innerWrap,data:t.date,previewMode:false,allowOverbooking:s.ALLOW_OVERBOOKING==="Y",changeValueCallback:BX.proxy(this.handleDateChanging,this),requestDataCallback:BX.proxy(this.requestAccessibilityData,this)});if(this.timeSelectorDisplayed()){var i=false;if(s.USE_USER_TIMEZONE==="N"){var r=-(new Date).getTimezoneOffset()*60;if(r!==this.timezoneOffset){i=s.TIMEZONE}}this.timeControl=new BX.Calendar.UserField.TimeSelector({outerWrap:this.DOM.innerWrap,data:t.time,previewMode:false,changeValueCallback:BX.proxy(this.handleSelectedDateTimeChanging,this),timeFrom:this.timeFrom,timeTo:this.timeTo,timezone:i,timezoneOffset:this.timezoneOffset,timezoneOffsetLabel:this.timezoneOffsetLabel})}this.statusControl=new BX.Calendar.UserField.ResourceBookingStatusControl({outerWrap:this.DOM.innerWrap,timezone:i,timezoneOffsetLabel:this.timezoneOffsetLabel});if(this.selectorCanBeShown("date")){this.statusControl.show();if(t.date.start==="free"){e=this.getFreeDate({resources:this.getSelectedResources(),user:this.getSelectedUser(),duration:this.getCurrentDuration()})}this.dateControl.display({selectedValue:e});if(this.timeControl&&!this.timeControl.isShown()){this.timeControl.display()}}else{this.statusControl.hide()}},handleDateChanging:function(e,t){BX.onCustomEvent(this,"CrmFormResourceBookingFieldLiveController:onDateChanged",[]);if(this.timeSelectorDisplayed()){if(t){this.timeControl.show();var s,i=this.getCurrentDate();if(i){s=i.getHours()*60+i.getMinutes()}this.timeControl.refresh(this.getSettingsData().time,{slotIndex:this.getSlotIndex({date:t}),currentDate:t,selectedValue:s})}}else{this.handleSelectedDateTimeChanging(null,true)}this.onChangeValues()},handleSelectedDateTimeChanging:function(e,t){if(t!==false){if(this.updateTimeStatusTimeout){this.updateTimeStatusTimeout=clearTimeout(this.updateTimeStatusTimeout)}this.updateTimeStatusTimeout=setTimeout(BX.proxy(function(){this.handleSelectedDateTimeChanging(e,false)},this),100)}else{if(this.isUserSelectorInAutoMode()){this.autoAdjustUserSelector()}if(this.isResourceSelectorInAutoMode()){this.autoAdjustResourceSelector()}this.updateStatusControl();BX.onCustomEvent(window,"crmWebFormFireResize")}this.onChangeValues()},updateStatusControl:function(){if(this.statusControl&&this.selectorCanBeShown("date")){var e=this.getCurrentDate();if(this.dateControl.isItPastDate(e)){this.statusControl.setError(BX.message("WEBF_RES_BOOKING_PAST_DATE_WARNING"))}else{if(this.timeSelectorDisplayed()){if(this.timeControl.hasAvailableSlots()){var t=this.timeControl.getValue();this.statusControl.refresh({dateFrom:t?e:null,duration:t?this.getCurrentDuration():null,fullDay:false})}else{this.statusControl.hide()}}else{this.statusControl.refresh({dateFrom:this.dateControl.isDateAvailable(e)?e:null,duration:this.getCurrentDuration(),fullDay:true})}}}},getFreeDate:function(e){var t=Math.ceil(e.duration/this.scale),s=null,i=this.loadedDataFrom;while(true){if(this.checkSlotsForDate(i,t,{resources:e.resources,user:e.user})){s=i;break}i.setDate(i.getDate()+1);if(i.getTime()>=this.loadedDataTo.getTime()){break}}return s},getAvailableDateIndex:function(e){var t,s,i={};if(this.timeSelectorDisplayed()){var r=Math.ceil(e.duration/this.scale);this.loadedDates.forEach(function(t){i[t.key]=this.checkSlotsForDate(t.key,r,{resources:e.resources,user:e.user})},this)}else{var a,o,n,l,u=e.user?"user"+e.user:null,h=Math.ceil(e.duration/1440);o=1;for(a=this.loadedDates.length;a--;a>=0){t=true;s=true;n=this.loadedDates[a];if(u){t=!n.slotsCount[u]}if(t&&e.resources&&e.resources.length>0){for(l=0;l<e.resources.length;l++){s=s&&!n.slotsCount["resource"+e.resources[l]];if(!s){break}}}if(t&&s){o++}else{o=0}i[n.key]=t&&s&&h<=o}}return i},getSlotIndex:function(e){if(e.date){e.date=this.dateControl.getValue()}var t={};if(BX.type.isDate(e.date)){if(this.getFieldParams().ALLOW_OVERBOOKING!=="Y"&&(this.isUserSelectorInAutoMode()||this.isResourceSelectorInAutoMode())){var s,i,r,a,o=this.getSettingsData(),n=1,l=0,u=this.getTimeSlots(),h=BX.date.format(this.DATE_FORMAT,e.date),d=this.loadedDates[this.loadedDatesIndex[h]],c=Math.ceil(this.getCurrentDuration()/this.scale);if(this.checkIsTodayDate(h)){var f=new Date;l=f.getHours()*60+f.getMinutes()}u.forEach(function(e){t[e.time]=true},this);if(this.isUserSelectorInAutoMode()){var m=BX.type.isArray(o.users.value)?o.users.value:o.users.value.split("|");for(i=u.length;i--;i>=0){a=u[i].time;s=false;if(l&&a<l){t[a]=false;continue}for(r=0;r<m.length;r++){if(!d.slots[a]||!d.slots[a]["user"+m[r]]){s=true;break}}t[a]=t[a]&&s&&c<=n;n=s?n+1:1}}if(this.isResourceSelectorInAutoMode()){var D=BX.type.isArray(o.resources.value)?o.resources.value:o.resources.value.split("|");for(i=u.length;i--;i>=0){a=u[i].time;s=false;if(l&&a<l){t[a]=false;continue}for(r=0;r<D.length;r++){if(!d.slots[a]||!d.slots[a]["resource"+D[r]]){s=true;break}}t[a]=t[a]&&s&&c<=n;n=s?n+1:1}}}else{t=this.getAvailableSlotIndex({date:e.date||this.dateControl.getValue(),resources:this.getSelectedResources(),user:this.getSelectedUser(),duration:this.getCurrentDuration()})}}return t},getAvailableSlotIndex:function(e){var t,s,i,r,a,o=0,n,l=e.user?"user"+e.user:null,u=Math.ceil(e.duration/this.scale),h,d,c=this.getTimeSlots(),f=this.getFieldParams().ALLOW_OVERBOOKING==="Y",m={};c.forEach(function(e){m[e.time]=true},this);if(BX.type.isDate(e.date)){t=BX.date.format(this.DATE_FORMAT,e.date);s=this.loadedDates[this.loadedDatesIndex[t]];n=1;if(this.checkIsTodayDate(t)){var D=new Date;o=D.getHours()*60+D.getMinutes()}for(i=c.length;i--;i>=0){a=c[i].time;if(o&&a<o){m[a]=false;continue}if(f){m[a]=u<=n;n++}else{h=true;d=true;if(l){h=!s.slots[a]||!s.slots[a][l]}if(e.resources&&e.resources.length>0){for(r=0;r<e.resources.length;r++){d=d&&(!s.slots[a]||!s.slots[a]["resource"+e.resources[r]]);if(!d){break}}}m[a]=h&&d&&u<=n;if(h&&d){n++}else{n=1}}}}return m},checkSlotsForDate:function(e,t,s){var i=true,r=true,a=BX.type.isDate(e)?BX.date.format(this.DATE_FORMAT,e):e;s=s||{};if(this.usersDisplayed()&&s.user){if(this.busySlotMatrix.user[s.user]&&!this.entityHasSlotsForDate({entityType:"user",entityId:s.user,dateKey:a,slotsAmount:t})){i=false}}if(this.resourcesDisplayed()&&i&&BX.type.isArray(s.resources)&&s.resources.length>0){s.resources.forEach(function(e){if(r&&this.busySlotMatrix.resource[e]&&!this.entityHasSlotsForDate({entityType:"resource",entityId:e,dateKey:a,slotsAmount:t})){r=false}},this)}return i&&r},entityHasSlotsForDate:function(e){var t,s,i,r=0,a=false;if(this.busySlotMatrix[e.entityType][e.entityId]&&this.busySlotMatrix[e.entityType][e.entityId][e.dateKey]){t=this.busySlotMatrix[e.entityType][e.entityId][e.dateKey];s=this.getTimeSlots();for(i=0;i<s.length;i++){if(!t[s[i].time]){r++;if(r>=e.slotsAmount){a=true;break}}else{r=0}}}else{a=true}return a},getSelectedResources:function(){var e=null;if(this.resourceControl){e=this.resourceControl.getSelectedValues();if(BX.type.isArray(e)&&!e.length){e=null}}return e},getSelectedUser:function(){var e=null;if(this.userControl){e=this.userControl.getSelectedUser()}return e},getCurrentDuration:function(){var e=null;if(this.durationControl){e=this.durationControl.getSelectedValue()}else if(this.serviceControl){var t=this.serviceControl.getSelectedService(true);if(t&&t.duration){e=parseInt(t.duration)}}return e},getDefaultDurationSlotsAmount:function(){var e=this.getSettingsData(),t=this.getFieldParams(),s,i,r,a=function(e){return BX.translit(e).replace(/[^a-z0-9_]/gi,"_")};if(t.USE_SERVICES==="Y"&&e.services.value){var o=e.services.value.split("|");if(BX.type.isArray(t.SERVICE_LIST)&&BX.type.isArray(o)&&o.length>0){for(i=0;i<t.SERVICE_LIST.length;i++){if(a(t.SERVICE_LIST[i].name)===o[0]){s=parseInt(t.SERVICE_LIST[i].duration);break}}}}else{s=parseInt(e.duration.defaultValue)}r=Math.ceil(s/this.scale);return r},getCurrentServiceName:function(){var e="";if(this.serviceControl){var t=this.serviceControl.getSelectedService(true);if(t&&t.name){e=t.name}}return e},getCurrentDate:function(){var e=null;if(this.dateControl&&this.dateControl.isShown()){e=this.dateControl.getValue();if(this.timeSelectorDisplayed()){var t,s,i=this.timeControl.getValue();if(i){t=Math.floor(i/60);s=i-t*60;e.setHours(t,s,0,0)}}else{e.setHours(0,0,0,0)}}return e},getTimeSlots:function(){if(!this.slots){this.slots=[];var e,t,s,i,r,a,o=0,n=this.timeFrom*60;while(n<this.timeTo*60){s=Math.floor(n/60);i=n-s*60;t=n+this.scale;r=Math.floor(t/60);a=t-r*60;e={time:n};this.slots.push(e);n+=this.scale;o++}}return this.slots},usersDisplayed:function(){if(this.useUsers===undefined){this.useUsers=!!(this.getFieldParams()["USE_USERS"]==="Y"&&this.getSettingsData().users.value)}return this.useUsers},resourcesDisplayed:function(){if(this.useResources===undefined){var e=this.getFieldParams();this.useResources=!!(e.USE_RESOURCES==="Y"&&e.SELECTED_RESOURCES&&this.getSettingsData().resources.value)}return this.useResources},timeSelectorDisplayed:function(){if(this.useTime===undefined){this.useTime=this.getFieldParams().FULL_DAY!=="Y"}return this.useTime},selectorCanBeShown:function(e){var t=false;if(e==="resources"){if(this.resourcesDisplayed()&&!this.usersDisplayed()){t=true}else if(this.usersDisplayed()){t=this.getSelectedUser()}}else if(e==="date"||e==="services"||e==="duration"){if(this.usersDisplayed()&&this.resourcesDisplayed()){t=this.getSelectedUser()&&this.getSelectedResources()}else if(this.usersDisplayed()){t=this.getSelectedUser()}else if(this.resourcesDisplayed()){t=this.getSelectedResources()}}return t},checkIsTodayDate:function(e){if(!this.todayDateKey){var t=new Date;this.todayDateKey=BX.date.format(this.DATE_FORMAT,t)}return this.todayDateKey===e}}})();
//# sourceMappingURL=resourcebooking-webform-live.map.js